/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.BOMExtend2FacadeFactory;
import com.kingdee.eas.mm.basedata.BomException;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.MMBaseStatusEnum;
import com.kingdee.eas.mm.planning.app.mrp.MRPUtil;
import com.kingdee.eas.mm.project.IProjectDictData;
import com.kingdee.eas.mm.project.IProjectFacade;
import com.kingdee.eas.mm.project.ProjectDictDataFactory;
import com.kingdee.eas.mm.project.ProjectDictDataInfo;
import com.kingdee.eas.mm.project.ProjectFacadeFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.mm.project.ProjectTaskCollection;
import com.kingdee.eas.mm.project.ProjectTaskInfo;
import com.kingdee.eas.mm.project.WBSException;
import com.kingdee.eas.mm.project.WBSInfo;
import com.kingdee.eas.mm.project.WBSRulerFactory;
import com.kingdee.eas.mm.project.WBSRulerInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class BOMExpand4WBS {
    private final String cr = "\r\n";
    private boolean isTemplate = false;
    private Context ctx = null;

    public BOMExpand4WBS(Context context, boolean template) {
        this.ctx = context;
        this.isTemplate = template;
    }

    private String createTable() throws BOSException {
        StringBuffer sqlCreateTable = new StringBuffer();
        String expandTablName = null;
        TempTablePool pool = TempTablePool.getInstance((Context)this.ctx);
        sqlCreateTable.append("create table t_temp_bomexpand (").append("\r\n").append("FID varchar(44) not null,").append("\r\n").append("FParentID varchar(44) null,").append("\r\n").append("FMaterialID varchar(44) null,").append("\r\n").append("FUnitID varchar(44) null,").append("\r\n").append("FBaseUnitID varchar(44) null,").append("\r\n").append("FPrec int  not null default 0, ").append("\r\n").append("FUnitQty numeric(21,8) not null default 0,").append("\r\n").append("FscrapQty numeric(21,8) not null default 0,").append("\r\n").append("FScrapRate numeric(21,8) not null default 0,").append("\r\n").append("FScrapRateExpression int null,").append("\r\n").append("FMaterialAttr int  not null default 0,").append("\r\n").append("FLevel int  not null default 0, ").append("\r\n").append("FTrackNumberID varchar(44) null,").append("\r\n").append("FProjectID varchar(44) null ,").append("\r\n").append("FLeadTime numeric(21,8) not null default 0 ,").append("\r\n").append("FProduceLeadTime numeric(21,8) not null default 0 ").append("\r\n").append(")");
        try {
            expandTablName = pool.createTempTable(sqlCreateTable.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return expandTablName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map bomExpand(Map inParam) throws BOSException, EASBizException {
        HashMap<String, Object> hashMap;
        HashMap<String, Object> rusultMap = new HashMap<String, Object>();
        ProjectTaskCollection coll = new ProjectTaskCollection();
        ProjectTaskInfo parent = null;
        if (inParam.get("PARENT") != null) {
            parent = (ProjectTaskInfo)inParam.get("PARENT");
        }
        ProjectInfo project = (ProjectInfo)inParam.get("PROJECT");
        String bomID = (String)inParam.get("BOMID");
        StorageOrgUnitInfo storageOrgUnit = (StorageOrgUnitInfo)inParam.get("STORAGEORG");
        String storageOrgId = storageOrgUnit.getId().toString();
        String tmpTable = null;
        String projectID = "999999999";
        String trackID = "999999999";
        if (project != null) {
            projectID = project.getId().toString();
        }
        if (inParam.get("TRACKNUM") != null) {
            trackID = inParam.get("TRACKNUM").toString();
        }
        ProjectTaskInfo taskInstance = new ProjectTaskInfo();
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)this.ctx);
        RuleStatus ruleStatus = codingRuleManager.getRuleStatus((IObjectValue)taskInstance, storageOrgUnit.getId().toString());
        if (!ruleStatus.isExist()) {
            throw new WBSException(WBSException.TASK_CODING_RULE_WRONG);
        }
        String beginDate = null;
        beginDate = parent == null ? MRPUtil.dateToString((Date)project.getPlanBeginTime(), (String)"yyyy-MM-dd") : MRPUtil.dateToString((Date)parent.getPlanBeginTime(), (String)"yyyy-MM-dd");
        String expandTablName = this.createTable();
        StringBuffer sqlBuf = new StringBuffer();
        try {
            int level;
            sqlBuf.setLength(0);
            sqlBuf.append("insert into ").append(expandTablName).append(" ").append("\r\n").append("(FID,FTrackNumberID,FProjectID,FParentID,FMaterialID,FUnitID,FPrec,").append("FMaterialAttr,FLevel,FUnitQty,FScrapRate,FScrapRateExpression,FLeadTime,FProduceLeadTime) ").append("\r\n").append("select newbosid('9F1477B3'),'").append(trackID).append("','").append(projectID).append("',null,t0.FMaterialID,t3.FBaseUnit,t21.FQtyPrecision,");
            sqlBuf.append("t2.FMaterialAttr,0,1,").append("t2.FScrapRate,t2.FScrapRateExpression,t2.FProduceLeadTime,t2.FProduceLeadTime ").append("").append("\r\n").append("from t_mm_bom t0 ").append("\r\n").append("inner join T_BD_Material t3 on t3.FID = t0.FMaterialID ").append("inner join T_BD_MultiMeasureUnit t21 on t0.fmaterialid = t21.fmaterialid and t3.FBaseUnit = t21.FMeasureUnitID ").append("\r\n").append("inner join t_bd_materialplan t2 on t0.fmaterialid = t2.fmaterialid ").append("\r\n").append("and t2.forgunit = '").append(storageOrgId).append("' ").append("\r\n");
            sqlBuf.append("where ").append("\r\n").append(" t0.fid = '").append(bomID).append("'");
            int rows = MRPUtil.executeUpdate((Context)this.ctx, (String)sqlBuf.toString());
            tmpTable = this.createTempTable2(this.ctx);
            for (level = 0; rows > 0 && level <= 99; ++level) {
                StringBuffer sb2 = new StringBuffer();
                sb2.append(" insert into ").append(tmpTable).append("\r\n").append(" (FID,FMaterialID,FTrackNumberID,FProjectID,FStorageOrgUnitID) ").append("\r\n").append(" select FID,FMaterialID,FTrackNumberID,FProjectID,").append("'").append(storageOrgId).append("' from ").append(expandTablName).append(" where flevel = ").append(level);
                MRPUtil.executeUpdate((Context)this.ctx, (String)sb2.toString());
                BOMExtend2FacadeFactory.getLocalInstance((Context)this.ctx).getBomByTmpTab(tmpTable);
                sqlBuf.setLength(0);
                sqlBuf.append("insert into ").append(expandTablName).append(" ").append("\r\n").append("(FID,FTrackNumberID,FProjectID,FParentID,FMaterialID,FUnitID,FPrec,").append("FMaterialAttr,FLevel,FUnitQty,FScrapRate,FScrapRateExpression,FLeadTime,FProduceLeadTime) ").append("\r\n").append("select newbosid('9F1477B3'),'").append(trackID).append("','").append(projectID).append("',t4.FID,t1.FMaterialID,t3.FBaseUnit,t21.FQtyPrecision,");
                sqlBuf.append("t2.FMaterialAttr,").append(level + 1).append(",").append("case when t1.FConsumeType = 20 then ").append("to_decimal(1.0 /(t0.FProductQty * t0.fyield / 100) * t1.FConsumeFixQty,21,8) ").append("else ").append("\r\n").append("to_decimal(to_decimal(to_decimal(to_decimal(to_decimal(t0.FPRODUCTBASEQTY/t1.fbaseproductrate,21,8)/t1.FBASERATE,21,8)*(t1.FPROPORTION * 0.01),21,8) / t0.FPRODUCTQTY / t0.fyield / 100,21,8) * t4.funitQty,21,8) ").append("end FFUnitQty,").append("\r\n").append("case when t4.FScrapRateExpression = 10610 then ").append("\r\n").append("round(to_decimal(t1.FScrapRatio/100 /(1-t4.fscrapRate)/t0.fyield/100,21,8),4) ").append("\r\n").append("else round(to_decimal(t1.FScrapRatio/100*(1+t4.fscrapRate)/t0.fyield/100,21,8),4) ").append("\r\n").append("end FFScrapRate,t2.FScrapRateExpression,t1.FLeadTime,t2.FProduceLeadTime ").append("\r\n").append("from t_mm_bom t0 ").append("\r\n").append("inner join t_mm_bomentry t1 on t0.fid = t1.fparentid ").append("\r\n").append("inner join T_BD_Material t3 on t3.FID = t1.FMaterialID ").append("\r\n").append("inner join T_BD_MultiMeasureUnit t21 on t1.fmaterialid = t21.fmaterialid and t3.FBaseUnit = t21.FMeasureUnitID ").append("\r\n").append("inner join t_bd_materialplan t2 on t1.fmaterialid = t2.fmaterialid ").append("\r\n").append("and t2.forgunit = '").append(storageOrgId).append("' ").append("\r\n").append("inner join ").append(expandTablName).append(" t4 on t0.fmaterialid = t4.fmaterialid  ").append("inner join ").append(tmpTable).append(" t10 on t10.fid = t4.FID ").append("where t1.FEffectiveDate <= add_days(to_date('").append(beginDate).append(" 00:00:00') , t1.FLeadtime) ").append("\r\n").append("and t1.FDisableDate >= add_days(to_date('").append(beginDate).append(" 00:00:00') , t1.FLeadtime)  ").append("\r\n").append("and t1.FOutputType in (10710,10740) ").append("\r\n").append("and t0.FSTORAGEORGUNITID = ? ").append("\r\n").append(" and t0.FID = t10.FBomID");
                rows = MRPUtil.executeUpdate((Context)this.ctx, (String)sqlBuf.toString(), (Object[])new Object[]{storageOrgId});
                MRPUtil.executeUpdate((Context)this.ctx, (String)("delete from " + tmpTable));
            }
            if (level > 99) {
                throw new BomException(BomException.CYCLE);
            }
            StringBuffer checkETOMaterialSql = new StringBuffer();
            checkETOMaterialSql.append(" select m.fnumber from ").append(expandTablName).append(" as expand").append("\r\n");
            checkETOMaterialSql.append(" inner join t_bd_materialplan mp on mp.fmaterialId=expand.fmaterialId").append("\r\n");
            checkETOMaterialSql.append(" inner join t_bd_material m on m.fId=expand.fmaterialId").append("\r\n");
            checkETOMaterialSql.append(" where mp.forgunit ='").append(storageOrgId).append("' ").append("\r\n");
            checkETOMaterialSql.append(" and mp.FManufactureStrategyID not in('").append("GE2FIa4GQ6uhdx0RDGuibtg0uEU=").append("', '").append("qAXoUB/uBg/gQKjAYj0WQ9g0uEU=").append("') ").append("\r\n");
            IRowSet materialRs = DbUtil.executeQuery((Context)this.ctx, (String)checkETOMaterialSql.toString());
            ArrayList<String> materialNumberList = new ArrayList<String>();
            try {
                while (materialRs.next()) {
                    materialNumberList.add(materialRs.getString("fnumber"));
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            inParam.put("TABLENAME", expandTablName);
            coll = this.buildTasks(inParam);
            rusultMap.put("projectTaskCollection", (Object)coll);
            rusultMap.put("errorNumber", materialNumberList);
            hashMap = rusultMap;
        }
        catch (Throwable throwable) {
            TempTablePool pool = TempTablePool.getInstance((Context)this.ctx);
            if (expandTablName != null) {
                pool.releaseTable(expandTablName);
            }
            if (tmpTable != null) {
                pool.releaseTable(tmpTable);
            }
            throw throwable;
        }
        TempTablePool pool = TempTablePool.getInstance((Context)this.ctx);
        if (expandTablName != null) {
            pool.releaseTable(expandTablName);
        }
        if (tmpTable != null) {
            pool.releaseTable(tmpTable);
        }
        return hashMap;
    }

    private ProjectTaskCollection buildTasks(Map inParam) throws BOSException, EASBizException {
        IProjectDictData iProjectDictData = ProjectDictDataFactory.getLocalInstance(this.ctx);
        ProjectDictDataInfo feedbackMode = iProjectDictData.getProjectDictDataInfo((IObjectPK)new ObjectUuidPK("8RJ1z1oESdOXmsnCpkmCeppMH64="));
        String locStr = LocaleUtils.getLocaleString((Locale)this.ctx.getLocale());
        ProjectTaskInfo taskInstance = new ProjectTaskInfo();
        BigDecimal convertRate = null;
        WBSInfo[] wbsInfos = null;
        WBSRulerInfo[] wbsRulers = null;
        String tableName = (String)inParam.get("TABLENAME");
        StorageOrgUnitInfo storageOrgUnit = (StorageOrgUnitInfo)inParam.get("STORAGEORG");
        ProjectInfo project = (ProjectInfo)inParam.get("PROJECT");
        BigDecimal expandqty = (BigDecimal)inParam.get("QTY");
        ProjectTaskInfo parent = null;
        if (inParam.get("PARENT") != null) {
            parent = (ProjectTaskInfo)inParam.get("PARENT");
        }
        ProjectDictDataInfo taskType = null;
        taskType = ProjectDictDataFactory.getLocalInstance(this.ctx).getProjectDictDataInfo((IObjectPK)new ObjectUuidPK("uxqG1JcyTNKWqD8KTZatKppMH64="));
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)this.ctx);
        wbsRulers = WBSRulerFactory.getLocalInstance(this.ctx).getWBSRuler(project.getId().toString());
        wbsInfos = parent != null ? WBSRulerFactory.getLocalInstance(this.ctx).getNextWBS(project.getId().toString(), parent.getId().toString(), 1) : WBSRulerFactory.getLocalInstance(this.ctx).getNextWBS(project.getId().toString(), null, 1);
        HashMap<String, ProjectTaskInfo> parents = new HashMap<String, ProjectTaskInfo>();
        convertRate = this.calcCconvertRate(inParam);
        ProjectTaskCollection tasks = new ProjectTaskCollection();
        ProjectTaskCollection needProcessRelation = new ProjectTaskCollection();
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("select t0.*,t1.FNumber fmaterialnumber,t1.FName_").append(locStr).append(" fmaterialname ,t1.fmodel FModel, ").append("t2.FNumber funitnumber,t2.FName_").append(locStr).append(" funitname, ").append("t3.FNumber").append(" ftrackNum ").append("from ").append(tableName).append(" t0 ").append("inner join t_bd_material t1 on t0.fmaterialid = t1.FID ").append("inner join T_BD_MeasureUnit t2 on t0.funitid = t2.FID ").append("left outer join t_mm_tracknumber t3 on t0.FTrackNumberID=t3.FID ").append(" order by t0.FLevel asc");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sqlBuf.toString());
        String[] nums = codingRuleManager.getBatchNumber((IObjectValue)taskInstance, storageOrgUnit.getId().toString(), rs.size());
        try {
            int numIndex = 0;
            while (rs.next()) {
                BigDecimal qty;
                ProjectTaskInfo task = new ProjectTaskInfo();
                String parentID = null;
                task.setFeedbackMode(feedbackMode);
                task.setCreator((UserInfo)this.ctx.get((Object)"UserInfo"));
                task.setId(BOSUuid.read((String)rs.getString("FID")));
                task.setNumber(nums[numIndex]);
                task.setName(rs.getString("fmaterialname"));
                task.setStorageOrgUnit(storageOrgUnit);
                task.setCreateOrgUnit(storageOrgUnit);
                task.setProject(project);
                task.setTaskType(taskType);
                task.setBaseStatus(MMBaseStatusEnum.SAVED);
                BigDecimal totalTime = rs.getBigDecimal("FLeadTime");
                BigDecimal productLeadTime = rs.getBigDecimal("FProduceLeadTime");
                if (totalTime.floatValue() < 0.0f) {
                    totalTime = totalTime.abs();
                } else if (totalTime.floatValue() == 0.0f) {
                    totalTime = new BigDecimal("1.00");
                }
                if (productLeadTime.floatValue() < 0.0f) {
                    productLeadTime = totalTime.abs();
                } else if (productLeadTime.floatValue() == 0.0f) {
                    productLeadTime = new BigDecimal("1.00");
                }
                task.put("FProduceLeadTime", productLeadTime);
                task.setTotalTime(totalTime);
                task.setIsMileStone(false);
                task.setIsTemplate(this.isTemplate);
                IProjectFacade projectfacade = ProjectFacadeFactory.getLocalInstance(this.ctx);
                CurrencyInfo baseCurrInfo = projectfacade.getCurrenyOrgUnitInfo(storageOrgUnit.getId().toString());
                task.setCurrency(baseCurrInfo);
                task.setCreateTime(new Timestamp(System.currentTimeMillis()));
                MaterialInfo material = new MaterialInfo();
                material.setId(BOSUuid.read((String)rs.getString("FMaterialID")));
                material.setModel(rs.getString("FModel"));
                material.setName(rs.getString("fmaterialname"));
                material.setNumber(rs.getString("fmaterialnumber"));
                task.setMaterial(material);
                MeasureUnitInfo unit = new MeasureUnitInfo();
                unit.setId(BOSUuid.read((String)rs.getString("funitid")));
                unit.setName(rs.getString("funitname"));
                unit.setNumber(rs.getString("funitnumber"));
                task.setUnit(unit);
                if (rs.getString("ftrackNum") != null) {
                    TrackNumberInfo trackNum = new TrackNumberInfo();
                    trackNum.setName(rs.getString("ftrackNum"));
                    trackNum.setId(BOSUuid.read((String)rs.getString("FTrackNumberID")));
                    task.setCarNumber(trackNum);
                }
                if (!rs.getString("FMaterialAttr").equalsIgnoreCase("10020")) {
                    task.put("10020", "10020");
                    needProcessRelation.add(task);
                }
                if (rs.getString("FParentID") != null) {
                    parentID = rs.getString("FParentID");
                }
                if (parentID == null) {
                    task.setWbsNumber(wbsInfos[0].getWBS());
                    task.setSeq(wbsInfos[0].getSeq());
                    task.setNextSeq(1);
                    task.setLevel(wbsInfos[0].getLevel());
                    task.setParent(parent);
                    task.put("isBOMExp", Boolean.TRUE);
                } else if (parents.get(parentID) != null) {
                    ProjectTaskInfo ptask = (ProjectTaskInfo)parents.get(parentID);
                    WBSInfo wbsInfo = new WBSInfo();
                    wbsInfo.setDelimitor(".");
                    wbsInfo.setDigists(wbsRulers[ptask.getLevel()].getDigists());
                    wbsInfo.setSeq(ptask.getNextSeq());
                    wbsInfo.setParentWBS(ptask.getWbsNumber());
                    this.checkWBSOutOfBounds(ptask.getNextSeq(), wbsRulers[ptask.getLevel()].getDigists());
                    task.setLevel(ptask.getLevel() + 1);
                    task.setSeq(ptask.getNextSeq());
                    task.setNextSeq(1);
                    task.setWbsNumber(wbsInfo.getWBS());
                    task.setParent(ptask);
                    expandqty = ptask.getQty();
                    ptask.setNextSeq(ptask.getNextSeq() + 1);
                }
                int prec = rs.getInt("fPrec");
                BigDecimal unitQty = rs.getBigDecimal("funitQty").multiply(convertRate).setScale(8, 0);
                BigDecimal planedQty = qty = unitQty.multiply(expandqty).setScale(prec, 0);
                planedQty = rs.getInt("FScrapRateExpression") == 10610 ? qty.divide(new BigDecimal("1.0").subtract(rs.getBigDecimal("fscrapRate")), prec, 0) : qty.multiply(new BigDecimal("1.0").add(rs.getBigDecimal("fscrapRate"))).setScale(prec, 0);
                task.setQty(planedQty);
                parents.put(task.getId().toString(), task);
                tasks.add(task);
                ++numIndex;
            }
            this.buildPreRelation(needProcessRelation, tasks, storageOrgUnit, codingRuleManager);
        }
        catch (SQLException e) {
            codingRuleManager.recycleBatchNumber((IObjectValue)taskInstance, storageOrgUnit.getId().toString(), nums);
            throw new SQLDataException(e);
        }
        return tasks;
    }

    private void checkWBSOutOfBounds(int seq, int digists) throws WBSException {
        if ((double)seq > Math.pow(10.0, digists) - 1.0) {
            throw new WBSException(WBSException.WBSSEQ_OUTOFBOUNDS);
        }
    }

    private BigDecimal calcCconvertRate(Map inParam) throws BOSException, EASBizException {
        BigDecimal convertRate = new BigDecimal("1.00");
        StorageOrgUnitInfo storageOrgUnit = (StorageOrgUnitInfo)inParam.get("STORAGEORG");
        MaterialInfo parentMaterial = (MaterialInfo)inParam.get("MATERIAL");
        MeasureUnitInfo billUnit = parentMaterial.getBaseUnit();
        String prodUnitID = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select FProductUnitID from t_bd_materialplan where fmaterialid = ? and forgunit = ?");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{parentMaterial.getId().toString(), storageOrgUnit.getId().toString()});
        try {
            if (rs.next()) {
                prodUnitID = rs.getString("FProductUnitID");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (prodUnitID != null && !prodUnitID.equals(billUnit.getId().toString())) {
            BigDecimal billunit_ConRate = null;
            BigDecimal produnit_ConRate = null;
            sql.setLength(0);
            sql.append("select FBaseConvsRate,FQtyPrecision,FMeasureUnitID ").append("from T_BD_MultiMeasureUnit ").append("where fmaterialid = ? and (FMeasureUnitID = ? or FMeasureUnitID = ?)");
            rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{parentMaterial.getId().toString(), billUnit.getId().toString(), prodUnitID});
            try {
                while (rs.next()) {
                    if (rs.getString("FMeasureUnitID").equals(prodUnitID)) {
                        produnit_ConRate = rs.getBigDecimal("FBaseConvsRate");
                        continue;
                    }
                    billunit_ConRate = rs.getBigDecimal("FBaseConvsRate");
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            if (billunit_ConRate != null && produnit_ConRate != null) {
                convertRate = billunit_ConRate.divide(produnit_ConRate, 8, 4);
            }
        }
        return convertRate;
    }

    private ProjectTaskCollection buildPreRelation(ProjectTaskCollection needProcessRelation, ProjectTaskCollection tasks, StorageOrgUnitInfo storageOrgUnit, ICodingRuleManager codingRuleManager) throws EASBizException, BOSException {
        ProjectTaskCollection copyTasks = new ProjectTaskCollection();
        for (int i = 0; i < needProcessRelation.size(); ++i) {
            ProjectTaskInfo task = needProcessRelation.get(i);
            boolean hasChild = false;
            ProjectTaskInfo pretask = null;
            for (int j = 0; j < tasks.size(); ++j) {
                ProjectTaskInfo temp = tasks.get(j);
                if (temp.getParent() == null || !temp.getParent().getId().equals((Object)task.getId())) continue;
                hasChild = true;
                if (pretask == null) {
                    pretask = temp;
                    continue;
                }
                if (!(temp.getTotalTime().subtract(pretask.getTotalTime()).floatValue() >= 0.0f)) continue;
                pretask = temp;
            }
            ProjectTaskInfo taskCopy = null;
            if (!hasChild) continue;
            ProjectDictDataInfo iteratorType = null;
            iteratorType = ProjectDictDataFactory.getLocalInstance(this.ctx).getProjectDictDataInfo((IObjectPK)new ObjectUuidPK("Fq4GNbRIRsycITnKFLeBd5pMH64="));
            taskCopy = (ProjectTaskInfo)task.clone();
            BigDecimal productLeadTime = (BigDecimal)taskCopy.get("FProduceLeadTime");
            if (productLeadTime != null) {
                taskCopy.setTotalTime(productLeadTime);
            }
            taskCopy.setId(BOSUuid.create((BOSObjectType)taskCopy.getBOSType()));
            taskCopy.put("isCopy", Boolean.TRUE);
            taskCopy.setParent(task);
            taskCopy.setIteratorType(iteratorType);
            taskCopy.setInterval(new BigDecimal("0"));
            WBSInfo wbsInfo = new WBSInfo();
            wbsInfo.setDelimitor(".");
            wbsInfo.setLevel(task.getLevel() + 1);
            wbsInfo.setSeq(task.getNextSeq());
            wbsInfo.setParentWBS(task.getWbsNumber());
            if (pretask != null) {
                String preTaskWBS = pretask.getWbsNumber();
                int lastIndex = preTaskWBS.lastIndexOf(".");
                int digists = preTaskWBS.length() - lastIndex - 1;
                wbsInfo.setDigists(digists);
                this.checkWBSOutOfBounds(task.getNextSeq(), digists);
            }
            taskCopy.setWbsNumber(wbsInfo.getWBS());
            taskCopy.setNextSeq(1);
            task.setNextSeq(task.getNextSeq() + 1);
            copyTasks.add(taskCopy);
        }
        String[] copyNums = codingRuleManager.getBatchNumber((IObjectValue)tasks.get(0), storageOrgUnit.getId().toString(), needProcessRelation.size());
        for (int i = 0; i < copyTasks.size(); ++i) {
            ProjectTaskInfo task = copyTasks.get(i);
            task.setNumber(copyNums[i]);
            int indexOfTask = tasks.indexOf(task.getParent());
            tasks.insertObject(indexOfTask, (IObjectValue)task);
        }
        return copyTasks;
    }

    private String createTempTable2(Context ctx) throws BOSException, EASBizException {
        String expandTablName = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            StringBuffer sqlBuf = new StringBuffer();
            sqlBuf.append("create table tttttt (").append("FID varchar(44) not null,").append("FMaterialID varchar(44) null,").append("FTrackNumberID varchar(44) null,").append("FProjectID varchar(44) null,").append("FStorageOrgUnitID varchar(44) null,").append("FBOMID varchar(44) null").append(")");
            expandTablName = pool.createTempTable(sqlBuf.toString());
        }
        catch (Exception e1) {
            throw new BOSException((Throwable)e1);
        }
        return expandTablName;
    }
}

