/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.framework.DataBaseDException;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitCollection;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.ICtrlUnit;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.app.webservice.util.BillProertiesConvertor;
import com.kingdee.eas.fi.ar.app.webservice.util.WrongArgumentException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mm.common.MMBaseStatusEnum;
import com.kingdee.eas.mm.project.IProject;
import com.kingdee.eas.mm.project.ProjectCalendarFactory;
import com.kingdee.eas.mm.project.ProjectCalendarInfo;
import com.kingdee.eas.mm.project.ProjectCollection;
import com.kingdee.eas.mm.project.ProjectDictDataInfo;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.mm.project.ProjectGroupInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.mm.project.ProjectOrgInfo;
import com.kingdee.eas.mm.project.app.AbstractCreateProjectFacadeControllerBean;
import com.kingdee.eas.mm.project.util.MMProjectCalendarFactory;
import com.kingdee.eas.scm.im.inv.ws.util.XMLUtil;
import com.kingdee.eas.util.ResourceBase;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class CreateProjectFacadeControllerBean
extends AbstractCreateProjectFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.project.app.CreateProjectFacadeControllerBean");
    private static final String SUCCESS = "Y";
    private static final String FAILED = "N";

    public FilterInfo getFilterDup(String fieldName, Object compareValue, CompareType compareType) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo(fieldName, compareValue, compareType);
        filter.getFilterItems().add(filterItem);
        filter.setMaskString("#0");
        return filter;
    }

    @Override
    protected String[] _CreateProject(Context ctx, String xmlData) throws BOSException, EASBizException {
        Document d = null;
        HashMap hashmap = null;
        ArrayList entryList = null;
        IProject ip = ProjectFactory.getLocalInstance(ctx);
        try {
            d = XMLUtil.builderDocument((String)xmlData);
            hashmap = XMLUtil.getBillHead((Document)d);
            entryList = XMLUtil.getBillEntries((Document)d);
        }
        catch (SAXException e) {
            return new String[]{FAILED, "0001", e.getMessage()};
        }
        catch (IOException e) {
            return new String[]{FAILED, "0002", e.getMessage()};
        }
        catch (ParserConfigurationException e) {
            return new String[]{FAILED, "0003", e.getMessage()};
        }
        catch (TransformerException e) {
            return new String[]{FAILED, "0004", e.getMessage()};
        }
        ProjectInfo pro = new ProjectInfo();
        ProjectCalendarFactory.getLocalInstance(ctx).getProjectCalendar();
        ProjectCalendarInfo projectcalendarInfo = new ProjectCalendarInfo();
        projectcalendarInfo.setId(BOSUuid.read((String)"nz4fwnlKQs2UUNYLZfS4U5nUdmw="));
        pro.setProjectCalendar(projectcalendarInfo);
        try {
            this.setProertiesNewPro(pro, hashmap, entryList, ctx, ip);
        }
        catch (WrongArgumentException e1) {
            return new String[]{FAILED, e1.getTypeNumber(), e1.getField()};
        }
        if (pro != null && pro.getNumber() != null) {
            try {
                IObjectPK io = ip.submit((CoreBaseInfo)pro);
                ip.audit(io);
            }
            catch (Exception e) {
                logger.error((Object)e);
                return new String[]{FAILED, e.getMessage()};
            }
        }
        return new String[]{SUCCESS};
    }

    private void setProertiesNewPro(ProjectInfo pro, HashMap hashmap, List entryList, Context ctx, IProject ip) throws BOSException, EASBizException, WrongArgumentException {
        if (hashmap != null) {
            String name = (String)hashmap.get("name");
            if (name == null || name.length() == 0) {
                throw new WrongArgumentException("name", this.getResource(ctx, "Dup_Name"));
            }
            pro.setName(name);
            String number = (String)hashmap.get("number");
            if (number == null || number != null && number.length() > 0 && ip.exists(this.getFilterDup("number", number, CompareType.EQUALS))) {
                throw new WrongArgumentException("number", this.getResource(ctx, "PROJECT_NUMBER_ISNULL"));
            }
            pro.setNumber(number);
            CtrlUnitInfo cu = (CtrlUnitInfo)BillProertiesConvertor.getValueObject(hashmap.get("CU"), CtrlUnitInfo.class, null, (Context)ctx);
            this.verifyFieldNotNull("CU", cu);
            CurrencyInfo currency = this.getCompanyOrgUnit2Infoby(ctx, cu.getId().toString(), "cu");
            pro.setCurrency(currency);
            pro.setCU(cu);
            pro.setAdminCU(cu);
            this.verifyFieldNotNull("creator", hashmap.get("creator"));
            UserInfo userInfo = (UserInfo)BillProertiesConvertor.getValueObject(hashmap.get("creator"), UserInfo.class, null, (Context)ctx);
            this.verifyFieldNotNull("creator", userInfo);
            pro.setCreator(userInfo);
            if (!this.isNull(hashmap.get("planBeginTime"))) {
                this.verifyFieldFormat("planBeginTime", hashmap.get("planBeginTime"), "date");
            }
            Timestamp planBeginTime = BillProertiesConvertor.getTimestamp((String)((String)hashmap.get("planBeginTime")));
            MMProjectCalendarFactory mmprojectCalendarFactory = new MMProjectCalendarFactory(ctx, null);
            BigDecimal totalTime = new BigDecimal("1.0");
            if (totalTime != null && planBeginTime != null) {
                Date beginTime = mmprojectCalendarFactory.getWorkdate(planBeginTime);
                pro.setPlanBeginTime(new Timestamp(beginTime.getTime()));
                Date addWorklength = mmprojectCalendarFactory.addWroklength(beginTime, totalTime.intValue());
                Date endTime = mmprojectCalendarFactory.getWorkdate(new Timestamp(addWorklength.getTime()));
                pro.setPlanEndTime(new Timestamp(endTime.getTime()));
                pro.setTotalTime(totalTime);
            }
            if (!this.isNull(hashmap.get("totalCost"))) {
                this.verifyFieldFormat("totalCost", hashmap.get("totalCost"), "bigdecimal");
            }
            BigDecimal totalCost = BillProertiesConvertor.getBigDecimal((String)((String)hashmap.get("totalCost")));
            pro.setTotalCost(totalCost);
            ProjectGroupInfo pGroup = new ProjectGroupInfo();
            pGroup.setId(BOSUuid.read((String)"K8Er4JuzTpys1ipFv+b8dkLK+hE="));
            pro.setGroup(pGroup);
            pro.setAuditor(userInfo);
            pro.setLastUpdateUser(userInfo);
            ProjectDictDataInfo pd = new ProjectDictDataInfo();
            pd.setId(BOSUuid.read((String)"U+F6TI7tSwWsxrdj4TYytZpMH64="));
            pro.setProjectType(pd);
            pro.setBaseStatus(MMBaseStatusEnum.SAVED);
            pro.setIsTemplate(false);
            Calendar cal = Calendar.getInstance();
            Timestamp t = new Timestamp(cal.getTimeInMillis());
            pro.setCreateTime(t);
            if (entryList != null && entryList.get(0) != null) {
                HashMap storg = (HashMap)entryList.get(0);
                StorageOrgUnitInfo storageOrgunit = (StorageOrgUnitInfo)BillProertiesConvertor.getValueObject(storg.get("storageOrgunit"), StorageOrgUnitInfo.class, null, (Context)ctx);
                this.verifyFieldNotNull("storageOrgunit", storageOrgunit);
                ProjectOrgInfo projectOrg = new ProjectOrgInfo();
                projectOrg.setStorageOrgUnit(storageOrgunit);
                pro.getProjectOrg().add(projectOrg);
            }
        }
    }

    private void verifyFieldNotNull(String name, Object value) throws WrongArgumentException {
        if (this.isNull(value)) {
            throw new WrongArgumentException(name, "1005");
        }
    }

    private boolean isNull(Object o) {
        if (o == null) {
            return true;
        }
        if (o instanceof String) {
            return o.equals("");
        }
        return false;
    }

    private void verifyFieldFormat(String name, Object value, String dataType) throws WrongArgumentException {
        if (dataType.equals("int")) {
            String intString = (String)value;
            if (!Pattern.matches("[+|-]?\\d+", intString)) {
                throw new WrongArgumentException(name, "1002");
            }
        } else if (dataType.equals("bigdecimal")) {
            String bigDecimalStirng = (String)value;
            if (!Pattern.matches("[-|+]?\\d+(.\\d+)?(e[-|+]\\d+)?", bigDecimalStirng)) {
                throw new WrongArgumentException(name, "1004");
            }
        } else if (dataType.equals("date")) {
            String dateString = (String)value;
            if (!Pattern.matches("\\d{4}\\-\\d{1,2}\\-\\d{1,2}\\s\\d{1,2}:\\d{1,2}:\\d{1,2}", dateString)) {
                throw new WrongArgumentException(name, "1001");
            }
        } else if (dataType.equals("bool") && !value.equals("true") && !value.equals("false")) {
            throw new WrongArgumentException(name, "1003");
        }
    }

    public String getResource(Context ctx, String strKey) {
        String strTemp = ResourceBase.getString((String)"com.kingdee.eas.mm.project.ProjectResource", (String)strKey, (Locale)ctx.getLocale());
        return strTemp;
    }

    @Override
    protected String[] _ProjectToAssign(Context ctx, String projectNo, String cuNumber) throws BOSException, EASBizException {
        ProjectInfo pro = null;
        CtrlUnitInfo cuinfo = null;
        IProject ip = ProjectFactory.getLocalInstance(ctx);
        try {
            pro = this.bangProject(ctx, projectNo, ip);
        }
        catch (WrongArgumentException e) {
            return new String[]{FAILED, e.getTypeNumber(), e.getField()};
        }
        try {
            cuinfo = this.bangCtrlUnit(ctx, cuNumber);
        }
        catch (WrongArgumentException e) {
            return new String[]{FAILED, e.getTypeNumber(), e.getField()};
        }
        ObjectUuidPK ctrlUnitPK = new ObjectUuidPK(pro.getCU().getId().toString());
        ObjectUuidPK dataBaseDPK = new ObjectUuidPK(pro.getId().toString());
        ObjectUuidPK assignCUPK = new ObjectUuidPK(cuinfo.getId().toString());
        try {
            ip.assign((IObjectPK)ctrlUnitPK, (IObjectPK)dataBaseDPK, (IObjectPK)assignCUPK);
        }
        catch (DataBaseDException e) {
            return new String[]{FAILED, e.getMessage()};
        }
        return new String[]{SUCCESS};
    }

    private ProjectInfo bangProject(Context ctx, String projectNo, IProject ip) throws BOSException, EASBizException, WrongArgumentException {
        ProjectInfo pro = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(this.getFilterDup("number", projectNo, CompareType.EQUALS));
        ProjectCollection pros = ip.getProjectCollection(viewInfo);
        if (pros == null || pros.size() <= 0) {
            throw new WrongArgumentException(projectNo, this.getResource(ctx, "PROJECT_WS_NAME_NOT"));
        }
        pro = pros.get(0);
        return pro;
    }

    private CtrlUnitInfo bangCtrlUnit(Context ctx, String cuNumber) throws BOSException, EASBizException, WrongArgumentException {
        CtrlUnitInfo cuinfo = null;
        ICtrlUnit icu = CtrlUnitFactory.getLocalInstance((Context)ctx);
        EntityViewInfo viewInfo1 = new EntityViewInfo();
        viewInfo1.setFilter(this.getFilterDup("number", cuNumber, CompareType.EQUALS));
        CtrlUnitCollection cus = icu.getCtrlUnitCollection(viewInfo1);
        if (cus == null || cus.size() <= 0) {
            throw new WrongArgumentException(cuNumber, this.getResource(ctx, "PROJECT_WS_CU_NOT"));
        }
        cuinfo = cus.get(0);
        return cuinfo;
    }

    private CurrencyInfo getCompanyOrgUnit2Infoby(Context ctx, String id, String number) throws BOSException, EASBizException, WrongArgumentException {
        CompanyOrgUnitInfo cominfo = null;
        ICompanyOrgUnit icom = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CurrencyInfo baseCurrInfo = null;
        EntityViewInfo viewInfo1 = new EntityViewInfo();
        viewInfo1.setFilter(this.getFilterDup("CU", id, CompareType.EQUALS));
        CompanyOrgUnitCollection carrys = icom.getCompanyOrgUnitCollection(viewInfo1);
        if (carrys == null || carrys.size() <= 0) {
            throw new WrongArgumentException(number, this.getResource(ctx, "PROJECT_ISNOT_ADMIN"));
        }
        cominfo = carrys.get(0);
        baseCurrInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(cominfo.getBaseCurrency().getId().toString()));
        return baseCurrInfo;
    }
}

