/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.WorkDateTypeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mm.basedata.FactoryCalendarRuleException;
import com.kingdee.eas.mm.basedata.FactoryCalendarUtils;
import com.kingdee.eas.mm.project.ProjectCalendarEntryCollection;
import com.kingdee.eas.mm.project.ProjectCalendarEntryInfo;
import com.kingdee.eas.mm.project.ProjectCalendarFactory;
import com.kingdee.eas.mm.project.ProjectCalendarInfo;
import com.kingdee.eas.mm.project.app.AbstractProjectCalendarControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ProjectCalendarControllerBean
extends AbstractProjectCalendarControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.project.app.ProjectCalendarControllerBean");

    @Override
    protected void _getProjectCalendar(Context ctx) throws BOSException, EASBizException {
        if (this.isHavaCalendarInDate(ctx, "nz4fwnlKQs2UUNYLZfS4U5nUdmw=")) {
            return;
        }
        Calendar currentCal = Calendar.getInstance();
        currentCal.add(1, -3);
        java.util.Date startDate = currentCal.getTime();
        currentCal.add(1, 11);
        java.util.Date endDate = currentCal.getTime();
        ProjectCalendarInfo projectCalendarInfo = new ProjectCalendarInfo();
        projectCalendarInfo.setId(BOSUuid.read((String)"nz4fwnlKQs2UUNYLZfS4U5nUdmw="));
        ProjectCalendarEntryCollection collection = this._createProjectCalendar(ctx, startDate, endDate, "nz4fwnlKQs2UUNYLZfS4U5nUdmw=", true);
        projectCalendarInfo.setNumber("PMTime");
        projectCalendarInfo.getEntrys().addCollection(collection);
        ProjectCalendarFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)projectCalendarInfo);
    }

    private boolean isHavaCalendarInDate(Context ctx, String projectCalendarId) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("select TOP 1 cal.fid from t_mm_projectcalendar cal  ");
        sb.append("where cal.fId = '").append(projectCalendarId).append("'");
        String entrySql = "select top 1 fid from t_mm_projectcalendarentry  where fparentId = '" + projectCalendarId + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        boolean isHava = false;
        boolean isHead = false;
        boolean isEntry = false;
        try {
            while (rs.next()) {
                isHead = true;
            }
            rs.close();
            rs = DbUtil.executeQuery((Context)ctx, (String)entrySql);
            while (rs.next()) {
                isEntry = true;
            }
            rs.close();
            if (isHead && !isEntry) {
                entrySql = " delete from t_mm_projectcalendar where fid='" + projectCalendarId + "'";
                DbUtil.execute((Context)ctx, (String)entrySql);
            } else if (isHead && isEntry) {
                isHava = true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return isHava;
    }

    private ProjectCalendarEntryCollection getEntryCollection(java.util.Date startDate, java.util.Date endDate, String projectCalendarId) {
        ProjectCalendarEntryCollection collection = new ProjectCalendarEntryCollection();
        ProjectCalendarInfo projectCalendarInfo = new ProjectCalendarInfo();
        if (projectCalendarId != null) {
            projectCalendarInfo.setId(BOSUuid.read((String)projectCalendarId));
        }
        if (startDate.before(endDate)) {
            Calendar cal = Calendar.getInstance();
            ProjectCalendarEntryInfo entryInfo = null;
            int seq = 1;
            int weekOfDay = 0;
            while (startDate.before(endDate)) {
                cal.setTime(startDate);
                weekOfDay = cal.get(7);
                entryInfo = new ProjectCalendarEntryInfo();
                entryInfo.setParent(projectCalendarInfo);
                entryInfo.setWorkDate(cal.getTime());
                if (7 == weekOfDay || 1 == weekOfDay) {
                    entryInfo.setDateType(WorkDateTypeEnum.RESTDAY);
                } else {
                    entryInfo.setDateType(WorkDateTypeEnum.WORKDAY);
                }
                entryInfo.setSeq(seq++);
                collection.add(entryInfo);
                int month = cal.get(2);
                int day = cal.get(5);
                if (month == 11 && day == 31) {
                    int year = cal.get(1) + 1;
                    cal.set(year, 0, 1);
                } else {
                    cal.roll(6, 1);
                }
                startDate = cal.getTime();
            }
            entryInfo = new ProjectCalendarEntryInfo();
            entryInfo.setWorkDate(cal.getTime());
            entryInfo.setParent(projectCalendarInfo);
            cal.setTime(endDate);
            weekOfDay = cal.get(7);
            if (7 == weekOfDay || 1 == weekOfDay) {
                entryInfo.setDateType(WorkDateTypeEnum.RESTDAY);
            } else {
                entryInfo.setDateType(WorkDateTypeEnum.WORKDAY);
            }
            entryInfo.setSeq(seq++);
            collection.add(entryInfo);
        }
        return collection;
    }

    private ProjectCalendarEntryCollection getAllWorkDateEntry(java.util.Date startDate, java.util.Date endDate, String projectCalendarId) {
        ProjectCalendarEntryCollection collection = new ProjectCalendarEntryCollection();
        ProjectCalendarInfo projectCalendarInfo = new ProjectCalendarInfo();
        if (projectCalendarId != null) {
            projectCalendarInfo.setId(BOSUuid.read((String)projectCalendarId));
        }
        if (startDate.before(endDate)) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(startDate);
            ProjectCalendarEntryInfo entryInfo = null;
            int seq = 1;
            while (startDate.before(endDate)) {
                entryInfo = new ProjectCalendarEntryInfo();
                entryInfo.setParent(projectCalendarInfo);
                entryInfo.setWorkDate(cal.getTime());
                entryInfo.setDateType(WorkDateTypeEnum.WORKDAY);
                entryInfo.setSeq(seq++);
                collection.add(entryInfo);
                int month = cal.get(2);
                int day = cal.get(5);
                if (month == 11 && day == 31) {
                    int year = cal.get(1) + 1;
                    cal.set(year, 0, 1);
                } else {
                    cal.roll(6, 1);
                }
                startDate = cal.getTime();
            }
            entryInfo = new ProjectCalendarEntryInfo();
            entryInfo.setWorkDate(cal.getTime());
            if (projectCalendarId != null) {
                entryInfo.setParent(projectCalendarInfo);
            }
            entryInfo.setDateType(WorkDateTypeEnum.WORKDAY);
            entryInfo.setSeq(seq++);
            collection.add(entryInfo);
        }
        return collection;
    }

    public static void setWorkDateSeq(int seq, int workSeq, ProjectCalendarEntryCollection entryColl) {
        int monthSeq = 1;
        int weekSeq = 1;
        java.util.Date currDate = null;
        for (int i = 0; i < entryColl.size(); ++i) {
            ProjectCalendarEntryInfo entryInfo = entryColl.get(i);
            entryInfo.setSeq(seq + i);
            java.util.Date workDate = entryInfo.getWorkDate();
            if (currDate != null) {
                boolean isSameWeek;
                boolean isSameMonth = FactoryCalendarUtils.isSameMonth((java.util.Date)currDate, (java.util.Date)workDate);
                if (!isSameMonth) {
                    ++monthSeq;
                }
                if (!(isSameWeek = FactoryCalendarUtils.isSameWeek((java.util.Date)currDate, (java.util.Date)workDate))) {
                    ++weekSeq;
                }
                entryInfo.setMonthSeq(monthSeq);
                entryInfo.setWeekSeq(weekSeq);
                currDate = workDate;
            } else {
                currDate = workDate;
                entryInfo.setMonthSeq(monthSeq);
                entryInfo.setWeekSeq(weekSeq);
            }
            entryInfo.setYearSeq(1);
            int workDateType = entryInfo.getDateType().getValue();
            if (workDateType == 1) {
                entryInfo.setWorkDateSeq(workSeq);
                entryInfo.setNextWorkDaySeq(workSeq + 1);
                entryInfo.setPreWorkDaySeq(workSeq - 1);
                ++workSeq;
                continue;
            }
            entryInfo.setWorkDateSeq(0);
            entryInfo.setNextWorkDaySeq(workSeq);
            entryInfo.setPreWorkDaySeq(workSeq - 1);
        }
    }

    protected ProjectCalendarInfo _getProjectCalendar(Context ctx, String projectId) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected ProjectCalendarInfo _getProjectCalendarById(Context ctx, String projectCalendarId, java.util.Date startDate, java.util.Date endDate) throws BOSException, EASBizException {
        ProjectCalendarInfo projectCalendarInfo = new ProjectCalendarInfo();
        ProjectCalendarEntryCollection entrys = new ProjectCalendarEntryCollection();
        ProjectCalendarEntryInfo entryInfo = null;
        boolean isSunRest = false;
        boolean isMonRest = false;
        boolean isTueRest = false;
        boolean isWedRest = false;
        boolean isThuRest = false;
        boolean isFriRest = false;
        boolean isSatRest = false;
        if (projectCalendarId == null) {
            return projectCalendarInfo;
        }
        projectCalendarInfo.setId(BOSUuid.read((String)projectCalendarId));
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(ctx);
            StringBuffer strBuffSql = new StringBuffer();
            strBuffSql.append("select proCalendar.Fissunrest as issunrest,proCalendar.Fismonrest as ismonrest,");
            strBuffSql.append(" proCalendar.Fistuerest as istuerest,proCalendar.Fiswedrest as iswedrest,");
            strBuffSql.append(" proCalendar.Fisthurest as isthurest,proCalendar.Fisfrirest as isfrirest,");
            strBuffSql.append("proCalendar.Fissatrest as issatrest,calEntry.Fid as entryId , calEntry.FWorkDateSeq  ");
            strBuffSql.append(" as WorkDateSeq,calEntry.FWorkDate as WorkDate,calEntry.FDateType as DateType");
            strBuffSql.append(" from T_MM_ProjectCalendar proCalendar   ");
            strBuffSql.append(" inner join t_Mm_Projectcalendarentry calEntry on proCalendar.fid=calEntry.Fparentid");
            strBuffSql.append(" where ProCalendar.Fid='").append(projectCalendarId).append("' ");
            Calendar cal = Calendar.getInstance();
            if (startDate != null) {
                cal.setTime(startDate);
                cal.set(10, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                startDate = cal.getTime();
                strBuffSql.append(" and calEntry.FWorkDate>=? ");
            }
            if (endDate != null) {
                cal.setTime(endDate);
                int mm = cal.get(2);
                int yy = cal.get(1);
                if (mm == 11) {
                    ++yy;
                    mm = 0;
                } else {
                    ++mm;
                }
                cal.set(yy, mm, 1, 0, 0, 0);
                endDate = cal.getTime();
                strBuffSql.append(" and calEntry.FWorkDate< ? ");
            }
            strBuffSql.append(" order by calEntry.FWorkDate ");
            ps = con.prepareStatement(strBuffSql.toString());
            int index = 1;
            if (startDate != null) {
                ps.setDate(index++, new Date(startDate.getTime()));
            }
            if (endDate != null) {
                ps.setDate(index++, new Date(endDate.getTime()));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                entryInfo = new ProjectCalendarEntryInfo();
                String strEntryId = rs.getString("entryId");
                BOSUuid id = BOSUuid.read((String)strEntryId);
                entryInfo.setId(id);
                int workDateSeq = rs.getInt("WorkDateSeq");
                entryInfo.setWorkDateSeq(workDateSeq);
                int dateType = rs.getInt("DateType");
                entryInfo.setDateType(WorkDateTypeEnum.getEnum((int)dateType));
                Date workDate = rs.getDate("WorkDate");
                entryInfo.setWorkDate((java.util.Date)workDate);
                entrys.add(entryInfo);
                if (!rs.isFirst()) continue;
                isSunRest = rs.getBoolean("issunrest");
                isMonRest = rs.getBoolean("ismonrest");
                isTueRest = rs.getBoolean("istuerest");
                isWedRest = rs.getBoolean("iswedrest");
                isThuRest = rs.getBoolean("isthurest");
                isFriRest = rs.getBoolean("isfrirest");
                isSatRest = rs.getBoolean("issatrest");
            }
        }
        catch (SQLException er) {
            try {
                throw new BOSException("sql Execute Error :", (Throwable)er);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup(ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Statement)ps, (Connection)con);
        if (entrys.isEmpty()) {
            return null;
        }
        projectCalendarInfo.setIsSunRest(isSunRest);
        projectCalendarInfo.setIsMonRest(isMonRest);
        projectCalendarInfo.setIsTueRest(isTueRest);
        projectCalendarInfo.setIsWedRest(isWedRest);
        projectCalendarInfo.setIsThuRest(isThuRest);
        projectCalendarInfo.setIsFriRest(isFriRest);
        projectCalendarInfo.setIsSatRest(isSatRest);
        projectCalendarInfo.getEntrys().addCollection(entrys);
        return projectCalendarInfo;
    }

    @Override
    protected ProjectCalendarEntryCollection _createProjectCalendar(Context ctx, java.util.Date startDate, java.util.Date endDate, String projectCalendarId, boolean isNatureCalendar) throws BOSException, EASBizException {
        ProjectCalendarEntryCollection collection = null;
        collection = isNatureCalendar ? this.getEntryCollection(startDate, endDate, projectCalendarId) : this.getAllWorkDateEntry(startDate, endDate, projectCalendarId);
        ProjectCalendarControllerBean.setWorkDateSeq(1, 1, collection);
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProjectCalendarInfo projectCalendarInfo = (ProjectCalendarInfo)model;
        Connection cn = null;
        IORMappingDAO dao = null;
        boolean isAddNew = true;
        if (projectCalendarInfo.getId() != null) {
            try {
                cn = this.getConnection(ctx);
                this.checkDatas(ctx, projectCalendarInfo);
                ObjectUuidPK retValue = new ObjectUuidPK(projectCalendarInfo.getId());
                ProjectCalendarEntryCollection entrys = projectCalendarInfo.getEntrys();
                this.updateProjectCalendar(ctx, projectCalendarInfo);
                if (entrys != null) {
                    dao = ORMappingDAO.getInstance((BOSObjectType)BOSObjectType.create((String)"82D0C566"), (Context)ctx, (Connection)cn);
                    for (int i = 0; i < entrys.size(); ++i) {
                        ProjectCalendarEntryInfo entryInfo = entrys.get(i);
                        entryInfo.setParent(projectCalendarInfo);
                        if (entryInfo.getId() == null) {
                            dao.addNewBatch((IObjectValue)entryInfo);
                            continue;
                        }
                        isAddNew = false;
                        dao.updateBatch((IObjectPK)new ObjectUuidPK(entryInfo.getId().toString()), (IObjectValue)entryInfo);
                    }
                    dao.executeBatch();
                    if (entrys.size() > 0) {
                        this.updateWorkDateSeq(ctx, projectCalendarInfo.getId().toString());
                    }
                }
                ObjectUuidPK objectUuidPK = retValue;
                return objectUuidPK;
            }
            finally {
                SQLUtils.cleanup((Connection)cn);
            }
        }
        ProjectCalendarControllerBean.setWorkDateSeq(1, 1, projectCalendarInfo.getEntrys());
        return super._submit(ctx, model);
    }

    private void checkDatas(Context ctx, ProjectCalendarInfo vo) throws BOSException, EASBizException {
        ProjectCalendarEntryInfo entryInfo;
        if (vo == null) {
            return;
        }
        StringBuffer errBuff = new StringBuffer(500);
        String strPath = "com.kingdee.eas.mm.basedata.FactoryCalendarResource";
        ProjectCalendarEntryCollection entrys = vo.getEntrys();
        String projectCalendarId = null;
        projectCalendarId = vo.getId().toString();
        if (entrys.size() > 0 && (entryInfo = entrys.get(0)).getId() == null) {
            java.util.Date workDate = entryInfo.getWorkDate();
            Calendar cal = Calendar.getInstance();
            cal.setTime(workDate);
            int year = cal.get(1);
            if (!this.isContinuumDate(ctx, year, projectCalendarId)) {
                errBuff.append(year);
                errBuff.append(ResourceBase.getString((String)strPath, (String)"skipYear", (Locale)ctx.getLocale()) + "\n");
            }
        }
        if (errBuff.toString().length() > 0) {
            throw new FactoryCalendarRuleException(FactoryCalendarRuleException.BLANK, (Object[])new String[]{errBuff.toString()});
        }
    }

    private boolean isContinuumDate(Context ctx, int year, String projectCalendarId) throws BOSException {
        Map map = this._getStartAndEndDateByID(ctx, projectCalendarId);
        int startYear = (Integer)map.get("startYear");
        int endYear = (Integer)map.get("endYear");
        if (year < startYear && startYear - year > 2) {
            year = startYear - 1;
            return false;
        }
        if (year > endYear && year - endYear > 2) {
            year = endYear + 1;
            return false;
        }
        return true;
    }

    @Override
    protected Map _getStartAndEndDateByID(Context ctx, String projectCalendarId) throws BOSException {
        HashMap<String, Integer> yearMap = new HashMap<String, Integer>();
        StringBuffer sb = new StringBuffer();
        Date startDate = null;
        Date endDate = null;
        sb.append("select min(p.fworkdate) as startDate, max(p.fworkdate) as endDate ");
        sb.append(" from t_mm_projectcalendarentry p where p.fparentid = '").append(projectCalendarId).append("'");
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            while (set.next()) {
                startDate = set.getDate("startDate");
                endDate = set.getDate("endDate");
            }
            if (startDate == null) {
                return yearMap;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(startDate);
            int startYear = cal.get(1);
            cal.setTime(endDate);
            int endYear = cal.get(1);
            yearMap.put("startYear", new Integer(startYear));
            yearMap.put("endYear", new Integer(endYear));
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return yearMap;
    }

    @Override
    protected boolean _delEntrysByYear(Context ctx, String projectCalendarId, int year) throws BOSException, EASBizException {
        if (projectCalendarId == null || year == 0) {
            return true;
        }
        Connection con = this.getConnection(ctx);
        PreparedStatement ps = null;
        IRowSet rs = null;
        Calendar col = Calendar.getInstance();
        col.set(year, 0, 1);
        java.util.Date startDate = col.getTime();
        col.set(year + 1, 0, 1);
        java.util.Date endDate = col.getTime();
        boolean isHaveEntry = false;
        StringBuffer strSql = new StringBuffer();
        strSql.append("delete t_mm_projectCalendarEntry where  fparentid ='");
        strSql.append(projectCalendarId);
        strSql.append("' and FWorkDate>= ? ");
        strSql.append(" and  FWorkDate<? ");
        try {
            ps = con.prepareStatement(strSql.toString());
            ps.setDate(1, new Date(startDate.getTime()));
            ps.setDate(2, new Date(endDate.getTime()));
            ps.executeQuery();
            strSql.setLength(0);
            strSql.append("select top 1 fid from t_mm_projectCalendarEntry  where fparentid = '");
            strSql.append(projectCalendarId).append("'");
            rs = DbUtil.executeQuery((Context)ctx, (String)strSql.toString());
            if (rs.next()) {
                isHaveEntry = true;
            }
            if (isHaveEntry) {
                this.updateWorkDateSeq(ctx, projectCalendarId);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup((Statement)ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Statement)ps, (Connection)con);
        return isHaveEntry;
    }

    private void updateWorkDateSeq(Context ctx, String projectCalendarId) throws BOSException, EASBizException {
        if (projectCalendarId == null) {
            return;
        }
        Connection con = null;
        PreparedStatement ps = null;
        IRowSet rs = null;
        con = this.getConnection(ctx);
        try {
            StringBuffer strBuffSql = new StringBuffer("select ce.FId as FEntryId,ce.FWorkDate,ce.FDateType from T_MM_ProjectCalendar c right join t_mm_projectcalendarentry  ce on c.fid=ce.fparentid where c.fid='");
            strBuffSql.append(projectCalendarId);
            strBuffSql.append("'");
            strBuffSql.append(" order by ce.FWorkDate ");
            rs = DbUtil.executeQuery((Context)ctx, (String)strBuffSql.toString());
            strBuffSql = null;
            Vector<String> vec = new Vector<String>();
            Vector<Date> vecWorkDate = new Vector<Date>();
            Vector<Integer> vecDateType = new Vector<Integer>();
            while (rs.next()) {
                String strEntryId = rs.getString("FEntryId");
                vec.add(strEntryId);
                Date date = rs.getDate("FWorkDate");
                vecWorkDate.add(date);
                int dateType = rs.getInt("FDateType");
                vecDateType.add(new Integer(dateType));
            }
            rs.close();
            String sql = "update t_mm_projectcalendarentry set fworkdateseq = ?, FYearSeq=?,FMonthSeq=?,FWeekSeq=?,FNextWorkDaySeq=?,FPreWorkDaySeq=?,FSeq = ? where FId= ? ";
            ps = con.prepareStatement(sql);
            java.util.Date currDate = null;
            java.util.Date preCurrDate = null;
            int seq = 1;
            int yearSeq = 1;
            int monthSeq = 1;
            int weekSeq = 1;
            int workDateSeq = 1;
            for (int i = 0; i < vec.size(); ++i) {
                String strId = (String)vec.get(i);
                currDate = (java.util.Date)vecWorkDate.get(i);
                if (i > 0) {
                    boolean isSameWeek;
                    boolean isSameMonth;
                    boolean isSameYear = FactoryCalendarUtils.isSameYear((java.util.Date)preCurrDate, (java.util.Date)currDate);
                    if (!isSameYear) {
                        ++yearSeq;
                    }
                    if (!(isSameMonth = FactoryCalendarUtils.isSameMonth((java.util.Date)preCurrDate, (java.util.Date)currDate))) {
                        ++monthSeq;
                    }
                    if (!(isSameWeek = FactoryCalendarUtils.isSameWeek((java.util.Date)preCurrDate, (java.util.Date)currDate))) {
                        ++weekSeq;
                    }
                }
                preCurrDate = currDate;
                int dateType = (Integer)vecDateType.get(i);
                int index = 1;
                if (dateType == 1) {
                    ps.setInt(index++, workDateSeq);
                } else {
                    ps.setInt(index++, 0);
                }
                ps.setInt(index++, yearSeq);
                ps.setInt(index++, monthSeq);
                ps.setInt(index++, weekSeq);
                if (dateType == 1) {
                    ps.setInt(index++, workDateSeq + 1);
                    ps.setInt(index++, workDateSeq - 1);
                    ++workDateSeq;
                } else {
                    ps.setInt(index++, workDateSeq);
                    ps.setInt(index++, workDateSeq - 1);
                }
                ps.setInt(index++, seq++);
                ps.setString(index++, strId);
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException er) {
            try {
                throw new BOSException("sql Execute Error :", (Throwable)er);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup(ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Statement)ps, (Connection)con);
    }

    private void updateProjectCalendar(Context ctx, ProjectCalendarInfo projectCalendarInfo) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        sb.append("update  t_mm_projectcalendar  set  fissunrest = ? , fismonrest = ?,");
        sb.append(" fistuerest = ? ,fiswedrest = ? ,fisthurest = ? ,fisfrirest= ? ,fissatrest = ? ");
        sb.append(" where fid = '").append(projectCalendarInfo.getId().toString()).append("'");
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(ctx);
            ps = con.prepareStatement(sb.toString());
            int index = 1;
            ps.setInt(index++, this.booleanToint(projectCalendarInfo.isIsSunRest()));
            ps.setInt(index++, this.booleanToint(projectCalendarInfo.isIsMonRest()));
            ps.setInt(index++, this.booleanToint(projectCalendarInfo.isIsTueRest()));
            ps.setInt(index++, this.booleanToint(projectCalendarInfo.isIsWedRest()));
            ps.setInt(index++, this.booleanToint(projectCalendarInfo.isIsThuRest()));
            ps.setInt(index++, this.booleanToint(projectCalendarInfo.isIsFriRest()));
            ps.setInt(index++, this.booleanToint(projectCalendarInfo.isIsSatRest()));
            ps.execute();
        }
        catch (SQLException er) {
            try {
                throw new BOSException("sql Execute Error :", (Throwable)er);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup(ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs);
        SQLUtils.cleanup((Statement)ps, (Connection)con);
    }

    private int booleanToint(boolean isBoolean) {
        if (isBoolean) {
            return 1;
        }
        return 0;
    }
}

