/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.project.ProjectCalendarFactory;
import com.kingdee.eas.mm.project.WBSException;
import com.kingdee.eas.mm.project.app.AbstractProjectCalendarFacadeControllerBean;
import com.kingdee.eas.mm.project.util.MMProjectCalendar;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import org.apache.log4j.Logger;

public class ProjectCalendarFacadeControllerBean
extends AbstractProjectCalendarFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.project.app.ProjectCalendarFacadeControllerBean");

    @Override
    protected ArrayList _getAllFreeDate(Context ctx, String projectId) throws BOSException, EASBizException {
        ArrayList<MMProjectCalendar> results = new ArrayList<MMProjectCalendar>();
        StringBuffer sql = new StringBuffer("");
        ProjectCalendarFactory.getLocalInstance(ctx).getProjectCalendar();
        if (projectId == null) {
            sql.append("select entryCalendar.Fworkdateseq as FWorkDateSeq,entryCalendar.Fnextworkdayseq as FNextWorkDaySeq,");
            sql.append(" entryCalendar.FPreWorkDaySeq as FPreWorkDaySeq,entryCalendar.FWorkDate as  FWorkDate ");
            sql.append(" from t_mm_projectcalendarentry entryCalendar where entryCalendar.fparentId = '");
            sql.append("nz4fwnlKQs2UUNYLZfS4U5nUdmw=").append("' and entryCalendar.FWorkDateSeq=0 ");
            sql.append(" order by entryCalendar.FSeq ");
        } else {
            sql.append("select entryCalendar.Fworkdateseq as FWorkDateSeq,entryCalendar.Fnextworkdayseq as FNextWorkDaySeq,");
            sql.append(" entryCalendar.FPreWorkDaySeq as FPreWorkDaySeq,entryCalendar.FWorkDate as  FWorkDate ");
            sql.append(" from t_mm_project project ");
            sql.append("inner join t_mm_projectcalendarentry entryCalendar on project.fprojectcalendarid = entryCalendar.Fparentid ");
            sql.append(" where project.fid =  '");
            sql.append(projectId);
            sql.append("' and entryCalendar.FWorkDateSeq=0 order by entryCalendar.FSeq");
        }
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (set.next()) {
                MMProjectCalendar mmcalendar = new MMProjectCalendar();
                mmcalendar.setSeq(set.getInt("FWorkDateSeq"));
                mmcalendar.setNextSeq(set.getInt("FNextWorkDaySeq"));
                mmcalendar.setPreSeq(set.getInt("FPreWorkDaySeq"));
                mmcalendar.setWorkDate(this.toCalendar(set.getDate("FWorkDate")));
                results.add(mmcalendar);
            }
        }
        catch (SQLException e) {
            new BOSException((Throwable)e);
        }
        return results;
    }

    @Override
    protected ArrayList _getFactoryCalendars(Context ctx, String storageOrgID) throws BOSException, EASBizException {
        ArrayList<MMProjectCalendar> results = new ArrayList<MMProjectCalendar>();
        if (!this.hasProjectCalendar(ctx, storageOrgID)) {
            throw new WBSException(WBSException.HAVE_NO_FACTORYCALENDAR);
        }
        StringBuffer sql = new StringBuffer("");
        sql.append("select T0.FSeq,T0.FWorkDateSeq FWorkDateSeq,T0.FNextWorkDaySeq FNextWorkDaySeq,T0.FPreWorkDaySeq FPreWorkDaySeq,T0.FWorkDate FWorkDate from T_MM_FactoryCalendarEntry T0 ");
        sql.append("inner join T_MM_FactoryCalendar T1 on T0.FParentID=T1.FID ");
        sql.append("where T1.FStorageOrgUnitID = '");
        sql.append(storageOrgID);
        sql.append("' order by T0.FSeq");
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (set.next()) {
                MMProjectCalendar mmcalendar = new MMProjectCalendar();
                mmcalendar.setSeq(set.getInt("FWorkDateSeq"));
                mmcalendar.setNextSeq(set.getInt("FNextWorkDaySeq"));
                mmcalendar.setPreSeq(set.getInt("FPreWorkDaySeq"));
                mmcalendar.setWorkDate(this.toCalendar(set.getTimestamp("FWorkDate")));
                results.add(mmcalendar);
            }
        }
        catch (SQLException e) {
            new BOSException((Throwable)e);
        }
        return results;
    }

    protected boolean hasProjectCalendar(Context ctx, String storageOrgID) throws BOSException, EASBizException {
        String sql = "select FID from T_MM_FactoryCalendar where FStorageOrgUnitID = '" + storageOrgID + "'";
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (set.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    @Override
    protected ArrayList _getProjectCalendars(Context ctx, String projectId) throws BOSException, EASBizException {
        ArrayList<MMProjectCalendar> results = new ArrayList<MMProjectCalendar>();
        StringBuffer sql = new StringBuffer("");
        ProjectCalendarFactory.getLocalInstance(ctx).getProjectCalendar();
        if (projectId == null) {
            sql.append("select entryCalendar.Fworkdateseq as FWorkDateSeq,entryCalendar.Fnextworkdayseq as FNextWorkDaySeq,");
            sql.append(" entryCalendar.FPreWorkDaySeq as FPreWorkDaySeq,entryCalendar.FWorkDate as  FWorkDate ");
            sql.append(" from t_mm_projectcalendarentry entryCalendar where entryCalendar.fparentId = '");
            sql.append("nz4fwnlKQs2UUNYLZfS4U5nUdmw=").append("'  ");
            sql.append(" order by entryCalendar.FSeq ");
        } else {
            sql.append("select entryCalendar.Fworkdateseq as FWorkDateSeq,entryCalendar.Fnextworkdayseq as FNextWorkDaySeq,");
            sql.append(" entryCalendar.FPreWorkDaySeq as FPreWorkDaySeq,entryCalendar.FWorkDate as  FWorkDate ");
            sql.append(" from t_mm_project project ");
            sql.append("inner join t_mm_projectcalendarentry entryCalendar on project.fprojectcalendarid = entryCalendar.Fparentid ");
            sql.append(" where project.fid =  '");
            sql.append(projectId);
            sql.append("' order by entryCalendar.FSeq");
        }
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (set.next()) {
                MMProjectCalendar mmcalendar = new MMProjectCalendar();
                mmcalendar.setSeq(set.getInt("FWorkDateSeq"));
                mmcalendar.setNextSeq(set.getInt("FNextWorkDaySeq"));
                mmcalendar.setPreSeq(set.getInt("FPreWorkDaySeq"));
                mmcalendar.setWorkDate(this.toCalendar(set.getTimestamp("FWorkDate")));
                results.add(mmcalendar);
            }
        }
        catch (SQLException e) {
            new BOSException((Throwable)e);
        }
        return results;
    }

    public Calendar toCalendar(java.util.Date theDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(theDate);
        return calendar;
    }

    @Override
    protected void _deleteProjectCalendar(Context ctx, String projectCalendarId) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        sb.append("delete t_mm_projectCalendarEntry where fparentid in (").append(projectCalendarId).append(")");
        DbUtil.execute((Context)ctx, (String)sb.toString());
        sb.setLength(0);
        sb.append(" delete t_mm_projectCalendar where fid in (").append(projectCalendarId).append(")");
        DbUtil.execute((Context)ctx, (String)sb.toString());
        sb.setLength(0);
        sb.append("  delete t_mm_projectCalendarRuleEntry   where fparentid in ");
        sb.append(" (select fid    from t_mm_projectCalendarRule where fprojectCalendarid in (");
        sb.append(projectCalendarId).append("))");
        DbUtil.execute((Context)ctx, (String)sb.toString());
        sb.setLength(0);
        sb.append("delete t_mm_projectCalendarRule where fprojectCalendarid in (").append(projectCalendarId).append(")");
        DbUtil.execute((Context)ctx, (String)sb.toString());
    }

    @Override
    protected int _getTotalValidWorkDate(Context ctx, String projectCalendarId, java.util.Date startDate, java.util.Date endDate) throws BOSException, EASBizException {
        int totalValidWorkDate = 0;
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(ctx);
            StringBuffer strBuffSql = new StringBuffer();
            strBuffSql.append("select calEntry.Fid as entryId , calEntry.FDateType as DateType ");
            strBuffSql.append(" from  t_Mm_Projectcalendarentry calEntry ");
            strBuffSql.append(" where calEntry.fparentid='").append(projectCalendarId).append("' ");
            Calendar cal = Calendar.getInstance();
            if (startDate != null) {
                cal.setTime(startDate);
                cal.set(10, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                startDate = cal.getTime();
                strBuffSql.append(" and calEntry.FWorkDate>=? ");
            }
            if (endDate != null) {
                cal.setTime(endDate);
                int mm = cal.get(2);
                int yy = cal.get(1);
                if (mm == 11) {
                    ++yy;
                    mm = 0;
                } else {
                    ++mm;
                }
                cal.set(yy, mm, 1, 0, 0, 0);
                endDate = cal.getTime();
                strBuffSql.append(" and calEntry.FWorkDate< ? ");
            }
            strBuffSql.append(" order by calEntry.FWorkDate ");
            ps = con.prepareStatement(strBuffSql.toString());
            int index = 1;
            if (startDate != null) {
                ps.setDate(index++, new Date(startDate.getYear(), startDate.getMonth(), startDate.getDate()));
            }
            if (endDate != null) {
                ps.setDate(index++, new Date(endDate.getYear(), endDate.getMonth(), endDate.getDate()));
            }
            rs = ps.executeQuery();
            int dateType = 0;
            while (rs.next()) {
                dateType = rs.getInt("DateType");
                if (dateType != 1) continue;
                ++totalValidWorkDate;
            }
        }
        catch (SQLException er) {
            try {
                throw new BOSException("sql Execute Error :", (Throwable)er);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup(ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Statement)ps, (Connection)con);
        return totalValidWorkDate;
    }

    @Override
    protected java.util.Date _getEndDateByStartDate(Context ctx, java.util.Date startDate, int totalTime, String projectCalendarId) throws BOSException, EASBizException {
        Date endDate = null;
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(ctx);
            StringBuffer strBuffSql = new StringBuffer();
            strBuffSql.append("select calEntry.Fid as entryId,calEntry.FDateType as DateType,calEntry.FWorkDate as WorkDate");
            strBuffSql.append(" from  t_Mm_Projectcalendarentry calEntry ");
            strBuffSql.append(" where calEntry.fparentid='").append(projectCalendarId).append("' ");
            Calendar cal = Calendar.getInstance();
            if (startDate != null) {
                cal.setTime(startDate);
                cal.set(10, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                startDate = cal.getTime();
                strBuffSql.append(" and calEntry.FWorkDate>=? ");
            }
            strBuffSql.append(" order by calEntry.FWorkDate ");
            ps = con.prepareStatement(strBuffSql.toString());
            int index = 1;
            if (startDate != null) {
                ps.setDate(index++, new Date(startDate.getYear(), startDate.getMonth(), startDate.getDate()));
            }
            rs = ps.executeQuery();
            int dateType = 0;
            int i = 0;
            while (rs.next()) {
                dateType = rs.getInt("DateType");
                if (dateType != 1 || ++i != totalTime) continue;
                endDate = rs.getDate("WorkDate");
            }
        }
        catch (SQLException er) {
            try {
                throw new BOSException("sql Execute Error :", (Throwable)er);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup(ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Statement)ps, (Connection)con);
        return endDate;
    }
}

