/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.FactoryCalendarRuleException;
import com.kingdee.eas.mm.basedata.FactoryCalendarUtils;
import com.kingdee.eas.mm.project.ProjectCalendarRuleCollection;
import com.kingdee.eas.mm.project.ProjectCalendarRuleEntryCollection;
import com.kingdee.eas.mm.project.ProjectCalendarRuleEntryInfo;
import com.kingdee.eas.mm.project.ProjectCalendarRuleInfo;
import com.kingdee.eas.mm.project.app.AbstractProjectCalendarRuleControllerBean;
import com.kingdee.eas.util.ResourceBase;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ProjectCalendarRuleControllerBean
extends AbstractProjectCalendarRuleControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.project.app.ProjectCalendarRuleControllerBean");

    @Override
    protected IObjectCollection _getValueByStorageOrgUnit(Context ctx, String projectCalendarId) throws BOSException, EASBizException {
        ProjectCalendarRuleCollection projectCalendarRuleCollection = new ProjectCalendarRuleCollection();
        if (projectCalendarId == null || projectCalendarId.trim().length() == 0) {
            return projectCalendarRuleCollection;
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("projectCalendar.id", (Object)projectCalendarId, CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        entityViewInfo.getSelector().add(new SelectorItemInfo("id"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("projectCalendar"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("projectCalendar.id"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("projectCalendar.number"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("entrys.*"));
        projectCalendarRuleCollection = this.getProjectCalendarRuleCollection(ctx, entityViewInfo);
        return projectCalendarRuleCollection;
    }

    private void checkMonthOrDay(Context ctx, ProjectCalendarRuleInfo vo) throws BOSException, EASBizException {
        if (vo == null) {
            return;
        }
        StringBuffer errBuff = new StringBuffer(500);
        String strPath = "com.kingdee.eas.mm.basedata.FactoryCalendarResource";
        ProjectCalendarRuleEntryCollection entrys = vo.getEntrys();
        int size = entrys.size();
        if (size == 0) {
            errBuff.append(ResourceBase.getString((String)strPath, (String)"line_NotNUll", (Locale)ctx.getLocale()) + "\n");
        }
        StringBuffer buffer = new StringBuffer();
        String strNo = ResourceBase.getString((String)strPath, (String)"entry", (Locale)ctx.getLocale());
        int cycSign = -1;
        block6: for (int i = 0; i < size; ++i) {
            ProjectCalendarRuleEntryInfo entryInfo = entrys.get(i);
            int seq = i + 1;
            if (entryInfo.getCycSign() == null) {
                errBuff.append(strNo);
                errBuff.append(seq);
                errBuff.append(ResourceBase.getString((String)strPath, (String)"cyc_SignNotPUt", (Locale)ctx.getLocale()) + "\n");
            } else {
                cycSign = entryInfo.getCycSign().getValue();
            }
            int month = entryInfo.getMonth();
            int day = entryInfo.getDay();
            int series = entryInfo.getSeriesDays();
            switch (cycSign) {
                case 40: {
                    boolean isYes;
                    if (month < 1 || month > 12) {
                        errBuff.append(strNo);
                        errBuff.append(seq);
                        errBuff.append(ResourceBase.getString((String)strPath, (String)"MONTH_YEAR", (Locale)ctx.getLocale()) + "\n");
                    }
                    if (!(isYes = FactoryCalendarUtils.isDateTrue((int)month, (int)day))) {
                        errBuff.append(strNo);
                        errBuff.append(seq);
                        errBuff.append(ResourceBase.getString((String)strPath, (String)"DAY_CURR", (Locale)ctx.getLocale()) + "\n");
                    }
                    if (series >= 1 && series <= 365) continue block6;
                    errBuff.append(strNo);
                    errBuff.append(seq);
                    errBuff.append(ResourceBase.getString((String)strPath, (String)"SERIES_YEAR", (Locale)ctx.getLocale()) + "\n");
                    continue block6;
                }
                case 20: {
                    boolean isYes;
                    if (month < 0 || month > 12) {
                        errBuff.append(strNo);
                        errBuff.append(seq);
                        errBuff.append(ResourceBase.getString((String)strPath, (String)"MONTH_ERR", (Locale)ctx.getLocale()) + "\n");
                    }
                    if (month == 0) {
                        if ((day < 1 || day > 31) && day != 99) {
                            errBuff.append(strNo);
                            errBuff.append(seq);
                            errBuff.append(ResourceBase.getString((String)strPath, (String)"DAY_EVERY", (Locale)ctx.getLocale()) + "\n");
                        }
                    } else {
                        isYes = FactoryCalendarUtils.isDateTrue((int)month, (int)day);
                        if (!isYes && day != 99) {
                            errBuff.append(strNo);
                            errBuff.append(seq);
                            errBuff.append(ResourceBase.getString((String)strPath, (String)"DAY_CURR", (Locale)ctx.getLocale()) + "\n");
                        }
                    }
                    if (series >= 1 && series <= 31) continue block6;
                    errBuff.append(strNo);
                    errBuff.append(seq);
                    errBuff.append(ResourceBase.getString((String)strPath, (String)"SERIES", (Locale)ctx.getLocale()) + "\n");
                    continue block6;
                }
                case 30: {
                    boolean isYes;
                    if (month < 1 || month > 3) {
                        errBuff.append(strNo);
                        errBuff.append(seq);
                        errBuff.append(ResourceBase.getString((String)strPath, (String)"MONTH_SEAON", (Locale)ctx.getLocale()) + "\n");
                    }
                    if (!(isYes = FactoryCalendarUtils.isDateTrue((int)month, (int)day)) && day != 99) {
                        errBuff.append(strNo);
                        errBuff.append(seq);
                        errBuff.append(ResourceBase.getString((String)strPath, (String)"DAY_EVERY", (Locale)ctx.getLocale()) + "\n");
                    }
                    if (series >= 1 && series <= 31) continue block6;
                    errBuff.append(strNo);
                    errBuff.append(seq);
                    errBuff.append(ResourceBase.getString((String)strPath, (String)"SERIES", (Locale)ctx.getLocale()) + "\n");
                    continue block6;
                }
                case 10: {
                    if (month < 0 || month > 12) {
                        errBuff.append(strNo);
                        errBuff.append(seq);
                        errBuff.append(ResourceBase.getString((String)strPath, (String)"MONTH_ERR", (Locale)ctx.getLocale()) + "\n");
                    }
                    if (day < 1 || day > 7) {
                        errBuff.append(strNo);
                        errBuff.append(seq);
                        errBuff.append(ResourceBase.getString((String)strPath, (String)"DAY_WEEK", (Locale)ctx.getLocale()) + "\n");
                    }
                    if (series >= 1 && series <= 7) continue block6;
                    errBuff.append(strNo);
                    errBuff.append(seq);
                    errBuff.append(ResourceBase.getString((String)strPath, (String)"SERIES_WEEK", (Locale)ctx.getLocale()) + "\n");
                    continue block6;
                }
            }
        }
        if (errBuff.toString().length() > 0) {
            throw new FactoryCalendarRuleException(FactoryCalendarRuleException.BLANK, (Object[])new String[]{errBuff.toString()});
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkMonthOrDay(ctx, (ProjectCalendarRuleInfo)model);
        return super._submit(ctx, model);
    }

    @Override
    protected void _verify(Context ctx, IObjectValue objectValue) throws BOSException, EASBizException {
        this.checkMonthOrDay(ctx, (ProjectCalendarRuleInfo)objectValue);
    }
}

