/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectReferedException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.ejb.BizController;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICostObject;
import com.kingdee.eas.basedata.assistant.IProject;
import com.kingdee.eas.basedata.assistant.ProjectStatus;
import com.kingdee.eas.basedata.assistant.app.ProjectRef;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.INewOrgUnitFacade;
import com.kingdee.eas.basedata.org.NewOrgUnitFacadeFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.BizReferenceException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.app.dao.ReferenceDAO;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.dynbusiness.IBatchExecute;
import com.kingdee.eas.dynbusiness.app.DynamicBusinessProcessHelper;
import com.kingdee.eas.dynbusiness.app.GeneralBusinessProcessorBuilder;
import com.kingdee.eas.dynbusiness.app.IBusinessProcessorBuilder;
import com.kingdee.eas.dynbusiness.app.processor.BillsExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.GeneralBusinessProcessor;
import com.kingdee.eas.emm.basedata.projectjch.ProjectJCHFactory;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.LineResult;
import com.kingdee.eas.framework.Result;
import com.kingdee.eas.framework.batchaction.ActionResult;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.industry.emm.imm.ProjectAppSaleContractCollection;
import com.kingdee.eas.industry.emm.imm.ProjectAppSaleContractFactory;
import com.kingdee.eas.industry.emm.imm.ProjectAppSaleOrderCollection;
import com.kingdee.eas.industry.emm.imm.ProjectAppSaleOrderFactory;
import com.kingdee.eas.industry.emm.imm.ProjectApprovingInfo;
import com.kingdee.eas.mm.basedata.BomFactory;
import com.kingdee.eas.mm.basedata.IBom;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.MMBaseException;
import com.kingdee.eas.mm.common.MMBaseStatusEnum;
import com.kingdee.eas.mm.common.app.CodingRulerSrvHelper;
import com.kingdee.eas.mm.common.app.CommonUtils;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.project.IProjectCalendar;
import com.kingdee.eas.mm.project.IProjectGroup;
import com.kingdee.eas.mm.project.ProjectCalendarFacadeFactory;
import com.kingdee.eas.mm.project.ProjectCalendarFactory;
import com.kingdee.eas.mm.project.ProjectCalendarInfo;
import com.kingdee.eas.mm.project.ProjectCarCollection;
import com.kingdee.eas.mm.project.ProjectCarFactory;
import com.kingdee.eas.mm.project.ProjectCarInfo;
import com.kingdee.eas.mm.project.ProjectCentralPurOrgFactory;
import com.kingdee.eas.mm.project.ProjectCollection;
import com.kingdee.eas.mm.project.ProjectDictDataInfo;
import com.kingdee.eas.mm.project.ProjectException;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.mm.project.ProjectGroupFactory;
import com.kingdee.eas.mm.project.ProjectGroupInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.mm.project.ProjectOrgCollection;
import com.kingdee.eas.mm.project.ProjectOrgInfo;
import com.kingdee.eas.mm.project.ProjectPriorityEnum;
import com.kingdee.eas.mm.project.app.AbstractProjectControllerBean;
import com.kingdee.eas.mm.project.util.MMProjectCalendarFactory;
import com.kingdee.eas.scm.common.SDSMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.app.bizprocess.processorbuilder.SCMBusinessProcessorBuilder4common;
import com.kingdee.eas.scm.im.inv.IMaterialRequestBillEntry;
import com.kingdee.eas.scm.im.inv.MaterialRequestBillEntryFactory;
import com.kingdee.eas.scm.sd.sale.ISaleOrderEntry;
import com.kingdee.eas.scm.sd.sale.SaleContractEntryFactory;
import com.kingdee.eas.scm.sd.sale.SaleContractEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.eas.scm.sm.pur.IPurOrderEntry;
import com.kingdee.eas.scm.sm.pur.IPurRequestEntry;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryFactory;
import com.kingdee.eas.util.BizReference;
import com.kingdee.eas.util.IndustryUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.zjbom.DesignBOMBillFactory;
import com.kingdee.eas.zjbom.DesignBOMMiddleBillFactory;
import com.kingdee.eas.zjbom.IDesignBOMBill;
import com.kingdee.eas.zjbom.IDesignBOMMiddleBill;
import com.kingdee.eas.zjbom.IProcessBomBill;
import com.kingdee.eas.zjbom.ProcessBomBillFactory;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.NumericExceptionSubItem;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringEscapeUtils;

public class ProjectControllerBean
extends AbstractProjectControllerBean
implements IBatchExecute {
    private static final long serialVersionUID = -693086129247488724L;

    public static String getResource(Context ctx, String strKey) {
        String strTemp = ResourceBase.getString((String)"com.kingdee.eas.mm.project.ProjectResource", (String)strKey, (Locale)ctx.getLocale());
        return strTemp;
    }

    public void batchAfterAudit(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        for (BatchExecuteParamsEntry entrie : entries) {
            TrackNumberInfo minTrackNumberInfo;
            ProjectCarInfo projectCarInfo;
            String projectID;
            IObjectPK pk = (IObjectPK)entrie.get(0);
            ProjectInfo projectInfo = ProjectFactory.getLocalInstance(ctx).getProjectInfo(pk);
            String string = projectInfo == null ? null : (projectID = projectInfo.getId() == null ? null : projectInfo.getId().toString());
            if (projectID == null || projectInfo.get("projectApp") == null) continue;
            EntityViewInfo projectCarEntityViewInfo = new EntityViewInfo();
            FilterInfo projectCarFilterInfo = new FilterInfo();
            SelectorItemCollection projectCarSelectorItemCollection = new SelectorItemCollection();
            SorterItemCollection projectCarSorterItemCollection = new SorterItemCollection();
            projectCarFilterInfo.getFilterItems().add(new FilterItemInfo("project.id", (Object)projectID, CompareType.EQUALS));
            projectCarSelectorItemCollection.add(new SelectorItemInfo("id"));
            projectCarSelectorItemCollection.add(new SelectorItemInfo("project.id"));
            projectCarSelectorItemCollection.add(new SelectorItemInfo("trackNumber.id"));
            projectCarSelectorItemCollection.add(new SelectorItemInfo("trackNumber.number"));
            projectCarSelectorItemCollection.add(new SelectorItemInfo("trackNumber.name"));
            projectCarSorterItemCollection.add(new SorterItemInfo("trackNumber.number"));
            projectCarEntityViewInfo.setFilter(projectCarFilterInfo);
            projectCarEntityViewInfo.setSelector(projectCarSelectorItemCollection);
            projectCarEntityViewInfo.setSorter(projectCarSorterItemCollection);
            ProjectCarCollection projectCarCollection = ProjectCarFactory.getLocalInstance(ctx).getProjectCarCollection(projectCarEntityViewInfo);
            ProjectCarInfo projectCarInfo2 = projectCarCollection == null ? null : (projectCarInfo = projectCarCollection.size() == 0 ? null : projectCarCollection.get(0));
            TrackNumberInfo trackNumberInfo = projectCarInfo == null ? null : (minTrackNumberInfo = projectCarInfo.getTrackNumber() == null ? null : projectCarInfo.getTrackNumber());
            String minTrackNumberID = minTrackNumberInfo == null ? null : (minTrackNumberInfo.getId() == null ? null : minTrackNumberInfo.getId().toString());
            ProjectApprovingInfo projectAppInfo = (ProjectApprovingInfo)projectInfo.get("projectApp");
            EntityViewInfo entityInfo = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("projectApp.id");
            sic.add("SaleContractEntry.parent.id");
            sic.add("SaleContractEntry.parent.number");
            sic.add("SaleContractEntry.id");
            sic.add("SaleContractEntry.seq");
            sic.add("SaleContractEntry.material.id");
            sic.add("SaleContractEntry.material.name");
            sic.add("SaleContractEntry.material.number");
            sic.add("SaleContractEntry.unit.id");
            sic.add("SaleContractEntry.unit.number");
            sic.add("SaleContractEntry.unit.name");
            sic.add("SaleContractEntry.project.id");
            sic.add("SaleContractEntry.project.number");
            sic.add("SaleContractEntry.project.name");
            entityInfo.setSelector(sic);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("projectApp.id", (Object)projectAppInfo.getId()));
            entityInfo.setFilter(filter);
            ProjectAppSaleContractCollection projectAppColl = ProjectAppSaleContractFactory.getLocalInstance((Context)ctx).getProjectAppSaleContractCollection(entityInfo);
            if (projectAppColl.size() > 0) {
                for (int j = 0; j < projectAppColl.size(); ++j) {
                    SaleContractEntryInfo saleEntryInfo = projectAppColl.get(j).getSaleContractEntry();
                    saleEntryInfo.setProject(projectInfo);
                    SaleContractEntryFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectUuidPK(saleEntryInfo.getId()), (SDSMBillEntryBaseInfo)saleEntryInfo);
                }
            }
            new EntityViewInfo();
            new SelectorItemCollection();
            sic.add("projectApp.id");
            sic.add("SaleOrderEntry.parent.id");
            sic.add("SaleOrderEntry.parent.number");
            sic.add("SaleOrderEntry.id");
            sic.add("SaleOrderEntry.seq");
            sic.add("SaleOrderEntry.material.id");
            sic.add("SaleOrderEntry.material.name");
            sic.add("SaleOrderEntry.material.number");
            sic.add("SaleOrderEntry.unit.id");
            sic.add("SaleOrderEntry.unit.number");
            sic.add("SaleOrderEntry.unit.name");
            sic.add("SaleOrderEntry.project.id");
            sic.add("SaleOrderEntry.project.number");
            sic.add("SaleOrderEntry.project.name");
            sic.add("SaleOrderEntry.trackNumber.id");
            sic.add("SaleOrderEntry.trackNumber.number");
            sic.add("SaleOrderEntry.trackNumber.name");
            entityInfo.setSelector(sic);
            FilterInfo oderfilter = new FilterInfo();
            oderfilter.getFilterItems().add(new FilterItemInfo("projectApp.id", (Object)projectAppInfo.getId()));
            entityInfo.setFilter(oderfilter);
            ProjectAppSaleOrderCollection projectAppOrderColl = ProjectAppSaleOrderFactory.getLocalInstance((Context)ctx).getProjectAppSaleOrderCollection(entityInfo);
            ArrayList<String> saleOrderIDList = new ArrayList<String>();
            if (projectAppOrderColl.size() > 0) {
                for (int j = 0; j < projectAppOrderColl.size(); ++j) {
                    String saleOrderID;
                    SaleOrderInfo saleOrderInfo;
                    SaleOrderEntryInfo saleEntryInfo = projectAppOrderColl.get(j).getSaleOrderEntry();
                    SaleOrderInfo saleOrderInfo2 = saleOrderInfo = saleEntryInfo == null ? null : saleEntryInfo.getParent();
                    String string2 = saleOrderInfo == null ? null : (saleOrderID = saleOrderInfo.getId() == null ? null : saleOrderInfo.getId().toString());
                    if (saleOrderID != null && !saleOrderIDList.contains(saleOrderID)) {
                        saleOrderIDList.add(saleOrderID);
                    }
                    saleEntryInfo.setProject(projectInfo);
                    saleEntryInfo.setTrackNumber(minTrackNumberInfo);
                    SaleOrderEntryFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectUuidPK(saleEntryInfo.getId()), (CoreBaseInfo)saleEntryInfo);
                }
            }
            if (saleOrderIDList.size() <= 0 || projectID == null || minTrackNumberID == null) continue;
            StringBuffer sql = new StringBuffer();
            sql.setLength(0);
            sql.append("Update T_SD_SaleOrderEntry UT\r\n");
            sql.append("Set\r\n");
            sql.append("FProjectID='").append(projectID).append("',\r\n");
            sql.append("FTrackNumberID='").append(minTrackNumberID).append("'\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And UT.FParentID In (\r\n");
            sql.append(SQLUtil.arrayToString((Object[])saleOrderIDList.toArray()));
            sql.append(")\r\n");
            sql.append("And UT.FProjectID Is Null\r\n");
            int effectedRows = SQLUtils.execute((Context)ctx, (String)sql.toString());
            System.out.println("Execute SQL Effected Rows: " + effectedRows + "\r\n" + sql.toString());
        }
    }

    public void batchAfterUnAudit(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        for (BatchExecuteParamsEntry entrie : entries) {
            IObjectPK pk = (IObjectPK)entrie.get(0);
            ProjectInfo projectInfo = ProjectFactory.getLocalInstance(ctx).getProjectInfo(pk);
            if (projectInfo.get("projectApp") == null) continue;
            ProjectApprovingInfo projectAppInfo = (ProjectApprovingInfo)projectInfo.get("projectApp");
            EntityViewInfo entityInfo = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("projectApp.id");
            sic.add("SaleContractEntry.parent.id");
            sic.add("SaleContractEntry.parent.number");
            sic.add("SaleContractEntry.id");
            sic.add("SaleContractEntry.seq");
            sic.add("SaleContractEntry.material.id");
            sic.add("SaleContractEntry.material.name");
            sic.add("SaleContractEntry.material.number");
            sic.add("SaleContractEntry.unit.id");
            sic.add("SaleContractEntry.unit.number");
            sic.add("SaleContractEntry.unit.name");
            sic.add("SaleContractEntry.project.id");
            sic.add("SaleContractEntry.project.number");
            sic.add("SaleContractEntry.project.name");
            entityInfo.setSelector(sic);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("projectApp.id", (Object)projectAppInfo.getId()));
            entityInfo.setFilter(filter);
            ProjectAppSaleContractCollection projectAppColl = ProjectAppSaleContractFactory.getLocalInstance((Context)ctx).getProjectAppSaleContractCollection(entityInfo);
            if (projectAppColl.size() > 0) {
                for (int j = 0; j < projectAppColl.size(); ++j) {
                    SaleContractEntryInfo saleEntryInfo = projectAppColl.get(j).getSaleContractEntry();
                    saleEntryInfo.setProject(null);
                    SaleContractEntryFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectUuidPK(saleEntryInfo.getId()), (SDSMBillEntryBaseInfo)saleEntryInfo);
                }
            }
            new EntityViewInfo();
            new SelectorItemCollection();
            sic.add("projectApp.id");
            sic.add("SaleOrderEntry.parent.id");
            sic.add("SaleOrderEntry.parent.number");
            sic.add("SaleOrderEntry.id");
            sic.add("SaleOrderEntry.seq");
            sic.add("SaleOrderEntry.material.id");
            sic.add("SaleOrderEntry.material.name");
            sic.add("SaleOrderEntry.material.number");
            sic.add("SaleOrderEntry.unit.id");
            sic.add("SaleOrderEntry.unit.number");
            sic.add("SaleOrderEntry.unit.name");
            sic.add("SaleOrderEntry.project.id");
            sic.add("SaleOrderEntry.project.number");
            sic.add("SaleOrderEntry.project.name");
            entityInfo.setSelector(sic);
            FilterInfo oderfilter = new FilterInfo();
            oderfilter.getFilterItems().add(new FilterItemInfo("projectApp.id", (Object)projectAppInfo.getId()));
            entityInfo.setFilter(oderfilter);
            ProjectAppSaleOrderCollection projectAppOrderColl = ProjectAppSaleOrderFactory.getLocalInstance((Context)ctx).getProjectAppSaleOrderCollection(entityInfo);
            if (projectAppOrderColl.size() <= 0) continue;
            for (int j = 0; j < projectAppOrderColl.size(); ++j) {
                SaleOrderEntryInfo saleEntryInfo = projectAppOrderColl.get(j).getSaleOrderEntry();
                saleEntryInfo.setProject(null);
                SaleOrderEntryFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectUuidPK(saleEntryInfo.getId()), (CoreBaseInfo)saleEntryInfo);
            }
        }
    }

    public BatchActionResults batchAudit(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        BatchActionResults batchAction = this.batchExecute(ctx, entries, BatchActionEnum.AUDIT);
        this.batchAfterAudit(ctx, entries);
        return batchAction;
    }

    public void batchCheck(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException, EASBizException {
        String[] ids = batchResults.getToDoIdsArray();
        List idList = batchResults.getToDoIdsList();
        this.checkProjectInChanging(ctx, batchResults);
        if (batchAction.equals((Object)BatchActionEnum.DELETE)) {
            StringBuffer deleteSql = new StringBuffer();
            deleteSql.append("delete t_mm_projecttask where fprojectid in ( select fid from t_mm_project where FBaseStatus in (1,2) and fid in ( ");
            deleteSql.append(SQLUtil.arrayToString((Object[])batchResults.getToDoIdsArray()));
            deleteSql.append(") )");
            DbUtil.execute((Context)ctx, (String)deleteSql.toString());
            this.refCheck(ctx, batchResults);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("IDList", idList);
            params.put("Action", "Delete");
            this.dataCheck(ctx, params);
        }
        if (batchAction.equals((Object)BatchActionEnum.SUBMIT)) {
            this.submitCheck(ctx, ids, batchResults);
        }
        if (batchAction.equals((Object)BatchActionEnum.AUDIT)) {
            this.checkPlanDataIsExitProjectCalendar(ctx, batchResults);
            this.projectAuditInsertIntoTBDproject(ctx, batchResults);
            this.auditAfterInsertTOTask(ctx, ids);
        }
        if (batchAction.equals((Object)BatchActionEnum.UNAUDIT)) {
            this.checkTaskIsExitProject(ctx, batchResults);
            this.checkProjectUNAudit(ctx, batchResults);
        }
        if (batchAction.equals((Object)new BatchActionEnum("PRJ_CLOSE"))) {
            this.checkProjectTaskIsClose(ctx, batchResults);
        }
        if (batchAction.equals((Object)new BatchActionEnum("PRJ_UNCLOSE"))) {
            this.checkProjectUNClose(ctx, batchResults);
        }
    }

    public BatchActionResults batchClose(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, new BatchActionEnum("PRJ_CLOSE"));
    }

    public BatchActionResults batchDelete(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, BatchActionEnum.DELETE);
    }

    public BatchActionResults batchDisable(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, new BatchActionEnum("DISABLE"));
    }

    public BatchActionResults batchEnable(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, new BatchActionEnum("ENABLE"));
    }

    public void batchExecute(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException, EASBizException {
        IRowSet rs;
        HashSet<String> pids;
        StringBuffer closeoff;
        boolean isSystem = this.getSystemParams(ctx);
        Object[] ids = batchResults.getToDoIdsArray();
        if (batchAction.equals((Object)BatchActionEnum.SAVE) || batchAction.equals((Object)BatchActionEnum.SUBMIT)) {
            this.checkWbsRule(ctx, (String[])ids);
        }
        if (batchAction.equals((Object)BatchActionEnum.DELETE)) {
            String idStr = SQLUtil.arrayToString((Object[])ids);
            this.delete(ctx, batchResults);
            String billSql = this.getRecycleNumberSQL(idStr);
            CommonUtils.batchRecycleNumber((Context)ctx, (String)billSql, (IObjectValue)this.getBillInstance());
        }
        if (batchAction.equals((Object)new BatchActionEnum("PRJ_CLOSE"))) {
            this.computeTotalDate(ctx, (String[])ids);
            this.aftersetTotaldate(ctx, SQLUtil.arrayToString((Object[])ids), isSystem);
        }
        if (batchAction.equals((Object)new BatchActionEnum("PRJ_UNCLOSE"))) {
            closeoff = new StringBuffer();
            closeoff.append("update T_BD_Project as t0 set Fstatus = 1 where t0.fid in (select t1.FProjectAssistID from t_mm_project t1 where t1.fid in (");
            closeoff.append(SQLUtil.arrayToString((Object[])ids)).append("))");
            DbUtil.execute((Context)ctx, (String)closeoff.toString());
        }
        if (batchAction.equals((Object)BatchActionEnum.AUDIT)) {
            this.insertIntoAssist(ctx, (String[])ids, isSystem);
        }
        if (batchAction.equals((Object)BatchActionEnum.UNAUDIT)) {
            this.projectAssistRefCheck(ctx, batchResults);
        }
        if (batchAction.equals((Object)BatchActionEnum.DISABLE)) {
            closeoff = new StringBuffer();
            closeoff.append("select t1.FProjectAssistID from t_mm_project t1 where t1.fid in (");
            closeoff.append(SQLUtil.arrayToString((Object[])ids)).append(")");
            pids = new HashSet<String>();
            try {
                rs = DbUtil.executeQuery((Context)ctx, (String)closeoff.toString());
                while (rs.next()) {
                    pids.add(rs.getString("FProjectAssistID"));
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            this.setDBProjectStatus(ctx, pids, 2);
        }
        if (batchAction.equals((Object)BatchActionEnum.ENABLE)) {
            closeoff = new StringBuffer();
            closeoff.append("select t1.FProjectAssistID from t_mm_project t1 where t1.fid in (");
            closeoff.append(SQLUtil.arrayToString((Object[])ids)).append(")");
            pids = new HashSet();
            try {
                rs = DbUtil.executeQuery((Context)ctx, (String)closeoff.toString());
                while (rs.next()) {
                    pids.add(rs.getString("FProjectAssistID"));
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            this.setDBProjectStatus(ctx, pids, 1);
        }
    }

    public BatchActionResults batchUnAudit(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        BatchActionResults batchResults = this.batchExecute(ctx, entries, BatchActionEnum.UNAUDIT);
        this.batchAfterUnAudit(ctx, entries);
        return batchResults;
    }

    public BatchActionResults batchUnClose(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, new BatchActionEnum("PRJ_UNCLOSE"));
    }

    @Override
    public IObjectValue createNewData(Context ctx, boolean isUseAgent) throws BOSException, EASBizException {
        ProjectInfo project = new ProjectInfo();
        Calendar cal = Calendar.getInstance();
        Timestamp t = new Timestamp(cal.getTimeInMillis());
        project.setCreateTime(new Timestamp(cal.getTimeInMillis()));
        project.setPlanBeginTime(t);
        project.setPlanEndTime(t);
        IProjectCalendar iprojectcalendar = ProjectCalendarFactory.getLocalInstance(ctx);
        iprojectcalendar.getProjectCalendar();
        ProjectCalendarInfo projectcalendarInfo = (ProjectCalendarInfo)iprojectcalendar.getValue((IObjectPK)new ObjectUuidPK("nz4fwnlKQs2UUNYLZfS4U5nUdmw="));
        project.setProjectCalendar(projectcalendarInfo);
        return project;
    }

    private void batchSave(Context ctx, IObjectValue model, BatchActionEnum action) throws BOSException, EASBizException {
        BatchExecuteParamsEntry entry = new BatchExecuteParamsEntry(new Class[]{IObjectValue.class});
        entry.add((Object)model);
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{entry};
        GeneralBusinessProcessorBuilder builder = new GeneralBusinessProcessorBuilder(action, this.getBOSType(), this.getBillTypeId());
        builder.pushXmlFile(this.getBOSType(), this.getXmlFileName(null));
        GeneralBusinessProcessor processor = new GeneralBusinessProcessor(ctx, this.getBOSType(), action, this.getBillTypeId(), OrgType.ControlUnit);
        BatchActionResults batchResults = BatchActionResults.populateActionResults((BatchExecuteParamsEntry[])entries);
        processor.setBatchExecutor((IBatchExecute)this);
        processor.execute(batchResults);
        batchResults.throwExceptions();
    }

    private void changerByProjectCandler(Context ctx, ProjectInfo objectValue) throws BOSException {
        if (objectValue == null) {
            return;
        }
        if ("".equals(objectValue.getNumber().trim())) {
            return;
        }
        if (objectValue.getProjectCalendar() == null || objectValue.getProjectCalendar().getId() == null) {
            return;
        }
        if ("nz4fwnlKQs2UUNYLZfS4U5nUdmw=".equals(objectValue.getProjectCalendar().getId().toString())) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("update t_mm_projectcalendar set fnumber ='");
        sql.append(objectValue.getNumber());
        sql.append("'||'Time' ");
        sql.append(" where fid = '");
        sql.append(objectValue.getProjectCalendar().getId().toString()).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void checkNumber(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProjectInfo prjInfo = (ProjectInfo)model;
        CodingRulerSrvHelper codeHelper = new CodingRulerSrvHelper();
        codeHelper.setBizOrgPropertyName("CU");
        codeHelper.setNumberException((EASBizException)new MMBaseException(MMBaseException.NULL, new Object[]{ProjectControllerBean.getResource(ctx, "PROJECT_NUMBER_CANT_NULL")}));
        codeHelper.checkNumber(ctx, this.getBizInterface(ctx), model, (OrgUnitInfo)prjInfo.getCU());
    }

    private void checkPlanDataIsExitProjectCalendar(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        String[] ids = batchResults.getToDoIdsArray();
        for (int i = 0; i < ids.length; ++i) {
            Timestamp planTime;
            ProjectInfo objectValue = this.getProjectInfo(ctx, (IObjectPK)new ObjectUuidPK(ids[i]));
            String id = objectValue.getId().toString();
            MMProjectCalendarFactory mmCalendarFactory = new MMProjectCalendarFactory(ctx, id);
            if (!mmCalendarFactory.isWorkDay(planTime = objectValue.getPlanBeginTime())) {
                batchResults.addError(ids[i], (Exception)((Object)new ProjectException(ProjectException.PROJECT_PLANDATABEGIN_NOTEXIT)));
            }
            if (mmCalendarFactory.isWorkDay(planTime = objectValue.getPlanEndTime())) continue;
            batchResults.addError(ids[i], (Exception)((Object)new ProjectException(ProjectException.PROJECT_PLANEND_NOT_EXIT)));
        }
    }

    private void checkProjectInChanging(Context ctx, BatchActionResults batchResults) throws BOSException {
        Object[] ids = batchResults.getToDoIdsArray();
        StringBuffer sql = new StringBuffer();
        sql.append("select  fid  from  t_mm_project where fid in  (");
        sql.append(SQLUtil.arrayToString((Object[])ids));
        sql.append(") and FIsChanging = 1");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        ProjectException exception = new ProjectException(ProjectException.PROJECT_INCHANGINGE);
        try {
            while (rs.next()) {
                batchResults.addError(rs.getString("fid"), (Exception)((Object)exception));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private void computeTotalDate(Context ctx, String[] ids) throws BOSException, EASBizException {
        for (int i = 0; i < ids.length; ++i) {
            ObjectUuidPK pk = new ObjectUuidPK(ids[i]);
            ProjectInfo objectValue = this.getProjectInfo(ctx, (IObjectPK)new ObjectUuidPK(ids[i]));
            String id = objectValue.getId().toString();
            MMProjectCalendarFactory mmCalendarFactory = new MMProjectCalendarFactory(ctx, id);
            Timestamp planbeginTime = objectValue.getActualBeginTime();
            Timestamp planEndTime = objectValue.getActualEndTime();
            if (planbeginTime == null || planEndTime == null) continue;
            int total = mmCalendarFactory.getWorklength(planbeginTime, planEndTime);
            objectValue.setActualTotalTime(new BigDecimal(total));
            this.update(ctx, (IObjectPK)pk, objectValue);
        }
    }

    private CurrencyInfo getCompanyOrgUnit2Infoby(Context ctx, String id, String string) throws BOSException, EASBizException {
        CompanyOrgUnitInfo cominfo = null;
        ICompanyOrgUnit icom = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CurrencyInfo baseCurrInfo = null;
        EntityViewInfo viewInfo1 = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("CU", (Object)id, CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        viewInfo1.setFilter(filter);
        CompanyOrgUnitCollection carrys = icom.getCompanyOrgUnitCollection(viewInfo1);
        if (carrys != null && carrys.size() > 0) {
            cominfo = carrys.get(0);
            baseCurrInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(cominfo.getBaseCurrency().getId().toString()));
        }
        return baseCurrInfo;
    }

    private CoreBaseCollection getDataFromBD(Context ctx, String cuid) throws BOSException {
        IProject iproject = com.kingdee.eas.basedata.assistant.ProjectFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo fileter = new FilterInfo();
        fileter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)cuid));
        fileter.getFilterItems().add(new FilterItemInfo("isSysCreate", (Object)Boolean.FALSE));
        fileter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(2), CompareType.NOTEQUALS));
        fileter.getFilterItems().add(new FilterItemInfo("type", (Object)new Integer(3), CompareType.NOTEQUALS));
        view.setFilter(fileter);
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("type"));
        view.getSelector().add(new SelectorItemInfo("status"));
        view.getSelector().add(new SelectorItemInfo("scheduleStartDate"));
        view.getSelector().add(new SelectorItemInfo("schedulEndDate"));
        view.getSelector().add(new SelectorItemInfo("parent.*"));
        view.getSelector().add(new SelectorItemInfo("factStartDate"));
        view.getSelector().add(new SelectorItemInfo("factEndDate"));
        view.getSelector().add(new SelectorItemInfo("process"));
        view.getSelector().add(new SelectorItemInfo("prjManager"));
        view.getSelector().add(new SelectorItemInfo("company"));
        view.getSelector().add(new SelectorItemInfo("isListItem"));
        view.getSelector().add(new SelectorItemInfo("address"));
        view.getSelector().add(new SelectorItemInfo("isSysCreate"));
        view.getSelector().add(new SelectorItemInfo("longNumber"));
        view.getSelector().add(new SelectorItemInfo("cu.*"));
        view.getSorter().add(new SorterItemInfo("isListItem"));
        view.getSorter().add(new SorterItemInfo("longNumber"));
        CoreBaseCollection collection = iproject.getCollection(view);
        return collection;
    }

    private Result getDataFromBDProject(Context ctx, String cuid) throws EASBizException, BOSException {
        int i;
        boolean isSystem = this.getSystemParams(ctx);
        if (!isSystem) {
            return null;
        }
        StorageOrgUnitInfo centralOrgUnit = null;
        String sql = "select TOP 1 fid from  t_org_storage t where t.FControlUnitID ='" + cuid + "'  AND  t.fisbizunit =1";
        IRowSet irowset = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (irowset.size() == 0) {
            throw new EASBizException(new NumericExceptionSubItem("200", "\u5f53\u524d\u7ba1\u7406\u5355\u5143\u4e0b\u6ca1\u6709\u5b9e\u4f53\u5e93\u5b58\u7ec4\u7ec7"));
        }
        try {
            irowset.next();
            centralOrgUnit = new StorageOrgUnitInfo();
            centralOrgUnit.setId(BOSUuid.read((String)irowset.getString("fid")));
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        CoreBaseCollection collection = this.getDataFromBD(ctx, cuid);
        CoreBaseCollection projects = new CoreBaseCollection();
        CoreBaseCollection projectgroups = new CoreBaseCollection();
        com.kingdee.eas.basedata.assistant.ProjectInfo coreBaseInfo = null;
        ProjectInfo project = null;
        HashMap groupmap = new HashMap();
        HashSet set = new HashSet();
        BigDecimal defaultQty = SysConstant.BIGZERO;
        CurrencyInfo currency = this.getCompanyOrgUnit2Infoby(ctx, cuid, "cu");
        ProjectGroupInfo pGroup = new ProjectGroupInfo();
        pGroup.setId(BOSUuid.read((String)"K8Er4JuzTpys1ipFv+b8dkLK+hE="));
        UserInfo userinfo = SysContext.getSysContext().getCurrentUserInfo();
        Result result1 = this.saveProjectGroup(ctx, collection, projectgroups, groupmap, set, pGroup, userinfo);
        Calendar cal = Calendar.getInstance();
        Timestamp t = new Timestamp(cal.getTimeInMillis());
        ProjectCalendarInfo projectcalendarInfo = new ProjectCalendarInfo();
        projectcalendarInfo.setId(BOSUuid.read((String)"nz4fwnlKQs2UUNYLZfS4U5nUdmw="));
        int n = collection.size();
        for (i = 0; i < n; ++i) {
            coreBaseInfo = (com.kingdee.eas.basedata.assistant.ProjectInfo)collection.get(i);
            if (!coreBaseInfo.isIsListItem()) continue;
            project = new ProjectInfo();
            project.setProjectCalendar(projectcalendarInfo);
            project.setCreateTime(new Timestamp(cal.getTimeInMillis()));
            project.setCreator(userinfo);
            project.setPlanBeginTime(t);
            project.setPlanEndTime(t);
            if (coreBaseInfo.getScheduleStartDate() != null) {
                project.setPlanBeginTime(new Timestamp(coreBaseInfo.getScheduleStartDate().getTime()));
            }
            if (coreBaseInfo.getSchedulEndDate() != null) {
                project.setPlanEndTime(new Timestamp(coreBaseInfo.getSchedulEndDate().getTime()));
            }
            project.setProjectAssist(coreBaseInfo);
            project.setPerson(coreBaseInfo.getPrjManager());
            project.setNumber(coreBaseInfo.getNumber());
            project.setName(coreBaseInfo.getName());
            project.setBaseStatus(MMBaseStatusEnum.SAVED);
            project.setCU(coreBaseInfo.getCU());
            project.setCreator(SysContext.getSysContext().getCurrentUserInfo());
            project.setQty(new BigDecimal("1.00"));
            project.setUnitCost(defaultQty);
            project.setTotalCost(defaultQty);
            project.setCurrency(currency);
            project.setTotalTime(new BigDecimal("1.00"));
            project.setActTotalCost(defaultQty);
            project.setTotalQty(defaultQty);
            project.setCompletePercent(defaultQty);
            project.setIsTemplate(false);
            project.setProjectAssist(coreBaseInfo);
            ProjectOrgInfo projectorgInfo = new ProjectOrgInfo();
            projectorgInfo.setStorageOrgUnit(centralOrgUnit);
            project.getProjectOrg().add(projectorgInfo);
            if (coreBaseInfo.getParent() != null) {
                ProjectGroupInfo pareetn = (ProjectGroupInfo)groupmap.get(coreBaseInfo.getParent().getNumber());
                project.setGroup(pareetn);
            } else {
                project.setGroup(pGroup);
            }
            project.setPriority(ProjectPriorityEnum.A);
            if (this.isExistProject(ctx, coreBaseInfo.getNumber())) continue;
            projects.add((CoreBaseInfo)project);
        }
        Result result2 = new Result();
        IObjectPK[] addnewBatchData = this.addnewBatchData(ctx, projects);
        int n2 = addnewBatchData.length;
        for (i = 0; i < n2; ++i) {
            LineResult lineResult = new LineResult();
            lineResult.setPk(addnewBatchData[i]);
            lineResult.setSucess(true);
            result2.addLineResult(lineResult);
        }
        n2 = result1.size();
        for (i = 0; i < n2; ++i) {
            result2.addLineResult(result1.getLineResult(i));
        }
        return result2;
    }

    private boolean isExistProject(Context ctx, String number) throws BOSException {
        String sql = " select top 1 fid  from  t_mm_project where fnumber='" + number + "' ";
        IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
        return executeQuery.size() > 0;
    }

    private void projectAuditInsertIntoTBDproject(Context ctx, BatchActionResults batchResults) throws BOSException {
        Object[] id = batchResults.getToDoIdsArray();
        StringBuffer sql = new StringBuffer();
        sql.append(" select distinct p.fid  from t_mm_project  p  left outer join  t_bd_project d ");
        sql.append(" on  p.fnumber = d.fnumber  where  p.fid in(").append(SQLUtil.arrayToString((Object[])id));
        sql.append(") and  d.fnumber is not null and  p.FProjectAssistID is null");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                batchResults.addError(rs.getString("fid"), (Exception)((Object)new ProjectException(ProjectException.PROJECT_IS_TONG)));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private void removerSame(CoreBaseCollection projectgroups, ProjectGroupInfo projectGroupInfo) {
        ProjectGroupInfo otherInfo = null;
        int n = projectgroups.size();
        for (int i = 0; i < n; ++i) {
            otherInfo = (ProjectGroupInfo)projectgroups.get(i);
            if (!otherInfo.getNumber().equals(projectGroupInfo.getNumber())) continue;
            projectgroups.remove((CoreBaseInfo)otherInfo);
            return;
        }
    }

    private Result saveProjectGroup(Context ctx, CoreBaseCollection collection, CoreBaseCollection projectgroups, HashMap groupmap, HashSet set, ProjectGroupInfo pGroup, UserInfo userinfo) throws BOSException, EASBizException {
        int i;
        int n = collection.size();
        for (i = 0; i < n; ++i) {
            com.kingdee.eas.basedata.assistant.ProjectInfo coreBaseInfo = (com.kingdee.eas.basedata.assistant.ProjectInfo)collection.get(i);
            if (coreBaseInfo.isIsListItem()) continue;
            ProjectGroupInfo projectGroupInfo = new ProjectGroupInfo();
            projectGroupInfo.setId(BOSUuid.create((String)"42CAFA11"));
            projectGroupInfo.setName(coreBaseInfo.getName());
            projectGroupInfo.setNumber(coreBaseInfo.getNumber());
            projectGroupInfo.setCreator(userinfo);
            set.add(coreBaseInfo.getNumber());
            if (coreBaseInfo.getParent() != null) {
                ProjectGroupInfo pareetn = (ProjectGroupInfo)groupmap.get(coreBaseInfo.getParent().getNumber());
                projectGroupInfo.setParent(pareetn);
            } else {
                projectGroupInfo.setParent(pGroup);
            }
            projectGroupInfo.setCU(coreBaseInfo.getCU());
            groupmap.put(coreBaseInfo.getNumber(), projectGroupInfo);
            projectgroups.add((CoreBaseInfo)projectGroupInfo);
        }
        IProjectGroup localInstance = ProjectGroupFactory.getLocalInstance(ctx);
        EntityViewInfo view = null;
        view = new EntityViewInfo();
        FilterInfo fileter = null;
        fileter = new FilterInfo();
        fileter.getFilterItems().add(new FilterItemInfo("number", (Object)set, CompareType.INCLUDE));
        view.setFilter(fileter);
        CoreBaseCollection collection2 = localInstance.getCollection(view);
        int n2 = collection2.size();
        for (i = 0; i < n2; ++i) {
            ProjectGroupInfo projectGroupInfo = (ProjectGroupInfo)collection2.get(i);
            groupmap.put(projectGroupInfo.getNumber(), projectGroupInfo);
            this.removerSame(projectgroups, projectGroupInfo);
        }
        Result result1 = new Result();
        int n3 = projectgroups.size();
        for (i = 0; i < n3; ++i) {
            IObjectPK addnew = localInstance.addnew((ProjectGroupInfo)projectgroups.get(i));
            LineResult lineResult = new LineResult();
            lineResult.setPk(addnew);
            lineResult.setSucess(true);
            result1.addLineResult(lineResult);
        }
        return result1;
    }

    private void submitCheck(Context ctx, String[] ids, BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectCollection objects = batchResults.getObjCollection();
        StringBuffer sql = new StringBuffer();
        String locStr = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        sql.setLength(0);
        sql.append("SELECT fid, FBaseStatus  from t_mm_project where fid in (");
        sql.append(SQLUtil.arrayToString((Object[])ids));
        sql.append(")");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                if (rs.getInt("FBaseStatus") <= 2) continue;
                batchResults.addError(rs.getString("fid"), "\u4e0d\u662f\u4fdd\u5b58\u6216\u63d0\u4ea4\u72b6\u6001\u7684\u9879\u76ee\u53f7\u4e0d\u80fd\u63d0\u4ea4,\u8bf7\u67e5\u770b\u662f\u5426\u5df2\u88ab\u4fee\u6539\uff01");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        String materialID = "";
        StringBuffer orgIDs = new StringBuffer("");
        String billID = "";
        if (objects != null && objects.size() > 0) {
            ProjectInfo project = (ProjectInfo)objects.getObject(0);
            ProjectOrgCollection orgs = project.getProjectOrg();
            billID = project.getId().toString();
            materialID = project.getMaterial() != null ? project.getMaterial().getId().toString() : "null";
            for (int i = 0; i < orgs.size(); ++i) {
                StorageOrgUnitInfo orgUnit = orgs.get(i).getStorageOrgUnit();
                orgIDs.append("'");
                orgIDs.append(orgUnit.getId().toString());
                orgIDs.append("',");
            }
            orgIDs.append("'null'");
        }
        sql.setLength(0);
        sql.append("SELECT t1.FID,t4.FName_");
        sql.append(locStr);
        sql.append(" FName FROM t_bd_material t1 LEFT OUTER JOIN t_bd_materialPlan t2 on t1.FID = t2.FMaterialID ");
        sql.append("LEFT OUTER JOIN t_bd_manufactureStrategy t3 on t3.FID = t2.FManufactureStrategyID ");
        sql.append("LEFT OUTER JOIN T_ORG_Storage t4 on t2.FOrgUnit = t4.FID ");
        sql.append(" WHERE t3.FID  not in( '");
        sql.append("GE2FIa4GQ6uhdx0RDGuibtg0uEU=','qAXoUB/uBg/gQKjAYj0WQ9g0uEU=");
        sql.append("') AND t1.FID ='");
        sql.append(materialID);
        sql.append("' and t2.FOrgUnit in(");
        sql.append(orgIDs);
        sql.append(")");
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            MessageFormat msgFormat = new MessageFormat(ProjectControllerBean.getResource(ctx, "MATERIAL_MUST_ETO10"));
            StringBuffer msg = new StringBuffer("");
            msg.append("");
            msg.setLength(0);
            while (set != null && set.next()) {
                msg.append(msgFormat.format(new String[]{set.getString("FName"), set.getString("FName")}));
                msg.append("\r\n");
            }
            if (msg.length() > 0) {
                batchResults.addError(billID, msg.toString());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected Result _addnew(Context ctx, IObjectCollection colls) throws BOSException, EASBizException {
        if (ctx == null || colls == null) {
            throw new EASBizException(new NumericExceptionSubItem("\u65b0\u589e\u5931\u8d25", "\u4f20\u9012\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        this.dataCheck(ctx, colls);
        Result result = super._addnew(ctx, colls);
        this.updateSecondaryTNDelivery(ctx);
        return result;
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (pk == null || ctx == null || model == null) {
            throw new EASBizException(new NumericExceptionSubItem("\u65b0\u589e\u5931\u8d25", "\u4f20\u9012\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        this.dataCheck(ctx, model);
        super._addnew(ctx, pk, model);
        this.updateSecondaryTNDelivery(ctx);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (ctx == null || model == null) {
            throw new EASBizException(new NumericExceptionSubItem("\u65b0\u589e\u5931\u8d25", "\u4f20\u9012\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        this.dataCheck(ctx, model);
        IObjectPK pk = super._addnew(ctx, model);
        this.updateSecondaryTNDelivery(ctx);
        return pk;
    }

    protected IObjectPK[] _addnewBatchData(Context ctx, IObjectCollection colls) throws BOSException, EASBizException {
        if (ctx == null || colls == null) {
            throw new EASBizException(new NumericExceptionSubItem("\u65b0\u589e\u5931\u8d25", "\u4f20\u9012\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        this.dataCheck(ctx, colls);
        IObjectPK[] pks = super._addnewBatchData(ctx, colls);
        this.updateSecondaryTNDelivery(ctx);
        return pks;
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BatchActionResults result = this.batchAudit(ctx, this.buildBatchParam(ctx, pk));
        result.throwExceptions();
    }

    @Override
    protected void _close(Context ctx, IObjectPK PK) throws BOSException, EASBizException {
        BatchActionResults result = this.batchClose(ctx, this.buildBatchParam(ctx, PK));
        result.throwExceptions();
    }

    @Override
    protected IObjectValue _createNewData(Context ctx, boolean isUseAgent) throws BOSException, EASBizException {
        ProjectInfo project = new ProjectInfo();
        Calendar cal = Calendar.getInstance();
        Timestamp t = new Timestamp(cal.getTimeInMillis());
        project.setCreateTime(new Timestamp(cal.getTimeInMillis()));
        project.setPlanBeginTime(t);
        project.setPlanEndTime(t);
        return project;
    }

    @Override
    protected IObjectPK[] _delete(Context ctx, FilterInfo filter) throws BOSException, EASBizException {
        IObjectPK[] pks = this._getPKList(ctx, filter, null);
        this.dataCheck(ctx, pks, "Delete");
        this.deleteJCH(ctx, pks);
        super._delete(ctx, pks);
        return pks;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IObjectPK[] pks = new IObjectPK[]{pk};
        this.dataCheck(ctx, pks, "Delete");
        this.deleteJCH(ctx, pks);
        BatchActionResults result = this.batchDelete(ctx, this.buildBatchParam(ctx, pk));
        result.throwExceptions();
    }

    @Override
    protected void _delete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        this.dataCheck(ctx, arrayPK, "Delete");
        this.deleteJCH(ctx, arrayPK);
        super._delete(ctx, arrayPK);
    }

    @Override
    protected IObjectPK[] _delete(Context ctx, String oql) throws BOSException, EASBizException {
        IObjectPK[] pks = this._getPKList(ctx, oql);
        this.dataCheck(ctx, pks, "Delete");
        this.deleteJCH(ctx, pks);
        super._delete(ctx, pks);
        return pks;
    }

    protected void _deleteBatchData(Context ctx, IObjectPK[] pkArray) throws BOSException, EASBizException {
        this.dataCheck(ctx, pkArray, "Delete");
        this.deleteJCH(ctx, pkArray);
        super._deleteBatchData(ctx, pkArray);
    }

    @Override
    protected void _disable(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BatchActionResults result = this.batchDisable(ctx, this.buildBatchParam(ctx, pk));
        result.throwExceptions();
    }

    @Override
    protected void _enable(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BatchActionResults result = this.batchEnable(ctx, this.buildBatchParam(ctx, pk));
        result.throwExceptions();
    }

    @Override
    protected Result _getDataFromBDproject(Context ctx, String cuid) throws BOSException, EASBizException {
        return this.getDataFromBDProject(ctx, cuid);
    }

    @Override
    protected IObjectCollection _getFilterProjectCollection(Context ctx, String[] orgUnit, boolean isTemplate, String groupid, String controlUnitID) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select project.fid  as id,").append("project.fname_").append(ctx.getLocale()).append(" as name  ,project.fgroupid  ,project.fprojecttypeid as fprojecttypeid,project.fbasestatus as fbasestatus,").append(" project.fnumber number,project.fplanbegintime planbegintime,").append(" project.fplanendtime planendtime,project.ftotaltime totaltime,").append(" project.FActualBeginTime ActualBeginTime,").append(" project.FCentralPurstgOrgID centralPurOrg,project.FControlUnitID cu,project.FQty qty").append(" from t_mm_project as project").append(" LEFT OUTER JOIN  T_mm_ProjectOrg as projectorg   ").append("on project.fid=projectorg.fprojectid  ").append("left outer join T_ORG_Storage as storage  ").append(" on projectorg.FStorageOrgUnitID=storage.fid  ").append("where   project.fgroupid ='" + groupid + "' ");
        if (orgUnit != null) {
            sql.append(" and  storage.fnumber in (").append(SQLUtil.arrayToString((Object[])orgUnit)).append(") ");
        }
        if (controlUnitID != null) {
            sql.append(" and  ( project.fcontrolunitid = '").append(controlUnitID).append("' ");
            sql.append("OR project.fcontrolunitid in ( ");
            sql.append("SELECT FDataBaseDID FROM T_BD_DataBaseDAssign WHERE FBOSObjectType = '00B2050E' AND FAssignCUID = '");
            sql.append(controlUnitID);
            sql.append("') ) ");
        }
        if (isTemplate) {
            sql.append(" and project.fisTemplate =1");
        } else {
            sql.append(" and project.fisTemplate =0");
        }
        ProjectCollection projctlist = new ProjectCollection();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        ProjectGroupInfo proGroup = ProjectGroupFactory.getLocalInstance(ctx).getProjectGroupInfo((IObjectPK)new ObjectUuidPK(groupid));
        try {
            while (rs.next()) {
                String centralOrgUnitId;
                ProjectInfo pro = new ProjectInfo();
                pro.setId(BOSUuid.read((String)rs.getString("id")));
                pro.setName(rs.getString("name"));
                pro.setNumber(rs.getString("number"));
                pro.setPlanBeginTime(rs.getTimestamp("planbegintime"));
                pro.setPlanEndTime(rs.getTimestamp("planendtime"));
                pro.setTotalTime(rs.getBigDecimal("totaltime"));
                pro.setActualBeginTime(rs.getTimestamp("ActualBeginTime"));
                pro.setQty(rs.getBigDecimal("qty"));
                pro.setGroup(proGroup);
                String cuId = rs.getString("cu");
                if (cuId != null) {
                    CtrlUnitInfo cu = new CtrlUnitInfo();
                    cu.setId(BOSUuid.read((String)cuId));
                    pro.setCU(cu);
                }
                if ((centralOrgUnitId = rs.getString("centralPurOrg")) != null) {
                    StorageOrgUnitInfo centralOrgUnit = new StorageOrgUnitInfo();
                    centralOrgUnit.setId(BOSUuid.read((String)rs.getString("centralPurOrg")));
                    pro.setCentralPurStgOrg(centralOrgUnit);
                }
                if (rs.getString("fprojecttypeid") != null && rs.getString("fprojecttypeid").length() > 0) {
                    ProjectDictDataInfo prodict = new ProjectDictDataInfo();
                    prodict.setId(BOSUuid.read((String)rs.getString("fprojecttypeid")));
                    pro.setProjectType(prodict);
                }
                pro.setBaseStatus(MMBaseStatusEnum.getEnum((int)rs.getInt("fbasestatus")));
                projctlist.add(pro);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return projctlist;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProjectCarCollection cars;
        ProjectInfo objectValue = (ProjectInfo)model;
        objectValue.setBaseStatus(MMBaseStatusEnum.SAVED);
        if (objectValue.getId() == null) {
            objectValue.setId(BOSUuid.create((BOSObjectType)this.getBOSType()));
        }
        if ((cars = objectValue.getCarNumberRange()) != null && cars.size() > 0) {
            for (int i = 0; i < cars.size(); ++i) {
                ProjectCarInfo carInfo = cars.get(i);
                if (carInfo.getTrackNumber() != null || carInfo.getName() != null) continue;
                cars.remove(carInfo);
                --i;
            }
        }
        this.batchSave(ctx, (IObjectValue)objectValue, BatchActionEnum.SAVE);
        IObjectPK pk = super._save(ctx, (IObjectValue)objectValue);
        this.afterSetUnit(ctx, new String[]{objectValue.getId().toString()});
        this.changerByProjectCandler(ctx, objectValue);
        return pk;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProjectInfo objectValue = (ProjectInfo)model;
        objectValue.setBaseStatus(MMBaseStatusEnum.SUBMIT);
        ProjectCarCollection cars = objectValue.getCarNumberRange();
        if (cars != null && cars.size() > 0) {
            for (int i = 0; i < cars.size(); ++i) {
                ProjectCarInfo carInfo = cars.get(i);
                if (carInfo.getTrackNumber() != null || carInfo.getName() != null) continue;
                cars.remove(carInfo);
                --i;
            }
        }
        if (objectValue.getId() == null) {
            objectValue.setId(BOSUuid.create((BOSObjectType)this.getBOSType()));
        }
        this.batchSave(ctx, (IObjectValue)objectValue, BatchActionEnum.SUBMIT);
        IObjectPK pk = super._submit(ctx, (IObjectValue)objectValue);
        this.afterSetUnit(ctx, new String[]{objectValue.getId().toString()});
        return pk;
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BatchActionResults result = this.batchUnAudit(ctx, this.buildBatchParam(ctx, pk));
        result.throwExceptions();
    }

    @Override
    protected void _unClose(Context ctx, IObjectPK PK) throws BOSException, EASBizException {
        BatchActionResults result = this.batchUnClose(ctx, this.buildBatchParam(ctx, PK));
        result.throwExceptions();
    }

    protected Result _update(Context ctx, IObjectCollection colls) throws BOSException, EASBizException {
        if (ctx == null || colls == null) {
            throw new EASBizException(new NumericExceptionSubItem("\u66f4\u65b0\u5931\u8d25", "\u4f20\u9012\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        this.dataCheck(ctx, colls);
        Result result = super._update(ctx, colls);
        this.updateSecondaryTNDelivery(ctx);
        return result;
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (ctx == null || model == null) {
            throw new EASBizException(new NumericExceptionSubItem("\u66f4\u65b0\u5931\u8d25", "\u4f20\u9012\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        this.dataCheck(ctx, model);
        super._update(ctx, pk, model);
        this.updateSecondaryTNDelivery(ctx);
        String id = IndustryUtils.getObjectValueStringData((IObjectValue)model, (String)"id");
        if (!IndustryUtils.isEmptyString((String)id)) {
            try {
                ProjectCentralPurOrgFactory.getLocalInstance(ctx).delete(new FilterInfo("parent.id='" + id + "'"));
            }
            catch (ParserException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    protected IObjectPK[] _updateBatchData(Context ctx, IObjectCollection colls) throws BOSException, EASBizException {
        if (ctx == null || colls == null) {
            throw new EASBizException(new NumericExceptionSubItem("\u66f4\u65b0\u5931\u8d25", "\u4f20\u9012\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        this.dataCheck(ctx, colls);
        IObjectPK[] pks = super._updateBatchData(ctx, colls);
        this.updateSecondaryTNDelivery(ctx);
        return pks;
    }

    @Override
    protected void _updatePartial(Context ctx, IObjectValue model, SelectorItemCollection selector) throws BOSException, EASBizException {
        if (ctx == null || model == null || selector == null) {
            throw new EASBizException(new NumericExceptionSubItem("\u66f4\u65b0\u5931\u8d25", "\u4f20\u9012\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        model.put("SelectorItemCollection", (Object)selector);
        this.dataCheck(ctx, model);
        super._updatePartial(ctx, model, selector);
        this.updateSecondaryTNDelivery(ctx);
    }

    @Override
    protected void _updateProjectCanler(Context ctx, String projectCanlerId, String projectId) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("update T_MM_Project set FProjectCalendarID='").append(projectCanlerId);
        sql.append("'  where fid='").append(projectId).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    protected void aftersetTotaldate(Context ctx, String ids, boolean isSystem) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("update T_MM_TrackNumber set FStatus=80 where fid in(select FTrackNumberID  from t_mm_projectcar where fprojectid in(").append(ids).append(") )");
        StringBuffer closeoff = new StringBuffer();
        closeoff.append("update T_BD_Project as t0 set Fstatus = 2 where t0.fid in (select t1.FProjectAssistID from t_mm_project t1 where t1.fid in (");
        closeoff.append(ids).append("))");
        DbUtil.execute((Context)ctx, (String)closeoff.toString());
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("update T_MM_PROJECT  SET  FActualTotalTime =").append("  ((DATEDIFF(CONVERT(DATETIME,  tochar( FActualBeginTime, 'yyyy-mm-dd')||' 00:00:00'),").append(" CONVERT(DATETIME ,tochar( FActualEndTime,'yyyy-mm-dd')||' 00:00:00')").append(" \t)/1/60/60/24) +1  )").append("where   fid in(").append(ids).append(") and FActualEndTime is not null and FActualBeginTime is not null");
        if (isSystem) {
            StringBuffer updateAssist = new StringBuffer();
            updateAssist.append("update T_BD_Project as t0 set (FFactStartDate,FFactEndDate) = ( ").append(" select to_date(tochar( FActualBeginTime,'yyyy-mm-dd')||' 00:00:00')  FFactStartDate,").append(" to_date(tochar( FActualEndTime,'yyyy-mm-dd')||' 00:00:00')  FFactEndDate from t_mm_project t1  ").append("where t1.FProjectAssistID=t0.fid and t1.fid in(").append(ids).append(")and t1.FActualBeginTime is not null and t1.FActualEndTime is not null )");
            SQLUtil.batchExecuteSql((Context)ctx, (String[])new String[]{updateAssist.toString(), sql.toString(), updateSql.toString()});
        } else {
            SQLUtil.batchExecuteSql((Context)ctx, (String[])new String[]{sql.toString(), updateSql.toString()});
        }
    }

    protected void afterSetUnit(Context ctx, String[] ids) throws BOSException, EASBizException {
        StringBuffer updateSql = new StringBuffer("");
        updateSql.setLength(0);
        updateSql.append("update T_MM_Project as t0  ").append("set (FUnitID,FBaseQty) = ").append("(select t2.FBaseUnit,round(decimal(t0.FQty * t1.FBaseConvsRate,21,8),t3.FQtyPrecision) ").append("from t_bd_multimeasureunit t1,t_bd_material t2,t_bd_multimeasureunit t3 ").append("where t0.FMaterialID = t1.FMaterialID and t0.FBaseUnitID = t1.fmeasureunitid ").append("and t0.FMaterialID = t2.FID ").append("and t0.FMaterialID = t3.FMaterialID and  t2.FBaseUnit = t3.fmeasureunitid ").append("and t0.FID in (").append(SQLUtil.arrayToString((Object[])ids)).append(") ").append(")");
        StringBuffer updateNoMaterial = new StringBuffer("");
        updateNoMaterial.setLength(0);
        updateNoMaterial.append("update T_MM_Project as t0 ").append("set FBaseQty =fqty where  t0.FMaterialID is null and t0.fid in(").append(SQLUtil.arrayToString((Object[])ids)).append(")");
        SQLUtil.batchExecuteSql((Context)ctx, (String[])new String[]{updateSql.toString(), updateNoMaterial.toString()});
    }

    protected void auditAfterInsertTOTask(Context ctx, String[] id) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into t_mm_projecttask (fcompletePercent ,FActTotalCost,FTotalQty, FTOTALBASEQTY,  FNAME_L1 , FNAME_L2,FNAME_L3,FNUMBER,");
        sql.append(" FTOTALCOST,");
        sql.append("  FUNITCOST,  FTOTALTIME,  FPLANBEGINTIME,  FPLANENDTIME,  FEARISTBEGINTIME,  FLASTBEGINTIME ,  FEARISTENDTIME,");
        sql.append("  FLASTENDTIME,  FQTY, FBASEQTY, FPERSONID,  FADMINORGUNITID,  FMATERIALID,  fprojectid, ");
        sql.append(" FCURRENCYID,  FUnitID ,FINTERVAL, FACTUALTOTALTIME, flevel,FSeq,FNextSeq,FBaseStatus,fid) ");
        sql.append("select fcompletePercent, FActTotalCost,FTotalQty,FTOTALBASEQTY, FNAME_L1 ,  FNAME_L2 ,  FNAME_L3 ,  FNUMBER,");
        sql.append(" FTOTALCOST    ,  FUNITCOST ,  FTOTALTIME ,  FPLANBEGINTIME  ,");
        sql.append("  FPLANENDTIME  ,  FEARISTBEGINTIME,  FLASTBEGINTIME,  FEARISTENDTIME,");
        sql.append("  FLASTENDTIME  ,  FQTY  , FBASEQTY, FPERSONID ,  FADMINORGUNITID,  FMATERIALID,");
        sql.append("  FID    as fprojectid ,  FCURRENCYID   ,");
        sql.append("  FBaseUnitID  as FUnitID ,0 as FINTERVAL, 0 as FACTUALTOTALTIME, 0 as flevel ,1 as fseq,1 as fnextseq ,1 as FBaseStatus,newbosid('9F1477B3') as fid ");
        sql.append(" from t_mm_project where fid in(");
        sql.append(SQLUtil.arrayToString((Object[])id));
        sql.append(") ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    protected BatchActionResults batchExecute(Context ctx, BatchExecuteParamsEntry[] entries, BatchActionEnum batchActionEnum) throws EASBizException, BOSException {
        BillsExecuteContext executeContext = new BillsExecuteContext(ctx, this.getBOSType(), batchActionEnum, (BizController)this, (Object[])entries);
        executeContext.setXmlFileName(this.getXmlFileName(batchActionEnum));
        executeContext.setBillTypeID(this.getBillTypeId());
        SCMBusinessProcessorBuilder4common builder = new SCMBusinessProcessorBuilder4common((ExecuteContext)executeContext);
        return DynamicBusinessProcessHelper.batchExecute((Context)ctx, (BizController)this, (IBusinessProcessorBuilder)builder, (BatchExecuteParamsEntry[])entries, (String)this.getXmlFileName(batchActionEnum));
    }

    protected BatchExecuteParamsEntry[] buildBatchParam(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BatchExecuteParamsEntry entry = new BatchExecuteParamsEntry(new Class[]{IObjectPK.class});
        entry.add((Object)pk);
        return new BatchExecuteParamsEntry[]{entry};
    }

    protected void checkProjectTaskIsClose(Context ctx, BatchActionResults batchResults) throws BOSException {
        Object[] id = batchResults.getToDoIdsArray();
        StringBuffer sql = new StringBuffer();
        sql.append("select  fid  from  t_mm_project where fid in  ").append(" (  select  distinct fprojectid from t_mm_projecttask t where   ").append(" fprojectid  in (").append(SQLUtil.arrayToString((Object[])id)).append(") and t.flevel=1 and  fbasestatus in (0,1,2,5,50,70)) ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                batchResults.addError(rs.getString("fid"), (Exception)((Object)new ProjectException(ProjectException.PROJECTTASK_IS_UNCLOSE)));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    protected void checkProjectUNAudit(Context ctx, BatchActionResults batchResults) throws BOSException {
        Object[] id = batchResults.getToDoIdsArray();
        StringBuffer sql = new StringBuffer();
        sql.append("select  fid  from  t_mm_project where fid in  ").append(" (  select  distinct fprojectid from t_mm_projectfeedback t where   ").append(" fprojectid  in (").append(SQLUtil.arrayToString((Object[])id)).append(")  and  fbasestatus in (4,7,60)) ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                batchResults.addError(rs.getString("fid"), (Exception)((Object)new ProjectException(ProjectException.PROJECT_UNAUDIT_NOFEEDBACK)));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    protected void checkProjectUNClose(Context ctx, BatchActionResults batchResults) throws BOSException {
        Object[] id = batchResults.getToDoIdsArray();
        StringBuffer sql = new StringBuffer();
        sql.append("select  fid  from  t_mm_project where fid in  ").append(" (  select  distinct fprojectid from t_mm_projectfeedback t where   ").append(" fprojectid  in (").append(SQLUtil.arrayToString((Object[])id)).append(")  and  fbasestatus in (4,7,60)) ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                batchResults.addError(rs.getString("fid"), (Exception)((Object)new ProjectException(ProjectException.PROJECT_IS_UINIALLDANJU)));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    protected void checkTaskIsExitProject(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        if (batchResults.getToDoIdsArray().length > 0) {
            Object[] id = batchResults.getToDoIdsArray();
            String sql = "select distinct fprojectid from t_mm_projecttask where fprojectid in (" + SQLUtil.arrayToString((Object[])id) + ") and flevel = 1";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            try {
                while (rs.next()) {
                    batchResults.addError(rs.getString("fprojectid"), (Exception)((Object)new ProjectException(ProjectException.IS_EXISTS_TASK)));
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            if (batchResults.getToDoIdsArray().length > 0) {
                StringBuffer deleteSql = new StringBuffer();
                deleteSql.append("delete t_mm_projecttask where fprojectid in (");
                deleteSql.append(SQLUtil.arrayToString((Object[])batchResults.getToDoIdsArray()));
                deleteSql.append(")");
                DbUtil.execute((Context)ctx, (String)deleteSql.toString());
            }
        }
    }

    protected void checkWbsRule(Context ctx, String[] idStr) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select distinct t2.fid ").append(" from t_mm_WBSRuler t2  where t2.FProjectID  in (").append(SQLUtil.arrayToString((Object[])idStr)).append(")");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs != null && rs.size() == 0) {
            String[] sqls = new String[idStr.length];
            StringBuffer insertsql = new StringBuffer();
            for (int i = 0; i < idStr.length; ++i) {
                insertsql.setLength(0);
                insertsql.append("insert into t_mm_WBSRuler(fid,flevel,fdigists,FProjectid) ");
                insertsql.append(" select newbosid('D0793B79') as fid, t.flevel,t.fdigists,");
                insertsql.append(" '" + idStr[i] + "'");
                insertsql.append(" as fprojectid from  t_mm_WBSRuler  t ");
                insertsql.append(" where t.fprojectid is null");
                sqls[i] = insertsql.toString();
            }
            SQLUtil.batchExecuteSql((Context)ctx, (String[])sqls);
        }
    }

    protected void dataCheck(Context ctx, IObjectCollection colls) throws BOSException, EASBizException {
        if (ctx == null || colls == null) {
            throw new EASBizException(new NumericExceptionSubItem("\u6570\u636e\u68c0\u6d4b\u5931\u8d25", "\u4f20\u9012\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        int size = colls.size();
        if (size == 0) {
            return;
        }
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        for (int index = 0; index < colls.size(); ++index) {
            ProjectInfo model;
            ProjectInfo projectInfo = colls.getObject(index) == null ? null : (model = colls.getObject(index) instanceof ProjectInfo ? (ProjectInfo)colls.getObject(index) : null);
            if (model == null) continue;
            String id = IndustryUtils.getObjectValueStringData(model, (String)"id");
            Boolean isAddNew = IndustryUtils.isEmptyString((String)id) ? true : !this._exists(ctx, (IObjectPK)new ObjectUuidPK(id));
            if (isAddNew.booleanValue()) {
                if (model.getCU() == null) {
                    model.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
                }
                if (model.getCreator() == null) {
                    model.setCreator(userInfo);
                }
                if (model.getCreateTime() == null) {
                    model.setCreateTime(IndustryUtils.currTime);
                }
                if (model.getLastUpdateUser() == null) {
                    model.setLastUpdateUser(userInfo);
                }
                if (model.getLastUpdateTime() == null) {
                    model.setLastUpdateTime(IndustryUtils.currTime);
                }
                if (model.getBaseStatus() == null) {
                    model.setBaseStatus(MMBaseStatusEnum.SAVED);
                }
            }
            SelectorItemCollection selectorItemCollection = model.containsKey("SelectorItemCollection") ? (model.get("SelectorItemCollection") == null ? null : (model.get("SelectorItemCollection") instanceof SelectorItemCollection ? (SelectorItemCollection)model.get("SelectorItemCollection") : null)) : null;
        }
    }

    protected void dataCheck(Context ctx, IObjectPK[] pks, String action) throws BOSException, EASBizException {
        if (ctx == null || IndustryUtils.isEmptyArray((Object[])pks) || IndustryUtils.isEmptyString((String)action)) {
            throw new EASBizException(new NumericExceptionSubItem("\u6570\u636e\u68c0\u6d4b\u5931\u8d25", "\u4f20\u9012\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        ArrayList<String> idList = new ArrayList<String>();
        for (IObjectPK pk : pks) {
            if (pk == null) continue;
            idList.add(pk.toString());
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("IDList", idList);
        params.put("Action", action);
        this.dataCheck(ctx, params);
    }

    protected void dataCheck(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (ctx == null || model == null) {
            throw new EASBizException(new NumericExceptionSubItem("\u6570\u636e\u68c0\u6d4b\u5931\u8d25", "\u4f20\u9012\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        ProjectCollection colls = new ProjectCollection();
        colls.addObject(model);
        this.dataCheck(ctx, (IObjectCollection)colls);
    }

    protected void dataCheck(Context ctx, Map params) throws BOSException, EASBizException {
        if (ctx == null || IndustryUtils.isEmptyMap((Map)params)) {
            throw new EASBizException(new NumericExceptionSubItem("\u6570\u636e\u68c0\u6d4b\u5931\u8d25", "\u4f20\u9012\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        List idList = IndustryUtils.getMapListData((Map)params, (Object)"IDList");
        String action = IndustryUtils.getMapStringData((Map)params, (Object)"Action");
        if (IndustryUtils.isEmptyList((List)idList) || IndustryUtils.isEmptyString((String)action)) {
            return;
        }
        StringBuilder errorMessages = new StringBuilder();
        HashMap<String, String> pMap = new HashMap<String, String>();
        errorMessages.setLength(0);
        StringBuilder sql = new StringBuilder();
        sql.setLength(0);
        sql.append("Select ");
        sql.append("fid ");
        sql.append(",fnumber ");
        sql.append(",fbaseStatus ");
        sql.append(",FProjectAssistID from t_mm_project\r\n");
        sql.append("Where ");
        sql.append("fid In ( ");
        sql.append(SQLUtil.arrayToString((Object[])idList.toArray()));
        sql.append(" ) ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs != null && rs.size() > 0) {
            try {
                while (rs.next()) {
                    String id = rs.getString("FID");
                    String projectAssistID = rs.getString("FProjectAssistID");
                    String number = rs.getString("FNumber");
                    int baseStatusInt = rs.getInt("fbaseStatus");
                    MMBaseStatusEnum baseStatusEnum = MMBaseStatusEnum.getEnum((int)baseStatusInt);
                    if (IndustryUtils.isEmptyString((String)id) || IndustryUtils.isEmptyString((String)number)) continue;
                    pMap.put(id, number);
                    if (baseStatusEnum == null) {
                        errorMessages.append("\u5355\u636e\u3010").append(number).append("\u3011").append("\u7684\u3010\u72b6\u6001\u3011\u4e3a\u7a7a\r\n");
                    }
                    if (action.equals("Audit") && !MMBaseStatusEnum.SUBMIT.equals((Object)baseStatusEnum)) {
                        errorMessages.append("\u5355\u636e\u3010").append(number).append("\u3011").append("\u672a\u63d0\u4ea4\r\n");
                    } else if (action.equals("UnAudit") && !MMBaseStatusEnum.AUDIT.equals((Object)baseStatusEnum)) {
                        errorMessages.append("\u5355\u636e\u3010").append(number).append("\u3011").append("\u672a\u5ba1\u6838\r\n");
                    } else if ((action.equals("Delete") || action.equals("Submit")) && !MMBaseStatusEnum.SUBMIT.equals((Object)baseStatusEnum) && !MMBaseStatusEnum.SAVED.equals((Object)baseStatusEnum)) {
                        errorMessages.append("\u5355\u636e\u3010").append(number).append("\u3011").append("\u4e0d\u662f\u4fdd\u5b58\uff0c\u63d0\u4ea4\u72b6\u6001\r\n");
                    }
                    if (projectAssistID == null) continue;
                    errorMessages.append("\u5355\u636e\u3010").append(number).append("\u3011").append("\u9879\u76ee\u540c\u6b65\u5b57\u6bb5\u4e0d\u4e3a\u7a7a\uff0c\u8f85\u52a9\u8d44\u6599\u5b58\u5728\u540c\u6b65\u9879\u76ee\uff01\r\n");
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        IDesignBOMBill dbbi = DesignBOMBillFactory.getLocalInstance((Context)ctx);
        IProcessBomBill pbbi = ProcessBomBillFactory.getLocalInstance((Context)ctx);
        IBom bi = BomFactory.getLocalInstance((Context)ctx);
        IPurOrderEntry poei = PurOrderEntryFactory.getLocalInstance((Context)ctx);
        ICostObject coi = CostObjectFactory.getLocalInstance((Context)ctx);
        ISaleOrderEntry soei = SaleOrderEntryFactory.getLocalInstance((Context)ctx);
        IPurRequestEntry prei = PurRequestEntryFactory.getLocalInstance((Context)ctx);
        IMaterialRequestBillEntry mrbei = MaterialRequestBillEntryFactory.getLocalInstance((Context)ctx);
        IDesignBOMMiddleBill dbmbi = DesignBOMMiddleBillFactory.getLocalInstance((Context)ctx);
        ICoreBase[] checkPICBs = new ICoreBase[]{dbbi, pbbi, bi, poei, coi, soei, prei, mrbei, dbmbi};
        String[] checkPENs = new String[]{"\u8bbe\u8ba1BOM", "\u5de5\u827aBOM", "\u5236\u9020BOM", "\u91c7\u8d2d\u8ba2\u5355\u5206\u5f55", "\u6210\u672c\u5bf9\u8c61", "\u9500\u552e\u8ba2\u5355\u5206\u5f55", "\u91c7\u8d2d\u7533\u8bf7\u5355\u5206\u5f55", "\u9886\u6599\u7533\u8bf7\u5355\u5206\u5f55", "\u5de5\u827aBom\u5e95\u7a3f"};
        String[] checkPProps = new String[]{"project.", "project.", "project.", "project.", "projectID", "project.", "project.", "project.", "project."};
        errorMessages.append(IndustryUtils.checkColumnUsage((String[])checkPENs, (ICoreBase[])checkPICBs, (List)idList, (String)"\u9879\u76ee\u53f7", (String[])checkPProps, pMap));
        if (errorMessages.length() > 0) {
            throw new EASBizException(new NumericExceptionSubItem("\u5220\u9664\u5931\u8d25", errorMessages.toString()));
        }
    }

    protected void delete(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectPK[] pks = batchResults == null ? null : batchResults.getToDoPkArray();
        this.deleteJCH(ctx, pks);
        String idStr = SQLUtil.arrayToString((Object[])batchResults.getToDoIdsArray());
        this.deleteBdProject(ctx, batchResults, idStr);
        StringBuffer selectprojectId = new StringBuffer();
        selectprojectId.append(" select FProjectCalendarID ");
        selectprojectId.append("  from t_mm_project where fid in( ");
        selectprojectId.append(idStr);
        selectprojectId.append(") and FProjectCalendarID!='");
        selectprojectId.append("nz4fwnlKQs2UUNYLZfS4U5nUdmw=").append("' ");
        ProjectCalendarFacadeFactory.getLocalInstance(ctx).deleteProjectCalendar(selectprojectId.toString());
        String[] sqls = new String[]{"delete from t_mm_WBSRuler where FProjectID in (" + idStr + ")", "delete from t_mm_projectcar where FProjectID in (" + idStr + ")", "delete from t_mm_projectorg where FProjectID in (" + idStr + ")", "DELETE FROM T_MM_project WHERE FID in (" + idStr + ")", "delete from t_mm_ProjectCentralPurOrg where FParentID in (" + idStr + ")"};
        SQLUtil.batchExecuteSql((Context)ctx, (String[])sqls);
    }

    protected void deleteBdProject(Context ctx, BatchActionResults batchResults, String idStr) throws BOSException, EASBizException {
        String sql = "select FProjectAssistID fid from t_mm_project where fid in(" + idStr + ")";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        ArrayList<ObjectUuidPK> a = new ArrayList<ObjectUuidPK>();
        if (rs != null && rs.size() > 0) {
            try {
                while (rs.next()) {
                    String id = rs.getString("fid");
                    if (IndustryUtils.isEmptyString((String)id) || "null".equals(id)) continue;
                    a.add(new ObjectUuidPK(rs.getString("fid")));
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        if (a.size() > 0) {
            ObjectUuidPK[] ids = new ObjectUuidPK[a.size()];
            for (int i = 0; i < a.size(); ++i) {
                ids[i] = (ObjectUuidPK)a.get(i);
            }
            com.kingdee.eas.basedata.assistant.ProjectFactory.getLocalInstance((Context)ctx).delete((IObjectPK[])ids);
        }
    }

    protected void deleteJCH(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        if (ctx == null || pks == null) {
            return;
        }
        if (pks.length == 0) {
            return;
        }
        FilterInfo fi = new FilterInfo();
        HashSet<String> pIDSet = new HashSet<String>();
        for (IObjectPK pk : pks) {
            if (pk == null || pIDSet.contains(pk.toString())) continue;
            pIDSet.add(pk.toString());
        }
        if (pIDSet.size() == 0) {
            return;
        }
        fi.getFilterItems().add(new FilterItemInfo("parent.id", pIDSet, CompareType.INCLUDE));
        ProjectJCHFactory.getLocalInstance((Context)ctx).delete(fi);
    }

    protected IObjectValue getBillInstance() {
        return new ProjectInfo();
    }

    protected String getBillTypeId() {
        return "zMl6HN8ASuu4/rSKSNjwm0Y+1VI=";
    }

    protected ICoreBase getBizInterface(Context ctx) throws BOSException, EASBizException {
        return ProjectFactory.getLocalInstance(ctx);
    }

    protected String getRecycleNumberSQL(String idStr) {
        return "select fid,fnumber,FControlUnitID forgid from T_MM_Project where fid in (" + idStr + ")";
    }

    protected boolean getSystemParams(Context ctx) throws BOSException, EASBizException {
        String sys;
        HashMap paramInfo1 = ParamManager.getParamHashMap((Context)ctx, (String[])new String[]{"ProjectIsolate"}, null);
        boolean isSystem = false;
        if (paramInfo1 != null && paramInfo1.get("ProjectIsolate") != null && (sys = (String)paramInfo1.get("ProjectIsolate")).equals("false")) {
            isSystem = true;
        }
        return isSystem;
    }

    protected String getUnionAllTable() {
        return "T_MM_Project";
    }

    protected String getXmlFileName(BatchActionEnum batchActionEnum) {
        return "com.kingdee.eas.mm.project.app.xml.project.xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void insertIntoAssist(Context ctx, String[] id, boolean isSystem) throws BOSException, EASBizException {
        String[] updateSql = new String[id.length];
        String[] insertSql = new String[id.length];
        String[] updateCompanySql = new String[id.length];
        StringBuffer temp = new StringBuffer();
        for (int i = 0; i < id.length; ++i) {
            temp.setLength(0);
            boolean flag = true;
            temp.append("select FProjectAssistID,FNUMBER,FNAME_L1,FNAME_L2,FNAME_L3 from t_mm_project where fid ='").append(id[i]).append("'\r\n");
            temp.append(" and FProjectAssistID is not null \r\n");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)temp.toString());
            if (rs != null && rs.size() > 0) {
                try {
                    while (rs.next()) {
                        if (rs.getString("FProjectAssistID") == null) continue;
                        String projectAssistID = rs.getString("FProjectAssistID");
                        com.kingdee.eas.basedata.assistant.ProjectInfo pInfo = com.kingdee.eas.basedata.assistant.ProjectFactory.getLocalInstance((Context)ctx).getProjectInfo((IObjectPK)new ObjectUuidPK(projectAssistID));
                        pInfo.setStatus(ProjectStatus.EXECUTE);
                        String number = rs.getString("FNUMBER");
                        String FNAME_L1 = rs.getString("FNAME_L1");
                        String FNAME_L2 = rs.getString("FNAME_L2");
                        String FNAME_L3 = rs.getString("FNAME_L3");
                        pInfo.setNumber(number);
                        pInfo.setName(FNAME_L1, Locale.ENGLISH);
                        pInfo.setName(FNAME_L2, Locale.SIMPLIFIED_CHINESE);
                        pInfo.setName(FNAME_L3, Locale.TRADITIONAL_CHINESE);
                        pInfo.setDisplayName(FNAME_L1, Locale.ENGLISH);
                        pInfo.setDisplayName(FNAME_L2, Locale.SIMPLIFIED_CHINESE);
                        pInfo.setDisplayName(FNAME_L3, Locale.TRADITIONAL_CHINESE);
                        com.kingdee.eas.basedata.assistant.ProjectFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectUuidPK(projectAssistID), (CoreBaseInfo)pInfo);
                        flag = false;
                    }
                }
                catch (SQLException e) {
                    throw new SQLDataException(e);
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
            ProjectInfo projectInfo = ProjectFactory.getLocalInstance(ctx).getProjectInfo((IObjectPK)new ObjectUuidPK(id[i].toString()));
            StorageOrgUnitInfo orgInfo = projectInfo.getSetUpStorageOrg();
            INewOrgUnitFacade iNOU = NewOrgUnitFacadeFactory.getLocalInstance((Context)ctx);
            OrgUnitInfo fiInfo = null;
            if (orgInfo != null) {
                fiInfo = iNOU.getDelegateUnit(orgInfo.getId().toString(), OrgType.Company);
            }
            String companyId = "";
            if (fiInfo != null) {
                companyId = fiInfo.getId().toString();
            }
            if (!flag) continue;
            temp.setLength(0);
            BOSUuid bosid = BOSUuid.create((String)"DADE05EE");
            temp.append("insert into T_BD_Project").append(" (FID,FNUMBER,FNAME_L1,FNAME_L2,FNAME_L3,FDISPLAYNAME_L1,FDISPLAYNAME_L2,FDISPLAYNAME_L3,FType,FIsListItem,\r\n");
            temp.append("FScheduleStartDate,FschedulEndDate,FStatus,FIsSysCreate,FLONGNUMBER,FISLEAF,FLEVEL,\r\n");
            temp.append("FCreatorID,FLastUpdateUserID,FPrjManagerID) ").append("select '").append(bosid.toString());
            temp.append("' fid, FNUMBER,FNAME_L1,FNAME_L2,FNAME_L3,FNAME_L1,FNAME_L2,FNAME_L3,3 FTYPE,1 FIsListItem,\r\n");
            temp.append("to_date(tochar( FPlanBeginTime,'yyyy-mm-dd')||' 00:00:00')  FScheduleStartDate,\r\n");
            temp.append("to_date(tochar( FPlanEndTime,'yyyy-mm-dd')||' 00:00:00' ) FschedulEndDate ,1 Fstatus,1 FIsSysCreate,\r\n");
            temp.append("FNUMBER FLONGNUMBER,1 FISLEAF, 1 FLEVEL,FCreatorID,FLastUpdateUserID,FPersonID from t_mm_project  where fid ='");
            temp.append(id[i]).append("' and FProjectAssistID is null");
            insertSql[i] = temp.toString();
            temp.setLength(0);
            temp.append("update t_mm_project set FProjectAssistID='").append(bosid.toString()).append("' where fid ='").append(id[i]).append("' and FProjectAssistID is null");
            updateSql[i] = temp.toString();
            temp.setLength(0);
            temp.append(" update t_bd_project set FCOMPANYID='").append(companyId.toString()).append("' where fid ='").append(bosid.toString()).append("'");
            updateCompanySql[i] = temp.toString();
            temp.setLength(0);
        }
        Connection conn = null;
        Statement statement = null;
        try {
            int i;
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.createStatement();
            for (i = 0; i < insertSql.length; ++i) {
                if (insertSql[i] == null) continue;
                statement.executeUpdate(insertSql[i]);
            }
            for (i = 0; i < updateSql.length; ++i) {
                if (updateSql[i] == null) continue;
                statement.executeUpdate(updateSql[i]);
            }
            for (i = 0; i < updateCompanySql.length; ++i) {
                if (updateCompanySql[i] == null) continue;
                statement.executeUpdate(updateCompanySql[i]);
            }
        }
        catch (SQLException sQLException) {
            com.kingdee.util.db.SQLUtils.cleanup((Statement)statement, (Connection)conn);
            catch (Throwable throwable) {
                com.kingdee.util.db.SQLUtils.cleanup(statement, (Connection)conn);
                throw throwable;
            }
        }
        com.kingdee.util.db.SQLUtils.cleanup((Statement)statement, (Connection)conn);
    }

    protected void projectAssistRefCheck(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        String idStr = SQLUtil.arrayToString((Object[])batchResults.getToDoIdsArray());
        BizReference ref = null;
        String id = "";
        String projectAssistID = "";
        String projectAssistNumber = "";
        String sql = "select FID ,FProjectAssistID ,FNumber from t_mm_project where fid in(" + idStr + ")";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs != null && rs.size() > 0) {
            try {
                while (rs.next()) {
                    ICostObject iCostObject;
                    String updatesql;
                    if (rs.getString("FProjectAssistID") == null) continue;
                    id = rs.getString("FID");
                    projectAssistID = rs.getString("FProjectAssistID");
                    projectAssistNumber = rs.getString("FNumber");
                    ObjectUuidPK projectAssistPK = new ObjectUuidPK(projectAssistID);
                    ref = this.getReference(ctx, BOSUuid.read((String)projectAssistID));
                    if (ref == null) {
                        this.deleteBdProject(ctx, batchResults, "'" + id + "'");
                        updatesql = " update t_mm_project set FProjectAssistID=null where fid ='" + id + "' and FProjectAssistID is not null";
                        DbUtil.execute((Context)ctx, (String)updatesql);
                    } else {
                        updatesql = " update T_BD_Project set Fstatus = 2 where fid ='" + projectAssistID + "'";
                        DbUtil.execute((Context)ctx, (String)updatesql);
                    }
                    if (!(iCostObject = CostObjectFactory.getLocalInstance((Context)ctx)).checkMaterialUsed(projectAssistPK.toString(), projectAssistNumber, 1) && !ProjectRef.getInstance().IsRefrenced(ctx, (IObjectPK)projectAssistPK)) continue;
                    batchResults.addError(id, (Exception)new com.kingdee.eas.basedata.assistant.ProjectException(com.kingdee.eas.basedata.assistant.ProjectException.DELETEFAIL));
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    private void setDBProjectStatus(Context ctx, Set ids, int status) throws BOSException, EASBizException {
        if (ids != null && ids.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
            view.setFilter(filterInfo);
            com.kingdee.eas.basedata.assistant.ProjectCollection pInfos = com.kingdee.eas.basedata.assistant.ProjectFactory.getLocalInstance((Context)ctx).getProjectCollection(view);
            if (pInfos != null && pInfos.size() > 0) {
                for (int i = 0; i < pInfos.size(); ++i) {
                    pInfos.get(i).setStatus(ProjectStatus.getEnum((int)status));
                    com.kingdee.eas.basedata.assistant.ProjectFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectUuidPK(pInfos.get(i).getId()), (CoreBaseInfo)pInfos.get(i));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BizReference getReference(Context ctx, BOSUuid objID) throws BOSException {
        boolean found = false;
        BizReference reference = null;
        Connection conn = null;
        ResultSet rs = null;
        PreparedStatement ps = null;
        Statement stat2 = null;
        IRowSet rsTemp = null;
        String matched = new StringBuffer().append("select ").append("FRefTableName,").append("FRefFieldName,").append("FRefEntityName,").append("FRefEntityAlias_L1,").append("FRefEntityAlias_L2,").append("FRefEntityAlias_L3 ").append("FROM T_SYS_EntityRef ").append("where FIsBosFK=1 and FBosType=? ").append("order by FOrder desc").toString();
        try {
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(matched);
            ps.setString(1, objID.getType().toString());
            rs = ps.executeQuery();
            String id = objID.toString();
            StringBuffer sql = new StringBuffer();
            int i = 1;
            boolean hasExecuted = false;
            while (rs.next()) {
                sql = ProjectControllerBean.getCheckDataSql(sql, rs, id);
                hasExecuted = false;
                if (i % 50 == 0) {
                    rsTemp = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                    hasExecuted = true;
                    if (rsTemp.next()) {
                        found = true;
                        break;
                    }
                    sql.setLength(0);
                }
                ++i;
            }
            if (sql.length() > 0 && !hasExecuted && (rsTemp = DbUtil.executeQuery((Context)ctx, (String)sql.toString())).next()) {
                found = true;
            }
            if (rsTemp != null) {
                rsTemp.beforeFirst();
            }
            while (rsTemp != null && rsTemp.next()) {
                if (found) {
                    reference = new BizReference();
                    reference.setRefTableName(rsTemp.getString(1));
                    reference.setRefFieldName(rsTemp.getString(2));
                    reference.setRefEntityName(rsTemp.getString(3));
                    reference.setRefEntityAlias_L1(rsTemp.getString(4));
                    reference.setRefEntityAlias_L2(rsTemp.getString(5));
                    reference.setRefEntityAlias_L3(rsTemp.getString(6));
                }
                if (!rsTemp.getString(3).equalsIgnoreCase("project")) break;
                reference = null;
            }
            com.kingdee.util.db.SQLUtils.cleanup((ResultSet)rs);
        }
        catch (SQLException e1) {
            throw new RuntimeException((Throwable)new BizReferenceException(BizReferenceException.REFERENCE_DATA_ERROR, (Throwable)e1));
            catch (SQLDataException e) {
                e.printStackTrace();
                return reference;
            }
        }
        com.kingdee.util.db.SQLUtils.cleanup((ResultSet)rsTemp);
        com.kingdee.util.db.SQLUtils.cleanup((Statement)ps);
        com.kingdee.util.db.SQLUtils.cleanup(stat2);
        com.kingdee.util.db.SQLUtils.cleanup((Connection)conn);
        return reference;
        finally {
            com.kingdee.util.db.SQLUtils.cleanup(rs);
            com.kingdee.util.db.SQLUtils.cleanup(rsTemp);
            com.kingdee.util.db.SQLUtils.cleanup((Statement)ps);
            com.kingdee.util.db.SQLUtils.cleanup(stat2);
            com.kingdee.util.db.SQLUtils.cleanup((Connection)conn);
        }
    }

    private static StringBuffer getCheckDataSql(StringBuffer sql, ResultSet rs, String objID) throws SQLException {
        String FRefTableName = rs.getString(1);
        String FRefFieldName = rs.getString(2);
        String FRefEntityName = StringEscapeUtils.escapeSql((String)rs.getString(3));
        String FRefEntityAlias_L1 = StringEscapeUtils.escapeSql((String)rs.getString(4));
        String FRefEntityAlias_L2 = StringEscapeUtils.escapeSql((String)rs.getString(5));
        String FRefEntityAlias_L3 = StringEscapeUtils.escapeSql((String)rs.getString(6));
        if (sql.length() > 0) {
            sql.append(" union all ");
        }
        sql.append(" select ");
        sql.append("'" + FRefTableName + "',");
        sql.append("'" + FRefFieldName + "',");
        sql.append("'" + FRefEntityName + "',");
        sql.append("'" + FRefEntityAlias_L1 + "',");
        sql.append("'" + FRefEntityAlias_L2 + "',");
        sql.append("'" + FRefEntityAlias_L3 + "' ");
        sql.append(" where exists (select ");
        sql.append(FRefFieldName);
        sql.append(" from ");
        sql.append(FRefTableName);
        sql.append(" where ");
        sql.append(FRefFieldName);
        sql.append(" = '");
        sql.append(objID);
        sql.append("' ");
        sql.append(" ) ");
        return sql;
    }

    protected void refCheck(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        if (ctx == null || batchResults == null) {
            return;
        }
        String[] idArray = batchResults.getToDoIdsArray();
        if (idArray == null) {
            return;
        }
        if (idArray.length == 0) {
            return;
        }
        if (batchResults.getToDoIdsArray().length > 0) {
            BizReference ref = null;
            for (int i = 0; i < batchResults.getToDoIdsArray().length; ++i) {
                String id = batchResults.getToDoIdsArray()[i];
                ref = ReferenceDAO.getReference((Context)ctx, (BOSUuid)BOSUuid.read((String)id));
                if (ref == null) continue;
                batchResults.addError(id, (Exception)new ObjectReferedException((Object)ref));
            }
        }
        for (String id : idArray) {
            String refEntityAlias;
            ObjectReferedException orException;
            if (id == null || id.trim().length() == 0) continue;
            ActionResult ar = batchResults.getActionResult((Object)id);
            ObjectReferedException objectReferedException = ar.getException() == null ? null : (orException = ar.getException() instanceof ObjectReferedException ? (ObjectReferedException)ar.getException() : null);
            BizReference bizReference = orException == null ? null : (orException.getReferingObject() == null ? null : (orException.getReferingObject() instanceof BizReference ? (BizReference)orException.getReferingObject() : null));
            String string = refEntityAlias = bizReference == null ? null : bizReference.getRefEntityAlias(ctx.getLocale());
            if (orException == null) continue;
            if (refEntityAlias != null && refEntityAlias.trim().length() > 0) {
                throw new EASBizException(new NumericExceptionSubItem("\u6570\u636e\u68c0\u67e5\u4e0d\u901a\u8fc7", "\u8be5\u6570\u636e\u5df2\u88ab\u3010" + refEntityAlias + "\u3011\u5f15\u7528"));
            }
            throw new EASBizException(new NumericExceptionSubItem("\u6570\u636e\u68c0\u67e5\u4e0d\u901a\u8fc7", "\u8be5\u6570\u636e\u5df2\u88ab\u5176\u4ed6\u5355\u636e\u5f15\u7528"));
        }
    }

    protected void updateSecondaryTNDelivery(Context ctx) throws BOSException, EASBizException {
        if (ctx == null) {
            return;
        }
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put("Action", "Fill");
        try {
            Method stndCBFillMethod;
            Class<?> stndCBClass = Class.forName("com.kingdee.eas.industry.emm.pcp.app.SecondaryTNDeliveryControllerBean");
            Object stndCBI = stndCBClass.newInstance();
            Method method = stndCBFillMethod = stndCBClass == null ? null : stndCBClass.getMethod("batchExecute", Context.class, Map.class);
            if (stndCBFillMethod != null) {
                stndCBFillMethod.invoke(stndCBI, ctx, paramsMap);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
    }
}

