/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.base.report.formatcondition.Appearance;
import com.kingdee.eas.base.report.formatcondition.ReportFormatConditions;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.mm.project.app.ReportUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.LocaleUtils;
import java.awt.Color;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Locale;

public class ProjectFeedBackCostReport
extends ReportServerBase {
    private String createTable() throws BOSException {
        String cr = "\r\n";
        StringBuffer sqlCreateTable = new StringBuffer();
        String expandTablName = null;
        TempTablePool pool = TempTablePool.getInstance((Context)this.getContext());
        sqlCreateTable.append("create table t_temp_FeedBackCost (").append(cr).append("FID varchar(44) not null,").append(cr).append("FParentID varchar(44) null,").append(cr).append("FSTORAGEORGUNITNAME varchar(255) null,").append(cr).append("FPROJECTNAME varchar(255) null,").append(cr).append("FTASKTYPENAME varchar(255) null,").append(cr).append("FTASKNAME varchar(255), ").append(cr).append("FMATERIALNAME varchar(255),").append(cr).append("FTOTALCOST numeric(17,4) not null default 0,").append(cr).append("FKACTTOTALCOST numeric(17,4) not null default 0,").append(cr).append("TOTALCOMPLETE numeric(21,8) not null default 0,").append(cr).append("FUNITCOST numeric(17,4) not null default 0,").append(cr).append("FADMINORGNAME varchar(255), ").append(cr).append("FPERSONNAME varchar(255),").append(cr).append("LV int ,").append(cr).append("FQTYPRECISION int ,").append(cr).append("FWBSNumber varchar(255) ,").append(cr).append("FLevel int ,").append(cr).append("FGroup varChar(10)").append(cr).append(")");
        try {
            expandTablName = pool.createTempTable(sqlCreateTable.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return expandTablName;
    }

    private String buildWhereFilters(RptParams filter, String conFlag) throws BOSException {
        StringBuffer sb = new StringBuffer();
        String sfilter = "";
        if (conFlag.equals("gethiberarchydata")) {
            if (filter.getString("storageOrgUnit.number") != null && !"".equals(filter.getString("storageOrgUnit.number"))) {
                sb.append(" and org.FNUMBER in (" + ReportUtil.StringUtil(filter.getString("storageOrgUnit.number")));
                sb.append(") ");
            }
            if (filter.getString("planTotalCostF") != null && !"".equals(filter.getString("planTotalCostF"))) {
                sb.append(" and b.FTOTALCOST >=").append(ReportUtil.formatNumber(filter.getString("planTotalCostF")));
            }
            if (filter.getString("planTotalCostT") != null && !"".equals(filter.getString("planTotalCostT"))) {
                sb.append(" and b.FTOTALCOST <=").append(ReportUtil.formatNumber(filter.getString("planTotalCostT")));
            }
            if (filter.getString("planUnitCostF") != null && !"".equals(filter.getString("planUnitCostF"))) {
                sb.append(" and b.FUNITCOST >=").append(ReportUtil.formatNumber(filter.getString("planUnitCostF")));
            }
            if (filter.getString("planUnitCostT") != null && !"".equals(filter.getString("planUnitCostT"))) {
                sb.append(" and b.FUNITCOST <=").append(ReportUtil.formatNumber(filter.getString("planUnitCostT")));
            }
            if (filter.getString("project.numberF") != null && !"".equals(filter.getString("project.numberF"))) {
                sb.append(" and x.Fnumber in (" + ReportUtil.StringUtil(filter.getString("project.numberF")));
                sb.append(") ");
            }
            if (filter.getString("task.numberF") != null && !"".equals(filter.getString("task.numberF"))) {
                sb.append(" and b.Fnumber in (" + ReportUtil.StringUtil(filter.getString("task.numberF")));
                sb.append(") ");
            }
            if (filter.getString("dateF") != null && !"".equals(filter.getString("dateF"))) {
                sb.append(" and b.FAUDITTIME >=to_date('" + filter.getString("dateF"));
                sb.append("') ");
            }
            if (filter.getString("dateT") != null && !"".equals(filter.getString("dateT"))) {
                sb.append(" and b.FAUDITTIME <=to_date('" + filter.getString("dateT"));
                sb.append("') ");
            }
        } else if (conFlag.equals("first")) {
            if (filter.getString("storageOrgUnit.number") != null && !"".equals(filter.getString("storageOrgUnit.number"))) {
                sb.append(" and org.FNUMBER in (" + ReportUtil.StringUtil(filter.getString("storageOrgUnit.number")));
                sb.append(") ");
            }
            if (filter.getString("planTotalCostF") != null && !"".equals(filter.getString("planTotalCostF"))) {
                sb.append(" and b.FTOTALCOST >=").append(ReportUtil.formatNumber(filter.getString("planTotalCostF")));
            }
            if (filter.getString("planTotalCostT") != null && !"".equals(filter.getString("planTotalCostT"))) {
                sb.append(" and b.FTOTALCOST <=").append(ReportUtil.formatNumber(filter.getString("planTotalCostT")));
            }
            if (filter.getString("planUnitCostF") != null && !"".equals(filter.getString("planUnitCostF"))) {
                sb.append(" and b.FUNITCOST >=").append(ReportUtil.formatNumber(filter.getString("planUnitCostF")));
            }
            if (filter.getString("planUnitCostT") != null && !"".equals(filter.getString("planUnitCostT"))) {
                sb.append(" and b.FUNITCOST <=").append(ReportUtil.formatNumber(filter.getString("planUnitCostT")));
            }
            if (filter.getString("dateF") != null && !"".equals(filter.getString("dateF"))) {
                sb.append(" and b.FAUDITTIME >=to_date('" + filter.getString("dateF"));
                sb.append("') ");
            }
            if (filter.getString("dateT") != null && !"".equals(filter.getString("dateT"))) {
                sb.append(" and b.FAUDITTIME <=to_date('" + filter.getString("dateT"));
                sb.append("') ");
            }
        }
        if (conFlag.equals("project") && filter.getString("project.numberF") != null && !"".equals(filter.getString("project.numberF"))) {
            sb.append(" and b.Fnumber in (" + ReportUtil.StringUtil(filter.getString("project.numberF")));
            sb.append(") ");
        }
        if (conFlag.equals("task")) {
            if (filter.getString("project.numberF") != null && !"".equals(filter.getString("project.numberF"))) {
                sb.append(" and x.Fnumber in (" + ReportUtil.StringUtil(filter.getString("project.numberF")));
                sb.append(") ");
            }
            if (filter.getString("task.numberF") != null && !"".equals(filter.getString("task.numberF"))) {
                sb.append(" and b.Fnumber in (" + ReportUtil.StringUtil(filter.getString("task.numberF")));
                sb.append(") ");
            }
        } else if (conFlag.equals("last")) {
            if (filter.getString("completeF") != null && !"".equals(filter.getString("completeF"))) {
                sb.append(" and a.TOTALCOMPLETE >=").append(ReportUtil.formatNumber(filter.getString("completeF")));
            }
            if (filter.getString("completeT") != null && !"".equals(filter.getString("completeT"))) {
                sb.append(" and a.TOTALCOMPLETE <=").append(ReportUtil.formatNumber(filter.getString("completeT")));
            }
        } else if (conFlag.equals("orcondition")) {
            // empty if block
        }
        sfilter = sb.toString();
        return sfilter;
    }

    protected IRowSet getReportData(String reportId, RptParams filter) throws Exception {
        StringBuffer sqlBuff = new StringBuffer();
        sqlBuff.append(this.constructSql(filter, true));
        String tableName = this.createTable();
        String insertTemp = "insert into " + tableName + " " + sqlBuff.toString();
        DbUtil.execute((Context)this.getContext(), (String)insertTemp);
        StringBuffer update = new StringBuffer("");
        update.append("update ").append(tableName).append(" as t0 set (FGroup) = (select case when charindex('.',t0.FWBSNumber)=0 then t0.FWBSNumber else substring(t0.FWBSNumber,0,charindex('.',t0.FWBSNumber)-1) end").append(" from ").append(tableName).append(" t1 where t0.fid=t1.fid)");
        DbUtil.execute((Context)this.getContext(), (String)update.toString());
        StringBuffer query = new StringBuffer("");
        query.append("select t0.FID,t0.FPARENTID,t0.FSTORAGEORGUNITNAME,t0.FPROJECTNAME,t0.FTASKTYPENAME,t0.FTASKNAME,").append(" t0.FMATERIALNAME,t0.FTOTALCOST,t0.FKACTTOTALCOST,t0.TOTALCOMPLETE,t0.FUNITCOST,t0.FADMINORGNAME,t0.FPERSONNAME,").append(" t0.LV,t0.FQTYPRECISION ").append(" from ").append(tableName).append(" t0").append(" where length(FWBSNumber) in ( ").append(" (select min(length(FWBSNumber)) from ").append(tableName).append(" t1 where t0.FGroup=t1.FGroup group by FGroup) )");
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)query.toString());
        TempTablePool pool = TempTablePool.getInstance((Context)this.getContext());
        if (tableName != null) {
            pool.releaseTable(tableName);
        }
        return rs;
    }

    protected ReportTitles getReportTitles(String reportId, RptParams filter) throws BaseException {
        String locStr = LocaleUtils.getLocaleString((Locale)this.getContext().getLocale());
        String storagenumber = "";
        if (filter.getString("storageOrgUnit.number") != null && !"".equals(filter.getString("storageOrgUnit.number"))) {
            storagenumber = ReportUtil.StringUtil(filter.getString("storageOrgUnit.number"));
            StringBuffer sql = new StringBuffer();
            sql.append(" select FName_").append(locStr).append(" from T_ORG_Storage storage where  storage.FNumber in(" + storagenumber + ")");
            storagenumber = ReportUtil.getNameByNumber(sql, storagenumber, this.getContext());
        }
        String projectF = "";
        if (filter.getString("project.numberF") != null && !filter.getString("project.numberF").equals("")) {
            projectF = ReportUtil.StringUtil(filter.getString("project.numberF"));
            StringBuffer sql = new StringBuffer();
            sql.append("select FName_").append(locStr).append(" from t_mm_project p where p.Fnumber in (" + projectF + ")");
            projectF = ReportUtil.getNameByNumber(sql, projectF, this.getContext());
        }
        ReportTitles titles = new ReportTitles();
        titles.AddTitle(0, ProjectFeedBackCostReport.getResource(this.getContext(), "STORAGEUNIT") + storagenumber);
        titles.AddTitle(3, ProjectFeedBackCostReport.getResource(this.getContext(), "PROJECT") + projectF);
        titles.AddTitle(6, ProjectFeedBackCostReport.getResource(this.getContext(), "BEGINTIME") + (filter.getString("dateF") == null ? "" : filter.getString("dateF").substring(0, 10)));
        titles.AddTitle(9, ProjectFeedBackCostReport.getResource(this.getContext(), "ENDTIME") + (filter.getString("dateT") == null ? "" : filter.getString("dateT").substring(0, 10)));
        return titles;
    }

    protected ReportFormatConditions buildReportFormatConditions(String reportID) throws Exception {
        ReportFormatConditions reportFormatConditions = new ReportFormatConditions();
        Appearance a = new Appearance();
        a.backColor = Color.YELLOW;
        reportFormatConditions.add("TOTALCOMPLETE", 6, (Object)new BigDecimal(100), a, false);
        return reportFormatConditions;
    }

    public static String getResource(Context ctx, String strKey) {
        String strTemp = ResourceBase.getString((String)"com.kingdee.eas.mm.project.ProjectFeedBackResource", (String)strKey, (Locale)ctx.getLocale());
        return strTemp;
    }

    public String constructSql(RptParams filter, boolean first) throws BOSException {
        String locStr = LocaleUtils.getLocaleString((Locale)this.getContext().getLocale());
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append(" select FID,FPARENTID,FSTORAGEORGUNITNAME, ").append(" FPROJECTNAME,FTASKTYPENAME,FTASKNAME,FMATERIALNAME,FTOTALCOST,FKACTTOTALCOST, ").append("TOTALCOMPLETE,FUNITCOST,FADMINORGNAME,FPERSONNAME,LV ,FPRECISION as FQTYPRECISION,FWBSNumber,FLevel,null  from (").append(" select b.FID,b.FPARENTID,b.FPROJECTNAME,org.Fname_").append(locStr).append(" FSTORAGEORGUNITNAME,  ").append("FPROJECTTASKNAME FTASKNAME,projecttasktypename FTASKTYPENAME, c.fname_").append(locStr).append(" FMATERIALNAME, ").append("case when b.FTOTALCOST=0 then 0 else round(b.FACTTOTALCOST/b.FTOTALCOST,4)*100 end TOTALCOMPLETE,b.FTOTALCOST,").append(" b.FACTTOTALCOST FKACTTOTALCOST,b.FUNITCOST,d.fname_").append(locStr).append(" FCARNAME,e.FNAME_").append(locStr).append(" FADMINORGNAME, f.FNAME_").append(locStr).append(" FPERSONNAME,LV,cur.FPRECISION,FWBSNumber,b.FLevel  from (").append(" select b.FControlUnitID FSTORAGEORGUNITID,b.FID,b.FNAME_").append(locStr).append(" FPROJECTNAME, null FPARENTID,null FPROJECTTASKNAME,b.FMATERIALID,b.FTOTALCOST,b.FUNITCOST,").append(" b.FACTTOTALCOST,null FCARNUMBERID,b.FADMINORGUNITID,b.FPERSONID,b.Fname_").append(locStr).append(" projectname, null projecttasktypename,b.fnumber projectnumber,null tasknumber,0 LV,").append("to_date(tochar(b.FAUDITTIME ,'yyyy-mm-dd HH24:MI:SS')) FAUDITTIME  ,b.FCURRENCYID,null FWBSNumber,0 FLevel from t_mm_project b").append(" where 1=1  ").append(this.buildWhereFilters(filter, "project")).append(" union all select  b.FSTORAGEORGUNITID,b.FID,x.FNAME_").append(locStr).append(" FPROJECTNAME,b.FPARENTID,b.FNAME_").append(locStr).append("  FPROJECTTASKNAME,b.FMATERIALID,b.FTOTALCOST,").append(" b.FUNITCOST,b.FACTTOTALCOST,b.FCARNUMBERID,b.FADMINORGUNITID,b.FPERSONID,x.Fname_").append(locStr).append(" projectname,g.Fname_").append(locStr).append(" projecttasktypename,null projectnumber,").append(" b.fnumber tasknumber,case when exists(select null from t_mm_projecttask a where a.FParentId=b.Fid) then 2 else 1 end LV, ").append("to_date(tochar(b.FAUDITTIME ,'yyyy-mm-dd HH24:MI:SS')) FAUDITTIME   ,b.FCURRENCYID,b.FWBSNumber,b.FLevel from t_mm_projecttask b").append(" inner join t_mm_project x on b.FPROJECTID = x.Fid left join T_MM_ProjectDictData g on g.fid= b.ftasktypeid  left join t_mm_projecttask t on b.fparentid=t.fid left join T_ORG_Storage org on org.FID= t.FSTORAGEORGUNITID ").append(" where 1=1 ").append(this.buildWhereFilters(filter, "orcondition")).append(this.buildWhereFilters(filter, "task")).append(" ) b  inner join T_ORG_Storage org on org.FID= b.FSTORAGEORGUNITID left join t_bd_material c on c.fid =b.FMATERIALID left join T_MM_ProjectCar d on  d.fid=b.fcarnumberid ").append(" left join T_ORG_Admin e on e.fid= b.FAdminOrgUnitID left join T_BD_Person f on f.FID = b.FPersonID ").append(" inner join  t_bd_currency cur on  cur.FID = b.FCURRENCYID ").append(" where 1=1   ").append(this.buildWhereFilters(filter, "first")).append(" ) a where 1=1 ").append(this.buildWhereFilters(filter, "last")).append(" order by a.FPROJECTNAME,a.FTASKNAME desc");
        return sqlBuf.toString();
    }

    public IRowSet getHiberarchyData(String reportID, RptParams filter, HashMap rowData) throws BaseException {
        String parentId = (String)rowData.get("FID");
        StringBuffer sqlBuff = new StringBuffer();
        sqlBuff.append(this.constructSql()).append(" where b.FparentID=? ").append(this.buildWhereFilters(filter, "gethiberarchydata")).append(") a where 1=1 ").append(this.buildWhereFilters(filter, "last")).append(" order by a.FPROJECTNAME,a.FTASKNAME desc");
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sqlBuff.toString(), (Object[])new Object[]{parentId});
        return rs;
    }

    public String constructSql() throws BOSException {
        String locStr = LocaleUtils.getLocaleString((Locale)this.getContext().getLocale());
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("\tselect FID,FPARENTID,FSTORAGEORGUNITNAME,  FPROJECTNAME,FTASKTYPENAME,FTASKNAME,FMATERIALNAME,FTOTALCOST,").append(" FKACTTOTALCOST,TOTALCOMPLETE,FUNITCOST,FADMINORGNAME,FPERSONNAME,LV ,FPRECISION as FQTYPRECISION  from ( ").append(" select b.FID,b.FPARENTID,x.Fname_").append(locStr).append(" FPROJECTNAME,org.Fname_").append(locStr).append(" FSTORAGEORGUNITNAME,b.Fname_").append(locStr).append(" FTASKNAME,g.Fname_").append(locStr).append(" FTASKTYPENAME,c.fname_").append(locStr).append(" FMATERIALNAME,case when b.FTOTALCOST=0 then 0 else round(b.FACTTOTALCOST/b.FTOTALCOST,4)*100 end TOTALCOMPLETE,").append(" b.FTOTALCOST, b.FACTTOTALCOST FKACTTOTALCOST,b.FUNITCOST,e.FNAME_").append(locStr).append(" FADMINORGNAME,f.FNAME_").append(locStr).append(" FPERSONNAME,").append(" case when exists(select null from t_mm_projecttask a where a.FParentId=b.Fid) then 2 else 1 end LV ,cur.FPRECISION   from t_mm_projecttask b ").append(" inner join t_mm_project x on b.FPROJECTID = x.Fid left join T_MM_ProjectDictData g on g.fid= b.ftasktypeid  ").append(" inner join T_ORG_Storage org on org.FID= b.FSTORAGEORGUNITID left join t_bd_material c on c.fid =b.FMATERIALID ").append(" left join T_MM_ProjectCar d on  d.fid=b.fcarnumberid  left join T_ORG_Admin e on e.fid= b.FAdminOrgUnitID ").append(" left join T_BD_Person f on f.FID = b.FPersonID  ").append(" inner join  t_bd_currency cur on  cur.FID = b.FCURRENCYID ");
        return sqlBuf.toString();
    }
}

