/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.common.app.BillUpdater;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.planning.app.mrp.MRPUtil;
import com.kingdee.eas.mm.project.ProjectFeedbackException;
import com.kingdee.eas.mm.project.app.ProjectControllerBean;
import com.kingdee.eas.mm.project.app.ProjectTaskControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;

public class ProjectFeedbackUpdater
extends BillUpdater {
    private String type;

    public ProjectFeedbackUpdater(Context ctx) {
        super(ctx);
    }

    public void execute() throws BOSException, EASBizException {
        this.UpdateProjectAndTask("PROJECT");
        this.afterExecute();
        this.UpdateProjectAndTask("PROJECTTASK");
    }

    protected String getFID() {
        return this.type.equals("PROJECT") ? "FSourceBillID" : "FSOURCEBILLENTRYID";
    }

    public boolean ProjectClosedCheck() throws BOSException, EASBizException {
        boolean ret = true;
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("select  t0.FBillID from ");
        sqlBuf.append(this.sourceDataTable).append(" t0 ").append("inner join ").append(this.targetTable).append(" t1  on t1.FID = t0.").append(this.getFID()).append(" where t1.Fbasestatus=").append(7);
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sqlBuf.toString());
        try {
            sqlBuf.setLength(0);
            sqlBuf.append("delete ").append(this.sourceDataTable).append(" where ").append("FBillID").append(" in (");
            int i = 0;
            HashMap<String, String> errMap = new HashMap<String, String>();
            while (rs != null && rs.next()) {
                String billID = rs.getString("FBillID");
                if (errMap.containsKey(billID)) continue;
                this.batchResults.addError(billID, (Exception)((Object)this.throwExcpetion));
                errMap.put(billID, "1");
                sqlBuf.append(i > 0 ? "," : " ").append("?");
                ++i;
            }
            sqlBuf.append(")");
            if (i > 0 && this.isDeleteTempData) {
                DbUtil.execute((Context)this.ctx, (String)sqlBuf.toString(), (Object[])errMap.keySet().toArray());
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return ret;
    }

    private void isFinished(String type) throws BOSException, EASBizException {
        StringBuffer strBuf = new StringBuffer();
        if (type != null && type.equals("PROJECT")) {
            strBuf.append(" select max(FActEndTime) FactendTime ,fprojectid FBillID from T_MM_PROJECTFEEDBACK where fprojectid ");
            strBuf.append("in (select distinct b.fid from ");
            strBuf.append(this.sourceDataTable);
            strBuf.append("  a, ");
            strBuf.append(this.targetTable);
            strBuf.append(" b where a.FSOURCEBILLID=b.fid and b.fqty=b.ftotalqty and a.fqty>0) and fprojecttaskid is null ");
            strBuf.append("group by fprojectid");
        } else {
            strBuf.append(" select max(FActEndTime) FactendTime ,fprojecttaskid FBillID from T_MM_PROJECTFEEDBACK where fprojecttaskid ");
            strBuf.append("in (select distinct b.fid from ");
            strBuf.append(this.sourceDataTable);
            strBuf.append("  a, ");
            strBuf.append(this.targetTable);
            strBuf.append(" b where a.FSOURCEBILLENTRYID=b.fid and b.fqty=b.ftotalqty and a.fqty>0) ");
            strBuf.append("group by fprojecttaskid");
        }
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)strBuf.toString());
        if (rs != null && rs.size() > 0) {
            BatchExecuteParamsEntry[] entrys = new BatchExecuteParamsEntry[rs.size()];
            ArrayList<Object[]> paraList = new ArrayList<Object[]>();
            try {
                BatchActionResults batchActionResults;
                int i = 0;
                while (rs.next()) {
                    String FBillID = rs.getString("FBillID");
                    Timestamp FactendTime = rs.getTimestamp("FactendTime");
                    paraList.add(new Object[]{FactendTime, FBillID});
                    BatchExecuteParamsEntry entry = new BatchExecuteParamsEntry(new Class[]{IObjectPK.class});
                    entry.add((Object)new ObjectUuidPK(FBillID));
                    entrys[i++] = entry;
                }
                String sql = "update " + this.targetTable + " set FactualEndTime=? where FID=?";
                DbUtil.executeBatch((Context)this.ctx, (String)sql, paraList);
                if (type != null && type.equals("PROJECT")) {
                    ProjectControllerBean projectBean = new ProjectControllerBean();
                    batchActionResults = projectBean.batchClose(this.ctx, entrys);
                } else if (type != null && type.equals("PROJECTTASK")) {
                    ProjectTaskControllerBean projectTaskBean = new ProjectTaskControllerBean();
                    batchActionResults = projectTaskBean.batchClose(this.ctx, entrys);
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
    }

    private void unAuditUpdateActEnd(String type) throws BOSException {
        String sourceid = "";
        if (type.equalsIgnoreCase("PROJECT")) {
            return;
        }
        sourceid = "FProjectTaskID";
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("update ");
        sqlBuf.append(this.targetTable);
        sqlBuf.append(" as t0 set FActualTotalTime = 0,FActualEndTime = null where FID in ");
        sqlBuf.append(" (select t3.");
        sqlBuf.append(this.getFID());
        sqlBuf.append(" from ");
        sqlBuf.append(this.sourceDataTable);
        sqlBuf.append(" t3) and t0.FActualTotalTime != 0");
        DbUtil.execute((Context)this.ctx, (String)sqlBuf.toString());
        sqlBuf.setLength(0);
        sqlBuf.append("update ");
        sqlBuf.append(this.targetTable);
        sqlBuf.append(" as t0 set FProcessStatusID =null where FID in ");
        sqlBuf.append(" (select t3.");
        sqlBuf.append(this.getFID());
        sqlBuf.append(" from ");
        sqlBuf.append(this.sourceDataTable);
        sqlBuf.append(" t3) ");
        DbUtil.execute((Context)this.ctx, (String)sqlBuf.toString());
    }

    private String[] unAuditUpdateActBegin(String type) throws BOSException {
        String[] results = new String[2];
        String sourceid = "";
        sourceid = type.equalsIgnoreCase("PROJECT") ? "FProjectID" : "FProjectTaskID";
        String updateStatus = "update t_mm_projectfeedback  set fbasestatus = 1 where fid in (select FBillID from " + this.sourceDataTable + ")";
        DbUtil.execute((Context)this.ctx, (String)updateStatus);
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("update ").append(this.targetTable).append(" as t0 set ( FCOMPLETEPERCENT )=(").append("select maxComplete from (select ").append(sourceid).append(" FPROJECTID").append(",max(t1.FCompletepercent) maxComplete ").append(" from ").append(" t_mm_projectfeedback").append(" t1  where t1.fbasestatus = 4 and t1.").append(sourceid).append(" in (select t3.").append(this.getFID()).append(" from ").append(this.sourceDataTable).append(" t3) group by ").append(sourceid).append(") t2 where  t2.FPROJECTID = t0.FID )");
        DbUtil.execute((Context)this.ctx, (String)sqlBuf.toString());
        results[0] = sqlBuf.toString();
        StringBuffer sqlupdate = new StringBuffer("");
        sqlupdate.append("update ").append(this.targetTable).append(" as t0 set (FCOMPLETEPERCENT, FactualBeginTime)=(select 0,null from ").append("(select distinct t1.").append(this.getFID()).append(" fsourceid from ").append(this.sourceDataTable).append(" t1 where (select count(t2.FID) from  ").append("t_mm_projectfeedback ").append(" t2 where t2.").append(sourceid).append(" = t1.").append(this.getFID()).append(" and t2.fbasestatus = 4) = 0 ) t2 where t0.fid=t2.fsourceid )");
        DbUtil.execute((Context)this.ctx, (String)sqlupdate.toString());
        results[1] = sqlupdate.toString();
        return results;
    }

    public void updateProjectComplete() throws BOSException, EASBizException {
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("update ").append(this.targetTable).append(" as t0 set ( FCOMPLETEPERCENT )=(").append("select maxComplete from (select ").append(this.getFID()).append(" FPROJECTID").append(",max(t1.FCOMPLETEPERCENT) maxComplete ").append(" from ").append(this.sourceDataTable).append(" t1  group by ").append(this.getFID()).append(") t2 where  t2.FPROJECTID = t0.FID and t2.maxComplete-t0.FCOMPLETEPERCENT > 0)");
        DbUtil.execute((Context)this.ctx, (String)sqlBuf.toString());
    }

    private void updateTaskProcessStatus() throws BOSException {
        if (!"T_MM_PROJECTTASK".equalsIgnoreCase(this.getTargetTable())) {
            return;
        }
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("update ").append(this.targetTable).append(" as t0 set ( FProcessStatusID )=(").append("select FProcessStatusID from ").append(this.sourceDataTable).append(" t1 where t0.FID = t1.").append(this.getFID()).append(")");
        DbUtil.execute((Context)this.ctx, (String)sqlBuf.toString());
    }

    public void UpdateProjectAndTask(String type) throws EASBizException, BOSException {
        this.type = type;
        String idStr = SQLUtil.arrayToString((Object[])this.batchResults.getToDoIdsArray());
        if (idStr == null || idStr.length() == 0) {
            return;
        }
        String tempTable = ProjectFeedbackUpdater.createTempTable(this.ctx);
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("INSERT INTO ").append(tempTable).append(" (FBILLID,FSOURCEBILLID,FSOURCEBILLENTRYID ,FQTY,FBASEQTY,FACTTOTALCOST,FCOMPLETEPERCENT,FACTBEGINTIME,FACTENDTIME,FACTUSEDTIME,FProcessStatusID) ").append(" SELECT FID FBillID,FPROJECTID FSourceBillID,FPROJECTTASKID FSOURCEBILLENTRYID,FACTQTY FQTY ,FACTBASEQTY FBASEQTY,FACTTOTALCOST,FCOMPLETEPERCENT,FACTBEGINTIME,FACTENDTIME,FACTUSEDTIME,FProcessStatusID FROM T_MM_PROJECTFEEDBACK ");
        if (type.equals("PROJECT")) {
            updateSql.append(" WHERE FPROJECTID IS NOT NULL AND FPROJECTTASKID IS NULL AND FID IN (");
        } else {
            updateSql.append(" WHERE FPROJECTID IS NOT NULL AND FPROJECTTASKID IS NOT NULL AND FID IN (");
        }
        updateSql.append(idStr).append(") ");
        MRPUtil.executeUpdate((Context)this.ctx, (String)updateSql.toString());
        this.setSourceDataTable(tempTable);
        if (type.equals("PROJECT")) {
            this.setTargetTable("T_MM_PROJECT");
        } else {
            this.setTargetTable("T_MM_PROJECTTASK");
        }
        this.isDeleteTempData = true;
        this.setThrowException(false);
        if (type.equals("PROJECT")) {
            this.setThrowExcpetion(new ProjectFeedbackException(ProjectFeedbackException.PROJECT_CLOSED));
        } else {
            this.setThrowExcpetion(new ProjectFeedbackException(ProjectFeedbackException.TASK_CLOSED));
        }
        this.ProjectClosedCheck();
        if (this.isAuditAction) {
            this.setUnBaseQtyExpression("FBaseQTY-FTotalBaseQty");
            this.setThrowException(false);
            this.setThrowExcpetion(new ProjectFeedbackException(ProjectFeedbackException.ACTQTY_BIGGER_PLANQTY));
            this.isDeleteTempData = true;
            this.qtyCheck();
            this.setTransfUnit(true);
            this.setBaseQtyFields(new String[]{"FTOTALBASEQTY"});
            this.setQtyFields(new String[]{"FTOTALQTY"});
            this.setBaseQtyOperation(new String[]{"+"});
            this.setQtyOperation(new String[]{"+"});
            this.writeBack();
            this.updateActTotalcost("+");
            this.setThrowExcpetion(new ProjectFeedbackException(ProjectFeedbackException.UPDATE_COMPLETE_LOSS));
            this.updateProjectComplete();
            this.updateTaskProcessStatus();
            this.updateActBeginTime();
            this.isFinished(type);
        } else {
            this.setBaseQtyFields(new String[]{"FTOTALBASEQTY"});
            this.setQtyFields(new String[]{"FTOTALQTY"});
            this.setBaseQtyOperation(new String[]{"-"});
            this.setQtyOperation(new String[]{"-"});
            this.writeBack();
            this.updateActTotalcost("-");
            this.setThrowExcpetion(new ProjectFeedbackException(ProjectFeedbackException.UPDATE_COMPLETE_LOSS));
            this.unAuditUpdateActBegin(type);
            this.updateTaskProcessStatus();
            this.unAuditUpdateActEnd(type);
        }
        this.deleteTempTableRow(tempTable);
    }

    private void deleteTempTableRow(String tableName) throws BOSException {
        String delSql = "delete from " + tableName;
        DbUtil.execute((Context)this.ctx, (String)delSql);
    }

    public static String createTempTable(Context ctx) throws BOSException, EASBizException {
        String expandTablName = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            StringBuffer sqlBuf = new StringBuffer();
            sqlBuf.append("CREATE TABLE ls (").append("FBillID varchar(44) null,").append("FSourceBillID varchar(44) null,").append("FSourceBillEntryId varchar(44) null,").append("FQty numeric(21,8) not null default 0 ,").append("FBaseQty numeric(21,8) not null default 0, ").append("FACTTOTALCOST numeric(21,8) not null default 0 ,").append("FCOMPLETEPERCENT numeric(21,8) not null default 0,").append("FACTBEGINTIME DATETIME ,").append("FACTENDTIME DATETIME,").append("FACTUSEDTIME numeric(21,8) not null default 0,").append("FProcessStatusID varchar(44)").append(")");
            expandTablName = pool.createTempTable(sqlBuf.toString());
        }
        catch (Exception e1) {
            throw new BOSException((Throwable)e1);
        }
        return expandTablName;
    }

    public void updateActBeginTime() throws BOSException, EASBizException {
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("update ").append(this.targetTable).append(" as t0 set ( FactualBeginTime )=(").append("select minBeginTime from (select ").append(this.getFID()).append(" FPROJECTID").append(",min(t1.FACTBEGINTIME) minBeginTime ").append(" from ").append(this.sourceDataTable).append(" t1  group by ").append(this.getFID()).append(") t2 where  t2.FPROJECTID = t0.FID and (t0.FactualBeginTime is null or t0.FactualBeginTime>t2.minBeginTime) )");
        DbUtil.execute((Context)this.ctx, (String)sqlBuf.toString());
    }

    public void updateActualUsedTime(String express) throws BOSException, EASBizException {
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("update ").append(this.targetTable).append(" as t0 set ( FActualTotalTime )=(").append("select t0.FActualTotalTime ").append(express).append(" t2.TOTALACTUSED from (select ").append(this.getFID()).append(" FPROJECTID").append(",sum(t1.FACTUSEDTIME) TOTALACTUSED ").append(" from ").append(this.sourceDataTable).append(" t1  group by ").append(this.getFID()).append(") t2 where  t2.FPROJECTID = t0.FID)");
    }

    public void updateActTotalcost(String express) throws BOSException, EASBizException {
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("update ").append(this.targetTable).append(" as t0 set ( FACTTOTALCOST )=(").append("select t0.FACTTOTALCOST ").append(express).append(" t2.FACTTOTALCOST from (select ").append(this.getFID()).append(" FPROJECTID").append(",sum(t1.FACTTOTALCOST) FACTTOTALCOST ").append(" from ").append(this.sourceDataTable).append(" t1  group by ").append(this.getFID()).append(") t2 where  t2.FPROJECTID = t0.FID)");
        DbUtil.execute((Context)this.ctx, (String)sqlBuf.toString());
    }

    public void writeBack() throws BOSException, EASBizException {
        int i;
        int i2;
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("update ").append(this.targetTable).append(" as a ").append("set (");
        for (i2 = 0; i2 < this.baseQtyFields.length; ++i2) {
            sqlBuffer.append(i2 > 0 ? "," : " ").append(this.baseQtyFields[i2]);
        }
        for (i2 = 0; i2 < this.qtyFields.length; ++i2) {
            sqlBuffer.append(this.baseQtyFields.length > 0 || i2 > 0 ? "," : " ").append(this.qtyFields[i2]);
        }
        sqlBuffer.append(") = (select ");
        for (i2 = 0; i2 < this.baseQtyFields.length; ++i2) {
            sqlBuffer.append(i2 > 0 ? "," : " ").append("a.").append(this.baseQtyFields[i2]).append(this.baseQtyOperation[i2]).append(" t.FBaseQty ");
        }
        for (i2 = 0; i2 < this.qtyFields.length; ++i2) {
            sqlBuffer.append(this.baseQtyFields.length > 0 || i2 > 0 ? "," : " ").append("a.").append(this.qtyFields[i2]).append(this.qtyOperation[i2]);
            if (this.isTransfUnit) {
                sqlBuffer.append(" round(decimal(t.FBaseQty/b.FBaseConvsRate,21,8),b.FQtyPrecision) ");
                continue;
            }
            sqlBuffer.append(" t.FQty ");
        }
        sqlBuffer.append(" from  (").append("select decimal(sum(FBaseQty),21,8) FBaseQty,decimal(sum(FQty),21,8) FQty,").append(this.getFID()).append(" FSRCID ").append("from ").append(this.sourceDataTable).append(" ").append("group by ").append(this.getFID()).append(") t ");
        if (this.isTransfUnit) {
            sqlBuffer.append(",t_bd_multimeasureunit  b ");
            if (this.type.equals("PROJECTTASK")) {
                sqlBuffer.append("where a.FMaterialID = b.FMaterialID and a.FUnitID = b.fmeasureunitid ");
            } else {
                sqlBuffer.append("where a.FMaterialID = b.FMaterialID and a.FBaseUnitID = b.fmeasureunitid ");
            }
            sqlBuffer.append("and a.fid = t.FSRCID ");
        } else {
            sqlBuffer.append("WHERE a.fid = t.FSRCID ");
        }
        sqlBuffer.append(") ");
        StringBuffer sqlNoMaterial = new StringBuffer();
        sqlNoMaterial.append("update ").append(this.targetTable).append(" as a ").append("set (");
        for (i = 0; i < this.baseQtyFields.length; ++i) {
            sqlNoMaterial.append(i > 0 ? "," : " ").append(this.baseQtyFields[i]);
        }
        for (i = 0; i < this.qtyFields.length; ++i) {
            sqlNoMaterial.append(this.baseQtyFields.length > 0 || i > 0 ? "," : " ").append(this.qtyFields[i]);
        }
        sqlNoMaterial.append(") = (select ");
        for (i = 0; i < this.baseQtyFields.length; ++i) {
            sqlNoMaterial.append(i > 0 ? "," : " ").append("a.").append(this.baseQtyFields[i]).append(this.baseQtyOperation[i]).append(" t.FBaseQty ");
        }
        for (i = 0; i < this.qtyFields.length; ++i) {
            sqlNoMaterial.append(this.baseQtyFields.length > 0 || i > 0 ? "," : " ").append("a.").append(this.qtyFields[i]).append(this.qtyOperation[i]);
            sqlNoMaterial.append(" t.FQty ");
        }
        sqlNoMaterial.append(" from  (").append("select decimal(sum(FBaseQty),21,8) FBaseQty,decimal(sum(FQty),21,8) FQty,").append(this.getFID()).append(" FSRCID ").append("from ").append(this.sourceDataTable).append(" ").append("group by ").append(this.getFID()).append(") t ");
        sqlNoMaterial.append("WHERE a.fid = t.FSRCID and a.fMaterialID is null");
        sqlNoMaterial.append(") ");
        SQLUtil.batchExecuteSql((Context)this.ctx, (String[])new String[]{sqlBuffer.toString(), sqlNoMaterial.toString()});
    }

    public void submitQtyCheck() throws EASBizException, BOSException {
        this.checkQtySubmit("PROJECT");
        this.afterExecute();
        this.checkQtySubmit("PROJECTTASK");
        this.afterExecute();
    }

    public void checkQtySubmit(String type) throws EASBizException, BOSException {
        this.type = type;
        String idStr = SQLUtil.arrayToString((Object[])this.batchResults.getToDoIdsArray());
        if (idStr == null || idStr.length() == 0) {
            return;
        }
        String tempTable = ProjectFeedbackUpdater.createTempTable(this.ctx);
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("INSERT INTO ").append(tempTable).append(" (FBILLID,FSOURCEBILLID,FSOURCEBILLENTRYID ,FQTY,FBASEQTY,FACTTOTALCOST,FCOMPLETEPERCENT,FACTBEGINTIME,FACTENDTIME,FACTUSEDTIME,FProcessStatusID) ").append(" SELECT FID FBillID,FPROJECTID FSourceBillID,FPROJECTTASKID FSOURCEBILLENTRYID,").append("FACTQTY FQTY,FACTBASEQTY FBASEQTY,FACTTOTALCOST,FCOMPLETEPERCENT,FACTBEGINTIME,FACTENDTIME,FACTUSEDTIME,FProcessStatusID FROM T_MM_PROJECTFEEDBACK ");
        if (type.equals("PROJECT")) {
            updateSql.append(" WHERE FPROJECTID IS NOT NULL AND FPROJECTTASKID IS NULL AND FID IN (");
        } else {
            updateSql.append(" WHERE FPROJECTID IS NOT NULL AND FPROJECTTASKID IS NOT NULL AND FID IN (");
        }
        updateSql.append(idStr).append(") ");
        MRPUtil.executeUpdate((Context)this.ctx, (String)updateSql.toString());
        this.setSourceDataTable(tempTable);
        if (type.equals("PROJECT")) {
            this.setTargetTable("T_MM_PROJECT");
        } else {
            this.setTargetTable("T_MM_PROJECTTASK");
        }
        this.setUnBaseQtyExpression("FBaseQTY-FTotalBaseQty");
        this.setThrowException(false);
        this.setThrowExcpetion(new ProjectFeedbackException(ProjectFeedbackException.ACTQTY_BIGGER_PLANQTY));
        this.isDeleteTempData = true;
        this.qtyCheck();
        this.deleteTempTableRow(tempTable);
    }
}

