/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetListener;
import com.kingdee.bos.ctrl.kdf.data.impl.DataSetWrapperFactory;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTColumns;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.SimpleTextRender;
import com.kingdee.bos.ctrl.kdf.util.render.icon.Icon;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.mm.project.util.ITreeTableAdaptor;
import com.kingdee.eas.mm.project.util.SimpleUserObject;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.sql.SQLException;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

public class TreeTableUtil {
    private CoreUI uiObject;
    private KDTable table;
    private String treeColumnName;
    private String levelColumnName;
    protected IRowSet set = null;
    private int treeNodeIndentCell = 16;
    private int treeNodeIconIndentCell = this.treeNodeIndentCell + 6;
    private Set expandedNode = new HashSet();
    private Map parents = new HashMap();
    ITreeTableAdaptor adaptor;

    public TreeTableUtil(CoreUI ui, KDTable table, String treeCol, String levelCol) throws Exception {
        this.uiObject = ui;
        this.table = table;
        this.treeColumnName = treeCol;
        this.levelColumnName = levelCol;
        this.removeRequestDataListener();
    }

    public void removeRequestDataListener() throws Exception {
        DataSetWrapperFactory dataSetFactory = this.getTreeTable().getDataRequestManager().getDataSetFactory();
        EventListener[] lisnter = dataSetFactory.getRequestRowSetListeners();
        for (int i = 0; i < lisnter.length; ++i) {
            dataSetFactory.removeRequestRowSetListener((RequestRowSetListener)lisnter[i]);
        }
    }

    public void initVirtualCompanyListener(KDTable table, String treeCol) {
        table.getColumn(treeCol).setRenderer((IBasicRender)new CellTreeRenderer());
        this.getTreeTable().addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                int row = e.getRowIndex();
                int column = e.getColIndex();
                if (e.getClickCount() == 1) {
                    TreeTableUtil.this.cellClicked(row, column, e.getX(), e.getY());
                } else {
                    if (e.getClickCount() != 2) {
                        return;
                    }
                    TreeTableUtil.this.tblDoubleClicked(row, column, e.getX(), e.getY());
                }
            }
        });
    }

    public void tblDoubleClicked(int row, int column, int x, int y) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cellClicked(int row, int column, int x, int y) {
        if (this.getTreeTable().getRowCount() <= 0 || row <= -1 || column != this.getTreeTable().getColumnIndex(this.getTreeColumn())) {
            return;
        }
        SimpleUserObject simpleUserObject = (SimpleUserObject)this.getTreeTable().getRow(row).getCell(column).getValue();
        if (simpleUserObject == null) {
            return;
        }
        try {
            this.uiObject.setCursorOfWair();
            this.doExpand(simpleUserObject, row, this.getTreeTable(), this.getTreeColumn());
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        finally {
            this.uiObject.setCursorOfDefault();
        }
    }

    public void doExpand(SimpleUserObject simpleUserObject, int rowIndex, KDTable table, String treeCol) throws Exception {
        int insertRowIndex = 0;
        int insertRowCount = 0;
        int rowCount = table.getRowCount();
        if (simpleUserObject.isLeaf() || simpleUserObject.isIconEmpty()) {
            return;
        }
        table.setRefresh(false);
        if (simpleUserObject.isExpanded()) {
            for (int i = rowIndex + 1; i < rowCount; ++i) {
                IRow row2 = table.getRow(i);
                SimpleUserObject company2 = (SimpleUserObject)row2.getCell(treeCol).getValue();
                if (company2 == null) continue;
                if (company2.getLevel() == simpleUserObject.getLevel()) break;
                if (company2.getLevel() <= simpleUserObject.getLevel()) continue;
                row2.getStyleAttributes().setHided(true);
            }
            simpleUserObject.setExpanded(false);
            this.removeExpanded(simpleUserObject.getId());
        } else if (simpleUserObject.isHasExpanded()) {
            this.expandRow(rowIndex, table, treeCol);
            this.addExpanded(simpleUserObject.getId());
        } else {
            IRowSet rowSet = this.adaptor.getObjectRowSet(simpleUserObject);
            insertRowIndex = 1;
            insertRowIndex += rowIndex;
            if (rowSet.size() > 0) {
                this.insertRows(simpleUserObject, rowSet, insertRowIndex, table, true, 0, simpleUserObject.getLevel() + 1);
            } else {
                simpleUserObject.setLeaf(true);
            }
            insertRowCount += rowSet.size();
            simpleUserObject.setExpanded(true);
            simpleUserObject.setHasExpanded(true);
            this.addExpanded(simpleUserObject.getId());
        }
        table.setRefresh(true);
        table.reLayoutAndPaint();
    }

    public int expandRow(int rowIndex, KDTable table, String treeCol) {
        IRow row = table.getRow(rowIndex);
        int rowCount = table.getRowCount();
        SimpleUserObject simpleUserObject = (SimpleUserObject)row.getCell(treeCol).getValue();
        simpleUserObject.setExpanded(true);
        while (++rowIndex < rowCount) {
            IRow row2 = table.getRow(rowIndex);
            SimpleUserObject simpleUserObject2 = (SimpleUserObject)row2.getCell(treeCol).getValue();
            if (simpleUserObject2 == null) continue;
            IRow row3 = table.getRow(rowIndex - 1);
            if (simpleUserObject2.isIconEmpty()) {
                row2.getStyleAttributes().setHided(row3.getStyleAttributes().isHided());
            }
            if (simpleUserObject2.getLevel() > simpleUserObject.getLevel()) {
                if (simpleUserObject2.getLevel() == simpleUserObject.getLevel() + 1) {
                    row2.getStyleAttributes().setHided(false);
                    simpleUserObject2.setExpanded(simpleUserObject2.isExpanded());
                    continue;
                }
                boolean isAllExpand = true;
                for (SimpleUserObject parent = simpleUserObject2.getParent(); parent != null; parent = parent.getParent()) {
                    if (parent.isExpanded()) continue;
                    isAllExpand = false;
                }
                if (!isAllExpand) continue;
                row2.getStyleAttributes().setHided(simpleUserObject2.isHide());
                simpleUserObject2.setExpanded(simpleUserObject2.isExpanded());
                continue;
            }
            --rowIndex;
            break;
        }
        return rowIndex;
    }

    private void drawHorizentol(Graphics g, int x1, int y, int x2) {
        g.setColor(Color.gray);
        g.drawLine(x1, y, x2, y);
        g.setColor(Color.BLACK);
    }

    private void drawVertical(Graphics g, int y1, int x, int y2) {
        g.setColor(Color.gray);
        g.drawLine(x, y1, x, y2);
        g.setColor(Color.BLACK);
    }

    public Set insertRows(SimpleUserObject parent, IRowSet rowSet, int insertRowIndex, KDTable table, boolean refreshUI, int insertRowCount, int level) throws SQLException {
        HashSet<String> pks = new HashSet<String>();
        table.setRefresh(false);
        int rowIndex = insertRowIndex + insertRowCount;
        String preTreeColumn = null;
        String curTreeColumn = null;
        SimpleUserObject simpleUserObject = new SimpleUserObject();
        SimpleUserObject preObject = null;
        String projectId = "";
        while (rowSet.next()) {
            if (!this.adaptor.isOnlyFirstLevel()) {
                if (parent == null) {
                    curTreeColumn = rowSet.getString(this.getLevelColumn());
                    if (preTreeColumn != null && curTreeColumn.startsWith(preTreeColumn) && projectId.equals(rowSet.getString(this.adaptor.getLevelGroupColumn()))) continue;
                }
                projectId = rowSet.getString(this.adaptor.getLevelGroupColumn());
            }
            simpleUserObject = new SimpleUserObject();
            this.insertRow(simpleUserObject, rowSet, rowIndex, parent);
            pks.add(simpleUserObject.getId());
            if (preObject != null) {
                preObject.setPostObject(simpleUserObject);
            }
            simpleUserObject.setPreObject(preObject);
            preObject = simpleUserObject;
            ++rowIndex;
            preTreeColumn = rowSet.getString(this.getLevelColumn());
        }
        simpleUserObject.setLastOne(true);
        if (refreshUI) {
            table.setRefresh(true);
        }
        if (rowSet.size() > 0) {
            table.reLayoutAndPaint();
            if (parent != null) {
                parent.setHasChild(true);
            }
        } else {
            table.repaint();
        }
        return pks;
    }

    private void insertRow(SimpleUserObject simpleUserObject, IRowSet rowSet, int rowIndex, SimpleUserObject parent) throws SQLException {
        KDTColumns columns = this.getTreeTable().getColumns();
        IRow row = this.table.addRow(rowIndex++);
        Color c = new Color(252, 251, 223);
        String fieldName = null;
        for (int i = 0; i < columns.size(); ++i) {
            fieldName = columns.getColumn(i).getFieldName();
            if (fieldName == null || rowSet.getObject(fieldName) == null) continue;
            row.getCell(fieldName).setValue(rowSet.getObject(fieldName));
        }
        simpleUserObject.setParent(parent);
        simpleUserObject.setLastOne(rowSet.isLast());
        simpleUserObject.setFirst(rowSet.isFirst());
        if (parent == null) {
            simpleUserObject.setHide(false);
            simpleUserObject.setLevel(1);
        } else {
            simpleUserObject.setLevel(parent.getLevel() + 1);
            if (simpleUserObject.getParent().equals(parent)) {
                simpleUserObject.setHide(false);
            } else {
                simpleUserObject.setHide(true);
            }
        }
        simpleUserObject.setId(rowSet.getString(this.adaptor.getSQLPkColumn()));
        simpleUserObject.setName(rowSet.getString(this.getTreeColumn()));
        simpleUserObject.setExpanded(false);
        if (simpleUserObject.getId() != null) {
            simpleUserObject.setLeaf(this.adaptor.isLeaf(rowSet));
            ICell cell = row.getCell(this.getTreeColumn());
            cell.setValue((Object)simpleUserObject);
            cell.setUserObject((Object)simpleUserObject);
        }
        this.adaptor.setRowColumnValue(row, c);
    }

    public void fillFirstDate() {
        IRowSet rowSet = null;
        try {
            rowSet = this.adaptor.getObjectRowSet(null);
            Set pks = this.insertRows(null, rowSet, 0, this.getTreeTable(), true, 0, 1);
            this.adaptor.initFirstPks(pks);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public KDTable getTreeTable() {
        return this.table;
    }

    public String getTreeColumn() {
        return this.treeColumnName;
    }

    public String getLevelColumn() {
        return this.levelColumnName;
    }

    public void registAdaptor(ITreeTableAdaptor ada) {
        this.adaptor = ada;
    }

    public void init() throws Exception {
        this.initVirtualCompanyListener(this.table, this.treeColumnName);
    }

    private void addExpanded(String id) {
        this.expandedNode.add(id);
    }

    private void removeExpanded(String id) {
        this.expandedNode.remove(id);
    }

    public Set getExpanded() {
        return this.expandedNode;
    }

    public class TreeIcon
    implements Icon {
        private int iconSize;
        private int margin;

        public TreeIcon() {
            this(9);
        }

        public TreeIcon(int iconSize) {
            this.iconSize = iconSize;
            this.margin = 2;
        }

        public int getWidth() {
            return this.iconSize;
        }

        public int getHeight() {
            return this.iconSize;
        }

        public void paint(Object value, Graphics g, int x, int y) {
            if (!(value instanceof Integer)) {
                return;
            }
            int type = (Integer)value;
            if (type == 3) {
                return;
            }
            if (type == 0) {
                this.drawLeaf(g, x, y);
            } else if (type == 1) {
                this.drawCollapsed(g, x, y);
            } else {
                this.drawExpanded(g, x, y);
            }
        }

        protected void drawLeaf(Graphics g, int x, int y) {
            int lineSize = this.iconSize - 2 * this.margin;
            g.drawLine(x + this.margin, y + this.iconSize / 2, x + this.margin + lineSize, y + this.iconSize / 2);
        }

        protected void drawExpanded(Graphics g, int x, int y) {
            g.drawRect(x, y, this.iconSize, this.iconSize);
            int lineSize = this.iconSize - 2 * this.margin;
            g.drawLine(x + this.margin, y + this.iconSize / 2, x + this.margin + lineSize, y + this.iconSize / 2);
        }

        protected void drawCollapsed(Graphics g, int x, int y) {
            g.drawRect(x, y, this.iconSize, this.iconSize);
            int lineSize = this.iconSize - 2 * this.margin;
            g.drawLine(x + this.margin, y + this.iconSize / 2, x + this.margin + lineSize, y + this.iconSize / 2);
            g.drawLine(x + 1 + this.iconSize / 2, y + this.margin, x + 1 + this.iconSize / 2, y + this.margin + lineSize);
        }
    }

    public class CellTreeRenderer
    implements IBasicRender {
        protected SimpleTextRender simpleRender = new SimpleTextRender();
        protected Icon cbIcon;
        private Map mapOfTreeNodeLocation = new Hashtable();

        public CellTreeRenderer() {
            this.cbIcon = new TreeIcon();
        }

        public boolean inRect(SimpleUserObject simpleUserObject, int x, int y) {
            String companyId = simpleUserObject.getId();
            Rectangle rec = (Rectangle)this.mapOfTreeNodeLocation.get(companyId);
            if (rec != null) {
                return rec.getX() < (double)x && rec.getX() + rec.getWidth() > (double)x;
            }
            return false;
        }

        public void draw(Graphics g, Shape clip, Object value, Style style) {
            SimpleUserObject simpleUserObject = null;
            if (!(value instanceof SimpleUserObject)) {
                simpleUserObject = new SimpleUserObject();
                simpleUserObject.setName((String)value);
                simpleUserObject.setId("");
                simpleUserObject.setisIconEmpty(true);
            } else {
                simpleUserObject = (SimpleUserObject)value;
            }
            int ident = 0;
            if (simpleUserObject.getLevel() != 1) {
                ident = (simpleUserObject.getLevel() - 1) * TreeTableUtil.this.treeNodeIconIndentCell;
            }
            Rectangle rect = clip.getBounds();
            int x = rect.x + ident;
            int y = rect.y + (rect.height - this.cbIcon.getHeight()) / 2;
            int v = simpleUserObject.isLeaf() ? 0 : (simpleUserObject.isExpanded() ? 2 : 1);
            if (simpleUserObject.isIconEmpty()) {
                v = 3;
            }
            Color color = style.getFontColor();
            g.setColor(color);
            Rectangle locRec = new Rectangle(x, y, this.cbIcon.getWidth(), this.cbIcon.getWidth());
            String companyId = simpleUserObject.getId();
            this.mapOfTreeNodeLocation.put(companyId, locRec);
            int xx = x + this.cbIcon.getWidth() + TreeTableUtil.this.treeNodeIndentCell;
            Rectangle newRec = new Rectangle(xx, rect.y, clip.getBounds().width - this.cbIcon.getWidth() - TreeTableUtil.this.treeNodeIndentCell, (int)clip.getBounds().getHeight());
            this.simpleRender.draw(g, (Shape)newRec, simpleUserObject.toString(), style);
            if (!simpleUserObject.isLeaf() && simpleUserObject.isExpanded() && simpleUserObject.isHasChild()) {
                TreeTableUtil.this.drawVertical(g, (int)((double)newRec.y + newRec.getHeight() / 2.0 + 8.0), (int)((double)(x + TreeTableUtil.this.treeNodeIconIndentCell) + (double)this.cbIcon.getWidth() / 2.0 + 1.0), newRec.y + newRec.height);
            }
            SimpleUserObject parent = simpleUserObject.getParent();
            for (int i = 0; i < simpleUserObject.getLevel(); ++i) {
                if (parent != null && !parent.isLastOne()) {
                    TreeTableUtil.this.drawVertical(g, newRec.y, (int)((double)x + (double)this.cbIcon.getWidth() / 2.0) + 1 - TreeTableUtil.this.treeNodeIconIndentCell * (i + 1), newRec.y + newRec.height);
                    parent = parent.getParent();
                    continue;
                }
                if (parent == null) continue;
                parent = parent.getParent();
            }
            TreeTableUtil.this.drawHorizentol(g, x + this.cbIcon.getWidth(), (int)((double)newRec.y + newRec.getHeight() / 2.0), newRec.x - 4);
            if (simpleUserObject.isLastOne() && (!simpleUserObject.isFirst() || simpleUserObject.getLevel() != 1)) {
                TreeTableUtil.this.drawVertical(g, newRec.y, (int)((double)x + (double)this.cbIcon.getWidth() / 2.0) + 1, y);
            }
            if (!simpleUserObject.isLastOne()) {
                if (!simpleUserObject.isFirst() || simpleUserObject.getLevel() != 1) {
                    TreeTableUtil.this.drawVertical(g, newRec.y, (int)((double)x + (double)this.cbIcon.getWidth() / 2.0) + 1, y);
                }
                TreeTableUtil.this.drawVertical(g, y + this.cbIcon.getHeight(), (int)((double)x + (double)this.cbIcon.getWidth() / 2.0) + 1, newRec.y + newRec.height);
            }
            if (simpleUserObject.isLeaf()) {
                if (!simpleUserObject.isFirst() || simpleUserObject.isFirst() && simpleUserObject.getLevel() != 1) {
                    TreeTableUtil.this.drawVertical(g, newRec.y, (int)((double)x + (double)this.cbIcon.getWidth() / 2.0) + 1, (int)((double)newRec.y + newRec.getHeight() / 2.0));
                }
                if (!simpleUserObject.isLastOne()) {
                    TreeTableUtil.this.drawVertical(g, (int)((double)newRec.y + newRec.getHeight() / 2.0), (int)((double)x + (double)this.cbIcon.getWidth() / 2.0) + 1, newRec.y + newRec.height);
                }
                TreeTableUtil.this.drawHorizentol(g, (int)((double)x + (double)this.cbIcon.getWidth() / 2.0 + 1.0), (int)((double)newRec.y + newRec.getHeight() / 2.0), newRec.x - 4);
                this.cbIcon.paint((Object)new Integer(3), g, x, y);
            } else {
                this.cbIcon.paint((Object)new Integer(v), g, x, y);
            }
        }
    }
}

