/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.sfc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.mm.basedata.IFactoryCalendar;
import com.kingdee.eas.mm.basedata.OprTimeUnitEnum;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsInfo;
import com.kingdee.eas.mm.sfc.PACDispatchException;
import com.kingdee.eas.mm.sfc.app.IPACSchedule;
import com.kingdee.eas.mm.sfc.util.pac.PACUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractPACSchedule
implements IPACSchedule {
    Map classTermMap = null;
    Map QueuingTimeMap = null;
    Map WorkTimeMap = null;
    Map startTimeMap = null;
    Map endTimeMap = null;
    Map scheduleMap = null;
    IFactoryCalendar calendarFactory = null;
    String orgId = null;
    public static final BigDecimal ZERO = new BigDecimal("0.0000");
    public static final Timestamp CLOCK0 = new Timestamp(-28800000L);
    public static final Timestamp CLOCK24 = new Timestamp(57600000L);
    boolean isFirstKeyOperation = false;

    @Override
    public abstract Map schedule(Map var1) throws BOSException, SQLException, EASBizException;

    protected Map forwardSchedule(Map paramsMap) throws BOSException, EASBizException {
        List technicsInfoList = (List)paramsMap.get("technicsList");
        String getDispatchTimeType = (String)paramsMap.get("GetDispatchTimeType");
        ManufactureOrderTechnicsInfo info = null;
        String operationId = null;
        String classTermId = null;
        Timestamp startTime = null;
        Timestamp endTime = null;
        Timestamp startTimeOfTechnics = null;
        Timestamp endTimeOfTechnics = null;
        BigDecimal dosumHours = ZERO;
        BigDecimal queuingHours = ZERO;
        BigDecimal dayWorkHours = ZERO;
        BigDecimal rightSideHours = ZERO;
        BigDecimal lastDayHours = ZERO;
        BigDecimal leadDay = ZERO;
        int leadTime = 0;
        int n = technicsInfoList.size();
        for (int i = 0; i < n; ++i) {
            info = (ManufactureOrderTechnicsInfo)technicsInfoList.get(i);
            operationId = info.getId().toString();
            classTermId = (String)this.classTermMap.get(info.getWorkcenter().getId().toString());
            queuingHours = (BigDecimal)this.QueuingTimeMap.get(operationId);
            if (startTimeOfTechnics == null) {
                if ("10".equals(getDispatchTimeType)) {
                    startTimeOfTechnics = info.getEarlistWoktime();
                    if (this.isFirstKeyOperation) {
                        startTimeOfTechnics = info.getEarlistCmpTime();
                        continue;
                    }
                } else if ("20".equals(getDispatchTimeType)) {
                    startTimeOfTechnics = info.getLastWorktime();
                    if (this.isFirstKeyOperation) {
                        startTimeOfTechnics = info.getLastCmpTime();
                        continue;
                    }
                }
            }
            startTime = PACUtil.setDafultTime(startTimeOfTechnics);
            dosumHours = (BigDecimal)this.WorkTimeMap.get(operationId);
            if (dosumHours.compareTo(rightSideHours = this.calculateRightSideTime(startTime, queuingHours, classTermId, startTimeOfTechnics)) <= 0) {
                endTime = this.getEndTime(startTime, dosumHours, classTermId);
            } else {
                dayWorkHours = this.calculateDayWorkTime(classTermId);
                leadDay = dosumHours.subtract(rightSideHours).divide(dayWorkHours, 0, 1);
                lastDayHours = new BigDecimal(dosumHours.subtract(rightSideHours).floatValue() % dayWorkHours.floatValue()).setScale(2, 4);
                leadTime = lastDayHours.compareTo(ZERO) == 0 ? leadDay.intValue() : 1 + leadDay.intValue();
                endTime = this.getEndTime(CLOCK0, lastDayHours, classTermId);
            }
            endTimeOfTechnics = PACUtil.setWorkTime(this.calendarFactory, startTimeOfTechnics, endTime, leadTime, this.orgId);
            if (this.scheduleMap == null) {
                this.scheduleMap = new HashMap();
            }
            this.scheduleMap.put(info.getId().toString(), new Timestamp[]{new Timestamp(startTimeOfTechnics.getTime()), new Timestamp(endTimeOfTechnics.getTime())});
            startTimeOfTechnics = endTimeOfTechnics;
            leadTime = 0;
        }
        return null;
    }

    protected Map backwardSchedule(Map paramsMap) throws EASBizException, BOSException {
        List technicsInfoList = (List)paramsMap.get("technicsList");
        String getDispatchTimeType = (String)paramsMap.get("GetDispatchTimeType");
        ManufactureOrderTechnicsInfo info = null;
        String operationId = null;
        String classTermId = null;
        Timestamp startTime = null;
        Timestamp endTime = null;
        Timestamp startTimeOfTechnics = null;
        Timestamp endTimeOfTechnics = null;
        BigDecimal dosumHours = ZERO;
        BigDecimal queuingHours = ZERO;
        BigDecimal dayWorkHours = ZERO;
        BigDecimal leftSideHours = ZERO;
        BigDecimal lastDayHours = ZERO;
        BigDecimal leadDay = ZERO;
        int leadTime = 0;
        for (int i = technicsInfoList.size() - 1; i >= 0; --i) {
            info = (ManufactureOrderTechnicsInfo)technicsInfoList.get(i);
            operationId = info.getId().toString();
            classTermId = (String)this.classTermMap.get(info.getWorkcenter().getId().toString());
            queuingHours = (BigDecimal)this.QueuingTimeMap.get(operationId);
            if (endTimeOfTechnics == null) {
                if ("10".equals(getDispatchTimeType)) {
                    endTimeOfTechnics = info.getEarlistCmpTime();
                    if (this.isFirstKeyOperation) {
                        endTimeOfTechnics = info.getEarlistWoktime();
                        continue;
                    }
                } else {
                    endTimeOfTechnics = info.getLastCmpTime();
                    if (this.isFirstKeyOperation) {
                        endTimeOfTechnics = info.getLastWorktime();
                        continue;
                    }
                }
            }
            endTime = PACUtil.setDafultTime(endTimeOfTechnics);
            dosumHours = (BigDecimal)this.WorkTimeMap.get(operationId);
            if (dosumHours.compareTo(leftSideHours = this.calculateLeftSideTime(endTime, queuingHours, classTermId, endTimeOfTechnics)) <= 0) {
                startTime = this.getStartTime(endTime, dosumHours, classTermId);
                leadTime = 0;
            } else {
                dayWorkHours = this.calculateDayWorkTime(classTermId);
                leadDay = dosumHours.subtract(leftSideHours).divide(dayWorkHours, 0, 1);
                lastDayHours = new BigDecimal(dosumHours.subtract(leftSideHours).doubleValue() % dayWorkHours.doubleValue());
                leadTime = lastDayHours.compareTo(ZERO) == 0 ? -leadDay.intValue() : -1 - leadDay.intValue();
                startTime = this.getStartTime(CLOCK24, lastDayHours, classTermId);
            }
            startTimeOfTechnics = PACUtil.setWorkTime(this.calendarFactory, endTimeOfTechnics, startTime, leadTime, this.orgId);
            if (this.scheduleMap == null) {
                this.scheduleMap = new HashMap();
            }
            this.scheduleMap.put(info.getId().toString(), new Timestamp[]{new Timestamp(startTimeOfTechnics.getTime()), new Timestamp(endTimeOfTechnics.getTime())});
            endTimeOfTechnics = PACUtil.addTime(startTimeOfTechnics, -queuingHours.doubleValue());
            leadTime = 0;
        }
        return null;
    }

    private BigDecimal calculateDayWorkTime(String classTermId) {
        List startTimeList = (List)this.startTimeMap.get(classTermId);
        List endTimeList = (List)this.endTimeMap.get(classTermId);
        return this.calculateDayWorkTime(startTimeList, endTimeList);
    }

    private BigDecimal calculateDayWorkTime(List startTimeList, List endTimeList) {
        BigDecimal count = ZERO;
        if (startTimeList == null || endTimeList == null) {
            return count;
        }
        int n = startTimeList.size();
        for (int i = 0; i < n; ++i) {
            count = count.add(PACUtil.DateMinus((Timestamp)startTimeList.get(i), (Timestamp)endTimeList.get(i)));
        }
        return count;
    }

    private BigDecimal calculateRightSideTime(Timestamp timePoint, BigDecimal queuingHours, String classTermId, Timestamp startTimeOfTechnics) throws EASBizException, BOSException {
        List startTimeList = (List)this.startTimeMap.get(classTermId);
        List endTimeList = (List)this.endTimeMap.get(classTermId);
        if (PACUtil.dateCompare(timePoint, (Timestamp)endTimeList.get(endTimeList.size() - 1)) > 0) {
            timePoint.setTime(((Timestamp)startTimeList.get(0)).getTime());
            startTimeOfTechnics.setTime(PACUtil.setWorkTime(this.calendarFactory, startTimeOfTechnics, timePoint, 1, this.orgId).getTime());
            return this.calculateDayWorkTime(classTermId);
        }
        BigDecimal result = this.calculateRightSideTime(timePoint, queuingHours, startTimeList, endTimeList);
        startTimeOfTechnics.setTime(PACUtil.setWorkTime(this.calendarFactory, startTimeOfTechnics, timePoint, 0, this.orgId).getTime());
        return result;
    }

    private BigDecimal calculateRightSideTime(Timestamp timePoint, BigDecimal queuingHours, List startTimeList, List endTimeList) {
        BigDecimal count = ZERO;
        BigDecimal queuingHoursTemp = queuingHours;
        boolean isGetIndex = false;
        Timestamp temp = null;
        int n = startTimeList.size();
        for (int i = 0; i < n; ++i) {
            Timestamp startTemp = null;
            Timestamp endTemp = null;
            if (isGetIndex) {
                count = count.add(PACUtil.DateMinus((Timestamp)startTimeList.get(i), (Timestamp)endTimeList.get(i)));
                continue;
            }
            endTemp = (Timestamp)endTimeList.get(i);
            if (PACUtil.dateCompare(timePoint, endTemp) > 0) continue;
            startTemp = (Timestamp)startTimeList.get(i);
            temp = PACUtil.dateCompare(timePoint, startTemp) > 0 ? PACUtil.setDafultTime(PACUtil.addTime(timePoint, queuingHoursTemp.doubleValue())) : PACUtil.setDafultTime(PACUtil.addTime(startTemp, queuingHoursTemp.doubleValue()));
            if (PACUtil.dateCompare(temp, endTemp) > 0) {
                queuingHoursTemp = queuingHoursTemp.subtract(PACUtil.DateMinus(timePoint, endTemp));
                timePoint.setTime(endTemp.getTime());
                continue;
            }
            timePoint.setTime(temp.getTime());
            count = count.add(PACUtil.DateMinus(timePoint, endTemp));
            isGetIndex = true;
        }
        return count;
    }

    private BigDecimal calculateLeftSideTime(Timestamp timePoint, BigDecimal queuingHours, String classTermId, Timestamp endTimeOfTechnics) throws EASBizException, BOSException {
        List startTimeList = (List)this.startTimeMap.get(classTermId);
        List endTimeList = (List)this.endTimeMap.get(classTermId);
        BigDecimal result = ZERO;
        if (PACUtil.dateCompare(timePoint, (Timestamp)startTimeList.get(0)) < 0) {
            timePoint.setTime(((Timestamp)endTimeList.get(endTimeList.size() - 1)).getTime());
            endTimeOfTechnics.setTime(PACUtil.setWorkTime(this.calendarFactory, endTimeOfTechnics, timePoint, -1, this.orgId).getTime());
            return this.calculateDayWorkTime(classTermId);
        }
        result = this.calculateLeftSideTime(timePoint, queuingHours, startTimeList, endTimeList);
        endTimeOfTechnics.setTime(PACUtil.setWorkTime(this.calendarFactory, endTimeOfTechnics, timePoint, 0, this.orgId).getTime());
        return result;
    }

    private BigDecimal calculateLeftSideTime(Timestamp timePoint, BigDecimal queuingHours, List startTimeList, List endTimeList) {
        BigDecimal count = ZERO;
        boolean isGetIndex = false;
        for (int i = startTimeList.size() - 1; i >= 0; --i) {
            Timestamp startTemp = null;
            Timestamp endTemp = null;
            if (isGetIndex) {
                count = count.add(PACUtil.DateMinus((Timestamp)startTimeList.get(i), (Timestamp)endTimeList.get(i)));
                continue;
            }
            startTemp = (Timestamp)startTimeList.get(i);
            if (PACUtil.dateCompare(timePoint, startTemp) < 0) continue;
            endTemp = (Timestamp)endTimeList.get(i);
            if (PACUtil.dateCompare(timePoint, endTemp) <= 0) {
                count = count.add(PACUtil.DateMinus(startTemp, timePoint));
            } else {
                timePoint.setTime(endTemp.getTime());
                count = count.add(PACUtil.DateMinus(startTemp, endTemp));
            }
            isGetIndex = true;
        }
        return count;
    }

    private Timestamp getEndTime(Timestamp startTime, BigDecimal wrokHours, String classTermId) {
        List startTimeList = (List)this.startTimeMap.get(classTermId);
        List endTimeList = (List)this.endTimeMap.get(classTermId);
        return this.getEndTime(startTime, wrokHours, startTimeList, endTimeList);
    }

    private Timestamp getEndTime(Timestamp startTime, BigDecimal wrokHours, List startTimeList, List endTimeList) {
        BigDecimal count = ZERO;
        Timestamp endTime = null;
        int n = startTimeList.size();
        for (int i = 0; i < n; ++i) {
            if (PACUtil.dateCompare(startTime, (Timestamp)endTimeList.get(i)) > 0) continue;
            if (PACUtil.dateCompare(startTime, (Timestamp)startTimeList.get(i)) <= 0) {
                if (wrokHours.compareTo(count = count.add(PACUtil.DateMinus((Timestamp)startTimeList.get(i), (Timestamp)endTimeList.get(i)))) > 0) {
                    startTime = (Timestamp)endTimeList.get(i);
                    continue;
                }
                endTime = PACUtil.addTime((Timestamp)endTimeList.get(i), -count.subtract(wrokHours).doubleValue());
                break;
            }
            if (wrokHours.compareTo(count = count.add(PACUtil.DateMinus(startTime, (Timestamp)endTimeList.get(i)))) > 0) {
                startTime = (Timestamp)endTimeList.get(i);
                continue;
            }
            endTime = PACUtil.addTime((Timestamp)endTimeList.get(i), -count.subtract(wrokHours).doubleValue());
            break;
        }
        return endTime;
    }

    private Timestamp getStartTime(Timestamp endTime, BigDecimal wrokHours, String classTermId) {
        List startTimeList = (List)this.startTimeMap.get(classTermId);
        List endTimeList = (List)this.endTimeMap.get(classTermId);
        return this.getStartTime(endTime, wrokHours, startTimeList, endTimeList);
    }

    private Timestamp getStartTime(Timestamp endTime, BigDecimal wrokHours, List startTimeList, List endTimeList) {
        BigDecimal count = ZERO;
        Timestamp startTime = null;
        for (int i = startTimeList.size() - 1; i >= 0; --i) {
            if (PACUtil.dateCompare(endTime, (Timestamp)startTimeList.get(i)) < 0) continue;
            if (PACUtil.dateCompare(endTime, (Timestamp)endTimeList.get(i)) >= 0) {
                if (wrokHours.compareTo(count = count.add(PACUtil.DateMinus((Timestamp)startTimeList.get(i), (Timestamp)endTimeList.get(i)))) > 0) {
                    endTime = (Timestamp)startTimeList.get(i);
                    continue;
                }
                startTime = PACUtil.addTime((Timestamp)startTimeList.get(i), count.subtract(wrokHours).doubleValue());
                break;
            }
            if (wrokHours.compareTo(count = count.add(PACUtil.DateMinus((Timestamp)startTimeList.get(i), endTime))) > 0) {
                endTime = (Timestamp)startTimeList.get(i);
                continue;
            }
            startTime = PACUtil.addTime((Timestamp)startTimeList.get(i), count.subtract(wrokHours).doubleValue());
            break;
        }
        return startTime;
    }

    protected void getOperationTime(Context ctx, List technicsInfoList) {
        ManufactureOrderTechnicsInfo info2 = null;
        BigDecimal processBatchNum = ZERO;
        BigDecimal workTime = ZERO;
        BigDecimal qty = null;
        String operationId = null;
        for (ManufactureOrderTechnicsInfo info2 : technicsInfoList) {
            processBatchNum = info2.getProcessBatch();
            operationId = info2.getId().toString();
            qty = info2.getQty();
            OprTimeUnitEnum unit = info2.getTimeUnit();
            if (this.QueuingTimeMap == null) {
                this.QueuingTimeMap = new HashMap();
            }
            if (!this.QueuingTimeMap.containsKey(operationId)) {
                this.QueuingTimeMap.put(operationId, ZERO);
            }
            workTime = processBatchNum != null && processBatchNum.compareTo(ZERO) > 0 ? info2.getWorkTime().multiply(qty.divide(processBatchNum, 0, 0)) : info2.getWorkTime();
            if (this.WorkTimeMap == null) {
                this.WorkTimeMap = new HashMap();
            }
            if (this.WorkTimeMap.containsKey(operationId)) continue;
            this.WorkTimeMap.put(operationId, this.transferTime(unit, info2.getPrepareTime().add(workTime).add(info2.getMovingTime()).add(info2.getWaitingTime()).add(info2.getQueuingTime())));
        }
    }

    protected BigDecimal transferTime(OprTimeUnitEnum unit, BigDecimal time) {
        if (unit != null && unit.getValue() == 3) {
            return time.divide(new BigDecimal(60), 2, 4);
        }
        if (unit != null && unit.getValue() == 4) {
            return time.divide(new BigDecimal(3600), 2, 4);
        }
        return time;
    }

    protected boolean hasProjectCalendar(Context ctx, String storageOrgID) throws BOSException, EASBizException {
        String sql = "select FID from T_MM_FactoryCalendar where FStorageOrgUnitID = '" + storageOrgID + "'";
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (set.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    protected IObjectCollection getTechnicsInfoList(Context ctx, FilterInfo filterInfo) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("parent.id"));
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("operationNo"));
        view.getSelector().add(new SelectorItemInfo("earlistWoktime"));
        view.getSelector().add(new SelectorItemInfo("earlistCmpTime"));
        view.getSelector().add(new SelectorItemInfo("lastWorktime"));
        view.getSelector().add(new SelectorItemInfo("lastCmpTime"));
        view.getSelector().add(new SelectorItemInfo("queuingTime"));
        view.getSelector().add(new SelectorItemInfo("prepareTime"));
        view.getSelector().add(new SelectorItemInfo("workTime"));
        view.getSelector().add(new SelectorItemInfo("waitingTime"));
        view.getSelector().add(new SelectorItemInfo("movingTime"));
        view.getSelector().add(new SelectorItemInfo("processBatch"));
        view.getSelector().add(new SelectorItemInfo("qty"));
        view.getSelector().add(new SelectorItemInfo("workcenter.id"));
        view.getSelector().add(new SelectorItemInfo("operation.id"));
        view.getSelector().add(new SelectorItemInfo("isKeyOP"));
        view.getSelector().add(new SelectorItemInfo("timeUnit"));
        view.getSorter().add(new SorterItemInfo("parent.id"));
        view.getSorter().add(new SorterItemInfo("operationNo"));
        view.setFilter(filterInfo);
        CoreBaseCollection col = ManufactureOrderTechnicsFactory.getLocalInstance((Context)ctx).getCollection(view);
        return col;
    }

    protected void filterTechnics(Map technicsMap, Map maxOperationMap) {
        if (maxOperationMap == null || technicsMap == null) {
            return;
        }
        Set maxOperationSet = maxOperationMap.entrySet();
        block0: for (Map.Entry entry : maxOperationSet) {
            if (!technicsMap.containsKey(entry.getKey())) continue;
            Iterator iter2 = ((List)technicsMap.get(entry.getKey())).iterator();
            while (iter2.hasNext()) {
                int operationNo = ((BigDecimal)entry.getValue()).intValue();
                if (operationNo != ((ManufactureOrderTechnicsInfo)iter2.next()).getOperationNo()) {
                    iter2.remove();
                    continue;
                }
                iter2.remove();
                continue block0;
            }
        }
    }

    private boolean getClassTerm(Context ctx, Set workCenterIds) throws BOSException, PACDispatchException {
        StringBuffer sqlSB = new StringBuffer("");
        sqlSB.setLength(0);
        sqlSB.append(" select t1.fid,t1.FClassTeamID from T_MM_WorkCenter t1 ").append(" where t1.fid in ( ").append(SQLUtil.arrayToString((Object[])workCenterIds.toArray())).append(")");
        ArrayList paramLst = new ArrayList();
        paramLst.clear();
        IRowSet rs = null;
        rs = DbUtil.executeQuery((Context)ctx, (String)sqlSB.toString(), (Object[])paramLst.toArray());
        try {
            while (rs.next()) {
                if (rs.getString("FClassTeamID") == null || rs.getString("FClassTeamID").length() == 0) {
                    throw new PACDispatchException(PACDispatchException.NOTFOUNDTEAMTERM);
                }
                if (this.classTermMap == null) {
                    this.classTermMap = new HashMap();
                }
                if (this.classTermMap.containsKey(rs.getString("fid"))) continue;
                this.classTermMap.put(rs.getString("fid"), rs.getString("FClassTeamID"));
            }
        }
        catch (SQLException sqlExp) {
            throw new SQLDataException(sqlExp);
        }
        sqlSB = null;
        return true;
    }

    private boolean getClassTermTime(Context ctx, Set classTermIds) throws BOSException {
        StringBuffer sqlSB = new StringBuffer("");
        sqlSB.setLength(0);
        sqlSB.append(" select t1.fid,t2.fstartTime,t2.fstartRestTime,t2.fendTime,t2.fendRestTime").append("  from T_MM_ClassTeam t1 inner join T_MM_ClassTeamEntry t2 on t1.fid=t2.FParentID ").append(" where t1.fid in ( ").append(SQLUtil.arrayToString((Object[])classTermIds.toArray())).append(")").append(" and FStorageOrgUnitID=?").append(" order by t2.fstarttime ");
        ArrayList<String> paramLst = new ArrayList<String>();
        paramLst.clear();
        IRowSet rs = null;
        paramLst.clear();
        paramLst.add(this.orgId);
        rs = DbUtil.executeQuery((Context)ctx, (String)sqlSB.toString(), (Object[])paramLst.toArray());
        try {
            String classTermId = null;
            ArrayList startTimeList = null;
            ArrayList endTimeList = null;
            Object diffHoursList = null;
            Timestamp startTime = null;
            Timestamp startRestTime = null;
            Timestamp endTime = null;
            Timestamp endRestTime = null;
            if (this.startTimeMap == null) {
                this.startTimeMap = new HashMap();
            }
            if (this.endTimeMap == null) {
                this.endTimeMap = new HashMap();
            }
            while (rs.next()) {
                classTermId = rs.getString("fid");
                if (this.startTimeMap.containsKey(classTermId)) {
                    startTimeList = (ArrayList)this.startTimeMap.get(classTermId);
                } else {
                    startTimeList = new ArrayList();
                    this.startTimeMap.put(classTermId, startTimeList);
                }
                if (this.endTimeMap.containsKey(classTermId)) {
                    endTimeList = (ArrayList)this.endTimeMap.get(classTermId);
                } else {
                    endTimeList = new ArrayList();
                    this.endTimeMap.put(classTermId, endTimeList);
                }
                startTime = rs.getTimestamp("fstartTime");
                startRestTime = rs.getTimestamp("fstartRestTime");
                endTime = rs.getTimestamp("fendTime");
                endRestTime = rs.getTimestamp("fendRestTime");
                if (startRestTime != null) {
                    if (PACUtil.dateCompare(startTime, startRestTime) == 0) {
                        this.transTimeAboutPassDay(startTimeList, endTimeList, endRestTime, endTime);
                        continue;
                    }
                    if (PACUtil.dateCompare(endRestTime, endTime) == 0) {
                        this.transTimeAboutPassDay(startTimeList, endTimeList, startTime, startRestTime);
                        continue;
                    }
                    this.transTimeAboutPassDay(startTimeList, endTimeList, startTime, startRestTime);
                    this.transTimeAboutPassDay(startTimeList, endTimeList, endRestTime, endTime);
                    continue;
                }
                this.transTimeAboutPassDay(startTimeList, endTimeList, startTime, endTime);
            }
        }
        catch (SQLException sqlExp) {
            throw new SQLDataException(sqlExp);
        }
        return true;
    }

    private void transTimeAboutPassDay(List startTimeList, List endTimeList, Timestamp startTime, Timestamp endTime) {
        if (PACUtil.dateCompare(endTime, startTime) <= 0) {
            Timestamp startTemp = CLOCK0;
            Timestamp endTemp = CLOCK24;
            this.addTimeToList(startTimeList, startTime);
            this.addTimeToList(endTimeList, endTemp);
            this.addTimeToList(startTimeList, startTemp);
            this.addTimeToList(endTimeList, endTime);
        } else {
            this.addTimeToList(startTimeList, startTime);
            this.addTimeToList(endTimeList, endTime);
        }
    }

    private void addTimeToList(List timeList, Timestamp time) {
        if (!timeList.contains(time)) {
            timeList.add(time);
        }
    }

    protected boolean getClassTermSort(Context ctx, List technicsInfoList) throws BOSException, EASBizException {
        boolean result = true;
        HashSet<String> classTermIds = new HashSet<String>();
        ManufactureOrderTechnicsInfo info2 = null;
        HashSet<String> workCenterIds = new HashSet<String>();
        for (ManufactureOrderTechnicsInfo info2 : technicsInfoList) {
            if (info2.getWorkcenter() == null || info2.getWorkcenter().getId() == null) {
                return false;
            }
            workCenterIds.add(info2.getWorkcenter().getId().toString());
        }
        this.getClassTerm(ctx, workCenterIds);
        for (ManufactureOrderTechnicsInfo info2 : technicsInfoList) {
            if (!this.classTermMap.containsKey(info2.getWorkcenter().getId().toString())) {
                return false;
            }
            classTermIds.add((String)this.classTermMap.get(info2.getWorkcenter().getId().toString()));
        }
        this.getClassTermTime(ctx, classTermIds);
        this.sortClassTerm();
        return result;
    }

    private void sortClassTerm() {
        Iterator iter = this.startTimeMap.keySet().iterator();
        HashMap startToEndTiemMap = null;
        String classTermId = null;
        List startTimeList = null;
        ArrayList endTimeList = null;
        while (iter.hasNext()) {
            int i;
            startToEndTiemMap = new HashMap();
            classTermId = (String)iter.next();
            startTimeList = (ArrayList)this.startTimeMap.get(classTermId);
            endTimeList = (ArrayList)this.endTimeMap.get(classTermId);
            int n = startTimeList.size();
            for (i = 0; i < n; ++i) {
                startToEndTiemMap.put(startTimeList.get(i), endTimeList.get(i));
            }
            startTimeList = PACUtil.dateSort(startTimeList);
            this.startTimeMap.put(classTermId, startTimeList);
            endTimeList.clear();
            n = startTimeList.size();
            for (i = 0; i < n; ++i) {
                endTimeList.add(startToEndTiemMap.get(startTimeList.get(i)));
            }
            this.endTimeMap.put(classTermId, endTimeList);
        }
    }

    protected Map getTechnicsMap(Context ctx, List technicsList) throws BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)this.orgId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.id", (Object)("select distinct fparentid from T_MM_MFTOrderTechnics where fid in ( " + SQLUtil.arrayToString((Object[])technicsList.toArray()) + ")"), CompareType.INNER));
        CoreBaseCollection col = (CoreBaseCollection)this.getTechnicsInfoList(ctx, filterInfo);
        HashMap technicsMap = new HashMap(col.size());
        List<ManufactureOrderTechnicsInfo> techList = null;
        String moId = null;
        for (ManufactureOrderTechnicsInfo info : col) {
            moId = info.getParent().getId().toString();
            if (technicsMap.containsKey(moId)) {
                techList = (List)technicsMap.get(moId);
                techList.add(info);
                continue;
            }
            techList = new ArrayList();
            techList.add(info);
            technicsMap.put(moId, techList);
        }
        return technicsMap;
    }

    protected Map getMoCollection(Context ctx, List technicsList) throws BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)this.orgId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.id", (Object)("select distinct fparentid from T_MM_MFTOrderTechnics where fid in ( " + SQLUtil.arrayToString((Object[])technicsList.toArray()) + ")"), CompareType.INNER));
        CoreBaseCollection col = (CoreBaseCollection)this.getTechnicsInfoList(ctx, filterInfo);
        HashMap technicsMap = new HashMap(col.size());
        List<ManufactureOrderTechnicsInfo> techList = null;
        String moId = null;
        for (ManufactureOrderTechnicsInfo info : col) {
            moId = info.getParent().getId().toString();
            if (technicsMap.containsKey(moId)) {
                techList = (List)technicsMap.get(moId);
                techList.add(info);
                continue;
            }
            techList = new ArrayList();
            techList.add(info);
            technicsMap.put(moId, techList);
        }
        return technicsMap;
    }

    protected Map getMaxOperationMap(Context ctx, List technicsList) throws BOSException, SQLException {
        HashMap<String, BigDecimal> maxOperationMap = null;
        StringBuffer sql = new StringBuffer("");
        sql.append(" select fparentid,max(foperationNo) maxvlaue from T_MM_MFTOrderTechnics mftot ");
        sql.append(" where ffinishedQty>0  ");
        sql.append(" and EXISTS(select fparentid from T_MM_MFTOrderTechnics mftot2 where mftot2.fparentid = mftot.fparentid  ");
        sql.append(" and mftot2.fid in(" + SQLUtil.arrayToString((Object[])technicsList.toArray()) + ") )  ");
        sql.append(" group by fparentid ");
        ArrayList paramLst = new ArrayList();
        paramLst.clear();
        IRowSet rs = null;
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])paramLst.toArray());
        while (rs.next()) {
            if (maxOperationMap == null) {
                maxOperationMap = new HashMap<String, BigDecimal>(1 + rs.size(), 1.0f);
            }
            maxOperationMap.put(rs.getString("fparentid"), rs.getBigDecimal("maxvlaue"));
        }
        return maxOperationMap;
    }

    protected void setCalendarFactory(IFactoryCalendar factoryCalendar) {
        this.calendarFactory = factoryCalendar;
    }

    protected void setOrgId(String orgId) {
        this.orgId = orgId;
    }
}

