/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.sfc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.AppLogFactory;
import com.kingdee.eas.base.log.IAppLog;
import com.kingdee.eas.base.log.app.LogServerUtil;
import com.kingdee.eas.base.log.app.adapter.LogControllManager;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.IBillType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.IBatchExecute;
import com.kingdee.eas.eqm.common.core.app.util.GeneSeverMetadataUtils;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.sfc.AssistantTimeReportCollection;
import com.kingdee.eas.mm.sfc.AssistantTimeReportEntryCollection;
import com.kingdee.eas.mm.sfc.AssistantTimeReportEntryInfo;
import com.kingdee.eas.mm.sfc.AssistantTimeReportFactory;
import com.kingdee.eas.mm.sfc.AssistantTimeReportInfo;
import com.kingdee.eas.mm.sfc.IAssistantTimeReport;
import com.kingdee.eas.mm.sfc.SalaryCaculateEnum;
import com.kingdee.eas.mm.sfc.app.AbstractAssistantTimeReportControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AssistantTimeReportControllerBean
extends AbstractAssistantTimeReportControllerBean
implements IBatchExecute {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.sfc.app.AssistantTimeReportControllerBean");
    private static final BigDecimal ZERO = new BigDecimal("0.00");
    public static final String ASSISTANTTIMEREPORT_BILLTYPEID = "n0SwvzJuRMzgQAB/AQB9lEY+1VI=";

    public IObjectPK save(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        return super.save(ctx, model);
    }

    public BatchActionResults batchDelete(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, BatchActionEnum.DELETE);
    }

    protected void _audit(Context ctx, IObjectPK objPK) throws BOSException, EASBizException {
        BatchExecuteParamsEntry entry = new BatchExecuteParamsEntry(new Class[]{IObjectPK.class});
        entry.add((Object)objPK);
        BatchExecuteParamsEntry[] entrys = new BatchExecuteParamsEntry[]{entry};
        this.batchAudit(ctx, entrys);
    }

    public BatchActionResults batchAudit(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, BatchActionEnum.AUDIT);
    }

    protected void _unAudit(Context ctx, IObjectPK objPK) throws BOSException, EASBizException {
        BatchExecuteParamsEntry entry = new BatchExecuteParamsEntry(new Class[]{IObjectPK.class});
        entry.add((Object)objPK);
        BatchExecuteParamsEntry[] entrys = new BatchExecuteParamsEntry[]{entry};
        this.batchUnAudit(ctx, entrys);
    }

    public BatchActionResults batchUnAudit(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        BatchActionResults results = this.batchExecute(ctx, entries, BatchActionEnum.UNAUDIT);
        return results;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK objectPK = super._submit(ctx, model);
        AssistantTimeReportInfo info = (AssistantTimeReportInfo)model;
        IBillType iBillType = BillTypeFactory.getLocalInstance((Context)ctx);
        BillTypeInfo billTypeInfo = iBillType.getBillTypeInfo((IObjectPK)new ObjectUuidPK(this.getBillTypeId()));
        info.setBillType(billTypeInfo);
        if (this.isAuditAfterSubmit(ctx, info, info.getStorageOrgUnit().getId().toString(), 4)) {
            this.auditAndLog(ctx, objectPK, info.getBOSType(), info.getNumber(), "mm_atreport_audit");
        }
        return objectPK;
    }

    protected void auditAndLog(Context ctx, IObjectPK pk, BOSObjectType bosType, String billNum, String logItemName) throws BOSException, EASBizException {
        LogControllManager.getInstance().enableLog();
        ServiceStateManager.getInstance().enableNextCallService("LOG_SERVICE");
        this.audit(ctx, pk);
    }

    public void batchCheck(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException, EASBizException {
        if (batchAction.equals((Object)BatchActionEnum.SUBMIT)) {
            this.submitBatchCheck(ctx, batchResults);
        } else if (batchAction.equals((Object)BatchActionEnum.UNAUDIT)) {
            this.unAuditBatchCheck(ctx, batchResults);
        }
    }

    private void unAuditBatchCheck(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        String[] ids = batchResults.getToDoIdsArray();
        HashSet<String> idSet = new HashSet<String>();
        int count = ids.length;
        for (int i = 0; i < count; ++i) {
            idSet.add(ids[i]);
        }
        EntityViewInfo entity = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        entity.setFilter(filterInfo);
        IAssistantTimeReport iar = AssistantTimeReportFactory.getLocalInstance(ctx);
        AssistantTimeReportCollection col = iar.getAssistantTimeReportCollection(entity);
        if (null != col && 0 < col.size()) {
            String msg = "";
            int count2 = col.size();
            block1: for (int i = 0; i < count2; ++i) {
                AssistantTimeReportInfo atrInfo = (AssistantTimeReportInfo)col.getObject(i);
                IBillType iBillType = BillTypeFactory.getLocalInstance((Context)ctx);
                BillTypeInfo billTypeInfo = iBillType.getBillTypeInfo((IObjectPK)new ObjectUuidPK(this.getBillTypeId()));
                atrInfo.setBillType(billTypeInfo);
                String orgUnitID = atrInfo.getStorageOrgUnit().getId().toString();
                String atrId = atrInfo.getId().toString();
                if (!batchResults.isToDo(atrId)) continue;
                if (!this.isUnAudit(ctx, atrInfo, orgUnitID, 4)) {
                    msg = ResourceBase.getString((String)"com.kingdee.eas.mm.sfc.SfcResource", (String)"ISUNAUDIT_PARAM", (Locale)ctx.getLocale());
                    batchResults.addError(atrId, msg);
                }
                if (atrInfo.getEntry() == null || atrInfo.getEntry().size() <= 0) continue;
                for (int j = 0; j < atrInfo.getEntry().size(); ++j) {
                    AssistantTimeReportEntryInfo atrEntryInfo = atrInfo.getEntry().get(j);
                    if (SalaryCaculateEnum.YET_CACULATE != atrEntryInfo.getSalaryCaculateFlag()) continue;
                    msg = AssistantTimeReportControllerBean.getString(ctx, "Caculated");
                    batchResults.addError(atrId, msg);
                    continue block1;
                }
            }
        }
    }

    private void submitBatchCheck(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectCollection col = batchResults.getObjCollection();
        String msg = null;
        StringBuffer msgEntries = new StringBuffer();
        String errorInfoPerson = "";
        String errorInfoAtt = "";
        String errorInfoDate = "";
        for (int i = 0; i < col.size(); ++i) {
            AssistantTimeReportEntryCollection entryCol;
            AssistantTimeReportInfo atrInfo = (AssistantTimeReportInfo)col.getObject(i);
            String id = null;
            id = atrInfo.getId() == null ? "NEWID" : atrInfo.getId().toString();
            if (!batchResults.isToDo(id)) continue;
            if (atrInfo.getStorageOrgUnit() == null) {
                msg = AssistantTimeReportControllerBean.getString(ctx, "StorageNUll");
                batchResults.addError(id, msg);
            }
            if (atrInfo.getDepartment() == null) {
                msg = AssistantTimeReportControllerBean.getString(ctx, "DepartmentNotNull");
                batchResults.addError(id, msg);
            }
            if ((entryCol = atrInfo.getEntry()) == null || entryCol.size() < 1) {
                msg = AssistantTimeReportControllerBean.getString(ctx, "EntryNotNull");
                batchResults.addError(id, msg);
            } else {
                for (int j = 1; j <= entryCol.size(); ++j) {
                    AssistantTimeReportEntryInfo entryInfo = entryCol.get(j - 1);
                    if (entryInfo.getPerson() == null && entryInfo.getClassGroup() == null) {
                        errorInfoPerson = errorInfoPerson + MessageFormat.format(AssistantTimeReportControllerBean.getString(ctx, "PersonNotNull"), "" + j) + "\n";
                    }
                    if (entryInfo.getAssistantTimeType() == null) {
                        errorInfoAtt = errorInfoAtt + MessageFormat.format(AssistantTimeReportControllerBean.getString(ctx, "TimeTypeNotNull"), "" + j) + "\n";
                    }
                    if (entryInfo.getDate() == null) {
                        errorInfoDate = errorInfoAtt + MessageFormat.format(AssistantTimeReportControllerBean.getString(ctx, "DateNotNull"), "" + j) + "\n";
                    }
                    if (entryInfo.getLaborCost() != null) continue;
                    errorInfoDate = errorInfoAtt + MessageFormat.format(AssistantTimeReportControllerBean.getString(ctx, "LaborCostNotNull"), "" + j) + "\n";
                }
                if (!errorInfoPerson.equals("")) {
                    msgEntries.append(errorInfoPerson);
                }
                if (!errorInfoAtt.equals("")) {
                    msgEntries.append(errorInfoAtt);
                }
                if (!errorInfoDate.equals("")) {
                    msgEntries.append(errorInfoDate);
                }
            }
            if (msgEntries.length() <= 0) continue;
            batchResults.addError(id, msgEntries.toString());
        }
    }

    public void batchExecute(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException, EASBizException {
        if (batchResults.getToDoIdsArray().length > 0) {
            if (batchAction.equals((Object)BatchActionEnum.AUDIT)) {
                this.afterAudit(ctx, batchResults);
            } else if (batchAction.equals((Object)BatchActionEnum.UNAUDIT)) {
                this.afterUnAudit(ctx, batchResults);
            } else if (batchAction.equals((Object)BatchActionEnum.DELETE)) {
                String[] ids = batchResults.getToDoIdsArray();
                for (int i = 0; i < ids.length; ++i) {
                    this._delete(ctx, (IObjectPK)new ObjectUuidPK(ids[i]));
                }
            }
        }
    }

    private void afterAudit(Context ctx, BatchActionResults batchResults) throws BOSException {
        List list = batchResults.getToDoIdsList();
        Object[] ids = new String[list.size()];
        int count = ids.length;
        for (int i = 0; i < count; ++i) {
            ids[i] = list.get(i).toString();
        }
        String sql = "UPDATE T_MM_ASSISTANTTIMEREPORTENTRY SET FSalaryCaculateFlag = 6 WHERE FParentID IN (" + SQLUtil.arrayToString((Object[])ids) + ")";
        SQLUtil.batchExecuteSql((Context)ctx, (String[])new String[]{sql});
    }

    private void afterUnAudit(Context ctx, BatchActionResults batchResults) throws BOSException {
        List list = batchResults.getToDoIdsList();
        Object[] ids = new String[list.size()];
        int count = ids.length;
        for (int i = 0; i < count; ++i) {
            ids[i] = list.get(i).toString();
        }
        String sql = "UPDATE T_MM_ASSISTANTTIMEREPORTENTRY SET FSalaryCaculateFlag = 4 WHERE FParentID IN (" + SQLUtil.arrayToString((Object[])ids) + ")";
        SQLUtil.batchExecuteSql((Context)ctx, (String[])new String[]{sql});
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = null;
        AssistantTimeReportInfo info = (AssistantTimeReportInfo)model;
        try {
            pk = super._addnew(ctx, model);
            this.writeLog(ctx, info, "addnew", new Boolean(true));
        }
        catch (BOSException e1) {
            this.writeLog(ctx, info, "addnew", new Boolean(false));
            throw e1;
        }
        catch (EASBizException e2) {
            this.writeLog(ctx, info, "addnew", new Boolean(false));
            throw e2;
        }
        return pk;
    }

    private void writeLog(Context ctx, AssistantTimeReportInfo atrInfo, String operation, Boolean isSuccessed) throws BOSException {
        if (this.getLogItem(operation) == null || "".equals(this.getLogItem(operation))) {
            return;
        }
        IAppLog appLog = AppLogFactory.getLocalInstance((Context)ctx);
        EntityObjectInfo entityObjectInfo = GeneSeverMetadataUtils.getBOSEntity((Context)ctx, (BOSObjectType)this.getBOSType());
        HashMap<String, Object> hashLog = new HashMap<String, Object>();
        LogServerUtil.setLogInfo(null, (Context)ctx, hashLog);
        hashLog.put("isSuccessed", new Boolean(false));
        hashLog.put("successed", isSuccessed);
        hashLog.put("FEntityID", this.getBOSType().toString());
        hashLog.put("FEntityName", entityObjectInfo.getName());
        hashLog.put("FEntityAlias_L1", entityObjectInfo.getAlias(ctx.getLocale()));
        hashLog.put("FEntityAlias_L2", entityObjectInfo.getAlias(ctx.getLocale()));
        hashLog.put("FEntityAlias_L3", entityObjectInfo.getAlias(ctx.getLocale()));
        hashLog.put("FMethodName", "close");
        hashLog.put("FCompanyName_L1", atrInfo.getStorageOrgUnit().getName(ctx.getLocale()));
        hashLog.put("FCompanyName_L2", atrInfo.getStorageOrgUnit().getName(ctx.getLocale()));
        hashLog.put("FCompanyName_L3", atrInfo.getStorageOrgUnit().getName(ctx.getLocale()));
        hashLog.put("FInstanceID", atrInfo.getId().toString());
        hashLog.put("FInstanceNo", atrInfo.getLogInfo());
        hashLog.put("FItemName", this.getLogItem(operation));
        hashLog.put("LOG_HIDDEN_WRITE_MODE", "LOG_HIDDEN_WRITE_MODE");
        appLog.writeLog(hashLog);
    }

    private Object getLogItem(String operation) {
        String logItem = "";
        if (operation.equals("addnew")) {
            logItem = "mm_atreport_addnew";
        }
        if (operation.equals("delete")) {
            logItem = "mm_atreport_delete";
        }
        return logItem;
    }

    protected String getXmlFileName(BatchActionEnum batchActionEnum) {
        return "com.kingdee.eas.mm.sfc.app.assistantTimeReportConfig.xml";
    }

    protected String getBillTypeId() {
        return ASSISTANTTIMEREPORT_BILLTYPEID;
    }

    public static String getString(Context ctx, String resourceName) {
        String path = "com.kingdee.eas.mm.sfc.AssistantTimeReportResource";
        String strTemp = ResourceBase.getString((String)path, (String)resourceName, (Locale)ctx.getLocale());
        if (strTemp.equals("Missing Resource")) {
            return "Missing Resource{" + resourceName + "}";
        }
        return strTemp;
    }

    @Override
    protected void _costAlter(Context ctx, Map caInfoMap) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement ps = null;
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.setLength(0);
        sqlBuf.append("update T_MM_AssistantTimeReportEntry ").append("set FLaborCost = ?, FWorkTime = ? ").append(" where Fid = ?");
        if (caInfoMap != null && caInfoMap.size() > 0) {
            Set entryIds = caInfoMap.keySet();
            Iterator bomIt = entryIds.iterator();
            String pk = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                ps = conn.prepareStatement(sqlBuf.toString());
                while (bomIt.hasNext()) {
                    pk = (String)bomIt.next();
                    AssistantTimeReportEntryInfo atrEntryInfo = (AssistantTimeReportEntryInfo)caInfoMap.get(pk);
                    BigDecimal laborCost = atrEntryInfo.getLaborCost();
                    BigDecimal workTime = atrEntryInfo.getWorkTime();
                    if (laborCost == null || laborCost.compareTo(ZERO) == 0) {
                        laborCost = ZERO;
                    }
                    if (workTime == null || workTime.compareTo(ZERO) == 0) {
                        workTime = ZERO;
                    }
                    ps.setBigDecimal(1, laborCost);
                    ps.setBigDecimal(2, workTime);
                    ps.setString(3, pk);
                    ps.addBatch();
                }
                ps.executeBatch();
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                SQLUtils.cleanup((Connection)conn);
            }
        }
    }
}

