/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.sfc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.mo.IManufactureOrderExpectOutput;
import com.kingdee.eas.mm.mo.IManufactureOrderTechnics;
import com.kingdee.eas.mm.mo.ManufactureOrderExpectOutputCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderExpectOutputFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderExpectOutputInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsInfo;
import com.kingdee.eas.mm.sfc.BatchCompletionInfo;
import com.kingdee.eas.mm.sfc.CompletionReportAmountTimeInfo;
import com.kingdee.eas.mm.sfc.CompletionReportByproductInfo;
import com.kingdee.eas.mm.sfc.CompletionReportFactory;
import com.kingdee.eas.mm.sfc.CompletionReportInfo;
import com.kingdee.eas.mm.sfc.DisTaskDispatchEntryFactory;
import com.kingdee.eas.mm.sfc.DisTaskDispatchEntryInfo;
import com.kingdee.eas.mm.sfc.IDisTaskDispatchEntry;
import com.kingdee.eas.mm.sfc.ReportTypeEnum;
import com.kingdee.eas.mm.sfc.RowStatusEnum;
import com.kingdee.eas.mm.sfc.SfcException;
import com.kingdee.eas.mm.sfc.SourceBillTypeEnum;
import com.kingdee.eas.mm.sfc.TechnicslayerEnum;
import com.kingdee.eas.mm.sfc.app.AbstractBatchCompletionFacadeControllerBean;
import com.kingdee.eas.mm.sfc.util.SFCUntil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.ISCMBillParam;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillParamFactory;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BatchCompletionFacadeControllerBean
extends AbstractBatchCompletionFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.sfc.app.BatchCompletionFacadeControllerBean");
    private static Map precisionMap = new HashMap();
    private static int MAX_COUNT = 100;
    private static int MAX_SELECT_COUNT = 2001;

    @Override
    protected List _getManuFactureOrder(Context ctx, Map paramMap) throws BOSException, EASBizException {
        ArrayList<Object> result = new ArrayList<Object>();
        ArrayList<BatchCompletionInfo> resultList = new ArrayList<BatchCompletionInfo>();
        String orderStorageOrgUnitID = (String)paramMap.get("storageOrgUnitID");
        String ordernumberFrom = (String)paramMap.get("ordernumberFrom");
        String ordernumberTo = (String)paramMap.get("ordernumberTo");
        Date orderstartdateFrom = (Date)paramMap.get("orderstartdateFrom");
        Date orderenddateTo = (Date)paramMap.get("orderstartdateTo");
        HashSet materialIDSet = (HashSet)paramMap.get("materialSet");
        HashSet moprojectSet = (HashSet)paramMap.get("moprojectSet");
        HashSet motrackNumSet = (HashSet)paramMap.get("motrackNumSet");
        HashSet moAdminDepartmentSet = (HashSet)paramMap.get("moAdminDepartmentSet");
        HashSet workCenterSet = (HashSet)paramMap.get("moWorkCenter");
        String moLotNum = (String)paramMap.get("moLot");
        FilterInfo filterInfo = new FilterInfo();
        if (materialIDSet != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("parent.material.id", (Object)materialIDSet, CompareType.INCLUDE));
        }
        if (moprojectSet != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("parent.project.id", (Object)moprojectSet, CompareType.INCLUDE));
        }
        if (motrackNumSet != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("parent.trackNumber.id", (Object)motrackNumSet, CompareType.INCLUDE));
        }
        if (moAdminDepartmentSet != null && moAdminDepartmentSet.size() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("adminOrgUnit.id", (Object)moAdminDepartmentSet, CompareType.INCLUDE));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)orderStorageOrgUnitID, CompareType.EQUALS));
        if (ordernumberFrom != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("parent.number", (Object)ordernumberFrom, CompareType.GREATER_EQUALS));
        }
        if (ordernumberTo != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("parent.number", (Object)ordernumberTo, CompareType.LESS_EQUALS));
        }
        if (orderstartdateFrom != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("parent.planBeginDate", (Object)orderstartdateFrom, CompareType.GREATER_EQUALS));
        }
        if (orderenddateTo != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("parent.planBeginDate", (Object)orderenddateTo, CompareType.LESS_EQUALS));
        }
        if (workCenterSet != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("workCenter.id", (Object)workCenterSet, CompareType.INCLUDE));
        }
        if (moLotNum != null && moLotNum.trim().length() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("parent.lot", (Object)("%" + moLotNum + "%"), CompareType.LIKE));
        }
        HashSet<Integer> set = new HashSet<Integer>();
        set.add(new Integer(5));
        set.add(new Integer(8));
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.baseStatus", set, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("totalDispatchQty", (Object)new BigDecimal(0), CompareType.LESS_EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("isReportPoint", (Object)new Boolean(true), CompareType.EQUALS));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("totalSplitQty"));
        sic.add(new SelectorItemInfo("totalSplitBaseQty"));
        sic.add(new SelectorItemInfo("baseQty"));
        sic.add(new SelectorItemInfo("qty"));
        sic.add(new SelectorItemInfo("repairQty"));
        sic.add(new SelectorItemInfo("repairBaseQty"));
        sic.add(new SelectorItemInfo("finishedQty"));
        sic.add(new SelectorItemInfo("finishedBaseQty"));
        sic.add(new SelectorItemInfo("totalManufactureScrapQty"));
        sic.add(new SelectorItemInfo("totalManufactureScrapBaseQty"));
        sic.add(new SelectorItemInfo("totalMaterialScrapQty"));
        sic.add(new SelectorItemInfo("totalMaterialScrapBaseQty"));
        sic.add(new SelectorItemInfo("passQty"));
        sic.add(new SelectorItemInfo("concessionQty"));
        sic.add(new SelectorItemInfo("prepareTime"));
        sic.add(new SelectorItemInfo("workTime"));
        sic.add(new SelectorItemInfo("processBatch"));
        sic.add(new SelectorItemInfo("isCheckPoint"));
        sic.add(new SelectorItemInfo("timeUnit"));
        sic.add(new SelectorItemInfo("operationNo"));
        sic.add(new SelectorItemInfo("scrapQty"));
        sic.add(new SelectorItemInfo("scrapBaseQty"));
        sic.add(new SelectorItemInfo("earlistWoktime"));
        sic.add(new SelectorItemInfo("earlistCmpTime"));
        sic.add(new SelectorItemInfo("actualScrapLaborCost"));
        sic.add(new SelectorItemInfo("actualMatScrapLaborCost"));
        sic.add(new SelectorItemInfo("actualLaborCost"));
        sic.add(new SelectorItemInfo("theoreticalScrapLaborCost"));
        sic.add(new SelectorItemInfo("theoreticalMatScrapLaborCost"));
        sic.add(new SelectorItemInfo("theoreticalLaborCost"));
        sic.add(new SelectorItemInfo("valuationType"));
        sic.add(new SelectorItemInfo("parent.lastOperNo"));
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("parent.name"));
        sic.add(new SelectorItemInfo("parent.number"));
        sic.add(new SelectorItemInfo("parent.planBeginDate"));
        sic.add(new SelectorItemInfo("parent.planEndDate"));
        sic.add(new SelectorItemInfo("parent.lot"));
        sic.add(new SelectorItemInfo("parent.qty"));
        sic.add(new SelectorItemInfo("parent.baseStatus"));
        sic.add(new SelectorItemInfo("parent.transactionType.id"));
        sic.add(new SelectorItemInfo("parent.transactionType.name"));
        sic.add(new SelectorItemInfo("parent.transactionType.number"));
        sic.add(new SelectorItemInfo("parent.transactionType.finishedQty"));
        sic.add(new SelectorItemInfo("parent.unit.id"));
        sic.add(new SelectorItemInfo("parent.unit.name"));
        sic.add(new SelectorItemInfo("parent.unit.number"));
        sic.add(new SelectorItemInfo("operation.id"));
        sic.add(new SelectorItemInfo("operation.name"));
        sic.add(new SelectorItemInfo("operation.number"));
        sic.add(new SelectorItemInfo("parent.material.id"));
        sic.add(new SelectorItemInfo("parent.material.number"));
        sic.add(new SelectorItemInfo("parent.material.name"));
        sic.add(new SelectorItemInfo("parent.material.model"));
        sic.add(new SelectorItemInfo("parent.material.baseUnit.id"));
        sic.add(new SelectorItemInfo("parent.material.baseUnit.name"));
        sic.add(new SelectorItemInfo("parent.material.baseUnit.number"));
        sic.add(new SelectorItemInfo("parent.defaultWarehous.id"));
        sic.add(new SelectorItemInfo("parent.defaultWarehous.name"));
        sic.add(new SelectorItemInfo("parent.defaultWarehous.number"));
        sic.add(new SelectorItemInfo("parent.material.baseUnit.id"));
        sic.add(new SelectorItemInfo("parent.material.baseUnit.name"));
        sic.add(new SelectorItemInfo("parent.material.baseUnit.number"));
        sic.add(new SelectorItemInfo("parent.storageorgunit.id"));
        sic.add(new SelectorItemInfo("parent.storageorgunit.name"));
        sic.add(new SelectorItemInfo("parent.storageorgunit.number"));
        sic.add(new SelectorItemInfo("parent.routing.id"));
        sic.add(new SelectorItemInfo("parent.routing.name"));
        sic.add(new SelectorItemInfo("parent.routing.number"));
        sic.add(new SelectorItemInfo("parent.routing.currency.id"));
        sic.add(new SelectorItemInfo("parent.routing.currency.name"));
        sic.add(new SelectorItemInfo("parent.routing.currency.number"));
        sic.add(new SelectorItemInfo("parent.project.id"));
        sic.add(new SelectorItemInfo("parent.project.name"));
        sic.add(new SelectorItemInfo("parent.project.number"));
        sic.add(new SelectorItemInfo("parent.trackNumber.id"));
        sic.add(new SelectorItemInfo("parent.trackNumber.name"));
        sic.add(new SelectorItemInfo("parent.trackNumber.number"));
        sic.add(new SelectorItemInfo("parent.adminOrgUnit.id"));
        sic.add(new SelectorItemInfo("parent.adminOrgUnit.name"));
        sic.add(new SelectorItemInfo("parent.adminOrgUnit.number"));
        sic.add(new SelectorItemInfo("storageorgunit.id"));
        sic.add(new SelectorItemInfo("storageorgunit.name"));
        sic.add(new SelectorItemInfo("storageorgunit.number"));
        sic.add(new SelectorItemInfo("entrustSupplier.id"));
        sic.add(new SelectorItemInfo("entrustSupplier.name"));
        sic.add(new SelectorItemInfo("entrustSupplier.number"));
        sic.add(new SelectorItemInfo("workcenter.id"));
        sic.add(new SelectorItemInfo("workcenter.name"));
        sic.add(new SelectorItemInfo("workcenter.number"));
        sic.add(new SelectorItemInfo("adminOrgUnit.id"));
        sic.add(new SelectorItemInfo("adminOrgUnit.name"));
        sic.add(new SelectorItemInfo("adminOrgUnit.number"));
        sic.add(new SelectorItemInfo("operationRemark"));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filterInfo);
        view.setSelector(sic);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("parent.number"));
        sorter.add(new SorterItemInfo("operation.number"));
        view.setSorter(sorter);
        view.setTopCount(MAX_SELECT_COUNT);
        IManufactureOrderTechnics manuOrder = ManufactureOrderTechnicsFactory.getLocalInstance((Context)ctx);
        CoreBaseCollection manuColl = manuOrder.getCollection(view);
        ArrayList<String> orderIDList = new ArrayList<String>();
        BatchCompletionInfo resultInfo = null;
        if (manuColl != null) {
            if (manuColl.size() == MAX_SELECT_COUNT) {
                throw new SfcException(SfcException.MAXSELECTCOUNTOVER);
            }
            for (int i = 0; i < manuColl.size(); ++i) {
                resultInfo = new BatchCompletionInfo();
                ManufactureOrderTechnicsInfo info = (ManufactureOrderTechnicsInfo)manuColl.get(i);
                ManufactureOrderExpectOutputCollection moc = this.getInitOutputCollection(info, null, ctx);
                resultInfo.setMoc(moc);
                resultInfo.setBillType(SourceBillTypeEnum.PRODUCTORDER);
                resultInfo.setManufactureOrderTechnicsinfo(info);
                resultInfo.setManufactureorder(info.getParent());
                resultInfo.setMaterialnum(info.getParent().getMaterial());
                resultInfo.setMaterialName(info.getParent().getMaterial() != null ? info.getParent().getMaterial().getName() : null);
                resultInfo.setMaterialModel(info.getParent().getMaterial() == null ? null : info.getParent().getMaterial().getModel());
                resultInfo.setBaseStatus(BillBaseStatusEnum.ADD);
                resultInfo.setOperation(info.getOperation());
                resultInfo.setOperationName(info.getOperation() != null ? info.getOperation().getName() : null);
                resultInfo.setPlanStartDate(info.getParent().getPlanBeginDate());
                resultInfo.setPlanEndDate(info.getParent().getPlanEndDate());
                resultInfo.setPlanQty(info.getParent().getQty() != null ? info.getParent().getQty() : new BigDecimal(0));
                resultInfo.setTotalSplitQty(info.getTotalSplitQty() != null ? info.getTotalSplitQty() : new BigDecimal(0));
                resultInfo.setTotalSplitBaseQty(info.getTotalSplitBaseQty() != null ? info.getTotalSplitBaseQty() : new BigDecimal(0));
                resultInfo.setBasePlanQty(info.getBaseQty());
                resultInfo.setRepairQty(info.getRepairQty());
                resultInfo.setBaseRepairQty(info.getRepairBaseQty());
                resultInfo.setTotalfinishedQty(info.getFinishedQty());
                resultInfo.setBaseTotalfinishedQty(info.getFinishedBaseQty());
                resultInfo.setTotalManufactureScrapQty(info.getTotalManufactureScrapQty());
                resultInfo.setBaseTotalManufactureScrapQty(info.getTotalManufactureScrapBaseQty());
                resultInfo.setTotalMaterialScrapQty(info.getTotalMaterialScrapQty());
                resultInfo.setBaseTotalMaterialScrapQty(info.getTotalMaterialScrapBaseQty());
                resultInfo.setUnit(info.getParent().getUnit());
                resultInfo.setTotalpassQty(info.getPassQty());
                resultInfo.setTotalgiveInQty(info.getConcessionQty());
                resultInfo.setBsUnit(info.getParent().getMaterial().getBaseUnit());
                resultInfo.setSourceID(System.currentTimeMillis() + "" + i);
                resultInfo.setPrepareTime(info.getPrepareTime() != null ? info.getPrepareTime() : new BigDecimal(0));
                resultInfo.setWorkTime(info.getWorkTime() != null ? info.getWorkTime() : new BigDecimal(0));
                resultInfo.setProcessBatch(info.getProcessBatch());
                resultInfo.setSupplier(info.getEntrustSupplier());
                resultInfo.setStorage(info.getStorageOrgUnit());
                resultInfo.setLot(info.getParent().getLot());
                resultInfo.setCheckPoint(info.isIsCheckPoint());
                resultInfo.setTimeUnit(info.getTimeUnit());
                resultInfo.setManuOpNo(info.getOperationNo());
                resultInfo.setWorkCenterinfo(info.getWorkcenter());
                resultInfo.setProject(info.getParent().getProject());
                resultInfo.setTracknum(info.getParent().getTrackNumber());
                resultInfo.setAdminOrg(info.getAdminOrgUnit());
                resultInfo.setOperationRemark(info.getOperationRemark());
                resultInfo.setProductTransactionTypeInfo(info.getParent().getTransactionType());
                resultInfo.setAdminDepartMent(info.getParent().getAdminOrgUnit());
                orderIDList.add(info.getParent().getId().toString());
                resultList.add(resultInfo);
            }
        }
        if (resultList.size() > 0) {
            ArrayList<String> materialIds = new ArrayList<String>();
            ArrayList<String> unitids = new ArrayList<String>();
            Map converMap = new HashMap();
            Map maxNoMap = SFCUntil.getMaxOperationNo(ctx, orderIDList);
            for (int i = 0; i < resultList.size(); ++i) {
                BatchCompletionInfo bs = (BatchCompletionInfo)resultList.get(i);
                Integer maxNo = new Integer(0);
                if (maxNoMap.containsKey(bs.getManufactureorder().getId().toString())) {
                    maxNo = (Integer)maxNoMap.get(bs.getManufactureorder().getId().toString());
                }
                int operationnumber = bs.getManufactureOrderTechnicsinfo().getOperationNo();
                if (maxNo == operationnumber) {
                    bs.setLastNo(true);
                }
                if (bs.getMaterialnum() == null || bs.getUnit() == null || materialIds.contains(bs.getMaterialnum().getId().toString())) continue;
                materialIds.add(bs.getMaterialnum().getId().toString());
                unitids.add(bs.getUnit().getId().toString());
            }
            String[] materialArrays = materialIds.toArray(new String[0]);
            String[] unitIdarrays = unitids.toArray(new String[0]);
            converMap = this.getPricesionByMaterial(ctx, materialArrays, unitIdarrays);
            precisionMap.putAll(converMap);
        }
        result.add(resultList);
        result.add(precisionMap);
        return result;
    }

    protected Map getPricesionByMaterial(Context ctx, String[] materialIds, String[] unitsIds) throws BOSException, EASBizException {
        int materialSize = materialIds.length;
        int unitsIdsSize = unitsIds.length;
        if (materialSize != unitsIdsSize || materialSize < 1) {
            return null;
        }
        StringBuffer conditionBuffer = new StringBuffer();
        conditionBuffer.append(" (material ='" + materialIds[0] + "' And measureUnit = '" + unitsIds[0] + "') ");
        for (int index = 1; index < materialSize; ++index) {
            conditionBuffer.append(" or ");
            conditionBuffer.append(" (material ='" + materialIds[index] + "' And measureUnit ='" + unitsIds[index] + "') ");
        }
        IMultiMeasureUnit imultiUnit = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        MultiMeasureUnitCollection collection = imultiUnit.getMultiMeasureUnitCollection("Where" + conditionBuffer.toString());
        int collSize = collection.size();
        HashMap<String, Integer> returnMap = new HashMap<String, Integer>();
        for (int index = 0; index < collSize; ++index) {
            String keyString = collection.get(index).getMaterial().getId().toString() + collection.get(index).getMeasureUnit().getId().toString();
            Integer rate = new Integer(collection.get(index).getQtyPrecision());
            returnMap.put(keyString, rate);
        }
        return returnMap;
    }

    protected ManufactureOrderExpectOutputCollection getInitOutputCollection(ManufactureOrderTechnicsInfo moti, DisTaskDispatchEntryInfo ddei, Context ctx) throws BOSException {
        if (null == moti && null == ddei) {
            return null;
        }
        ManufactureOrderExpectOutputCollection moc = null;
        int operationNo = 0;
        String orderID = null;
        if (null != moti) {
            operationNo = moti.getOperationNo();
            orderID = moti.getParent().getId().toString();
        } else {
            String technicId = ddei.getSourceBillEntryId();
            orderID = ddei.getManufactureOrder().getId().toString();
            if (null != technicId) {
                ManufactureOrderTechnicsCollection collection = ddei.getManufactureOrder().getTechnics();
                int count = collection.size();
                for (int i = 0; i < count; ++i) {
                    ManufactureOrderTechnicsInfo mot = collection.get(i);
                    if (!mot.getId().toString().equals(technicId)) continue;
                    operationNo = mot.getOperationNo();
                    break;
                }
            }
        }
        if (operationNo != 0) {
            EntityViewInfo entityView = new EntityViewInfo();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("defaultWarehous.id");
            selector.add("defaultWarehous.number");
            selector.add("defaultWarehous.name");
            selector.add("unit.id");
            selector.add("unit.number");
            selector.add("unit.name");
            selector.add("baseUnit.id");
            selector.add("baseUnit.number");
            selector.add("baseUnit.name");
            selector.add("costObect.id");
            selector.add("costObect.number");
            selector.add("costObect.name");
            selector.add("material.id");
            selector.add("material.number");
            selector.add("material.name");
            selector.add("material.model");
            selector.add("outputType");
            selector.add("costObect.id");
            selector.add("costObect.number");
            selector.add("costObect.name");
            selector.add("qty");
            selector.add("baseQty");
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("operationNo", (Object)new Integer(operationNo), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)orderID, CompareType.EQUALS));
            entityView.setSelector(selector);
            entityView.setFilter(filter);
            IManufactureOrderExpectOutput imo = ManufactureOrderExpectOutputFactory.getLocalInstance((Context)ctx);
            moc = imo.getManufactureOrderExpectOutputCollection(entityView);
        }
        return moc;
    }

    @Override
    protected List _getDisTaskDispatchOrder(Context ctx, Map paramMap) throws BOSException, EASBizException {
        ArrayList<Object> result = new ArrayList<Object>();
        ArrayList<BatchCompletionInfo> resultList = new ArrayList<BatchCompletionInfo>();
        String taskStorageOrgUnitID = (String)paramMap.get("taskStorageOrgUnitID");
        String distaskOrderFrom = (String)paramMap.get("distaskOrderFrom");
        String distaskOrderTO = (String)paramMap.get("distaskOrderTO");
        HashSet workcenterSet = (HashSet)paramMap.get("workcenterSet");
        HashSet disprojectSet = (HashSet)paramMap.get("disprojectSet");
        HashSet distrackNumSet = (HashSet)paramMap.get("distrackNumSet");
        HashSet taskAdminDepartmentSet = (HashSet)paramMap.get("taskAdminDepartmentSet");
        String taskLotNum = (String)paramMap.get("taskLot");
        Date taskstartdateFrom = (Date)paramMap.get("taskstartdateFrom");
        Date taskstartdateTo = (Date)paramMap.get("taskstartdateTo");
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.storageOrgUnit.id", (Object)taskStorageOrgUnitID, CompareType.EQUALS));
        if (workcenterSet != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("workCenter.id", (Object)workcenterSet, CompareType.INCLUDE));
        }
        if (disprojectSet != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("project.id", (Object)disprojectSet, CompareType.INCLUDE));
        }
        if (distrackNumSet != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("trackNumber.id", (Object)distrackNumSet, CompareType.INCLUDE));
        }
        if (taskAdminDepartmentSet != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("parent.adminOrgUnit.id", (Object)taskAdminDepartmentSet, CompareType.INCLUDE));
        }
        if (distaskOrderFrom != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("parent.number", (Object)distaskOrderFrom, CompareType.GREATER_EQUALS));
        }
        if (distaskOrderTO != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("parent.number", (Object)distaskOrderTO, CompareType.LESS_EQUALS));
        }
        if (taskstartdateFrom != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("parent.planBeginDate", (Object)taskstartdateFrom, CompareType.GREATER_EQUALS));
        }
        if (taskstartdateTo != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("parent.planBeginDate", (Object)taskstartdateTo, CompareType.LESS_EQUALS));
        }
        if (taskLotNum != null && taskLotNum.trim().length() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("lot", (Object)("%" + taskLotNum + "%"), CompareType.LIKE));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.baseStatus", (Object)BillBaseStatusEnum.AUDITED, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("rowStatus", (Object)RowStatusEnum.NATURAL, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("isReportPoint", (Object)new Boolean(true), CompareType.EQUALS));
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("qty"));
        sic.add(new SelectorItemInfo("baseQty"));
        sic.add(new SelectorItemInfo("repReportQty"));
        sic.add(new SelectorItemInfo("repReportBaseQty"));
        sic.add(new SelectorItemInfo("finishedQty"));
        sic.add(new SelectorItemInfo("finishedBaseQty"));
        sic.add(new SelectorItemInfo("workScrapQty"));
        sic.add(new SelectorItemInfo("workScrapBaseQty"));
        sic.add(new SelectorItemInfo("materialScrapQty"));
        sic.add(new SelectorItemInfo("materialScrapBaseQty"));
        sic.add(new SelectorItemInfo("passQty"));
        sic.add(new SelectorItemInfo("concessionQty"));
        sic.add(new SelectorItemInfo("technicsLayer"));
        sic.add(new SelectorItemInfo("sourceBillEntryId"));
        sic.add(new SelectorItemInfo("lot"));
        sic.add(new SelectorItemInfo("timeUnit"));
        sic.add(new SelectorItemInfo("isCheckPoint"));
        sic.add(new SelectorItemInfo("operationNumber"));
        sic.add(new SelectorItemInfo("earlistWoktime"));
        sic.add(new SelectorItemInfo("earlistCmpTime"));
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("parent.name"));
        sic.add(new SelectorItemInfo("parent.number"));
        sic.add(new SelectorItemInfo("parent.planBeginDate"));
        sic.add(new SelectorItemInfo("parent.planEndDate"));
        sic.add(new SelectorItemInfo("parent.storageorgunit.id"));
        sic.add(new SelectorItemInfo("parent.storageorgunit.name"));
        sic.add(new SelectorItemInfo("parent.storageorgunit.number"));
        sic.add(new SelectorItemInfo("parent.classGroup.id"));
        sic.add(new SelectorItemInfo("parent.classGroup.name"));
        sic.add(new SelectorItemInfo("parent.classGroup.number"));
        sic.add(new SelectorItemInfo("parent.equipment.id"));
        sic.add(new SelectorItemInfo("parent.equipment.name"));
        sic.add(new SelectorItemInfo("parent.equipment.number"));
        sic.add(new SelectorItemInfo("manufactureOrder.unit.id"));
        sic.add(new SelectorItemInfo("manufactureOrder.unit.name"));
        sic.add(new SelectorItemInfo("manufactureOrder.unit.number"));
        sic.add(new SelectorItemInfo("manufactureOrder.routing.id"));
        sic.add(new SelectorItemInfo("manufactureOrder.routing.name"));
        sic.add(new SelectorItemInfo("manufactureOrder.routing.number"));
        sic.add(new SelectorItemInfo("manufactureOrder.routing.currency.id"));
        sic.add(new SelectorItemInfo("manufactureOrder.routing.currency.name"));
        sic.add(new SelectorItemInfo("manufactureOrder.routing.currency.number"));
        sic.add(new SelectorItemInfo("operation.id"));
        sic.add(new SelectorItemInfo("operation.name"));
        sic.add(new SelectorItemInfo("operation.number"));
        sic.add(new SelectorItemInfo("manufactureOrder.id"));
        sic.add(new SelectorItemInfo("manufactureOrder.name"));
        sic.add(new SelectorItemInfo("manufactureOrder.number"));
        sic.add(new SelectorItemInfo("manufactureOrder.baseStatus"));
        sic.add(new SelectorItemInfo("manufactureOrder.transactionType.id"));
        sic.add(new SelectorItemInfo("manufactureOrder.transactionType.name"));
        sic.add(new SelectorItemInfo("manufactureOrder.transactionType.number"));
        sic.add(new SelectorItemInfo("manufactureOrder.transactionType.finishedQty"));
        sic.add(new SelectorItemInfo("manufactureOrder.material.id"));
        sic.add(new SelectorItemInfo("manufactureOrder.material.name"));
        sic.add(new SelectorItemInfo("manufactureOrder.material.number"));
        sic.add(new SelectorItemInfo("manufactureOrder.material.model"));
        sic.add(new SelectorItemInfo("manufactureOrder.material.baseUnit.id"));
        sic.add(new SelectorItemInfo("manufactureOrder.material.baseUnit.name"));
        sic.add(new SelectorItemInfo("manufactureOrder.material.baseUnit.number"));
        sic.add(new SelectorItemInfo("manufactureOrder.defaultWarehous.id"));
        sic.add(new SelectorItemInfo("manufactureOrder.defaultWarehous.name"));
        sic.add(new SelectorItemInfo("manufactureOrder.defaultWarehous.number"));
        sic.add(new SelectorItemInfo("manufactureOrder.technics.id"));
        sic.add(new SelectorItemInfo("manufactureOrder.technics.operationNo"));
        sic.add(new SelectorItemInfo("manufactureOrder.storageorgunit.id"));
        sic.add(new SelectorItemInfo("manufactureOrder.storageorgunit.name"));
        sic.add(new SelectorItemInfo("manufactureOrder.storageorgunit.number"));
        sic.add(new SelectorItemInfo("manufactureOrder.adminOrgUnit.id"));
        sic.add(new SelectorItemInfo("manufactureOrder.adminOrgUnit.name"));
        sic.add(new SelectorItemInfo("manufactureOrder.adminOrgUnit.number"));
        sic.add(new SelectorItemInfo("workCenter.id"));
        sic.add(new SelectorItemInfo("workCenter.name"));
        sic.add(new SelectorItemInfo("workCenter.number"));
        sic.add(new SelectorItemInfo("project.id"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("trackNumber.id"));
        sic.add(new SelectorItemInfo("trackNumber.name"));
        sic.add(new SelectorItemInfo("trackNumber.number"));
        sic.add(new SelectorItemInfo("parent.adminOrgUnit.id"));
        sic.add(new SelectorItemInfo("parent.adminOrgUnit.name"));
        sic.add(new SelectorItemInfo("parent.adminOrgUnit.number"));
        sic.add(new SelectorItemInfo("manufactureOrder.lot"));
        view.setFilter(filterInfo);
        view.setSelector(sic);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("manufactureOrder.number"));
        sorter.add(new SorterItemInfo("parent.number"));
        sorter.add(new SorterItemInfo("operation.number"));
        view.setSorter(sorter);
        view.setTopCount(MAX_SELECT_COUNT);
        IDisTaskDispatchEntry distaskEntry = DisTaskDispatchEntryFactory.getLocalInstance(ctx);
        CoreBaseCollection coll = distaskEntry.getCollection(view);
        ArrayList<String> orderIDList = new ArrayList<String>();
        if (coll != null) {
            if (coll.size() == MAX_SELECT_COUNT) {
                throw new SfcException(SfcException.MAXSELECTCOUNTOVER);
            }
            BatchCompletionInfo resultInfo = null;
            for (int i = 0; i < coll.size(); ++i) {
                resultInfo = new BatchCompletionInfo();
                DisTaskDispatchEntryInfo info = (DisTaskDispatchEntryInfo)coll.get(i);
                if (info.getManufactureOrder().getBaseStatus() == BillBaseStatusEnum.CLOSED || info.getManufactureOrder().getBaseStatus() == BillBaseStatusEnum.BLOCKED || info.getManufactureOrder().getBaseStatus() == BillBaseStatusEnum.FINCLOSED) continue;
                ManufactureOrderExpectOutputCollection moc = this.getInitOutputCollection(null, info, ctx);
                resultInfo.setMoc(moc);
                resultInfo.setBillType(SourceBillTypeEnum.DISPATCHWORKBILL);
                resultInfo.setDistaskOrderentryinfo(info);
                resultInfo.setManufactureorder(info.getManufactureOrder());
                resultInfo.setMaterialnum(info.getManufactureOrder().getMaterial());
                resultInfo.setMaterialName(info.getManufactureOrder().getMaterial() != null ? info.getManufactureOrder().getMaterial().getName() : null);
                resultInfo.setOperation(info.getOperation());
                resultInfo.setOperationName(info.getOperation() != null ? info.getOperation().getName() : null);
                resultInfo.setOpNo(info.getOperationNumber().doubleValue());
                resultInfo.setPlanStartDate(info.getParent().getPlanBeginDate());
                resultInfo.setPlanEndDate(info.getParent().getPlanEndDate());
                resultInfo.setPlanQty(info.getQty());
                resultInfo.setBasePlanQty(info.getBaseQty());
                resultInfo.setRepairQty(info.getRepReportQty());
                resultInfo.setBaseRepairQty(info.getRepReportBaseQty());
                resultInfo.setTotalfinishedQty(info.getFinishedQty() != null ? info.getFinishedQty() : new BigDecimal(0));
                resultInfo.setBaseTotalfinishedQty(info.getFinishedBaseQty());
                resultInfo.setUnit(info.getManufactureOrder().getUnit());
                resultInfo.setClassGroup(info.getParent().getClassGroup());
                resultInfo.setMaterialModel(info.getManufactureOrder() == null ? null : info.getManufactureOrder().getMaterial().getModel());
                resultInfo.setBaseStatus(BillBaseStatusEnum.ADD);
                resultInfo.setTotalManufactureScrapQty(info.getWorkScrapQty());
                resultInfo.setBaseTotalManufactureScrapQty(info.getWorkScrapBaseQty());
                resultInfo.setTotalMaterialScrapQty(info.getMaterialScrapQty());
                resultInfo.setBaseTotalMaterialScrapQty(info.getMaterialScrapBaseQty());
                resultInfo.setTotalpassQty(info.getPassQty());
                resultInfo.setTotalgiveInQty(info.getConcessionQty());
                resultInfo.setBsUnit(info.getManufactureOrder().getMaterial().getBaseUnit());
                resultInfo.setSourceID(System.currentTimeMillis() + "" + i);
                resultInfo.setStorage(info.getParent().getStorageOrgUnit());
                IManufactureOrderTechnics technis = ManufactureOrderTechnicsFactory.getLocalInstance((Context)ctx);
                if (info.getTechnicsLayer() == TechnicslayerEnum.FIRST) {
                    if (technis.exists((IObjectPK)new ObjectUuidPK(info.getSourceBillEntryId()))) {
                        ManufactureOrderTechnicsInfo technicsInfo = (ManufactureOrderTechnicsInfo)technis.getValue((IObjectPK)new ObjectUuidPK(info.getSourceBillEntryId()));
                        resultInfo.setManufactureOrderTechnicsinfo(technicsInfo);
                        resultInfo.setProcessBatch(technicsInfo.getProcessBatch());
                        resultInfo.setWorkTime(technicsInfo.getWorkTime() != null ? technicsInfo.getWorkTime() : new BigDecimal(0));
                        resultInfo.setPrepareTime(technicsInfo.getPrepareTime() != null ? technicsInfo.getPrepareTime() : new BigDecimal(0));
                        resultInfo.setLot(info.getLot());
                        resultInfo.setOperationRemark(technicsInfo.getOperationRemark());
                    }
                } else if (info.getTechnicsLayer() == TechnicslayerEnum.SECOND) {
                    resultInfo.setProcessBatch(new BigDecimal(0));
                    resultInfo.setWorkTime(new BigDecimal(0));
                    resultInfo.setPrepareTime(new BigDecimal(0));
                }
                resultInfo.setTimeUnit(info.getTimeUnit());
                resultInfo.setDistaskOrdernfo(info.getParent());
                resultInfo.setCheckPoint(info.isIsCheckPoint());
                orderIDList.add(info.getManufactureOrder().getId().toString());
                resultInfo.setWorkCenterinfo(info.getWorkCenter());
                resultInfo.setProject(info.getProject());
                resultInfo.setTracknum(info.getTrackNumber());
                resultInfo.setEquipment(info.getParent().getEquipment());
                if (info.getParent() != null) {
                    resultInfo.setAdminOrg(info.getParent().getAdminOrgUnit());
                }
                resultInfo.setProductTransactionTypeInfo(info.getManufactureOrder().getTransactionType());
                resultInfo.setAdminDepartMent(info.getManufactureOrder().getAdminOrgUnit());
                resultList.add(resultInfo);
            }
        }
        if (resultList.size() > 0) {
            ArrayList<String> materialIds = new ArrayList<String>();
            ArrayList<String> unitids = new ArrayList<String>();
            Map converMap = new HashMap();
            Map maxNoMap = SFCUntil.getMaxOperationNo(ctx, orderIDList);
            for (int i = 0; i < resultList.size(); ++i) {
                BatchCompletionInfo bs = (BatchCompletionInfo)resultList.get(i);
                Integer maxNo = new Integer(0);
                if (maxNoMap.containsKey(bs.getManufactureorder().getId().toString())) {
                    maxNo = (Integer)maxNoMap.get(bs.getManufactureorder().getId().toString());
                }
                if (bs.getDistaskOrderentryinfo().getOperationNumber() != null) {
                    int operationnumber = bs.getDistaskOrderentryinfo().getOperationNumber().toBigInteger().intValue();
                    if (maxNo == operationnumber) {
                        bs.setLastNo(true);
                    }
                }
                if (bs.getMaterialnum() == null || bs.getUnit() == null || materialIds.contains(bs.getMaterialnum().getId().toString())) continue;
                materialIds.add(bs.getMaterialnum().getId().toString());
                unitids.add(bs.getUnit().getId().toString());
            }
            String[] materialArrays = materialIds.toArray(new String[0]);
            String[] unitIdarrays = unitids.toArray(new String[0]);
            converMap = this.getPricesionByMaterial(ctx, materialArrays, unitIdarrays);
            precisionMap.putAll(converMap);
        }
        result.add(resultList);
        result.add(precisionMap);
        return result;
    }

    @Override
    protected HashSet _getClassGroupIdSet(Context ctx, String workcenterID) throws BOSException {
        HashSet<String> resultSet = new HashSet<String>();
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("select fclassgroupid  from T_MM_RESOURCEENTRY entity where entity.FPARENTID in(select fid from t_mm_resource resouce where resouce.FRESOURCETYPE=10 and resouce.fid in(select e.FRESOURCEID from T_MM_WORKCENTERENTRY e where FPARENTID ='");
        strBuf.append(workcenterID);
        strBuf.append("'))");
        strBuf.append(" and entity.FHRTYPEID=20");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strBuf.toString());
        if (rs != null && rs.size() > 0) {
            try {
                while (rs.next()) {
                    resultSet.add(rs.getString("fclassgroupid"));
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return resultSet;
    }

    @Override
    protected HashSet _getEqmIdSet(Context ctx, String workcenterID) throws BOSException {
        HashSet<String> resultSet = new HashSet<String>();
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("select fid  from T_MM_RESOURCEENTRY entity where entity.FPARENTID in(select fid from t_mm_resource resouce where resouce.FRESOURCETYPE= 10 and resouce.fid in(select e.FRESOURCEID from T_MM_WORKCENTERENTRY e where FPARENTID ='");
        strBuf.append(workcenterID);
        strBuf.append("'))");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strBuf.toString());
        if (rs != null && rs.size() > 0) {
            try {
                while (rs.next()) {
                    resultSet.add(rs.getString("fid"));
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return resultSet;
    }

    @Override
    protected HashSet _getPersonIdSet(Context ctx, String workcenterID) throws BOSException {
        HashSet<String> resultSet = new HashSet<String>();
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("select fpersonid  from T_MM_RESOURCEENTRY entity where entity.FPARENTID in(select fid from t_mm_resource resouce where resouce.FRESOURCETYPE= 30 and resouce.fid in(select e.FRESOURCEID from T_MM_WORKCENTERENTRY e where FPARENTID ='");
        strBuf.append(workcenterID);
        strBuf.append("'))");
        strBuf.append(" and entity.FHRTYPEID=10");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strBuf.toString());
        if (rs != null && rs.size() > 0) {
            try {
                while (rs.next()) {
                    resultSet.add(rs.getString("fpersonid"));
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return resultSet;
    }

    @Override
    protected Map _getIdSetByWorkcenterID(Context ctx, String workcenterID) throws BOSException {
        HashMap<String, HashSet> resultMap = new HashMap<String, HashSet>();
        resultMap.put("personSet", this._getPersonIdSet(ctx, workcenterID));
        resultMap.put("eqmSet", this._getEqmIdSet(ctx, workcenterID));
        resultMap.put("classGroupSet", this._getClassGroupIdSet(ctx, workcenterID));
        return resultMap;
    }

    @Override
    protected HashSet _getOrderIdSetByStorageID(Context ctx, String storageOrgUnit) throws BOSException, EASBizException {
        HashSet<String> resultSet = new HashSet<String>();
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("select fid from T_MM_MANUFACTUREORDER where (FBASESTATUS=5 or fbasestatus=8)  and fid in(select fparentid from T_MM_MFTORDERTECHNICS where FSTORAGEORGUNITID='");
        strBuf.append(storageOrgUnit);
        strBuf.append("')");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strBuf.toString());
        if (rs != null && rs.size() > 0) {
            try {
                while (rs.next()) {
                    resultSet.add(rs.getString("fid"));
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return resultSet;
    }

    @Override
    protected BatchExecuteResult _batchCommitReport(Context ctx, List completionList) throws BOSException, EASBizException {
        if (completionList == null || completionList.size() == 0) {
            return null;
        }
        BatchCompletionInfo reportInfo2 = (BatchCompletionInfo)completionList.get(0);
        IPermission ipermission = PermissionFactory.getLocalInstance((Context)ctx);
        ipermission.checkFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(reportInfo2.getStorage().getId()), "mm_sfc_batch_submit");
        Class[] paramTypes = new Class[]{CoreBillBaseInfo.class, BOTRelationCollection.class};
        BatchExecuteResult result = new BatchExecuteResult(completionList.size());
        BatchExecuteParamsEntry entry = null;
        ServiceStateManager.getInstance().disableNextCallService("PERMISSION_SERVICE");
        HashSet<BatchExecuteParamsEntry> set = new HashSet<BatchExecuteParamsEntry>();
        BatchActionResults actionResult = null;
        int i = 0;
        for (BatchCompletionInfo reportInfo2 : completionList) {
            CompletionReportInfo report = this.buildCompletionReport(reportInfo2);
            entry = new BatchExecuteParamsEntry(paramTypes, new Object[]{report, null});
            set.add(entry);
            if (++i != MAX_COUNT) continue;
            try {
                BatchExecuteParamsEntry[] entries = set.toArray(new BatchExecuteParamsEntry[0]);
                actionResult = this.doBatchReport(ctx, paramTypes, entries, actionResult);
                set = new HashSet();
                i = 0;
            }
            catch (BaseException e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (set.size() > 0) {
            BatchExecuteParamsEntry[] entries = set.toArray(new BatchExecuteParamsEntry[0]);
            actionResult = this.doBatchReport(ctx, paramTypes, entries, actionResult);
        }
        result.setBatchResult(actionResult);
        ServiceStateManager.getInstance().enableNextCallService("PERMISSION_SERVICE");
        return result;
    }

    private BatchActionResults doBatchReport(Context ctx, Class[] paramTypes, BatchExecuteParamsEntry[] entries, BatchActionResults _actionResult) throws BOSException {
        try {
            BatchExecuteResult result = CompletionReportFactory.getLocalInstance(ctx).batchExecute("submitRelations", paramTypes, entries);
            BatchActionResults actionResult = (BatchActionResults)result.getBatchResult();
            if (_actionResult == null) {
                _actionResult = actionResult;
            } else {
                _actionResult.mergeResults(actionResult);
            }
            return _actionResult;
        }
        catch (BaseException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private CompletionReportInfo buildCompletionReport(BatchCompletionInfo info) throws EASBizException, BOSException {
        CompletionReportInfo completion = new CompletionReportInfo();
        completion.setId(info.getId());
        completion.setDmesOrder(info.getManufactureorder());
        completion.setReportType(ReportTypeEnum.NORMAL_PRODUCTION);
        completion.setReportTime(info.getReportTime());
        if (SourceBillTypeEnum.PRODUCTORDER.equals((Object)info.getBillType())) {
            completion.setProcess(info.getManufactureOrderTechnicsinfo());
        } else {
            completion.setProcess(info.getManufactureOrderTechnicsinfo());
            completion.setDispWorkProcess(info.getDistaskOrderentryinfo());
        }
        completion.setSourceBillType1(info.getBillType());
        completion.setDispatchWork(info.getDistaskOrdernfo());
        completion.setBaseStatus(BillBaseStatusEnum.SUBMITED);
        completion.setProductNumber(info.getManufactureorder().getMaterial());
        completion.setStorageOrgUnit(info.getStorage());
        completion.setPStorageOrgUnit(info.getManufactureorder().getStorageOrgUnit());
        completion.setUnit(info.getUnit());
        completion.setBaseUnit(info.getBsUnit());
        completion.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        Calendar cal = Calendar.getInstance();
        completion.setBizDate(cal.getTime());
        completion.setCreateTime(new Timestamp(cal.getTimeInMillis()));
        completion.setWorkcenter(info.getWorkCenterinfo());
        completion.setCheckout(info.isCheckPoint());
        completion.setProject(info.getProject());
        completion.setTrackNumber(info.getTracknum());
        completion.setConsignerNumber(info.getSupplier());
        completion.setClassGroup(info.getClassGroup());
        completion.setDmesorderNumber(info.getLot());
        completion.setDepartMent(info.getAdminOrg());
        completion.setProductType(info.getProductTransactionTypeInfo());
        completion.setAdminDepartMent(info.getAdminDepartMent());
        if (SourceBillTypeEnum.DISPATCHWORKBILL.equals((Object)info.getBillType()) && TechnicslayerEnum.SECOND.equals((Object)info.getDistaskOrderentryinfo().getTechnicsLayer())) {
            completion.setBatchProcessQty(SCMConstant.BIGDECIMAL_ONE);
            completion.setActualCancelLaborCost(SCMConstant.BIGDECIMAL_ZERO);
            completion.setActualLaborCost(SCMConstant.BIGDECIMAL_ZERO);
            completion.setActualMatScarpLaborCost(SCMConstant.BIGDECIMAL_ZERO);
            completion.setTheoreticalCancelLaborCost(SCMConstant.BIGDECIMAL_ZERO);
            completion.setTheoreticalLaborCost(SCMConstant.BIGDECIMAL_ZERO);
            completion.setTheoreticalMatScarpLaborCost(SCMConstant.BIGDECIMAL_ZERO);
            completion.setBatchProcessQty(SCMConstant.BIGDECIMAL_ONE);
        } else {
            completion.setActualCancelLaborCost(info.getManufactureOrderTechnicsinfo().getActualScrapLaborCost());
            completion.setActualLaborCost(info.getManufactureOrderTechnicsinfo().getActualLaborCost());
            completion.setActualMatScarpLaborCost(info.getManufactureOrderTechnicsinfo().getActualMatScrapLaborCost());
            completion.setTheoreticalCancelLaborCost(info.getManufactureOrderTechnicsinfo().getTheoreticalScrapLaborCost());
            completion.setTheoreticalLaborCost(info.getManufactureOrderTechnicsinfo().getTheoreticalLaborCost());
            completion.setTheoreticalMatScarpLaborCost(info.getManufactureOrderTechnicsinfo().getTheoreticalMatScrapLaborCost());
            if (info.getManufactureorder().getRouting() != null && info.getManufactureorder().getRouting().getCurrency() != null) {
                completion.setCurrency(info.getManufactureorder().getRouting().getCurrency());
            }
            completion.setValuationType(info.getManufactureOrderTechnicsinfo().getValuationType());
            completion.setBatchProcessQty(info.getProcessBatch());
        }
        if (SourceBillTypeEnum.PRODUCTORDER.equals((Object)info.getBillType())) {
            completion.getAmountTime().add(this.buildEntry(info));
            this.buildRelationMaterial(completion, info);
        } else {
            completion.getAmountTime().add(this.buildEntry(info));
            this.buildRelationMaterial(completion, info);
        }
        return completion;
    }

    private CompletionReportAmountTimeInfo buildEntry(BatchCompletionInfo info) throws EASBizException, BOSException {
        CompletionReportAmountTimeInfo entry = new CompletionReportAmountTimeInfo();
        entry.setId(BOSUuid.create((BOSObjectType)entry.getBOSType()));
        entry.setPersonNumber(info.getPerson());
        entry.setEquipmentNumber(info.getEquipment());
        entry.setReportAmount(info.getReportAmount());
        entry.setQualifiedAmount(info.getQualifiedAmount());
        entry.setYieldAmount(info.getYieldAmount());
        entry.setRepairAmount(info.getRepairQty());
        entry.setWorkScrapAmount(info.getWorkScrapAmount() != null ? info.getWorkScrapAmount() : SCMConstant.BIGDECIMAL_ZERO);
        entry.setMaterialScrapAm(info.getMaterialScrapAmount() != null ? info.getMaterialScrapAmount() : SCMConstant.BIGDECIMAL_ZERO);
        entry.setScrapAmount(entry.getWorkScrapAmount().add(entry.getMaterialScrapAm()));
        entry.setWarehouse(info.getWarehouse());
        entry.setBatchSeq(info.getLot());
        entry.setActualBegain(info.getActualBegin());
        entry.setActualEnd(info.getActualEnd());
        entry.setProcessTime(info.getWorkTime());
        entry.setPrepareTime(info.getPrepareTime());
        entry.setTimeUnit(info.getTimeUnit());
        return entry;
    }

    private void buildRelationMaterial(CompletionReportInfo parent, BatchCompletionInfo info) throws EASBizException, BOSException {
        if (info.getMoc() != null && info.getMoc().size() > 0) {
            for (int i = 0; i < info.getMoc().size(); ++i) {
                ManufactureOrderExpectOutputInfo output = info.getMoc().get(i);
                CompletionReportByproductInfo byProductentry = new CompletionReportByproductInfo();
                byProductentry.setId(BOSUuid.create((BOSObjectType)byProductentry.getBOSType()));
                byProductentry.setMaterial(output.getMaterial());
                byProductentry.setUnit(output.getUnit());
                byProductentry.setBaseUnit(output.getBaseUnit());
                byProductentry.setOutPutType(output.getOutputType());
                byProductentry.setCostObject(output.getCostObect());
                byProductentry.setBatchSeq(output.getLot());
                ManufactureOrderTechnicsInfo technicsInfo = info.getManufactureOrderTechnicsinfo();
                BigDecimal qtySub = technicsInfo.getQty().subtract(technicsInfo.getTotalSplitQty());
                if (qtySub.compareTo(SCMConstant.BIGDECIMAL_ZERO) > 0) {
                    byProductentry.setReportAmount(output.getQty().divide(qtySub, 8, 4).multiply(parent.getAmountTime().get(0).getReportAmount()));
                    if (!parent.isCheckout()) {
                        byProductentry.setQualifiedAmount(byProductentry.getReportAmount());
                    }
                } else {
                    byProductentry.setReportAmount(SCMConstant.BIGDECIMAL_ZERO);
                }
                byProductentry.setWarehouse(output.getDefaultWarehous());
                parent.getByproduct().add(byProductentry);
            }
        }
    }

    protected boolean isAuditAfterSubmit(Context ctx, SCMBillBaseInfo info, String orgUnitID, int orgType) throws BOSException, EASBizException {
        boolean isAutoAudit = false;
        if (info.getBillType() != null) {
            String billTypeId = info.getBillType().getId().toString();
            ISCMBillParam scmParam = SCMBillParamFactory.getLocalInstance((Context)ctx);
            String strAutoAudit = scmParam.getParamByBillTypeID("SCM_Submit_01", orgType, orgUnitID, billTypeId);
            if (strAutoAudit != null && strAutoAudit.trim().length() != 0 && strAutoAudit.trim().toLowerCase().equals("1")) {
                isAutoAudit = true;
            }
        }
        return isAutoAudit;
    }

    @Override
    protected Map _batchCommitCompletion(Context ctx, List completionList) throws BOSException, EASBizException {
        return null;
    }
}

