/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.sfc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.agent.AgentUtility;
import com.kingdee.bos.framework.agent.IObjectValueAgent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.mo.IManufactureOrder;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderStockCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderStockInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsInfo;
import com.kingdee.eas.mm.sfc.BackFrushStatusEnum;
import com.kingdee.eas.scm.common.SCMGroupFacadeFactory;
import com.kingdee.eas.scm.common.loadmass.SCMEntryDataVO;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class CompletionReportAuditUtil {
    private CompletionReportAuditUtil() {
    }

    public static Map getCompletionReportBackFlushStatus(Context ctx, String[] ids, BillTypeInfo billType) throws BOSException, EASBizException, SQLException {
        if (ids.length == 0) {
            return new HashMap();
        }
        CoreBillBaseCollection cbc = CompletionReportAuditUtil.getOperationBackFlushOrders(ctx, ids);
        return CompletionReportAuditUtil.getCompletionReportBackFlushStatus(ctx, cbc, ids, billType);
    }

    public static Map getCompletionReportBackFlushStatus(Context ctx, CoreBillBaseCollection cbc, String[] ids, BillTypeInfo billType) throws BOSException, EASBizException, SQLException {
        HashMap<String, BackFrushStatusEnum> map = new HashMap<String, BackFrushStatusEnum>();
        if (null == ids) {
            return map;
        }
        String idStr = SQLUtil.arrayToString((Object[])ids);
        StringBuffer selectSQL = new StringBuffer();
        selectSQL.setLength(0);
        selectSQL.append(" SELECT FID,FORDERID,FNUMBER,FPRODQTY,FOPNO,FTechniceLayer ,FBackFlushQtyBase,FIsBackFlushQtyMore FROM ( ").append("select t0.FID,t0.FDmesOrderID FOrderID,t0.FNumber,t0.FReportQty FProdQty,t1.FOperationNo FOpNo,10 FTechniceLayer,t2.FBackFlushQtyBase,t2.FIsBackFlushQtyMore ").append("from T_MM_CompletionReport t0 inner join T_MM_MFTOrderTechnics t1 on t0.FProcessID = t1.FID ").append(" inner join T_MM_ManufactureOrder t3 on t0.FDmesOrderID = t3.FID ").append(" inner join T_MM_ProductTransactionType t2 on t3.FTransactionTypeID = t2.FID ").append("where t0.FID in (").append(idStr).append(") ").append("and t1.FIsReportPoint = 1 AND T0.FSOURCEBILLTYPE1 = '10' AND T0.FReportType = 10 ").append(" UNION ").append("select COMPLETIONREPORT.FID FID,COMPLETIONREPORT.FDmesOrderID FORDERID,COMPLETIONREPORT.FNUMBER FNUMBER,").append(" COMPLETIONREPORT.FREPORTQTY FPRODQTY,PROCESS.FOPERATIONNO FOPNO,DISPWORKPROCESS.FTechnicsLayer FTechniceLayer,transType.FBackFlushQtyBase,transType.FIsBackFlushQtyMore ").append(" from T_MM_CompletionReport COMPLETIONREPORT ").append("     INNER JOIN T_MM_DisTaskDispatchEntry AS DISPWORKPROCESS ON COMPLETIONREPORT.FDispWorkProcessID = DISPWORKPROCESS.FID  ").append("     INNER JOIN T_MM_MFTOrderTechnics AS PROCESS ON DISPWORKPROCESS.FSOURCEBILLENTRYID = PROCESS.FID ").append(" inner join T_MM_ManufactureOrder t3 on COMPLETIONREPORT.FDmesOrderID = t3.FID ").append(" inner join T_MM_ProductTransactionType transType on t3.FTransactionTypeID = transType.FID ").append("where COMPLETIONREPORT.FID in (").append(idStr).append(") ").append("and PROCESS.FIsReportPoint = 1 AND COMPLETIONREPORT.FSOURCEBILLTYPE1 = '20' AND COMPLETIONREPORT.FReportType = 10 ").append(") T");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSQL.toString());
        SCMEntryDataVO dataVO = CompletionReportAuditUtil.getMaterialMmu(ctx, cbc);
        ManufactureOrderInfo moInfo = null;
        String orderID = null;
        BigDecimal prodQty = null;
        BigDecimal prodQty4Rep = null;
        int backFlushQtyBase = 20;
        boolean isBackFlushQtyMore = false;
        while (rs != null && rs.next()) {
            Boolean sumAudit;
            int theOp;
            backFlushQtyBase = rs.getInt("FBackFlushQtyBase");
            if (rs.getInt("FTechniceLayer") == 20 || (moInfo = CompletionReportAuditUtil.getManufactureOrder(cbc, orderID = rs.getString("FOrderID"))) == null) continue;
            moInfo.setSourceBillId(rs.getString("FID"));
            moInfo.setSourceBillType(billType);
            moInfo.setSrcBillNum(rs.getString("FNumber"));
            prodQty = rs.getBigDecimal("FProdQty");
            isBackFlushQtyMore = rs.getBoolean("FIsBackFlushQtyMore");
            prodQty4Rep = prodQty;
            int fromOp = 0;
            int lastOp = theOp = rs.getInt("FOpNo");
            if (theOp == moInfo.getFirstOperNo()) {
                fromOp = moInfo.getFirstOperNo();
            }
            if ((sumAudit = (Boolean)ctx.get((Object)"backflush_delay")) != null && sumAudit.booleanValue()) {
                Integer opNo = (Integer)ctx.get((Object)"opNo");
                BigDecimal reportQty = (BigDecimal)ctx.get((Object)"reportQty");
                if (opNo != null && reportQty != null) {
                    prodQty = reportQty;
                    lastOp = theOp = opNo.intValue();
                } else {
                    return map;
                }
            }
            for (int j = 0; j <= moInfo.getTechnics().size() - 1; ++j) {
                ManufactureOrderTechnicsInfo techEntry = moInfo.getTechnics().get(j);
                if (!techEntry.isIsReportPoint()) continue;
                if (techEntry.getOperationNo() == theOp) {
                    lastOp = theOp;
                    break;
                }
                if (techEntry.getOperationNo() >= lastOp || techEntry.getOperationNo() <= fromOp) continue;
                fromOp = techEntry.getOperationNo();
            }
            boolean groupFlag = false;
            boolean replacePriority = false;
            ManufactureOrderStockInfo stockInfo = null;
            Object stockInfo1 = null;
            ManufactureOrderStockCollection stockCollection = moInfo.getStocks();
            int num = 0;
            Iterator stockIter = moInfo.getStocks().iterator();
            while (stockIter.hasNext()) {
                BigDecimal maxQty;
                stockInfo = (ManufactureOrderStockInfo)stockIter.next();
                if (stockInfo.getOperationNo() <= fromOp || stockInfo.getOperationNo() > lastOp) {
                    if (stockInfo.getOperationNo() == moInfo.getFirstOperNo()) {
                        if (fromOp != lastOp) {
                            stockIter.remove();
                            continue;
                        }
                    } else {
                        stockIter.remove();
                        continue;
                    }
                }
                if (stockInfo.getIssueMode().getValue() == 11040) {
                    stockIter.remove();
                    continue;
                }
                int prec = CompletionReportAuditUtil.getPrec(dataVO, stockInfo.getMaterial(), stockInfo.getUnit());
                BigDecimal backflushQty = new BigDecimal("0.0");
                BigDecimal bigDecimal = backFlushQtyBase == 10 ? (stockInfo.getQty().compareTo(SysConstant.BIGZERO) == 0 ? stockInfo.getPlannedQty() : stockInfo.getQty()) : (maxQty = stockInfo.getPlannedQty());
                if (maxQty.compareTo(SysConstant.BIGZERO) > 0 && maxQty.compareTo(stockInfo.getActIssueQty()) > 0) {
                    BigDecimal orderQty = SysConstant.BIGZERO;
                    int count = moInfo.getTechnics().size();
                    for (int j = 0; j < count; ++j) {
                        ManufactureOrderTechnicsInfo mti = moInfo.getTechnics().get(j);
                        if (stockInfo.getOperationNo() != mti.getOperationNo()) continue;
                        orderQty = mti.getQty().subtract(null == mti.getTotalSplitQty() ? SysConstant.BIGZERO : mti.getTotalSplitQty());
                        break;
                    }
                    if (backFlushQtyBase == 10) {
                        backflushQty = prodQty.multiply(stockInfo.getUnitQty()).setScale(prec, 0);
                    } else if (backFlushQtyBase == 20) {
                        backflushQty = prodQty.multiply(stockInfo.getPlannedQty()).divide(orderQty, prec, 0);
                    }
                    BigDecimal leaveIssueQty = maxQty.subtract(stockInfo.getActIssueQty());
                    if (leaveIssueQty.compareTo(backflushQty) < 0) {
                        backflushQty = leaveIssueQty;
                    }
                }
                if (backflushQty.compareTo(SysConstant.BIGZERO) > 0) {
                    int baseUnitprec = CompletionReportAuditUtil.getPrec(dataVO, stockInfo.getMaterial(), stockInfo.getBaseUnit());
                    BigDecimal convertRate = CompletionReportAuditUtil.getConvertRate(dataVO, stockInfo.getMaterial(), stockInfo.getUnit());
                    BigDecimal backBaseQty = backflushQty.multiply(convertRate).setScale(baseUnitprec, 4);
                    stockInfo.setUnIssueQty(backflushQty);
                    stockInfo.setUnIssueBaseQty(backBaseQty);
                } else if (!isBackFlushQtyMore) {
                    stockIter.remove();
                    --num;
                }
                ++num;
            }
            if (0 >= moInfo.getStocks().size()) continue;
            map.put(moInfo.getSourceBillId(), BackFrushStatusEnum.NOT_BACKFRUSH);
        }
        int count = ids.length;
        for (int i = 0; i < count; ++i) {
            if (map.containsKey(ids[i])) continue;
            map.put(ids[i], BackFrushStatusEnum.NO_BACKFRUSH);
        }
        return map;
    }

    public static CoreBillBaseCollection getOperationBackFlushOrders(Context ctx, String[] billIDs) throws BOSException, EASBizException {
        IManufactureOrder moBiz = ManufactureOrderFactory.getLocalInstance((Context)ctx);
        String idStr = SQLUtil.arrayToString((Object[])billIDs);
        String idSql = null;
        StringBuffer selectSQL = new StringBuffer();
        selectSQL.setLength(0);
        selectSQL.append("SELECT MOID FROM ( ").append("select t0.FDmesOrderID AS MOID ").append("from T_MM_CompletionReport t0 inner join T_MM_MFTOrderTechnics t1 on t0.FProcessID = t1.FID ").append("where t0.FID in (").append(idStr).append(") ").append("and t1.FIsReportPoint = 1 AND T0.FSOURCEBILLTYPE1 = '10' ").append(" UNION ").append("select COMPLETIONREPORT.FDmesOrderID AS MOID ").append("from T_MM_CompletionReport COMPLETIONREPORT ").append("     INNER JOIN T_MM_DisTaskDispatchEntry AS DISPWORKPROCESS ON COMPLETIONREPORT.FDispWorkProcessID = DISPWORKPROCESS.FID  ").append("     INNER JOIN T_MM_MFTOrderTechnics AS PROCESS ON DISPWORKPROCESS.FSOURCEBILLENTRYID = PROCESS.FID ").append("where COMPLETIONREPORT.FID in (").append(idStr).append(") ").append("and PROCESS.FIsReportPoint = 1 AND COMPLETIONREPORT.FSOURCEBILLTYPE1 = '20' ").append(") T");
        idSql = selectSQL.toString();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idSql, CompareType.INNER));
        Integer backFlushMode = new Integer(10);
        filterInfo.getFilterItems().add(new FilterItemInfo("transactionType.deductionBFPoint", (Object)backFlushMode));
        viewInfo.setFilter(filterInfo);
        FilterInfo entryFilterInfo = new FilterInfo();
        entryFilterInfo.setEntryName("stocks");
        entryFilterInfo.getFilterItems().add(new FilterItemInfo("isBackFlush", (Object)Boolean.TRUE));
        entryFilterInfo.getFilterItems().add(new FilterItemInfo("issueMode", (Object)new Integer(11040), CompareType.NOTEQUALS));
        viewInfo.getEntryFilters().add(entryFilterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("firstOperNo"));
        sic.add(new SelectorItemInfo("storageOrgUnit.*"));
        sic.add(new SelectorItemInfo("baseStatus"));
        sic.add(new SelectorItemInfo("sourceBillTypeId"));
        sic.add(new SelectorItemInfo("srcBillNum"));
        sic.add(new SelectorItemInfo("sourceBillId"));
        sic.add(new SelectorItemInfo("stocks.*"));
        sic.add(new SelectorItemInfo("technics.operationNo"));
        sic.add(new SelectorItemInfo("technics.isReportPoint"));
        sic.add(new SelectorItemInfo("technics.qty"));
        sic.add(new SelectorItemInfo("technics.totalSplitQty"));
        viewInfo.setSelector(sic);
        SorterItemCollection sortIC = new SorterItemCollection();
        sortIC.add(new SorterItemInfo("technics.operationNo"));
        sortIC.add(new SorterItemInfo("stocks.operationNo"));
        sortIC.add(new SorterItemInfo("stocks.replaceGroupFlag"));
        sortIC.add(new SorterItemInfo("stocks.replacePriority"));
        viewInfo.setSorter(sortIC);
        CoreBillBaseCollection cbc = moBiz.getCoreBillBaseCollection(viewInfo);
        Iterator orderIter = cbc.iterator();
        while (orderIter.hasNext()) {
            ManufactureOrderInfo mo = (ManufactureOrderInfo)orderIter.next();
            if (mo.getStocks().size() > 0) continue;
            orderIter.remove();
        }
        return cbc;
    }

    private static int getPrec(SCMEntryDataVO vo, MaterialInfo material, MeasureUnitInfo unitInfo) {
        int prec = 4;
        if (material != null && unitInfo != null) {
            String key = material.getId().toString() + unitInfo.getId().toString();
            if (vo != null && vo.getMmuPrecisions() != null && vo.getMmuPrecisions().get(key) != null) {
                prec = (Integer)vo.getMmuPrecisions().get(key);
            }
        }
        return prec;
    }

    private static BigDecimal getConvertRate(SCMEntryDataVO vo, MaterialInfo material, MeasureUnitInfo unitInfo) {
        BigDecimal convRate = new BigDecimal("1.0");
        if (material != null && unitInfo != null) {
            String key = material.getId().toString() + unitInfo.getId().toString();
            if (vo != null && vo.getMmuConvsRate() != null && vo.getMmuConvsRate().get(key) != null) {
                convRate = (BigDecimal)vo.getMmuConvsRate().get(key);
            }
        }
        return convRate;
    }

    private static SCMEntryDataVO getMaterialMmu(Context ctx, CoreBillBaseCollection cbc) throws EASBizException, BOSException {
        ArrayList<MaterialInfo> materialLst = new ArrayList<MaterialInfo>();
        ArrayList<MeasureUnitInfo> unitLst = new ArrayList<MeasureUnitInfo>();
        ArrayList<MeasureUnitInfo> baseunitLst = new ArrayList<MeasureUnitInfo>();
        ManufactureOrderInfo moInfo = null;
        for (int i = 0; i < cbc.size(); ++i) {
            moInfo = (ManufactureOrderInfo)cbc.get(i);
            for (int j = 0; j < moInfo.getStocks().size(); ++j) {
                materialLst.add(moInfo.getStocks().get(j).getMaterial());
                unitLst.add(moInfo.getStocks().get(j).getUnit());
                baseunitLst.add(moInfo.getStocks().get(j).getBaseUnit());
            }
        }
        SCMEntryDataVO vo = new SCMEntryDataVO();
        vo.setMaterialInfos(materialLst.toArray(new MaterialInfo[materialLst.size()]));
        vo.setBaseMeasureUnitInfos(baseunitLst.toArray(new MeasureUnitInfo[baseunitLst.size()]));
        vo.setMeasureUnitInfos(unitLst.toArray(new MeasureUnitInfo[unitLst.size()]));
        return SCMGroupFacadeFactory.getLocalInstance((Context)ctx).loadMmuPrecision(vo);
    }

    private static ManufactureOrderInfo getManufactureOrder(CoreBillBaseCollection cbc, String orderId) {
        if (cbc == null || orderId == null) {
            return null;
        }
        ManufactureOrderInfo moInfo = null;
        for (int i = 0; i < cbc.size(); ++i) {
            moInfo = (ManufactureOrderInfo)cbc.get(i);
            if (moInfo.getId().toString().equals(orderId)) {
                if (moInfo instanceof IObjectValueAgent) {
                    moInfo = (ManufactureOrderInfo)AgentUtility.deepCopyAgentValue((IObjectValueAgent)((IObjectValueAgent)moInfo));
                    break;
                }
                moInfo = (ManufactureOrderInfo)moInfo.clone();
                break;
            }
            moInfo = null;
        }
        return moInfo;
    }
}

