/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.sfc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.common.app.BillUpdater;
import com.kingdee.eas.mm.common.app.BillUpdaterFactory;
import com.kingdee.eas.mm.common.app.MMExternalProcessor;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.mo.app.CalculateWipUtil;
import com.kingdee.eas.mm.mo.app.CheckPickingHandler;
import com.kingdee.eas.mm.mo.app.MoExOutInstockWriteBack;
import com.kingdee.eas.mm.mo.app.MoInstockWriteBack;
import com.kingdee.eas.mm.mo.app.util.MOAutoCloseUtil;
import com.kingdee.eas.mm.mo.util.MOBackFlushUtil;
import com.kingdee.eas.mm.planning.app.mrp.MRPUtil;
import com.kingdee.eas.mm.sfc.SfcException;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;

public class CompletionReportProcessor
extends BillUpdater
implements MMExternalProcessor {
    private static final String currBillTypeID = "HxPKDRdzRpaqr31LD+3SBEY+1VI=";
    protected String billTypeID = null;
    protected String[] billIds = null;

    protected boolean beforeExecute() throws BOSException, EASBizException {
        if (!this.checkDataCount()) {
            return false;
        }
        this.insertTempTableData();
        MOAutoCloseUtil.checkMOCloseForCR((Context)this.ctx, (String)this.sourceDataTable);
        MOAutoCloseUtil.checkProductTransactionTypeForCR((Context)this.ctx, (String)this.sourceDataTable);
        this.setTargetTable("T_MM_COMPLETIONRES");
        this.setUpdateHead(false);
        this.setTransfUnit(true);
        this.setBaseQtyFields(new String[]{"FTOTALBASEENTERSTA"});
        this.setQtyFields(new String[]{"FTOTALENTERSTA"});
        this.setUnBaseQtyExpression("ISNULL(FCompleteBaseAmount,0)-ISNULL(FTOTALBASEENTERSTA,0)");
        if (this.isAuditAction) {
            this.setBaseQtyOperation(new String[]{"+"});
            this.setQtyOperation(new String[]{"+"});
        } else {
            this.setBaseQtyOperation(new String[]{"-"});
            this.setQtyOperation(new String[]{"-"});
        }
        this.setReleaseTempTable(true);
        this.setThrowException(true);
        this.setThrowExcpetion(new SfcException(SfcException.EXCEEDCOMPLETIONQTY));
        return true;
    }

    public boolean qtyCheck() throws BOSException, EASBizException {
        boolean flag = super.qtyCheck();
        if (flag) {
            String moSourceDataTable = this.getMOSourceDataTable(this.ctx, this.sourceDataTable);
            CheckPickingHandler handler = new CheckPickingHandler(this.ctx);
            handler.checkManufactureRec(moSourceDataTable);
        }
        return flag;
    }

    private String getMOSourceDataTable(Context ctx, String sourceDataTable) throws EASBizException, BOSException {
        StringBuffer updateSql = new StringBuffer();
        String moSourceDataTable = BillUpdaterFactory.createTempTable((Context)ctx);
        updateSql.append("insert into ").append(moSourceDataTable).append(" (FBillID,FSourceBillID,FSourceBillEntryId,FBaseQty)").append(" select t.FBillID, cr.FDmesOrderID, cr.FProcessID, t.FBaseQty ").append(" from " + sourceDataTable + " t, T_MM_CompletionRES res, T_MM_CompletionReport cr, T_MM_ManufactureOrder mo").append(" where t.FSourceBillEntryId=res.FID and res.FParentID=cr.FID and cr.FDmesOrderID = mo.FID and res.FMaterialID=mo.FMaterialID");
        MRPUtil.executeUpdate((Context)ctx, (String)updateSql.toString());
        return moSourceDataTable;
    }

    private void updateOutQtyWhenLastOP() throws BOSException, EASBizException {
        StringBuffer updateSrc = new StringBuffer(512);
        String distinctSrcTable = BillUpdaterFactory.createTempTable((Context)this.ctx);
        updateSrc.append("insert into ").append(distinctSrcTable).append(" (FSourceBillID)").append(" select distinct t.FSourceBillID ").append(" from " + this.sourceDataTable + " t, T_MM_CompletionReport cr ").append(" where  t.FSourceBillID = cr.FID ");
        MRPUtil.executeUpdate((Context)this.ctx, (String)updateSrc.toString());
        String flag = this.isAuditAction ? "+" : "-";
        updateSrc.setLength(0);
        updateSrc.append("update T_MM_CompletionReport as t0 set (FOpNo, FLastOpNo) = ( ").append(" select t.FOperationNo, t.FLastOperNo ").append(" from ( select t1.FOperationNo, t2.FLastOperNo, t1.FID ").append(" from T_MM_MFTOrderTechnics t1, T_MM_ManufactureOrder t2 ").append(" where t1.FParentID=t2.FID ) t where t.FID=t0.FProcessID").append(" ) where t0.FID in (select t4.FSourceBillID from ").append(distinctSrcTable).append(" t4)");
        DBUtil.execute((Context)this.ctx, (String)updateSrc.toString());
        updateSrc.setLength(0);
        updateSrc.append(" update T_MM_MFTOrderTechnics as t0 set (FoutQty,FoutBaseQty) = ( ").append(" select t0.FoutQty").append(flag).append("t.FSumScrapAmount, ").append(" t0.FoutBaseQty").append(flag).append("t.FSumBaseScrapAmount").append(" from (select sum(t2.FQualifiedAmount+t2.FYieldAmount) as FSumScrapAmount ,").append("sum(t2.FBaseQualifiedAmount+t2.FBaseYieldAmount) as FSumBaseScrapAmount, t1.FProcessID").append(" from T_MM_CompletionRAT as t2, T_MM_CompletionReport as t1, ").append(distinctSrcTable).append(" t3").append(" where t1.fid=t2.fparentid and t1.fid = t3.FSourceBillID and t1.FOpNo=t1.FLastOpNo and t1.FReportType=10").append(" group by t1.FProcessID) t where t0.fid=t.FProcessID").append(" )");
        DBUtil.execute((Context)this.ctx, (String)updateSrc.toString());
    }

    public void process(Context ctx, int bizAction, String billTypeId, String[] billIds) throws BOSException, EASBizException {
        this.ctx = ctx;
        this.billIds = billIds;
        this.billTypeID = billTypeId;
        if (!"50957179-0105-1000-e000-0167c0a812fd463ED552".equalsIgnoreCase(billTypeId)) {
            return;
        }
        String tableName = BillUpdaterFactory.createTempTable((Context)ctx);
        this.setSourceDataTable(tableName);
        this.setAuditAction(bizAction == 103);
        super.execute();
    }

    private boolean checkDataCount() throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("select count(T.FID) iCount ");
        sb.append("from T_IM_ManufactureRecBill T ");
        sb.append("where T.FID in (").append(SQLUtil.arrayToString((Object[])this.billIds)).append(") AND ");
        sb.append(" T.FSourceBillTypeID = '").append(currBillTypeID).append("'");
        IRowSet rows = DbUtil.executeQuery((Context)this.ctx, (String)sb.toString());
        try {
            while (rows.next()) {
                if (rows.getInt("iCount") <= 0) continue;
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    protected void insertTempTableData() throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("insert into ");
        sb.append(this.sourceDataTable);
        sb.append(" (FBillID, FSourceBillID, FSourceBillEntryId, FBaseQty, FQty) ");
        sb.append("select T.FID, Entry.FSourceBillID, Entry.FSourceBillEntryId, Entry.FBaseQty, Entry.FQty ");
        sb.append("from T_IM_ManufactureRecBill T ");
        sb.append("inner join T_IM_ManufactureRecBillEntry entry on T.FID = entry.FParentId ");
        sb.append("where T.FID in (").append(SQLUtil.arrayToString((Object[])this.billIds)).append(") AND ");
        sb.append(" T.FSourceBillTypeID = '").append(currBillTypeID).append("'");
        DbUtil.execute((Context)this.ctx, (String)sb.toString());
    }

    protected void afterExecute() throws BOSException, EASBizException {
        MOBackFlushUtil.setIsBackFlush((Context)this.ctx, (String)this.sourceDataTable, (String)"50957179-0105-1000-e000-0167c0a812fd463ED552", (boolean)this.isAuditAction);
        String moExOutInstockWriteBackTableName = BillUpdaterFactory.createTempTable((Context)this.ctx);
        MoExOutInstockWriteBack moExOutInstockWriteBack = new MoExOutInstockWriteBack(this.ctx);
        moExOutInstockWriteBack.setBillIds(this.billIds);
        moExOutInstockWriteBack.setBotDestBillTypeID("50957179-0105-1000-e000-0167c0a812fd463ED552");
        moExOutInstockWriteBack.setSourceDataTable(moExOutInstockWriteBackTableName);
        moExOutInstockWriteBack.setAuditAction(this.isAuditAction);
        moExOutInstockWriteBack.execute();
        String moInstockWriteBackTableName = BillUpdaterFactory.createTempTable((Context)this.ctx);
        MoInstockWriteBack moInstockWriteBack = new MoInstockWriteBack(this.ctx);
        moInstockWriteBack.setBillIds(this.billIds);
        moInstockWriteBack.setSourceDataTable(moInstockWriteBackTableName);
        moInstockWriteBack.setAuditAction(this.isAuditAction);
        moInstockWriteBack.execute();
        this.updateOutQtyWhenLastOP();
        StringBuffer updateSql = new StringBuffer();
        String entryDataTable = BillUpdaterFactory.createTempTable((Context)this.ctx);
        updateSql.append("insert into ").append(entryDataTable).append(" (FBillID,FSourceBillID,FSourceBillEntryId,FBaseQty)").append("select t2.FBillID,t1.FParentID,t1.FID,t2.FBaseQty ").append("from T_MM_MFTOrderStock t1, ").append(moInstockWriteBackTableName).append(" t2 ").append("where  t1.FParentID = t2.FSourceBillID ");
        int rowcount = MRPUtil.executeUpdate((Context)this.ctx, (String)updateSql.toString());
        if (rowcount > 0) {
            CalculateWipUtil.updateWipByTemTable((Context)this.ctx, (String)entryDataTable);
        }
        if (this.isAuditAction()) {
            MOAutoCloseUtil.autoCloseFromMRBByCR((Context)this.ctx, (String)moInstockWriteBackTableName, (boolean)false);
        }
        moExOutInstockWriteBack.releaseTemptable(moExOutInstockWriteBackTableName);
        moInstockWriteBack.releaseTemptable(moInstockWriteBackTableName);
        super.afterExecute();
    }

    public String createTempTable(Context ctx, String createTableSQL) throws Exception {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        return pool.createTempTable(createTableSQL);
    }

    public void releaseTempTable(Context ctx, String tableName) {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        pool.releaseTable(tableName);
    }
}

