/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.sfc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.common.app.BillUpdater;
import com.kingdee.eas.mm.common.app.BillUpdaterFactory;
import com.kingdee.eas.mm.common.app.MMExternalProcessor;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.mo.app.CheckPickingHandler;
import com.kingdee.eas.mm.mo.app.MoExOutInstockWriteBack;
import com.kingdee.eas.mm.mo.app.util.MOAutoCloseUtil;
import com.kingdee.eas.mm.planning.app.mrp.MRPUtil;
import com.kingdee.eas.mm.sfc.SfcException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;

public class CompletionReportToOtherInWarehUpdater
extends BillUpdater
implements MMExternalProcessor {
    private static final String currBillTypeID = "HxPKDRdzRpaqr31LD+3SBEY+1VI=";
    private static final String destBillTypeID = "50957179-0105-1000-e000-017bc0a812fd463ED552";
    protected String billTypeID = null;
    protected String[] billIds = null;

    protected boolean beforeExecute() throws BOSException, EASBizException {
        if (!this.checkDataCount()) {
            return false;
        }
        this.insertTempTableData();
        MOAutoCloseUtil.checkMOCloseForCRToOIW((Context)this.ctx, (String)this.sourceDataTable);
        MOAutoCloseUtil.checkProductTransactionTypeForCRToOIW((Context)this.ctx, (String)this.sourceDataTable);
        this.setTargetTable("T_MM_COMPLETIONRES");
        this.setUpdateHead(false);
        this.setTransfUnit(true);
        this.setBaseQtyFields(new String[]{"FTOTALBASEENTERSTA"});
        this.setQtyFields(new String[]{"FTOTALENTERSTA"});
        this.setUnBaseQtyExpression("ISNULL(FCompleteBaseAmount,0)-ISNULL(FTOTALBASEENTERSTA,0)");
        if (this.isAuditAction) {
            this.setBaseQtyOperation(new String[]{"+"});
            this.setQtyOperation(new String[]{"+"});
        } else {
            this.setBaseQtyOperation(new String[]{"-"});
            this.setQtyOperation(new String[]{"-"});
        }
        this.setReleaseTempTable(true);
        this.setThrowException(true);
        this.setThrowExcpetion(new SfcException(SfcException.OTHERINWAREHEXCEEDCOMPLETIONQTY));
        return true;
    }

    public boolean qtyCheck() throws BOSException, EASBizException {
        boolean flag = super.qtyCheck();
        if (flag) {
            String moSourceDataTable = this.getMOSourceDataTable(this.ctx, this.sourceDataTable);
            CheckPickingHandler handler = new CheckPickingHandler(this.ctx);
            handler.checkManufactureRec(moSourceDataTable);
        }
        return flag;
    }

    private String getMOSourceDataTable(Context ctx, String sourceDataTable) throws EASBizException, BOSException {
        StringBuffer updateSql = new StringBuffer();
        String moSourceDataTable = BillUpdaterFactory.createTempTable((Context)ctx);
        updateSql.append("insert into ").append(moSourceDataTable).append(" (FBillID,FSourceBillID,FSourceBillEntryId,FBaseQty)").append(" select t.FBillID, cr.FDmesOrderID, cr.FProcessID, t.FBaseQty ").append(" from " + sourceDataTable + " t, T_MM_CompletionRES res, T_MM_CompletionReport cr, T_MM_ManufactureOrder mo").append(" where t.FSourceBillEntryId=res.FID and res.FParentID=cr.FID and cr.FDmesOrderID = mo.FID and res.FMaterialID=mo.FMaterialID");
        MRPUtil.executeUpdate((Context)ctx, (String)updateSql.toString());
        return moSourceDataTable;
    }

    public void process(Context ctx, int bizAction, String billTypeId, String[] billIds) throws BOSException, EASBizException {
        this.ctx = ctx;
        this.billIds = billIds;
        this.billTypeID = billTypeId;
        if (!destBillTypeID.equalsIgnoreCase(billTypeId)) {
            return;
        }
        String tableName = BillUpdaterFactory.createTempTable((Context)ctx);
        this.setSourceDataTable(tableName);
        this.setAuditAction(bizAction == 103);
        super.execute();
    }

    private boolean checkDataCount() throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("select count(T.FID) iCount ");
        sb.append("from T_IM_OtherInWarehsBill T ");
        sb.append("where T.FID in (").append(SQLUtil.arrayToString((Object[])this.billIds)).append(") AND ");
        sb.append(" T.FSourceBillTypeID = '").append(currBillTypeID).append("'");
        IRowSet rows = DbUtil.executeQuery((Context)this.ctx, (String)sb.toString());
        try {
            while (rows.next()) {
                if (rows.getInt("iCount") <= 0) continue;
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    protected void insertTempTableData() throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("insert into ");
        sb.append(this.sourceDataTable);
        sb.append(" (FBillID, FSourceBillID, FSourceBillEntryId, FBaseQty, FQty) ");
        sb.append("select T.FID, Entry.FSourceBillID, Entry.FSourceBillEntryId, Entry.FBaseQty, Entry.FQty ");
        sb.append("from T_IM_OtherInWarehsBill T ");
        sb.append("inner join T_IM_OtherInWarehsBillEntry entry on T.FID = entry.FParentId ");
        sb.append("where T.FID in (").append(SQLUtil.arrayToString((Object[])this.billIds)).append(") AND ");
        sb.append(" T.FSourceBillTypeID = '").append(currBillTypeID).append("'");
        DbUtil.execute((Context)this.ctx, (String)sb.toString());
    }

    protected void afterExecute() throws BOSException, EASBizException {
        String moExOutInstockWriteBackTableName = BillUpdaterFactory.createTempTable((Context)this.ctx);
        MoExOutInstockWriteBack moExOutInstockWriteBack = new MoExOutInstockWriteBack(this.ctx);
        moExOutInstockWriteBack.setBillIds(this.billIds);
        moExOutInstockWriteBack.setBotDestBillTypeID(destBillTypeID);
        moExOutInstockWriteBack.setSourceDataTable(moExOutInstockWriteBackTableName);
        moExOutInstockWriteBack.setAuditAction(this.isAuditAction);
        moExOutInstockWriteBack.execute();
        moExOutInstockWriteBack.releaseTemptable(moExOutInstockWriteBackTableName);
        super.afterExecute();
    }

    public String createTempTable(Context ctx, String createTableSQL) throws Exception {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        return pool.createTempTable(createTableSQL);
    }

    public void releaseTempTable(Context ctx, String tableName) {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        pool.releaseTable(tableName);
    }
}

