/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.sfc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataLimitExceedException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.app.adapter.LogControllManager;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.IBillType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.sfc.AssistantTimeReportEntryFactory;
import com.kingdee.eas.mm.sfc.AssistantTimeReportEntryInfo;
import com.kingdee.eas.mm.sfc.CompletionReportFactory;
import com.kingdee.eas.mm.sfc.CompletionReportInfo;
import com.kingdee.eas.mm.sfc.HourlyAndEfficiencyWagesCollection;
import com.kingdee.eas.mm.sfc.HourlyAndEfficiencyWagesEntryCollection;
import com.kingdee.eas.mm.sfc.HourlyAndEfficiencyWagesEntryInfo;
import com.kingdee.eas.mm.sfc.HourlyAndEfficiencyWagesFactory;
import com.kingdee.eas.mm.sfc.HourlyAndEfficiencyWagesInfo;
import com.kingdee.eas.mm.sfc.IAssistantTimeReportEntry;
import com.kingdee.eas.mm.sfc.ICompletionReport;
import com.kingdee.eas.mm.sfc.IHourlyAndEfficiencyWages;
import com.kingdee.eas.mm.sfc.SalaryCaculateEnum;
import com.kingdee.eas.mm.sfc.SfcException;
import com.kingdee.eas.mm.sfc.app.AbstractHourlyAndEfficiencyWagesControllerBean;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class HourlyAndEfficiencyWagesControllerBean
extends AbstractHourlyAndEfficiencyWagesControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.sfc.app.HourlyAndEfficiencyWagesControllerBean");
    private static final String H_AND_E_BILLTYPEID = "n0nEWp9zUUDgQAB/AQALcUY+1VI=";

    protected String getXmlFileName(BatchActionEnum batchActionEnum) {
        return "com.kingdee.eas.mm.sfc.app.hourlyAndEfficiencyWageConfig.xml";
    }

    protected String getBillTypeId() {
        return H_AND_E_BILLTYPEID;
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk;
        block4: {
            try {
                this.reWriteSalaryCaculateFlag(ctx, null);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            pk = null;
            try {
                pk = super._addnew(ctx, model);
            }
            catch (BOSException ex) {
                if (!(ex.getCause() instanceof DataLimitExceedException)) break block4;
                throw new SfcException(SfcException.NUMBERTOOLONG);
            }
        }
        return pk;
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        block4: {
            try {
                this.reWriteSalaryCaculateFlag(ctx, pk);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                super._update(ctx, pk, model);
            }
            catch (BOSException ex) {
                if (!(ex.getCause() instanceof DataLimitExceedException)) break block4;
                throw new SfcException(SfcException.NUMBERTOOLONG);
            }
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.reWriteSalaryCaculateFlagForDelete(ctx, pk);
        super._delete(ctx, pk);
    }

    protected void _audit(Context ctx, IObjectPK objPK) throws BOSException, EASBizException {
        BatchExecuteParamsEntry entry = new BatchExecuteParamsEntry(new Class[]{IObjectPK.class});
        entry.add((Object)objPK);
        BatchExecuteParamsEntry[] entrys = new BatchExecuteParamsEntry[]{entry};
        this.batchAudit(ctx, entrys);
    }

    public BatchActionResults batchAudit(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        logger.info((Object)("reportbill begin :" + new Date()));
        BatchActionResults results = this.batchExecute(ctx, entries, BatchActionEnum.AUDIT);
        return results;
    }

    public BatchActionResults batchUnAudit(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        BatchActionResults results = this.batchExecute(ctx, entries, BatchActionEnum.UNAUDIT);
        return results;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK objectPK = super._submit(ctx, model);
        HourlyAndEfficiencyWagesInfo haeInfo = (HourlyAndEfficiencyWagesInfo)model;
        String orgUnitID = haeInfo.getStorageOrgUnit().getId().toString();
        IBillType iBillType = BillTypeFactory.getLocalInstance((Context)ctx);
        BillTypeInfo billTypeInfo = iBillType.getBillTypeInfo((IObjectPK)new ObjectUuidPK(this.getBillTypeId()));
        haeInfo.setBillType(billTypeInfo);
        if (this.isAuditAfterSubmit(ctx, haeInfo, orgUnitID, 4)) {
            this.auditAndLog(ctx, objectPK, haeInfo.getBOSType(), haeInfo.getNumber(), "mm_sfc_HAEReportAudit");
        }
        return objectPK;
    }

    protected void auditAndLog(Context ctx, IObjectPK pk, BOSObjectType bosType, String billNum, String logItemName) throws BOSException, EASBizException {
        LogControllManager.getInstance().enableLog();
        ServiceStateManager.getInstance().enableNextCallService("LOG_SERVICE");
        this.audit(ctx, pk);
    }

    public void batchCheck(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException, EASBizException {
        if (batchAction.equals((Object)BatchActionEnum.UNAUDIT)) {
            this.unAuditBatchCheck(ctx, batchResults);
        }
    }

    private void unAuditBatchCheck(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        String[] ids = batchResults.getToDoIdsArray();
        HashSet<String> idSet = new HashSet<String>();
        int count = ids.length;
        for (int i = 0; i < count; ++i) {
            idSet.add(ids[i]);
        }
        EntityViewInfo entity = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        entity.setFilter(filterInfo);
        IHourlyAndEfficiencyWages ihae = HourlyAndEfficiencyWagesFactory.getLocalInstance(ctx);
        HourlyAndEfficiencyWagesCollection col = ihae.getHourlyAndEfficiencyWagesCollection(entity);
        if (null != col && 0 < col.size()) {
            String msg = "";
            int count2 = col.size();
            for (int i = 0; i < count2; ++i) {
                HourlyAndEfficiencyWagesInfo haeInfo = (HourlyAndEfficiencyWagesInfo)col.getObject(i);
                IBillType iBillType = BillTypeFactory.getLocalInstance((Context)ctx);
                BillTypeInfo billTypeInfo = iBillType.getBillTypeInfo((IObjectPK)new ObjectUuidPK(this.getBillTypeId()));
                haeInfo.setBillType(billTypeInfo);
                String orgUnitID = haeInfo.getStorageOrgUnit().getId().toString();
                String atrId = haeInfo.getId().toString();
                if (!batchResults.isToDo(atrId)) continue;
                if (!this.isUnAudit(ctx, haeInfo, orgUnitID, 4)) {
                    msg = ResourceBase.getString((String)"com.kingdee.eas.mm.sfc.SfcResource", (String)"ISUNAUDIT_PARAM", (Locale)ctx.getLocale());
                    batchResults.addError(atrId, msg);
                }
                if (haeInfo.isCostFlag()) {
                    String msg1 = ResourceBase.getString((String)"com.kingdee.eas.mm.sfc.SfcResource", (String)"costFlagTrue", (Locale)ctx.getLocale());
                    batchResults.addError(atrId, msg1);
                }
                if (!haeInfo.isHrFlag()) continue;
                String msg2 = ResourceBase.getString((String)"com.kingdee.eas.mm.sfc.SfcResource", (String)"hrFlagTrue", (Locale)ctx.getLocale());
                batchResults.addError(atrId, msg2);
            }
        }
    }

    private void reWriteSalaryCaculateFlag(Context ctx, IObjectPK pk) throws BOSException, EASBizException, SQLException {
        HourlyAndEfficiencyWagesEntryCollection col;
        HourlyAndEfficiencyWagesInfo backInfo = null;
        IHourlyAndEfficiencyWages wages = HourlyAndEfficiencyWagesFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("entrys.completionReport.id"));
        sic.add(new SelectorItemInfo("entrys.assistantTimeReport.id"));
        sic.add(new SelectorItemInfo("entrys.assistantTimeReportEntry.id"));
        if (pk != null) {
            backInfo = (HourlyAndEfficiencyWagesInfo)wages.getValue(pk, sic);
        }
        HashSet<String> backCompSet = new HashSet<String>();
        HashSet<String> backAssSet = new HashSet<String>();
        HashSet<String> backAssEntrySet = new HashSet<String>();
        if (backInfo != null && (col = backInfo.getEntrys()) != null) {
            for (int i = 0; i < col.size(); ++i) {
                HourlyAndEfficiencyWagesEntryInfo entryInfo = col.get(i);
                if (entryInfo.getCompletionReport() != null) {
                    backCompSet.add(entryInfo.getCompletionReport().getId().toString());
                }
                if (entryInfo.getAssistantTimeReportEntry() != null) {
                    backAssEntrySet.add(entryInfo.getAssistantTimeReportEntry().getId().toString());
                }
                if (entryInfo.getAssistantTimeReport() == null) continue;
                backAssSet.add(entryInfo.getAssistantTimeReport().getId().toString());
            }
        }
        Set completionReportIds = new HashSet();
        if (ctx.get((Object)"CompletionReportIds") != null) {
            completionReportIds = (Set)ctx.get((Object)"CompletionReportIds");
        }
        Set assistantTimeReportEntryIds = new HashSet();
        if (ctx.get((Object)"AssistantTimeReportEntryIds") != null) {
            assistantTimeReportEntryIds = (Set)ctx.get((Object)"AssistantTimeReportEntryIds");
        }
        Set assistantTimeReportIds = new HashSet();
        if (ctx.get((Object)"AssistantTimeReportIds") != null) {
            assistantTimeReportIds = (Set)ctx.get((Object)"AssistantTimeReportIds");
        }
        this.executeWriteBackSql(ctx, completionReportIds, assistantTimeReportEntryIds, assistantTimeReportIds, backCompSet, backAssEntrySet, backAssSet);
    }

    private void reWriteSalaryCaculateFlagForDelete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        HourlyAndEfficiencyWagesEntryCollection col;
        HourlyAndEfficiencyWagesInfo backInfo = null;
        IHourlyAndEfficiencyWages wages = HourlyAndEfficiencyWagesFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("entrys.completionReport.id"));
        sic.add(new SelectorItemInfo("entrys.assistantTimeReport.id"));
        sic.add(new SelectorItemInfo("entrys.assistantTimeReportEntry.id"));
        backInfo = (HourlyAndEfficiencyWagesInfo)wages.getValue(pk, sic);
        HashSet<String> backCompSet = new HashSet<String>();
        HashSet<String> backAssSet = new HashSet<String>();
        HashSet<String> backAssEntrySet = new HashSet<String>();
        if (backInfo != null && (col = backInfo.getEntrys()) != null) {
            for (int i = 0; i < col.size(); ++i) {
                HourlyAndEfficiencyWagesEntryInfo entryInfo = col.get(i);
                if (entryInfo.getCompletionReport() != null) {
                    backCompSet.add(entryInfo.getCompletionReport().getId().toString());
                }
                if (entryInfo.getAssistantTimeReport() != null) {
                    backAssSet.add(entryInfo.getAssistantTimeReport().getId().toString());
                }
                if (entryInfo.getAssistantTimeReportEntry() == null) continue;
                backAssEntrySet.add(entryInfo.getAssistantTimeReportEntry().getId().toString());
            }
        }
        this.executeWriteBackSqlForDelete(ctx, backCompSet, backAssSet, backAssEntrySet);
    }

    private void executeWriteBackSqlForDelete(Context ctx, Set backCompSet, Set backAssSet, Set backAssEntrySet) throws BOSException {
        String updateSQL = new String();
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        updateSQL = "update T_MM_CompletionReport set FSalaryCaculateFlag = 6, FSalaryCaculateDate = null where fid = ?;";
        Iterator backComIt = backCompSet.iterator();
        while (backComIt.hasNext()) {
            params.add(new Object[]{backComIt.next()});
        }
        DbUtil.executeBatch((Context)ctx, (String)updateSQL.toString(), params);
        params = new ArrayList();
        updateSQL = "update T_MM_AssistantTimeReportEntry set FSalaryCaculateFlag = 6 where fid = ?;";
        Iterator backAssEntryIt = backAssEntrySet.iterator();
        while (backAssEntryIt.hasNext()) {
            params.add(new Object[]{backAssEntryIt.next()});
        }
        DbUtil.executeBatch((Context)ctx, (String)updateSQL.toString(), params);
        params = new ArrayList();
        updateSQL = "update T_MM_AssistantTimeReport set FSalaryCalStatus = 6 where fid = ?;";
        Iterator backAssIt = backAssSet.iterator();
        while (backAssIt.hasNext()) {
            params.add(new Object[]{backAssIt.next()});
        }
        DbUtil.executeBatch((Context)ctx, (String)updateSQL.toString(), params);
        String backAssIdStr = this.exchangeSetToString(backAssSet);
        updateSQL = "update T_MM_AssistantTimeReport set FSalaryCalDate = null where fid not in (select distinct fparentid from T_MM_AssistantTimeReportEntry as entry where entry.FSalaryCaculateFlag = 8 and entry.fparentid in ( " + backAssIdStr + " ) ) and fid in (" + backAssIdStr + ")";
        DBUtil.execute((Context)ctx, (String)updateSQL);
    }

    private void executeWriteBackSql(Context ctx, Set completionReportIdsSet, Set assistantTimeReportEntryIdsSet, Set assistantTimeReportIdsSet, Set backCompSet, Set backAssEntrySet, Set backAssSet) throws BOSException, SQLException {
        String updateSQL = new String();
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        Date bizDate = (Date)ctx.get((Object)"bizDate");
        updateSQL = "update T_MM_CompletionReport set FSalaryCaculateFlag = 6, FSalaryCaculateDate = null where fid = ?;";
        Iterator backComIt = backCompSet.iterator();
        while (backComIt.hasNext()) {
            params.add(new Object[]{backComIt.next()});
        }
        DbUtil.executeBatch((Context)ctx, (String)updateSQL.toString(), params);
        params = new ArrayList();
        updateSQL = "update T_MM_AssistantTimeReportEntry set FSalaryCaculateFlag = 6 where fid = ?;";
        Iterator backAssEntryIt = backAssEntrySet.iterator();
        while (backAssEntryIt.hasNext()) {
            params.add(new Object[]{backAssEntryIt.next()});
        }
        DbUtil.executeBatch((Context)ctx, (String)updateSQL.toString(), params);
        params = new ArrayList();
        updateSQL = "update T_MM_CompletionReport set FSalaryCaculateFlag = 8, FSalaryCaculateDate = ? where fid = ?;";
        Iterator entryComIt = completionReportIdsSet.iterator();
        while (entryComIt.hasNext()) {
            params.add(new Object[]{new Timestamp(bizDate.getTime()), entryComIt.next()});
        }
        DbUtil.executeBatch((Context)ctx, (String)updateSQL.toString(), params);
        params = new ArrayList();
        updateSQL = "update T_MM_AssistantTimeReportEntry set FSalaryCaculateFlag = 8 where fid = ?;";
        Iterator entryAssIt = assistantTimeReportEntryIdsSet.iterator();
        while (entryAssIt.hasNext()) {
            params.add(new Object[]{entryAssIt.next()});
        }
        DbUtil.executeBatch((Context)ctx, (String)updateSQL.toString(), params);
        params = new ArrayList();
        updateSQL = "update T_MM_AssistantTimeReport set FSalaryCalDate = ? where fid = ?;";
        Iterator AssIt = assistantTimeReportIdsSet.iterator();
        while (AssIt.hasNext()) {
            params.add(new Object[]{new Timestamp(bizDate.getTime()), AssIt.next()});
        }
        DbUtil.executeBatch((Context)ctx, (String)updateSQL.toString(), params);
        if (backAssSet != null && backAssSet.size() > 0) {
            Set excludeAssIdSet = this.getExcludeIdSet(backAssSet, assistantTimeReportIdsSet);
            String excludeAssIdStr = this.exchangeSetToString(excludeAssIdSet);
            updateSQL = "update T_MM_AssistantTimeReport set FSalaryCalDate = null where fid not in (select distinct entry.fparentid from T_MM_AssistantTimeReportEntry as entry where entry.FSalaryCaculateFlag = 8 and entry.fparentid in ( " + excludeAssIdStr + " ) ) and fid in (" + excludeAssIdStr + ")";
            DBUtil.execute((Context)ctx, (String)updateSQL);
        }
    }

    private Set getExcludeIdSet(Set backAssSet, Set assistantTimeReportIdsSet) {
        HashSet<String> excludeAssIdSet = new HashSet<String>();
        if (backAssSet != null) {
            for (String id : backAssSet) {
                if (assistantTimeReportIdsSet.contains(id)) continue;
                excludeAssIdSet.add(id);
            }
        }
        return excludeAssIdSet;
    }

    private String exchangeSetToString(Set ts) {
        StringBuffer tsStringbuffer = new StringBuffer();
        tsStringbuffer.append("'");
        if (!ts.isEmpty()) {
            Object[] tsArr = ts.toArray();
            String tsString = StringUtils.arrayToString((Object[])tsArr, (String)"','");
            tsStringbuffer.append(tsString);
        } else {
            String tsString = "";
        }
        tsStringbuffer.append("'");
        return tsStringbuffer.toString();
    }

    @Override
    protected List _checkDataExclusive(Context ctx, Set completionReportIdsSet, Set assistantTimeReportEntryIdsSet, HourlyAndEfficiencyWagesInfo info) throws BOSException, EASBizException {
        int i;
        HourlyAndEfficiencyWagesEntryCollection col;
        HourlyAndEfficiencyWagesInfo backInfo = new HourlyAndEfficiencyWagesInfo();
        IHourlyAndEfficiencyWages wages = HourlyAndEfficiencyWagesFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("entrys.completionReport.id"));
        sic.add(new SelectorItemInfo("entrys.completionReport.salaryCaculateFlag"));
        sic.add(new SelectorItemInfo("entrys.assistantTimeReport.id"));
        sic.add(new SelectorItemInfo("entrys.assistantTimeReportEntry.id"));
        sic.add(new SelectorItemInfo("entrys.assistantTimeReportEntry.salaryCaculateFlag"));
        if (info.getId() != null) {
            backInfo = (HourlyAndEfficiencyWagesInfo)wages.getValue((IObjectPK)new ObjectUuidPK(info.getId()), sic);
        }
        HashMap<String, SalaryCaculateEnum> backCompMap = new HashMap<String, SalaryCaculateEnum>();
        HashMap<String, SalaryCaculateEnum> backAssEntryMap = new HashMap<String, SalaryCaculateEnum>();
        if (backInfo != null && (col = backInfo.getEntrys()) != null) {
            for (int i2 = 0; i2 < col.size(); ++i2) {
                HourlyAndEfficiencyWagesEntryInfo entryInfo = col.get(i2);
                if (entryInfo.getCompletionReport() != null) {
                    backCompMap.put(entryInfo.getCompletionReport().getId().toString(), entryInfo.getCompletionReport().getSalaryCaculateFlag());
                }
                if (entryInfo.getAssistantTimeReportEntry() == null) continue;
                backAssEntryMap.put(entryInfo.getAssistantTimeReportEntry().getId().toString(), entryInfo.getAssistantTimeReportEntry().getSalaryCaculateFlag());
            }
        }
        HashSet<String> newComIdsSet = new HashSet<String>();
        if (completionReportIdsSet != null) {
            Iterator it = completionReportIdsSet.iterator();
            String id = null;
            while (it.hasNext()) {
                id = (String)it.next();
                if (backCompMap.get(id) != null) continue;
                newComIdsSet.add(id);
            }
        }
        HashSet<String> newAssEntryIdsSet = new HashSet<String>();
        if (assistantTimeReportEntryIdsSet != null) {
            Iterator it = assistantTimeReportEntryIdsSet.iterator();
            String id = null;
            while (it.hasNext()) {
                id = (String)it.next();
                if (backAssEntryMap.get(id) != null) continue;
                newAssEntryIdsSet.add(id);
            }
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", newComIdsSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection comSic = new SelectorItemCollection();
        comSic.add(new SelectorItemInfo("id"));
        comSic.add(new SelectorItemInfo("number"));
        comSic.add(new SelectorItemInfo("salaryCaculateFlag"));
        comSic.add(new SelectorItemInfo("baseStatus"));
        view.setSelector(comSic);
        ICompletionReport report = CompletionReportFactory.getLocalInstance(ctx);
        CoreBaseCollection comCol = report.getCollection(view);
        EntityViewInfo assEntryView = new EntityViewInfo();
        FilterInfo assEntryFilter = new FilterInfo();
        assEntryFilter.getFilterItems().add(new FilterItemInfo("id", newAssEntryIdsSet, CompareType.INCLUDE));
        assEntryView.setFilter(assEntryFilter);
        SelectorItemCollection assEntrySic = new SelectorItemCollection();
        assEntrySic.add(new SelectorItemInfo("parent.id"));
        assEntrySic.add(new SelectorItemInfo("parent.number"));
        assEntrySic.add(new SelectorItemInfo("parent.baseStatus"));
        assEntrySic.add(new SelectorItemInfo("id"));
        assEntrySic.add(new SelectorItemInfo("salaryCaculateFlag"));
        assEntryView.setSelector(assEntrySic);
        IAssistantTimeReportEntry assReportEntry = AssistantTimeReportEntryFactory.getLocalInstance(ctx);
        CoreBaseCollection assEntryCol = assReportEntry.getCollection(assEntryView);
        ArrayList<SCMBillBaseInfo> errorList = new ArrayList<SCMBillBaseInfo>();
        ArrayList<SCMBillBaseInfo> noAuditList = new ArrayList<SCMBillBaseInfo>();
        if (comCol != null) {
            for (i = 0; i < comCol.size(); ++i) {
                CompletionReportInfo reportInfo = (CompletionReportInfo)comCol.get(i);
                if (!BillBaseStatusEnum.AUDITED.equals((Object)reportInfo.getBaseStatus())) {
                    noAuditList.add(reportInfo);
                }
                if (!SalaryCaculateEnum.YET_CACULATE.equals((Object)reportInfo.getSalaryCaculateFlag())) continue;
                errorList.add(reportInfo);
            }
        }
        if (assEntryCol != null) {
            for (i = 0; i < assEntryCol.size(); ++i) {
                AssistantTimeReportEntryInfo assReportEntryInfo = (AssistantTimeReportEntryInfo)assEntryCol.get(i);
                if (assReportEntryInfo == null || assReportEntryInfo.getParent() == null) continue;
                if (!BillBaseStatusEnum.AUDITED.equals((Object)assReportEntryInfo.getParent().getBaseStatus())) {
                    noAuditList.add(assReportEntryInfo.getParent());
                }
                if (!SalaryCaculateEnum.YET_CACULATE.equals((Object)assReportEntryInfo.getSalaryCaculateFlag())) continue;
                errorList.add(assReportEntryInfo.getParent());
                break;
            }
        }
        if (noAuditList != null && noAuditList.size() > 0) {
            errorList = noAuditList;
        }
        return errorList;
    }

    @Override
    protected Map _getQtyAndHourTime(Context ctx, Set ids) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        sb.append("select fparentid, FTimeUnit as TimeUnit, ");
        sb.append("sum(FBaseQualifiedAmount) as BaseQualifiedAmount, ");
        sb.append("sum(FBaseYieldAmount) as BaseYieldAmount, ");
        sb.append("sum(FBaseWorkScrapAmount) as BaseWorkScrapAmount, ");
        sb.append("sum(FBaseMaterialScrapAm) as BaseMaterialScrapAm, ");
        sb.append("sum(FBaseReportAmount) as BaseReportAmount, ");
        sb.append("sum(FPrepareTime) as PrepareTime, ");
        sb.append("sum(FProcessTime) as ProcessTime ");
        sb.append("from T_MM_CompletionRAT where fparentid in (").append(SQLUtil.arrayToString((Object[])ids.toArray())).append(") group by fparentid,FTimeUnit order by fparentid");
        IRowSet irow = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        HashMap allMap = new HashMap();
        try {
            while (irow.next()) {
                HashMap<String, Object> amountTimeTotalMap = new HashMap<String, Object>();
                amountTimeTotalMap.put("fparentid", irow.getString("fparentid"));
                amountTimeTotalMap.put("TimeUnit", irow.getBigDecimal("TimeUnit"));
                amountTimeTotalMap.put("BaseQualifiedAmount", irow.getBigDecimal("BaseQualifiedAmount"));
                amountTimeTotalMap.put("BaseYieldAmount", irow.getBigDecimal("BaseYieldAmount"));
                amountTimeTotalMap.put("BaseWorkScrapAmount", irow.getBigDecimal("BaseWorkScrapAmount"));
                amountTimeTotalMap.put("BaseMaterialScrapAm", irow.getBigDecimal("BaseMaterialScrapAm"));
                amountTimeTotalMap.put("BaseReportAmount", irow.getBigDecimal("BaseReportAmount"));
                amountTimeTotalMap.put("PrepareTime", irow.getBigDecimal("PrepareTime"));
                amountTimeTotalMap.put("ProcessTime", irow.getBigDecimal("ProcessTime"));
                allMap.put(irow.getString("fparentid"), amountTimeTotalMap);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return allMap;
    }
}

