/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.sfc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.IDataBase;
import com.kingdee.eas.mm.basedata.ClassGroupEntryInfo;
import com.kingdee.eas.mm.basedata.ClassGroupFactory;
import com.kingdee.eas.mm.basedata.ClassGroupInfo;
import com.kingdee.eas.mm.basedata.IClassGroup;
import com.kingdee.eas.mm.basedata.LaborCostUnitEnum;
import com.kingdee.eas.mm.basedata.OprTimeUnitEnum;
import com.kingdee.eas.mm.basedata.ValuationTypeEnum;
import com.kingdee.eas.mm.sfc.CountWagesWayEnum;
import com.kingdee.eas.mm.sfc.HourlyAndEfficiencyWagesEntryInfo;
import com.kingdee.eas.mm.sfc.HourlyAndEfficiencyWagesFactory;
import com.kingdee.eas.mm.sfc.HourlyAndEfficiencyWagesInfo;
import com.kingdee.eas.mm.sfc.IHourlyAndEfficiencyWages;
import com.kingdee.eas.qm.common.util.NumericUtils;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.TypeConversionUtils;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Hashtable;

public class HourlyAndEfficiencyWagesDataTransmission
extends AbstractDataTransmission {
    private static String resources = "com.kingdee.eas.mm.sfc.SfcResource";

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        HourlyAndEfficiencyWagesInfo info = new HourlyAndEfficiencyWagesInfo();
        Hashtable headData = (Hashtable)hsData.get(new Integer(0));
        try {
            this.setHeadValue(ctx, info, headData);
            this.setBodyValue(ctx, info, hsData);
        }
        catch (BOSException e) {
            throw new TaskExternalException("BOSException:", (Throwable)e);
        }
        catch (EASBizException e) {
            throw new TaskExternalException("EASBizException:", (Throwable)e);
        }
        return info;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        int precision = 8;
        Hashtable result = new Hashtable();
        try {
            HourlyAndEfficiencyWagesDataTransmission.putTable(result, "FStorageOrgUnit_number", rs.getString("storageOrgUnit.number"));
            HourlyAndEfficiencyWagesDataTransmission.putTable(result, "FAdminOrgUnit_number", rs.getString("adminOrgUnit.number"));
            HourlyAndEfficiencyWagesDataTransmission.putTable(result, "FNumber", rs.getString("number"));
            HourlyAndEfficiencyWagesDataTransmission.putTable(result, "FWagesAccountForm", rs.getString("wagesAccountForm"));
            HourlyAndEfficiencyWagesDataTransmission.putTable(result, "FBizDate", rs.getString("bizDate"));
            HourlyAndEfficiencyWagesDataTransmission.putTable(result, "FCurrency_number", rs.getString("currency.number"));
            HourlyAndEfficiencyWagesDataTransmission.putTable(result, "FEntrys$classGroup_number", rs.getString("classGroup.number"));
            HourlyAndEfficiencyWagesDataTransmission.putTable(result, "FEntrys$person_number", rs.getString("person.number"));
            HourlyAndEfficiencyWagesDataTransmission.putTable(result, "FEntrys_salaryCaculateDate", rs.getString("entrys.salaryCaculateDate"));
            HourlyAndEfficiencyWagesDataTransmission.putTable(result, "FEntrys_passQty", StringUtils.formatNumber((double)NumericUtils.toBigDecimal((Object)rs.getString("entrys.passQty")).doubleValue(), (int)precision));
            HourlyAndEfficiencyWagesDataTransmission.putTable(result, "FEntrys_cancelLaborQty", StringUtils.formatNumber((double)NumericUtils.toBigDecimal((Object)rs.getString("entrys.cancelLaborQty")).doubleValue(), (int)precision));
            HourlyAndEfficiencyWagesDataTransmission.putTable(result, "FEntrys_matScarpLaborQty", StringUtils.formatNumber((double)NumericUtils.toBigDecimal((Object)rs.getString("entrys.matScarpLaborQty")).doubleValue(), (int)precision));
            HourlyAndEfficiencyWagesDataTransmission.putTable(result, "FEntrys_passManHours", StringUtils.formatNumber((double)NumericUtils.toBigDecimal((Object)rs.getString("entrys.passManHours")).doubleValue(), (int)precision));
            HourlyAndEfficiencyWagesDataTransmission.putTable(result, "FEntrys_workScrapManHours", StringUtils.formatNumber((double)NumericUtils.toBigDecimal((Object)rs.getString("entrys.workScrapManHours")).doubleValue(), (int)precision));
            HourlyAndEfficiencyWagesDataTransmission.putTable(result, "FEntrys_materialScrapManHours", StringUtils.formatNumber((double)NumericUtils.toBigDecimal((Object)rs.getString("entrys.materialScrapManHours")).doubleValue(), (int)precision));
            HourlyAndEfficiencyWagesDataTransmission.putTable(result, "FEntrys_assignWeight", StringUtils.formatNumber((double)NumericUtils.toBigDecimal((Object)rs.getString("entrys.assignWeight")).doubleValue(), (int)precision));
            HourlyAndEfficiencyWagesDataTransmission.putTable(result, "FEntrys_countWay", rs.getString("entrys.countWay"));
            HourlyAndEfficiencyWagesDataTransmission.putTable(result, "FEntrys_actuallyLaborCost", StringUtils.formatNumber((double)NumericUtils.toBigDecimal((Object)rs.getString("entrys.actuallyLaborCost")).doubleValue(), (int)precision));
            HourlyAndEfficiencyWagesDataTransmission.putTable(result, "FEntrys_actuallyCancelLaborCost", StringUtils.formatNumber((double)NumericUtils.toBigDecimal((Object)rs.getString("entrys.actuallyCancelLaborCost")).doubleValue(), (int)precision));
            HourlyAndEfficiencyWagesDataTransmission.putTable(result, "FEntrys_actuallyMatScarplLaborCost", StringUtils.formatNumber((double)NumericUtils.toBigDecimal((Object)rs.getString("entrys.actuallyMatScarplLaborCost")).doubleValue(), (int)precision));
            HourlyAndEfficiencyWagesDataTransmission.putTable(result, "FEntrys_theoryLaborCost", StringUtils.formatNumber((double)NumericUtils.toBigDecimal((Object)rs.getString("entrys.theoryLaborCost")).doubleValue(), (int)precision));
            HourlyAndEfficiencyWagesDataTransmission.putTable(result, "FEntrys_theoryCancelLaborCost", StringUtils.formatNumber((double)NumericUtils.toBigDecimal((Object)rs.getString("entrys.theoryCancelLaborCost")).doubleValue(), (int)precision));
            HourlyAndEfficiencyWagesDataTransmission.putTable(result, "FEntrys_theoryMatScarpLaborCost", StringUtils.formatNumber((double)NumericUtils.toBigDecimal((Object)rs.getString("entrys.theoryMatScarpLaborCost")).doubleValue(), (int)precision));
            HourlyAndEfficiencyWagesDataTransmission.putTable(result, "FEntrys_costUnit", rs.getString("entrys.costUnit"));
            HourlyAndEfficiencyWagesDataTransmission.putTable(result, "FEntrys_timeUnit", rs.getString("entrys.timeUnit"));
            HourlyAndEfficiencyWagesDataTransmission.putTable(result, "FEntrys$unit_number", rs.getString("unit.number"));
            HourlyAndEfficiencyWagesDataTransmission.putTable(result, "FEntrys_remark", rs.getString("entrys.remark"));
        }
        catch (Exception e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return result;
    }

    protected void setHeadValue(Context ctx, HourlyAndEfficiencyWagesInfo headInfo, Hashtable hsData) throws TaskExternalException, BOSException, EASBizException {
        StorageOrgUnitInfo orgInfo = this.getStorageOrgUnit(ctx, this.getDataString(hsData, "FStorageOrgUnit_number"));
        headInfo.setStorageOrgUnit(orgInfo);
        CtrlUnitInfo cu = orgInfo.getCU();
        headInfo.setCU(cu);
        try {
            this.checkPermission(ctx, headInfo, "mm_sfc_HAEReportAddnew");
        }
        catch (Exception e1) {
            throw new TaskExternalException(e1.getMessage(), (Throwable)e1);
        }
        AdminOrgUnitInfo adminInfo = this.getDept(ctx, orgInfo.getId().toString(), this.getDataString(hsData, "FAdminOrgUnit_number"));
        headInfo.setAdminOrgUnit(adminInfo);
        String number = this.getNumber(ctx, headInfo, this.getDataString(hsData, "FNumber"));
        if (this.isDoubleNumber(ctx, number)) {
            throw new TaskExternalException(HourlyAndEfficiencyWagesDataTransmission.getResource(ctx, "IMPORT_Number_DOUBLE", resources));
        }
        headInfo.setNumber(number);
        String accountForm = this.getDataString(hsData, "FWagesAccountForm");
        if (this.isNullOrEmpty(accountForm)) {
            throw new TaskExternalException(HourlyAndEfficiencyWagesDataTransmission.getResource(ctx, "IMPORT_WAGESACCOUNTFORM_IS_NULL", resources));
        }
        if (!this.isWagesAccountForm(accountForm)) {
            throw new TaskExternalException(HourlyAndEfficiencyWagesDataTransmission.getResource(ctx, "IMPORT_WAGESACCOUNTFORM_ERROR", resources));
        }
        headInfo.setWagesAccountForm(CountWagesWayEnum.getEnum(accountForm.trim()));
        String bizDate = this.getDataString(hsData, "FBizDate");
        if (this.isNullOrEmpty(bizDate)) {
            throw new TaskExternalException(HourlyAndEfficiencyWagesDataTransmission.getResource(ctx, "IMPORT_Msg_BizDate_Not_Null", resources));
        }
        try {
            headInfo.setBizDate(TypeConversionUtils.objToDate((Object)bizDate));
        }
        catch (Exception e) {
            throw new TaskExternalException(HourlyAndEfficiencyWagesDataTransmission.getResource(ctx, "IMPORT_Msg_BizDate_Error", resources));
        }
        String currency = this.getDataString(hsData, "FCurrency_number");
        if (this.isNullOrEmpty(currency)) {
            throw new TaskExternalException(HourlyAndEfficiencyWagesDataTransmission.getResource(ctx, "IMPORT_Msg_CUDRRENCY_Not_Null", resources));
        }
        CurrencyInfo currencyInfo = this.getCurrency(ctx, currency);
        if (!this.isRightFulCurrency(ctx, orgInfo, currencyInfo)) {
            throw new TaskExternalException(HourlyAndEfficiencyWagesDataTransmission.getResource(ctx, "IMPORT_CUDRRENCY_ERROR", resources));
        }
        headInfo.setCurrency(currencyInfo);
        headInfo.setBaseStatus(BillBaseStatusEnum.getEnum((int)1));
    }

    protected void setBodyValue(Context ctx, HourlyAndEfficiencyWagesInfo headInfo, Hashtable hsData) throws EASBizException, BOSException, TaskExternalException {
        Hashtable bodyData = null;
        for (int i = 0; i < hsData.size(); ++i) {
            String timeUnit;
            HourlyAndEfficiencyWagesEntryInfo entryInfo = new HourlyAndEfficiencyWagesEntryInfo();
            bodyData = (Hashtable)hsData.get(new Integer(i));
            entryInfo.setParent(headInfo);
            String groupNumber = this.getDataString(bodyData, "FEntrys$classGroup_number");
            ClassGroupInfo classGroupInfo = null;
            if (!this.isNullOrEmpty(groupNumber)) {
                classGroupInfo = this.getClassGroup(ctx, groupNumber);
                this.isRightFulClassGroup(ctx, classGroupInfo, headInfo.getAdminOrgUnit().getId().toString());
                entryInfo.setClassGroup(this.getClassGroup(ctx, groupNumber));
            }
            String personNumber = this.getDataString(bodyData, "FEntrys$person_number");
            PersonInfo personInfo = this.getPerson(ctx, personNumber);
            if (this.isRightFulPerson(ctx, headInfo.getAdminOrgUnit(), classGroupInfo, personInfo)) {
                entryInfo.setPerson(personInfo);
            }
            String salaryCaculateDate = this.getDataString(bodyData, "FEntrys_salaryCaculateDate");
            try {
                if (!this.isNullOrEmpty(salaryCaculateDate)) {
                    entryInfo.setSalaryCaculateDate(new Timestamp(TypeConversionUtils.objToDate((Object)salaryCaculateDate).getTime()));
                }
            }
            catch (Exception e) {
                throw new TaskExternalException(HourlyAndEfficiencyWagesDataTransmission.getResource(ctx, "IMPORT_salaryCaculateDate_Error", resources));
            }
            entryInfo.setPassQty(NumericUtils.toBigDecimal((Object)this.getDataString(bodyData, "FEntrys_passQty")));
            entryInfo.setCancelLaborQty(NumericUtils.toBigDecimal((Object)this.getDataString(bodyData, "FEntrys_cancelLaborQty")));
            entryInfo.setMatScarpLaborQty(NumericUtils.toBigDecimal((Object)this.getDataString(bodyData, "FEntrys_matScarpLaborQty")));
            entryInfo.setPassManHours(NumericUtils.toBigDecimal((Object)this.getDataString(bodyData, "FEntrys_passManHours")));
            entryInfo.setWorkScrapManHours(NumericUtils.toBigDecimal((Object)this.getDataString(bodyData, "FEntrys_workScrapManHours")));
            entryInfo.setMaterialScrapManHours(NumericUtils.toBigDecimal((Object)this.getDataString(bodyData, "FEntrys_materialScrapManHours")));
            entryInfo.setAssignWeight(NumericUtils.toBigDecimal((Object)this.getDataString(bodyData, "FEntrys_assignWeight")));
            String countWay = this.getDataString(bodyData, "FEntrys_countWay");
            if (this.isCountWay(countWay)) {
                entryInfo.setCountWay(ValuationTypeEnum.getEnum((int)new Integer(countWay.trim())));
            }
            entryInfo.setActuallyCancelLaborCost(NumericUtils.toBigDecimal((Object)this.getDataString(bodyData, "FEntrys_actuallyLaborCost")));
            entryInfo.setActuallyCancelLaborCost(NumericUtils.toBigDecimal((Object)this.getDataString(bodyData, "FEntrys_actuallyCancelLaborCost")));
            entryInfo.setActuallyMatScarplLaborCost(NumericUtils.toBigDecimal((Object)this.getDataString(bodyData, "FEntrys_actuallyMatScarplLaborCost")));
            entryInfo.setTheoryLaborCost(NumericUtils.toBigDecimal((Object)this.getDataString(bodyData, "FEntrys_theoryLaborCost")));
            entryInfo.setTheoryCancelLaborCost(NumericUtils.toBigDecimal((Object)this.getDataString(bodyData, "FEntrys_theoryCancelLaborCost")));
            entryInfo.setTheoryMatScarpLaborCost(NumericUtils.toBigDecimal((Object)this.getDataString(bodyData, "FEntrys_theoryMatScarpLaborCost")));
            String costUnit = this.getDataString(bodyData, "FEntrys_costUnit");
            if (this.isCostUnit(costUnit)) {
                entryInfo.setCostUnit(LaborCostUnitEnum.getEnum((int)new Integer(costUnit.trim())));
            }
            if (this.isTimeUnit(timeUnit = this.getDataString(bodyData, "FEntrys_timeUnit"))) {
                entryInfo.setTimeUnit(OprTimeUnitEnum.getEnum((int)new Integer(timeUnit.trim())));
            }
            String unitNumber = this.getDataString(bodyData, "FEntrys$unit_number");
            MeasureUnitInfo unitInfo = this.getUnit(ctx, unitNumber);
            if (!this.isNullOrEmpty(unitNumber) && unitInfo == null) {
                throw new TaskExternalException(HourlyAndEfficiencyWagesDataTransmission.getResource(ctx, "IMPORT_UNIT_IS_NOT_EXIST", resources));
            }
            entryInfo.setUnit(unitInfo);
            entryInfo.setRemark(this.getDataString(bodyData, "FEntrys_remark"));
            headInfo.getEntrys().add(entryInfo);
        }
    }

    private boolean isDoubleNumber(Context ctx, String number) throws BOSException {
        IHourlyAndEfficiencyWages ihaew = HourlyAndEfficiencyWagesFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        view.setFilter(filter);
        CoreBaseCollection col = ihaew.getCollection(view);
        return col != null && col.size() > 0;
    }

    private MeasureUnitInfo getUnit(Context ctx, String unitNumber) throws BOSException, EASBizException {
        IMeasureUnit imu = MeasureUnitFactory.getLocalInstance((Context)ctx);
        return (MeasureUnitInfo)this.getCoreBaseInfo((IDataBase)imu, unitNumber, null);
    }

    private PersonInfo getPerson(Context ctx, String personNumber) throws BOSException, EASBizException, TaskExternalException {
        if (this.isNullOrEmpty(personNumber)) {
            throw new TaskExternalException(HourlyAndEfficiencyWagesDataTransmission.getResource(ctx, "IMPORT_PERSON_IS_NOT_NULL", resources));
        }
        IPerson ips = PersonFactory.getLocalInstance((Context)ctx);
        return (PersonInfo)this.getCoreBaseInfo((IDataBase)ips, personNumber, null);
    }

    private boolean isRightFulPerson(Context ctx, AdminOrgUnitInfo adminInfo, ClassGroupInfo classGroupInfo, PersonInfo personInfo) throws TaskExternalException, EASBizException, BOSException {
        if (personInfo == null) {
            throw new TaskExternalException(HourlyAndEfficiencyWagesDataTransmission.getResource(ctx, "IMPORT_PERSON_IS_NOT_EXIST", resources));
        }
        if (classGroupInfo == null) {
            return this.isBeloanToDept(ctx, adminInfo, personInfo);
        }
        return this.isBelongToClassGroup(classGroupInfo, personInfo);
    }

    private boolean isBeloanToDept(Context ctx, AdminOrgUnitInfo adminInfo, PersonInfo personInfo) throws BOSException, EASBizException {
        IPositionMember ipm = PositionMemberFactory.getLocalInstance((Context)ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("position.adminOrgUnit.id", (Object)adminInfo.getId().toString()));
        EntityViewInfo view = HourlyAndEfficiencyWagesDataTransmission.getViewInfo(filter);
        CoreBaseCollection collection = ipm.getCollection(view);
        return collection != null && collection.size() > 0;
    }

    private boolean isBelongToClassGroup(ClassGroupInfo classGroupInfo, PersonInfo personInfo) {
        if (classGroupInfo == null) {
            return true;
        }
        if (classGroupInfo.getEntry() == null || classGroupInfo.getEntry().size() == 0) {
            return false;
        }
        ClassGroupEntryInfo entryInfo = null;
        for (int i = 0; i < classGroupInfo.getEntry().size(); ++i) {
            entryInfo = classGroupInfo.getEntry().get(i);
            if (!entryInfo.getPerson().getId().toString().equals(personInfo.getId().toString())) continue;
            return true;
        }
        return false;
    }

    private ClassGroupInfo getClassGroup(Context ctx, String groupNumber) throws BOSException, EASBizException {
        IClassGroup icg = ClassGroupFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection col = new SelectorItemCollection();
        col.add(new SelectorItemInfo("*"));
        col.add(new SelectorItemInfo("priceRateAllocationScheme.id"));
        col.add(new SelectorItemInfo("priceRateAllocationScheme.number"));
        col.add(new SelectorItemInfo("priceRateAllocationScheme.name"));
        col.add(new SelectorItemInfo("entry.*"));
        return (ClassGroupInfo)this.getCoreBaseInfo((IDataBase)icg, groupNumber, col);
    }

    private boolean isRightFulClassGroup(Context ctx, ClassGroupInfo info, String adminOrgId) throws TaskExternalException {
        if (info == null) {
            throw new TaskExternalException(HourlyAndEfficiencyWagesDataTransmission.getResource(ctx, "IMPORT_CLASSGROUP_IS_NOT_EXIST", resources));
        }
        String rightFulAdminOrgId = info.getWorkshop().getId().toString();
        return rightFulAdminOrgId.equals(adminOrgId);
    }

    public static EntityViewInfo getViewInfo(FilterInfo filter) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    public int getSubmitType() {
        return 1;
    }

    protected StorageOrgUnitInfo getStorageOrgUnit(Context ctx, String orgNumber) throws TaskExternalException {
        if (this.isNullOrEmpty(orgNumber)) {
            throw new TaskExternalException(HourlyAndEfficiencyWagesDataTransmission.getResource(ctx, "IMPORT_StorageOrgUnit_Not_null", resources));
        }
        try {
            IStorageOrgUnit isou = StorageOrgUnitFactory.getLocalInstance((Context)ctx);
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            if (orgNumber != null) {
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)orgNumber, CompareType.EQUALS));
                ev.setFilter(filter);
                ev.getSelector().add(new SelectorItemInfo("*"));
                ev.getSelector().add(new SelectorItemInfo("CU.*"));
                StorageOrgUnitCollection cols = isou.getStorageOrgUnitCollection(ev);
                if (cols.size() > 0) {
                    StorageOrgUnitInfo orgInfo = cols.get(0);
                    if (orgInfo.isIsBizUnit()) {
                        return orgInfo;
                    }
                    throw new TaskExternalException(HourlyAndEfficiencyWagesDataTransmission.getResource(ctx, "IMPORT_StorageOrgUnit_IsNotBizUnit", resources));
                }
                throw new TaskExternalException(HourlyAndEfficiencyWagesDataTransmission.getResource(ctx, "IMPORT_StorageOrgUnit_Not_Exist", resources));
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return HourlyAndEfficiencyWagesFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("BOSException: getLocalInstance", (Throwable)e);
        }
    }

    protected static String getResource(Context ctx, String strKey, String resource) {
        if (strKey == null || strKey.trim().length() == 0) {
            return null;
        }
        return SCMUtils.getResource((String)resource, (String)strKey, (Context)ctx);
    }

    protected String getDataString(Hashtable hsData, String key) {
        DataToken dataToken = (DataToken)hsData.get(key);
        if (dataToken == null) {
            return null;
        }
        String number = (String)dataToken.data;
        return number;
    }

    private void checkPermission(Context ctx, HourlyAndEfficiencyWagesInfo info, String permission) throws BOSException, TaskExternalException {
        StorageOrgUnitInfo orgInfo = info.getStorageOrgUnit();
        IPermission ipermission = PermissionFactory.getLocalInstance((Context)ctx);
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        ObjectUuidPK userPK = new ObjectUuidPK(user.getId());
        ObjectUuidPK orgPK = new ObjectUuidPK(orgInfo.getId());
        try {
            ipermission.checkFunctionPermission((IObjectPK)userPK, (IObjectPK)orgPK, permission);
        }
        catch (EASBizException e1) {
            throw new TaskExternalException(e1.getMessage(), (Throwable)e1);
        }
    }

    private String getNumber(Context ctx, HourlyAndEfficiencyWagesInfo headInfo, String number) throws TaskExternalException, BOSException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (this.isNullOrEmpty(number)) {
            try {
                number = iCodingRuleManager.getNumber((IObjectValue)headInfo, headInfo.getStorageOrgUnit().getId().toString());
            }
            catch (EASBizException e) {
                number = BOSUuid.create((BOSObjectType)headInfo.getBOSType()).toString();
            }
        }
        if (number.length() >= 80) {
            throw new TaskExternalException(HourlyAndEfficiencyWagesDataTransmission.getResource(ctx, "IMPORT_Number_Too_long", resources));
        }
        return number;
    }

    private AdminOrgUnitInfo getDept(Context ctx, String orgId, String adminNumber) throws EASBizException, BOSException, TaskExternalException {
        if (this.isNullOrEmpty(adminNumber)) {
            throw new TaskExternalException(HourlyAndEfficiencyWagesDataTransmission.getResource(ctx, "IMPORT_DETP_IS_NULL", resources));
        }
        AdminOrgUnitInfo adminInfo = this.getAdminOrgUnitInfo(ctx, adminNumber);
        if (adminInfo == null) {
            throw new TaskExternalException(HourlyAndEfficiencyWagesDataTransmission.getResource(ctx, "IMPORT_DETP_IS_NOT_EXIST", resources));
        }
        if (this.isAuthorizeAdmin(ctx, orgId, adminInfo)) {
            return adminInfo;
        }
        throw new TaskExternalException(HourlyAndEfficiencyWagesDataTransmission.getResource(ctx, "IMPORT_DETP_IS_NOT_AUTHORIZEADMIN", resources));
    }

    private AdminOrgUnitInfo getAdminOrgUnitInfo(Context ctx, String adminNumber) throws BOSException, EASBizException {
        IAdminOrgUnit iAdmin = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
        return (AdminOrgUnitInfo)this.getCoreBaseInfo((IDataBase)iAdmin, adminNumber, null);
    }

    private boolean isAuthorizeAdmin(Context ctx, String orgId, AdminOrgUnitInfo adminInfo) {
        HashSet set = this.getAdminOrgByStorageOrg(ctx, orgId);
        return set != null && set.contains(adminInfo.getId().toString());
    }

    private HashSet getAdminOrgByStorageOrg(Context ctx, String storageOrgId) {
        if (storageOrgId == null) {
            return null;
        }
        try {
            IOrgUnitRelation iOrgUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            HashSet<String> set = new HashSet<String>();
            OrgUnitCollection orgIds = iOrgUnitRel.getToUnit(storageOrgId, 4, 0);
            for (int i = 0; orgIds != null && i < orgIds.size(); ++i) {
                set.add(orgIds.get(i).getId().toString());
            }
            return set;
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return null;
    }

    private boolean isWagesAccountForm(String wagesAccountForm) {
        HashSet<String> wagesAccountFormSet = new HashSet<String>();
        wagesAccountFormSet.add("0");
        wagesAccountFormSet.add("1");
        return wagesAccountFormSet.contains(wagesAccountForm.trim());
    }

    private boolean isCountWay(String countWay) {
        if (this.isNullOrEmpty(countWay)) {
            return false;
        }
        HashSet<String> countWaySet = new HashSet<String>();
        countWaySet.add("0");
        countWaySet.add("10");
        countWaySet.add("20");
        return countWaySet.contains(countWay.trim());
    }

    private boolean isCostUnit(String costUnit) {
        if (this.isNullOrEmpty(costUnit)) {
            return false;
        }
        HashSet<String> costUnitSet = new HashSet<String>();
        costUnitSet.add("1");
        return costUnitSet.contains(costUnit.trim());
    }

    private boolean isTimeUnit(String timeUnit) {
        if (this.isNullOrEmpty(timeUnit)) {
            return false;
        }
        HashSet<String> timeUnitSet = new HashSet<String>();
        timeUnitSet.add("2");
        timeUnitSet.add("3");
        timeUnitSet.add("4");
        return timeUnitSet.contains(timeUnit.trim());
    }

    private boolean isRightFulCurrency(Context ctx, StorageOrgUnitInfo orgUnit, CurrencyInfo currency) {
        CurrencyInfo rightFulCurrency = HourlyAndEfficiencyWagesDataTransmission.getBaseCurrencyByCompanyOrg(ctx, orgUnit.getId().toString());
        return rightFulCurrency != null && rightFulCurrency.getNumber().equals(currency.getNumber());
    }

    public static CurrencyInfo getBaseCurrencyByCompanyOrg(Context ctx, String storageOrgId) {
        CompanyOrgUnitInfo orgUnit = HourlyAndEfficiencyWagesDataTransmission.getCompanyOrgByStorageOrg(ctx, storageOrgId);
        CurrencyInfo baseCurrInfo = null;
        try {
            ICurrency icurrency = CurrencyFactory.getLocalInstance((Context)ctx);
            if (orgUnit != null && orgUnit.getBaseCurrency() != null) {
                ObjectUuidPK uuidPk = new ObjectUuidPK(orgUnit.getBaseCurrency().getId());
                baseCurrInfo = icurrency.getCurrencyInfo((IObjectPK)uuidPk);
            }
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return baseCurrInfo;
    }

    public static CompanyOrgUnitInfo getCompanyOrgByStorageOrg(Context ctx, String storageOrgId) {
        if (storageOrgId == null) {
            return null;
        }
        try {
            CompanyOrgUnitInfo ret = null;
            IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            OrgUnitCollection orgCol = iUnitRel.getToUnit(storageOrgId, 4, 1);
            if (orgCol != null && orgCol.size() > 0) {
                ret = (CompanyOrgUnitInfo)orgCol.get(0);
            }
            return ret;
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return null;
    }

    private CurrencyInfo getCurrency(Context ctx, String currency) throws BOSException, EASBizException, TaskExternalException {
        ICurrency ic = CurrencyFactory.getLocalInstance((Context)ctx);
        CurrencyInfo info = (CurrencyInfo)this.getCoreBaseInfo((IDataBase)ic, currency, null);
        if (info == null) {
            throw new TaskExternalException(HourlyAndEfficiencyWagesDataTransmission.getResource(ctx, "IMPORT_CURRENCY_IS_NOT_EXIST", resources));
        }
        return info;
    }

    private CoreBaseInfo getCoreBaseInfo(IDataBase idb, String number, SelectorItemCollection col) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        EntityViewInfo view = HourlyAndEfficiencyWagesDataTransmission.getViewInfo(filter);
        if (col == null) {
            col = new SelectorItemCollection();
            col.add(new SelectorItemInfo("*"));
        }
        view.setSelector(col);
        CoreBaseCollection collection = idb.getCollection(view);
        if (collection != null && collection.size() > 0) {
            return collection.get(0);
        }
        return null;
    }

    private boolean isNullOrEmpty(String obj) {
        if (obj == null) {
            return true;
        }
        return "".equals(obj.trim());
    }

    public boolean isSameBlock(Hashtable firstData, Hashtable currentData) {
        return firstData != null && currentData != null && firstData.get("FStorageOrgUnit_number").equals(currentData.get("FStorageOrgUnit_number")) && firstData.get("FAdminOrgUnit_number").equals(currentData.get("FAdminOrgUnit_number")) && firstData.get("FNumber").equals(currentData.get("FNumber")) && firstData.get("FWagesAccountForm").equals(currentData.get("FWagesAccountForm")) && firstData.get("FBizDate").equals(currentData.get("FBizDate")) && firstData.get("FCurrency_number").equals(currentData.get("FCurrency_number"));
    }

    public static void putTable(Hashtable htable, Object key, Object value) {
        if (value != null) {
            htable.put(key, value);
        }
    }
}

