/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.sfc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.agent.AgentUtility;
import com.kingdee.bos.framework.agent.IObjectValueAgent;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.function.WfEventListenerStateManager;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Collections;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.log.app.adapter.LogControllManager;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.IssuePriorityEnum;
import com.kingdee.eas.basedata.master.material.MaterialCostCollection;
import com.kingdee.eas.basedata.master.material.MaterialCostFactory;
import com.kingdee.eas.basedata.master.material.MaterialCostInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.common.util.StoreCommonUtil;
import com.kingdee.eas.mm.common.util.TransactionTypeHelper;
import com.kingdee.eas.mm.mo.IManufactureOrder;
import com.kingdee.eas.mm.mo.IManufactureOrderStock;
import com.kingdee.eas.mm.mo.ManufactureOrderException;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderStockCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderStockFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderStockInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.mm.sfc.BackFlushFilterInfo;
import com.kingdee.eas.mm.sfc.BackFlushListResultInfo;
import com.kingdee.eas.mm.sfc.BackFlushSourceTypeEnum;
import com.kingdee.eas.mm.sfc.BackFrushStatusEnum;
import com.kingdee.eas.mm.sfc.CalculateLotLineValue;
import com.kingdee.eas.mm.sfc.CalculateLotValue;
import com.kingdee.eas.mm.sfc.CalculateParam;
import com.kingdee.eas.mm.sfc.CompletionReportCollection;
import com.kingdee.eas.mm.sfc.CompletionReportFactory;
import com.kingdee.eas.mm.sfc.CompletionReportInfo;
import com.kingdee.eas.mm.sfc.ICompletionReport;
import com.kingdee.eas.mm.sfc.IInteractionBackFlush;
import com.kingdee.eas.mm.sfc.InteractionBackFlushCollection;
import com.kingdee.eas.mm.sfc.InteractionBackFlushFactory;
import com.kingdee.eas.mm.sfc.InteractionBackFlushInfo;
import com.kingdee.eas.mm.sfc.SfcException;
import com.kingdee.eas.mm.sfc.SourceBillTypeEnum;
import com.kingdee.eas.mm.sfc.app.AbstractInteractionBackflushFacadeControllerBean;
import com.kingdee.eas.scm.common.SCMGroupFacadeFactory;
import com.kingdee.eas.scm.common.loadmass.SCMEntryDataVO;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.BackFlushSucceedEnum;
import com.kingdee.eas.scm.im.inv.IManufactureRecBill;
import com.kingdee.eas.scm.im.inv.IManufactureRecBillEntry;
import com.kingdee.eas.scm.im.inv.IMaterialReqBill;
import com.kingdee.eas.scm.im.inv.InventoryCollection;
import com.kingdee.eas.scm.im.inv.InventoryInfo;
import com.kingdee.eas.scm.im.inv.ManufactureRecBillEntryCollection;
import com.kingdee.eas.scm.im.inv.ManufactureRecBillEntryFactory;
import com.kingdee.eas.scm.im.inv.ManufactureRecBillEntryInfo;
import com.kingdee.eas.scm.im.inv.ManufactureRecBillFactory;
import com.kingdee.eas.scm.im.inv.ManufactureRecBillInfo;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryInfo;
import com.kingdee.eas.scm.im.inv.MaterialReqBillFactory;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import com.kingdee.util.UuidException;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class InteractionBackflushFacadeControllerBean
extends AbstractInteractionBackflushFacadeControllerBean {
    private static final long serialVersionUID = -7099739633917539220L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.sfc.app.InteractionBackflushFacadeControllerBean");
    public static final String OP_BACKFLUSH_CTX = "backflush_delay";
    private static final String BACKFLUSH_BOTOPID = "AvzPEPUxQFuyv68C0g2dPwRRIsQ=";
    private static final String MATERIALREQ_BOSTYPE = "500AB75E";
    private static BigDecimal ZERO = new BigDecimal("0.00");

    @Override
    protected List _getRecBillAndCompletionData(Context ctx, BackFlushFilterInfo filterInfo) throws BOSException, EASBizException {
        ArrayList<BackFlushListResultInfo> result = new ArrayList<BackFlushListResultInfo>();
        result.addAll(this.getCompletionData(ctx, filterInfo));
        result.addAll(this.getRecBillData(ctx, filterInfo));
        Collections.sort(result, (Comparator)InteractionBackflushFacadeControllerBean.getResultComparator());
        return result;
    }

    public static Comparator getResultComparator() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                BackFlushListResultInfo mo1 = (BackFlushListResultInfo)o1;
                BackFlushListResultInfo mo2 = (BackFlushListResultInfo)o2;
                if (mo1.getStorageUnitNum().getNumber().compareTo(mo2.getStorageUnitNum().getNumber()) == 0) {
                    if (mo1.getBizDate().compareTo(mo2.getBizDate()) == 0) {
                        if (mo1.getBilltype().compareTo((Object)mo2.getBilltype()) == 0) {
                            return mo1.getNumber().compareTo(mo2.getNumber());
                        }
                        return mo1.getBilltype().compareTo((Object)mo2.getBilltype());
                    }
                    return mo1.getBizDate().compareTo(mo2.getBizDate());
                }
                return mo1.getStorageUnitNum().getNumber().compareTo(mo2.getStorageUnitNum().getNumber());
            }
        };
    }

    private List<BackFlushListResultInfo> getCompletionData(Context ctx, BackFlushFilterInfo filterInfo) throws BOSException {
        ArrayList<BackFlushListResultInfo> resultList = new ArrayList<BackFlushListResultInfo>();
        FilterInfo filter = this.buildCommonFilter(filterInfo, ctx);
        this.getCompletionFilter(filter);
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("dmesOrder.id"));
        sic.add(new SelectorItemInfo("dmesOrder.name"));
        sic.add(new SelectorItemInfo("dmesOrder.number"));
        sic.add(new SelectorItemInfo("process.operation.id"));
        sic.add(new SelectorItemInfo("process.operation.name"));
        sic.add(new SelectorItemInfo("process.operation.number"));
        sic.add(new SelectorItemInfo("dispWorkProcess.operation.id"));
        sic.add(new SelectorItemInfo("dispWorkProcess.operation.name"));
        sic.add(new SelectorItemInfo("dispWorkProcess.operation.number"));
        sic.add(new SelectorItemInfo("dispatchWork.id"));
        sic.add(new SelectorItemInfo("dispatchWork.name"));
        sic.add(new SelectorItemInfo("dispatchWork.number"));
        sic.add(new SelectorItemInfo("productNumber.id"));
        sic.add(new SelectorItemInfo("productNumber.name"));
        sic.add(new SelectorItemInfo("productNumber.number"));
        sic.add(new SelectorItemInfo("productNumber.model"));
        sic.add(new SelectorItemInfo("unit.id"));
        sic.add(new SelectorItemInfo("unit.name"));
        sic.add(new SelectorItemInfo("unit.number"));
        sic.add(new SelectorItemInfo("baseUnit.id"));
        sic.add(new SelectorItemInfo("baseUnit.name"));
        sic.add(new SelectorItemInfo("baseUnit.number"));
        sic.add(new SelectorItemInfo("project.id"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("trackNumber.id"));
        sic.add(new SelectorItemInfo("trackNumber.name"));
        sic.add(new SelectorItemInfo("trackNumber.number"));
        ICompletionReport report = CompletionReportFactory.getLocalInstance(ctx);
        viewInfo.setFilter(filter);
        viewInfo.setSelector(sic);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("number"));
        viewInfo.setSorter(sorter);
        CompletionReportCollection coll = report.getCompletionReportCollection(viewInfo);
        if (coll != null && coll.size() > 0) {
            try {
                for (int i = 0; i < coll.size(); ++i) {
                    BackFlushListResultInfo result = new BackFlushListResultInfo();
                    result.setStorageUnitNum(coll.get(i).getStorageOrgUnit());
                    result.setReportInfo(coll.get(i));
                    result.setBackFlushFlag(coll.get(i).getIsBackfrush());
                    result.setBilltype(BackFlushSourceTypeEnum.BACKFLUSH_COMPLETION);
                    result.setBizDate(coll.get(i).getBizDate());
                    result.setDisInfo(coll.get(i).getDispatchWork());
                    result.setManuOrder(coll.get(i).getDmesOrder());
                    result.setMaterial(coll.get(i).getProductNumber());
                    result.setProject(coll.get(i).getProject() != null ? coll.get(i).getProject().getNumber() : null);
                    result.setTrcknumber(coll.get(i).getTrackNumber() != null ? coll.get(i).getTrackNumber().getNumber() : null);
                    result.setQty(coll.get(i).getReportQty());
                    result.setId(System.currentTimeMillis() + "" + i);
                    result.setBaseQty(coll.get(i).getBasereportQty());
                    result.setUnit(coll.get(i).getUnit());
                    result.setBsUnit(coll.get(i).getBaseUnit());
                    if (coll.get(i).getSourceBillType1() == SourceBillTypeEnum.PRODUCTORDER) {
                        result.setOperation(coll.get(i).getProcess().getOperation());
                    } else if (coll.get(i).getSourceBillType1() == SourceBillTypeEnum.DISPATCHWORKBILL) {
                        result.setOperation(coll.get(i).getDispWorkProcess().getOperation());
                    }
                    resultList.add(result);
                }
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        return resultList;
    }

    private void getCompletionFilter(FilterInfo filter) {
        HashSet<Integer> set = new HashSet<Integer>();
        set.add(new Integer(3));
        set.add(new Integer(2));
        set.add(new Integer(4));
        filter.getFilterItems().add(new FilterItemInfo("isBackfrush", set, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("reportQty", (Object)new BigDecimal("0.00"), CompareType.NOTEQUALS));
        HashSet<Integer> set2 = new HashSet<Integer>();
        set2.add(new Integer(4));
        set2.add(new Integer(5));
        set2.add(new Integer(8));
        filter.getFilterItems().add(new FilterItemInfo("dmesOrder.baseStatus", set2, CompareType.INCLUDE));
    }

    private List<BackFlushListResultInfo> getRecBillData(Context ctx, BackFlushFilterInfo filterInfo) throws BOSException, EASBizException {
        ArrayList<BackFlushListResultInfo> resultList = new ArrayList<BackFlushListResultInfo>();
        FilterInfo filter = this.buildCommonFilterForRecBill(filterInfo, ctx);
        filter.getFilterItems().add(new FilterItemInfo("parent.baseStatus", (Object)new Integer(4), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("qty", (Object)new BigDecimal("0.00"), CompareType.NOTEQUALS));
        FilterInfo backFlushStatusMode = new FilterInfo();
        backFlushStatusMode.getFilterItems().add(new FilterItemInfo("parent.isBackFlushSucceed", (Object)new Integer(3), CompareType.EQUALS));
        backFlushStatusMode.getFilterItems().add(new FilterItemInfo("parent.isBackFlushSucceed", (Object)new Integer(2), CompareType.EQUALS));
        backFlushStatusMode.getFilterItems().add(new FilterItemInfo("parent.isBackFlushSucceed", (Object)new Integer(4), CompareType.EQUALS));
        backFlushStatusMode.setMaskString("#0 or #1 or #2");
        filter.mergeFilter(backFlushStatusMode, "AND");
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("parent.name"));
        sic.add(new SelectorItemInfo("parent.number"));
        sic.add(new SelectorItemInfo("parent.isBackFlushSucceed"));
        sic.add(new SelectorItemInfo("parent.bizDate"));
        sic.add(new SelectorItemInfo("parent.storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("parent.storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("parent.storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("parent.storageOrgUnit.*"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("material.name"));
        sic.add(new SelectorItemInfo("material.number"));
        sic.add(new SelectorItemInfo("material.model"));
        sic.add(new SelectorItemInfo("unit.id"));
        sic.add(new SelectorItemInfo("unit.name"));
        sic.add(new SelectorItemInfo("unit.number"));
        sic.add(new SelectorItemInfo("baseUnit.id"));
        sic.add(new SelectorItemInfo("baseUnit.name"));
        sic.add(new SelectorItemInfo("baseUnit.number"));
        sic.add(new SelectorItemInfo("qty"));
        sic.add(new SelectorItemInfo("baseQty"));
        sic.add(new SelectorItemInfo("lot"));
        sic.add(new SelectorItemInfo("manuBillID"));
        IManufactureRecBillEntry recbill = ManufactureRecBillEntryFactory.getLocalInstance((Context)ctx);
        viewInfo.setSelector(sic);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("parent.number"));
        viewInfo.setSorter(sorter);
        ManufactureRecBillEntryCollection coll = recbill.getManufactureRecBillEntryCollection(viewInfo);
        if (coll != null && coll.size() > 0) {
            int manuRecEntrySize = coll.size();
            HashSet<String> manuRecIds = new HashSet<String>(manuRecEntrySize);
            HashSet<String> orderIds = new HashSet<String>(manuRecEntrySize);
            ManufactureRecBillEntryInfo manuRecEntry = null;
            for (int i = 0; i < manuRecEntrySize; ++i) {
                manuRecEntry = coll.get(i);
                manuRecIds.add(manuRecEntry.getParent().getId().toString());
                orderIds.add(manuRecEntry.getManuBillID());
            }
            Object[] manuOrders = this.getSourceManuOrder4ManuRec(ctx, manuRecIds, orderIds);
            Map manuRecs = (Map)manuOrders[0];
            Map orders = (Map)manuOrders[1];
            ManufactureOrderInfo order = null;
            BackFlushListResultInfo result = null;
            for (int i = 0; i < manuRecEntrySize; ++i) {
                if (!manuRecs.containsKey(coll.get(i).getParent().getId().toString())) continue;
                result = new BackFlushListResultInfo();
                result.setStorageUnitNum(coll.get(i).getParent().getStorageOrgUnit());
                result.setRecBillInfo(coll.get(i).getParent());
                result.setBackFlushFlag(BackFrushStatusEnum.getEnum(coll.get(i).getParent().getIsBackFlushSucceed().getValue()));
                result.setBilltype(BackFlushSourceTypeEnum.BACKFLUSH_RECBILL);
                result.setBizDate(coll.get(i).getParent().getBizDate());
                result.setLotNumber(coll.get(i).getLot());
                if (coll.get(i).getManuBillID() != null) {
                    order = (ManufactureOrderInfo)orders.get(coll.get(i).getManuBillID());
                    if (order == null) continue;
                    result.setManuOrder(order);
                    result.setProject(order.getProject() != null ? order.getProject().getNumber() : null);
                    result.setTrcknumber(order.getTrackNumber() != null ? order.getTrackNumber().getNumber() : null);
                }
                result.setMaterial(coll.get(i).getMaterial());
                result.setQty(coll.get(i).getQty());
                result.setId(System.currentTimeMillis() + "" + i);
                result.setBaseQty(coll.get(i).getBaseQty());
                result.setUnit(coll.get(i).getUnit());
                result.setBsUnit(coll.get(i).getBaseUnit());
                resultList.add(result);
            }
        }
        return resultList;
    }

    private FilterInfo buildCommonFilter(BackFlushFilterInfo backFlushFilter, Context ctx) throws BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.number", (Object)backFlushFilter.getStorageUnitNum().getNumber()));
        if (backFlushFilter.getAdminOrgUnitNum() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("adminDepartMent.number", (Object)backFlushFilter.getAdminOrgUnitNum().getNumber()));
        }
        if (backFlushFilter.getMaterialNumFrom() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("productNumber.number", (Object)backFlushFilter.getMaterialNumFrom().getNumber(), CompareType.GREATER_EQUALS));
        }
        if (backFlushFilter.getMaterialNumTo() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("productNumber.number", (Object)backFlushFilter.getMaterialNumTo().getNumber(), CompareType.LESS_EQUALS));
        }
        if (backFlushFilter.getCompletionFrom() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)backFlushFilter.getCompletionFrom().getNumber(), CompareType.GREATER_EQUALS));
        }
        if (backFlushFilter.getCompletionTo() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)backFlushFilter.getCompletionTo().getNumber(), CompareType.LESS_EQUALS));
        }
        if (backFlushFilter.getBizDateFrom() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("bizDate", (Object)backFlushFilter.getBizDateFrom(), CompareType.GREATER_EQUALS));
        }
        if (backFlushFilter.getBizDateTo() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("bizDate", (Object)backFlushFilter.getBizDateTo(), CompareType.LESS_EQUALS));
        }
        return filterInfo;
    }

    private FilterInfo buildCommonFilterForRecBill(BackFlushFilterInfo backFlushFilter, Context ctx) throws BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.storageOrgUnit.number", (Object)backFlushFilter.getStorageUnitNum().getNumber()));
        if (backFlushFilter.getAdminOrgUnitNum() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("adminOrgUnit.number", (Object)backFlushFilter.getAdminOrgUnitNum().getNumber()));
        }
        if (backFlushFilter.getMaterialNumFrom() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("material.number", (Object)backFlushFilter.getMaterialNumFrom().getNumber(), CompareType.GREATER_EQUALS));
        }
        if (backFlushFilter.getMaterialNumTo() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("material.number", (Object)backFlushFilter.getMaterialNumTo().getNumber(), CompareType.LESS_EQUALS));
        }
        if (backFlushFilter.getBizDateFrom() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("parent.bizDate", (Object)backFlushFilter.getBizDateFrom(), CompareType.GREATER_EQUALS));
        }
        if (backFlushFilter.getBizDateTo() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("parent.bizDate", (Object)backFlushFilter.getBizDateTo(), CompareType.LESS_EQUALS));
        }
        if (backFlushFilter.getRecBillFrom() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("parent.number", (Object)backFlushFilter.getRecBillFrom().getNumber(), CompareType.GREATER_EQUALS));
        }
        if (backFlushFilter.getRecBillTo() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("parent.number", (Object)backFlushFilter.getRecBillTo().getNumber(), CompareType.LESS_EQUALS));
        }
        return filterInfo;
    }

    protected int getOperationNo(Context ctx, String entryID, boolean flag) throws BOSException {
        int operationNo = 0;
        StringBuffer strBuf = new StringBuffer();
        if (flag) {
            strBuf.append("select f.FOPERATIONNO as operactionNo from T_MM_MFTORDERTECHNICS f where  f.fid='");
        } else {
            strBuf.append("select f.foperationNumber as operactionNo from T_MM_DisTaskDispatchEntry f where  f.fid='");
        }
        strBuf.append(entryID);
        strBuf.append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strBuf.toString());
        if (rs != null && rs.size() > 0) {
            try {
                while (rs.next()) {
                    operationNo = rs.getInt("operactionNo");
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return operationNo;
    }

    @Override
    protected List _getInteractionData(Context ctx, String billId, BackFlushSourceTypeEnum sourceType, BackFrushStatusEnum backFlushStatus) throws BOSException, EASBizException {
        List result = new ArrayList();
        if (sourceType == BackFlushSourceTypeEnum.BACKFLUSH_COMPLETION) {
            result = this.getBackFlushDataForCompletion(ctx, billId, sourceType, backFlushStatus);
        } else if (sourceType == BackFlushSourceTypeEnum.BACKFLUSH_RECBILL) {
            result = this.getBackFlushDataForRecBill(ctx, billId, sourceType, backFlushStatus);
        }
        return result;
    }

    private List getBackFlushDataForCompletion(Context ctx, String billId, BackFlushSourceTypeEnum sourceType, BackFrushStatusEnum backFlushStatus) throws EASBizException, BOSException {
        ICompletionReport report;
        List<InteractionBackFlushInfo> resultList = new ArrayList();
        if (backFlushStatus == BackFrushStatusEnum.FAILING || backFlushStatus == BackFrushStatusEnum.PART_SUCCESS) {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("sourcebillID", (Object)billId, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("sourceBillType", (Object)new Integer(0)));
            resultList = this.getInteractionDataInTable(ctx, filterInfo);
        } else if (backFlushStatus == BackFrushStatusEnum.NOT_BACKFRUSH && (report = CompletionReportFactory.getLocalInstance(ctx)).exists((IObjectPK)new ObjectUuidPK(billId))) {
            CompletionReportInfo reportinfo = (CompletionReportInfo)report.getValue((IObjectPK)new ObjectUuidPK(billId));
            String orderID = reportinfo.getDmesOrder().getId().toString();
            IManufactureOrder order = ManufactureOrderFactory.getLocalInstance((Context)ctx);
            ManufactureOrderInfo orderinfo = (ManufactureOrderInfo)order.getValue((IObjectPK)new ObjectUuidPK(orderID));
            int fromOp = 0;
            int theOp = 0;
            theOp = reportinfo.getSourceBillType1() == SourceBillTypeEnum.PRODUCTORDER ? this.getOperationNo(ctx, reportinfo.getProcess().getId().toString(), true) : this.getOperationNo(ctx, reportinfo.getDispWorkProcess().getId().toString(), false);
            int lastOp = theOp;
            if (theOp == orderinfo.getFirstOperNo()) {
                fromOp = orderinfo.getFirstOperNo();
            }
            for (int j = 0; j <= orderinfo.getTechnics().size() - 1; ++j) {
                ManufactureOrderTechnicsInfo techEntry = orderinfo.getTechnics().get(j);
                if (!techEntry.isIsReportPoint()) continue;
                if (techEntry.getOperationNo() == theOp) {
                    lastOp = theOp;
                    break;
                }
                if (techEntry.getOperationNo() >= lastOp || techEntry.getOperationNo() <= fromOp) continue;
                fromOp = techEntry.getOperationNo();
            }
            boolean isBackFlushQtyMore = orderinfo.getTransactionType() == null ? false : orderinfo.getTransactionType().isIsBackFlushQtyMore();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("parent.id", (Object)orderID, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("isBackflush", (Object)new Boolean(true), CompareType.EQUALS));
            CoreBaseCollection coll = this.getManufactureStockEntrys(ctx, filterInfo);
            if (coll != null && coll.size() > 0) {
                for (int i = 0; i < coll.size(); ++i) {
                    InteractionBackFlushInfo backinfo = new InteractionBackFlushInfo();
                    ManufactureOrderStockInfo info = (ManufactureOrderStockInfo)coll.get(i);
                    if (!(info.getOperationNo() > fromOp && info.getOperationNo() <= lastOp || info.getOperationNo() == orderinfo.getFirstOperNo() && fromOp == lastOp)) continue;
                    SCMEntryDataVO dataVO = InteractionBackflushFacadeControllerBean.getMaterialMmu(ctx, info);
                    int prec = InteractionBackflushFacadeControllerBean.getPrec(dataVO, info.getMaterial(), info.getUnit());
                    BigDecimal subQty = this.getTechinisQty(ctx, orderID, info.getOperationNo());
                    BigDecimal leaveIssueQty = info.getPlannedQty().subtract(info.getActIssueQty());
                    BigDecimal backFlushQty = info.getPlannedQty().multiply(reportinfo.getReportQty()).divide(subQty, prec, 0);
                    if (backFlushQty.compareTo(new BigDecimal(0)) == 0) continue;
                    if (!isBackFlushQtyMore && leaveIssueQty.compareTo(backFlushQty) < 0) {
                        backFlushQty = leaveIssueQty;
                    }
                    backinfo.setBackFlushQty(backFlushQty);
                    BigDecimal baseBackFlushQty = SCMUtils.getExchangePrecisionQtyForServer((Context)ctx, (String)info.getMaterial().getId().toString(), (MeasureUnitInfo)info.getUnit(), (MeasureUnitInfo)info.getBaseUnit(), (BigDecimal)backFlushQty);
                    backinfo.setBaseBackFlushQty(baseBackFlushQty);
                    backinfo.setUnit(info.getUnit());
                    backinfo.setBaseUnit(info.getBaseUnit());
                    backinfo.setMaterial(info.getMaterial());
                    backinfo.setWarehouse(info.getWarehouse());
                    backinfo.setLocation(info.getLocation());
                    backinfo.setSourcebillID(reportinfo.getId().toString());
                    backinfo.setSourceBillType(BackFlushSourceTypeEnum.BACKFLUSH_COMPLETION);
                    backinfo.setStorageorgunitID(reportinfo.getPStorageOrgUnit().getId().toString());
                    backinfo.setId(BOSUuid.create((BOSObjectType)backinfo.getBOSType()));
                    backinfo.setOrderNum(info.getParent().getNumber());
                    backinfo.setOrderID(info.getParent().getId().toString());
                    backinfo.setOrderEntryID(info.getId().toString());
                    backinfo.setSourceBillNo(reportinfo.getNumber());
                    ProjectInfo project = (ProjectInfo)StoreCommonUtil.getProjectNumberAndTrackNumber((Context)ctx, (ProjectInfo)info.getParent().getProject(), (TrackNumberInfo)info.getParent().getTrackNumber(), (String)info.getParent().getStorageOrgUnit().getId().toString(), (String)info.getMaterial().getId().toString(), (int)1)[0];
                    TrackNumberInfo trackNumber = (TrackNumberInfo)StoreCommonUtil.getProjectNumberAndTrackNumber((Context)ctx, (ProjectInfo)info.getParent().getProject(), (TrackNumberInfo)info.getParent().getTrackNumber(), (String)info.getParent().getStorageOrgUnit().getId().toString(), (String)info.getMaterial().getId().toString(), (int)1)[1];
                    backinfo.setProject(project);
                    backinfo.setTrackNumber(trackNumber);
                    resultList.add(backinfo);
                }
            }
        }
        return resultList;
    }

    protected BigDecimal getTechinisQty(Context ctx, String orderID, int OpNo) throws BOSException {
        BigDecimal result = new BigDecimal(0);
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("select t.Fqty as qty,t.FtotalSplitQty  as totalsplitqty from T_MM_MFTORDERTECHNICS t where t.FPARENTID ='");
        strBuf.append(orderID);
        strBuf.append("'");
        strBuf.append(" and t.FOPERATIONNO=" + OpNo);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strBuf.toString());
        if (rs != null && rs.size() > 0) {
            try {
                while (rs.next()) {
                    BigDecimal qty = rs.getBigDecimal("qty");
                    BigDecimal totalsplitqty = rs.getBigDecimal("totalsplitqty");
                    result = qty.subtract(totalsplitqty);
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return result;
    }

    private static SCMEntryDataVO getMaterialMmu(Context ctx, ManufactureOrderStockInfo stockinfo) throws EASBizException, BOSException {
        ArrayList<MaterialInfo> materialLst = new ArrayList<MaterialInfo>();
        ArrayList<MeasureUnitInfo> unitLst = new ArrayList<MeasureUnitInfo>();
        ArrayList<MeasureUnitInfo> baseunitLst = new ArrayList<MeasureUnitInfo>();
        materialLst.add(stockinfo.getMaterial());
        unitLst.add(stockinfo.getUnit());
        baseunitLst.add(stockinfo.getBaseUnit());
        SCMEntryDataVO vo = new SCMEntryDataVO();
        vo.setMaterialInfos(materialLst.toArray(new MaterialInfo[materialLst.size()]));
        vo.setBaseMeasureUnitInfos(baseunitLst.toArray(new MeasureUnitInfo[baseunitLst.size()]));
        vo.setMeasureUnitInfos(unitLst.toArray(new MeasureUnitInfo[unitLst.size()]));
        return SCMGroupFacadeFactory.getLocalInstance((Context)ctx).loadMmuPrecision(vo);
    }

    private static int getPrec(SCMEntryDataVO vo, MaterialInfo material, MeasureUnitInfo unitInfo) {
        int prec = 4;
        if (material != null && unitInfo != null) {
            String key = material.getId().toString() + unitInfo.getId().toString();
            if (vo != null && vo.getMmuPrecisions() != null && vo.getMmuPrecisions().get(key) != null) {
                prec = (Integer)vo.getMmuPrecisions().get(key);
            }
        }
        return prec;
    }

    private List getBackFlushDataForRecBill(Context ctx, String billId, BackFlushSourceTypeEnum sourceType, BackFrushStatusEnum backFlushStatus) throws EASBizException, BOSException {
        List<InteractionBackFlushInfo> resultList = new ArrayList();
        ManufactureRecBillInfo manuInfo = ManufactureRecBillFactory.getLocalInstance((Context)ctx).getManufactureRecBillInfo((IObjectPK)new ObjectUuidPK(billId));
        BackFlushSucceedEnum succeed = manuInfo.getIsBackFlushSucceed();
        backFlushStatus = BackFrushStatusEnum.getEnum(succeed.getValue());
        if (backFlushStatus == BackFrushStatusEnum.FAILING || backFlushStatus == BackFrushStatusEnum.PART_SUCCESS) {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("sourcebillID", (Object)billId, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("sourceBillType", (Object)new Integer(1), CompareType.EQUALS));
            resultList = this.getInteractionDataInTable(ctx, filterInfo);
        } else if (backFlushStatus == BackFrushStatusEnum.NOT_BACKFRUSH) {
            IManufactureRecBillEntry recBillEntry = ManufactureRecBillEntryFactory.getLocalInstance((Context)ctx);
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("parent.id", (Object)billId, CompareType.EQUALS));
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("parent.*"));
            sic.add(new SelectorItemInfo("parent.storageOrgUnit.id"));
            sic.add(new SelectorItemInfo("parent.storageOrgUnit.name"));
            sic.add(new SelectorItemInfo("parent.storageOrgUnit.number"));
            viewInfo.setFilter(filterInfo);
            viewInfo.setSelector(sic);
            CoreBaseCollection coll = recBillEntry.getCollection(viewInfo);
            HashMap<String, InteractionBackFlushInfo> map = new HashMap<String, InteractionBackFlushInfo>();
            if (coll != null && coll.size() > 0) {
                for (int i = 0; i < coll.size(); ++i) {
                    ManufactureRecBillEntryInfo recEntryInfo = (ManufactureRecBillEntryInfo)coll.get(i);
                    if (!this.isOrderMaterial(ctx, recEntryInfo)) continue;
                    boolean isBackFlushQtyMore = this.isBackFlushQtyMore(ctx, recEntryInfo.getManuBillID());
                    FilterInfo orderfilter = new FilterInfo();
                    orderfilter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)recEntryInfo.getManuBillID(), CompareType.EQUALS));
                    orderfilter.getFilterItems().add(new FilterItemInfo("isBackflush", (Object)new Boolean(true), CompareType.EQUALS));
                    CoreBaseCollection orderStockEntry = this.getManufactureStockEntrys(ctx, orderfilter);
                    if (orderStockEntry == null || orderStockEntry.size() <= 0) continue;
                    for (int z = 0; z < orderStockEntry.size(); ++z) {
                        InteractionBackFlushInfo backinfo;
                        ManufactureOrderStockInfo info = (ManufactureOrderStockInfo)orderStockEntry.get(z);
                        if (info.getIssueMode().getValue() == 11040) continue;
                        SCMEntryDataVO dataVO = InteractionBackflushFacadeControllerBean.getMaterialMmu(ctx, info);
                        int prec = InteractionBackflushFacadeControllerBean.getPrec(dataVO, info.getMaterial(), info.getUnit());
                        BigDecimal orderQty = info.getParent().getQty().subtract(info.getParent().getTotalSplitQty());
                        BigDecimal backFlushQty = info.getPlannedQty().multiply(recEntryInfo.getQty()).divide(orderQty, prec, 0).setScale(prec, 0);
                        BigDecimal baseBackFlushQty = SCMUtils.getExchangePrecisionQtyForServer((Context)ctx, (String)info.getMaterial().getId().toString(), (MeasureUnitInfo)info.getUnit(), (MeasureUnitInfo)info.getBaseUnit(), (BigDecimal)backFlushQty);
                        BigDecimal leaveIssueQty = info.getPlannedQty().subtract(info.getActIssueQty());
                        BigDecimal baseleaveIssueQty = info.getPlannedBaseQty().subtract(info.getActIssueBaseQty());
                        String mapKey = info.getParent().getId().toString() + info.getId().toString() + info.getMaterial().getId().toString();
                        if (!isBackFlushQtyMore) {
                            if (map.containsKey(mapKey)) {
                                backinfo = (InteractionBackFlushInfo)map.get(mapKey);
                                leaveIssueQty = leaveIssueQty.subtract(backinfo.getBackFlushQty());
                                baseleaveIssueQty = baseleaveIssueQty.subtract(backinfo.getBaseBackFlushQty());
                            }
                            if (leaveIssueQty.compareTo(backFlushQty) < 0) {
                                backFlushQty = leaveIssueQty;
                                baseBackFlushQty = baseleaveIssueQty;
                            }
                        }
                        if (backFlushQty.compareTo(new BigDecimal(0)) == 0) continue;
                        if (!map.containsKey(mapKey)) {
                            backinfo = new InteractionBackFlushInfo();
                            backinfo.setBackFlushQty(backFlushQty);
                            backinfo.setBaseBackFlushQty(baseBackFlushQty);
                            backinfo.setUnit(info.getUnit());
                            backinfo.setBaseUnit(info.getBaseUnit());
                            backinfo.setMaterial(info.getMaterial());
                            backinfo.setWarehouse(info.getWarehouse());
                            backinfo.setLocation(info.getLocation());
                            backinfo.setSourcebillID(billId);
                            backinfo.setSourceBillType(BackFlushSourceTypeEnum.BACKFLUSH_RECBILL);
                            backinfo.setOrderEntryID(info.getId().toString());
                            backinfo.setOrderID(info.getParent().getId().toString());
                            backinfo.setStorageorgunitID(recEntryInfo.getParent().getStorageOrgUnit().getId().toString());
                            backinfo.setId(BOSUuid.create((BOSObjectType)backinfo.getBOSType()));
                            backinfo.setOrderNum(info.getParent().getNumber());
                            ProjectInfo project = (ProjectInfo)StoreCommonUtil.getProjectNumberAndTrackNumber((Context)ctx, (ProjectInfo)info.getParent().getProject(), (TrackNumberInfo)info.getParent().getTrackNumber(), (String)info.getParent().getStorageOrgUnit().getId().toString(), (String)info.getMaterial().getId().toString(), (int)1)[0];
                            TrackNumberInfo trackNumber = (TrackNumberInfo)StoreCommonUtil.getProjectNumberAndTrackNumber((Context)ctx, (ProjectInfo)info.getParent().getProject(), (TrackNumberInfo)info.getParent().getTrackNumber(), (String)info.getParent().getStorageOrgUnit().getId().toString(), (String)info.getMaterial().getId().toString(), (int)1)[1];
                            backinfo.setProject(project);
                            backinfo.setTrackNumber(trackNumber);
                            resultList.add(backinfo);
                            map.put(mapKey, backinfo);
                            continue;
                        }
                        backinfo = (InteractionBackFlushInfo)map.get(mapKey);
                        backinfo.setBackFlushQty(backinfo.getBackFlushQty().add(backFlushQty));
                        backinfo.setBaseBackFlushQty(backinfo.getBaseBackFlushQty().add(baseBackFlushQty));
                    }
                }
            }
        }
        return resultList;
    }

    private boolean isBackFlushQtyMore(Context ctx, String orderID) throws BOSException, EASBizException {
        boolean rtn = false;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("transactionType.isBackFlushQtyMore"));
        IManufactureOrder order = ManufactureOrderFactory.getLocalInstance((Context)ctx);
        ManufactureOrderInfo orderinfo = (ManufactureOrderInfo)order.getValue((IObjectPK)new ObjectUuidPK(orderID), sic);
        if (orderinfo != null && orderinfo.getTransactionType() != null) {
            rtn = orderinfo.getTransactionType().isIsBackFlushQtyMore();
        }
        return rtn;
    }

    private boolean isOrderMaterial(Context ctx, ManufactureRecBillEntryInfo recEntryInfo) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("material.id"));
        ManufactureOrderInfo manufactureOrderInfo = ManufactureOrderFactory.getLocalInstance((Context)ctx).getManufactureOrderInfo((IObjectPK)new ObjectUuidPK(recEntryInfo.getManuBillID()), sic);
        return recEntryInfo.getMaterial().getId().toString().equalsIgnoreCase(manufactureOrderInfo.getMaterial().getId().toString());
    }

    private CoreBaseCollection getManufactureStockEntrys(Context ctx, FilterInfo filter) throws BOSException {
        IManufactureOrderStock stockInterface = ManufactureOrderStockFactory.getLocalInstance((Context)ctx);
        EntityViewInfo orderViewInfo = new EntityViewInfo();
        orderViewInfo.setFilter(filter);
        SelectorItemCollection orderSic = new SelectorItemCollection();
        orderSic.add(new SelectorItemInfo("*"));
        orderSic.add(new SelectorItemInfo("parent.*"));
        orderSic.add(new SelectorItemInfo("unit.id"));
        orderSic.add(new SelectorItemInfo("unit.name"));
        orderSic.add(new SelectorItemInfo("unit.number"));
        orderSic.add(new SelectorItemInfo("baseUnit.id"));
        orderSic.add(new SelectorItemInfo("baseUnit.name"));
        orderSic.add(new SelectorItemInfo("baseUnit.number"));
        orderSic.add(new SelectorItemInfo("material.id"));
        orderSic.add(new SelectorItemInfo("material.name"));
        orderSic.add(new SelectorItemInfo("material.number"));
        orderSic.add(new SelectorItemInfo("material.model"));
        orderSic.add(new SelectorItemInfo("warehouse.id"));
        orderSic.add(new SelectorItemInfo("warehouse.name"));
        orderSic.add(new SelectorItemInfo("warehouse.number"));
        orderSic.add(new SelectorItemInfo("location.id"));
        orderSic.add(new SelectorItemInfo("location.name"));
        orderSic.add(new SelectorItemInfo("location.number"));
        orderSic.add(new SelectorItemInfo("parent.trackNumber.*"));
        orderSic.add(new SelectorItemInfo("parent.project.*"));
        orderViewInfo.setSelector(orderSic);
        CoreBaseCollection coll = stockInterface.getCollection(orderViewInfo);
        return coll;
    }

    private List getInteractionDataInTable(Context ctx, FilterInfo filterInfo) throws BOSException {
        ArrayList<InteractionBackFlushInfo> resultList = new ArrayList<InteractionBackFlushInfo>();
        IInteractionBackFlush inter = InteractionBackFlushFactory.getLocalInstance(ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("orderID"));
        sic.add(new SelectorItemInfo("orderEntryID"));
        sic.add(new SelectorItemInfo("orderNum"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("sourcebillID"));
        sic.add(new SelectorItemInfo("sourceBillType"));
        sic.add(new SelectorItemInfo("backFlushQty"));
        sic.add(new SelectorItemInfo("baseBackFlushQty"));
        sic.add(new SelectorItemInfo("baseBackFlushQty"));
        sic.add(new SelectorItemInfo("unit.id"));
        sic.add(new SelectorItemInfo("unit.name"));
        sic.add(new SelectorItemInfo("unit.number"));
        sic.add(new SelectorItemInfo("baseUnit.id"));
        sic.add(new SelectorItemInfo("baseUnit.name"));
        sic.add(new SelectorItemInfo("baseUnit.number"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("material.name"));
        sic.add(new SelectorItemInfo("material.number"));
        sic.add(new SelectorItemInfo("material.model"));
        sic.add(new SelectorItemInfo("warehouse.id"));
        sic.add(new SelectorItemInfo("warehouse.name"));
        sic.add(new SelectorItemInfo("warehouse.number"));
        sic.add(new SelectorItemInfo("location.id"));
        sic.add(new SelectorItemInfo("location.name"));
        sic.add(new SelectorItemInfo("location.number"));
        sic.add(new SelectorItemInfo("storageorgunitID"));
        sic.add(new SelectorItemInfo("project.id"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("trackNumber.id"));
        sic.add(new SelectorItemInfo("trackNumber.number"));
        sic.add(new SelectorItemInfo("trackNumber.name"));
        viewInfo.setSelector(sic);
        InteractionBackFlushCollection coll = inter.getInteractionBackFlushCollection(viewInfo);
        if (coll != null && coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                resultList.add(coll.get(i));
            }
        }
        return resultList;
    }

    public CalculateLotValue buildValue(Context ctx, InventoryCollection inventoryCollection, boolean isUpdateByBaseUnit, String unitID, BigDecimal qty, boolean isNagetive) throws EASBizException, BOSException {
        CalculateLotValue value = new CalculateLotValue();
        value.setLineValues(new ArrayList());
        BigDecimal totalQty = new BigDecimal("0.00");
        Iterator iter = inventoryCollection.iterator();
        if (qty != null) {
            while (iter.hasNext()) {
                String stockUnitid;
                InventoryInfo inventory = (InventoryInfo)iter.next();
                CalculateLotLineValue lineValue = new CalculateLotLineValue();
                BigDecimal inventoryQty = inventory.getCurStoreQty();
                String materialID = inventory.getMaterial() != null ? inventory.getMaterial().getId().toString() : null;
                String string = stockUnitid = inventory.getUnit() != null ? inventory.getUnit().getId().toString() : null;
                if (isUpdateByBaseUnit) {
                    inventoryQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)materialID, (String)stockUnitid, (BigDecimal)inventoryQty, (String)unitID);
                }
                lineValue.setCurentStockQty(inventoryQty);
                BigDecimal thisQty = new BigDecimal("0.00");
                if (!isNagetive) {
                    if (inventoryQty.compareTo(new BigDecimal(0)) <= 0) continue;
                    thisQty = totalQty.add(inventoryQty).compareTo(qty) > 0 ? qty.subtract(totalQty) : inventoryQty;
                } else {
                    thisQty = inventoryQty.compareTo(new BigDecimal(0)) <= 0 ? new BigDecimal("0.00") : (totalQty.add(inventoryQty).compareTo(qty) > 0 ? qty.subtract(totalQty) : inventoryQty);
                }
                lineValue.setQty(thisQty);
                lineValue.setLot(inventory.getLot());
                lineValue.setMfg((Date)inventory.get("mfg"));
                lineValue.setExp((Date)inventory.get("exp"));
                if (inventory.getWarehouse() != null) {
                    lineValue.setWarehouseID(inventory.getWarehouse().getId().toString());
                }
                if (inventory.getLocation() != null) {
                    lineValue.setLocationID(inventory.getLocation().getId().toString());
                }
                if (inventory.getSupplier() != null) {
                    lineValue.setSupplierID(inventory.getSupplier().getId().toString());
                }
                if (inventory.getCustomer() != null) {
                    lineValue.setCustomerID(inventory.getCustomer().getId().toString());
                }
                if (inventory.getProject() != null) {
                    lineValue.setProjectID(inventory.getProject().getId().toString());
                }
                if (inventory.getTrackNumber() != null) {
                    lineValue.setTrackNumberID(inventory.getTrackNumber().getId().toString());
                }
                value.getLineValues().add(lineValue);
                totalQty = totalQty.add(thisQty);
            }
        }
        return value;
    }

    @Override
    protected Map _getInventoryCollection(Context ctx, CalculateParam param) throws BOSException, EASBizException {
        boolean isUpdateByBaseUnit = param.isUpdateByBaseUnit();
        TransactionTypeInfo tti = param.getTti();
        String souID = param.getSouID();
        String billTypeID = param.getBillTypeID();
        String[] materialIDs = param.getMaterialIDs();
        String[] unitIDs = param.getUnitIDs();
        String[] baseUnitIDs = param.getBaseUnitIDs();
        BigDecimal[] qtys = param.getQtys();
        String[] asstAttrIDs = param.getAsstAttrIDs();
        String[] warehouseIDs = param.getWarehouseIDs();
        String[] locationIDs = param.getLocationIDs();
        String[] supplierIDs = param.getSupplierIDs();
        String[] customerIDs = param.getCustomerIDs();
        String[] storeTypeIDs = param.getStoreTypeIDs();
        String[] storeStatusIDs = param.getStoreStatusIDs();
        String[] projectIDs = param.getProjectIDs();
        String[] trackNumberIDs = param.getTrackNumberIDs();
        HashMap<String, CalculateLotValue> returnMap = new HashMap<String, CalculateLotValue>();
        for (int i = 0; i < materialIDs.length; ++i) {
            MaterialInventoryInfo materialInv = MaterialInventoryFactory.getLocalInstance((Context)ctx).getInventoryInfo(materialIDs[i], souID);
            IssuePriorityEnum issuePriority = materialInv.getIssuePriorityMode();
            boolean isNegative = materialInv.isIsNegative();
            InventoryCollection inventoryCollection = null;
            inventoryCollection = isUpdateByBaseUnit ? this.getInventoryCollectionForCalculateLot(ctx, billTypeID, souID, tti, isUpdateByBaseUnit, materialIDs[i], asstAttrIDs[i], baseUnitIDs[i], warehouseIDs[i], locationIDs[i], storeTypeIDs[i], storeStatusIDs[i], supplierIDs[i], customerIDs[i], projectIDs[i], trackNumberIDs[i], issuePriority, isNegative) : this.getInventoryCollectionForCalculateLot(ctx, billTypeID, souID, tti, isUpdateByBaseUnit, materialIDs[i], asstAttrIDs[i], unitIDs[i], warehouseIDs[i], locationIDs[i], storeTypeIDs[i], storeStatusIDs[i], supplierIDs[i], customerIDs[i], projectIDs[i], trackNumberIDs[i], issuePriority, isNegative);
            if (inventoryCollection == null) {
                inventoryCollection = new InventoryCollection();
            }
            String key = param.buildKey(i);
            CalculateLotValue value = this.buildValue(ctx, inventoryCollection, isUpdateByBaseUnit, unitIDs[i], qtys[i], isNegative);
            returnMap.put(key, value);
        }
        return returnMap;
    }

    public InventoryCollection getInventoryCollectionForCalculateLot(Context ctx, String billTypeID, String souID, TransactionTypeInfo tti, boolean isUpdateByBaseUnit, String materialID, String asstattrID, String unitID, String warehouseID, String locationID, String storeTypeID, String storeStatusID, String supplierID, String customerID, String projectID, String trackNumberID, IssuePriorityEnum issuePriority, boolean isNegative) throws BOSException {
        InventoryCollection inventoryCollection;
        Connection conn = null;
        PreparedStatement preStmt = null;
        ResultSet rs = null;
        InventoryCollection coll = new InventoryCollection();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            preStmt = conn.prepareStatement(InteractionBackflushFacadeControllerBean.getInventoryConllectionSQL(billTypeID, souID, tti, isUpdateByBaseUnit, materialID, asstattrID, unitID, warehouseID, locationID, storeTypeID, storeStatusID, supplierID, customerID, projectID, trackNumberID, issuePriority, isNegative));
            rs = preStmt.executeQuery();
            this.addRS2Collection(coll, rs);
            inventoryCollection = coll;
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, preStmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)preStmt, (Connection)conn);
        return inventoryCollection;
    }

    @Override
    protected boolean _interactionBackFlushForComRpt(Context ctx, InteractionBackFlushInfo[] infos, BillTypeInfo billType) throws BOSException, EASBizException {
        if (infos == null || infos.length == 0) {
            return false;
        }
        String reportID = infos[0].getSourcebillID();
        ICompletionReport report = CompletionReportFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        CompletionReportInfo billinfo = (CompletionReportInfo)report.getValue((IObjectPK)new ObjectUuidPK(reportID));
        IObjectPK logPk = LogUtil.beginLog((Context)ctx, (String)"_interactionBackFlushForComRpt", (BOSObjectType)billinfo.getBOSType(), (IObjectPK)new ObjectUuidPK(reportID), (String)billinfo.getNumber(), (String)"mm_sfc_interactionbackflush", (String)billinfo.getPStorageOrgUnit().getId().toString());
        ManufactureOrderInfo cbc = InteractionBackflushFacadeControllerBean.getOperationBackFlushOrder(ctx, infos[0]);
        CoreBillBaseCollection orderCollection = new CoreBillBaseCollection();
        orderCollection.add((CoreBillBaseInfo)cbc);
        CoreBillBaseCollection moCol = new CoreBillBaseCollection();
        ManufactureOrderInfo moInfo = null;
        String noNumberRuleOrgs = null;
        moInfo = InteractionBackflushFacadeControllerBean.getManufactureOrder(orderCollection, infos[0].getOrderID());
        if (moInfo == null) {
            // empty if block
        }
        moInfo.setSourceBillId(infos[0].getSourcebillID());
        moInfo.setSourceBillType(billType);
        moInfo.setSrcBillNum(infos[0].getSourceBillNo());
        ManufactureOrderStockInfo stockInfo2 = null;
        ManufactureOrderStockCollection cloneCollection = new ManufactureOrderStockCollection();
        ArrayList<String> orderStockIdList = new ArrayList<String>();
        ArrayList<String> materialIds = new ArrayList<String>();
        ArrayList<String> unitids = new ArrayList<String>();
        Map converMap = new HashMap();
        for (ManufactureOrderStockInfo stockInfo2 : moInfo.getStocks()) {
            materialIds.add(stockInfo2.getMaterial().getId().toString());
            unitids.add(stockInfo2.getUnit().getId().toString());
        }
        if (materialIds.size() > 0) {
            String[] materialArrays = materialIds.toArray(new String[0]);
            String[] unitIdarrays = unitids.toArray(new String[0]);
            IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
            converMap = multiUnit.getConvRatesByMaterial(materialArrays, unitIdarrays);
        }
        for (ManufactureOrderStockInfo stockInfo2 : moInfo.getStocks()) {
            for (int i = 0; i < infos.length; ++i) {
                if (!stockInfo2.getId().toString().equals(infos[i].getOrderEntryID())) continue;
                ManufactureOrderStockInfo cloneStock = InteractionBackflushFacadeControllerBean.getCopyStock(stockInfo2);
                BOSUuid oldID = stockInfo2.getId();
                cloneStock.setId(BOSUuid.create((BOSObjectType)stockInfo2.getBOSType()));
                cloneStock.setUnIssueQty(infos[i].getThistimeQty());
                String converKey = stockInfo2.getMaterial().getId().toString() + stockInfo2.getUnit().getId().toString();
                if (converMap.containsKey(converKey)) {
                    BigDecimal rate = (BigDecimal)converMap.get(converKey);
                    BigDecimal baseThisQty = cloneStock.getUnIssueQty().multiply(rate);
                    cloneStock.setUnIssueBaseQty(baseThisQty);
                }
                cloneStock.setWarehouse(infos[i].getWarehouse());
                cloneStock.setLocation(infos[i].getLocation());
                cloneStock.setLot(infos[i].getLot());
                cloneStock.setMfg(infos[i].getMfg());
                cloneStock.setExg(infos[i].getExg());
                cloneCollection.add(cloneStock);
                cloneStock.setId(oldID);
                orderStockIdList.add(infos[i].getOrderEntryID());
            }
        }
        moInfo.getStocks().clear();
        for (ManufactureOrderStockInfo cloneStock : cloneCollection) {
            BOSUuid oldID = cloneStock.getId();
            cloneStock.setId(BOSUuid.create((BOSObjectType)stockInfo2.getBOSType()));
            moInfo.getStocks().add(cloneStock);
            cloneStock.setId(oldID);
        }
        if (moInfo.getStocks().size() > 0) {
            BOSUuid oldID = moInfo.getId();
            moInfo.setId(BOSUuid.create((BOSObjectType)moInfo.getBOSType()));
            moCol.add((CoreBillBaseInfo)moInfo);
            moInfo.setId(oldID);
        }
        try {
            InteractionBackflushFacadeControllerBean.generateManufactureRecBill(ctx, (CoreBillBaseInfo)billinfo, moCol, noNumberRuleOrgs);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        Object[] entryIDArray = orderStockIdList.toArray(new String[0]);
        String idStr = SQLUtil.arrayToString((Object[])entryIDArray);
        String deleteSQl = "delete from T_MM_INTERACTIONBACKFLUSH where FSOURCEBILLID='" + infos[0].getSourcebillID() + "' and FSOURCEBILLTYPE='" + 0 + "' and  FOrderEntryID in( " + idStr + ") ";
        DbUtil.execute((Context)ctx, (String)deleteSQl);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean _inStockBackFlush(Context ctx, String recBillID, Map recBillMap, BillTypeInfo billType) throws BOSException, EASBizException {
        IMutexServiceControl mutexService = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        ArrayList<String> mutexRecIds = new ArrayList<String>();
        ArrayList<String> mutexOrderIds = new ArrayList<String>();
        ManufactureRecBillInfo billinfo = null;
        CoreBillBaseCollection moCol = new CoreBillBaseCollection();
        String noNumberRuleOrgs = null;
        ArrayList<String> orderStockIdList = new ArrayList<String>();
        IObjectPK logPk = null;
        try {
            if (mutexService.requestObjIDForUpdate(recBillID)) {
                mutexRecIds.add(recBillID);
                IManufactureRecBill recBill = ManufactureRecBillFactory.getLocalInstance((Context)ctx);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("name"));
                sic.add(new SelectorItemInfo("number"));
                billinfo = (ManufactureRecBillInfo)recBill.getValue((IObjectPK)new ObjectUuidPK(recBillID));
                logPk = LogUtil.beginLog((Context)ctx, (String)"_inStockBackFlush", (BOSObjectType)billinfo.getBOSType(), (IObjectPK)new ObjectUuidPK(recBillID), (String)billinfo.getNumber(), (String)"mm_sfc_interactionmanufacturerecbill", (String)billinfo.getStorageOrgUnit().getId().toString());
                CoreBillBaseCollection cbc = null;
                Set<Object> orderIDSet = new HashSet();
                BackFlushSucceedEnum succeed = billinfo.getIsBackFlushSucceed();
                BackFrushStatusEnum backFlushStatus = BackFrushStatusEnum.getEnum(succeed.getValue());
                if (backFlushStatus != BackFrushStatusEnum.SUCCESS) {
                    orderIDSet = recBillMap.keySet();
                    cbc = InteractionBackflushFacadeControllerBean.getInStockBackFlushOrders(ctx, orderIDSet);
                }
                ManufactureOrderInfo moInfo = null;
                Object var20_23 = null;
                for (String string : orderIDSet) {
                    if (!mutexService.requestObjIDForUpdate(string)) continue;
                    mutexOrderIds.add(string);
                    moInfo = InteractionBackflushFacadeControllerBean.getManufactureOrder(cbc, string);
                    if (moInfo == null) continue;
                    ManufactureOrderStockInfo stockInfo22 = null;
                    ArrayList interactionList = (ArrayList)recBillMap.get(string);
                    moInfo.setSourceBillId(recBillID);
                    moInfo.setSourceBillType(billType);
                    InteractionBackFlushInfo forGetbillNum = (InteractionBackFlushInfo)interactionList.get(0);
                    moInfo.setSrcBillNum(forGetbillNum.getSourceBillNo());
                    ManufactureOrderStockCollection cloneCollection = new ManufactureOrderStockCollection();
                    ArrayList<String> materialIds = new ArrayList<String>();
                    ArrayList<String> unitids = new ArrayList<String>();
                    Map converMap = new HashMap();
                    for (ManufactureOrderStockInfo stockInfo22 : moInfo.getStocks()) {
                        materialIds.add(stockInfo22.getMaterial().getId().toString());
                        unitids.add(stockInfo22.getUnit().getId().toString());
                    }
                    if (materialIds.size() > 0) {
                        String[] materialArrays = materialIds.toArray(new String[0]);
                        String[] unitIdarrays = unitids.toArray(new String[0]);
                        IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
                        converMap = multiUnit.getConvRatesByMaterial(materialArrays, unitIdarrays);
                    }
                    for (ManufactureOrderStockInfo stockInfo22 : moInfo.getStocks()) {
                        for (int i = 0; i < interactionList.size(); ++i) {
                            InteractionBackFlushInfo backFlushInfo = (InteractionBackFlushInfo)interactionList.get(i);
                            if (!stockInfo22.getId().toString().equals(backFlushInfo.getOrderEntryID())) continue;
                            ManufactureOrderStockInfo stock = InteractionBackflushFacadeControllerBean.getCopyStock(stockInfo22);
                            BOSUuid oldID = stock.getId();
                            stock.setId(BOSUuid.create((BOSObjectType)stockInfo22.getBOSType()));
                            stock.setUnIssueQty(backFlushInfo.getThistimeQty());
                            String converKey = stockInfo22.getMaterial().getId().toString() + stockInfo22.getUnit().getId().toString();
                            if (converMap.containsKey(converKey)) {
                                BigDecimal rate = (BigDecimal)converMap.get(converKey);
                                BigDecimal baseThisQty = stock.getUnIssueQty().multiply(rate);
                                stock.setUnIssueBaseQty(baseThisQty);
                            }
                            stock.setWarehouse(backFlushInfo.getWarehouse());
                            stock.setLocation(backFlushInfo.getLocation());
                            stock.setLot(backFlushInfo.getLot());
                            stock.setMfg(backFlushInfo.getMfg());
                            stock.setExg(backFlushInfo.getExg());
                            cloneCollection.add(stock);
                            stock.setId(oldID);
                            orderStockIdList.add(backFlushInfo.getOrderEntryID());
                        }
                    }
                    moInfo.getStocks().clear();
                    for (ManufactureOrderStockInfo cloneStock : cloneCollection) {
                        BOSUuid oldID = cloneStock.getId();
                        cloneStock.setId(BOSUuid.create((BOSObjectType)stockInfo22.getBOSType()));
                        moInfo.getStocks().add(cloneStock);
                        cloneStock.setId(oldID);
                    }
                    if (moInfo.getStocks().size() <= 0) continue;
                    BOSUuid oldID = moInfo.getId();
                    moInfo.setId(BOSUuid.create((BOSObjectType)moInfo.getBOSType()));
                    moCol.add((CoreBillBaseInfo)moInfo);
                    moInfo.setId(oldID);
                }
            }
            try {
                InteractionBackflushFacadeControllerBean.generateManufactureRecBill(ctx, billinfo, moCol, noNumberRuleOrgs);
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            Object[] entryIDArray = orderStockIdList.toArray(new String[0]);
            String idStr = SQLUtil.arrayToString((Object[])entryIDArray);
            String deleteSQl = "delete from T_MM_INTERACTIONBACKFLUSH where FSOURCEBILLID='" + recBillID + "'and FSOURCEBILLTYPE='" + 1 + "' and  FOrderEntryID in( " + idStr + ") ";
            DbUtil.execute((Context)ctx, (String)deleteSQl);
            if (logPk != null) {
                LogUtil.afterLog((Context)ctx, logPk);
            }
        }
        finally {
            int i;
            int size = mutexRecIds.size();
            for (i = 0; i < size; ++i) {
                mutexService.releaseObjIDForUpdate(mutexRecIds.get(i).toString());
            }
            size = mutexOrderIds.size();
            for (i = 0; i < size; ++i) {
                mutexService.releaseObjIDForUpdate(mutexOrderIds.get(i).toString());
            }
        }
        return false;
    }

    private static ManufactureOrderInfo getManufactureOrder(CoreBillBaseCollection cbc, String orderId) {
        if (cbc == null || orderId == null) {
            return null;
        }
        ManufactureOrderInfo moInfo = null;
        for (int i = 0; i < cbc.size(); ++i) {
            moInfo = (ManufactureOrderInfo)cbc.get(i);
            if (moInfo.getId().toString().equals(orderId)) {
                if (moInfo instanceof IObjectValueAgent) {
                    moInfo = (ManufactureOrderInfo)AgentUtility.deepCopyAgentValue((IObjectValueAgent)((IObjectValueAgent)moInfo));
                    break;
                }
                moInfo = (ManufactureOrderInfo)moInfo.clone();
                break;
            }
            moInfo = null;
        }
        return moInfo;
    }

    private static CoreBillBaseCollection getInStockBackFlushOrders(Context ctx, Set orderIDSet) throws BOSException, EASBizException {
        IManufactureOrder moBiz = ManufactureOrderFactory.getLocalInstance((Context)ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)orderIDSet, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        FilterInfo entryFilterInfo = new FilterInfo();
        entryFilterInfo.setEntryName("stocks");
        entryFilterInfo.getFilterItems().add(new FilterItemInfo("isBackFlush", (Object)Boolean.TRUE));
        viewInfo.getEntryFilters().add(entryFilterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("firstOperNo"));
        sic.add(new SelectorItemInfo("storageOrgUnit.*"));
        sic.add(new SelectorItemInfo("baseStatus"));
        sic.add(new SelectorItemInfo("sourceBillTypeId"));
        sic.add(new SelectorItemInfo("srcBillNum"));
        sic.add(new SelectorItemInfo("sourceBillId"));
        sic.add(new SelectorItemInfo("stocks.*"));
        sic.add(new SelectorItemInfo("technics.operationNo"));
        sic.add(new SelectorItemInfo("technics.isReportPoint"));
        sic.add(new SelectorItemInfo("stocks.parent.project.*"));
        sic.add(new SelectorItemInfo("stocks.parent.trackNumber.*"));
        viewInfo.setSelector(sic);
        SorterItemCollection sortIC = new SorterItemCollection();
        sortIC.add(new SorterItemInfo("technics.operationNo"));
        sortIC.add(new SorterItemInfo("stocks.operationNo"));
        sortIC.add(new SorterItemInfo("stocks.replaceGroupFlag"));
        sortIC.add(new SorterItemInfo("stocks.replacePriority"));
        viewInfo.setSorter(sortIC);
        CoreBillBaseCollection cbc = moBiz.getCoreBillBaseCollection(viewInfo);
        if (cbc.size() <= 0) {
            throw new ManufactureOrderException(ManufactureOrderException.NO_WAREHOUSE_BACKFLUSH);
        }
        Iterator orderIter = cbc.iterator();
        while (orderIter.hasNext()) {
            ManufactureOrderInfo mo = (ManufactureOrderInfo)orderIter.next();
            if (mo.getStocks().size() > 0) continue;
            orderIter.remove();
        }
        if (cbc.size() <= 0) {
            throw new ManufactureOrderException(ManufactureOrderException.NO_BACKFLUSH_MATERIAL);
        }
        return cbc;
    }

    private static ManufactureOrderStockInfo getCopyStock(ManufactureOrderStockInfo srcStock) {
        if (srcStock == null || srcStock.getId() == null) {
            return null;
        }
        ManufactureOrderStockInfo dest = null;
        dest = srcStock instanceof IObjectValueAgent ? (ManufactureOrderStockInfo)AgentUtility.deepCopyAgentValue((IObjectValueAgent)((IObjectValueAgent)srcStock)) : (ManufactureOrderStockInfo)srcStock.clone();
        return dest;
    }

    private static ManufactureOrderInfo getOperationBackFlushOrder(Context ctx, InteractionBackFlushInfo backFlushInfo) throws BOSException, EASBizException {
        ManufactureOrderInfo mo = null;
        IManufactureOrder moBiz = ManufactureOrderFactory.getLocalInstance((Context)ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)backFlushInfo.getOrderID(), CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        FilterInfo entryFilterInfo = new FilterInfo();
        entryFilterInfo.setEntryName("stocks");
        entryFilterInfo.getFilterItems().add(new FilterItemInfo("isBackFlush", (Object)Boolean.TRUE));
        viewInfo.getEntryFilters().add(entryFilterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("firstOperNo"));
        sic.add(new SelectorItemInfo("storageOrgUnit.*"));
        sic.add(new SelectorItemInfo("baseStatus"));
        sic.add(new SelectorItemInfo("sourceBillTypeId"));
        sic.add(new SelectorItemInfo("srcBillNum"));
        sic.add(new SelectorItemInfo("sourceBillId"));
        sic.add(new SelectorItemInfo("stocks.*"));
        sic.add(new SelectorItemInfo("technics.operationNo"));
        sic.add(new SelectorItemInfo("technics.isReportPoint"));
        sic.add(new SelectorItemInfo("project.*"));
        sic.add(new SelectorItemInfo("trackNumber.*"));
        viewInfo.setSelector(sic);
        SorterItemCollection sortIC = new SorterItemCollection();
        sortIC.add(new SorterItemInfo("technics.operationNo"));
        sortIC.add(new SorterItemInfo("stocks.operationNo"));
        sortIC.add(new SorterItemInfo("stocks.replaceGroupFlag"));
        sortIC.add(new SorterItemInfo("stocks.replacePriority"));
        viewInfo.setSorter(sortIC);
        CoreBillBaseCollection cbc = moBiz.getCoreBillBaseCollection(viewInfo);
        if (cbc.size() <= 0) {
            throw new ManufactureOrderException(ManufactureOrderException.NO_OPERATION_BACKFLUSH);
        }
        Iterator orderIter = cbc.iterator();
        while (orderIter.hasNext()) {
            mo = (ManufactureOrderInfo)orderIter.next();
            if (mo.getStocks().size() > 0) continue;
            orderIter.remove();
        }
        return mo;
    }

    private static void generateManufactureRecBill(Context ctx, CoreBillBaseInfo billInfo, CoreBillBaseCollection moCol, String noNumberRuleOrgs) throws BOSException, SQLException, EASBizException {
        if (moCol.size() <= 0) {
            throw new ManufactureOrderException(ManufactureOrderException.NO_BACKFLUSHQTY);
        }
        if (noNumberRuleOrgs != null) {
            throw new ManufactureOrderException(ManufactureOrderException.ORG_NO_NUMBERRULE, new Object[]{noNumberRuleOrgs});
        }
        LogControllManager.getInstance().disableLog();
        ServiceStateManager.getInstance().disableNextCallService("LOG_SERVICE");
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        BTPTransformResult btpResult = iBTPManager.transformForBotp(moCol, MATERIALREQ_BOSTYPE, (IObjectPK)new ObjectStringPK(BACKFLUSH_BOTOPID));
        LogControllManager.getInstance().enableLog();
        ServiceStateManager.getInstance().enableNextCallService("LOG_SERVICE");
        IObjectCollection destBillCols = btpResult.getBills();
        BOTRelationCollection botRelationCols = btpResult.getBOTRelationCollection();
        if (billInfo instanceof ManufactureRecBillInfo) {
            Connection conn1 = null;
            PreparedStatement botpPrpStmt = null;
            StringBuffer sqlStr = new StringBuffer();
            sqlStr.append("insert into t_bot_relation(FID,FSRCENTITYID,FDESTENTITYID,FSRCOBJECTID,FDESTOBJECTID,FDATE,FOPERATORID,FISEFFECTED,FBOTMAPPINGID,FTYPE)");
            sqlStr.append(" values (?,'" + new ManufactureRecBillInfo().getBOSType().toString() + "','" + MATERIALREQ_BOSTYPE + "','" + billInfo.getId().toString() + "',?,now(),'" + ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() + "',1,null,0)");
            try {
                conn1 = EJBFactory.getConnection((Context)ctx);
                botpPrpStmt = conn1.prepareStatement(sqlStr.toString());
                String botBosType = new BOTRelationInfo().getBOSType().toString();
                int count = destBillCols.size();
                for (int i = 0; i < count; ++i) {
                    String relationID = BOSUuid.create((String)botBosType).toString();
                    botpPrpStmt.setString(1, relationID);
                    botpPrpStmt.setString(2, ((MaterialReqBillInfo)destBillCols.getObject(i)).getId().toString());
                    botpPrpStmt.addBatch();
                }
                botpPrpStmt.executeBatch();
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(botpPrpStmt, (Connection)conn1);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)botpPrpStmt, (Connection)conn1);
        }
        MaterialReqBillInfo materialReqBillInfo = null;
        Object[] orgunitids = new String[destBillCols.size()];
        int count = destBillCols.size();
        for (int i = 0; i < count; ++i) {
            materialReqBillInfo = (MaterialReqBillInfo)destBillCols.getObject(i);
            orgunitids[i] = materialReqBillInfo.getStorageOrgUnit().getId().toString();
        }
        String orgunitidStr = SQLUtil.arrayToString((Object[])orgunitids);
        StringBuffer paramSql = new StringBuffer();
        paramSql.append("select a.fparamvalue,a.forgunitid from t_scm_scmbillparamvalue as a ");
        paramSql.append("left join t_scm_scmbillparam as b on a.fparamid = b.fid ");
        paramSql.append("where b.fbilltype = '");
        paramSql.append("50957179-0105-1000-e000-0163c0a812fd463ED552");
        paramSql.append("' and b.fnumber='SCM_Submit_01'");
        paramSql.append(" and a.forgunitid in (");
        paramSql.append(orgunitidStr);
        paramSql.append(")");
        HashMap<String, Integer> parmValueMap = new HashMap<String, Integer>();
        IRowSet selectRs = DbUtil.executeQuery((Context)ctx, (String)paramSql.toString());
        while (selectRs != null && selectRs.next()) {
            parmValueMap.put(selectRs.getString("forgunitid"), new Integer(selectRs.getInt("fparamvalue")));
        }
        IMaterialReqBill materialReqBiz = MaterialReqBillFactory.getLocalInstance((Context)ctx);
        try {
            LogControllManager.getInstance().disableLog();
            ServiceStateManager.getInstance().disableNextCallService("LOG_SERVICE");
            if (WfEventListenerStateManager.getInstance().isEnable()) {
                WfEventListenerStateManager.getInstance().disableEventListener();
            }
            int count2 = destBillCols.size();
            for (int i = 0; i < count2; ++i) {
                CoreBillBaseInfo destBillInfo = (CoreBillBaseInfo)destBillCols.getObject(i);
                boolean needCostCenter = InteractionBackflushFacadeControllerBean.requiredCostCenter(ctx, destBillInfo);
                Map costItemMap = InteractionBackflushFacadeControllerBean.getMaterialCostItem(ctx, (MaterialReqBillInfo)destBillInfo);
                for (int j = 0; j < ((MaterialReqBillInfo)destBillInfo).getEntry().size(); ++j) {
                    MaterialReqBillEntryInfo entry = ((MaterialReqBillInfo)destBillInfo).getEntry().get(j);
                    if (entry.getMaterial() != null && entry.getCostItem() == null && costItemMap != null) {
                        entry.setCostItem((CostItemInfo)costItemMap.get(entry.getMaterial().getId()));
                    }
                    if (!needCostCenter || entry.getCostCenterOrgUnit() != null) continue;
                    throw new ManufactureOrderException(ManufactureOrderException.NO_BACKFLUSH_COSTCENTER);
                }
                if (billInfo instanceof CompletionReportInfo) {
                    destBillInfo.setBizDate(((CompletionReportInfo)billInfo).getReportTime());
                } else if (billInfo instanceof ManufactureRecBillInfo) {
                    destBillInfo.setBizDate(billInfo.getBizDate());
                }
                IObjectPK logPk = LogUtil.beginLog((Context)ctx, (String)"_addnew", (BOSObjectType)destBillInfo.getBOSType(), (IObjectPK)new ObjectUuidPK(destBillInfo.getId().toString()), (String)destBillInfo.getNumber(), (String)"im_materialReq_addnew");
                LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
                materialReqBiz.submit((CoreBaseInfo)destBillInfo);
                Integer integer = (Integer)parmValueMap.get(((MaterialReqBillInfo)destBillInfo).getStorageOrgUnit().getId().toString());
                int i1 = 1;
                if (integer != null) {
                    i1 = integer;
                }
                if (i1 != 0) continue;
                materialReqBiz.audit((IObjectPK)new ObjectUuidPK(destBillInfo.getId()));
            }
        }
        catch (BOSException e) {
            throw e;
        }
        catch (EASBizException e) {
            throw e;
        }
        finally {
            LogControllManager.getInstance().enableLog();
            ServiceStateManager.getInstance().enableNextCallService("LOG_SERVICE");
            if (!WfEventListenerStateManager.getInstance().isEnable()) {
                WfEventListenerStateManager.getInstance().enableEventListener();
            }
        }
    }

    private static boolean requiredCostCenter(Context ctx, CoreBillBaseInfo destBillInfo) throws EASBizException, BOSException {
        boolean flag = false;
        CompanyOrgUnitInfo couInfo = ((MaterialReqBillInfo)destBillInfo).getDemandCompanyOrgUnit();
        TransactionTypeInfo ttInfo = ((MaterialReqBillInfo)destBillInfo).getTransactionType();
        if (couInfo != null && ttInfo != null && ttInfo.isIsManuCostCalculate() && SystemStatusCtrolUtils.isStart((Context)ctx, (SystemEnum)SystemEnum.COSTMANAGEMENT, (CompanyOrgUnitInfo)couInfo)) {
            flag = true;
        }
        return flag;
    }

    private static Map getMaterialCostItem(Context ctx, MaterialReqBillInfo minfo) throws BOSException, EASBizException {
        CompanyOrgUnitInfo cou = InteractionBackflushFacadeControllerBean.getCompanyOrgByStorageOrg(ctx, minfo.getStorageOrgUnit().getId().toString());
        if (cou == null) {
            return null;
        }
        HashSet<String> materialSet = new HashSet<String>();
        for (int i = 0; i < minfo.getEntry().size(); ++i) {
            MaterialReqBillEntryInfo entry = minfo.getEntry().get(i);
            if (entry.getMaterial() == null || entry.getCostItem() != null) continue;
            materialSet.add(entry.getMaterial().getId().toString());
        }
        HashMap<BOSUuid, CostItemInfo> costItemMap = new HashMap<BOSUuid, CostItemInfo>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit", (Object)cou.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("material", materialSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("defaultCostItem.*"));
        sic.add(new SelectorItemInfo("material.*"));
        MaterialCostCollection coll = MaterialCostFactory.getLocalInstance((Context)ctx).getMaterialCostCollection(view);
        if (coll == null || coll.size() == 0) {
            return null;
        }
        for (int j = 0; j < coll.size(); ++j) {
            MaterialCostInfo materialCost = coll.get(j);
            if (materialCost == null) continue;
            costItemMap.put(materialCost.getMaterial().getId(), materialCost.getDefaultCostItem());
        }
        return costItemMap;
    }

    private static CompanyOrgUnitInfo getCompanyOrgByStorageOrg(Context ctx, String orgId) throws BOSException, EASBizException {
        CompanyOrgUnitInfo ret = null;
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection orgCol = iUnitRel.getToUnit(orgId, 4, 1);
        if (orgCol != null && orgCol.size() > 0) {
            ret = (CompanyOrgUnitInfo)orgCol.get(0);
        }
        return ret;
    }

    public static boolean checkMaterialNumberRuler(Context ctx, String orgID) throws BOSException, EASBizException {
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        RuleStatus ruleStatus = codingRuleManager.getRuleStatus((IObjectValue)new MaterialReqBillInfo(), orgID);
        return ruleStatus.isExist();
    }

    @Override
    protected BigDecimal _checkCurrentStock(Context ctx, String materialID, String storageOrgID, String warehouseID, String locationID, String unitID, String lot, String projectid, String trackNumberid) throws BOSException, EASBizException {
        BigDecimal bigDecimal;
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block20: {
            conn = null;
            stmt = null;
            rs = null;
            StringBuffer sqlBuffer = new StringBuffer();
            String sql = "";
            StringBuffer lotWhere = new StringBuffer();
            StringBuffer storageWhere = new StringBuffer();
            StringBuffer warehouseWhere = new StringBuffer();
            StringBuffer locationWhere = new StringBuffer();
            StringBuffer itemWhere = new StringBuffer();
            StringBuffer unitWhere = new StringBuffer();
            StringBuffer projectWhere = new StringBuffer();
            StringBuffer trackNumberWhere = new StringBuffer();
            if (lot != null) {
                lotWhere.append(" AND FLot = ? ");
            } else {
                lotWhere.append(" AND FLot = 'YNi0IQEOEADgBT3mfwAAAcznrtQ=' ");
            }
            storageWhere.append(" AND FStorageOrgUnitID = ? ");
            if (warehouseID != null) {
                warehouseWhere.append(" AND FWarehouseID = ? ");
            } else {
                warehouseWhere.append(" AND FWarehouseID = 'EgkAAABc3XG76fiu' ");
            }
            if (locationID != null) {
                locationWhere.append(" AND FLocationID = ? ");
            } else {
                locationWhere.append(" AND FLocationID = 'EgkAAABc3XMgX/hq' ");
            }
            itemWhere.append(" AND FMaterialID = ? ");
            unitWhere.append(" AND FUnitID = ? ");
            if (projectid != null) {
                projectWhere.append(" AND FProjectID = ? ");
            } else {
                projectWhere.append(" AND FProjectID = 'EgkAAABc3Xza3gXu' ");
            }
            if (trackNumberid != null) {
                trackNumberWhere.append(" AND FTrackNumberID = ? ");
            } else {
                trackNumberWhere.append(" AND FTrackNumberID = 'EgkAAABc3X0Ibpg9' ");
            }
            sqlBuffer.append("SELECT SUM(FCurStoreQty) AS Qty FROM T_IM_INVENTORY ");
            sqlBuffer.append("WHERE 1=1 ");
            sqlBuffer.append(lotWhere);
            sqlBuffer.append(storageWhere);
            sqlBuffer.append(warehouseWhere);
            sqlBuffer.append(locationWhere);
            sqlBuffer.append(itemWhere);
            sqlBuffer.append(unitWhere);
            sqlBuffer.append(projectWhere);
            sqlBuffer.append(trackNumberWhere);
            sql = sqlBuffer.toString();
            int index = 0;
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.prepareStatement(sql);
            if (lot != null) {
                stmt.setString(++index, lot);
            }
            stmt.setString(++index, storageOrgID != null ? storageOrgID : "");
            if (warehouseID != null) {
                stmt.setString(++index, warehouseID);
            }
            if (locationID != null) {
                stmt.setString(++index, locationID);
            }
            stmt.setString(++index, materialID != null ? materialID : "");
            stmt.setString(++index, unitID != null ? unitID : "");
            if (projectid != null) {
                stmt.setString(++index, projectid);
            }
            if (trackNumberid != null) {
                stmt.setString(++index, trackNumberid);
            }
            rs = stmt.executeQuery();
            rs.next();
            if (rs.getBigDecimal("Qty") != null) break block20;
            BigDecimal bigDecimal2 = ZERO;
            SQLUtils.cleanup((Statement)stmt, (Connection)conn);
            return bigDecimal2;
        }
        try {
            bigDecimal = rs.getBigDecimal("Qty");
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        return bigDecimal;
    }

    @Override
    protected void _saveInteractionFaiedData(Context ctx, List faiedList, List notSelectList, BackFrushStatusEnum updatestatus, BackFlushSourceTypeEnum sourceType, String srcBillId, boolean isInsertTable) throws BOSException, EASBizException {
        HashMap map = new HashMap();
        InteractionBackFlushCollection colls = new InteractionBackFlushCollection();
        if (isInsertTable) {
            this.saveListData(ctx, faiedList, map, colls);
            this.saveListData(ctx, notSelectList, map, colls);
        }
        this.updateBillStatus(ctx, updatestatus, sourceType, srcBillId);
    }

    private void saveListData(Context ctx, List paramList, HashMap map, InteractionBackFlushCollection colls) throws BOSException, EASBizException {
        if (paramList != null && paramList.size() > 0) {
            for (int i = 0; i < paramList.size(); ++i) {
                InteractionBackFlushInfo info = (InteractionBackFlushInfo)paramList.get(i);
                String key = info.getOrderID() + info.getMaterial().getId().toString() + info.getOrderEntryID();
                if (map.containsKey(key)) continue;
                map.put(key, key);
                colls.add(info);
                IInteractionBackFlush inter = InteractionBackFlushFactory.getLocalInstance(ctx);
                if (inter.exists((IObjectPK)new ObjectUuidPK(info.getId()))) continue;
                info.setThistimeQty(null);
                info.setMfg(null);
                info.setExg(null);
                info.setLot(null);
                inter.save(info);
            }
        }
    }

    private void updateBillStatus(Context ctx, BackFrushStatusEnum updatestatus, BackFlushSourceTypeEnum sourceType, String srcBillId) throws BOSException {
        if (sourceType == BackFlushSourceTypeEnum.BACKFLUSH_COMPLETION) {
            InteractionBackflushFacadeControllerBean.updateCompletionReportStatus(ctx, srcBillId, updatestatus.getValue());
        } else {
            InteractionBackflushFacadeControllerBean.updateRecBillStatus(ctx, srcBillId, updatestatus.getValue());
        }
    }

    public static void updateCompletionReportStatus(Context ctx, String billID, int toUpdateStatus) throws BOSException {
        String updateSql = "update T_MM_CompletionReport set FIsBackfrush = " + toUpdateStatus + " where FID ='" + billID + "'";
        DbUtil.execute((Context)ctx, (String)updateSql);
    }

    public static void updateRecBillStatus(Context ctx, String billID, int toUpdateStatus) throws BOSException {
        String updateSql = "update T_IM_ManufactureRecBill set FIsBackFlushSucceed = " + toUpdateStatus + " where FID ='" + billID + "'";
        DbUtil.execute((Context)ctx, (String)updateSql);
    }

    @Override
    protected boolean _getSourceManuOrderStatus(Context ctx, String id, boolean isCompletion) throws BOSException, EASBizException {
        StringBuffer sqlBuff = new StringBuffer();
        boolean result = true;
        if (isCompletion) {
            sqlBuff.append("select m.FBASESTATUS as status from T_MM_MANUFACTUREORDER m where m.fid in(select t.FDMESORDERID  from T_MM_COMPLETIONREPORT t where t.fid= '" + id + "')");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuff.toString());
            if (rs != null && rs.size() > 0) {
                try {
                    while (rs.next()) {
                        int status = rs.getInt("status");
                        if (status != 7 && status != 6 && status != 11) continue;
                        result = false;
                    }
                }
                catch (SQLException e) {
                    throw new SQLDataException(e);
                }
            }
        } else {
            sqlBuff.append("select count (m.FBASESTATUS) status from T_MM_MANUFACTUREORDER m where m.fid in (select i.FMANUBILLID from T_IM_MANUFACTURERECBILLENTRY i where i.FPARENTID='" + id + "' and i.FMANUBILLID is not null) and m.FBASESTATUS <> " + 7 + " and m.FBASESTATUS <> " + 6 + " and m.FBASESTATUS <> " + 11);
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuff.toString());
            if (rs != null && rs.size() > 0) {
                try {
                    while (rs.next()) {
                        int status = rs.getInt("status");
                        if (status != 0) continue;
                        result = false;
                    }
                }
                catch (SQLException e) {
                    throw new SQLDataException(e);
                }
            }
        }
        return result;
    }

    private Object[] getSourceManuOrder4ManuRec(Context ctx, HashSet manuRecIds, HashSet orderIds) throws BOSException {
        StringBuffer sqlBuff = new StringBuffer();
        Object[] result = new Object[2];
        HashMap<String, ManufactureOrderInfo> manuRecs = new HashMap<String, ManufactureOrderInfo>();
        HashMap<String, ManufactureOrderInfo> orders = new HashMap<String, ManufactureOrderInfo>();
        result[0] = manuRecs;
        result[1] = orders;
        String locStr = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        sqlBuff.append("select i.FPARENTID recId, m.FID orderId, m.FNUMBER orderNumber, ").append(" t.FID trackId, t.FNUMBER trackNumber, t.FNAME_").append(locStr).append(" trackName, p.FID projectId, p.FNUMBER projectNumber, p.FNAME_").append(locStr).append(" projectName from T_MM_MANUFACTUREORDER m left outer join T_IM_MANUFACTURERECBILLENTRY i on m.fid = i.FMANUBILLID and m.FMaterialId = i.FMaterialId").append(" left outer join T_MM_TRACKNUMBER t on m.FTrackId = t.FID").append(" left outer join T_MM_PROJECT p on m.FProjectId = p.FID").append(" where i.FPARENTID in (" + SQLUtil.setToString((Set)manuRecIds) + ") and i.FMANUBILLID is not null").append(" and m.fid in (" + SQLUtil.setToString((Set)orderIds) + ")").append(" and (m.FBASESTATUS not in (").append(7).append(",").append(6).append(",").append(11).append("))");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuff.toString());
        try {
            ManufactureOrderInfo mo = null;
            TrackNumberInfo track = null;
            ProjectInfo project = null;
            while (rs.next()) {
                mo = new ManufactureOrderInfo();
                mo.setId(BOSUuid.read((String)rs.getString("orderId")));
                mo.setNumber(rs.getString("orderNumber"));
                if (rs.getString("trackId") != null) {
                    track = new TrackNumberInfo();
                    track.setId(BOSUuid.read((String)rs.getString("trackId")));
                    track.setNumber(rs.getString("trackNumber"));
                    track.setName(rs.getString("trackName"));
                    mo.setTrackNumber(track);
                }
                if (rs.getString("projectId") != null) {
                    project = new ProjectInfo();
                    project.setId(BOSUuid.read((String)rs.getString("projectId")));
                    project.setNumber(rs.getString("projectNumber"));
                    project.setName(rs.getString("projectName"));
                    mo.setProject(project);
                }
                manuRecs.put(rs.getString("recId"), mo);
                orders.put(rs.getString("orderId"), mo);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return result;
    }

    @Override
    protected HashSet _getSourceManuOrderErrorSet(Context ctx, boolean isCompletion) throws BOSException, EASBizException {
        StringBuffer sqlBuff = new StringBuffer();
        HashSet<String> result = new HashSet<String>();
        if (isCompletion) {
            sqlBuff.append("select m.FBASESTATUS as status,t.fid as id  from T_MM_MANUFACTUREORDER m inner join T_MM_COMPLETIONREPORT t on m.fid=t.FDMESORDERID");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuff.toString());
            if (rs != null && rs.size() > 0) {
                try {
                    while (rs.next()) {
                        int status = rs.getInt("status");
                        if (status != 7 && status != 6 && status != 11) continue;
                        String id = rs.getString("id");
                        result.add(id);
                    }
                }
                catch (SQLException e) {
                    throw new SQLDataException(e);
                }
            }
        } else {
            sqlBuff.append("select m.FBASESTATUS as status , t.FPARENTID as id  from T_MM_MANUFACTUREORDER m inner  join T_IM_MANUFACTURERECBILLENTRY t on m.fid=t.FMANUBILLID and m.FMATERIALID is not null");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuff.toString());
            if (rs != null && rs.size() > 0) {
                try {
                    while (rs.next()) {
                        int status = rs.getInt("status");
                        if (status != 7 && status != 6 && status != 11) continue;
                        String id = rs.getString("id");
                        result.add(id);
                    }
                }
                catch (SQLException e) {
                    throw new SQLDataException(e);
                }
            }
        }
        return result;
    }

    private static String getInventoryConllectionSQL(String billTypeID, String souID, TransactionTypeInfo tti, boolean isUpdateByBaseUnit, String materialID, String asstattrID, String unitID, String warehouseID, String locationID, String storeTypeID, String storeStatusID, String supplierID, String customerID, String projectID, String trackNumberID, IssuePriorityEnum issuePriority, boolean isNegative) {
        InvUpdateTypeInfo ivtInfo;
        StringBuffer sql = new StringBuffer();
        sql.append("select inv.FStorageOrgUnitID as souID, ");
        sql.append("inv.FMaterialID as materialID, ");
        sql.append("inv.FWarehouseID as warehouseID, ");
        sql.append("inv.FLocationID as locationID, ");
        sql.append("inv.FCustomerID as customerID, ");
        sql.append("inv.FSupplierID as supplierID, ");
        sql.append("inv.FUnitID as unitID, ");
        sql.append("inv.FLot as lot, ");
        sql.append("inv.FCurStoreQty as qty, ");
        sql.append("dom.FMfg as mfg, ");
        sql.append("dom.FExp as exp, ");
        sql.append("FPROJECTID as projectID, ");
        sql.append("FTRACKNUMBERID as trackNumberID ");
        sql.append("from T_IM_Inventory inv left outer join T_IM_DateOfMinDurability dom ");
        sql.append(" on inv.FLot = dom.FLot and inv.FStorageOrgUnitID = dom.FStorageOrgUnitID and inv.FMaterialID = dom.FMaterialID ");
        sql.append(" where inv.FStorageOrgUnitID = '").append(souID).append("'");
        sql.append(" and inv.FMaterialID = '").append(materialID).append("'");
        sql.append(" and inv.FUnitID = '").append(unitID).append("'");
        if (warehouseID != null) {
            sql.append(" and inv.FWarehouseID = '").append(warehouseID).append("'");
        }
        if (locationID != null) {
            sql.append(" and inv.FLocationID = '").append(locationID).append("'");
        }
        if (!isNegative) {
            sql.append(" and inv.FBaseQty > 0 ");
        }
        if (billTypeID != null && (ivtInfo = TransactionTypeHelper.getDefaultInvUpdateTypeByTransactionType(null, (TransactionTypeInfo)tti)) != null) {
            if (ivtInfo.getStoreTypePre() != null) {
                sql.append(" and inv.FStoreTypeID = '").append(ivtInfo.getStoreTypePre().getId().toString()).append("'");
            }
            if (ivtInfo.getStoreStatePre() != null) {
                sql.append(" and inv.FStoreStatusID = '").append(ivtInfo.getStoreStatePre().getId().toString()).append("'");
            }
        }
        if (projectID != null) {
            sql.append(" and FProjectID = '").append(projectID).append("'");
        } else {
            sql.append(" and FProjectID = 'EgkAAABc3Xza3gXu' ");
        }
        if (trackNumberID != null) {
            sql.append(" and FTrackNumberID = '").append(trackNumberID).append("'");
        } else {
            sql.append(" and FTrackNumberID = 'EgkAAABc3X0Ibpg9' ");
        }
        sql.append(" order by FProjectID asc,");
        sql.append(" FTrackNumberID asc");
        if (issuePriority != null) {
            switch (issuePriority.getValue()) {
                case 1: {
                    sql.append(" ,dom.FLot asc");
                    break;
                }
                case 2: {
                    sql.append(" ,dom.FInWarehouseDate,inv.FLot asc ");
                    break;
                }
                case 3: {
                    sql.append(" ,dom.FInWarehouseDate desc,inv.FLot asc");
                    break;
                }
                case 4: {
                    sql.append(" ,dom.FExp,dom.FInWarehouseDate,inv.FLot asc");
                    break;
                }
                default: {
                    sql.append(" ,dom.FInWarehouseDate ,inv.FLot asc ");
                    break;
                }
            }
        } else {
            sql.append(" ,dom.FInWarehouseDate ,inv.FLot asc ");
        }
        return sql.toString();
    }

    private void addRS2Collection(InventoryCollection coll, ResultSet rs) throws UuidException, SQLException {
        while (rs.next()) {
            InventoryInfo info = new InventoryInfo();
            StorageOrgUnitInfo sou = new StorageOrgUnitInfo();
            sou.setId(BOSUuid.read((String)rs.getString("souID")));
            info.setStorageOrgUnit(sou);
            MaterialInfo material = new MaterialInfo();
            material.setId(BOSUuid.read((String)rs.getString("materialID")));
            info.setMaterial(material);
            MeasureUnitInfo unit = new MeasureUnitInfo();
            unit.setId(BOSUuid.read((String)rs.getString("unitID")));
            info.setUnit(unit);
            info.setCurStoreQty(rs.getBigDecimal("qty"));
            if (rs.getString("warehouseID") != null) {
                WarehouseInfo warehouse = new WarehouseInfo();
                warehouse.setId(BOSUuid.read((String)rs.getString("warehouseID")));
                info.setWarehouse(warehouse);
            }
            if (rs.getString("locationID") != null) {
                LocationInfo location = new LocationInfo();
                location.setId(BOSUuid.read((String)rs.getString("locationID")));
                info.setLocation(location);
            }
            if (rs.getString("customerID") != null) {
                CustomerInfo customer = new CustomerInfo();
                customer.setId(BOSUuid.read((String)rs.getString("customerID")));
                info.setCustomer(customer);
            }
            if (rs.getString("supplierID") != null) {
                SupplierInfo supplier = new SupplierInfo();
                supplier.setId(BOSUuid.read((String)rs.getString("supplierID")));
                info.setSupplier(supplier);
            }
            if (rs.getString("projectID") != null) {
                ProjectInfo project = new ProjectInfo();
                project.setId(BOSUuid.read((String)rs.getString("projectID")));
                info.setProject(project);
            }
            if (rs.getString("trackNumberID") != null) {
                TrackNumberInfo trackNumber = new TrackNumberInfo();
                trackNumber.setId(BOSUuid.read((String)rs.getString("trackNumberID")));
                info.setTrackNumber(trackNumber);
            }
            info.setLot(rs.getString("lot"));
            info.setDate("mfg", rs.getDate("mfg"));
            info.setDate("exp", rs.getDate("exp"));
            coll.add(info);
        }
    }

    @Override
    protected BigDecimal _checkCurrentStock(Context ctx, String materialID, String storageOrgID, String warehouseID, String locationID, String unitID, String lot, String projectid, String trackNumberid, boolean isUpdateByBaseUnit, String baseUnitID) throws BOSException, EASBizException {
        BigDecimal baseInvQty2;
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block24: {
            block23: {
                conn = null;
                stmt = null;
                rs = null;
                StringBuffer sqlBuffer = new StringBuffer();
                String sql = "";
                StringBuffer lotWhere = new StringBuffer();
                StringBuffer storageWhere = new StringBuffer();
                StringBuffer warehouseWhere = new StringBuffer();
                StringBuffer locationWhere = new StringBuffer();
                StringBuffer itemWhere = new StringBuffer();
                StringBuffer unitWhere = new StringBuffer();
                StringBuffer projectWhere = new StringBuffer();
                StringBuffer trackNumberWhere = new StringBuffer();
                if (lot != null) {
                    lotWhere.append(" AND FLot = ? ");
                } else {
                    lotWhere.append(" AND FLot = 'YNi0IQEOEADgBT3mfwAAAcznrtQ=' ");
                }
                storageWhere.append(" AND FStorageOrgUnitID = ? ");
                if (warehouseID != null) {
                    warehouseWhere.append(" AND FWarehouseID = ? ");
                } else {
                    warehouseWhere.append(" AND FWarehouseID = 'EgkAAABc3XG76fiu' ");
                }
                if (locationID != null) {
                    locationWhere.append(" AND FLocationID = ? ");
                } else {
                    locationWhere.append(" AND FLocationID = 'EgkAAABc3XMgX/hq' ");
                }
                itemWhere.append(" AND FMaterialID = ? ");
                unitWhere.append(" AND FUnitID = ? ");
                if (projectid != null) {
                    projectWhere.append(" AND FProjectID = ? ");
                } else {
                    projectWhere.append(" AND FProjectID = 'EgkAAABc3Xza3gXu' ");
                }
                if (trackNumberid != null) {
                    trackNumberWhere.append(" AND FTrackNumberID = ? ");
                } else {
                    trackNumberWhere.append(" AND FTrackNumberID = 'EgkAAABc3X0Ibpg9' ");
                }
                sqlBuffer.append("SELECT SUM(FCurStoreQty) AS Qty FROM T_IM_INVENTORY ");
                sqlBuffer.append("WHERE 1=1 ");
                sqlBuffer.append(lotWhere);
                sqlBuffer.append(storageWhere);
                sqlBuffer.append(warehouseWhere);
                sqlBuffer.append(locationWhere);
                sqlBuffer.append(itemWhere);
                sqlBuffer.append(unitWhere);
                sqlBuffer.append(projectWhere);
                sqlBuffer.append(trackNumberWhere);
                sql = sqlBuffer.toString();
                int index = 0;
                conn = EJBFactory.getConnection((Context)ctx);
                stmt = conn.prepareStatement(sql);
                if (lot != null) {
                    stmt.setString(++index, lot);
                }
                stmt.setString(++index, storageOrgID != null ? storageOrgID : "");
                if (warehouseID != null) {
                    stmt.setString(++index, warehouseID);
                }
                if (locationID != null) {
                    stmt.setString(++index, locationID);
                }
                stmt.setString(++index, materialID != null ? materialID : "");
                if (isUpdateByBaseUnit) {
                    stmt.setString(++index, baseUnitID != null ? baseUnitID : "");
                } else {
                    stmt.setString(++index, unitID != null ? unitID : "");
                }
                if (projectid != null) {
                    stmt.setString(++index, projectid);
                }
                if (trackNumberid != null) {
                    stmt.setString(++index, trackNumberid);
                }
                rs = stmt.executeQuery();
                rs.next();
                if (rs.getBigDecimal("Qty") != null) break block23;
                BigDecimal bigDecimal = ZERO;
                SQLUtils.cleanup((Statement)stmt, (Connection)conn);
                return bigDecimal;
            }
            if (!isUpdateByBaseUnit) break block24;
            BigDecimal baseInvQty2 = rs.getBigDecimal("Qty");
            BigDecimal bigDecimal = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)materialID, (String)baseUnitID, (BigDecimal)baseInvQty2, (String)unitID);
            SQLUtils.cleanup((Statement)stmt, (Connection)conn);
            return bigDecimal;
        }
        try {
            baseInvQty2 = rs.getBigDecimal("Qty");
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        return baseInvQty2;
    }

    @Override
    protected BigDecimal _checkCurrentStock(Context ctx, String materialID, String storageOrgID, String warehouseID, String locationID, String unitID, String lot, String projectID, String trackNumberID, boolean isUpdateByBaseUnit, String baseUnitID, TransactionTypeInfo tti) throws BOSException, EASBizException {
        BigDecimal baseInvQty2;
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block31: {
            block30: {
                conn = null;
                stmt = null;
                rs = null;
                StringBuffer sqlBuffer = new StringBuffer();
                String sql = "";
                String storeTypeID = null;
                String storeStatusID = null;
                InvUpdateTypeInfo ivtInfo = TransactionTypeHelper.getDefaultInvUpdateTypeByTransactionType(null, (TransactionTypeInfo)tti);
                if (ivtInfo != null) {
                    if (ivtInfo.getStoreTypePre() != null) {
                        storeTypeID = ivtInfo.getStoreTypePre().getId().toString();
                    }
                    if (ivtInfo.getStoreStatePre() != null) {
                        storeStatusID = ivtInfo.getStoreStatePre().getId().toString();
                    }
                }
                StringBuffer lotWhere = new StringBuffer();
                StringBuffer storageWhere = new StringBuffer();
                StringBuffer warehouseWhere = new StringBuffer();
                StringBuffer locationWhere = new StringBuffer();
                StringBuffer itemWhere = new StringBuffer();
                StringBuffer unitWhere = new StringBuffer();
                StringBuffer projectWhere = new StringBuffer();
                StringBuffer trackNumberWhere = new StringBuffer();
                StringBuffer storeTypeWhere = new StringBuffer();
                StringBuffer storeStatusWhere = new StringBuffer();
                if (lot != null) {
                    lotWhere.append(" AND FLot = ? ");
                } else {
                    lotWhere.append(" AND FLot = 'YNi0IQEOEADgBT3mfwAAAcznrtQ=' ");
                }
                storageWhere.append(" AND FStorageOrgUnitID = ? ");
                if (warehouseID != null) {
                    warehouseWhere.append(" AND FWarehouseID = ? ");
                } else {
                    warehouseWhere.append(" AND FWarehouseID = 'EgkAAABc3XG76fiu' ");
                }
                if (locationID != null) {
                    locationWhere.append(" AND FLocationID = ? ");
                } else {
                    locationWhere.append(" AND FLocationID = 'EgkAAABc3XMgX/hq' ");
                }
                itemWhere.append(" AND FMaterialID = ? ");
                unitWhere.append(" AND FUnitID = ? ");
                if (projectID != null) {
                    projectWhere.append(" AND FProjectID = ? ");
                } else {
                    projectWhere.append(" AND FProjectID = 'EgkAAABc3Xza3gXu' ");
                }
                if (trackNumberID != null) {
                    trackNumberWhere.append(" AND FTrackNumberID = ? ");
                } else {
                    trackNumberWhere.append(" AND FTrackNumberID = 'EgkAAABc3X0Ibpg9' ");
                }
                if (storeTypeID != null) {
                    storeTypeWhere.append(" AND FStoreTypeID = ? ");
                }
                if (storeStatusID != null) {
                    storeStatusWhere.append(" AND FStoreStatusID = ? ");
                }
                sqlBuffer.append("SELECT SUM(FCurStoreQty) AS Qty FROM T_IM_INVENTORY ");
                sqlBuffer.append("WHERE 1=1 ");
                sqlBuffer.append(lotWhere);
                sqlBuffer.append(storageWhere);
                sqlBuffer.append(warehouseWhere);
                sqlBuffer.append(locationWhere);
                sqlBuffer.append(itemWhere);
                sqlBuffer.append(unitWhere);
                sqlBuffer.append(projectWhere);
                sqlBuffer.append(trackNumberWhere);
                sqlBuffer.append(storeTypeWhere);
                sqlBuffer.append(storeStatusWhere);
                sql = sqlBuffer.toString();
                int index = 0;
                conn = EJBFactory.getConnection((Context)ctx);
                stmt = conn.prepareStatement(sql);
                if (lot != null) {
                    stmt.setString(++index, lot);
                }
                stmt.setString(++index, storageOrgID != null ? storageOrgID : "");
                if (warehouseID != null) {
                    stmt.setString(++index, warehouseID);
                }
                if (locationID != null) {
                    stmt.setString(++index, locationID);
                }
                stmt.setString(++index, materialID != null ? materialID : "");
                if (isUpdateByBaseUnit) {
                    stmt.setString(++index, baseUnitID != null ? baseUnitID : "");
                } else {
                    stmt.setString(++index, unitID != null ? unitID : "");
                }
                if (projectID != null) {
                    stmt.setString(++index, projectID);
                }
                if (trackNumberID != null) {
                    stmt.setString(++index, trackNumberID);
                }
                if (storeTypeID != null) {
                    stmt.setString(++index, storeTypeID);
                }
                if (storeStatusID != null) {
                    stmt.setString(++index, storeStatusID);
                }
                rs = stmt.executeQuery();
                rs.next();
                if (rs.getBigDecimal("Qty") != null) break block30;
                BigDecimal bigDecimal = ZERO;
                SQLUtils.cleanup((Statement)stmt, (Connection)conn);
                return bigDecimal;
            }
            if (!isUpdateByBaseUnit) break block31;
            BigDecimal baseInvQty2 = rs.getBigDecimal("Qty");
            BigDecimal bigDecimal = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)materialID, (String)baseUnitID, (BigDecimal)baseInvQty2, (String)unitID);
            SQLUtils.cleanup((Statement)stmt, (Connection)conn);
            return bigDecimal;
        }
        try {
            baseInvQty2 = rs.getBigDecimal("Qty");
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        return baseInvQty2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected BatchActionResults _autoBackFlushTask(Context ctx, String storageOrgUnitNum, String startDate, String endDate) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)storageOrgUnitNum) || StringUtils.isEmpty((String)startDate) || StringUtils.isEmpty((String)endDate)) {
            throw new SfcException(SfcException.BACKFLUSHMUSTINPUT);
        }
        BackFlushFilterInfo filterInfo = new BackFlushFilterInfo();
        StorageOrgUnitInfo storage = (StorageOrgUnitInfo)StorageOrgUnitFactory.getLocalInstance((Context)ctx).getValue("select id,number where number = '" + storageOrgUnitNum + "'");
        IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        boolean isSucceed = false;
        isSucceed = mutex.requestObjIDForUpdate(storage.getId().toString() + "completeBackFlush", ctx.getCaller().toString(), Uuid.create());
        if (!isSucceed) throw new SfcException(SfcException.COMPLEBACKFLUSHEXISTS);
        try {
            filterInfo.setStorageUnitNum(storage);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            try {
                Date startDateD = sdf.parse(startDate);
                Date endDateD = sdf.parse(endDate);
                filterInfo.setBizDateFrom(startDateD);
                filterInfo.setBizDateTo(endDateD);
            }
            catch (ParseException e) {
                throw new BOSException((Throwable)e);
            }
            FilterInfo filter = this.buildCommonFilter(filterInfo, ctx);
            this.getCompletionFilter(filter);
            EntityViewInfo viewInfo = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            viewInfo.setSelector(sic);
            viewInfo.setFilter(filter);
            SorterItemCollection sorter = new SorterItemCollection();
            sorter.add(new SorterItemInfo("number"));
            viewInfo.setSorter(sorter);
            ICompletionReport report = CompletionReportFactory.getLocalInstance(ctx);
            CompletionReportCollection coll = report.getCompletionReportCollection(viewInfo);
            if (coll.size() <= 0) return null;
            String[] compleIDArrs = new String[coll.size()];
            int k = -1;
            for (Object tt : coll.toArray()) {
                compleIDArrs[++k] = ((CompletionReportInfo)tt).getId().toString();
            }
            IManufactureOrder orderInterface = ManufactureOrderFactory.getLocalInstance((Context)ctx);
            BillTypeInfo billType = new BillTypeInfo();
            billType.setId(BOSUuid.read((String)"HxPKDRdzRpaqr31LD+3SBEY+1VI="));
            orderInterface.materialBackFlush(compleIDArrs, billType);
            return null;
        }
        finally {
            IMutexServiceControl mutex2 = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            mutex2.releaseObjIDForUpdate(storage.getId().toString() + "completeBackFlush");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected BatchExecuteResult _backFlush(Context ctx, String[] ids, BillTypeInfo billtype, String storageId) throws BOSException, EASBizException {
        boolean isSucceed = false;
        IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        isSucceed = "HxPKDRdzRpaqr31LD+3SBEY+1VI=".equals(billtype.getId().toString()) ? mutex.requestObjIDForUpdate(storageId + "completeBackFlush", ctx.getCaller().toString(), Uuid.create()) : mutex.requestObjIDForUpdate(storageId + "instockBackFlush", ctx.getCaller().toString(), Uuid.create());
        if (isSucceed) {
            try {
                IManufactureOrder orderInterface = ManufactureOrderFactory.getLocalInstance((Context)ctx);
                BatchExecuteResult batchExecuteResult = orderInterface.materialBackFlush(ids, billtype);
                return batchExecuteResult;
            }
            finally {
                if ("HxPKDRdzRpaqr31LD+3SBEY+1VI=".equals(billtype.getId().toString())) {
                    mutex.releaseObjIDForUpdate(storageId + "completeBackFlush");
                } else {
                    mutex.releaseObjIDForUpdate(storageId + "instockBackFlush");
                }
            }
        }
        if ("HxPKDRdzRpaqr31LD+3SBEY+1VI=".equals(billtype.getId().toString())) {
            throw new SfcException(SfcException.COMPLEBACKFLUSHEXISTS);
        }
        throw new SfcException(SfcException.INSTOCKBACKFLUSHEXISTS);
    }
}

