/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.sfc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.IBOSObject;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationEntryInfo;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.log.app.adapter.LogControllManager;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.basedata.WorkCenterInfo;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsInfo;
import com.kingdee.eas.mm.sfc.AbstractDisTaskDispatchInfo;
import com.kingdee.eas.mm.sfc.DisTaskDispatchEntryInfo;
import com.kingdee.eas.mm.sfc.DisTaskDispatchFactory;
import com.kingdee.eas.mm.sfc.DisTaskDispatchInfo;
import com.kingdee.eas.mm.sfc.OutOfAssignQtyLimitException;
import com.kingdee.eas.mm.sfc.RowStatusEnum;
import com.kingdee.eas.mm.sfc.TechnicslayerEnum;
import com.kingdee.eas.mm.sfc.app.AbstractPACBuildFacadeControllerBean;
import com.kingdee.eas.mm.sfc.app.AbstractPACSchedule;
import com.kingdee.eas.mm.sfc.app.PACBackwardOfSchedule;
import com.kingdee.eas.mm.sfc.app.PACBwdWithoutRepOfSchedule;
import com.kingdee.eas.mm.sfc.app.PACForwardOfSchedule;
import com.kingdee.eas.mm.sfc.app.PACFwdWithoutRepOfSchedule;
import com.kingdee.eas.mm.sfc.app.PACKeyOperationOfSchedule;
import com.kingdee.eas.mm.sfc.app.PACNoSchedule;
import com.kingdee.eas.mm.sfc.app.PACOperationChecker;
import com.kingdee.eas.mm.sfc.app.pac.CalcBurthenUtil;
import com.kingdee.eas.mm.sfc.app.pac.WorkCenterTreeNodeBuilder;
import com.kingdee.eas.mm.sfc.util.pac.AverageAssignTaskImpl;
import com.kingdee.eas.mm.sfc.util.pac.PACUtil;
import com.kingdee.eas.mm.sfc.util.pac.TaskAssignResult;
import com.kingdee.eas.scm.common.SCMBillParamFactory;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PACBuildFacadeControllerBean
extends AbstractPACBuildFacadeControllerBean {
    private static final long serialVersionUID = 8203604416636019973L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.sfc.app.PACBuildFacadeControllerBean");
    private BillTypeInfo billType;
    private BillTypeInfo sourceBillType;
    private Map dispatchMappings;
    private String[] exPropertiesName;
    private static final Class[] PK_TYPE = new Class[]{IObjectPK.class};

    public BatchExecuteResult batchExecute(Context ctx, String name, Class[] paramTypes, BatchExecuteParamsEntry[] paramEntries) throws BaseException {
        if (name.equalsIgnoreCase("releaseMO")) {
            return ManufactureOrderFactory.getLocalInstance((Context)ctx).batchExecute("released", new Class[]{IObjectPK.class}, paramEntries);
        }
        return super.batchExecute(ctx, name, paramTypes, paramEntries);
    }

    public BatchActionResults batchSave(Context ctx, BatchExecuteParamsEntry[] entries) throws BOSException, EASBizException {
        BatchActionResults batchResults = BatchActionResults.populateActionResults((BatchExecuteParamsEntry[])entries);
        String id = null;
        ManufactureOrderTechnicsInfo paramValue = null;
        ManufactureOrderTechnicsInfo info = null;
        Connection cn = null;
        IORMappingDAO idao = null;
        IORMappingDAO iMoDao = null;
        try {
            cn = this.getConnection(ctx);
            idao = ORMappingDAO.getInstance((BOSObjectType)BOSObjectType.create((String)"9A3656FE"), (Context)ctx, (Connection)cn);
            iMoDao = ORMappingDAO.getInstance((BOSObjectType)BOSObjectType.create((String)"1D0D80DD"), (Context)ctx, (Connection)cn);
            BatchExecuteParamsEntry[] paramEntries = batchResults.getParamEntries();
            HashMap<String, ManufactureOrderTechnicsInfo> paramMap = new HashMap<String, ManufactureOrderTechnicsInfo>();
            HashMap<Object, Timestamp[]> endDateMap = new HashMap<Object, Timestamp[]>();
            int n = paramEntries.length;
            for (int i = 0; i < n; ++i) {
                String temp;
                paramValue = (ManufactureOrderTechnicsInfo)paramEntries[i].get(0);
                Timestamp[] dateArray = new Timestamp[]{(Timestamp)paramValue.get("planBeginDate"), (Timestamp)paramValue.get("planEndDate")};
                endDateMap.put(paramValue.get("parentId"), dateArray);
                paramMap.put(paramValue.getId().toString(), paramValue);
                if (this.exPropertiesName != null || (temp = paramValue.getExtendedProperty("exPropertiesName")) == null) continue;
                this.exPropertiesName = temp.split(";");
            }
            Set set = endDateMap.entrySet();
            Iterator it = set.iterator();
            String s = " update T_MM_ManufactureOrder set FPlanBeginDate = ?, FPlanEndDate=? where fid=? ";
            ArrayList<Object[]> list = null;
            while (it.hasNext()) {
                if (list == null) {
                    list = new ArrayList<Object[]>();
                }
                Map.Entry entry = it.next();
                String moid = (String)entry.getKey();
                Timestamp[] dates = (Timestamp[])entry.getValue();
                list.add(new Object[]{dates[0], dates[1], moid});
            }
            DbUtil.executeBatch((Context)ctx, (String)s, list);
            CoreBaseCollection coll = ManufactureOrderTechnicsFactory.getLocalInstance((Context)ctx).getCollection(this.getEntityView4BatchSave(batchResults.getToDoIdsSet()));
            int n2 = coll.size();
            for (int i = 0; i < n2; ++i) {
                boolean isSame = true;
                info = (ManufactureOrderTechnicsInfo)coll.get(i);
                id = info.getId().toString();
                paramValue = (ManufactureOrderTechnicsInfo)paramMap.get(id);
                Enumeration keys = paramValue.keys();
                while (keys.hasMoreElements()) {
                    String property = (String)keys.nextElement();
                    if (!this.isDiffrent(info.get(property), paramValue.get(property))) continue;
                    isSame = false;
                    break;
                }
                if (isSame) continue;
                idao.updateBatch((IObjectPK)new ObjectUuidPK(id), (IObjectValue)paramValue);
            }
            idao.executeBatch();
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw e;
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
        return batchResults;
    }

    private EntityViewInfo getEntityView4BatchSave(Set idsSet) {
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)idsSet, CompareType.INCLUDE));
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("adminOrgUnit.id"));
        view.getSelector().add(new SelectorItemInfo("workCenter.id"));
        view.getSelector().add(new SelectorItemInfo("isKeyOP"));
        view.getSelector().add(new SelectorItemInfo("earlistWoktime"));
        view.getSelector().add(new SelectorItemInfo("earlistCmpTime"));
        view.getSelector().add(new SelectorItemInfo("lastWorktime"));
        view.getSelector().add(new SelectorItemInfo("lastCmpTime"));
        view.getSelector().add(new SelectorItemInfo("remark"));
        view.getSelector().add(new SelectorItemInfo("queuingTime"));
        view.getSelector().add(new SelectorItemInfo("prepareTime"));
        view.getSelector().add(new SelectorItemInfo("workTime"));
        view.getSelector().add(new SelectorItemInfo("waitingTime"));
        view.getSelector().add(new SelectorItemInfo("movingTime"));
        view.getSelector().add(new SelectorItemInfo("operationRemark"));
        if (this.exPropertiesName != null && this.exPropertiesName.length > 0) {
            int n = this.exPropertiesName.length;
            for (int i = 0; i < n; ++i) {
                view.getSelector().add(new SelectorItemInfo(this.exPropertiesName[i]));
            }
        }
        return view;
    }

    private boolean isDiffrent(Object arg0, Object arg1) {
        if (arg0 == null && arg1 == null) {
            return false;
        }
        boolean isChanged = true;
        if (arg0 != null && arg1 != null) {
            isChanged = arg0 instanceof CoreBaseInfo && arg1 instanceof CoreBaseInfo ? !((CoreBaseInfo)arg0).getId().toString().equals(((CoreBaseInfo)arg1).getId().toString()) : (arg0 instanceof BOSUuid && arg1 instanceof String ? !arg0.toString().equals(arg1) : !arg0.equals(arg1));
        }
        return isChanged;
    }

    @Override
    protected Map _getDispatchTime(Context ctx, Map param) throws BOSException {
        List technicsList = (List)param.get("technicsList");
        String getDispatchTimeType = (String)param.get("getDispatchTimeType");
        if (technicsList == null || technicsList.size() < 1) {
            return null;
        }
        StringBuffer sql = new StringBuffer("");
        sql.append("select mftot.fid  technicsid,");
        if ("10".equals(getDispatchTimeType)) {
            sql.append("min(dtde.FEarlistWoktime) workTime,").append("min(dtde.fEarlistCmptime) cmpTime");
        } else {
            sql.append("max(dtde.FLastWorktime) workTime,").append("max(dtde.fLastCmptime) cmpTime ");
        }
        sql.append(" from T_MM_DisTaskDispatchentry dtde ").append(" inner join T_MM_MFTOrderTechnics mftot on mftot.fid = dtde.fsourcebillentryid ").append(" where mftot.fid  in ( ").append(SQLUtil.arrayToString((Object[])technicsList.toArray())).append(") ").append(" group by mftot.fid  ");
        ArrayList paramLst = new ArrayList();
        paramLst.clear();
        IRowSet rs = null;
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])paramLst.toArray());
        if (rs.size() < 1) {
            return null;
        }
        HashMap<String, Timestamp[]> resultMap = new HashMap<String, Timestamp[]>();
        try {
            while (rs.next()) {
                Timestamp[] times = new Timestamp[2];
                if (rs.getString("workTime") != null) {
                    times[0] = Timestamp.valueOf(rs.getString("workTime"));
                }
                if (rs.getString("cmpTime") != null) {
                    times[1] = Timestamp.valueOf(rs.getString("cmpTime"));
                }
                resultMap.put(rs.getString("technicsid"), times);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return resultMap;
    }

    @Override
    protected Map _processSchedule(Context ctx, Map param) throws BOSException, EASBizException {
        String model = (String)param.get("model");
        AbstractPACSchedule Scheduler = null;
        Map result = new HashMap();
        Scheduler = "ForwardSchedule".equalsIgnoreCase(model) ? new PACForwardOfSchedule() : ("BackwardSchedule".equalsIgnoreCase(model) ? new PACBackwardOfSchedule() : ("FirstSchedule".equalsIgnoreCase(model) ? new PACFwdWithoutRepOfSchedule() : ("LastSchedule".equalsIgnoreCase(model) ? new PACBwdWithoutRepOfSchedule() : ("KeySchedule".equalsIgnoreCase(model) ? new PACKeyOperationOfSchedule() : ("NoSchedule".equalsIgnoreCase(model) ? new PACNoSchedule() : new PACNoSchedule())))));
        param.put("ctx", ctx);
        try {
            result = Scheduler.schedule(param);
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return result;
    }

    @Override
    protected List _assignTask(Context ctx, Map assignDatas, List assignParams) throws BOSException, EASBizException {
        AverageAssignTaskImpl iTaskAssign = new AverageAssignTaskImpl(ctx);
        return iTaskAssign.executeAssign(assignDatas, assignParams);
    }

    @Override
    protected List _getWorkCenterChildren(Context ctx, IObjectValue workOrg, IObjectValue workDept, FilterInfo filter) throws BOSException, EASBizException {
        WorkCenterTreeNodeBuilder builder = new WorkCenterTreeNodeBuilder(ctx);
        return builder.getWorkCenterChildren(workOrg, workDept, filter);
    }

    private boolean isOutOfAssignQtyLimit(Context ctx, List assignResults) throws BOSException, OutOfAssignQtyLimitException {
        Iterator it = assignResults.iterator();
        HashMap<String, BigDecimal> technicsMap = new HashMap<String, BigDecimal>();
        HashMap<String, TaskAssignResult> technicsInfoMap = new HashMap<String, TaskAssignResult>();
        ArrayList<String> technicsList = new ArrayList<String>();
        while (it.hasNext()) {
            TaskAssignResult result = (TaskAssignResult)it.next();
            BigDecimal assignQty = result.getAssignQty();
            ManufactureOrderTechnicsInfo technicsInfo = result.getTechnicsInfo();
            String technicsId = technicsInfo.getId().toString();
            technicsList.add(technicsId);
            if (!technicsInfoMap.containsKey(technicsId)) {
                technicsInfoMap.put(technicsId, result);
            }
            if (technicsMap.containsKey(technicsId)) {
                technicsMap.put(technicsId, ((BigDecimal)technicsMap.get(technicsId)).add(assignQty));
                continue;
            }
            technicsMap.put(technicsId, assignQty);
        }
        Map TechnicsAssignMap = this.getTechnicsAssignQty(ctx, technicsList);
        Set set = TechnicsAssignMap.entrySet();
        Iterator iter = set.iterator();
        StringBuffer msgStr = new StringBuffer();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (!technicsMap.containsKey(entry.getKey()) || ((BigDecimal)technicsMap.get(entry.getKey())).compareTo((BigDecimal)entry.getValue()) <= 0) continue;
            TaskAssignResult info = (TaskAssignResult)technicsInfoMap.get(entry.getKey());
            throw new OutOfAssignQtyLimitException(OutOfAssignQtyLimitException.OUTOFASSIGNQTYLIMIT, new Object[]{info.getManufactureOrder().getNumber(), String.valueOf(info.getTechnicsInfo().getOperationNo())});
        }
        return true;
    }

    private Map getTechnicsAssignQty(Context ctx, List technicsList) throws BOSException {
        StringBuffer sql = new StringBuffer("");
        sql.append("select m.fid technicsid ,(m.fqty - m.fTotalSplitQty - r.qty) qty, m.FFinishedQty FinishedQty ").append("from T_MM_MFTOrderTechnics m ").append(" join (select mftot.fid  technicsid,dtde.frowstatus,dtd.fbasestatus, isnull(sum(dtde.fqty),0) qty  from  T_MM_MFTOrderTechnics mftot ").append(" left join T_MM_DisTaskDispatchentry dtde on mftot.fid = dtde.fsourcebillentryid ").append(" left join t_MM_DisTaskDispatch dtd on dtd.fid = dtde.fparentid ").append(" where mftot.fid  in ( ").append(SQLUtil.arrayToString((Object[])technicsList.toArray())).append(")  ").append(" group by mftot.fid,dtde.frowstatus,dtd.fbasestatus) r on r.technicsid = m.fid  ").append(" where (r.frowstatus <>30 or r.frowstatus is null) and (r.fbasestatus=4 or r.fbasestatus is null) ");
        ArrayList paramLst = new ArrayList();
        paramLst.clear();
        IRowSet rs = null;
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])paramLst.toArray());
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        if (rs.size() < 1) {
            return resultMap;
        }
        try {
            while (rs.next()) {
                resultMap.put(rs.getString("technicsid"), rs.getBigDecimal("qty"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return resultMap;
    }

    @Override
    protected Map _genTaskDispatch(Context ctx, List assignResults) throws BOSException, EASBizException {
        this.dispatchMappings = new HashMap();
        String orgUnitID = ((TaskAssignResult)assignResults.get(0)).getTechnicsInfo().getStorageOrgUnit().getId().toString();
        this.isOutOfAssignQtyLimit(ctx, assignResults);
        boolean isAutoAudit = false;
        String strAutoAudit = SCMBillParamFactory.getLocalInstance((Context)ctx).getParamByBillTypeID("MM_Submit_02", 4, orgUnitID, "kL66w+DkkMDgQAB/AQATJEY+1VI=");
        if (!StringUtils.isEmpty((String)strAutoAudit) && strAutoAudit.trim().toLowerCase().equals("1")) {
            isAutoAudit = true;
        }
        this.billType = new BillTypeInfo();
        this.sourceBillType = new BillTypeInfo();
        this.billType.setId(BOSUuid.read((String)"kL66w+DkkMDgQAB/AQATJEY+1VI="));
        this.sourceBillType.setId(BOSUuid.read((String)"B2aZSVXaSx6qxdfekgCmrEY+1VI="));
        LogControllManager.getInstance().disableLog();
        ServiceStateManager.getInstance().disableNextCallService("PERMISSION_SERVICE");
        IObjectPK[] toDoPkArray = this.submitTargetBills(ctx, this.genTargetBill(assignResults));
        if (!isAutoAudit) {
            this.auditTargetBills(ctx, toDoPkArray);
        }
        LogControllManager.getInstance().enableLog();
        ServiceStateManager.getInstance().enableNextCallService("PERMISSION_SERVICE");
        return this.dispatchMappings;
    }

    private IObjectPK[] submitTargetBills(Context ctx, Map billMap) throws BOSException, EASBizException {
        Class[] parameTypes = new Class[]{CoreBillBaseInfo.class, BOTRelationCollection.class};
        ArrayList<BatchExecuteParamsEntry> toDoParams = new ArrayList<BatchExecuteParamsEntry>();
        AbstractDisTaskDispatchInfo targetBill = null;
        for (Map.Entry entry : billMap.entrySet()) {
            targetBill = (DisTaskDispatchInfo)entry.getValue();
            BOTRelationCollection relations = this.genDestBillBOTPRelations(ctx, (DisTaskDispatchInfo)targetBill);
            BatchExecuteParamsEntry paramEntry = new BatchExecuteParamsEntry(parameTypes);
            paramEntry.add((Object)targetBill).add((Object)relations);
            toDoParams.add(paramEntry);
        }
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        boolean exist = iCodingRuleManager.isExist((IObjectValue)targetBill, targetBill.getStorageOrgUnit().getId().toString());
        if (!exist) {
            String entityName = "";
            entityName = this.getMetaInfo(ctx, (IObjectValue)targetBill).getAlias(ctx.getLocale());
            throw new CodingRuleException(CodingRuleException.ERROR_CR_NOTEXIST, new Object[]{entityName});
        }
        BatchExecuteParamsEntry[] paramEntries = toDoParams.toArray(new BatchExecuteParamsEntry[0]);
        try {
            BatchExecuteResult executeResult = DisTaskDispatchFactory.getLocalInstance(ctx).batchExecute("submitRelations", parameTypes, paramEntries);
            BatchActionResults actionResults = (BatchActionResults)executeResult.getBatchResult();
            return actionResults.getToDoPkArray();
        }
        catch (BaseException e) {
            e.printStackTrace();
            return null;
        }
    }

    private EntityObjectInfo getMetaInfo(Context ctx, IObjectValue caller) {
        IMetaDataLoader metaLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo eo = null;
        if (caller != null) {
            eo = metaLoader.getEntity(caller.getBOSType());
        }
        return eo;
    }

    private void auditTargetBills(Context ctx, IObjectPK[] toDoPkArray) {
        ArrayList<BatchExecuteParamsEntry> toDoParams = new ArrayList<BatchExecuteParamsEntry>();
        int n = toDoPkArray.length;
        for (int i = 0; i < n; ++i) {
            BatchExecuteParamsEntry paramEntry = new BatchExecuteParamsEntry(PK_TYPE);
            paramEntry.add((Object)toDoPkArray[i]);
            toDoParams.add(paramEntry);
        }
        BatchExecuteParamsEntry[] paramEntries = toDoParams.toArray(new BatchExecuteParamsEntry[0]);
        try {
            BatchExecuteResult executeResult = DisTaskDispatchFactory.getLocalInstance(ctx).batchExecute("audit", PK_TYPE, paramEntries);
            BatchActionResults batchActionResults = (BatchActionResults)executeResult.getBatchResult();
        }
        catch (BaseException e) {
            e.printStackTrace();
        }
    }

    private BOTRelationCollection genDestBillBOTPRelations(Context ctx, DisTaskDispatchInfo destBill) {
        HashMap<String, BOTRelationInfo> map = new HashMap<String, BOTRelationInfo>();
        BOTRelationCollection relations = new BOTRelationCollection();
        Iterator ite = destBill.getEntrys().iterator();
        while (ite.hasNext()) {
            BOTRelationInfo botRelationInfo;
            DisTaskDispatchEntryInfo billEntry = (DisTaskDispatchEntryInfo)ite.next();
            String key = billEntry.getSourceBillId();
            if (map.containsKey(key)) {
                botRelationInfo = (BOTRelationInfo)map.get(key);
            } else {
                botRelationInfo = new BOTRelationInfo();
                botRelationInfo.setId(BOSUuid.create((BOSObjectType)botRelationInfo.getBOSType()));
                botRelationInfo.setDestEntityID("6F0D8519");
                botRelationInfo.setDestObjectID(destBill.getId().toString());
                botRelationInfo.setSrcEntityID("1D0D80DD");
                botRelationInfo.setSrcObjectID(billEntry.getSourceBillId());
                botRelationInfo.setType(0);
                botRelationInfo.setOperatorID(ctx.getUserName());
                botRelationInfo.setBOTMappingID("ZbPMSXhIRSysmga4QY83XgRRIsQ=");
                botRelationInfo.setDate(new Date());
            }
            BOTRelationEntryInfo botRelationEntryInfo = new BOTRelationEntryInfo();
            botRelationEntryInfo.setDestEntryID(billEntry.getId().toString());
            botRelationEntryInfo.setDestEntryPropName("__dest.entrys");
            botRelationEntryInfo.setDestPropertyName("");
            botRelationEntryInfo.setDestObjectID(botRelationInfo.getDestObjectID());
            botRelationEntryInfo.setSrcEntryID(billEntry.getSourceBillEntryId());
            botRelationEntryInfo.setSrcObjectID(botRelationInfo.getSrcObjectID());
            botRelationEntryInfo.setSrcEntryPropName("__src.technics");
            botRelationEntryInfo.setSrcPropertyName("");
            botRelationInfo.getRelationEntries().add(botRelationEntryInfo);
            map.put(key, botRelationInfo);
        }
        for (Map.Entry entry : map.entrySet()) {
            relations.add((BOTRelationInfo)entry.getValue());
        }
        return relations;
    }

    private Map genTargetBill(List assignResults) {
        HashMap<String, DisTaskDispatchInfo> map = new HashMap<String, DisTaskDispatchInfo>();
        int n = assignResults.size();
        for (int i = 0; i < n; ++i) {
            DisTaskDispatchInfo targetBill;
            TaskAssignResult result = (TaskAssignResult)assignResults.get(i);
            String workCenterId = result.getWorkCenter().getId().toString();
            String equipmentId = result.getEquipment() != null ? result.getEquipment().getId().toString() : "null";
            String classGroupId = result.getClassGroup() != null ? result.getClassGroup().getId().toString() : "null";
            String classTeamId = result.getClassTeam() != null ? result.getClassTeam().getId().toString() : "null";
            String classTeamEntryId = result.getClassTeamEntry() != null ? result.getClassTeamEntry().getId().toString() : "null";
            String disTaskPersonIds = result.getDisTaskPersonIds();
            String serialNumber = result.getSerialNumber();
            String key = workCenterId + "$" + equipmentId + "$" + classGroupId + "$" + classTeamId + "$" + classTeamEntryId + "$" + disTaskPersonIds + "$" + serialNumber;
            if (map.containsKey(key)) {
                targetBill = (DisTaskDispatchInfo)map.get(key);
                targetBill.getEntrys().add(this.genBillEntry(result));
            } else {
                targetBill = this.genBillHead(result);
            }
            this.dispatchMappings.put(result.getId(), targetBill.getId().toString());
            map.put(key, targetBill);
        }
        return map;
    }

    private DisTaskDispatchInfo genBillHead(TaskAssignResult result) {
        DisTaskDispatchInfo billHead = new DisTaskDispatchInfo();
        billHead.setId(BOSUuid.create((BOSObjectType)billHead.getBOSType()));
        billHead.setStorageOrgUnit(result.getTechnicsInfo().getStorageOrgUnit());
        billHead.setAdminOrgUnit(result.getTechnicsInfo().getAdminOrgUnit());
        if (billHead.getPlanBeginDate() == null || billHead.getPlanBeginDate().compareTo(result.getBeginDate()) > 0) {
            billHead.setPlanBeginDate(result.getBeginDate());
        }
        if (billHead.getPlanEndDate() == null || billHead.getPlanEndDate().compareTo(result.getEndDate()) < 0) {
            billHead.setPlanEndDate(result.getEndDate());
        }
        billHead.setWorkCenter(result.getWorkCenter());
        billHead.setEquipment(result.getEquipment());
        billHead.setClassGroup(result.getClassGroup());
        billHead.setClassTeam(result.getClassTeam());
        billHead.setClassTeamEntry(result.getClassTeamEntry());
        billHead.setDisTaskPersonIds("null".equals(result.getDisTaskPersonIds()) ? null : result.getDisTaskPersonIds());
        billHead.setDisTaskPersonNumbers("null".equals(result.getDisTaskPersonNumbers()) ? null : result.getDisTaskPersonNumbers());
        billHead.setDisTaskPersonNames("null".equals(result.getDisTaskPersonNames()) ? null : result.getDisTaskPersonNames());
        billHead.setIsEntrust(false);
        billHead.setSourceBillType(this.sourceBillType);
        billHead.setBillType(this.billType);
        billHead.setBizDate(new Date());
        billHead.getEntrys().add(this.genBillEntry(result));
        return billHead;
    }

    private DisTaskDispatchEntryInfo genBillEntry(TaskAssignResult result) {
        DisTaskDispatchEntryInfo billEntry = new DisTaskDispatchEntryInfo();
        billEntry.setId(BOSUuid.create((BOSObjectType)billEntry.getBOSType()));
        billEntry.setProject(result.getManufactureOrder().getProject());
        billEntry.setTrackNumber(result.getManufactureOrder().getTrackNumber());
        billEntry.setMaterial(result.getManufactureOrder().getMaterial());
        billEntry.setUnit(result.getManufactureOrder().getUnit());
        billEntry.setLot(result.getManufactureOrder().getLot());
        billEntry.setManufactureOrder(result.getManufactureOrder());
        billEntry.setOperationNumber(new BigDecimal(result.getTechnicsInfo().getOperationNo()));
        billEntry.setOperation(result.getTechnicsInfo().getOperation());
        billEntry.setWorkCenter(result.getWorkCenter());
        billEntry.setRouting(result.getManufactureOrder().getRouting());
        billEntry.setQty(result.getAssignQty());
        billEntry.setTechnicsLayer(TechnicslayerEnum.FIRST);
        billEntry.setIsReportPoint(result.getTechnicsInfo().isIsReportPoint());
        billEntry.setIsCheckPoint(result.getTechnicsInfo().isIsCheckPoint());
        billEntry.setIsKeyOP(result.getTechnicsInfo().isIsKeyOP());
        billEntry.setEarlistWoktime(result.getWorkBeginTime());
        billEntry.setEarlistCmpTime(result.getWorkEndTime());
        billEntry.setLastWorktime(result.getWorkBeginTime());
        billEntry.setLastCmpTime(result.getWorkEndTime());
        billEntry.setWorkTime(result.getTechnicsInfo().getWorkTime());
        billEntry.setTimeUnit(result.getTechnicsInfo().getTimeUnit());
        billEntry.setRowStatus(RowStatusEnum.NATURAL);
        billEntry.setBaseUnit(result.getTechnicsInfo().getBaseUnit());
        billEntry.setBaseQty(this.calcBaseUnitQty(result.getAssignQty(), result.getTechnicsInfo().getQty(), result.getTechnicsInfo().getBaseQty(), result.getBaseQtyPrecision()));
        billEntry.setSourceBillId(result.getManufactureOrder().getId().toString());
        billEntry.setSourceBillEntryId(result.getTechnicsInfo().getId().toString());
        billEntry.setSourceBillEntrySeq(result.getTechnicsInfo().getSeq());
        billEntry.setSourceBillNumber(result.getManufactureOrder().getNumber());
        billEntry.setSourceBillType(this.sourceBillType);
        return billEntry;
    }

    private BigDecimal calcBaseUnitQty(BigDecimal calcQty, BigDecimal qty, BigDecimal baseQty, int baseQtyPrecision) {
        return calcQty.multiply(baseQty).divide(qty, baseQtyPrecision, 4);
    }

    protected void saveTargetBill(Context ctx, CoreBillBaseInfo model, BOTRelationCollection relations) throws EASBizException, BOSException {
        LogControllManager.getInstance().disableLog();
        ServiceStateManager.getInstance().disableNextCallService("PERMISSION_SERVICE");
        LogControllManager.getInstance().disableLog();
        ServiceStateManager.getInstance().disableNextCallService("LOG_SERVICE");
        try {
            IBOSObject obj = BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)model.getBOSType());
            ICoreBillBase iBillBase = (ICoreBillBase)obj;
            iBillBase.saveRelations(model, relations);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            throw e;
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw e;
        }
        LogControllManager.getInstance().enableLog();
        ServiceStateManager.getInstance().enableNextCallService("PERMISSION_SERVICE");
        LogControllManager.getInstance().enableLog();
        ServiceStateManager.getInstance().enableNextCallService("LOG_SERVICE");
    }

    @Override
    protected BigDecimal[] _getDispatchedBurthen(Context ctx, IObjectValue workCenter, String orgID, Timestamp beginDate, BigDecimal estimatedDays) throws BOSException, EASBizException {
        BigDecimal[] result = new BigDecimal[2];
        WorkCenterInfo info = (WorkCenterInfo)workCenter;
        Timestamp date = PACUtil.addTime(beginDate, estimatedDays.doubleValue() * 24.0);
        Timestamp endDate = PACUtil.resetTimeForEndDate(new Timestamp(((Date)date).getTime()));
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)this.getDispatchBurthenSql(), (Object[])new Object[]{info.getId().toString(), beginDate, beginDate, endDate, endDate, beginDate, endDate});
        BigDecimal burthen = SCMConstant.BIGDECIMAL_ZERO;
        try {
            while (rows.next()) {
                burthen = burthen.add(this.getBurthenFromRowSet(beginDate, endDate, rows));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        result[0] = burthen;
        result[1] = new BigDecimal(this.getWorkDays(ctx, endDate, beginDate, orgID));
        this.updateEstimatedDays(ctx, info.getId().toString(), estimatedDays);
        return result;
    }

    private BigDecimal getBurthenFromRowSet(Timestamp beginDate, Timestamp endDate, IRowSet rows) throws SQLException {
        BigDecimal qty = rows.getBigDecimal("Qty");
        int timeUnit = rows.getInt("FTimeUnit");
        BigDecimal prepareTime = rows.getBigDecimal("FPrepareTime");
        BigDecimal workTime = rows.getBigDecimal("FWorkTime");
        BigDecimal processBatch = rows.getBigDecimal("FProcessBatch");
        Timestamp beginWorkTime = rows.getTimestamp("FEarlistWoktime");
        Timestamp cmpWorkTime = rows.getTimestamp("FEarlistCmpTime");
        return CalcBurthenUtil.getBurthenResult(beginDate, endDate, beginWorkTime, cmpWorkTime, qty, timeUnit, prepareTime, workTime, processBatch);
    }

    private String getDispatchBurthenSql() {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT T2.FEarlistWoktime,T2.FEarlistCmpTime,T3.FProcessBatch,T3.FTimeUnit,T3.FPrepareTime,T3.FWorkTime,T2.FUNITID,T2.FQty-T2.FFinishedQty AS Qty ");
        sb.append("FROM T_MM_DISTASKDISPATCH T1 INNER JOIN T_MM_DISTASKDISPATCHENTRY T2 ON T1.FId = T2.FParentId AND T2.FQty-T2.FFinishedQty > 0 ");
        sb.append("INNER JOIN T_MM_MFTOrderTechnics T3 ON T2.FSourceBillEntryId = T3.FId ");
        sb.append("WHERE T1.FWorkCenterID = ? AND ((T2.FEarlistWoktime <= ? AND T2.FEarlistCmpTime >= ?) OR (T2.FEarlistWoktime <= ? AND T2.FEarlistCmpTime >= ?) OR (T2.FEarlistWoktime >= ? AND T2.FEarlistCmpTime <= ?)) ");
        sb.append("AND T1.FBaseStatus = 4 AND T2.FRowStatus = 10 ");
        return sb.toString();
    }

    @Override
    protected List _checkOperation(Context ctx, Map param) throws BOSException {
        String orgId = (String)param.get("orgId");
        List technicsList = (List)param.get("technicsList");
        String getDispatchTimeType = (String)param.get("getDispatchTimeType");
        PACOperationChecker checker = new PACOperationChecker(orgId);
        return checker.check(ctx, technicsList, getDispatchTimeType);
    }

    @Override
    protected void _save(Context ctx, IObjectValue moTechnicsInfo) throws BOSException, EASBizException {
    }

    protected void _releaseMO(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
    }

    private int getWorkDateSeq(Context ctx, Date startDate, String storageOrgUnitId) throws BOSException {
        int workSeq = 0;
        if (storageOrgUnitId == null || storageOrgUnitId.trim().length() == 0) {
            return workSeq;
        }
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(ctx);
            StringBuffer strBuffSql = new StringBuffer("select max(ce.fworkdateseq) as fworkdateseq from T_MM_FactoryCalendar c right join t_Mm_Factorycalendarentry ce on c.fid=ce.fparentid where ce.fdatetype=1 and c.fstorageorgunitid='");
            strBuffSql.append(storageOrgUnitId);
            strBuffSql.append("'");
            if (startDate != null) {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                String time = df.format(startDate);
                strBuffSql.append(" and ce.FWorkDate<={d'" + time + "'}");
            }
            ps = con.prepareStatement(strBuffSql.toString());
            strBuffSql = null;
            rs = ps.executeQuery();
            if (rs.next()) {
                workSeq = rs.getInt("FWorkDateSeq");
            }
        }
        catch (SQLException er) {
            try {
                throw new BOSException("sql Execute Error :", (Throwable)er);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup(ps, (Connection)con);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Statement)ps, (Connection)con);
        SQLUtils.cleanup((Connection)con);
        return workSeq;
    }

    private int getWorkDays(Context ctx, Date startDate, Date endDate, String storageOrgUnitId) throws BOSException {
        return this.getWorkDateSeq(ctx, startDate, storageOrgUnitId) - this.getWorkDateSeq(ctx, endDate, storageOrgUnitId);
    }

    protected void updateEstimatedDays(Context ctx, String workCenterId, BigDecimal estimatedDays) throws BOSException, EASBizException {
        if (workCenterId == null || estimatedDays == null) {
            return;
        }
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("update T_MM_WORKCENTER ").append("set FESTIMATEDDAYS").append(" = ? ").append("where FID = ? ");
        DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{estimatedDays, workCenterId});
    }

    @Override
    protected Map _getPeriodDayPoints(Context ctx, String storageOrgUnitId, Timestamp startDate, Timestamp endDate) throws BOSException {
        HashMap<String, BigDecimal> hashMap;
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        try {
            con = this.getConnection(ctx);
            StringBuffer strBuffSql = new StringBuffer("select c.fstorageorgunitid as fstorageorgunitid, ce.FWorkDate as fworkdate ,ce.fworkdateseq as fworkdateseq from T_MM_FactoryCalendar c right join t_Mm_Factorycalendarentry ce on c.fid=ce.fparentid where ce.fdatetype=1 and c.fstorageorgunitid in (");
            strBuffSql.append(storageOrgUnitId);
            strBuffSql.append(")");
            if (startDate != null) {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                String startTime = df.format(startDate);
                String endTime = df.format(endDate);
                strBuffSql.append(" and ce.FWorkDate>={d'" + startTime + "'}").append(" and ce.FWorkDate<={d'" + endTime + "'}");
            }
            ps = con.prepareStatement(strBuffSql.toString());
            strBuffSql = null;
            rs = ps.executeQuery();
            while (rs.next()) {
                resultMap.put(rs.getString("fstorageorgunitid") + PACUtil.resetTimeForBeginDate(rs.getTimestamp("fworkdate")).toString(), rs.getBigDecimal("fworkdateseq"));
            }
            hashMap = resultMap;
        }
        catch (SQLException er) {
            try {
                throw new BOSException("sql Execute Error :", (Throwable)er);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup(ps, (Connection)con);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Statement)ps, (Connection)con);
        SQLUtils.cleanup((Connection)con);
        return hashMap;
    }
}

