/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.sfc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsInfo;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PACOperationChecker {
    private String orgId;

    public PACOperationChecker(String orgId) {
        this.orgId = orgId;
    }

    public List check(Context ctx, List technicsList, String getDispatchTimeType) throws BOSException {
        Map technicsMap = this.getTechnicsMap(ctx, technicsList);
        Set technicsSet = technicsMap.entrySet();
        Iterator it = technicsSet.iterator();
        ArrayList<String> resultList = new ArrayList<String>();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            List technicsTempList = (List)entry.getValue();
            int n = technicsTempList.size();
            for (int i = 0; i < n; ++i) {
                ManufactureOrderTechnicsInfo nextInfo;
                ManufactureOrderTechnicsInfo info = (ManufactureOrderTechnicsInfo)technicsTempList.get(i);
                if (getDispatchTimeType.equals("10")) {
                    if (!this.checkEarlistTime(info)) {
                        resultList.add(info.getId().toString());
                        continue;
                    }
                } else if (!this.checkLastTime(info)) {
                    resultList.add(info.getId().toString());
                    continue;
                }
                if (!this.checkOrderTime(info, getDispatchTimeType)) {
                    resultList.add(info.getId().toString());
                    continue;
                }
                if (i == n - 1 || this.checkNextOperation(info, nextInfo = (ManufactureOrderTechnicsInfo)technicsTempList.get(i + 1), getDispatchTimeType)) continue;
                resultList.add(info.getId().toString());
            }
        }
        return resultList;
    }

    private boolean checkEarlistTime(ManufactureOrderTechnicsInfo info) {
        Timestamp startTime = info.getEarlistWoktime();
        Timestamp endTime = info.getEarlistCmpTime();
        if (startTime == null || endTime == null) {
            return true;
        }
        return endTime.compareTo(startTime) >= 0;
    }

    private boolean checkLastTime(ManufactureOrderTechnicsInfo info) {
        Timestamp startTime = info.getLastWorktime();
        Timestamp endTime = info.getLastCmpTime();
        if (startTime == null || endTime == null) {
            return true;
        }
        return endTime.compareTo(startTime) >= 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkOrderTime(ManufactureOrderTechnicsInfo info, String getDispatchTimeType) {
        boolean result = false;
        Timestamp earlistStartTime = info.getEarlistWoktime();
        Timestamp earlistEndTime = info.getEarlistCmpTime();
        Timestamp lastStartTime = info.getLastWorktime();
        Timestamp lastEndTime = info.getLastCmpTime();
        Timestamp orderStartTime = info.getParent().getPlanBeginDate();
        Timestamp orderEndTime = info.getParent().getPlanEndDate();
        if (getDispatchTimeType.equals("10")) {
            if (earlistStartTime.compareTo(orderStartTime) < 0) return false;
            if (earlistEndTime.compareTo(orderEndTime) > 0) return false;
            return true;
        }
        if (lastStartTime.compareTo(orderStartTime) < 0) return false;
        if (lastEndTime.compareTo(orderEndTime) > 0) return false;
        return true;
    }

    private boolean checkNextOperation(ManufactureOrderTechnicsInfo info, ManufactureOrderTechnicsInfo nextInfo, String getDispatchTimeType) {
        Timestamp earlistEndTime = info.getEarlistCmpTime();
        Timestamp nextEarlistStartTime = nextInfo.getEarlistWoktime();
        Timestamp lastEndTime = info.getLastCmpTime();
        Timestamp nextLastStartTime = nextInfo.getLastWorktime();
        return !(getDispatchTimeType.equals("10") ? earlistEndTime.compareTo(nextEarlistStartTime) > 0 : lastEndTime.compareTo(nextLastStartTime) > 0);
    }

    private Map getTechnicsMap(Context ctx, List technicsList) throws BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)this.orgId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.id", (Object)("select distinct fparentid from T_MM_MFTOrderTechnics where fid in ( " + SQLUtil.arrayToString((Object[])technicsList.toArray()) + ")"), CompareType.INNER));
        CoreBaseCollection col = (CoreBaseCollection)this.getTechnicsInfoList(ctx, filterInfo);
        HashMap technicsMap = new HashMap(col.size());
        List<ManufactureOrderTechnicsInfo> techList = null;
        String moId = null;
        for (ManufactureOrderTechnicsInfo info : col) {
            moId = info.getParent().getId().toString();
            if (technicsMap.containsKey(moId)) {
                techList = (List)technicsMap.get(moId);
                techList.add(info);
                continue;
            }
            techList = new ArrayList();
            techList.add(info);
            technicsMap.put(moId, techList);
        }
        return technicsMap;
    }

    private IObjectCollection getTechnicsInfoList(Context ctx, FilterInfo filterInfo) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("parent.id"));
        view.getSelector().add(new SelectorItemInfo("parent.planBeginDate"));
        view.getSelector().add(new SelectorItemInfo("parent.planEndDate"));
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("operationNo"));
        view.getSelector().add(new SelectorItemInfo("earlistWoktime"));
        view.getSelector().add(new SelectorItemInfo("earlistCmpTime"));
        view.getSelector().add(new SelectorItemInfo("lastWorktime"));
        view.getSelector().add(new SelectorItemInfo("lastCmpTime"));
        view.getSorter().add(new SorterItemInfo("parent.id"));
        view.getSorter().add(new SorterItemInfo("operationNo"));
        view.setFilter(filterInfo);
        CoreBaseCollection col = ManufactureOrderTechnicsFactory.getLocalInstance((Context)ctx).getCollection(view);
        return col;
    }
}

