/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.sfc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.IBillType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.IBatchExecute;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.batchaction.ActionCommonException;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.basedata.OperationInfo;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.sfc.WPTransferBillCollection;
import com.kingdee.eas.mm.sfc.WPTransferBillInfo;
import com.kingdee.eas.mm.sfc.WPTransferEntryCollection;
import com.kingdee.eas.mm.sfc.WPTransferEntryInfo;
import com.kingdee.eas.mm.sfc.WPTransferException;
import com.kingdee.eas.mm.sfc.WPTransferTypeEnum;
import com.kingdee.eas.mm.sfc.app.AbstractWPTransferBillControllerBean;
import com.kingdee.eas.mm.sfc.app.WPTransferBillUpdater;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.ISCMBillParam;
import com.kingdee.eas.scm.common.SCMBillParamFactory;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

public class WPTransferBillControllerBean
extends AbstractWPTransferBillControllerBean
implements IBatchExecute {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.sfc.app.WPTransferBillControllerBean");
    private Context ctx = null;

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.ctx = ctx;
        WPTransferBillInfo info = (WPTransferBillInfo)model;
        if (info.getStorageOrgUnit() == null) {
            throw new WPTransferException(WPTransferException.STORAGE_ISNOTNULL);
        }
        WPTransferEntryCollection entry = info.getEntry();
        if (entry == null || entry.size() == 0) {
            throw new WPTransferException(WPTransferException.ENTRY_ISNOTNULL);
        }
        return super._save(ctx, (IObjectValue)info);
    }

    protected OrgUnitInfo getMainBizOrgUnit(Context ctx, CoreBillBaseInfo model) {
        return (OrgUnitInfo)model.get("storageOrgUnit");
    }

    public void _handleAfterTransform(Context ctx, String action, IObjectCollection collection) throws EASBizException, BOSException {
        block18: {
            block16: {
                this.ctx = ctx;
                WPTransferBillInfo wpinfo = (WPTransferBillInfo)collection.getObject(0);
                if (!wpinfo.getTransferType().equals((Object)WPTransferTypeEnum.NORMAL_TRANSFER)) break block16;
                Connection conn = null;
                Statement stmt = null;
                ResultSet rs = null;
                StringBuffer sbids = new StringBuffer("'");
                StringBuffer moIds = new StringBuffer("'");
                WPTransferBillInfo info = (WPTransferBillInfo)collection.getObject(0);
                UserInfo user = new UserInfo();
                user.setId(BOSUuid.read((String)ctx.getCaller().toString()));
                info.setModifier(user);
                Date today = new Date();
                info.setModificationTime(new Timestamp(today.getTime()));
                WPTransferEntryCollection entries = info.getEntry();
                for (int j = 0; j < info.getEntry().size(); ++j) {
                    String entryid = info.getEntry().get(j).getSourceBillEntryId();
                    String moid = info.getEntry().get(j).getManufactureOrder();
                    sbids.append(entryid).append("','");
                    moIds.append(moid).append("','");
                }
                String Ids = moIds.toString();
                Ids = Ids.substring(0, Ids.toString().lastIndexOf(","));
                StringBuffer sql = new StringBuffer();
                sql.append(" select t1.flastOperNo,t2.fid as tfid,t3.fid as opid,t3.fnumber,t3.fname_l2 from ");
                sql.append(" T_MM_ManufactureOrder as t1,T_MM_MFTOrderTechnics as t2 ,t_mm_operation as t3 ");
                sql.append(" where t1.fnumber in (");
                sql.append(Ids);
                sql.append(")");
                sql.append(" and t1.flastOperNo=t2.foperationno ");
                sql.append(" and t1.fid=t2.fparentid ");
                sql.append(" and t2.foperationid=t3.fid ");
                String getLastOPNosql = sql.toString();
                HashMap<String, OperationInfo> opMap = new HashMap<String, OperationInfo>();
                try {
                    conn = EJBFactory.getConnection((Context)ctx);
                    stmt = conn.createStatement();
                    rs = stmt.executeQuery(getLastOPNosql);
                    while (rs.next()) {
                        OperationInfo opinfo = new OperationInfo();
                        opinfo.setId(BOSUuid.read((String)rs.getString("opid")));
                        opinfo.setNumber(rs.getString("fnumber"));
                        opinfo.setName(rs.getString("fname_l2"));
                        opMap.put(rs.getString("tfid"), opinfo);
                    }
                }
                catch (SQLException e) {
                    try {
                        throw new BOSException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rs, (Statement)stmt, (Connection)conn);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
                StringBuffer sb = new StringBuffer();
                sb.append(" select t1.nextop, t2.fid as opid,t2.fnumber,t2.fname_l2, t1.fid from t_mm_operation as t2 ,");
                sb.append("(select t2.fid, t1.fparentid,t2.foperationno,min(t1.FOperationNo)as nextop");
                sb.append(" from T_MM_MFTOrderTechnics as t1,T_MM_MFTOrderTechnics as t2 ");
                sb.append(" where t1.foperationno > t2.foperationno");
                sb.append(" and t1.fparentid = t2.fparentid ");
                sb.append(" and t1.fisReportPoint = 1 ");
                sb.append(" and t2.fid in (");
                sb.append(sbids.toString().substring(0, sbids.toString().lastIndexOf(",")));
                sb.append(") group by t1.fparentid,t2.foperationno,t2.fid ) as t1,T_MM_MFTOrderTechnics as t3");
                sb.append(" where t3.fparentid=t1.fparentid and t1.nextop =t3.foperationno and  t2.fid=t3.FOperationID");
                try {
                    conn = EJBFactory.getConnection((Context)ctx);
                    stmt = conn.createStatement();
                    rs = stmt.executeQuery(sb.toString());
                    block11: while (rs.next()) {
                        String entryid = rs.getString("fid");
                        for (int i = 0; i < entries.size(); ++i) {
                            WPTransferEntryInfo einfo = entries.get(i);
                            String srcEntryID = einfo.getSourceBillEntryId();
                            if (!srcEntryID.equals(entryid)) continue;
                            einfo.setTargetOperationNO(rs.getInt("nextop"));
                            OperationInfo opinfo = new OperationInfo();
                            opinfo.setId(BOSUuid.read((String)rs.getString("opid")));
                            opinfo.setName(rs.getString("fname_l2"));
                            opinfo.setNumber(rs.getString("fnumber"));
                            einfo.setTargetOperation(opinfo);
                            continue block11;
                        }
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
                }
                if (opMap == null || opMap.size() < 0) break block18;
                for (int j = 0; j < entries.size(); ++j) {
                    WPTransferEntryInfo wptEntry = entries.get(j);
                    if (opMap.get(wptEntry.getSourceBillEntryId()) == null) continue;
                    wptEntry.setTargetOperationNO(wptEntry.getSrcOperationNO());
                    wptEntry.setTargetOperation((OperationInfo)opMap.get(wptEntry.getSourceBillEntryId()));
                }
                break block18;
            }
            WPTransferBillInfo info = (WPTransferBillInfo)collection.getObject(0);
            WPTransferEntryCollection entries = info.getEntry();
            for (int j = 0; j < entries.size(); ++j) {
                entries.get(j).setTargetOperation(null);
                entries.get(j).setTargetOperationNO(0);
            }
        }
    }

    public BatchActionResults batchAudit(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        this.ctx = ctx;
        return this.batchExecute(ctx, entries, BatchActionEnum.AUDIT);
    }

    public BatchActionResults batchUnAudit(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        this.ctx = ctx;
        return this.batchExecute(ctx, entries, BatchActionEnum.UNAUDIT);
    }

    protected String getBillTypeId() {
        return "nb+ReM6GTqiwiF1vm0/PCkY+1VI=";
    }

    protected String getXmlFileName(BatchActionEnum batchActionEnum) {
        return "com.kingdee.eas.mm.sfc.app.wptbizprocess.xml";
    }

    public void batchCheck(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException, EASBizException {
        this.ctx = ctx;
        this.checkWptBill(ctx, batchResults);
        if (batchAction.equals((Object)BatchActionEnum.AUDIT)) {
            WPTransferBillUpdater billUpdater = new WPTransferBillUpdater(ctx);
            billUpdater.setBatchResults(batchResults);
            billUpdater.setAuditAction(true);
            billUpdater.execute();
        } else if (batchAction.equals((Object)BatchActionEnum.UNAUDIT)) {
            this.unAuditBatchCheck(ctx, batchResults);
            WPTransferBillUpdater billUpdater = new WPTransferBillUpdater(ctx);
            billUpdater.setBatchResults(batchResults);
            billUpdater.setAuditAction(false);
            billUpdater.execute();
        }
    }

    private void checkWptBill(Context ctx, BatchActionResults results) {
        WPTransferBillCollection coll = (WPTransferBillCollection)results.getObjCollection();
        if (coll == null) {
            return;
        }
        WPTransferBillInfo info = null;
        ActionCommonException bizExp = null;
        String errorMsg = null;
        for (int i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            if (info == null || !MMUtils.isNotEmptyString((String)(errorMsg = this.getCheckMsg(info)))) continue;
            bizExp = new ActionCommonException(null);
            bizExp.setMessage(errorMsg);
            results.addError(this.getWptId(info), (Exception)bizExp);
        }
    }

    private String getCheckMsg(WPTransferBillInfo info) {
        if (info == null) {
            return null;
        }
        StringBuffer msg = new StringBuffer();
        WPTransferEntryCollection entry = null;
        if (info.getStorageOrgUnit() == null) {
            msg.append(WPTransferBillControllerBean.getString(this.ctx, "StorageOrgUnit_IsNotNull"));
        }
        if ((entry = info.getEntry()) == null || entry.size() == 0) {
            if (msg.length() > 0) {
                msg.append(",").append(WPTransferBillControllerBean.getString(this.ctx, "entry_IsNull"));
            } else {
                msg.append(WPTransferBillControllerBean.getString(this.ctx, "entry_IsNull"));
            }
        }
        return msg.toString();
    }

    private String getWptId(WPTransferBillInfo info) {
        BOSUuid bosUuid = info.getId();
        if (bosUuid == null) {
            return "NEWID";
        }
        return bosUuid.toString();
    }

    public static String getString(Context ctx, String resourceName) {
        String path = "com.kingdee.eas.mm.sfc.SfcResource";
        String strTemp = ResourceBase.getString((String)path, (String)resourceName, (Locale)ctx.getLocale());
        if (strTemp.equals("Missing Resource")) {
            return "Missing Resource{" + resourceName + "}";
        }
        return strTemp;
    }

    public void batchExecute(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException, EASBizException {
    }

    private void afterSubmit(Context ctx, String idStr) throws BOSException, EASBizException {
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("update T_MM_WPTransferEntry as t0  ").append("set (FBaseTransferQty) = ").append("(select round(decimal(t0.FTransferQty * t2.FBaseConvsRate,21,8),t3.FQtyPrecision) ").append("from t_bd_multimeasureunit t2 , T_MM_WPTransferBill t1,t_bd_multimeasureunit t3 ").append("where t0.FParentID = t1.FID ").append("and t0.FMaterialID = t2.FMaterialID and t0.FUnitID = t2.fmeasureunitid ").append("and t0.FMaterialID = t3.FMaterialID and t0.FBaseUnitID = t3.fmeasureunitid ").append("and t1.FID in ('").append(idStr).append("') ").append(")");
        String[] str = new String[]{updateSql.toString()};
        DBUtil.execute((Context)ctx, (String[])str);
    }

    protected void _audit(Context ctx, IObjectPK objPK) throws BOSException, EASBizException {
        Object[] pks = new IObjectPK[]{objPK};
        this.batchExecute(ctx, pks, BatchActionEnum.AUDIT);
    }

    protected void _unAudit(Context ctx, IObjectPK objPK) throws BOSException, EASBizException {
        BatchExecuteParamsEntry entry = new BatchExecuteParamsEntry(new Class[]{IObjectPK.class});
        entry.add((Object)objPK);
        BatchExecuteParamsEntry[] entrys = new BatchExecuteParamsEntry[]{entry};
        this.batchUnAudit(ctx, entrys);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        WPTransferBillInfo mo = (WPTransferBillInfo)model;
        IBillType iBillType = BillTypeFactory.getLocalInstance((Context)ctx);
        BillTypeInfo billTypeInfo = iBillType.getBillTypeInfo((IObjectPK)new ObjectUuidPK("nb+ReM6GTqiwiF1vm0/PCkY+1VI="));
        mo.setBillType(billTypeInfo);
        IObjectPK pk = super._submit(ctx, model);
        this.afterSubmit(ctx, mo.getId().toString());
        String orgUnitID = mo.getStorageOrgUnit().getId().toString();
        if (this.isAuditAfterSubmit(ctx, mo, orgUnitID, 4)) {
            this.auditAndLog(ctx, pk, mo.getBOSType(), mo.getNumber(), "mm_wptransferbill_Audit");
        }
        return pk;
    }

    @Override
    protected boolean _isAuditWhenSubmit(Context ctx, String billId) throws BOSException, EASBizException {
        boolean isAutoAudit = false;
        String orgUnitID = this.getOrgUnitId(billId);
        if (MMUtils.isEmptyString((String)orgUnitID)) {
            return false;
        }
        ISCMBillParam scmParam = SCMBillParamFactory.getLocalInstance((Context)ctx);
        String strAutoAudit = scmParam.getParamByBillTypeNumber("SCM_Submit_01", 4, orgUnitID, "672");
        if (strAutoAudit != null && strAutoAudit.trim().length() != 0 && strAutoAudit.trim().equals("1")) {
            isAutoAudit = true;
        }
        return isAutoAudit;
    }

    private String getOrgUnitId(String billId) {
        String orgUnitID = null;
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" select T.FStorageOrgUnitID StorageOrgUnitID ").append(" from t_mm_wptransferbill T ").append(" where T.FID = '").append(billId).append("' ");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)this.ctx, (String)sqlBuffer.toString());
            if (rs.next()) {
                orgUnitID = rs.getString("StorageOrgUnitID");
            }
        }
        catch (Exception e) {
            logger.error((Object)("WPTransferBillControllerBean.getOrgUnitId error: " + e.getMessage()));
        }
        return orgUnitID;
    }

    private void unAuditBatchCheck(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        String idStr = SQLUtil.arrayToString((Object[])batchResults.getToDoIdsArray());
        StringBuffer sqlBuffer = new StringBuffer();
        String msg = null;
        sqlBuffer.append("select T.FID COPOID, T.FStorageOrgUnitID StorageOrgUnitID ").append("from t_mm_wptransferbill T ").append("where T.FID in (").append(idStr).append(") ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString());
        ISCMBillParam scmParam = SCMBillParamFactory.getLocalInstance((Context)ctx);
        try {
            while (rs.next()) {
                boolean isUnAudit = false;
                String strAutoAudit = scmParam.getParamByBillTypeID("SCM_UnAudit_01", 4, rs.getString("StorageOrgUnitID"), this.getBillTypeId());
                if (strAutoAudit != null && strAutoAudit.trim().length() != 0 && strAutoAudit.trim().equals("1")) {
                    isUnAudit = true;
                }
                if (isUnAudit) continue;
                msg = WPTransferBillControllerBean.getString(ctx, "ISUNAUDIT_PARAM");
                batchResults.addError(rs.getString("COPOID"), msg);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }
}

