/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.sfc.app.bizprocess.batchExecutor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.IBOSObject;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.app.adapter.LogControllManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.common.app.bizprocess.batchExecutor.MMBatchBOTPExecutor;
import com.kingdee.eas.mm.lot.ILotFacade;
import com.kingdee.eas.mm.lot.LotFacadeFactory;
import com.kingdee.eas.mm.lot.LotParamValueInfo;
import com.kingdee.eas.mm.sfc.CompletionReportEnterStorageCollection;
import com.kingdee.eas.mm.sfc.CompletionReportEnterStorageInfo;
import com.kingdee.eas.mm.sfc.CompletionReportInfo;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class BatchInStockExecutor
extends MMBatchBOTPExecutor {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.sfc.app.bizprocess.batchExecutor");

    public BatchInStockExecutor(BatchActionEnum action, BOSObjectType type, String typeID) {
        super(action, type, typeID);
    }

    protected CoreBillBaseCollection preTransform(Context ctx, BatchActionResults batchResults) throws EASBizException, BOSException {
        CoreBillBaseCollection col = new CoreBillBaseCollection();
        IObjectCollection reportCollection = batchResults.getObjCollection();
        if (reportCollection == null || reportCollection.size() == 0) {
            return col;
        }
        CompletionReportInfo info2 = (CompletionReportInfo)reportCollection.getObject(0);
        boolean clearLot = this.isClearLot(ctx, info2.getPStorageOrgUnit().getId().toString());
        for (CompletionReportInfo info2 : reportCollection) {
            Iterator entryIte = info2.getEnterStorage().iterator();
            while (entryIte.hasNext()) {
                CompletionReportEnterStorageInfo entryinfo = (CompletionReportEnterStorageInfo)entryIte.next();
                if (!clearLot) continue;
                entryinfo.setBatchSeq(null);
            }
            col.add((CoreBillBaseInfo)info2);
        }
        return col;
    }

    private boolean isClearLot(Context ctx, String orgId) throws EASBizException, BOSException {
        ILotFacade ilf = LotFacadeFactory.getLocalInstance((Context)ctx);
        LotParamValueInfo lotInfo = ilf.getLotParamValueByOrg(orgId);
        boolean clearLot = false;
        if (null == lotInfo) {
            clearLot = true;
        } else if (!lotInfo.isManufactureRec()) {
            clearLot = true;
        }
        return clearLot;
    }

    public void batchCheck(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException, EASBizException {
        super.batchCheck(ctx, batchAction, batchResults);
        IObjectCollection crc = batchResults.getObjCollection();
        if (crc == null || crc.size() == 0) {
            return;
        }
        for (int i = 0; i < crc.size(); ++i) {
            CompletionReportInfo cri = (CompletionReportInfo)crc.getObject(i);
            boolean canInstock = false;
            CompletionReportEnterStorageCollection cresc = cri.getEnterStorage();
            if (cresc == null || cresc.size() == 0) {
                batchResults.addError(cri.getId().toString(), this.getString(ctx, "NO_ENTERSTORAGE_MATERIAL"));
                continue;
            }
            for (int j = 0; j < cresc.size(); ++j) {
                if (this.dealNullQty(cresc.get(j).getCompleteAmount(), SysConstant.BIGZERO).subtract(this.dealNullQty(cresc.get(j).getTotalEnterStA(), SysConstant.BIGZERO)).compareTo(SysConstant.BIGZERO) <= 0) continue;
                canInstock = true;
                break;
            }
            if (canInstock) continue;
            batchResults.addError(cri.getId().toString(), this.getString(ctx, "COMPLETE_INSTOCK"));
        }
    }

    protected SelectorItemCollection getAddedSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("EnterStorage.*"));
        sic.add(new SelectorItemInfo("productType.id"));
        sic.add(new SelectorItemInfo("productType.isWPManagement"));
        sic.add(new SelectorItemInfo("dispWorkProcess.id"));
        sic.add(new SelectorItemInfo("dispWorkProcess.technicsLayer"));
        sic.add(new SelectorItemInfo("dmesOrder.id"));
        sic.add(new SelectorItemInfo("dmesOrder.lastOperNo"));
        return sic;
    }

    protected String getXmlFileName(BatchActionEnum action) {
        return "com.kingdee.eas.mm.sfc.app.sfcbizprocess.xml";
    }

    protected String getResourcePath() {
        return "com.kingdee.eas.mm.sfc.SfcResource";
    }

    protected void afterTransform(Context ctx, BatchActionResults batchResults) throws EASBizException, BOSException {
    }

    protected String getAddNewPermItemName() {
        return "manufacturerec_new";
    }

    protected String getBizOrgPropertyName() {
        return "pStorageOrgUnit";
    }

    protected void batchSaveTargetBills(Context ctx, BOTMappingInfo mappingInfo, IObjectCollection destBillCols, BOSObjectType billBOSType) throws EASBizException, BOSException {
        if (this.isDisablePermission()) {
            LogControllManager.getInstance().disableLog();
            ServiceStateManager.getInstance().disableNextCallService("PERMISSION_SERVICE");
        }
        if (this.isDisableLog()) {
            LogControllManager.getInstance().disableLog();
            ServiceStateManager.getInstance().disableNextCallService("LOG_SERVICE");
        }
        try {
            IBOSObject obj = BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)billBOSType);
            ICoreBillBase iBillBase = (ICoreBillBase)obj;
            for (int i = 0; i < destBillCols.size(); ++i) {
                SCMBillBaseInfo info;
                if (mappingInfo.getIsTempSave() == 0) {
                    if (destBillCols.getObject(i) instanceof SCMBillBaseInfo) {
                        info = (SCMBillBaseInfo)destBillCols.getObject(i);
                        info.setBotpCallSave(true);
                        iBillBase.submit((CoreBaseInfo)info);
                        continue;
                    }
                    info = (CoreBillBaseInfo)destBillCols.getObject(i);
                    iBillBase.submit((CoreBaseInfo)info);
                    continue;
                }
                if (destBillCols.getObject(i) instanceof SCMBillBaseInfo) {
                    info = (SCMBillBaseInfo)destBillCols.getObject(i);
                    info.setBotpCallSave(true);
                    iBillBase.save((CoreBaseInfo)info);
                    continue;
                }
                info = (CoreBillBaseInfo)destBillCols.getObject(i);
                iBillBase.save((CoreBaseInfo)info);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            throw e;
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw e;
        }
        if (this.isDisablePermission()) {
            LogControllManager.getInstance().enableLog();
            ServiceStateManager.getInstance().enableNextCallService("PERMISSION_SERVICE");
        }
        if (this.isDisableLog()) {
            LogControllManager.getInstance().enableLog();
            ServiceStateManager.getInstance().enableNextCallService("LOG_SERVICE");
        }
    }
}

