/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.sfc.app.bizprocess.batchExecutor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.sql.util.StringUtil;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.app.cache.PermissionCacheFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.common.app.bizprocess.batchExecutor.MMBatchBOTPExecutor;
import com.kingdee.eas.mm.sfc.CompletionReportAmountTimeInfo;
import com.kingdee.eas.mm.sfc.CompletionReportByproductInfo;
import com.kingdee.eas.mm.sfc.CompletionReportInfo;
import com.kingdee.eas.qm.qc.QCRequestEntryCollection;
import com.kingdee.eas.qm.qc.QCRequestEntryInfo;
import com.kingdee.eas.qm.qc.QCRequestException;
import com.kingdee.eas.qm.qc.QCRequestInfo;
import com.kingdee.eas.scm.common.SCMGroupFacadeFactory;
import com.kingdee.eas.scm.common.loadmass.SCMEntryDataVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class BatchProcessCheckExecutor
extends MMBatchBOTPExecutor {
    public BatchProcessCheckExecutor(BatchActionEnum action, BOSObjectType type, String typeID) {
        super(action, type, typeID);
    }

    public void batchCheck(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException, EASBizException {
        super.batchCheck(ctx, batchAction, batchResults);
        IObjectCollection crc = batchResults.getObjCollection();
        if (crc == null || crc.size() == 0) {
            return;
        }
        ArrayList<MaterialInfo> materials = new ArrayList<MaterialInfo>();
        ArrayList<StorageOrgUnitInfo> orgUnits = new ArrayList<StorageOrgUnitInfo>();
        HashSet<String> exceptIds = new HashSet<String>();
        for (CompletionReportInfo cri : crc) {
            BigDecimal checkOutAmount;
            BigDecimal reportAmount;
            materials.add(cri.getProductNumber());
            orgUnits.add(cri.getStorageOrgUnit());
            Iterator entryIte = cri.getAmountTime().iterator();
            while (entryIte.hasNext()) {
                CompletionReportAmountTimeInfo amountTimeInfo = (CompletionReportAmountTimeInfo)entryIte.next();
                reportAmount = this.dealNullQty(amountTimeInfo.getReportAmount(), SysConstant.BIGZERO);
                if (reportAmount.compareTo(checkOutAmount = this.dealNullQty(amountTimeInfo.getCheckoutAmount(), SysConstant.BIGZERO)) > 0) continue;
                entryIte.remove();
            }
            entryIte = cri.getByproduct().iterator();
            while (entryIte.hasNext()) {
                CompletionReportByproductInfo byproductInfo = (CompletionReportByproductInfo)entryIte.next();
                reportAmount = this.dealNullQty(byproductInfo.getReportAmount(), SysConstant.BIGZERO);
                if (reportAmount.compareTo(checkOutAmount = this.dealNullQty(byproductInfo.getCheckoutAmount(), SysConstant.BIGZERO)) <= 0) {
                    entryIte.remove();
                    continue;
                }
                materials.add(byproductInfo.getMaterial());
                orgUnits.add(cri.getStorageOrgUnit());
            }
            if (cri.getAmountTime().size() != 0 || cri.getByproduct().size() != 0) continue;
            batchResults.addError(cri.getId().toString(), this.getString(ctx, "COMPLETE_CHECKOUT"));
            exceptIds.add(cri.getId().toString());
        }
        StorageOrgUnitInfo[] storageOrgUnitInfos = orgUnits.toArray(new StorageOrgUnitInfo[0]);
        MaterialInfo[] materialInfos = materials.toArray(new MaterialInfo[0]);
        Map materialPlanInfos = this.getMaterialPlans(ctx, storageOrgUnitInfos, materialInfos);
        String key = null;
        MaterialPlanInfo mpInfo = null;
        PermItemInfo permItemInfo = null;
        HashSet<ObjectUuidPK> requestOrgUnits = new HashSet<ObjectUuidPK>();
        for (CompletionReportInfo cri : crc) {
            if (exceptIds.contains(cri.getId().toString())) continue;
            HashSet<String> set = new HashSet<String>();
            key = cri.getProductNumber().getId().toString() + cri.getStorageOrgUnit().getId().toString();
            mpInfo = (MaterialPlanInfo)materialPlanInfos.get(key);
            if (mpInfo == null || !mpInfo.isIsCheck() || mpInfo.getQualityOrg() == null) {
                set.add(cri.getProductNumber().getNumber());
                cri.getAmountTime().clear();
            } else {
                requestOrgUnits.add(new ObjectUuidPK(mpInfo.getQualityOrg().getId().toString()));
            }
            Iterator entryIte = cri.getByproduct().iterator();
            while (entryIte.hasNext()) {
                CompletionReportByproductInfo byproductInfo = (CompletionReportByproductInfo)entryIte.next();
                key = byproductInfo.getMaterial().getId().toString() + cri.getStorageOrgUnit().getId().toString();
                mpInfo = (MaterialPlanInfo)materialPlanInfos.get(key);
                if (mpInfo != null && mpInfo.isIsCheck()) continue;
                set.add(byproductInfo.getMaterial().getNumber());
                entryIte.remove();
            }
            if (cri.getAmountTime().size() != 0 || cri.getByproduct().size() != 0) continue;
            String materialNums = StringUtil.arrayToString((Object[])set.toArray(), (String)",");
            batchResults.addError(cri.getId().toString(), new QCRequestException(QCRequestException.MATERIALCANNOTSUPPORTCHECKFLOW, new Object[]{materialNums}).getMessage());
        }
        IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
        Set orgSet = iPermission.checkBatchPermission(ctx.getCaller(), requestOrgUnits.toArray(new IObjectPK[0]), this.getAddNewPermItemName());
        for (CompletionReportInfo cri : crc) {
            if (cri.getAmountTime() == null || cri.getAmountTime().size() == 0 || orgSet.contains((mpInfo = (MaterialPlanInfo)materialPlanInfos.get(key = cri.getProductNumber().getId().toString() + cri.getStorageOrgUnit().getId().toString())).getQualityOrg().getId().toString())) continue;
            if (permItemInfo == null) {
                permItemInfo = PermissionCacheFactory.getPermItemCache((Context)ctx).getPermItem(ctx, this.getAddNewPermItemName());
            }
            Object[] object = new Object[]{mpInfo.getQualityOrg().getName(), permItemInfo.getAlias()};
            batchResults.addError(cri.getId().toString(), new PermissionException(PermissionException.HAS_NOT_ORG_FUNCTION_PERMISSION, object).getMessage());
        }
    }

    private Map getMaterialPlans(Context ctx, StorageOrgUnitInfo[] storageOrgUnitInfos, MaterialInfo[] materialInfos) throws EASBizException, BOSException {
        SCMEntryDataVO dataVO = new SCMEntryDataVO();
        SCMEntryDataVO voResult = new SCMEntryDataVO();
        dataVO.setMaterialInfos(materialInfos);
        dataVO.setIsLoadingMaterialPlan(true);
        dataVO.setMaterialPlanSelectors(this.getMaterialPlanSelectors());
        dataVO.setStorageOrgUnitInfos(storageOrgUnitInfos);
        voResult = SCMGroupFacadeFactory.getLocalInstance((Context)ctx).loadComplexData(dataVO);
        return voResult.getMaterialPlanInfos();
    }

    private SelectorItemCollection getMaterialPlanSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("isCheck"));
        sic.add(new SelectorItemInfo("qualityOrg.id"));
        sic.add(new SelectorItemInfo("qualityOrg.number"));
        sic.add(new SelectorItemInfo("qualityOrg.name"));
        return sic;
    }

    protected CoreBillBaseCollection preTransform(Context ctx, BatchActionResults batchResults) throws EASBizException, BOSException {
        CoreBillBaseCollection col = new CoreBillBaseCollection();
        IObjectCollection reportCollection = batchResults.getObjCollection();
        if (reportCollection == null || reportCollection.size() == 0) {
            return col;
        }
        CompletionReportInfo reportInfo = null;
        for (int i = 0; i < reportCollection.size(); ++i) {
            reportInfo = (CompletionReportInfo)reportCollection.getObject(i);
            col.add((CoreBillBaseInfo)reportInfo);
        }
        return col;
    }

    protected void afterTransform(Context ctx, BatchActionResults batchResults) throws EASBizException, BOSException {
        BTPTransformResult btpResult = batchResults.getTransformResult(this.billTypeID);
        IObjectCollection destBillCols = btpResult.getBills();
        BOTRelationCollection relations = btpResult.getBOTRelationCollection();
        if (destBillCols == null || destBillCols.size() <= 0) {
            return;
        }
        Iterator ite = destBillCols.iterator();
        while (ite.hasNext()) {
            QCRequestInfo curOrder = (QCRequestInfo)ite.next();
            if (curOrder == null || curOrder.getEntrys() == null || curOrder.getEntrys().size() <= 0) continue;
            QCRequestEntryCollection curEntries = curOrder.getEntrys();
            Iterator entryIte = curEntries.iterator();
            while (entryIte.hasNext()) {
                QCRequestEntryInfo curEntry = (QCRequestEntryInfo)entryIte.next();
                if (curEntry.getSourceBillEntryID() != null) continue;
                entryIte.remove();
            }
            if (curOrder.getEntrys().size() != 0) continue;
            ite.remove();
            this.removeRelations(relations, curOrder.getId().toString());
        }
    }

    protected void removeRelations(BOTRelationCollection relations, String destBillId) {
        Iterator ite = relations.iterator();
        while (ite.hasNext()) {
            BOTRelationInfo relationInfo = (BOTRelationInfo)ite.next();
            if (!relationInfo.getDestObjectID().equalsIgnoreCase(destBillId)) continue;
            ite.remove();
        }
    }

    protected SelectorItemCollection getAddedSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("AmountTime.*"));
        sic.add(new SelectorItemInfo("Byproduct.*"));
        sic.add(new SelectorItemInfo("productNumber.id"));
        sic.add(new SelectorItemInfo("productNumber.number"));
        sic.add(new SelectorItemInfo("productNumber.name"));
        sic.add(new SelectorItemInfo("Byproduct.material.id"));
        sic.add(new SelectorItemInfo("Byproduct.material.number"));
        sic.add(new SelectorItemInfo("Byproduct.material.name"));
        sic.add(new SelectorItemInfo("dispWorkProcess.id"));
        sic.add(new SelectorItemInfo("dispWorkProcess.technicsLayer"));
        sic.add(new SelectorItemInfo("process.id"));
        sic.add(new SelectorItemInfo("process.isCheckPoint"));
        return sic;
    }

    protected boolean isCheckFunctionPermission() {
        return false;
    }

    protected boolean isHandleAfterTransform() {
        return true;
    }

    protected String getXmlFileName(BatchActionEnum action) {
        return "com.kingdee.eas.mm.sfc.app.sfcbizprocess.xml";
    }

    protected String getResourcePath() {
        return "com.kingdee.eas.mm.sfc.SfcResource";
    }

    protected String getAddNewPermItemName() {
        return "qm_QCMMRequest_02addnew";
    }

    protected String getBizOrgPropertyName() {
        return "storageOrgUnit";
    }
}

