/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.sfc.app.bizprocess.batchExecutor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.basedata.master.material.MaterialIssueModeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.common.app.bizprocess.batchExecutor.MMBatchBOTPExecutor;
import com.kingdee.eas.mm.mo.ManufactureOrderCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderStockCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderStockInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsInfo;
import com.kingdee.eas.mm.mo.ScrapOrderInfo;
import com.kingdee.eas.mm.sfc.CompletionReportInfo;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class BatchScrapExecutor
extends MMBatchBOTPExecutor {
    public BatchScrapExecutor(BatchActionEnum action, BOSObjectType type, String typeID) {
        super(action, type, typeID);
    }

    protected CoreBillBaseCollection preTransform(Context ctx, BatchActionResults batchResults) throws EASBizException, BOSException {
        CoreBillBaseCollection col = new CoreBillBaseCollection();
        IObjectCollection reportCollection = batchResults.getObjCollection();
        if (reportCollection == null || reportCollection.size() == 0) {
            return col;
        }
        CompletionReportInfo reportInfo = null;
        String techId = null;
        String orderId = null;
        HashSet<String> techIds = new HashSet<String>();
        HashSet<String> orderIds = new HashSet<String>();
        HashMap<String, BigDecimal> workScrapMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> baseWorkScrapMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> steelScrapMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> baseSteelScrapMap = new HashMap<String, BigDecimal>();
        BigDecimal workScrapQty = SysConstant.BIGZERO;
        BigDecimal baseWorkScrapQty = SysConstant.BIGZERO;
        BigDecimal steelScrapQty = SysConstant.BIGZERO;
        BigDecimal baseSteelScrapQty = SysConstant.BIGZERO;
        BigDecimal unitQty = SysConstant.BIGZERO;
        BigDecimal unitBaseQty = SysConstant.BIGZERO;
        int n = reportCollection.size();
        for (int i = 0; i < n; ++i) {
            reportInfo = (CompletionReportInfo)reportCollection.getObject(i);
            techId = reportInfo.getProcess().getId().toString();
            orderId = reportInfo.getDmesOrder().getId().toString();
            if (techIds.contains(techId)) {
                workScrapQty = (BigDecimal)workScrapMap.get(techId);
                baseWorkScrapQty = (BigDecimal)baseWorkScrapMap.get(techId);
                steelScrapQty = (BigDecimal)steelScrapMap.get(techId);
                baseSteelScrapQty = (BigDecimal)baseSteelScrapMap.get(techId);
                workScrapQty = workScrapQty.add(this.dealNullQty(reportInfo.getWorkerScrapQty(), SysConstant.BIGZERO));
                baseWorkScrapQty = baseWorkScrapQty.add(this.dealNullQty(reportInfo.getBaseWorkerScrapQty(), SysConstant.BIGZERO));
                steelScrapQty = steelScrapQty.add(this.dealNullQty(reportInfo.getSteelScrapQty(), SysConstant.BIGZERO));
                baseSteelScrapQty = baseSteelScrapQty.add(this.dealNullQty(reportInfo.getBaseSteelScrapQty(), SysConstant.BIGZERO));
                workScrapMap.put(techId, workScrapQty);
                baseWorkScrapMap.put(techId, baseWorkScrapQty);
                steelScrapMap.put(techId, steelScrapQty);
                baseSteelScrapMap.put(techId, baseSteelScrapQty);
                continue;
            }
            techIds.add(techId);
            orderIds.add(orderId);
            workScrapMap.put(techId, this.dealNullQty(reportInfo.getWorkerScrapQty(), SysConstant.BIGZERO));
            baseWorkScrapMap.put(techId, this.dealNullQty(reportInfo.getBaseWorkerScrapQty(), SysConstant.BIGZERO));
            steelScrapMap.put(techId, this.dealNullQty(reportInfo.getSteelScrapQty(), SysConstant.BIGZERO));
            baseSteelScrapMap.put(techId, this.dealNullQty(reportInfo.getBaseSteelScrapQty(), SysConstant.BIGZERO));
        }
        if (orderIds.size() <= 0 || techIds.size() <= 0) {
            return col;
        }
        ManufactureOrderCollection orderCollection = this.getManufactureOrderByIds(ctx, orderIds);
        int n2 = orderCollection.size();
        for (int i = 0; i < n2; ++i) {
            ManufactureOrderInfo orderInfo = orderCollection.get(i);
            ManufactureOrderTechnicsCollection technicsCol = orderInfo.getTechnics();
            ManufactureOrderStockCollection stocksCol = orderInfo.getStocks();
            for (ManufactureOrderStockInfo stocksInfo : stocksCol) {
                stocksInfo.setScrapQty(SysConstant.BIGZERO);
                stocksInfo.setScrapBaseQty(SysConstant.BIGZERO);
                stocksInfo.setMaterialScrapQty(SysConstant.BIGZERO);
                stocksInfo.setMaterialScrapBaseQty(SysConstant.BIGZERO);
            }
            int m = technicsCol.size();
            for (int j = 0; j < m; ++j) {
                ManufactureOrderTechnicsInfo technicsInfo = technicsCol.get(j);
                techId = technicsInfo.getId().toString();
                if (!techIds.contains(techId)) continue;
                int operationNo = technicsInfo.getOperationNo();
                for (ManufactureOrderStockInfo stocksInfo : stocksCol) {
                    if (operationNo < stocksInfo.getOperationNo()) continue;
                    workScrapQty = (BigDecimal)workScrapMap.get(techId);
                    baseWorkScrapQty = (BigDecimal)baseWorkScrapMap.get(techId);
                    steelScrapQty = (BigDecimal)steelScrapMap.get(techId);
                    baseSteelScrapQty = (BigDecimal)baseSteelScrapMap.get(techId);
                    unitQty = stocksInfo.getUnitQty();
                    unitBaseQty = stocksInfo.getUnitBaseQty();
                    stocksInfo.setScrapQty(stocksInfo.getScrapQty().add(workScrapQty.multiply(unitQty).setScale(8, 4)));
                    stocksInfo.setScrapBaseQty(stocksInfo.getScrapBaseQty().add(baseWorkScrapQty.multiply(unitBaseQty).setScale(8, 4)));
                    stocksInfo.setMaterialScrapQty(stocksInfo.getMaterialScrapQty().add(steelScrapQty.multiply(unitQty).setScale(8, 4)));
                    stocksInfo.setMaterialScrapBaseQty(stocksInfo.getMaterialScrapBaseQty().add(baseSteelScrapQty.multiply(unitBaseQty).setScale(8, 4)));
                    stocksInfo.setExtendedProperty("ISSCRAP", "TRUE");
                }
            }
            Iterator ite = stocksCol.iterator();
            while (ite.hasNext()) {
                ManufactureOrderStockInfo stocksInfo = (ManufactureOrderStockInfo)ite.next();
                if (!"TRUE".equalsIgnoreCase(stocksInfo.getExtendedProperty("ISSCRAP"))) {
                    ite.remove();
                    continue;
                }
                if (!stocksInfo.getIssueMode().equals((Object)MaterialIssueModeEnum.NOTISSMODE)) continue;
                ite.remove();
            }
            if (orderInfo.getStocks().size() <= 0) continue;
            col.add((CoreBillBaseInfo)orderInfo);
        }
        return col;
    }

    private ManufactureOrderCollection getManufactureOrderByIds(Context ctx, Set ids) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("technics.*"));
        sic.add(new SelectorItemInfo("stocks.*"));
        viewInfo.setSelector(sic);
        return ManufactureOrderFactory.getLocalInstance((Context)ctx).getManufactureOrderCollection(viewInfo);
    }

    protected void afterTransform(Context ctx, BatchActionResults batchResults) throws EASBizException, BOSException {
        super.afterTransform(ctx, batchResults);
        BTPTransformResult btpResult = batchResults.getTransformResult(this.billTypeID);
        IObjectCollection destBillCols = btpResult.getBills();
        for (ScrapOrderInfo scrapInfo : destBillCols) {
            scrapInfo.setExtendedProperty("SRCBILLTYPE", "671");
        }
    }

    protected SelectorItemCollection getAddedSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("dispWorkProcess.id"));
        sic.add(new SelectorItemInfo("dispWorkProcess.technicsLayer"));
        sic.add(new SelectorItemInfo("dmesOrder.id"));
        sic.add(new SelectorItemInfo("dmesOrder.baseStatus"));
        return sic;
    }

    protected String getXmlFileName(BatchActionEnum action) {
        return "com.kingdee.eas.mm.sfc.app.sfcbizprocess.xml";
    }

    protected String getResourcePath() {
        return "com.kingdee.eas.mm.sfc.SfcResource";
    }

    protected String getAddNewPermItemName() {
        return "mm_scrapOrder_addNew";
    }

    protected String getBizOrgPropertyName() {
        return "pStorageOrgUnit";
    }
}

