/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.sfc.app.bizprocess.batchExecutor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.common.app.bizprocess.batchExecutor.MMBatchBOTPExecutor;
import com.kingdee.eas.mm.mo.ManufactureOrderCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsInfo;
import com.kingdee.eas.mm.sfc.CompletionReportInfo;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class BatchTransferProcessExecutor
extends MMBatchBOTPExecutor {
    public BatchTransferProcessExecutor(BatchActionEnum action, BOSObjectType type, String typeID) {
        super(action, type, typeID);
    }

    public void batchCheck(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException, EASBizException {
        super.batchCheck(ctx, batchAction, batchResults);
        IObjectCollection crc = batchResults.getObjCollection();
        if (crc == null || crc.size() == 0) {
            return;
        }
        for (CompletionReportInfo cri : crc) {
            if (this.dealNullQty(cri.getQualifiedQty(), SysConstant.BIGZERO).add(this.dealNullQty(cri.getYieldQty(), SysConstant.BIGZERO)).compareTo(SysConstant.BIGZERO) > 0) continue;
            batchResults.addError(cri.getId().toString(), this.getString(ctx, "ERROR_NULLTRANSQTY"));
        }
    }

    protected CoreBillBaseCollection preTransform(Context ctx, BatchActionResults batchResults) throws EASBizException, BOSException {
        CoreBillBaseCollection col = new CoreBillBaseCollection();
        IObjectCollection reportCollection = batchResults.getObjCollection();
        if (reportCollection == null || reportCollection.size() == 0) {
            return col;
        }
        CompletionReportInfo reportInfo = null;
        String techId = "";
        String orderId = "";
        HashSet<String> techIds = new HashSet<String>();
        HashSet<String> orderIds = new HashSet<String>();
        HashMap<String, BigDecimal> passQtyMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> concessionQtyMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> passBaseQtyMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> concessionBaseQtyMap = new HashMap<String, BigDecimal>();
        int n = reportCollection.size();
        for (int i = 0; i < n; ++i) {
            reportInfo = (CompletionReportInfo)reportCollection.getObject(i);
            techId = reportInfo.getProcess().getId().toString();
            orderId = reportInfo.getDmesOrder().getId().toString();
            if (techIds.contains(techId)) {
                BigDecimal passQty = (BigDecimal)passQtyMap.get(techId);
                BigDecimal conQty = (BigDecimal)concessionQtyMap.get(techId);
                BigDecimal basePassQty = (BigDecimal)passBaseQtyMap.get(techId);
                BigDecimal baseConQty = (BigDecimal)concessionBaseQtyMap.get(techId);
                passQty = passQty.add(this.dealNullQty(reportInfo.getQualifiedQty(), SysConstant.BIGZERO));
                conQty = conQty.add(this.dealNullQty(reportInfo.getYieldQty(), SysConstant.BIGZERO));
                basePassQty = basePassQty.add(this.dealNullQty(reportInfo.getBasequalifiedQty(), SysConstant.BIGZERO));
                baseConQty = baseConQty.add(this.dealNullQty(reportInfo.getBaseYieldQty(), SysConstant.BIGZERO));
                passQtyMap.put(techId, passQty);
                passBaseQtyMap.put(techId, basePassQty);
                concessionQtyMap.put(techId, conQty);
                concessionBaseQtyMap.put(techId, baseConQty);
                continue;
            }
            techIds.add(techId);
            orderIds.add(orderId);
            passQtyMap.put(techId, this.dealNullQty(reportInfo.getQualifiedQty(), SysConstant.BIGZERO));
            passBaseQtyMap.put(techId, this.dealNullQty(reportInfo.getBasequalifiedQty(), SysConstant.BIGZERO));
            concessionQtyMap.put(techId, this.dealNullQty(reportInfo.getYieldQty(), SysConstant.BIGZERO));
            concessionBaseQtyMap.put(techId, this.dealNullQty(reportInfo.getBaseYieldQty(), SysConstant.BIGZERO));
        }
        if (orderIds.size() <= 0 || techIds.size() <= 0) {
            return col;
        }
        ManufactureOrderCollection orderCollection = this.getManufactureOrderByTechnicsIds(ctx, orderIds, techIds);
        int n2 = orderCollection.size();
        for (int i = 0; i < n2; ++i) {
            ManufactureOrderInfo orderInfo = orderCollection.get(i);
            ManufactureOrderTechnicsCollection technicsCol = orderInfo.getTechnics();
            int m = technicsCol.size();
            for (int j = 0; j < m; ++j) {
                ManufactureOrderTechnicsInfo technicsInfo = technicsCol.get(j);
                technicsInfo.setPassQty((BigDecimal)passQtyMap.get(technicsInfo.getId().toString()));
                technicsInfo.setPassBaseQty((BigDecimal)passBaseQtyMap.get(technicsInfo.getId().toString()));
                technicsInfo.setConcessionQty((BigDecimal)concessionQtyMap.get(technicsInfo.getId().toString()));
                technicsInfo.setConcessionBaseQty((BigDecimal)concessionBaseQtyMap.get(technicsInfo.getId().toString()));
                technicsInfo.setOutQty(SysConstant.BIGZERO);
                technicsInfo.setOutBaseQty(SysConstant.BIGZERO);
            }
            if (orderInfo.getTechnics().size() <= 0) continue;
            col.add((CoreBillBaseInfo)orderInfo);
        }
        return col;
    }

    private ManufactureOrderCollection getManufactureOrderByTechnicsIds(Context ctx, Set ids, Set entryIds) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        FilterInfo entryFilter = new FilterInfo();
        entryFilter.setEntryName("technics");
        entryFilter.getFilterItems().add(new FilterItemInfo("id", (Object)entryIds, CompareType.INCLUDE));
        viewInfo.getEntryFilters().add(entryFilter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("technics.*"));
        viewInfo.setSelector(sic);
        return ManufactureOrderFactory.getLocalInstance((Context)ctx).getManufactureOrderCollection(viewInfo);
    }

    protected void afterTransform(Context ctx, BatchActionResults batchResults) throws EASBizException, BOSException {
    }

    protected SelectorItemCollection getAddedSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("dispWorkProcess.id"));
        sic.add(new SelectorItemInfo("dispWorkProcess.technicsLayer"));
        sic.add(new SelectorItemInfo("dmesOrder.id"));
        sic.add(new SelectorItemInfo("dmesOrder.baseStatus"));
        sic.add(new SelectorItemInfo("dmesOrder.lastOperNo"));
        sic.add(new SelectorItemInfo("process.id"));
        sic.add(new SelectorItemInfo("process.operationNo"));
        return sic;
    }

    protected String getXmlFileName(BatchActionEnum action) {
        return "com.kingdee.eas.mm.sfc.app.sfcbizprocess.xml";
    }

    protected String getResourcePath() {
        return "com.kingdee.eas.mm.sfc.SfcResource";
    }

    protected String getAddNewPermItemName() {
        return "mm_sfc_wptransferbillAddNew";
    }

    protected String getBizOrgPropertyName() {
        return "pStorageOrgUnit";
    }
}

