/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.sfc.app.pac;

import com.kingdee.eas.scm.common.util.SCMConstant;
import java.math.BigDecimal;
import java.sql.Timestamp;

public class CalcBurthenUtil {
    private static final BigDecimal HOUR_MINUTE_RATE = new BigDecimal(60);
    private static final BigDecimal HOUR_SECOND_RATE = new BigDecimal(3600);

    public static BigDecimal getBurthenResult(BigDecimal qty, int timeUnit, BigDecimal prepareTime, BigDecimal workTime, BigDecimal processBatch, boolean hasReport, BigDecimal rate) {
        if (timeUnit == 3) {
            prepareTime = prepareTime.divide(HOUR_MINUTE_RATE, 2, 4);
            workTime = workTime.divide(HOUR_MINUTE_RATE, 2, 4);
        } else if (timeUnit == 4) {
            prepareTime = prepareTime.divide(HOUR_SECOND_RATE, 2, 4);
            workTime = workTime.divide(HOUR_SECOND_RATE, 2, 4);
        }
        if (hasReport) {
            prepareTime = SCMConstant.BIGDECIMAL_ZERO;
        }
        if (processBatch.compareTo(SCMConstant.BIGDECIMAL_ZERO) > 0) {
            workTime = workTime.multiply(qty.divide(processBatch, 0, 0)).setScale(2, 4);
        }
        return prepareTime.add(workTime.multiply(rate)).setScale(2, 4);
    }

    public static BigDecimal getBurthenResult(BigDecimal qty, int timeUnit, BigDecimal prepareTime, BigDecimal workTime, BigDecimal processBatch) {
        return CalcBurthenUtil.getBurthenResult(qty, timeUnit, prepareTime, workTime, processBatch, false, SCMConstant.BIGDECIMAL_ONE);
    }

    public static BigDecimal getBurthenResult(BigDecimal qty, int timeUnit, BigDecimal prepareTime, BigDecimal workTime, BigDecimal processBatch, boolean hasReport) {
        return CalcBurthenUtil.getBurthenResult(qty, timeUnit, prepareTime, workTime, processBatch, hasReport, SCMConstant.BIGDECIMAL_ONE);
    }

    public static BigDecimal getBurthenResult(Timestamp beginDate, Timestamp endDate, Timestamp beginWorkTime, Timestamp cmpWorkTime, BigDecimal qty, int timeUnit, BigDecimal prepareTime, BigDecimal workTime, BigDecimal processBatch) {
        BigDecimal workTimeRate = SCMConstant.BIGDECIMAL_ONE;
        if (beginWorkTime.compareTo(beginDate) < 0 && cmpWorkTime.compareTo(endDate) <= 0) {
            prepareTime = SCMConstant.BIGDECIMAL_ZERO;
        } else if (beginWorkTime.compareTo(beginDate) >= 0 && cmpWorkTime.compareTo(endDate) <= 0) {
            workTimeRate = SCMConstant.BIGDECIMAL_ONE;
        } else if (beginWorkTime.compareTo(beginDate) >= 0 && cmpWorkTime.compareTo(endDate) > 0) {
            BigDecimal numerator = new BigDecimal((endDate.getTime() - beginWorkTime.getTime()) / 86400000L);
            BigDecimal denominator = new BigDecimal((cmpWorkTime.getTime() - beginWorkTime.getTime()) / 86400000L);
            workTimeRate = numerator.divide(denominator, 2, 4);
        } else if (beginWorkTime.compareTo(beginDate) < 0 && cmpWorkTime.compareTo(endDate) > 0) {
            prepareTime = SCMConstant.BIGDECIMAL_ZERO;
            BigDecimal numerator = new BigDecimal((endDate.getTime() - beginDate.getTime()) / 86400000L);
            BigDecimal denominator = new BigDecimal((cmpWorkTime.getTime() - beginWorkTime.getTime()) / 86400000L);
            workTimeRate = numerator.divide(denominator, 2, 4);
        } else {
            workTimeRate = SCMConstant.BIGDECIMAL_ZERO;
        }
        return CalcBurthenUtil.getBurthenResult(qty, timeUnit, prepareTime, workTime, processBatch, false, workTimeRate);
    }

    public static BigDecimal getBurthenResult(Timestamp beginDate, Timestamp endDate, Timestamp systemTime, BigDecimal qty, int timeUnit, BigDecimal prepareTime, BigDecimal workTime, BigDecimal processBatch) {
        return null;
    }
}

