/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.sfc.app.pac;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.archives.EquipmentArchivesInfo;
import com.kingdee.eas.mm.basedata.WorkCenterInfo;
import com.kingdee.eas.mm.sfc.app.pac.CalcBurthenUtil;
import com.kingdee.eas.mm.sfc.app.pac.IWorkCenterTreeNodeBuilder;
import com.kingdee.eas.mm.sfc.util.pac.TaskAssignParam;
import com.kingdee.eas.mm.sfc.util.pac.WorkCenterTreeNode;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WorkCenterTreeNodeBuilder
implements IWorkCenterTreeNodeBuilder {
    protected Context ctx;
    private IMetaDataLoader loader = null;

    public WorkCenterTreeNodeBuilder(Context ctx) {
        this.ctx = ctx;
        this.loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
    }

    @Override
    public List getWorkCenterChildren(IObjectValue storageOrg, IObjectValue adminOrg, FilterInfo filter) throws BOSException, EASBizException {
        StorageOrgUnitInfo workOrg = (StorageOrgUnitInfo)storageOrg;
        AdminOrgUnitInfo workDept = (AdminOrgUnitInfo)adminOrg;
        QueryInfo query = this.loader.getQuery((IMetaDataPK)MetaDataPK.create((String)this.getQueryInfo()));
        MetaDataPK metaDataPK = MetaDataPK.create((String)query.getPackage(), (String)query.getName());
        IQueryExecutor queryExecutor = QueryExecutorFactory.getLocalInstance((Context)this.ctx, (IMetaDataPK)metaDataPK);
        queryExecutor.setObjectView(this.getEntityView(filter));
        IRowSet rows = queryExecutor.executeQuery();
        try {
            return this.getWorkCenterTreeNodes(workOrg, workDept, rows);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private EntityViewInfo getEntityView(FilterInfo filter) {
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        return view;
    }

    protected List getWorkCenterTreeNodes(StorageOrgUnitInfo workOrg, AdminOrgUnitInfo workDept, IRowSet rows) throws Exception {
        ArrayList list = new ArrayList();
        HashMap workCenterBurthens = new HashMap();
        HashMap eqmBurthens = new HashMap();
        this.getDispatchedBurthen(workOrg, workDept, workCenterBurthens, eqmBurthens);
        HashMap<String, WorkCenterTreeNode> map = new HashMap<String, WorkCenterTreeNode>();
        WorkCenterTreeNode treeNode = null;
        WorkCenterInfo workCenter = null;
        EquipmentArchivesInfo eqmInfo = null;
        TaskAssignParam param = null;
        while (rows.next()) {
            String workCenter_key = rows.getString("workCenter.id");
            if (map.containsKey(workCenter_key)) {
                treeNode = (WorkCenterTreeNode)((Object)map.get(workCenter_key));
                workCenter = (WorkCenterInfo)treeNode.getUserObject();
            } else {
                workCenter = new WorkCenterInfo();
                workCenter.setId(BOSUuid.read((String)workCenter_key));
                workCenter.setNumber(rows.getString("workCenter.number"));
                workCenter.setName(rows.getString("workCenter.name"));
                workCenter.setRatedAbility(rows.getBigDecimal("ratedAbility"));
                workCenter.setEstimatedDays(rows.getBigDecimal("estimatedDays"));
                workCenter.setStorageOrgUnit(workOrg);
                workCenter.setAdminOrgUnit(workDept);
                treeNode = new WorkCenterTreeNode(workCenter);
            }
            param = new TaskAssignParam();
            param.setWorkCenter(workCenter);
            if (workCenterBurthens.containsKey(workCenter_key)) {
                param.setWorkCenter_dispatched_Burthen((BigDecimal)workCenterBurthens.get(workCenter_key));
            } else {
                param.setWorkCenter_dispatched_Burthen(SCMConstant.BIGDECIMAL_ZERO);
            }
            String eqm_key = rows.getString("equipment.id");
            if (eqm_key != null) {
                eqmInfo = new EquipmentArchivesInfo();
                eqmInfo.setId(BOSUuid.read((String)eqm_key));
                eqmInfo.setNumber(rows.getString("equipment.number"));
                eqmInfo.setName(rows.getString("equipment.name"));
                if (eqmBurthens.containsKey(eqm_key)) {
                    param.setEqm_dispatched_Burthen((BigDecimal)eqmBurthens.get(eqm_key));
                } else {
                    param.setEqm_dispatched_Burthen(SCMConstant.BIGDECIMAL_ZERO);
                }
                param.setEquipment(eqmInfo);
            }
            treeNode.addTaskAssignParam(param);
            map.put(workCenter_key, treeNode);
        }
        for (Map.Entry enty : map.entrySet()) {
            list.add(enty.getValue());
        }
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                WorkCenterTreeNode treeNode1 = (WorkCenterTreeNode)((Object)o1);
                WorkCenterTreeNode treeNode2 = (WorkCenterTreeNode)((Object)o2);
                WorkCenterInfo workCenter1 = (WorkCenterInfo)treeNode1.getUserObject();
                WorkCenterInfo workCenter2 = (WorkCenterInfo)treeNode2.getUserObject();
                return workCenter1.getNumber().compareTo(workCenter2.getNumber());
            }
        });
        return list;
    }

    private void getDispatchedBurthen(StorageOrgUnitInfo workOrg, AdminOrgUnitInfo workDept, Map workCenterBurthens, Map eqmBurthens) throws Exception {
        IRowSet rows = DbUtil.executeQuery((Context)this.ctx, (String)this.getQuerySql(), (Object[])new Object[]{workOrg.getId().toString(), workDept.getId().toString()});
        while (rows.next()) {
            BigDecimal burthen;
            String workCenter_key = rows.getString("FWorkCenterID");
            String eqm_key = rows.getString("FEquipmentID");
            if (workCenterBurthens.containsKey(workCenter_key)) {
                burthen = (BigDecimal)workCenterBurthens.get(workCenter_key);
                burthen = burthen.add(this.getBurthenFromRowSet(rows));
            } else {
                burthen = this.getBurthenFromRowSet(rows);
            }
            workCenterBurthens.put(workCenter_key, burthen);
            if (eqm_key == null) continue;
            if (eqmBurthens.containsKey(eqm_key)) {
                burthen = (BigDecimal)eqmBurthens.get(eqm_key);
                burthen = burthen.add(this.getBurthenFromRowSet(rows));
            } else {
                burthen = this.getBurthenFromRowSet(rows);
            }
            eqmBurthens.put(eqm_key, burthen);
        }
    }

    private BigDecimal getBurthenFromRowSet(IRowSet rows) throws SQLException {
        int timeUnit = rows.getInt("FTimeUnit");
        BigDecimal qty = rows.getBigDecimal("Qty");
        BigDecimal prepareTime = rows.getBigDecimal("FPrepareTime");
        BigDecimal workTime = rows.getBigDecimal("FWorkTime");
        BigDecimal processBatch = rows.getBigDecimal("FProcessBatch");
        boolean hasReport = rows.getBoolean("HasReport");
        return CalcBurthenUtil.getBurthenResult(qty, timeUnit, prepareTime, workTime, processBatch, hasReport);
    }

    protected String getQuerySql() {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT T2.FWorkCenterID,T1.FEquipmentID,T3.FProcessBatch,T3.FTimeUnit,T3.FPrepareTime,T3.FWorkTime,T2.FUNITID,CASE WHEN T2.FFinishedQty > 0 THEN 1 ELSE 0 END AS HasReport,T2.FQty-T2.FFinishedQty AS Qty ");
        sb.append("FROM T_MM_DISTASKDISPATCH T1 INNER JOIN T_MM_DISTASKDISPATCHENTRY T2 ON T1.FId = T2.FParentId AND T2.FQty-T2.FFinishedQty > 0 ");
        sb.append("INNER JOIN T_MM_MFTOrderTechnics T3 ON T2.FSourceBillEntryId = T3.FId ");
        sb.append("WHERE T1.FStorageOrgUnitId = ? AND T1.FAdminOrgUnitId = ? AND T1.FBaseStatus = 4 AND T2.FRowStatus = 10 ");
        return sb.toString();
    }

    protected String getQueryInfo() {
        return "com.kingdee.eas.mm.sfc.app.WorkCenterEqmForPACQuery";
    }
}

