/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.sfc.util.pac;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.mo.IManufactureOrderTechnics;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsInfo;
import com.kingdee.eas.mm.sfc.util.pac.ITaskAssign;
import com.kingdee.eas.mm.sfc.util.pac.TaskAssignBurthen;
import com.kingdee.eas.mm.sfc.util.pac.TaskAssignData;
import com.kingdee.eas.mm.sfc.util.pac.TaskAssignParam;
import com.kingdee.eas.mm.sfc.util.pac.TaskAssignResult;
import com.kingdee.eas.scm.common.SCMBillEntryBaseCollection;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AverageAssignTaskImpl
implements ITaskAssign {
    private Context ctx;
    private String serialNumber;

    public AverageAssignTaskImpl(Context ctx) {
        this.ctx = ctx;
        this.serialNumber = Long.toString(System.currentTimeMillis(), 32);
    }

    @Override
    public List executeAssign(Map assignDatas, List assignParams) throws BOSException, EASBizException {
        ArrayList<TaskAssignResult> resultList = new ArrayList<TaskAssignResult>();
        TaskAssignResult resultInfo = null;
        SCMBillEntryBaseCollection technicsCol = this.getTechnicsCol(assignDatas.keySet());
        HashMap<BOSUuid, String> paramMap = new HashMap<BOSUuid, String>();
        int seq = 100;
        int n = technicsCol.size();
        for (int i = 0; i < n; ++i) {
            ManufactureOrderTechnicsInfo technicsInfo = (ManufactureOrderTechnicsInfo)technicsCol.get(i);
            TaskAssignData assignData = (TaskAssignData)assignDatas.get(technicsInfo.getId().toString());
            int precisions = assignData.getQtyPrecision();
            BigDecimal assignQty = assignData.getAssignQty();
            BigDecimal averageQty = assignQty.divide(new BigDecimal(assignParams.size()), precisions, 4);
            int timeUnit = technicsInfo.getTimeUnit().getValue();
            BigDecimal prepareTime = technicsInfo.getPrepareTime();
            BigDecimal workTime = technicsInfo.getWorkTime();
            BigDecimal processBatch = technicsInfo.getProcessBatch();
            int m = assignParams.size();
            for (int j = 0; j < m; ++j) {
                TaskAssignParam param = (TaskAssignParam)assignParams.get(j);
                resultInfo = new TaskAssignResult();
                resultInfo.setId(this.serialNumber + String.valueOf(++seq));
                resultInfo.setSerialNumber(this.serialNumber);
                resultInfo.setManufactureOrder(technicsInfo.getParent());
                resultInfo.setTechnicsInfo(technicsInfo);
                resultInfo.setWorkCenter(param.getWorkCenter());
                resultInfo.setEquipment(param.getEquipment());
                resultInfo.setClassGroup(param.getClassGroup());
                resultInfo.setClassTeam(param.getClassTeam());
                resultInfo.setClassTeamEntry(param.getClassTeamEntry());
                resultInfo.setPersons(param.getPersons());
                if (j == m - 1) {
                    resultInfo.setAssignQty(assignQty);
                } else {
                    resultInfo.setAssignQty(averageQty);
                    assignQty = assignQty.subtract(averageQty);
                }
                TaskAssignBurthen burthen = new TaskAssignBurthen();
                burthen.setPrepareTime(prepareTime);
                burthen.setProcessBatch(processBatch);
                burthen.setTimeUnit(timeUnit);
                burthen.setWorkTime(workTime);
                resultInfo.setTaskAssignBurthen(burthen);
                String getDispatchTimeType = "0";
                if (!paramMap.containsKey(technicsInfo.getId())) {
                    getDispatchTimeType = ParamManager.getParamValue((Context)this.ctx, (IObjectPK)new ObjectUuidPK(technicsInfo.getParent().getStorageOrgUnit().getId()), (String)"GetDispatchTimeType");
                    paramMap.put(technicsInfo.getId(), getDispatchTimeType);
                } else {
                    getDispatchTimeType = (String)paramMap.get(technicsInfo.getId());
                }
                if (getDispatchTimeType.equals("0")) {
                    resultInfo.setWorkBeginTime(technicsInfo.getEarlistWoktime());
                    resultInfo.setWorkEndTime(technicsInfo.getEarlistCmpTime());
                } else if (getDispatchTimeType.equals("1")) {
                    resultInfo.setWorkBeginTime(technicsInfo.getLastWorktime());
                    resultInfo.setWorkEndTime(technicsInfo.getLastCmpTime());
                }
                resultInfo.setGenTaskDispatch(false);
                resultInfo.setQtyPrecision(assignData.getQtyPrecision());
                resultInfo.setBaseQtyPrecision(assignData.getBaseQtyPrecision());
                resultList.add(resultInfo);
            }
        }
        return resultList;
    }

    private SCMBillEntryBaseCollection getTechnicsCol(Set ids) throws BOSException {
        IManufactureOrderTechnics bizControl = ManufactureOrderTechnicsFactory.getLocalInstance((Context)this.ctx);
        return bizControl.getSCMBillEntryBaseCollection(this.getDefaultEntityView(ids));
    }

    private EntityViewInfo getDefaultEntityView(Set ids) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("workcenter.number"));
        selector.add(new SelectorItemInfo("workcenter.name"));
        selector.add(new SelectorItemInfo("operation.number"));
        selector.add(new SelectorItemInfo("operation.name"));
        selector.add(new SelectorItemInfo("parent.*"));
        selector.add(new SelectorItemInfo("parent.storageOrgUnit.id"));
        selector.add(new SelectorItemInfo("parent.material.id"));
        selector.add(new SelectorItemInfo("parent.material.name"));
        selector.add(new SelectorItemInfo("parent.material.number"));
        selector.add(new SelectorItemInfo("parent.material.model"));
        view.setSelector(selector);
        return view;
    }
}

