/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.sfc.util.pac;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.common.EASBizException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public final class F7ContextManager {
    private Map f7Map = null;
    private Map diffTypeOrgs = null;
    private OrgType mainOrgType;

    public F7ContextManager(OrgType mainOrgType) throws EASBizException, BOSException {
        this.mainOrgType = mainOrgType;
        this.init();
    }

    private void init() throws EASBizException, BOSException {
        this.f7Map = new HashMap();
        this.diffTypeOrgs = new HashMap();
    }

    public void registerOtherOUF7(KDBizPromptBox f7, OrgType orgType) {
        this.diffTypeOrgs.put(f7, orgType);
    }

    public void registerContextChangeF7(KDBizPromptBox f7, String mainOrgProperty) {
        this.f7Map.put(f7, mainOrgProperty);
    }

    public void changeContext4F7(String ids) throws EASBizException, BOSException {
        EntityViewInfo viewInfo = null;
        for (Map.Entry entry : this.f7Map.entrySet()) {
            KDBizPromptBox f7 = (KDBizPromptBox)entry.getKey();
            String orgProperty = (String)entry.getValue();
            if (orgProperty != null) {
                viewInfo = f7.getEntityViewInfo() == null ? new EntityViewInfo() : f7.getEntityViewInfo();
                viewInfo.clearExtendedProperties();
                viewInfo.setFilter(this.getFilterInfo(orgProperty, ids));
            }
            f7.setEntityViewInfo(viewInfo);
            f7.setValue(null);
        }
        HashMap<OrgType, EntityViewInfo> viewMap = new HashMap<OrgType, EntityViewInfo>();
        for (Map.Entry entry : this.diffTypeOrgs.entrySet()) {
            KDBizPromptBox f7 = (KDBizPromptBox)entry.getKey();
            OrgType orgType = (OrgType)entry.getValue();
            if (orgType != null) {
                if (viewMap.containsKey(orgType)) {
                    viewInfo = (EntityViewInfo)viewMap.get(orgType);
                } else {
                    viewInfo = f7.getEntityViewInfo() == null ? new EntityViewInfo() : f7.getEntityViewInfo();
                    viewInfo.clearExtendedProperties();
                    viewInfo.setFilter(this.getFilterInfo(orgType, ids));
                    viewMap.put(orgType, viewInfo);
                }
            }
            f7.setEntityViewInfo(viewInfo);
            f7.setValue(null);
        }
    }

    private FilterInfo getFilterInfo(String orgProperty, String ids) {
        FilterInfo filterInfo = new FilterInfo();
        if (ids != null) {
            if (ids.indexOf(44) == -1) {
                filterInfo.getFilterItems().add(new FilterItemInfo(orgProperty, (Object)ids));
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo(orgProperty, (Object)ids, CompareType.INCLUDE));
            }
        } else if (ids == null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("1", (Object)"0"));
        }
        return filterInfo;
    }

    private FilterInfo getFilterInfo(OrgType orgType, String ids) throws EASBizException, BOSException {
        OrgUnitCollection unitCol;
        FilterInfo filterInfo = new FilterInfo();
        HashSet<String> set = new HashSet<String>();
        if (ids != null && ids.indexOf(44) == -1 && (unitCol = OrgUnitRelationFactory.getRemoteInstance().getToUnit(ids, this.mainOrgType.getValue(), orgType.getValue())) != null && unitCol.size() > 0) {
            int n = unitCol.size();
            for (int i = 0; i < n; ++i) {
                OrgUnitInfo orgUnit = unitCol.get(i);
                set.add(orgUnit.getId().toString());
            }
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        return filterInfo;
    }
}

