/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.sfc.util.pac;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.mm.sfc.util.pac.DataFilterHandler;
import com.kingdee.eas.mm.sfc.util.pac.DefaultPromptBoxFactory;
import com.kingdee.eas.mm.sfc.util.pac.IShortcutQueryImpl;
import com.kingdee.eas.mm.sfc.util.pac.MMTableSelectionHelper;
import com.kingdee.eas.mm.sfc.util.pac.RequestDataHandler;
import com.kingdee.eas.mm.sfc.util.pac.ShortcutQueryHandler;
import com.kingdee.eas.mm.sfc.util.pac.TableEditHandler;
import java.util.HashMap;
import java.util.Map;

public class PACFrameUIHelper {
    private IMetaDataLoader loader = null;
    private Map requestDataHandlers = null;
    private Map shortcutQueryHandlers = null;
    private Map dataFilterHandlers = null;
    private Map tableEditHandlers = null;
    private Map tableSelectionHelpers = null;
    private CoreUI owner;

    public PACFrameUIHelper(CoreUI ui) {
        this.owner = ui;
        this.loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        this.requestDataHandlers = new HashMap();
        this.shortcutQueryHandlers = new HashMap();
        this.dataFilterHandlers = new HashMap();
        this.tableEditHandlers = new HashMap();
        this.tableSelectionHelpers = new HashMap();
    }

    public void registerRequestDataHandler(KDTable table, String queryInfo, String[] pks) {
        QueryInfo query = this.loader.getQuery((IMetaDataPK)MetaDataPK.create((String)queryInfo));
        RequestDataHandler handler = new RequestDataHandler(this.owner, table, query, pks);
        this.requestDataHandlers.put(table, handler);
    }

    public void changedRequestDataQueryInfo(KDTable table, String queryInfo, String[] pks) {
        QueryInfo query = this.loader.getQuery((IMetaDataPK)MetaDataPK.create((String)queryInfo));
        this.getRequestDataHandler(table).changedQueryInfo(query, pks);
    }

    public void registerShortcutQueryHandler(KDTable table, IShortcutQueryImpl ui, KDPanel container, CustomerQueryPanel shortcutPanel, int columnWidth, int columnCount) {
        ShortcutQueryHandler handler = new ShortcutQueryHandler(ui, container, shortcutPanel);
        handler.setColumnCount(columnCount);
        handler.setColumnWidth(columnWidth);
        try {
            handler.initShortcutQueryPanel();
        }
        catch (Exception e) {
            this.owner.handUIExceptionAndAbort(e);
        }
        this.shortcutQueryHandlers.put(table, handler);
    }

    public void registerShortcutQueryHandler(KDTable table, IShortcutQueryImpl ui, KDPanel container, CustomerQueryPanel shortcutPanel) {
        ShortcutQueryHandler handler = new ShortcutQueryHandler(ui, container, shortcutPanel);
        try {
            handler.initShortcutQueryPanel();
        }
        catch (Exception e) {
            this.owner.handUIExceptionAndAbort(e);
        }
        this.shortcutQueryHandlers.put(table, handler);
    }

    public void registerDataFilterHandler(KDTable table, KDPanel panel, String[] filterFields) {
        DataFilterHandler handler = new DataFilterHandler(table);
        RequestDataHandler rdHandler = this.getRequestDataHandler(table);
        String[] fieldNames = null;
        fieldNames = rdHandler == null ? this.getFieldNames(table, filterFields) : this.getRequestDataHandler(table).getFieldNames(filterFields);
        handler.initialize(panel, filterFields, fieldNames);
        this.dataFilterHandlers.put(table, handler);
    }

    private String[] getFieldNames(KDTable table, String[] filterFields) {
        int size = filterFields.length;
        String[] fieldNames = new String[size];
        for (int i = 0; i < size; ++i) {
            fieldNames[i] = (String)table.getHeadRow(0).getCell(filterFields[i]).getValue();
        }
        return fieldNames;
    }

    public void registerDataFilterHandler(KDTable table) {
        DataFilterHandler handler = new DataFilterHandler(table);
        this.dataFilterHandlers.put(table, handler);
    }

    public void registerTableEditHandler(KDTable table, String[] editableFields) {
        DefaultPromptBoxFactory promptFactory = new DefaultPromptBoxFactory(this.owner);
        TableEditHandler handler = new TableEditHandler(table, editableFields, promptFactory);
        this.tableEditHandlers.put(table, handler);
    }

    public void registerTableSelectionHelpers(KDTable table, String rowKey) {
        MMTableSelectionHelper handler = new MMTableSelectionHelper(this.owner, table, rowKey);
        this.tableSelectionHelpers.put(table, handler);
    }

    public RequestDataHandler getRequestDataHandler(KDTable table) {
        return (RequestDataHandler)this.requestDataHandlers.get(table);
    }

    public DataFilterHandler getDataFilterHandler(KDTable table) {
        return (DataFilterHandler)this.dataFilterHandlers.get(table);
    }

    public TableEditHandler getTableEditHandler(KDTable table) {
        return (TableEditHandler)this.tableEditHandlers.get(table);
    }

    public ShortcutQueryHandler getShortcutQueryHandler(KDTable table) {
        return (ShortcutQueryHandler)this.shortcutQueryHandlers.get(table);
    }

    public MMTableSelectionHelper getTableSelectionHelper(KDTable table) {
        return (MMTableSelectionHelper)this.tableSelectionHelpers.get(table);
    }

    public void doRequestData(KDTable table, EntityViewInfo view) {
        this.getRequestDataHandler(table).doRequestData(view);
    }

    public void doFilterData(KDTable table, Map filters) {
        this.getDataFilterHandler(table).doFilter(filters);
    }

    public boolean isModify(KDTable table, String[] colNames) throws BOSException {
        return this.getRequestDataHandler(table).isModify(colNames);
    }

    public void setColumnEditable(KDTable table, boolean editable) {
        this.getTableEditHandler(table).setColumnEditable(editable);
    }
}

