/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.sfc.util.pac;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTCell;
import com.kingdee.bos.ctrl.kdf.table.KDTRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.mm.sfc.util.pac.MMTableSelectionHelper;
import java.text.Collator;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class PACKDTSortManager
extends KDTSortManager {
    private MMTableSelectionHelper selectionHelper;
    private String[] defaultSorter;

    public PACKDTSortManager(KDTable table) {
        super(table);
    }

    public void sort(int colIndex) {
        IColumn column;
        if (colIndex < 0) {
            return;
        }
        if (this.enableSortable && ((column = this.table.getColumn(colIndex)) == null || !column.isSortable())) {
            return;
        }
        int sortType = this.colIndex == colIndex ? this.getNextSortType(this.sortType) : 0;
        this.sort(colIndex, sortType);
    }

    public void sort(int colIndex, int sortType) {
        if (this.isSortAuto()) {
            IColumn column = this.table.getColumn(colIndex);
            if (column == null || !column.isSortable()) {
                return;
            }
            boolean refresh = this.table.isRefresh();
            this.table.setRefresh(false);
            this.changeHeadStatus(this.colIndex, colIndex, sortType);
            List rows = this.table.getBody().getRows();
            if (this.groupSortConfig != null && this.groupSortConfig.size() > 0) {
                this.sortByGroups(colIndex, sortType);
            } else {
                Collections.sort(rows, new TableCellComparator(this.colIndex, sortType));
            }
            this.table.setRefresh(refresh);
        } else {
            this.changeHeadStatus(this.colIndex, colIndex, sortType);
        }
        this.selectionHelper.initIDMap();
    }

    public MMTableSelectionHelper getSelectionHelper() {
        return this.selectionHelper;
    }

    public void setSelectionHelper(MMTableSelectionHelper selectionHelper) {
        this.selectionHelper = selectionHelper;
    }

    public void setDefaultSorter(String[] defaultSorter) {
        this.defaultSorter = defaultSorter;
    }

    class TableCellComparator
    implements Comparator {
        int colIndex = 0;
        int sortType;
        Collator comparator = Collator.getInstance(Locale.getDefault());

        public TableCellComparator(int i, int sortType) {
            this.colIndex = i;
            this.sortType = sortType;
        }

        public int compare(Object kdtRow1, Object kdtRow2) {
            int result = this.doDefaultCompare(kdtRow1, kdtRow2);
            if (result == 0) {
                result = this.doCompareAppoint(kdtRow1, kdtRow2);
            }
            if (this.sortType == 0) {
                return result;
            }
            if (result < 0) {
                return 1;
            }
            if (result > 0) {
                return -1;
            }
            return result;
        }

        public int doCompareAppoint(Object kdtRow1, Object kdtRow2) {
            Object o1 = null;
            Object o2 = null;
            KDTCell cell = ((KDTRow)kdtRow1).getCell(this.colIndex);
            if (cell != null) {
                o1 = cell.getValue();
            }
            if ((cell = ((KDTRow)kdtRow2).getCell(this.colIndex)) != null) {
                o2 = cell.getValue();
            }
            return this.doCompare(o1, o2);
        }

        public int doDefaultCompare(Object kdtRow1, Object kdtRow2) {
            int result = 0;
            Object o1 = null;
            Object o2 = null;
            int n = PACKDTSortManager.this.defaultSorter.length;
            for (int i = 0; i < n; ++i) {
                String sorterItem = PACKDTSortManager.this.defaultSorter[i];
                int cellIndex = PACKDTSortManager.this.table.getColumnIndex(sorterItem);
                o1 = ((KDTRow)kdtRow1).getCell(cellIndex).getValue();
                result = this.doCompare(o1, o2 = ((KDTRow)kdtRow2).getCell(cellIndex).getValue());
                if (result == 0) continue;
                return result;
            }
            return result;
        }

        public int doCompare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null && o2 != null) {
                return -1;
            }
            if (o1 != null && o2 == null) {
                return 1;
            }
            if (o1 instanceof Number) {
                if (o2 instanceof Number) {
                    double d2;
                    double d1 = ((Number)o1).doubleValue();
                    if (d1 == (d2 = ((Number)o2).doubleValue())) {
                        return 0;
                    }
                    if (d1 < d2) {
                        return -1;
                    }
                    return 1;
                }
                return o1.toString().compareTo(o2.toString());
            }
            if (o1 instanceof String) {
                if (o2 instanceof String) {
                    return this.comparator.compare(o1, o2);
                }
                return ((String)o1).compareTo(o2.toString());
            }
            if (o1 instanceof Date) {
                if (o2 instanceof Date) {
                    return ((Date)o1).compareTo((Date)o2);
                }
                return o1.toString().compareTo(o2.toString());
            }
            if (o1 instanceof Calendar) {
                if (o2 instanceof Calendar) {
                    long d2;
                    long d1 = ((Calendar)o1).getTimeInMillis();
                    if (d1 == (d2 = ((Calendar)o2).getTimeInMillis())) {
                        return 0;
                    }
                    if (d1 < d2) {
                        return -1;
                    }
                    return 1;
                }
                return o1.toString().compareTo(o2.toString());
            }
            if (o1 instanceof Comparable) {
                if (o2 instanceof Comparable) {
                    return ((Comparable)o1).compareTo((Comparable)o2);
                }
                return o1.toString().compareTo(o2.toString());
            }
            return o1.toString().compareTo(o2.toString());
        }
    }
}

