/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.sfc.util.pac;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.ctrl.extendcontrols.util.BosHelper;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.common.client.SysContext;

public class PACSelectUICreator {
    private static MetaDataPK getQueryInfoPK(String info) {
        if (StringUtil.isEmptyString((String)info)) {
            return null;
        }
        int pos = info.lastIndexOf(46);
        if (pos < 0) {
            return null;
        }
        String packageName = info.substring(0, pos);
        String className = info.substring(pos + 1);
        return MetaDataPK.create((String)packageName, (String)className);
    }

    private static IQueryExecutor getQueryExecutor(MetaDataPK pk) {
        IQueryExecutor queryExecutor = null;
        if (pk != null) {
            queryExecutor = BosHelper.createQueryExecutor((MetaDataPK)pk);
            boolean isAdmin = UserType.SYSTEM.equals((Object)SysContext.getSysContext().getCurrentUserInfo().getType());
            if (isAdmin) {
                queryExecutor.option().isIgnorePermissionCheck = true;
            }
        }
        queryExecutor.option().topCount = 10;
        return queryExecutor;
    }

    private static QueryInfo getQueryInfo(MetaDataPK pk) {
        QueryInfo queryInfo = null;
        if (pk != null) {
            IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
            queryInfo = loader.getQuery((IMetaDataPK)pk);
        }
        return queryInfo;
    }

    public static KDPromptSelector createSelector(String queryInfoStr) {
        KDCommonPromptDialog sel = null;
        KDCommonPromptDialog cqd = new KDCommonPromptDialog();
        MetaDataPK pk = PACSelectUICreator.getQueryInfoPK(queryInfoStr);
        cqd.setQueryExecutor(PACSelectUICreator.getQueryExecutor(pk));
        cqd.setQueryInfo(PACSelectUICreator.getQueryInfo(pk));
        sel = cqd;
        return sel;
    }
}

