/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill;

import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ncm.common.NCMIFilterParam;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import org.apache.log4j.Logger;

public class UnitStandardHourFilterParam
implements NCMIFilterParam {
    private static final long serialVersionUID = -2512962170686251565L;
    private static Logger logger = Logger.getLogger((String)UnitStandardHourFilterParam.class.getName());
    private Integer yearFrom = null;
    private Integer yearTo = null;
    private Integer monthFrom = null;
    private Integer monthTo = null;
    private CompanyOrgUnitInfo company = null;
    private CostCenterOrgUnitInfo costCenterFrom = null;
    private CostCenterOrgUnitInfo costCenterTo = null;
    private Boolean isHistory = Boolean.FALSE;

    public FilterInfo getFilter() {
        FilterInfo filterInfo = new FilterInfo();
        if (this.isHistory.booleanValue()) {
            Integer periodTo;
            Integer periodFrom = this.parsePeriod(this.yearFrom, this.monthFrom);
            if (periodFrom != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("calculatePeriod.number", (Object)periodFrom, CompareType.GREATER_EQUALS));
            }
            if ((periodTo = this.parsePeriod(this.yearTo, this.monthTo)) != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("calculatePeriod.number", (Object)periodTo, CompareType.LESS_EQUALS));
            }
        } else {
            try {
                String companyId = this.company != null ? this.company.getId().toString() : SysContext.getSysContext().getCurrentFIUnit().getId().toString();
                PeriodInfo curPeriod = NCMUtils.GetCurrentPeriod(null, (String)companyId);
                filterInfo.getFilterItems().add(new FilterItemInfo("calculatePeriod.number", (Object)curPeriod.getNumber(), CompareType.EQUALS));
            }
            catch (Exception exc) {
                logger.error((Object)exc.getMessage());
            }
        }
        if (this.company != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("companyOrg.id", (Object)this.company.getId().toString(), CompareType.EQUALS));
        }
        if (this.costCenterFrom != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("costCenter.number", (Object)this.costCenterFrom.getNumber(), CompareType.GREATER_EQUALS));
        }
        if (this.costCenterTo != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("costCenter.number", (Object)this.costCenterTo.getNumber(), CompareType.LESS_EQUALS));
        }
        return filterInfo;
    }

    public Integer getYearFrom() {
        return this.yearFrom;
    }

    public void setYearFrom(Integer yearFrom) {
        this.yearFrom = yearFrom;
    }

    public Integer getYearTo() {
        return this.yearTo;
    }

    public void setYearTo(Integer yearTo) {
        this.yearTo = yearTo;
    }

    public Integer getMonthFrom() {
        return this.monthFrom;
    }

    public void setMonthFrom(Integer monthFrom) {
        this.monthFrom = monthFrom;
    }

    public Integer getMonthTo() {
        return this.monthTo;
    }

    public void setMonthTo(Integer monthTo) {
        this.monthTo = monthTo;
    }

    public CompanyOrgUnitInfo getCompany() {
        return this.company;
    }

    public void setCompany(CompanyOrgUnitInfo company) {
        this.company = company;
    }

    public CostCenterOrgUnitInfo getCostCenterFrom() {
        return this.costCenterFrom;
    }

    public void setCostCenterFrom(CostCenterOrgUnitInfo costCenterFrom) {
        this.costCenterFrom = costCenterFrom;
    }

    public CostCenterOrgUnitInfo getCostCenterTo() {
        return this.costCenterTo;
    }

    public void setCostCenterTo(CostCenterOrgUnitInfo costCenterTo) {
        this.costCenterTo = costCenterTo;
    }

    public Boolean getIsHistory() {
        return this.isHistory;
    }

    public void setIsHistory(Boolean isHistory) {
        this.isHistory = isHistory;
    }

    private Integer parsePeriod(Integer year, Integer month) {
        if (year == null || month == null) {
            return null;
        }
        if (month < 10) {
            return Integer.valueOf(year.toString() + "0" + month.toString());
        }
        return Integer.valueOf(year.toString() + month.toString());
    }
}

