/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.ncm.bill.SproducetsBillInfo;
import com.kingdee.eas.scm.im.inv.ManufactureRecBillEntryCollection;
import com.kingdee.eas.scm.im.inv.ManufactureRecBillEntryInfo;
import com.kingdee.eas.scm.im.inv.ManufactureRecBillInfo;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryCollection;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryInfo;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import com.kingdee.eas.util.app.ContextUtil;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractSproducetsBill {
    protected static final BOSObjectType ManufactureRecDestBosType = BOSObjectType.create((String)"FA1292B4");
    protected static final BOSObjectType MaterialReqDestBosType = BOSObjectType.create((String)"500AB75E");
    protected static final Timestamp NOW_TIME = new Timestamp(new Date().getTime());

    protected Map transform(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        BTPTransformResult transformResult = null;
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        HashMap map = new HashMap();
        SproducetsBillInfo sproducetsBillInfo = (SproducetsBillInfo)model;
        CoreBillBaseCollection coreBillBaseColl = new CoreBillBaseCollection();
        coreBillBaseColl.add((CoreBillBaseInfo)sproducetsBillInfo);
        Calendar calendar = Calendar.getInstance();
        transformResult = iBTPManager.transformMultiBill(coreBillBaseColl, ManufactureRecDestBosType.toString());
        Date date = null;
        ArrayList<ManufactureRecBillInfo> destmanufactureRecBillInfoList = new ArrayList<ManufactureRecBillInfo>();
        int size = transformResult.getBills().size();
        for (int i = 0; i < size; ++i) {
            ManufactureRecBillInfo destmanufactureRecBillInfo = (ManufactureRecBillInfo)transformResult.getBills().getObject(i);
            date = destmanufactureRecBillInfo.getBizDate();
            calendar.setTime(date);
            destmanufactureRecBillInfo.setNumber("*" + sproducetsBillInfo.getNumber() + "_" + (i + 1));
            destmanufactureRecBillInfo.setPeriod(calendar.get(2) + 1);
            destmanufactureRecBillInfo.setYear(calendar.get(1));
            destmanufactureRecBillInfo.setAuditor(userInfo);
            destmanufactureRecBillInfo.setAuditTime(NOW_TIME);
            ManufactureRecBillEntryCollection collection = destmanufactureRecBillInfo.getEntry();
            int sizetwo = collection.size();
            for (int j = 0; j < sizetwo; ++j) {
                ManufactureRecBillEntryInfo entryInfo = collection.get(j);
                if (entryInfo == null) continue;
                MaterialInfo materialInfo = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(entryInfo.getMaterial().getId()));
                MeasureUnitInfo baseUnitInfo = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(entryInfo.getBaseUnit().getId()));
                MeasureUnitInfo unitInfo = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(entryInfo.getUnit().getId()));
                BigDecimal baseQty = this.getBaseUnitQtyFromData(baseUnitInfo, unitInfo, materialInfo, entryInfo.getQty(), ctx);
                entryInfo.setBaseQty(baseQty);
            }
            destmanufactureRecBillInfoList.add(destmanufactureRecBillInfo);
        }
        map.put("SproducetsToManufactureRec_Mapping", destmanufactureRecBillInfoList);
        transformResult = iBTPManager.transformMultiBill(coreBillBaseColl, MaterialReqDestBosType.toString());
        ArrayList<MaterialReqBillInfo> destmaterialReqBillInfoList = new ArrayList<MaterialReqBillInfo>();
        int size2 = transformResult.getBills().size();
        for (int i = 0; i < size2; ++i) {
            MaterialReqBillInfo destmaterialReqBillInfo = (MaterialReqBillInfo)transformResult.getBills().getObject(i);
            date = destmaterialReqBillInfo.getBizDate();
            calendar.setTime(date);
            destmaterialReqBillInfo.setNumber("*" + sproducetsBillInfo.getNumber() + "_" + (i + 1));
            destmaterialReqBillInfo.setPeriod(calendar.get(2) + 1);
            destmaterialReqBillInfo.setYear(calendar.get(1));
            destmaterialReqBillInfo.setAuditor(userInfo);
            destmaterialReqBillInfo.setAuditTime(NOW_TIME);
            MaterialReqBillEntryCollection collection = destmaterialReqBillInfo.getEntry();
            int sizetwo = collection.size();
            for (int j = 0; j < sizetwo; ++j) {
                MaterialReqBillEntryInfo entryInfo = collection.get(j);
                if (entryInfo == null) continue;
                MaterialInfo materialInfo = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(entryInfo.getMaterial().getId()));
                MeasureUnitInfo baseUnitInfo = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(entryInfo.getBaseUnit().getId()));
                MeasureUnitInfo unitInfo = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(entryInfo.getUnit().getId()));
                BigDecimal baseQty = this.getBaseUnitQtyFromData(baseUnitInfo, unitInfo, materialInfo, entryInfo.getQty(), ctx);
                entryInfo.setBaseQty(baseQty);
            }
            destmaterialReqBillInfoList.add(destmaterialReqBillInfo);
        }
        map.put("SproducetsToMaterialReq_Mapping", destmaterialReqBillInfoList);
        return map;
    }

    public BigDecimal getBaseUnitQtyFromData(MeasureUnitInfo baseUnitInfo, MeasureUnitInfo unitInfo, MaterialInfo materialInfo, BigDecimal orderQty, Context ctx) throws EASBizException, BOSException {
        if (orderQty == null || baseUnitInfo == null || unitInfo == null || materialInfo == null) {
            return null;
        }
        BigDecimal baseUnitQty = this.getExchangeQty(materialInfo.getId().toString(), unitInfo, baseUnitInfo, orderQty, ctx);
        return baseUnitQty;
    }

    public BigDecimal getExchangeQty(String materialID, MeasureUnitInfo unitInfo, MeasureUnitInfo baseUnitInfo, BigDecimal qty, Context ctx) throws BOSException, EASBizException {
        if (materialID == null) {
            throw new IllegalArgumentException();
        }
        BigDecimal targetQty = qty;
        IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        MultiMeasureUnitInfo multiUnifInfo = multiUnit.getMultiUnit(materialID, unitInfo.getId().toString());
        MultiMeasureUnitInfo othermultiUnifInfo = multiUnit.getMultiUnit(materialID, baseUnitInfo.getId().toString());
        if (multiUnifInfo != null && othermultiUnifInfo != null) {
            BigDecimal baseExchangeRate1 = multiUnifInfo.getBaseConvsRate();
            BigDecimal baseExchangeRate2 = othermultiUnifInfo.getBaseConvsRate();
            if (baseExchangeRate1 == null) {
                baseExchangeRate1 = new BigDecimal("1.00");
            }
            if (baseExchangeRate2 == null) {
                baseExchangeRate2 = new BigDecimal("1.00");
            }
            BigDecimal baseQty = AbstractSproducetsBill.effectualNumeric(qty).multiply(baseExchangeRate1);
            int scale = 10;
            if (baseQty != null && qty != null) {
                scale = baseQty.scale() + qty.scale();
            }
            targetQty = AbstractSproducetsBill.effectualNumeric(baseQty).divide(AbstractSproducetsBill.effectualExchangeRate(baseExchangeRate2), scale != 0 ? scale : 10, 4);
        }
        return targetQty;
    }

    public static BigDecimal effectualNumeric(BigDecimal v) {
        return AbstractSproducetsBill.equalsZero(v) ? SysConstant.BIGZERO : v;
    }

    public static boolean equalsZero(BigDecimal v) {
        return v == null || SysConstant.BIGZERO.compareTo(v) == 0;
    }

    public static BigDecimal effectualExchangeRate(BigDecimal exchangeRate) {
        return AbstractSproducetsBill.isDistrustExchangeRate(exchangeRate) ? exchangeRate : new BigDecimal("1.0");
    }

    public static boolean isDistrustExchangeRate(BigDecimal exchangeRate) {
        return exchangeRate != null && exchangeRate.compareTo(SysConstant.BIGZERO) != 0 && exchangeRate.compareTo(SysConstant.BIGZERO) != -1;
    }
}

