/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.ncm.utils.BDCMUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderFacadeFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.ncm.bill.ActualHourEntryCollection;
import com.kingdee.eas.ncm.bill.ActualHourEntryInfo;
import com.kingdee.eas.ncm.bill.ActualHourInfo;
import com.kingdee.eas.ncm.bill.DataInputModeEnum;
import com.kingdee.eas.ncm.bill.HourTypeEnum;
import com.kingdee.eas.ncm.bill.NcmBillException;
import com.kingdee.eas.ncm.bill.TimeUnitEnum;
import com.kingdee.eas.ncm.bill.app.AbstractActualHourControllerBean;
import com.kingdee.eas.ncm.common.BillBaseStatusEnum;
import com.kingdee.eas.ncm.common.CMBillBaseInfo;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.common.NCMCostTypeEnum;
import com.kingdee.eas.ncm.common.utils.app.NCMDbBatchUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.ncm.common.utils.app.NCMServerUtils;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ActualHourControllerBean
extends AbstractActualHourControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ncm.bill.app.ActualHourControllerBean");
    private static final String STORAGE = "_storage";
    private static final String WORKCENTER = "_workCenter";
    private static final String COSTCENTER = "_costCenter";
    private static final String COSTOBJECT = "_costObejct";

    public String getMainTableName(Context ctx, IObjectPK[] model) throws EASBizException, BOSException {
        return "T_NCM_ActualHour";
    }

    public void checkStart(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        ActualHourInfo info = null;
        if (model instanceof ActualHourInfo) {
            info = (ActualHourInfo)model;
        }
        if (info != null && NCMCostTypeEnum.NORMAL.equals((Object)info.getCostType())) {
            super.checkStart(ctx, model);
        }
    }

    protected FilterInfo getFilterForCheckNumber(CoreBillBaseInfo model) {
        FilterInfo filter = super.getFilterForCheckNumber(model);
        ActualHourInfo info = (ActualHourInfo)model;
        FilterInfo temp = new FilterInfo();
        temp.getFilterItems().add(new FilterItemInfo("costType", (Object)info.getCostType().getValue()));
        try {
            filter.mergeFilter(temp, "and");
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        return filter;
    }

    protected void checkStart(Context ctx, IObjectCollection billColl) throws BOSException, EASBizException {
        if (billColl == null || billColl.isEmpty()) {
            return;
        }
        CMBillBaseInfo info = (CMBillBaseInfo)billColl.getObject(0);
        if (NCMCostTypeEnum.NORMAL.equals(info.get("costType"))) {
            super.checkStart(ctx, billColl);
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (!(model instanceof ActualHourInfo)) {
            return null;
        }
        ActualHourInfo actualHourInfo = (ActualHourInfo)model;
        if (actualHourInfo.getEntries() == null || actualHourInfo.getEntries().size() == 0) {
            return null;
        }
        this.check(ctx, actualHourInfo);
        ActualHourEntryCollection entry = actualHourInfo.getEntries();
        Iterator iter = entry.iterator();
        while (iter.hasNext()) {
            BigDecimal hour;
            ActualHourEntryInfo entryInfo = (ActualHourEntryInfo)iter.next();
            String unit = entryInfo.getTimeUnit().getValue();
            int factor = 1;
            if ("1".equals(unit)) {
                factor = 3600;
            }
            if ("2".equals(unit)) {
                factor = 60;
            }
            if ((hour = entryInfo.getHourSecond()) == null) {
                hour = new BigDecimal(0);
            }
            entryInfo.setHour(hour);
            hour = hour.multiply(new BigDecimal(factor));
            entryInfo.setHourSecond(hour);
        }
        return super._submit(ctx, model);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ActualHourInfo actualHourInfo = (ActualHourInfo)model;
        actualHourInfo.setBillStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        ActualHourEntryCollection entry = actualHourInfo.getEntries();
        Iterator iter = entry.iterator();
        String unit = "1";
        while (iter.hasNext()) {
            BigDecimal hour;
            ActualHourEntryInfo entryInfo = (ActualHourEntryInfo)iter.next();
            if (entryInfo.getTimeUnit() != null) {
                unit = entryInfo.getTimeUnit().getValue();
            }
            int factor = 1;
            if ("1".equals(unit)) {
                factor = 3600;
            }
            if ("2".equals(unit)) {
                factor = 60;
            }
            if ((hour = entryInfo.getHourSecond()) == null) {
                hour = new BigDecimal(0);
            }
            entryInfo.setHour(hour);
            hour = hour.multiply(new BigDecimal(factor));
            entryInfo.setHourSecond(hour);
        }
        return super._save(ctx, model);
    }

    protected Map bizCheckForSubmit(Context ctx, List ids, Map param) throws BOSException, EASBizException {
        final HashMap report = new HashMap();
        if (ids == null || ids.isEmpty()) {
            return report;
        }
        ArrayList<Object[]> idsParam = new ArrayList<Object[]>();
        int size = ids.size();
        for (int i = 0; i < size; ++i) {
            idsParam.add(new Object[]{ids.get(i)});
        }
        final String costCenterIsNull = ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"249_ActualHourControlBean_CostCenterIsNull", (Locale)ctx.getLocale());
        final String bizDateIsNull = ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"250_ActualHourControlBean_BizDateIsNull", (Locale)ctx.getLocale());
        StringBuffer kSql = new StringBuffer();
        kSql.append(" select FID,FCostCenterID,FBizDate \n");
        kSql.append("   from T_NCM_ActualHour \n");
        kSql.append("  where FID in (");
        for (int i = 0; i < 200; ++i) {
            if (i == 199) {
                kSql.append(" ? ");
                continue;
            }
            kSql.append(" ?, ");
        }
        kSql.append("    )");
        kSql.append("    and (FCostCenterID is null or FBizDate is null) \n");
        NCMDbBatchUtil.batchExecuteQuery((Context)ctx, (String)kSql.toString(), idsParam, (NCMDbBatchUtil.QueryCallbackHandler)new NCMDbBatchUtil.QueryCallbackHandler(){

            public int beforeBatchBindParams(PreparedStatement ps) throws SQLException {
                return 0;
            }

            public void processRow(ResultSet rs) throws SQLException {
                String id = rs.getString("FID");
                String costCenterID = rs.getString("FCostCenterID");
                Date date = rs.getDate("FBizDate");
                List detail = null;
                detail = report.containsKey(id) ? (List)report.get(id) : new ArrayList();
                if (costCenterID == null || costCenterID.length() == 0) {
                    detail.add(costCenterIsNull);
                }
                if (date == null) {
                    detail.add(bizDateIsNull);
                }
                report.put(id, detail);
            }
        });
        final String noEntry = ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"251_ActualHourControlBean_NoEntry", (Locale)ctx.getLocale());
        kSql.setLength(0);
        kSql.append(" select FID \n");
        kSql.append("   from T_NCM_ActualHour \n");
        kSql.append("  where FID in (");
        for (int i = 0; i < 200; ++i) {
            if (i == 199) {
                kSql.append(" ? ");
                continue;
            }
            kSql.append(" ?, ");
        }
        kSql.append("    )");
        kSql.append("    and FNumber is not null \n");
        kSql.append("    and FID not in (select FParentID from T_NCM_ActualHourEntry) \n");
        NCMDbBatchUtil.batchExecuteQuery((Context)ctx, (String)kSql.toString(), idsParam, (NCMDbBatchUtil.QueryCallbackHandler)new NCMDbBatchUtil.QueryCallbackHandler(){

            public int beforeBatchBindParams(PreparedStatement ps) throws SQLException {
                return 0;
            }

            public void processRow(ResultSet rs) throws SQLException {
                String id = rs.getString("FID");
                List<String> detail = null;
                detail = report.containsKey(id) ? (List)report.get(id) : new ArrayList<String>();
                detail.add(noEntry);
                report.put(id, detail);
            }
        });
        final String noCostObjectInEntry = ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"252_ActualHourControlBean_NoCostObjectInEntry", (Locale)ctx.getLocale());
        final String errorHourInEntry = ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"253_ActualHourControlBean_ErrorHourInEntry", (Locale)ctx.getLocale());
        kSql.setLength(0);
        kSql.append(" select FParentID, FCostObjectID, FHourSecond \n");
        kSql.append("   from T_NCM_ActualHourEntry \n");
        kSql.append("  where FParentID in (");
        for (int i = 0; i < 200; ++i) {
            if (i == 199) {
                kSql.append(" ? ");
                continue;
            }
            kSql.append(" ?, ");
        }
        kSql.append("    )");
        kSql.append("    and (FCostObjectID is null or FHourSecond is null or FHourSecond <= 0) \n");
        NCMDbBatchUtil.batchExecuteQuery((Context)ctx, (String)kSql.toString(), idsParam, (NCMDbBatchUtil.QueryCallbackHandler)new NCMDbBatchUtil.QueryCallbackHandler(){

            public int beforeBatchBindParams(PreparedStatement ps) throws SQLException {
                return 0;
            }

            public void processRow(ResultSet rs) throws SQLException {
                String id = rs.getString("FParentID");
                String costObjectID = rs.getString("FCostObjectID");
                BigDecimal hour = rs.getBigDecimal("FHourSecond");
                List detail = null;
                detail = report.containsKey(id) ? (List)report.get(id) : new ArrayList();
                if (costObjectID == null || costObjectID.length() == 0) {
                    detail.add(noCostObjectInEntry);
                }
                if (hour == null || hour.compareTo(SysConstant.BIGZERO) <= 0) {
                    detail.add(errorHourInEntry);
                }
                report.put(id, detail);
            }
        });
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("costCenter.number"));
        sic.add(new SelectorItemInfo("costCenter.name"));
        sic.add(new SelectorItemInfo("entries.*"));
        sic.add(new SelectorItemInfo("entries.costObject.id"));
        sic.add(new SelectorItemInfo("entries.costObject.name"));
        sic.add(new SelectorItemInfo("entries.costObject.number"));
        HashSet idSet = new HashSet(ids);
        HashMap noInputMap = new HashMap();
        try {
            this.batchCheck(ctx, ids, noInputMap, param.get("companyID").toString());
        }
        catch (NcmBillException exc) {
            if (exc.getSubCode().equals(NcmBillException.NO_ANYINPUT_FORACTUALHOUR.getCode()) || exc.getSubCode().equals(NcmBillException.NO_INPUT_FORACTUALHOUR.getCode())) {
                List<String> detail = null;
                Iterator itr = noInputMap.keySet().iterator();
                String billId = null;
                StringBuffer value = null;
                while (itr.hasNext()) {
                    billId = itr.next().toString();
                    value = (StringBuffer)noInputMap.get(billId);
                    detail = report.containsKey(billId) ? (List)report.get(billId) : new ArrayList<String>();
                    detail.add(value.toString());
                    report.put(billId, detail);
                }
            }
            throw exc;
        }
        return report;
    }

    private void check(Context ctx, ActualHourInfo actualHourInfo) throws BOSException, EASBizException {
        ActualHourEntryCollection entrys = actualHourInfo.getEntries();
        int size = entrys.size();
        ArrayList<CostObjectInfo> cos = new ArrayList<CostObjectInfo>(size);
        for (int i = 0; i < size; ++i) {
            if (entrys.get(i).getCostObject() == null) continue;
            cos.add(entrys.get(i).getCostObject());
        }
        CostObjectInfo[] costObjects = new CostObjectInfo[cos.size()];
        for (int i = 0; i < cos.size(); ++i) {
            costObjects[i] = (CostObjectInfo)cos.get(i);
        }
        NCMServerUtils.checkInputQty((Context)ctx, (CompanyOrgUnitInfo)actualHourInfo.getCompanyOrg(), (PeriodInfo)actualHourInfo.getCalculatePeriod(), (CostCenterOrgUnitInfo)actualHourInfo.getCostCenter(), (CostObjectInfo[])costObjects);
    }

    private void batchCheck(Context ctx, List ids, Map noInputMap, String companyId) throws BOSException, EASBizException {
        String tempTable = null;
        StringBuffer sql = new StringBuffer();
        try {
            sql.append("create table tmp(").append("\r\n");
            sql.append("FBillID VARCHAR(44),").append("\r\n");
            sql.append("FCostObjectID VARCHAR(44),").append("\r\n");
            sql.append("FCostCenterID VARCHAR(44),").append("\r\n");
            sql.append("FCompanyOrg VARCHAR(44),").append("\r\n");
            sql.append("FCalculatePeriod VARCHAR(44),").append("\r\n");
            sql.append("FHasQty int default 0 )").append("\r\n");
            tempTable = NCMDbUtil.createTempTable((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append("insert into ").append(tempTable).append(" (FBillID, FCostObjectID, FCostCenterID, FCompanyOrg, FCalculatePeriod) ").append(" select bill.FID, entry.FCostObjectID, bill.FCostCenterID, bill.FCompanyOrg, bill.FCalculatePeriod").append(" from T_NCM_ActualHour bill").append(" inner join T_NCM_ActualHourEntry entry on bill.fid = entry.fparentid").append(" where Bill.fid in (").append(BDCMUtils.splitPK((Collection)ids)).append(")");
            NCMDbUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append(" update ").append(tempTable).append(" t set FHasQty = 1 WHERE EXISTS (");
            sql.append(" select 1  ");
            sql.append("   from T_NCM_InputQtyBillEntry billEntry ");
            sql.append("\t     left outer join T_NCM_InputQtyBill bill ");
            sql.append("\t        on bill.FID = billEntry.FParentID ");
            sql.append("\t     left outer join T_ORG_CostCenter cc ");
            sql.append("\t        on cc.fid = bill.FCostCenterOrgUnitID ");
            sql.append("  where bill.FCompanyOrg = t.FCompanyOrg ");
            sql.append("    and bill.FCalculatePeriod = t.FCalculatePeriod ");
            sql.append("    and bill.FCostCenterOrgUnitID = t.FCostCenterID ");
            sql.append("    and bill.FBillStatus = 4 ");
            sql.append("    and cc.FCostCenterType = 0 ");
            sql.append("    and billEntry.FCostObjectId = t.FCostObjectID");
            sql.append("  group by billEntry.FCostObjectId having ISNULL(SUM(billEntry.FQty),0) <> 0 )");
            NCMDbUtil.execute((Context)ctx, (String)sql.toString());
            String tblBalance = null;
            try {
                tblBalance = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_Balance");
            }
            catch (SQLException exc) {
                logger.error((Object)exc.getMessage(), (Throwable)exc);
                throw new BOSException((Throwable)exc);
            }
            sql.setLength(0);
            sql.append(" update ").append(tempTable).append(" t set FHasQty = 1 WHERE EXISTS (");
            sql.append(" select 1  ");
            sql.append("   from ").append(tblBalance).append(" bal");
            sql.append("  where bal.FCompanyOrg = t.FCompanyOrg ");
            sql.append("    and bal.FCalculatePeriodID =  t.FCalculatePeriod ");
            sql.append("    and bal.FCostCenterID =  t.FCostCenterID ");
            sql.append("    and bal.FCostObjectId =  t.FCostObjectId ");
            sql.append(" group by bal.FCostObjectID HAVING ISNULL(SUM(bal.FBopWIPQty),0) <>0 )");
            NCMDbUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append(" select t.FBillId FBillId, co.Fid FCostObjectID, co.Fnumber FCostObjectNumber, co.Fname_l2 FCostObjectName, ");
            sql.append(" cc.FId FCostCenterID, cc.Fnumber FCostCenterNumber, cc.Fname_l2 FCostCenterName ");
            sql.append("   from ").append(tempTable).append(" t");
            sql.append("   inner join T_BD_CostObject co on co.fid = t.FCostObjectID ");
            sql.append("   inner join T_ORG_CostCenter cc on cc.fid = t.FCostCenterID ");
            sql.append("  where t.FHasQty = 0 ");
            IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString());
            String billId = null;
            StringBuffer detail = null;
            while (rs.next()) {
                billId = rs.getString("FBillId");
                detail = noInputMap.containsKey(billId) ? (StringBuffer)noInputMap.get(billId) : new StringBuffer();
                detail.append("\u6210\u672c\u5bf9\u8c61\u3010").append(rs.getString("FCostObjectNumber")).append(" ").append(rs.getString("FCostObjectName")).append("\u3011").append("\u5728\u6210\u672c\u4e2d\u5fc3\u3010").append(rs.getString("FCostCenterNumber")).append(" ").append(rs.getString("FCostCenterName")).append("\u3011\u672a\u6295\u4ea7").append("\r\n");
                noInputMap.put(billId, detail);
            }
            if (!noInputMap.isEmpty()) {
                throw new NcmBillException(NcmBillException.NO_INPUT_FORACTUALHOUR);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                NCMDbUtil.releaseTempTable((Context)ctx, tempTable);
                throw throwable;
            }
        }
        NCMDbUtil.releaseTempTable((Context)ctx, (String)tempTable);
    }

    @Override
    protected Set _getCondition(Context ctx, String companyID) throws BOSException {
        HashSet conditions = new HashSet();
        StringBuffer getCondition = new StringBuffer();
        getCondition.append(" SELECT FStorageID,FWorkCenterID,FCostCenterID,FCostObjectID \n ");
        getCondition.append("FROM T_NCM_INDUCTHOURCONDITION \n");
        getCondition.append("WHERE FCompanyID = '");
        getCondition.append(companyID);
        getCondition.append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)getCondition.toString());
        if (rs != null) {
            try {
                while (rs.next()) {
                    HashMap<String, String> condition = new HashMap<String, String>();
                    condition.put(STORAGE, rs.getString(1));
                    condition.put(WORKCENTER, rs.getString(2));
                    condition.put(COSTCENTER, rs.getString(3));
                    condition.put("_costObject", rs.getString(4));
                    conditions.add(condition);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return conditions;
    }

    @Override
    protected boolean _inductData(Context ctx, boolean isRecover, CompanyOrgUnitInfo company, PeriodInfo period, Set condition, String sumMode) throws BOSException {
        boolean reuslt = false;
        String result = "";
        String stempTableName = this.createInductDataTable(ctx);
        try {
            result = ManufactureOrderFacadeFactory.getLocalInstance((Context)ctx).getFetchHourDataByBill(period, condition, stempTableName);
        }
        catch (Exception e1) {
            throw new BOSException((Throwable)e1);
        }
        String getImportCount = "select * from " + stempTableName;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)getImportCount);
        if (rs == null || rs.size() == 0) {
            throw new BOSException("\u65e0\u5408\u6cd5\u6570\u636e\u5f15\u5165\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u5f15\u5165\u6761\u4ef6\uff0c\u518d\u505a\u5f15\u5165\u64cd\u4f5c\u3002");
        }
        try {
            this.initInductData(ctx, stempTableName, company.getId().toString());
            if (isRecover && "1".equals(sumMode)) {
                this.updateInductDataByCCCo(ctx, stempTableName, company.getId().toString());
            }
            if (isRecover && "2".equals(sumMode)) {
                this.updateInductDataByOrder(ctx, stempTableName, company.getId().toString());
            }
            if (!isRecover && "1".equals(sumMode)) {
                this.insertInductDataByCCCo(ctx, stempTableName, company.getId().toString());
            }
            if (!isRecover && "2".equals(sumMode)) {
                this.insertInductDataByOrder(ctx, stempTableName, company.getId().toString());
            }
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        if ("Success".equals(result)) {
            reuslt = true;
        }
        return reuslt;
    }

    private void initInductData(Context ctx, String stempTableName, String companyID) throws BOSException, EASBizException, SQLException {
        StringBuffer ksql = new StringBuffer();
        ksql.append("update " + stempTableName + " \n");
        ksql.append("set (FMaterialID, FLot) = ( \n");
        ksql.append("    select mo.FMaterialID, mo.FLot from T_MM_ManufactureOrder mo \n");
        ksql.append("    where mo.FID = " + stempTableName + ".FManufactureOrderID \n");
        ksql.append(") \n");
        ksql.append("; \n");
        ksql.append("update " + stempTableName + " \n");
        ksql.append("set FCostObjectID = ( \n");
        ksql.append("    select top 1 FID from T_BD_CostObject co \n");
        ksql.append("    where co.FCompanyID = '" + companyID + "' \n");
        ksql.append("    and co.FIsForbiden = 0 \n");
        ksql.append("    and ( \n");
        ksql.append("        co.FCalculateMode = 7 \n");
        ksql.append("        and co.FOrderID = " + stempTableName + ".FManufactureOrderID \n");
        ksql.append("        or \n");
        ksql.append("        co.FCalculateMode in (1, 3) \n");
        ksql.append("        and co.FStdProductIDID = " + stempTableName + ".FMaterialID \n");
        ksql.append("        or \n");
        ksql.append("        co.FCalculateMode = 4 \n");
        ksql.append("        and co.FStdProductIDID = " + stempTableName + ".FMaterialID \n");
        ksql.append("        and ( \n");
        ksql.append("            co.FBatchNumber = " + stempTableName + ".FLot \n");
        ksql.append("            or \n");
        ksql.append("            co.FBatchNumber is null and " + stempTableName + ".FLot is null \n");
        ksql.append("        ) \n");
        ksql.append("        or \n");
        ksql.append("        co.FCalculateMode = 3 \n");
        ksql.append("        and co.FID in ( \n");
        ksql.append("            select ");
        ksql.append("                coe.FParentID ");
        ksql.append("            from T_BD_CostObjectEntry coe ");
        ksql.append("            where coe.FParentID = co.FID \n");
        ksql.append("            and FRelatedID = " + stempTableName + ".FMaterialID \n");
        ksql.append("        ) \n");
        ksql.append("    ) \n");
        ksql.append(") \n");
        ksql.append("where FCostObjectID is null \n");
        ksql.append("; \n");
        NCMServerUtils.BatchSqlExecute((Context)ctx, (String)ksql.toString());
    }

    @Override
    protected void _saveCondition(Context ctx, String companyID, Set conditonData) throws BOSException, EASBizException {
        this.deleteCondition(ctx, companyID);
        StringBuffer insertSql = new StringBuffer();
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        HashMap map2 = null;
        for (HashMap map2 : conditonData) {
            String storageInfoID;
            if (map2 == null) continue;
            insertSql.append(" insert into T_NCM_INDUCTHOURCONDITION (FID,FCOMPANYID,FSTORAGEID,FWORKCENTERID,FCOSTCENTERID,FCOSTOBJECTID,FUSERID) values(newbosid('E65D2506'),");
            if (companyID != null) {
                insertSql.append("'" + companyID + "',");
            }
            if ((storageInfoID = (String)map2.get(STORAGE)) != null && storageInfoID.length() != 0) {
                insertSql.append("'" + storageInfoID + "',");
            } else {
                insertSql.append(" null,");
            }
            String workCenterInfoID = (String)map2.get(WORKCENTER);
            if (workCenterInfoID != null && workCenterInfoID.length() != 0) {
                insertSql.append("'" + workCenterInfoID + "',");
            } else {
                insertSql.append(" null ,");
            }
            String costCenterInfoID = (String)map2.get(COSTCENTER);
            if (costCenterInfoID != null && costCenterInfoID.length() != 0) {
                insertSql.append("'" + costCenterInfoID + "',");
            } else {
                insertSql.append(" null ,");
            }
            String costObjectInfoID = (String)map2.get(COSTOBJECT);
            if (costObjectInfoID != null && costObjectInfoID.length() != 0) {
                insertSql.append("'" + costObjectInfoID + "',");
            } else {
                insertSql.append(" null ,");
            }
            if (userInfo != null) {
                insertSql.append("'" + userInfo.getId().toString() + "'");
            }
            insertSql.append(" );");
        }
        NCMServerUtils.BatchSqlExecute((Context)ctx, (String)insertSql.toString());
    }

    @Override
    protected IRowSet _getConditionCount(Context ctx, String companyID) throws BOSException {
        StringBuffer SelectSql = new StringBuffer();
        IRowSet rowSet = null;
        SelectSql.append("select getNumber.FCostCenterID,costCenter.FNumber,costCenter.FName_L2,").append(" getNumber.FCostObjectID,costObject.FNumber,costObject.Fname_L2,material.FModel, ").append(" getNumber.FStorageID,storage.FNumber,storage.FName_L2,").append(" getNumber.FWorkCenterID,workCenter.FNumber,workCenter.FName_L2").append(" from T_NCM_INDUCTHOURCONDITION getNumber ").append(" left join T_ORG_CostCenter costCenter ").append(" on costCenter.fid=getNumber.FCostCenterID").append(" left join T_BD_CostObject costObject").append(" on costObject.fid=getNumber.FCostObjectID").append(" left join T_BD_Material material").append(" on costObject.FStdProductIDID=material.FID").append(" left join t_ORG_BaseUnit storage").append(" on storage.fid = getNumber.FStorageID").append(" left join t_MM_WorkCenter workCenter").append(" on workCenter.fid = getNumber.FWorkCenterID").append(" where getNumber.FCompanyID=? ");
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)SelectSql.toString(), (Object[])new Object[]{companyID});
            return rowSet;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void deleteCondition(Context ctx, String companyId) throws BOSException {
        StringBuffer deteleSql = new StringBuffer();
        deteleSql.append("delete T_NCM_INDUCTHOURCONDITION where fcompanyid='");
        deteleSql.append(companyId + "'");
        DbUtil.execute((Context)ctx, (String)deteleSql.toString());
    }

    @Override
    protected String _checkCondition(Context ctx, String companyID) throws BOSException, EASBizException {
        StringBuffer result = new StringBuffer();
        try {
            result.append(this.checkWorCenter(ctx, companyID));
            result.append("//");
            result.append(this.checkCostCenter(ctx, companyID));
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer checkWorCenter(Context ctx, String companyID) throws BOSException, SQLException {
        StringBuffer checkResult = new StringBuffer();
        IOrgUnitRelation iOUR = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        StringBuffer sql = new StringBuffer();
        sql.append("    SELECT workCenter.Fid,workCenter.FNumber,workCenter.FName_l2 From  \n").append("    T_MM_WORKCENTER workCenter  \n").append("    WHERE workCenter.FCostCenterID is null AND workCenter.FStorageOrgUnitID IN ( ");
        try {
            OrgUnitCollection ccColl = iOUR.getFromUnit(companyID, 1, 4);
            for (int i = 0; i < ccColl.size(); ++i) {
                sql.append("'").append(ccColl.get(i).getId().toString()).append("',");
            }
        }
        catch (EASBizException e) {
            throw new SQLException(e.getMessage());
        }
        String exSql = sql.substring(1, sql.length() - 1);
        exSql = exSql + ")";
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)exSql);
            int i = 1;
            while (rs.next()) {
                checkResult.append(i + ". \u5de5\u4f5c\u4e2d\u5fc3" + rs.getString(2) + "\u6ca1\u6709\u6307\u5b9a\u6210\u672c\u4e2d\u5fc3\u3002\n");
                ++i;
            }
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        return checkResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer checkCostCenter(Context ctx, String companyID) throws BOSException, SQLException {
        StringBuffer checkResult = new StringBuffer();
        StringBuffer sql = new StringBuffer();
        sql.append("    SELECT cc.FID,cc.FNumber,cc.FName_l2 FROM T_NCM_INDUCTHOURCONDITION m \n").append("    INNER JOIN T_ORG_CostCenter cc ON cc.FID = m.FCostCenterID \n").append("    WHERE NOT EXISTS (SELECT FID FROM T_MM_WORKCENTER wc where wc.FCostCenterID = m.FCostCenterID) \n").append("AND m.FCompanyID = '").append(companyID + "'");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            int i = 1;
            while (rs.next()) {
                checkResult.append(i + ". \u6210\u672c\u4e2d\u5fc3" + rs.getString(2) + "\u6ca1\u6709\u5bf9\u5e94\u7684\u5de5\u4f5c\u4e2d\u5fc3\u3002\n");
                ++i;
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs);
        return checkResult;
    }

    private void updateInductDataByOrder(Context ctx, String stempTableName, String companyID) throws BOSException, EASBizException {
        StringBuffer delete = new StringBuffer();
        ISystemStatusCtrol ibiz = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        PeriodInfo periodInfo = ibiz.getCacheCurrentPeriod(1001, companyID);
        delete.append("DELETE FROM T_NCM_ACTUALHOUR WHERE FCompanyOrg = '" + companyID + "' \n");
        delete.append("    AND FCalculatePeriod = '" + periodInfo.getId().toString() + "' \n");
        delete.append("    AND EXISTS (SELECT T_NCM_ACTUALHOURENTRY.FID FROM T_NCM_ACTUALHOURENTRY \n");
        delete.append("    WHERE T_NCM_ACTUALHOURENTRY.FParentID = T_NCM_ACTUALHOUR.FID AND FInputMode = 3); \n\n ");
        DbUtil.execute((Context)ctx, (String)delete.toString());
        delete.setLength(0);
        delete.append("DELETE FROM T_NCM_ACTUALHOURENTRY WHERE FInputMode = 3 \n");
        delete.append("    AND NOT EXISTS (SELECT T_NCM_ACTUALHOUR.FID FROM T_NCM_ACTUALHOUR \n");
        delete.append("    WHERE T_NCM_ACTUALHOUR.FID = T_NCM_ACTUALHOURENTRY.FParentID); \n\n");
        DbUtil.execute((Context)ctx, (String)delete.toString());
        try {
            this.insertInductDataByOrder(ctx, stempTableName, companyID);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void updateInductDataByCCCo(Context ctx, String stempTableName, String companyID) throws BOSException, EASBizException {
        StringBuffer delete = new StringBuffer();
        ISystemStatusCtrol ibiz = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        PeriodInfo periodInfo = ibiz.getCacheCurrentPeriod(1001, companyID);
        delete.append("DELETE FROM T_NCM_ACTUALHOUR WHERE FCompanyOrg = '" + companyID + "' \n");
        delete.append("    AND FCalculatePeriod = '" + periodInfo.getId().toString() + "' \n");
        delete.append("    AND EXISTS (SELECT T_NCM_ACTUALHOURENTRY.FID FROM T_NCM_ACTUALHOURENTRY \n");
        delete.append("    WHERE T_NCM_ACTUALHOURENTRY.FParentID = T_NCM_ACTUALHOUR.FID AND FInputMode = 3); \n\n ");
        DbUtil.execute((Context)ctx, (String)delete.toString());
        delete.setLength(0);
        delete.append("DELETE FROM T_NCM_ACTUALHOURENTRY WHERE FInputMode = 3 \n");
        delete.append("    AND NOT EXISTS (SELECT T_NCM_ACTUALHOUR.FID FROM T_NCM_ACTUALHOUR \n");
        delete.append("    WHERE T_NCM_ACTUALHOUR.FID = T_NCM_ACTUALHOURENTRY.FParentID); \n\n");
        DbUtil.execute((Context)ctx, (String)delete.toString());
        try {
            this.insertInductDataByCCCo(ctx, stempTableName, companyID);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void insertInductDataByOrder(Context ctx, String stempTableName, String companyID) throws BOSException, EASBizException, SQLException {
        StringBuffer sql = new StringBuffer();
        ISystemStatusCtrol ibiz = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        PeriodInfo periodInfo = ibiz.getCacheCurrentPeriod(1001, companyID);
        sql.append("    SELECT FManufactureOrderID,FCostCenterID,FCostObjectID,FHourType,FTimeUnit,sum(FHourSecond)").append("    FROM ").append(stempTableName).append(" group by FManufactureOrderID,FCostCenterID,FCostObjectID,FHourType,FTimeUnit having sum(FHourSecond) <> 0").append(" order by FCostCenterID,FManufactureOrderID");
        IRowSet querySet = DBUtil.executeQuery((Context)ctx, (String)sql.toString());
        boolean isExistCodingRule = this.isExistCodingRule(ctx, new ActualHourInfo(), companyID);
        if (!isExistCodingRule) {
            throw new CMBillException(CMBillException.NOCORDRULE, new Object[]{"\u5b9e\u9645\u5de5\u65f6"});
        }
        ActualHourInfo hourInfo = null;
        String costCenterID = "";
        while (querySet.next()) {
            if (costCenterID != null && !costCenterID.equals(querySet.getString(2))) {
                if (costCenterID.length() > 0) {
                    this._addnew(ctx, (IObjectValue)hourInfo);
                }
                hourInfo = new ActualHourInfo();
                costCenterID = querySet.getString(2);
            }
            hourInfo.setCalculatePeriod(periodInfo);
            CostCenterOrgUnitInfo cc = new CostCenterOrgUnitInfo();
            if (querySet.getString(2) != null && !"".equals(querySet.getString(2))) {
                cc.setId(BOSUuid.read((String)querySet.getString(2)));
            }
            hourInfo.setCostCenter(cc);
            CompanyOrgUnitInfo companyInfo = new CompanyOrgUnitInfo();
            companyInfo.setId(BOSUuid.read((String)companyID));
            hourInfo.setCompanyOrg(companyInfo);
            hourInfo.setBillStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
            hourInfo.setCostType(NCMCostTypeEnum.NORMAL);
            java.util.Date bizData = this.getBizData(periodInfo);
            hourInfo.setBizDate(bizData);
            BOSUuid id = BOSUuid.create((BOSObjectType)hourInfo.getBOSType());
            hourInfo.setId(id);
            ActualHourEntryInfo entryInfo = new ActualHourEntryInfo();
            CostObjectInfo co = new CostObjectInfo();
            if (querySet.getString(3) != null && !"".equals(querySet.getString(3))) {
                co.setId(BOSUuid.read((String)querySet.getString(3)));
            }
            entryInfo.setCostObject(co);
            entryInfo.setHourSecond(querySet.getBigDecimal(6).setScale(2, 4));
            if (!"7".equals(querySet.getString(4)) && !"8".equals(querySet.getString(4))) continue;
            entryInfo.setHourType(HourTypeEnum.getEnum(String.valueOf(querySet.getInt(4) + 1)));
            if (querySet.getInt(5) == 2) {
                entryInfo.setTimeUnit(TimeUnitEnum.HOUR);
            }
            if (querySet.getInt(5) == 3) {
                entryInfo.setTimeUnit(TimeUnitEnum.MINUTES);
            }
            if (querySet.getInt(5) == 4) {
                entryInfo.setTimeUnit(TimeUnitEnum.SCEOND);
            }
            ManufactureOrderInfo manufactureOrderInfo = new ManufactureOrderInfo();
            if (querySet.getString(1) != null && !"".equals(querySet.getString(1))) {
                manufactureOrderInfo.setId(BOSUuid.read((String)querySet.getString(1)));
            }
            entryInfo.setManufactureOrder(manufactureOrderInfo);
            BOSUuid entryID = BOSUuid.create((BOSObjectType)entryInfo.getBOSType());
            entryInfo.setId(entryID);
            entryInfo.setInputMode(DataInputModeEnum.INDUCT);
            hourInfo.getEntries().add(entryInfo);
        }
        if (hourInfo != null) {
            this._addnew(ctx, (IObjectValue)hourInfo);
        }
    }

    private void insertInductDataByCCCo(Context ctx, String stempTableName, String companyID) throws BOSException, EASBizException, SQLException {
        StringBuffer sql = new StringBuffer();
        ISystemStatusCtrol ibiz = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        PeriodInfo periodInfo = ibiz.getCacheCurrentPeriod(1001, companyID);
        sql.append("    SELECT FCostCenterID,FCostObjectID,FHourType,FTimeUnit,sum(FHourSecond)").append("    FROM ").append(stempTableName).append(" group by FCostCenterID,FCostObjectID,FHourType,FTimeUnit having sum(FHourSecond) <> 0 ").append(" order by FCostCenterID");
        IRowSet querySet = DBUtil.executeQuery((Context)ctx, (String)sql.toString());
        boolean isExistCodingRule = this.isExistCodingRule(ctx, new ActualHourInfo(), companyID);
        if (!isExistCodingRule) {
            throw new CMBillException(CMBillException.NOCORDRULE, new Object[]{"\u5b9e\u9645\u5de5\u65f6"});
        }
        ActualHourInfo hourInfo = new ActualHourInfo();
        String costCenterID = "";
        if (querySet != null && querySet.size() == 0) {
            throw new BOSException("\u65e0\u6570\u636e\u53ef\u5f15\u5165\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u5f15\u5165\u6761\u4ef6\uff0c\u518d\u505a\u5f15\u5165\u64cd\u4f5c\u3002");
        }
        while (querySet.next()) {
            if (costCenterID != null && !costCenterID.equals(querySet.getString(1))) {
                if (costCenterID.length() > 0) {
                    this._addnew(ctx, (IObjectValue)hourInfo);
                }
                hourInfo = new ActualHourInfo();
                costCenterID = querySet.getString(1);
            }
            hourInfo.setCalculatePeriod(periodInfo);
            CostCenterOrgUnitInfo cc = new CostCenterOrgUnitInfo();
            if (querySet.getString(1) != null && !"".equals(querySet.getString(1))) {
                cc.setId(BOSUuid.read((String)querySet.getString(1)));
            }
            hourInfo.setCostCenter(cc);
            CompanyOrgUnitInfo companyInfo = new CompanyOrgUnitInfo();
            companyInfo.setId(BOSUuid.read((String)companyID));
            hourInfo.setCompanyOrg(companyInfo);
            hourInfo.setBillStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
            hourInfo.setCostType(NCMCostTypeEnum.NORMAL);
            java.util.Date bizData = this.getBizData(periodInfo);
            hourInfo.setBizDate(bizData);
            BOSUuid id = BOSUuid.create((BOSObjectType)hourInfo.getBOSType());
            hourInfo.setId(id);
            ActualHourEntryInfo entryInfo = new ActualHourEntryInfo();
            CostObjectInfo co = new CostObjectInfo();
            if (querySet.getString(2) != null && !"".equals(querySet.getString(2))) {
                co.setId(BOSUuid.read((String)querySet.getString(2)));
            }
            entryInfo.setCostObject(co);
            entryInfo.setHourSecond(querySet.getBigDecimal(5).setScale(2, 4));
            if (!"7".equals(querySet.getString(3)) && !"8".equals(querySet.getString(3))) continue;
            entryInfo.setHourType(HourTypeEnum.getEnum(String.valueOf(querySet.getInt(3) + 1)));
            if (querySet.getInt(4) == 2) {
                entryInfo.setTimeUnit(TimeUnitEnum.HOUR);
            }
            if (querySet.getInt(4) == 3) {
                entryInfo.setTimeUnit(TimeUnitEnum.MINUTES);
            }
            if (querySet.getInt(4) == 4) {
                entryInfo.setTimeUnit(TimeUnitEnum.SCEOND);
            }
            BOSUuid entryID = BOSUuid.create((BOSObjectType)entryInfo.getBOSType());
            entryInfo.setId(entryID);
            entryInfo.setInputMode(DataInputModeEnum.INDUCT);
            hourInfo.getEntries().add(entryInfo);
        }
        if (hourInfo != null) {
            this._addnew(ctx, (IObjectValue)hourInfo);
        }
    }

    private String createInductDataTable(Context ctx) throws BOSException {
        String stempTableName;
        StringBuffer createSql = new StringBuffer();
        createSql.append(" CREATE TABLE t1(");
        createSql.append("FStorageID varchar(44),");
        createSql.append(" FProcessID varchar(44),");
        createSql.append("FManufactureOrderID varchar(44),");
        createSql.append("FCostCenterID varchar(44),");
        createSql.append("FCostObjectID varchar(44),");
        createSql.append("FMaterialID varchar(44),");
        createSql.append("FLot nvarchar(255),");
        createSql.append("FHourType int ,");
        createSql.append("FTimeUnit int ,");
        createSql.append("FHourSecond decimal(28,13) not null default(0))");
        try {
            stempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(createSql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return stempTableName;
    }

    private java.util.Date getBizData(PeriodInfo periodInfo) {
        Timestamp bizDate = periodInfo.getEndDate();
        return bizDate;
    }

    private boolean isExistCodingRule(Context ctx, CMBillBaseInfo info, String companyID) throws BOSException, EASBizException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        return iCodingRuleManager.isExist((IObjectValue)info, companyID);
    }
}

