/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.InnerOverHead;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.ncm.AllocStdUnitFactory;
import com.kingdee.eas.basedata.ncm.AllocStdUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.bill.AllocUnitLevelEnum;
import com.kingdee.eas.ncm.bill.AllocateException;
import com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.InnerOverHead.BaseStrategy;
import com.kingdee.eas.ncm.bill.app.Alloc.helper.AllocUtils;
import com.kingdee.util.Assert;
import java.text.MessageFormat;
import java.util.Map;
import org.apache.log4j.Logger;

public class UserDefinedStrategy
extends BaseStrategy {
    private static Logger logger = Logger.getLogger((String)UserDefinedStrategy.class.getName());
    private String _factor;
    private Context _ctx;
    private String _fieldFlag;
    private AllocUnitLevelEnum _unitLevel;

    public UserDefinedStrategy(Map param, String factor) throws AllocateException {
        super(param);
        Assert.that((boolean)param.containsKey("ctx"));
        Assert.that((factor != null ? 1 : 0) != 0);
        this._factor = factor;
        this._ctx = (Context)this._param.get("ctx");
        this.initUnitInfo();
    }

    @Override
    public String GetAllocStdDataSql() throws AllocateException {
        super.GetAllocStdDataSql();
        StringBuffer sb = new StringBuffer();
        sb.append("UPDATE {0} SET {1} = (").append('\n').append("\tSELECT ISNULL(SUM(PARENT.FQty),0) As FQty ").append('\n').append("\tFROM T_NCM_UserDefinedData PARENT ").append('\n').append("\tINNER JOIN {2} R ON R.FCostCenterID=PARENT.FCostCenterID AND R.FCostObjectID=PARENT.FCostObjectID ").append('\n').append("\tWHERE R.FID={3}.FID AND PARENT.FCompanyID = ''{4}'' AND PARENT.FCalculatePeriodID = ''{5}'' ").append('\n').append("\t  AND PARENT.FAllocStdUnitID=''{6}'' ").append('\n').append(") ");
        return MessageFormat.format(sb.toString(), this._tblAllocData, this._fldFlag, this._tblObjectRange, this._tblAllocData, this._companyId, this._periodId, this._factor);
    }

    @Override
    public AllocUnitLevelEnum GetAllocUnitLevel() {
        return this._unitLevel;
    }

    @Override
    public String GetFieldFlag() {
        return this._fieldFlag;
    }

    @Override
    public String[] GetNoAllocStdDataHint() throws AllocateException {
        String[] ret = new String[]{AllocUtils.getAllocResource(this._ctx, "NoData_Hint_UserData_0"), AllocUtils.getAllocResource(this._ctx, "NoData_Hint_UserData_1")};
        return ret;
    }

    private void initUnitInfo() throws AllocateException {
        AllocStdUnitInfo unit;
        ObjectUuidPK pk = new ObjectUuidPK(this._factor);
        try {
            unit = AllocStdUnitFactory.getLocalInstance((Context)this._ctx).getAllocStdUnitInfo((IObjectPK)pk);
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e);
        }
        this._fieldFlag = "F" + unit.getNumber().trim();
        this._unitLevel = AllocUnitLevelEnum.OBJECT;
    }
}

