/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Fee;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.sql.DbType;
import com.kingdee.eas.ncm.bill.AllocateException;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Fee.MatFeeData;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Table.AllocTable;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class MatReqFeeData
extends MatFeeData {
    private static Logger logger = Logger.getLogger((String)MatReqFeeData.class.getName());

    public MatReqFeeData(Map param) {
        super(param);
    }

    @Override
    protected MetaDataPK setMetaDataPK() {
        return new MetaDataPK("com.kingdee.eas.ncm.bill.app", "MaterialAllocFeeGroupQuery");
    }

    @Override
    protected String setTblAllocResult() {
        return "T_NCM_MatAllocResult";
    }

    @Override
    protected String setAllocBillType() {
        return "MF";
    }

    @Override
    public void buildTargetBillEntryID(String tblResult) throws Exception {
        Context ctx = (Context)this.param.get("ctx");
        AllocTable allocTable = (AllocTable)this.param.get("allocTable");
        String tblToAlloc = allocTable.GetToAllocBillEntryIDTable();
        StringBuffer ksql = new StringBuffer();
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)this.mdPk);
        FilterInfo filter = (FilterInfo)((FilterInfo)this.param.get("filterInfo")).clone();
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        exec.setObjectView(view);
        String sql = exec.getSQL();
        sql = this.parseQuerySql(tblResult, sql);
        ksql.setLength(0);
        ksql.append("insert into " + tblToAlloc + " ( \n");
        ksql.append("    FSourceBillEntryID, \n");
        ksql.append("    FIsDirect \n");
        ksql.append(") \n");
        ksql.append(sql);
        ksql.append(" \n");
        ksql.append("; \n");
        NCMDbUtil.BatchSqlExecute((Context)ctx, (String)ksql.toString(), (String)";");
        ((TempTablePool)this.param.get("pool")).createIndex(tblToAlloc, "FSourceBillEntryID", true, false);
    }

    @Override
    public int hasTargetBillEntryID() throws Exception {
        return 1;
    }

    @Override
    protected String parseQuerySql(String tblResult, String sql) {
        String tempSql;
        FilterInfo filter = (FilterInfo)((FilterInfo)this.param.get("filterInfo")).clone();
        int index = sql.indexOf("GROUP BY");
        if (index >= 0 && (index = (tempSql = sql.substring(0, index)).indexOf("FROM")) >= 0) {
            tempSql = tempSql.substring(index);
            StringBuffer ksql = new StringBuffer();
            ksql.append("SELECT \n");
            ksql.append("     \"ENTRY\".FID, \n");
            ksql.append("     case \n");
            ksql.append("         when (\"COSTOBJECT\".FID IS NOT NULL) AND (\"COSTOBJECT\".FNumber <> 'SCOID') then 1 \n");
            ksql.append("         else 0 \n");
            ksql.append("     end   \n");
            ksql.append(" \n");
            sql = tempSql = ksql.toString() + tempSql;
        }
        if (this.param.containsKey("isOnlyUnAlloced") && this.param.get("isOnlyUnAlloced").equals(String.valueOf(true))) {
            sql = sql.replaceAll("WHERE", "\n LEFT OUTER JOIN " + tblResult + " AS \"TBLRESULT\" \n ON \"TBLRESULT\".FSourceBillEntryID=\"ENTRY\".FID \n WHERE ");
            sql = sql + " and \"TBLRESULT\".FSourceBillEntryID is null \n";
        }
        HashSet<String> filterItems = new HashSet<String>();
        Iterator it = filter.getFilterItems().iterator();
        while (it.hasNext()) {
            String propertyName = ((FilterItemInfo)it.next()).getPropertyName();
            filterItems.add(propertyName);
        }
        sql = sql.replaceAll("LEFT OUTER JOIN T_ORG_Storage AS \"STORAGEORGUNIT\"", " ");
        sql = sql.replaceAll("ON \"MATERIALREQBILL\".FStorageOrgUnitID = \"STORAGEORGUNIT\".FID", " ");
        sql = sql.replaceAll("LEFT OUTER JOIN T_SCM_BillType AS \"SOURCEBILLTYPE\"", " ");
        sql = sql.replaceAll("ON \"MATERIALREQBILL\".FSourceBillTypeID = \"SOURCEBILLTYPE\".FID", " ");
        sql = sql.replaceAll("LEFT OUTER JOIN T_BD_Material AS \"PRODUCTID\"", " ");
        sql = sql.replaceAll("ON \"ENTRY\".FProductIDID = \"PRODUCTID\".FID", " ");
        if (!filterItems.contains("material.name") && !filterItems.contains("material.number")) {
            sql = sql.replaceAll("LEFT OUTER JOIN T_BD_Material AS \"MATERIAL\"", " ");
            sql = sql.replaceAll("ON \"ENTRY\".FMaterialID = \"MATERIAL\".FID", " ");
        }
        if (!filterItems.contains("baseUnit.name")) {
            sql = sql.replaceAll("LEFT OUTER JOIN T_BD_MeasureUnit AS \"BASEUNIT\"", " ");
            sql = sql.replaceAll("ON \"ENTRY\".FBaseUnitID = \"BASEUNIT\".FID", " ");
        }
        sql = sql.replaceAll("LEFT OUTER JOIN T_BD_MeasureUnit AS \"UNIT\"", " ");
        sql = sql.replaceAll("ON \"ENTRY\".FUnitID = \"UNIT\".FID", " ");
        sql = sql.replaceAll("LEFT OUTER JOIN T_BD_MeasureUnit AS \"ASSISTUNIT\"", " ");
        sql = sql.replaceAll("ON \"ENTRY\".FAssistUnitID = \"ASSISTUNIT\".FID", " ");
        sql = sql.replaceAll("LEFT OUTER JOIN T_BD_MultiMeasureUnit AS \"MULTIMEASUREUNIT\"", "");
        sql = sql.replaceAll("ON \"ENTRY\".FMaterialID = \"MULTIMEASUREUNIT\".FMaterialID AND \"ENTRY\".FUnitID = \"MULTIMEASUREUNIT\".FMeasureUnitID", "");
        sql = sql.replaceAll("LEFT OUTER JOIN T_BD_MultiMeasureUnit AS \"MULTIMEASUREASSISTUNIT\"", "");
        sql = sql.replaceAll("ON \"ENTRY\".FMaterialID = \"MULTIMEASUREASSISTUNIT\".FMaterialID AND \"ENTRY\".FAssistUnitID = \"MULTIMEASUREASSISTUNIT\".FMeasureUnitID", "");
        sql = sql.replaceAll("LEFT OUTER JOIN T_BD_MultiMeasureUnit AS \"MULTIMEASURECOMMONUNIT\"", " ");
        sql = sql.replaceAll("ON \"ENTRY\".FMaterialID = \"MULTIMEASURECOMMONUNIT\".FMaterialID AND \"ENTRY\".FBaseUnitID = \"MULTIMEASURECOMMONUNIT\".FMeasureUnitID", "");
        sql = sql.replaceAll("LEFT OUTER JOIN T_BD_Currency AS \"BASECURRENCY\"", " ");
        sql = sql.replaceAll("ON \"COMPANYORGUNIT\".FBaseCurrencyID = \"BASECURRENCY\".FID", "");
        if (!filterItems.contains("creator.name")) {
            sql = sql.replaceAll("LEFT OUTER JOIN T_PM_User AS \"CREATOR\"", " ");
            sql = sql.replaceAll("ON \"MATERIALREQBILL\".FCreatorID = \"CREATOR\".FID", " ");
        }
        if (!filterItems.contains("warehouse.name")) {
            sql = sql.replaceAll("LEFT OUTER JOIN T_DB_WAREHOUSE AS \"WAREHOUSE\"", " ");
            sql = sql.replaceAll("ON \"ENTRY\".FWarehouseID = \"WAREHOUSE\".FID", " ");
        }
        if (!filterItems.contains("costItem.name") && !filterItems.contains("costItem.number")) {
            sql = sql.replaceAll("LEFT OUTER JOIN T_NCM_CostItem AS \"COSTITEM\"", " ");
            sql = sql.replaceAll("ON \"ENTRY\".FCostItemID = \"COSTITEM\".FID", " ");
        }
        if (!filterItems.contains("costObjectSuite.name") && !filterItems.contains("costObjectSuite.number")) {
            sql = sql.replaceAll("LEFT OUTER JOIN T_NCM_CostObjectSuite AS \"COSTOBJECTSUITE\"", " ");
            sql = sql.replaceAll("ON \"ENTRY\".FCostObjectSuiteID = \"COSTOBJECTSUITE\".FID", " ");
        }
        if (!filterItems.contains("costItem.name") && !filterItems.contains("costItem.number")) {
            sql = sql.replaceAll("LEFT OUTER JOIN T_NCM_CostItem AS \"COSTITEM\"", " ");
            sql = sql.replaceAll("ON \"ENTRY\".FCostItemID = \"COSTITEM\".FID", " ");
        }
        if (!filterItems.contains("costItem.name") && !filterItems.contains("costItem.number")) {
            sql = sql.replaceAll("LEFT OUTER JOIN T_NCM_CostItem AS \"COSTITEM\"", " ");
            sql = sql.replaceAll("ON \"ENTRY\".FCostItemID = \"COSTITEM\".FID", " ");
        }
        return sql;
    }

    @Override
    public String GetDirectFeeDataSql() throws AllocateException {
        AllocTable allocTable = (AllocTable)this.param.get("allocTable");
        String tblToAlloc = allocTable.GetToAllocBillEntryIDTable();
        StringBuffer ksql = new StringBuffer();
        ksql.append("SELECT \"ENTRY\".FWareHouseID \"FWAREHOUSEID\", \n");
        ksql.append("    \"MATERIALREQBILL\".FAdminOrgUnitID \"FADMINORGUNITID\", \n");
        ksql.append("    \"ENTRY\".FIsRework \"ENTRYFISREWORK\", \n");
        ksql.append("    \"MATERIALREQBILL\".FID \"ID\", \n");
        ksql.append("    \"ENTRY\".FCompanyOrgUnitID \"COMPANYORGUNITID\", \n");
        ksql.append("    \"MATERIALREQBILL\".FYear \"YEAR\", \n");
        ksql.append("    \"MATERIALREQBILL\".FPeriod \"PERIOD\", \n");
        ksql.append("    \"ENTRY\".FID \"ENTRYID\", \n");
        ksql.append("    \"ENTRY\".FSeq \"ENTRYSEQ\", \n");
        ksql.append("    \"COSTOBJECT\".FID \"COSTOBJECTID\", \n");
        ksql.append("    \"COSTITEM\".FID \"COSTITEMID\", \n");
        ksql.append("    \"ENTRY\".FBaseQty \"ENTRYBASEQTY\", \n");
        ksql.append("    \"ENTRY\".FUnitActualCost \"ENTRY.UNITACTUALCOST\", \n");
        ksql.append("    \"ENTRY\".FActualCost \"ENTRYACTUALCOST\", \n");
        ksql.append("    \"MATERIAL\".FPricePrecision \"MATERIALPRICEPRECISION\", \n");
        ksql.append("    \"MATERIALREQBILL\".FBizDate \"BIZDATE\", \n");
        ksql.append("    \"MATERIAL\".FID \"MATERIALID\", \n");
        ksql.append("    \"ENTRY\".FLot \"ENTRYLOT\", \n");
        ksql.append("    \"ENTRY\".FQty \"ENTRYQTY\", \n");
        ksql.append("    \"ENTRY\".FAssistQty \"ENTRYASSISTQTY\", \n");
        ksql.append("    \"ENTRY\".FCostCenterOrgUnitID \"COSTCENTERORGUNITID\" \n");
        ksql.append("FROM T_IM_MaterialReqBill \"MATERIALREQBILL\" \n");
        ksql.append("JOIN T_IM_MaterialReqBillEntry \"ENTRY\" \n");
        ksql.append("    ON \"MATERIALREQBILL\".FID = \"ENTRY\".FParentID \n");
        ksql.append("JOIN " + tblToAlloc + " tmp \n");
        ksql.append("    ON tmp.FSourceBillEntryID = \"ENTRY\".FID and tmp.FIsDirect = 1 \n");
        ksql.append("LEFT OUTER JOIN T_BD_CostObject \"COSTOBJECT\" \n");
        ksql.append("    ON \"ENTRY\".FCostObjectID = \"COSTOBJECT\".FID \n");
        ksql.append("LEFT OUTER JOIN T_BD_Material \"MATERIAL\" \n");
        ksql.append("    ON \"ENTRY\".FMaterialID = \"MATERIAL\".FID \n");
        ksql.append("LEFT OUTER JOIN T_NCM_CostItem \"COSTITEM\" \n");
        ksql.append("    ON \"ENTRY\".FCostItemID = \"COSTITEM\".FID \n");
        return ksql.toString();
    }

    @Override
    public IRowSet GetIndirectFeeData() throws AllocateException {
        Context ctx = (Context)this.param.get("ctx");
        AllocTable allocTable = (AllocTable)this.param.get("allocTable");
        String tblToAlloc = allocTable.GetToAllocBillEntryIDTable();
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)this.mdPk);
        IRowSet rs = null;
        try {
            String sql = exec.getSQL();
            StringBuffer sqlStr = new StringBuffer();
            sqlStr.append(" \n LEFT Join t_bd_materialcost matcos on \"ENTRY\".Fmaterialid = matcos.fmaterialid ");
            sqlStr.append(" AND \"ENTRY\".FCOMPANYORGUNITID = matcos.FORGUNIT ");
            sql = sql.replaceAll("GROUP BY", sqlStr.toString() + " \n JOIN " + tblToAlloc + " tmp \n    ON tmp.FSourceBillEntryID = \"ENTRY\".FID and tmp.FIsDirect = 0 \n GROUP BY matcos.FEXPENSEID, ");
            sql = sql.replace("SELECT ", "SELECT matcos.FEXPENSEID FEXPENSEID,");
            sql = sql.replaceAll("\"COSTCENTERORGUNIT.NAME\" ASC", " ");
            sql = sql.replaceAll("ORDER BY", "ORDER BY \"COSTCENTERORGUNIT.ID\",\"COSTOBJECTSUITEID\", \"MATERIAL.ID\" ");
            if (sql.indexOf("ORDER BY") < 0) {
                sql = sql + "\nORDER BY \"COSTCENTERORGUNIT.ID\",\"COSTOBJECTSUITEID\", \"MATERIAL.ID\" ";
            }
            rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql);
        }
        catch (BOSException e1) {
            logger.error((Object)"", (Throwable)e1);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e1);
        }
        return rs;
    }

    @Override
    public String GetIndirectFeeDataSql() throws AllocateException {
        Context ctx = (Context)this.param.get("ctx");
        AllocTable allocTable = (AllocTable)this.param.get("allocTable");
        String tblToAlloc = allocTable.GetToAllocBillEntryIDTable();
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)this.mdPk);
        String sql = null;
        try {
            sql = exec.getSQL();
            sql = sql.replaceAll("GROUP", "JOIN " + tblToAlloc + " tmp \n    ON tmp.FSourceBillEntryID = \"ENTRY\".FID and tmp.FIsDirect = 0 \n GROUP \n");
            sql = sql.replaceAll("\"COSTCENTERORGUNIT.NAME\" ASC", " ");
            sql = sql.replaceAll("ORDER BY", "ORDER BY \"COSTCENTERORGUNIT.ID\",\"COSTOBJECTSUITEID\", \"MATERIAL.ID\" ");
        }
        catch (BOSException e1) {
            logger.error((Object)"", (Throwable)e1);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e1);
        }
        return sql;
    }

    @Override
    public void updateFeeDataFlagToAllocated(String tblResult) throws Exception {
    }

    @Override
    public void updateFeeDataFlagToUnallocated(String tblResult) throws Exception {
        Assert.that((boolean)this.param.containsKey("filterInfo"));
        Context ctx = (Context)this.param.get("ctx");
        AllocTable allocTable = (AllocTable)this.param.get("allocTable");
        String tblToAlloc = allocTable.GetToAllocBillEntryIDTable();
        try {
            StringBuffer updateSql = new StringBuffer();
            String dbTypeName = (String)ctx.get((Object)"dbType");
            int CurrentDataBaseType = DbType.getValue((String)dbTypeName);
            if (CurrentDataBaseType == 2 || CurrentDataBaseType == 7 || CurrentDataBaseType == 8) {
                updateSql.append("/*dialect*/").append(" \n");
                updateSql.append("declare \n");
                updateSql.append("    Cursor cur_beid is \n");
                updateSql.append("    select FSourceBillEntryID \n");
                updateSql.append("    from " + tblToAlloc + " \n");
                updateSql.append("    where rownum < 1000 \n");
                updateSql.append("    ; \n");
                updateSql.append("begin \n");
                updateSql.append("    for mycur in cur_beid loop \n");
                updateSql.append("        update T_IM_MaterialReqBillEntry \n");
                updateSql.append("        set FIsAdmeasure = 1 \n");
                updateSql.append("        where fid = mycur.FSourceBillEntryID \n");
                updateSql.append("        and FIsAdmeasure = 0; \n");
                updateSql.append("        if mod(cur_beid%rowcount, 1000) = 0 then \n");
                updateSql.append("            commit; \n");
                updateSql.append("        end if; \n");
                updateSql.append("    end loop; \n");
                updateSql.append("    commit; \n");
                updateSql.append("end; \n");
                updateSql.setLength(0);
                updateSql.append("/*dialect*/").append(" \n");
                updateSql.append("declare \n");
                updateSql.append("    Cursor cur_beid is \n");
                updateSql.append("    select FSourceBillEntryID \n");
                updateSql.append("    from " + tblToAlloc + " \n");
                updateSql.append("    ; \n");
                updateSql.append("    type sourceBillEntryID is table of " + tblToAlloc + ".FSourceBillEntryID%type \n");
                updateSql.append("    ; \n");
                updateSql.append("    v_sourceBillEntryID sourceBillEntryID \n");
                updateSql.append("    ; \n");
                updateSql.append("begin \n");
                updateSql.append("    open cur_beid; \n");
                updateSql.append("    loop \n");
                updateSql.append("        FETCH cur_beid BULK COLLECT INTO v_sourceBillEntryID LIMIT 1000; \n");
                updateSql.append("        FORALL i IN 1 .. v_sourceBillEntryID.COUNT \n");
                updateSql.append("            update T_IM_MaterialReqBillEntry \n");
                updateSql.append("            set FIsAdmeasure = 1 \n");
                updateSql.append("            where fid = v_sourceBillEntryID(i) \n");
                updateSql.append("            and FIsAdmeasure = 0; \n");
                updateSql.append("        commit; \n");
                updateSql.append("        EXIT WHEN cur_beid%NOTFOUND; \n");
                updateSql.append("    end loop; \n");
                updateSql.append("    close cur_beid; \n");
                updateSql.append("    commit; \n");
                updateSql.append("end; \n");
                NCMDbUtil.execute((Context)ctx, (String)updateSql.toString());
            } else {
                updateSql.append("update T_IM_MaterialReqBillEntry ");
                updateSql.append("set FIsAdmeasure = 1 \n");
                updateSql.append("where exists ( \n");
                updateSql.append("    select 1 from " + tblToAlloc + " t where t.FSourceBillEntryID = T_IM_MaterialReqBillEntry.FID \n");
                updateSql.append(") \n");
                NCMDbUtil.execute((Context)ctx, (String)updateSql.toString());
            }
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e);
        }
    }
}

