/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Fee;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.ncm.bill.AllocateException;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Fee.FeeData;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Table.AllocTable;
import com.kingdee.eas.ncm.cal.utils.app.CalSeverUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import com.kingdee.util.db.SQLUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.apache.log4j.Logger;

public class OtherFeeData
extends FeeData {
    private static Logger logger = Logger.getLogger((String)OtherFeeData.class.getName());
    protected IMetaDataPK mdPk = new MetaDataPK("com.kingdee.eas.ncm.bill.app", "OtherAllocFeeGroupQuery");

    public OtherFeeData(Map param) {
        super(param);
    }

    @Override
    public void buildTargetBillEntryID(String tblResult) throws Exception {
        Context ctx = (Context)this.param.get("ctx");
        AllocTable allocTable = (AllocTable)this.param.get("allocTable");
        String tblToAlloc = allocTable.GetToAllocBillEntryIDTable();
        StringBuffer ksql = new StringBuffer();
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)this.mdPk);
        FilterInfo filter = (FilterInfo)((FilterInfo)this.param.get("filterInfo")).clone();
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        exec.setObjectView(view);
        String sql = exec.getSQL();
        sql = this.parseQuerySql(tblResult, sql);
        ksql.setLength(0);
        ksql.append("insert into " + tblToAlloc + " ( \n");
        ksql.append("    FSourceBillEntryID, \n");
        ksql.append("    FIsDirect \n");
        ksql.append(") \n");
        ksql.append(sql);
        ksql.append(" \n");
        ksql.append("; \n");
        NCMDbUtil.BatchSqlExecute((Context)ctx, (String)ksql.toString(), (String)";");
        ((TempTablePool)this.param.get("pool")).createIndex(tblToAlloc, "FSourceBillEntryID", false, false);
    }

    protected String parseQuerySql(String tblResult, String sql) {
        String tempSql;
        int index = sql.indexOf("GROUP BY");
        if (index >= 0 && (index = (tempSql = sql.substring(0, index)).indexOf("FROM")) >= 0) {
            tempSql = tempSql.substring(index);
            StringBuffer ksql = new StringBuffer();
            ksql.append("SELECT \n");
            ksql.append("     \"ENTRIES\".FID, \n");
            ksql.append("     case \n");
            ksql.append("         when (\"COSTOBJECT\".FID IS NOT NULL) AND (\"COSTOBJECT\".FNumber <> 'SCOID') then 1 \n");
            ksql.append("         else 0 \n");
            ksql.append("     end   \n");
            ksql.append(" \n");
            sql = tempSql = ksql.toString() + tempSql;
        }
        if (this.param.containsKey("isOnlyUnAlloced") && this.param.get("isOnlyUnAlloced").equals(String.valueOf(true))) {
            sql = sql.replaceAll("WHERE", "\n LEFT OUTER JOIN " + tblResult + " AS \"TBLRESULT\" \n ON \"TBLRESULT\".FSourceBillEntryID=\"ENTRIES\".FID \n WHERE ");
            sql = sql + " and \"TBLRESULT\".FSourceBillEntryID is null \n";
        }
        return sql;
    }

    @Override
    public String GetDirectFeeDataSql() throws AllocateException {
        Assert.that((boolean)this.param.containsKey("filterInfo"));
        Context ctx = (Context)this.param.get("ctx");
        AllocTable allocTable = (AllocTable)this.param.get("allocTable");
        String tblToAlloc = allocTable.GetToAllocBillEntryIDTable();
        FilterInfo filter = (FilterInfo)((FilterInfo)this.param.get("filterInfo")).clone();
        String sql = null;
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)this.mdPk);
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filter);
        try {
            exec.setObjectView(ev);
            sql = exec.getSQL();
            String key = "WHERE";
            int index = sql.indexOf(key);
            if (index < 0) {
                key = "GROUP";
                index = sql.indexOf(key);
            }
            if (index >= 0) {
                sql = sql.replaceAll(key, "\nJOIN " + tblToAlloc + " tmp \n    ON tmp.FSourceBillEntryID = \"ENTRIES\".FID and tmp.FIsDirect = 1 \n" + key + " \n");
            }
            sql = sql.replaceAll("ORDER BY.*", " ");
        }
        catch (BOSException e1) {
            logger.error((Object)"", (Throwable)e1);
            throw new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e1);
        }
        return sql;
    }

    @Override
    public String GetIndirectFeeDataSql() throws AllocateException {
        Assert.that((boolean)this.param.containsKey("filterInfo"));
        Context ctx = (Context)this.param.get("ctx");
        AllocTable allocTable = (AllocTable)this.param.get("allocTable");
        String tblToAlloc = allocTable.GetToAllocBillEntryIDTable();
        FilterInfo filter = (FilterInfo)((FilterInfo)this.param.get("filterInfo")).clone();
        String sql = null;
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)this.mdPk);
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filter);
        try {
            exec.setObjectView(ev);
            sql = exec.getSQL();
            String key = "WHERE";
            int index = sql.indexOf(key);
            if (index < 0) {
                key = "GROUP";
                index = sql.indexOf(key);
            }
            if (index >= 0) {
                sql = sql.replaceAll(key, "\nJOIN " + tblToAlloc + " tmp \n    ON tmp.FSourceBillEntryID = \"ENTRIES\".FID and tmp.FIsDirect = 0 \n" + key + " \n");
            }
            if ((sql = sql.replaceAll("ORDER BY.*", " ")).indexOf("ORDER BY") < 0) {
                sql = sql + "\nORDER BY \"COSTCENTER.ID\",\"COSTOBJECTSUITE.ID\", \"EXPENSE.ID\" ";
            }
        }
        catch (BOSException e1) {
            logger.error((Object)"", (Throwable)e1);
            throw new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e1);
        }
        return sql;
    }

    @Override
    public IRowSet GetIndirectFeeData() throws AllocateException {
        Context ctx = (Context)this.param.get("ctx");
        IRowSet rs = null;
        try {
            String sql = this.GetIndirectFeeDataSql();
            rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql);
        }
        catch (BOSException e1) {
            logger.error((Object)"", (Throwable)e1);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e1);
        }
        return rs;
    }

    @Override
    public void clearPreAllocResult(String tblResult) throws Exception {
        Assert.that((boolean)this.param.containsKey("filterInfo"));
        String sql = null;
        AllocTable allocTable = (AllocTable)this.param.get("allocTable");
        String tblToAlloc = allocTable.GetToAllocBillEntryIDTable();
        Context ctx = (Context)this.param.get("ctx");
        String companyId = this.param.get("companyId").toString();
        String periodId = this.param.get("periodId").toString();
        boolean bFilter_all = false;
        if (this.param.containsKey("bFilter_all")) {
            bFilter_all = this.param.get("bFilter_all").equals(String.valueOf(true));
        }
        StringBuffer ksql = new StringBuffer();
        if (bFilter_all) {
            NCMDynamicTableManager.DeleteTable((Context)ctx, (String)tblResult, null);
            return;
        }
        sql = " where exists (Select 1 from " + tblToAlloc + " S WHERE S.FSourceBillEntryID=" + tblResult + ".FSourceBillEntryID)";
        ksql.setLength(0);
        ksql.append("select top 1 1 from " + tblResult + " \n");
        ksql.append("where not exists ( \n");
        ksql.append("    Select 1 from " + tblToAlloc + " s \n");
        ksql.append("    WHERE s.FSourceBillEntryID = " + tblResult + ".FSourceBillEntryID \n");
        ksql.append(") \n");
        if (this.isCanUseTruncate(ctx, ksql.toString())) {
            sql = null;
        }
        NCMDynamicTableManager.DeleteTable((Context)ctx, (String)tblResult, (String)sql);
        CalSeverUtils.ClearInvalidOtherFeeAllocResult((Context)ctx, (String)companyId, (String)periodId);
    }

    protected String getFilterFeildName() {
        return "costObject.id";
    }

    protected String getFieldNameForClearPreAllocResult() {
        return "ENTRIES.ID";
    }

    @Override
    public void updateFeeDataFlagToAllocated(String tblResult) throws Exception {
        Context ctx = (Context)this.param.get("ctx");
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("update T_NCM_OtherFeeBillEntry set FIsAlloced = 1 where FID in \n");
        updateSql.append("( \n");
        updateSql.append("select distinct FSourceBillEntryID from " + tblResult + " \n");
        updateSql.append(") \n");
        try {
            NCMDbUtil.execute((Context)ctx, (String)updateSql.toString());
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e);
        }
    }

    @Override
    public void updateFeeDataFlagToUnallocated(String tblResult) throws Exception {
        Assert.that((boolean)this.param.containsKey("filterInfo"));
        FilterInfo filter = (FilterInfo)((FilterInfo)this.param.get("filterInfo")).clone();
        String sql = null;
        Context ctx = (Context)this.param.get("ctx");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)this.mdPk);
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filter);
        try {
            exec.setObjectView(ev);
            sql = exec.getSQL();
            sql = "select \"ENTRIES\".FID " + sql.substring(sql.toLowerCase().indexOf("from"), sql.toLowerCase().indexOf("group by"));
            StringBuffer updateSql = new StringBuffer();
            updateSql.append("update T_NCM_OtherFeeBillEntry ");
            updateSql.append("set FIsAlloced = 0 \n");
            updateSql.append("where FID in ( \n");
            updateSql.append(sql);
            updateSql.append(") \n");
            NCMDbUtil.execute((Context)ctx, (String)updateSql.toString());
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCanUseTruncate(Context ctx, String sqlNotDeleteData) throws SQLException, BOSException {
        IRowSet rs = null;
        try {
            rs = NCMDbUtil.executeQuery((Context)ctx, (String)sqlNotDeleteData);
            boolean bl = !rs.next();
            return bl;
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
    }
}

