/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.basedata.ncm.AllocStdInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.bill.AllocStdSetByOverheadFactory;
import com.kingdee.eas.ncm.bill.AllocStdSetByOverheadInfo;
import com.kingdee.eas.ncm.bill.AllocStdSetByPrdFactory;
import com.kingdee.eas.ncm.bill.AllocStdSetByPrdInfo;
import com.kingdee.eas.ncm.bill.AllocateException;
import com.kingdee.eas.ncm.bill.IAllocStdSetByOverhead;
import com.kingdee.eas.ncm.bill.IAllocStdSetByPrd;
import com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.AUSContext;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Fee.FeeData;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Fee.Info.IFeeInfo;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.OtherAllocator;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Table.AllocTable;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Table.ManuOtherAllocTable;
import com.kingdee.eas.ncm.common.task.CostTaskResultEnum;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ManuOtherAllocator
extends OtherAllocator {
    private static Logger logger = Logger.getLogger((String)ManuOtherAllocator.class.getName());
    private boolean _hasGetAllocTbl = false;

    public ManuOtherAllocator(Map param, AUSContext ausCtx) {
        super(param, ausCtx);
        Assert.that((boolean)param.containsKey("sourceBillId"));
        Assert.that((boolean)param.containsKey("sourceBillEntryId"));
        Assert.that((boolean)param.containsKey("isOnlyNotZero"));
        Assert.that((boolean)param.containsKey("isOnlyRangeChange"));
    }

    @Override
    public CostTaskResultEnum preCheck() throws Exception {
        return super.preCheck();
    }

    @Override
    public AllocTable getAllocTable() throws AllocateException {
        if (this._hasGetAllocTbl) {
            return super.getAllocTable();
        }
        Context ctx = (Context)this._param.get("ctx");
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        this._param.put("pool", pool);
        this.setAllocTable(new ManuOtherAllocTable(this._param));
        this._hasGetAllocTbl = true;
        return super.getAllocTable();
    }

    @Override
    public void preProcess() throws AllocateException {
        super.preProcess();
    }

    @Override
    public AllocStdInfo GetAllocStdSetting(IFeeInfo currFee) throws AllocateException {
        Context ctx = (Context)this._param.get("ctx");
        String companyId = this._param.get("companyId").toString();
        String periodId = this._param.get("periodId").toString();
        AllocStdInfo allocStd = null;
        if (this._param.containsKey("allocStd")) {
            allocStd = (AllocStdInfo)this._param.get("allocStd");
        }
        if (allocStd != null) {
            return allocStd;
        }
        StringBuffer sb = new StringBuffer();
        try {
            Boolean isAssistant = this.isAssistantCostCenterReqFee(currFee);
            if (isAssistant != null && isAssistant.booleanValue()) {
                IAllocStdSetByOverhead fact = AllocStdSetByOverheadFactory.getLocalInstance(ctx);
                sb.append("Select allocStd.* where company = '").append(companyId).append("' AND calculatePeriod = '").append(periodId).append("' AND expense = '").append(currFee.GetExpenseId()).append("' ").append(" AND costCenter = '").append(currFee.GetCostCenterId()).append("'");
                AllocStdSetByOverheadInfo info = fact.getAllocStdSetByOverheadInfo(sb.toString());
                allocStd = info.getAllocStd();
            } else {
                IAllocStdSetByPrd fact = AllocStdSetByPrdFactory.getLocalInstance(ctx);
                sb.append("Select allocStd.* where company = '").append(companyId).append("' AND calculatePeriod = '").append(periodId).append("' AND expense = '").append(currFee.GetExpenseId()).append("' ").append(" AND costCenter = '").append(currFee.GetCostCenterId()).append("'");
                AllocStdSetByPrdInfo info = fact.getAllocStdSetByPrdInfo(sb.toString());
                allocStd = info.getAllocStd();
            }
            return allocStd;
        }
        catch (ObjectNotFoundException e) {
            throw new AllocateException(AllocateException.ITEM_ALLOC_NOTSET, new Object[]{currFee.GetExpenseNumber().concat(" ").concat(currFee.GetExpenseName()), currFee.GetCostCenterNumber().concat(" ").concat(currFee.GetCostCenterName())});
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
        }
    }

    @Override
    public FeeData GetFeeDataControl() throws AllocateException {
        return super.GetFeeDataControl();
    }

    @Override
    public void allocDirect() throws AllocateException {
        super.allocDirect();
    }

    @Override
    public void allocIndirect(IFeeInfo currFee, int position) throws AllocateException {
        super.allocIndirect(currFee, position);
    }

    @Override
    public Map processResult() throws AllocateException {
        HashMap<String, Object> ret = null;
        ret = super.processResult();
        if (ret == null) {
            ret = new HashMap<String, Object>();
        }
        if (this._param.get("isOnlyRangeChange").equals(String.valueOf(true))) {
            this.dealWhenOnlyRangeChange();
        }
        IRowSet rs = this.getOtherAdjustData();
        ret.put("AdjustData", rs);
        ret.put("AllocStd", this.getAllocStd());
        return ret;
    }

    @Override
    public void endProcess() throws AllocateException {
        super.endProcess();
    }

    @Override
    protected String GetAdjustUserId() {
        return this._param.get("userId").toString();
    }

    @Override
    public void processAllocateException(AllocateException e, String possibleReason, String adviceHandle) throws AllocateException {
        super.processAllocateException(e, possibleReason, adviceHandle);
    }

    protected IRowSet getOtherAdjustData() throws AllocateException {
        String companyId = this._param.get("companyId").toString();
        String periodId = this._param.get("periodId").toString();
        String sourceBillId = this._param.get("sourceBillId").toString();
        String sourceBillEntryId = this._param.get("sourceBillEntryId").toString();
        String tblResult = this.getAllocTable().GetResultTable();
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT D.FID,D.FCostObjectID,O.FNumber As FCostObjectNumber, O.FName_L2 As FCostObjectName,P.FModel As FProdModel,").append('\n').append("  D.FAllocStdData,D.FQty,D.FPrice,D.FAmount,").append('\n').append("  D.FCostItemID, I.FNumber As FCostItemNumber, I.FName_L2 As FCostItemName,").append('\n').append("  D.FAllocStdID, S.FNumber As FAllocStdNumber, S.FName_L2 As FAllocStdName, ").append('\n').append("  D.FCreatorID, CR.FNumber As FCreatorNumber, CR.FName_L2 As FCreatorName,D.FCreateTime,").append('\n').append("  D.FAdjustUserID, AD.FNumber As AdjustUserNumber, AD.FName_L2 As FAdjustUserName,D.FAdjustTime,").append('\n').append("  CY.FPrecision As FAmountPrecision ,Isnull(UNT.FQtyPrecision,8)as FQtyPrecision, Isnull(EXP.FPricePrecision,8)As FPricePrecision, ").append('\n').append("  dp.Fname_l2 as Fdepartmentname ,sourceCC.Fname_l2 as FSourceCostCenterName ").append('\n').append("FROM ").append(tblResult).append(" D ").append('\n').append("LEFT OUTER JOIN T_NCM_AllocStd S ON D.FAllocStdID = S.FID ").append('\n').append("LEFT OUTER JOIN T_BD_CostObject O ON D.FCostObjectID = O.FID ").append('\n').append("LEFT OUTER JOIN T_NCM_CostItem I ON D.FCostItemID = I.FID ").append('\n').append("LEFT JOIN T_BD_Material P ON O.FStdProductIDID = P.FID ").append('\n').append("LEFT OUTER JOIN T_PM_User CR ON D.FCreatorID = CR.FID ").append('\n').append("LEFT JOIN T_PM_User AD ON D.FAdjustUserID = AD.FID ").append('\n').append("LEFT OUTER JOIN T_ORG_Company COM ON D.FCompanyID = COM.FID ").append('\n').append("LEFT OUTER JOIN T_BD_Currency CY ON COM.FBaseCurrencyID = CY.FID ").append('\n').append("LEFT OUTER JOIN T_NCM_OtherFeeBillEntry BILLEntry ON BILLEntry.FID=D.FSourceBillID ").append('\n').append("LEFT OUTER JOIN T_NCM_Expense EXP ON BILLEntry.FExpenseID = EXP.FID ").append('\n').append("LEFT OUTER JOIN T_BD_MeasureUnit UNT ON EXP.FUnitID = UNT.FID ").append('\n').append("LEFT OUTER JOIN T_ORG_BaseUnit dp ON D.FDepartmentID = dp.FID ").append('\n').append("LEFT OUTER JOIN T_ORG_CostCenter sourceCC ON D.FSourceCostCenterID = sourceCC.FID ").append('\n').append("WHERE D.FCompanyID ='").append(companyId).append("' AND D.FCalculatePeriodID='").append(periodId).append("'").append('\n').append("  AND D.FSourceBillID='").append(sourceBillId).append("' AND D.FSourceBillEntryID='").append(sourceBillEntryId).append("'").append('\n').append("Order by O.FNumber ");
        Context ctx = (Context)this._param.get("ctx");
        try {
            return NCMDbUtil.executeQuery((Context)ctx, (String)sb.toString());
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
        }
    }

    @Override
    protected boolean IsOnlyNotZero_AllcoStdData() {
        return this._param.get("isOnlyNotZero").equals(String.valueOf(true));
    }

    private void dealWhenOnlyRangeChange() throws AllocateException {
        String companyId = this._param.get("companyId").toString();
        String periodId = this._param.get("periodId").toString();
        String sourceBillId = this._param.get("sourceBillId").toString();
        String sourceBillEntryId = this._param.get("sourceBillEntryId").toString();
        Context ctx = (Context)this._param.get("ctx");
        String tblResult_Adjust = this.getAllocTable().GetResultTable();
        String tblResult = null;
        try {
            tblResult = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_OtherAllocResult");
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("UPDATE ").append(tblResult_Adjust).append(" SET FAllocStdData=0,FQty=0,FPrice=0,FAmount=0 ").append('\n').append("WHERE FCompanyID ='").append(companyId).append("' AND FCalculatePeriodID='").append(periodId).append("'").append('\n').append("  AND FSourceBillID='").append(sourceBillId).append("' AND FSourceBillEntryID='").append(sourceBillEntryId).append("'").append('\n').append(";").append('\n');
        sb.append("UPDATE ").append(tblResult_Adjust).append(" As D SET (FAllocStdData,FQty,FPrice,FAmount)=( ").append('\n').append("\tSelect S.FAllocStdData,S.FQty,S.FPrice,S.FAmount ").append('\n').append("\tFrom ").append(tblResult).append(" S ").append('\n').append("\tWHERE S.FCompanyID ='").append(companyId).append("' AND S.FCalculatePeriodID='").append(periodId).append("'").append('\n').append("  \t\tAND S.FSourceBillID='").append(sourceBillId).append("' AND S.FSourceBillEntryID='").append(sourceBillEntryId).append("'").append('\n').append("\t\tAND S.FCompanyID=D.FCompanyID AND S.FCalculatePeriodID=D.FCalculatePeriodID ").append('\n').append("\t\tAND S.FSourceBillID=D.FSourceBillID AND S.FSourceBillEntryID=D.FSourceBillEntryID ").append('\n').append("\t\tAND S.FCostCenterID=D.FCostCenterID AND S.FCostObjectID=D.FCostObjectID ").append('\n').append(");").append('\n');
        if (this.IsOnlyNotZero_AllcoStdData()) {
            sb.append("Delete from ").append(tblResult_Adjust).append('\n').append("WHERE FCompanyID ='").append(companyId).append("' AND FCalculatePeriodID='").append(periodId).append("'").append('\n').append("  \tAND FSourceBillID='").append(sourceBillId).append("' AND FSourceBillEntryID='").append(sourceBillEntryId).append("'").append('\n').append("\tAND FAllocStdData=0 ").append('\n').append(";").append('\n');
        }
        try {
            NCMDbUtil.BatchSqlExecute((Context)ctx, (String)sb.toString(), (String)";");
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
        }
    }
}

