/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.sql.DbType;
import com.kingdee.eas.ncm.bill.AllocateException;
import com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.AUSContext;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Fee.FeeData;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Fee.MatReqFeeData;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.MatAllocator;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.text.MessageFormat;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class MatReqAllocator
extends MatAllocator {
    private static Logger logger = Logger.getLogger((String)MatReqAllocator.class.getName());

    public MatReqAllocator(Map param, AUSContext ausCtx) {
        super(param, ausCtx);
    }

    @Override
    protected FeeData setFeeData(Map param) {
        return new MatReqFeeData(param);
    }

    @Override
    protected boolean hasDirectCostCenterReqFee() throws AllocateException {
        Context ctx = (Context)this._param.get("ctx");
        StringBuffer ksql = new StringBuffer();
        ksql.append("select top 1 \n");
        ksql.append("    1 \n");
        ksql.append("from " + this.getAllocTable().GetToAllocBillEntryIDTable() + " eids \n");
        ksql.append("join T_IM_MaterialReqBillEntry e on e.FID = eids.FSourceBillEntryID \n");
        ksql.append("join T_ORG_CostCenter cc on cc.FID = e.FCostCenterOrgUnitID \n");
        ksql.append("where cc.FCostCenterType = 0 \n");
        try {
            IRowSet rowSet = NCMDbUtil.executeQuery((Context)ctx, (String)ksql.toString());
            boolean result = rowSet.next();
            rowSet.close();
            return result;
        }
        catch (Exception e) {
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
            return false;
        }
    }

    @Override
    protected boolean hasAssistantCostCenterReqFee() throws AllocateException {
        Context ctx = (Context)this._param.get("ctx");
        StringBuffer ksql = new StringBuffer();
        ksql.append("select top 1 \n");
        ksql.append("    1 \n");
        ksql.append("from " + this.getAllocTable().GetToAllocBillEntryIDTable() + " eids \n");
        ksql.append("join T_IM_MaterialReqBillEntry e on e.FID = eids.FSourceBillEntryID \n");
        ksql.append("join T_ORG_CostCenter cc on cc.FID = e.FCostCenterOrgUnitID \n");
        ksql.append("where cc.FCostCenterType = 1 \n");
        try {
            IRowSet rowSet = NCMDbUtil.executeQuery((Context)ctx, (String)ksql.toString());
            boolean result = rowSet.next();
            rowSet.close();
            return result;
        }
        catch (Exception e) {
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
            return false;
        }
    }

    @Override
    protected void InsertDirectData(Context ctx, String companyId, String periodId, String userId) throws AllocateException {
        FeeData iFee = this.GetFeeDataControl();
        String sqlDirectFee = iFee.GetDirectFeeDataSql();
        try {
            String dbTypeName = (String)ctx.get((Object)"dbType");
            int CurrentDataBaseType = DbType.getValue((String)dbTypeName);
            if (CurrentDataBaseType == 2 || CurrentDataBaseType == 7 || CurrentDataBaseType == 8) {
                this.insertDirectDataOnOracle(ctx, companyId, periodId, userId, sqlDirectFee);
            } else if (CurrentDataBaseType == 3) {
                this.insertDirectDataOnMSSqlServer(ctx, companyId, periodId, userId, sqlDirectFee);
            } else if (CurrentDataBaseType == 1) {
                this.insertDirectDataOnDB2(ctx, companyId, periodId, userId, sqlDirectFee);
            } else {
                this.insertDirectDataOnKSQL(ctx, companyId, periodId, userId, sqlDirectFee);
            }
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
        }
    }

    protected void insertDirectDataOnOracle(Context ctx, String companyId, String periodId, String userId, String sqlDirectFee) throws BOSException, AllocateException {
        StringBuffer ksql = new StringBuffer();
        ksql.setLength(0);
        ksql.append("/*dialect*/").append(" \n");
        ksql.append("alter session enable parallel dml \n");
        NCMDbUtil.execute((Context)ctx, (String)ksql.toString());
        ksql.setLength(0);
        ksql.append("/*dialect*/").append(" \n");
        ksql.append("declare \n");
        ksql.append("    cursor cur is \n");
        ksql.append("    \n");
        ksql.append("    SELECT /*+ no_merge(S) use_hash(S) */ \n");
        ksql.append("        newbosid('ADC37CB3') FID, \n");
        ksql.append("        ID FSourceBillID, \n");
        ksql.append("        ENTRYID FSourceBillEntryID, \n");
        ksql.append("        costCenterOrgUnitid FCostCenterID, \n");
        ksql.append("        COSTOBJECTID FCostObjectID, \n");
        ksql.append("        COSTITEMid FCostItemID, \n");
        ksql.append("        entrybaseQty FQty, \n");
        ksql.append("        ENTRYQTY FCommonQty, \n");
        ksql.append("        ENTRYASSISTQTY FAssistQty, \n");
        ksql.append("        entryactualCost As FAmount, \n");
        ksql.append("        ROUND(CAST(entryactualCost AS NUMBER(24, 12)) / CAST(entrybaseQty AS NUMBER(24, 12)), materialpricePrecision) As FPrice, \n");
        ksql.append("        MATERIALID FMaterialId, \n");
        ksql.append("        ENTRYLOT As FLot, \n");
        ksql.append("        BIZDATE FBizDate, \n");
        ksql.append("        ENTRYSEQ FSeq, \n");
        ksql.append("        FWareHouseID, \n");
        ksql.append("        FAdminOrgUnitID, \n");
        ksql.append("        entryFIsRework FIsRework \n");
        ksql.append("    FROM ( \n");
        ksql.append("        " + sqlDirectFee + " \n");
        ksql.append("    ) S \n");
        ksql.append("    Where entrybaseQty <> 0 ");
        ksql.append("    ; \n");
        ksql.append("    \n");
        ksql.append("    type t_rec IS TABLE OF cur%ROWTYPE; \n");
        ksql.append("    v_rec t_rec; \n");
        ksql.append("    \n");
        ksql.append("begin \n");
        ksql.append("    \n");
        ksql.append("    open cur; \n");
        ksql.append("    loop \n");
        ksql.append("        FETCH cur BULK COLLECT INTO v_rec LIMIT 1000; \n");
        ksql.append("        FORALL i IN 1 .. v_rec.COUNT \n");
        ksql.append("        \n");
        ksql.append("        INSERT /*+ append parallel(" + this.getTblResult() + ") */ INTO " + this.getTblResult() + " ( \n");
        ksql.append("            FID, \n");
        ksql.append("            FCompanyID, \n");
        ksql.append("            FCalculatePeriodID, \n");
        ksql.append("            FSourceBillID, \n");
        ksql.append("            FSourceBillEntryID, \n");
        ksql.append("            FCostCenterID, \n");
        ksql.append("            FCostObjectID, \n");
        ksql.append("            FCostItemID, \n");
        ksql.append("            FAllocStdID, \n");
        ksql.append("            FAllocStdData, \n");
        ksql.append("            FQty, \n");
        ksql.append("            FCommonQty, \n");
        ksql.append("            FAssistQty, \n");
        ksql.append("            FAmount, \n");
        ksql.append("            FPrice, \n");
        ksql.append("            FMaterialID, \n");
        ksql.append("            FLot, \n");
        ksql.append("            FBizDate, \n");
        ksql.append("            FSeq, \n");
        ksql.append("            FCreatorID, \n");
        ksql.append("            FCreateTime, \n");
        ksql.append("            FAdjustUserID, \n");
        ksql.append("            FAdjustTime, \n");
        ksql.append("            FIsDirect, \n");
        ksql.append("            AllocBillType, \n");
        ksql.append("            FWareHouseID, \n");
        ksql.append("            FAdminOrgUnitID, \n");
        ksql.append("            fIsRework \n");
        ksql.append("        ) \n");
        ksql.append("        values ( \n");
        ksql.append("            v_rec(i).FID, \n");
        ksql.append("            '" + companyId + "', \n");
        ksql.append("            '" + periodId + "', \n");
        ksql.append("            v_rec(i).FSourceBillID, \n");
        ksql.append("            v_rec(i).FSourceBillEntryID, \n");
        ksql.append("            v_rec(i).FCostCenterID, \n");
        ksql.append("            v_rec(i).FCostObjectID, \n");
        ksql.append("            v_rec(i).FCostItemID, \n");
        ksql.append("            null, \n");
        ksql.append("            1, \n");
        ksql.append("            v_rec(i).FQty, \n");
        ksql.append("            v_rec(i).FCommonQty, \n");
        ksql.append("            v_rec(i).FAssistQty, \n");
        ksql.append("            v_rec(i).FAmount, \n");
        ksql.append("            v_rec(i).FPrice, \n");
        ksql.append("            v_rec(i).FMaterialID, \n");
        ksql.append("            v_rec(i).FLot, \n");
        ksql.append("            v_rec(i).FBizDate, \n");
        ksql.append("            v_rec(i).FSeq, \n");
        ksql.append("            '" + userId + "', \n");
        ksql.append("            SYSDATE, \n");
        ksql.append("            '" + this.GetAdjustUserId() + "', \n");
        ksql.append("            SYSDATE, \n");
        ksql.append("            1, \n");
        ksql.append("            'MF', \n");
        ksql.append("            v_rec(i).FWareHouseID, \n");
        ksql.append("            v_rec(i).FAdminOrgUnitID, \n");
        ksql.append("            v_rec(i).FIsRework \n");
        ksql.append("        ); \n");
        ksql.append("        \n");
        ksql.append("        commit; \n");
        ksql.append("        EXIT WHEN cur%NOTFOUND; \n");
        ksql.append("        \n");
        ksql.append("    end loop; \n");
        ksql.append("    close cur; \n");
        ksql.append("    commit; \n");
        ksql.append("    \n");
        ksql.append("end; \n");
        ksql.setLength(0);
        ksql.append("/*dialect*/").append(" \n");
        ksql.append("declare \n");
        ksql.append("    cursor cur is \n");
        ksql.append("    \n");
        ksql.append("    SELECT /*+ no_merge(S) use_hash(S) */ \n");
        ksql.append("        newbosid('ADC37CB3') FID, \n");
        ksql.append("        ID FSourceBillID, \n");
        ksql.append("        ENTRYID FSourceBillEntryID, \n");
        ksql.append("        costCenterOrgUnitid FCostCenterID, \n");
        ksql.append("        COSTOBJECTID FCostObjectID, \n");
        ksql.append("        COSTITEMid FCostItemID, \n");
        ksql.append("        entrybaseQty FQty, \n");
        ksql.append("        ENTRYQTY FCommonQty, \n");
        ksql.append("        ENTRYASSISTQTY FAssistQty, \n");
        ksql.append("        entryactualCost As FAmount, \n");
        ksql.append("        ROUND(CAST(entryactualCost AS NUMBER(24, 12)) / CAST(entrybaseQty AS NUMBER(24, 12)), materialpricePrecision) As FPrice, \n");
        ksql.append("        MATERIALID FMaterialId, \n");
        ksql.append("        ENTRYLOT As FLot, \n");
        ksql.append("        BIZDATE FBizDate, \n");
        ksql.append("        ENTRYSEQ FSeq, \n");
        ksql.append("        FWareHouseID, \n");
        ksql.append("        FAdminOrgUnitID, \n");
        ksql.append("        entryFIsRework FIsRework \n");
        ksql.append("    FROM ( \n");
        ksql.append("        " + sqlDirectFee + " \n");
        ksql.append("    ) S \n");
        ksql.append("    Where entrybaseQty <> 0 ");
        ksql.append("    ; \n");
        ksql.append("    \n");
        ksql.append("    type t_FID IS TABLE OF " + this.getTblResult() + ".FID%TYPE; \n");
        ksql.append("    type t_FSourceBillID IS TABLE OF " + this.getTblResult() + ".FSourceBillID%TYPE; \n");
        ksql.append("    type t_FSourceBillEntryID IS TABLE OF " + this.getTblResult() + ".FSourceBillEntryID%TYPE; \n");
        ksql.append("    type t_FCostCenterID IS TABLE OF " + this.getTblResult() + ".FCostCenterID%TYPE; \n");
        ksql.append("    type t_FCostObjectID IS TABLE OF " + this.getTblResult() + ".FCostObjectID%TYPE; \n");
        ksql.append("    type t_FCostItemID IS TABLE OF " + this.getTblResult() + ".FCostItemID%TYPE; \n");
        ksql.append("    type t_FQty IS TABLE OF " + this.getTblResult() + ".FQty%TYPE; \n");
        ksql.append("    type t_FCommonQty IS TABLE OF " + this.getTblResult() + ".FCommonQty%TYPE; \n");
        ksql.append("    type t_FAssistQty IS TABLE OF " + this.getTblResult() + ".FAssistQty%TYPE; \n");
        ksql.append("    type t_FAmount IS TABLE OF " + this.getTblResult() + ".FAmount%TYPE; \n");
        ksql.append("    type t_FPrice IS TABLE OF " + this.getTblResult() + ".FPrice%TYPE; \n");
        ksql.append("    type t_FMaterialID IS TABLE OF " + this.getTblResult() + ".FMaterialID%TYPE; \n");
        ksql.append("    type t_FLot IS TABLE OF " + this.getTblResult() + ".FLot%TYPE; \n");
        ksql.append("    type t_FBizDate IS TABLE OF " + this.getTblResult() + ".FBizDate%TYPE; \n");
        ksql.append("    type t_FSeq IS TABLE OF " + this.getTblResult() + ".FSeq%TYPE; \n");
        ksql.append("    type t_FWareHouseID IS TABLE OF " + this.getTblResult() + ".FWareHouseID%TYPE; \n");
        ksql.append("    type t_FAdminOrgUnitID IS TABLE OF " + this.getTblResult() + ".FAdminOrgUnitID%TYPE; \n");
        ksql.append("    type t_FIsRework IS TABLE OF " + this.getTblResult() + ".FIsRework%TYPE; \n");
        ksql.append("    \n");
        ksql.append("    v_FID t_FID; \n");
        ksql.append("    v_FSourceBillID t_FSourceBillID; \n");
        ksql.append("    v_FSourceBillEntryID t_FSourceBillEntryID; \n");
        ksql.append("    v_FCostCenterID t_FCostCenterID; \n");
        ksql.append("    v_FCostObjectID t_FCostObjectID; \n");
        ksql.append("    v_FCostItemID t_FCostItemID; \n");
        ksql.append("    v_FQty t_FQty; \n");
        ksql.append("    v_FCommonQty t_FCommonQty; \n");
        ksql.append("    v_FAssistQty t_FAssistQty; \n");
        ksql.append("    v_FAmount t_FAmount; \n");
        ksql.append("    v_FPrice t_FPrice; \n");
        ksql.append("    v_FMaterialID t_FMaterialID; \n");
        ksql.append("    v_FLot t_FLot; \n");
        ksql.append("    v_FBizDate t_FBizDate; \n");
        ksql.append("    v_FSeq t_FSeq; \n");
        ksql.append("    v_FWareHouseID t_FWareHouseID; \n");
        ksql.append("    v_FAdminOrgUnitID t_FAdminOrgUnitID; \n");
        ksql.append("    v_FIsRework t_FIsRework; \n");
        ksql.append("    \n");
        ksql.append("begin \n");
        ksql.append("    \n");
        ksql.append("    open cur; \n");
        ksql.append("    loop \n");
        ksql.append("        FETCH cur BULK COLLECT INTO \n");
        ksql.append("            v_FID, \n");
        ksql.append("            v_FSourceBillID, \n");
        ksql.append("            v_FSourceBillEntryID, \n");
        ksql.append("            v_FCostCenterID, \n");
        ksql.append("            v_FCostObjectID, \n");
        ksql.append("            v_FCostItemID, \n");
        ksql.append("            v_FQty, \n");
        ksql.append("            v_FCommonQty, \n");
        ksql.append("            v_FAssistQty, \n");
        ksql.append("            v_FAmount, \n");
        ksql.append("            v_FPrice, \n");
        ksql.append("            v_FMaterialID, \n");
        ksql.append("            v_FLot, \n");
        ksql.append("            v_FBizDate, \n");
        ksql.append("            v_FSeq, \n");
        ksql.append("            v_FWareHouseID, \n");
        ksql.append("            v_FAdminOrgUnitID, \n");
        ksql.append("            v_FIsRework \n");
        ksql.append("        LIMIT 1000; \n");
        ksql.append("        FORALL i IN 1 .. v_FID.COUNT \n");
        ksql.append("        INSERT /*+ append parallel(" + this.getTblResult() + ") */ INTO " + this.getTblResult() + " ( \n");
        ksql.append("            FID, \n");
        ksql.append("            FCompanyID, \n");
        ksql.append("            FCalculatePeriodID, \n");
        ksql.append("            FSourceBillID, \n");
        ksql.append("            FSourceBillEntryID, \n");
        ksql.append("            FCostCenterID, \n");
        ksql.append("            FCostObjectID, \n");
        ksql.append("            FCostItemID, \n");
        ksql.append("            FAllocStdID, \n");
        ksql.append("            FAllocStdData, \n");
        ksql.append("            FQty, \n");
        ksql.append("            FCommonQty, \n");
        ksql.append("            FAssistQty, \n");
        ksql.append("            FAmount, \n");
        ksql.append("            FPrice, \n");
        ksql.append("            FMaterialID, \n");
        ksql.append("            FLot, \n");
        ksql.append("            FBizDate, \n");
        ksql.append("            FSeq, \n");
        ksql.append("            FCreatorID, \n");
        ksql.append("            FCreateTime, \n");
        ksql.append("            FAdjustUserID, \n");
        ksql.append("            FAdjustTime, \n");
        ksql.append("            FIsDirect, \n");
        ksql.append("            AllocBillType, \n");
        ksql.append("            FWareHouseID, \n");
        ksql.append("            FAdminOrgUnitID, \n");
        ksql.append("            fIsRework \n");
        ksql.append("        ) \n");
        ksql.append("        values ( \n");
        ksql.append("            v_FID(i), \n");
        ksql.append("            '" + companyId + "', \n");
        ksql.append("            '" + periodId + "', \n");
        ksql.append("            v_FSourceBillID(i), \n");
        ksql.append("            v_FSourceBillEntryID(i), \n");
        ksql.append("            v_FCostCenterID(i), \n");
        ksql.append("            v_FCostObjectID(i), \n");
        ksql.append("            v_FCostItemID(i), \n");
        ksql.append("            null, \n");
        ksql.append("            1, \n");
        ksql.append("            v_FQty(i), \n");
        ksql.append("            v_FCommonQty(i), \n");
        ksql.append("            v_FAssistQty(i), \n");
        ksql.append("            v_FAmount(i), \n");
        ksql.append("            v_FPrice(i), \n");
        ksql.append("            v_FMaterialID(i), \n");
        ksql.append("            v_FLot(i), \n");
        ksql.append("            v_FBizDate(i), \n");
        ksql.append("            v_FSeq(i), \n");
        ksql.append("            '" + userId + "', \n");
        ksql.append("            SYSDATE, \n");
        ksql.append("            '" + this.GetAdjustUserId() + "', \n");
        ksql.append("            SYSDATE, \n");
        ksql.append("            1, \n");
        ksql.append("            'MF', \n");
        ksql.append("            v_FWareHouseID(i), \n");
        ksql.append("            v_FAdminOrgUnitID(i), \n");
        ksql.append("            v_FIsRework(i) \n");
        ksql.append("        ); \n");
        ksql.append("        \n");
        ksql.append("        commit; \n");
        ksql.append("        EXIT WHEN cur%NOTFOUND; \n");
        ksql.append("        \n");
        ksql.append("    end loop; \n");
        ksql.append("    close cur; \n");
        ksql.append("    commit; \n");
        ksql.append("    \n");
        ksql.append("end; \n");
        NCMDbUtil.execute((Context)ctx, (String)ksql.toString());
    }

    protected void insertDirectDataOnKSQL(Context ctx, String companyId, String periodId, String userId, String sqlDirectFee) throws BOSException, AllocateException {
        StringBuffer ksql = new StringBuffer();
        ksql.append("INSERT INTO " + this.getTblResult() + " ( \n");
        ksql.append("    FID, \n");
        ksql.append("    FCompanyID, \n");
        ksql.append("    FCalculatePeriodID, \n");
        ksql.append("    FSourceBillID, \n");
        ksql.append("    FSourceBillEntryID, \n");
        ksql.append("    FCostCenterID, \n");
        ksql.append("    FCostObjectID, \n");
        ksql.append("    FCostItemID, \n");
        ksql.append("    FAllocStdID, \n");
        ksql.append("    FAllocStdData, \n");
        ksql.append("    FQty, \n");
        ksql.append("    FCommonQty, \n");
        ksql.append("    FAssistQty, \n");
        ksql.append("    FAmount, \n");
        ksql.append("    FPrice, \n");
        ksql.append("    FMaterialID, \n");
        ksql.append("    FLot, \n");
        ksql.append("    FBizDate, \n");
        ksql.append("    FSeq, \n");
        ksql.append("    FCreatorID, \n");
        ksql.append("    FCreateTime, \n");
        ksql.append("    FAdjustUserID, \n");
        ksql.append("    FAdjustTime, \n");
        ksql.append("    FIsDirect, \n");
        ksql.append("    AllocBillType, \n");
        ksql.append("    FWareHouseID, \n");
        ksql.append("    FAdminOrgUnitID, \n");
        ksql.append("    fIsRework \n");
        ksql.append(") \n");
        ksql.append("SELECT \n");
        ksql.append("    newbosid('ADC37CB3') FID, \n");
        ksql.append("    '" + companyId + "' FCompanyID, \n");
        ksql.append("    '" + periodId + "' FCalculatePeriodID, \n");
        ksql.append("    ID FSourceBillID, \n");
        ksql.append("    ENTRYID FSourceBillEntryID, \n");
        ksql.append("    costCenterOrgUnitid FCostCenterID, \n");
        ksql.append("    COSTOBJECTID FCostObjectID, \n");
        ksql.append("    COSTITEMid FCostItemID, \n");
        ksql.append("    null FAllocStdID, \n");
        ksql.append("    1 FAllocStdData, \n");
        ksql.append("    entrybaseQty FQty, \n");
        ksql.append("    ENTRYQTY FCommonQty, \n");
        ksql.append("    ENTRYASSISTQTY FAssistQty, \n");
        ksql.append("    entryactualCost FAmount, \n");
        ksql.append("    ROUND(to_decimal(entryactualCost,24,12) / to_decimal(entrybaseQty,24,12), materialpricePrecision) FPrice, \n");
        ksql.append("    MATERIALID FMaterialId, \n");
        ksql.append("    ENTRYLOT FLot, \n");
        ksql.append("    BIZDATE FBizDate, \n");
        ksql.append("    ENTRYSEQ FSeq, \n");
        ksql.append("    '" + userId + "' FCreatorID, \n");
        ksql.append("    GetDate() FCreateTime, \n");
        ksql.append("    '" + this.GetAdjustUserId() + "' FAdjustUserID, \n");
        ksql.append("    GetDate() FAdjustTime, \n");
        ksql.append("    1 FIsDirect, \n");
        ksql.append("    'MF' AllocBillType, \n");
        ksql.append("    FWareHouseID, \n");
        ksql.append("    FAdminOrgUnitID, \n");
        ksql.append("    entryFIsRework FIsRework \n");
        ksql.append("FROM ( " + sqlDirectFee + " ) S \n");
        ksql.append("Where entrybaseQty <> 0 \n");
        NCMDbUtil.execute((Context)ctx, (String)ksql.toString());
    }

    protected void insertDirectDataOnMSSqlServer(Context ctx, String companyId, String periodId, String userId, String sqlDirectFee) throws BOSException, AllocateException {
        this.insertDirectDataOnKSQL(ctx, companyId, periodId, userId, sqlDirectFee);
    }

    protected void insertDirectDataOnDB2(Context ctx, String companyId, String periodId, String userId, String sqlDirectFee) throws BOSException, AllocateException {
        this.insertDirectDataOnKSQL(ctx, companyId, periodId, userId, sqlDirectFee);
    }

    @Override
    public void commitAllocResult(boolean isLastBatch) throws AllocateException {
        super.commitAllocResult(isLastBatch);
        if (isLastBatch) {
            this.updateAllocResult();
        }
    }

    protected void updateAllocResult() throws AllocateException {
        String companyId = this._param.get("companyId").toString();
        String periodId = this._param.get("periodId").toString();
        Context ctx = (Context)this._param.get("ctx");
        StringBuffer updateIsRework = new StringBuffer();
        updateIsRework.append("UPDATE {0} SET FIsRework = 1 ").append('\n').append("    WHERE Fsourcebillentryid IN ").append('\n').append("            (SELECT BILLENTRY.FID FROM {1} BILLENTRY").append('\n').append("              Where {2}.FMaterialID = billEntry.FMaterialID AND billEntry.FIsRework = 1 AND BILLENTRY.Fcompanyorgunitid =''{3}'') ").append('\n').append("          AND FCompanyID = ''{3}''").append('\n').append("          AND FCalculatePeriodID = ''{4}''");
        String sqlUpdateIsRework = MessageFormat.format(updateIsRework.toString(), this.getTblResult(), "T_IM_MaterialReqBillEntry", this.getTblResult(), companyId, periodId);
        updateIsRework.delete(0, updateIsRework.length());
        try {
            NCMDbUtil.execute((Context)ctx, (String)sqlUpdateIsRework);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
        }
    }
}

