/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Table;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.ncm.bill.AllocateException;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Table.AllocTable;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.util.Assert;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class CCOAllocTable
extends AllocTable {
    private static Logger logger = Logger.getLogger((String)CCOAllocTable.class.getName());
    protected String _tblResult = null;
    protected String _tempTblObjectRange = null;
    protected String _tblCostCalPrdDetailResult = null;
    protected String _tempTblBillEntryID = null;
    protected String _ccoAllocTemp = null;
    protected String _ccoAllocTemp2 = null;
    protected Map tblAllocDataCache = null;
    protected static final char CLF = '\n';
    protected TempTablePool pool;

    public CCOAllocTable(Map param) {
        super(param);
        Assert.that((boolean)param.containsKey("pool"));
        this.pool = (TempTablePool)param.get("pool");
    }

    @Override
    public String GetResultTable() throws AllocateException {
        if (this._tblResult != null) {
            return this._tblResult;
        }
        String Sql_NCM_OtherAllocResult = "Create Table t_ncm_CCOAllocResult ( FID VARCHAR(44) NOT NULL,FCompanyID VARCHAR(44),FCalculatePeriodID VARCHAR(44),FExpenseID VARCHAR(44),FCostCenterGroupID VARCHAR(44),FCostCenterID VARCHAR(44),FSourceBillID VARCHAR(44),FSourceBillEntryID VARCHAR(44),FCostItemID VARCHAR(44),FSourceCostCenterID VARCHAR(44),FDepartmentID VARCHAR(44),FAllocStdID VARCHAR(44),FAllocStdData NUMERIC(24,12),FQty NUMERIC(21,8),FPrice NUMERIC(21,8),FAmount NUMERIC(17,4),FCreatorID VARCHAR(44),FCreateTime DateTime,FAdjustUserID VARCHAR(44),FAdjustTime DateTime,FIsDirect INT)";
        try {
            this._tblResult = this.pool.createTempTable(Sql_NCM_OtherAllocResult);
            this.pool.createIndex(this._tblResult, "FID", false, false);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e);
        }
        return this._tblResult;
    }

    @Override
    public String GetObjectRangeTable() throws AllocateException {
        if (this._tempTblObjectRange != null) {
            return this._tempTblObjectRange;
        }
        String createSqlTempTblObjectRange = "create table t_ncm_ObjectRange (FID varchar(44),FCostCenterID varchar(44),FCostObjectID varchar(44),FMaterialID varchar(44),FIsValid INT)";
        try {
            this._tempTblObjectRange = this.pool.createTempTable(createSqlTempTblObjectRange);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e);
        }
        return this._tempTblObjectRange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public String GetAllocDataTable(String factorFldCreateList) throws AllocateException {
        if (this.tblAllocDataCache == null) {
            Class<CCOAllocTable> clazz = CCOAllocTable.class;
            // MONITORENTER : com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Table.CCOAllocTable.class
            this.tblAllocDataCache = Collections.synchronizedMap(new HashMap());
            // MONITOREXIT : clazz
        }
        if (this.tblAllocDataCache.containsKey(factorFldCreateList)) {
            return (String)this.tblAllocDataCache.get(factorFldCreateList);
        }
        String createSqlTempTblAllocDataTable = "create table t_ncm_AllocData (FID varchar(44)," + factorFldCreateList + "FCostCenterID varchar(44),FCostObjectID varchar(44),FMaterialID varchar(44),FQty NUMERIC(24,12) Default(0), FRatio NUMERIC(24,12) Default(0))";
        String tblname = null;
        try {
            tblname = this.pool.createTempTable(createSqlTempTblAllocDataTable);
            this.pool.createIndex(tblname, "FID", false, false);
            this.pool.createIndex(tblname, "FCostCenterID,FCostObjectID", false, false);
            this.tblAllocDataCache.put(factorFldCreateList, tblname);
            return tblname;
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        return tblname;
    }

    @Override
    public String GetCalPrdDetailResultTable() throws AllocateException {
        return null;
    }

    @Override
    public void CreateTempTableIndexs() throws AllocateException {
        try {
            String tbl_range = this.GetObjectRangeTable();
            this.pool.createIndex(tbl_range, "FID", false, false);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    @Override
    public void releaseTempTable() {
        if (this._tblResult != null) {
            this.pool.releaseTable(this._tblResult);
        }
        if (this._tempTblObjectRange != null) {
            this.pool.releaseTable(this._tempTblObjectRange);
        }
        if (this._tempTblBillEntryID != null) {
            this.pool.releaseTable(this._tempTblBillEntryID);
        }
        if (this._ccoAllocTemp != null) {
            this.pool.releaseTable(this._ccoAllocTemp);
        }
        if (this._ccoAllocTemp2 != null) {
            this.pool.releaseTable(this._ccoAllocTemp2);
        }
        if (this.tblAllocDataCache != null) {
            for (Map.Entry entry : this.tblAllocDataCache.entrySet()) {
                String tblname = (String)entry.getValue();
                this.pool.releaseTable(tblname);
            }
        }
    }

    @Override
    public String GetToAllocBillEntryIDTable() throws AllocateException {
        if (this._tempTblBillEntryID != null) {
            return this._tempTblBillEntryID;
        }
        String createSqlTempBillEntryID = "create table t_ncm_BillEntryIDData (FSourceBillEntryID VARCHAR(44))";
        try {
            this._tempTblBillEntryID = this.pool.createTempTable(createSqlTempBillEntryID);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e);
        }
        return this._tempTblBillEntryID;
    }

    public String getCCOAllocTempTable(Context ctx) throws BOSException {
        if (this._ccoAllocTemp == null) {
            StringBuffer createTableSql = new StringBuffer();
            createTableSql.append("CREATE TABLE ");
            createTableSql.append("CCOAllocTemp");
            createTableSql.append("\t(");
            createTableSql.append("FID   \tVARCHAR(44)");
            createTableSql.append(")");
            try {
                this._ccoAllocTemp = this.pool.createTempTable(createTableSql.toString());
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        NCMDbUtil.execute((Context)ctx, (String)("truncate table " + this._ccoAllocTemp));
        return this._ccoAllocTemp;
    }

    public String getCCOAllocTempTable2(Context ctx) throws BOSException {
        if (this._ccoAllocTemp2 == null) {
            StringBuffer createTableSql = new StringBuffer();
            createTableSql.append("CREATE TABLE ");
            createTableSql.append("CCOAllocTemp2");
            createTableSql.append("\t(");
            createTableSql.append("FID   \tVARCHAR(44)");
            createTableSql.append(")");
            try {
                this._ccoAllocTemp2 = this.pool.createTempTable(createTableSql.toString());
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        NCMDbUtil.execute((Context)ctx, (String)("truncate table " + this._ccoAllocTemp2));
        return this._ccoAllocTemp2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public String getHourStrategyTbl() throws AllocateException {
        if (this.tblAllocDataCache == null) {
            Class<CCOAllocTable> clazz = CCOAllocTable.class;
            // MONITORENTER : com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Table.CCOAllocTable.class
            this.tblAllocDataCache = Collections.synchronizedMap(new HashMap());
            // MONITOREXIT : clazz
        }
        if (this.tblAllocDataCache.containsKey("hourStrategyTbl")) {
            return (String)this.tblAllocDataCache.get("hourStrategyTbl");
        }
        String createSqlTempTblAllocDataTable = "create table hourStrategyTbl (FID varchar(44),FQty NUMERIC(24,12) Default(0))";
        String tblname = null;
        try {
            tblname = this.pool.createTempTable(createSqlTempTblAllocDataTable);
            this.pool.createIndex(tblname, "FID", false, false);
            this.tblAllocDataCache.put("hourStrategyTbl", tblname);
            return tblname;
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        return tblname;
    }
}

