/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Table;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.bill.AllocateException;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Table.AllocTable;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Table.CCOAllocTable;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.util.Assert;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class OtherAllocTable
extends AllocTable {
    private static Logger logger = Logger.getLogger((String)OtherAllocTable.class.getName());
    protected String _tblResult = null;
    protected String _tempTblObjectRange = null;
    protected String _tblCostCalPrdDetailResult = null;
    protected String _tempTblBillEntryID = null;
    protected Map tblAllocDataCache = null;
    protected static final char CLF = '\n';
    protected TempTablePool pool;

    public OtherAllocTable(Map param) {
        super(param);
        Assert.that((boolean)param.containsKey("pool"));
        this.pool = (TempTablePool)param.get("pool");
    }

    protected String setAllocTblResult() {
        return "T_NCM_OtherAllocResult";
    }

    @Override
    public String GetResultTable() throws AllocateException {
        if (this._tblResult != null) {
            return this._tblResult;
        }
        Context ctx = (Context)this.param.get("ctx");
        String companyId = this.param.get("companyId").toString();
        try {
            this._tblResult = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)this.setAllocTblResult());
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e);
        }
        return this._tblResult;
    }

    @Override
    public String GetObjectRangeTable() throws AllocateException {
        if (this._tempTblObjectRange != null) {
            return this._tempTblObjectRange;
        }
        String createSqlTempTblObjectRange = "create table t_ncm_ObjectRange (FID varchar(44),FCostCenterID varchar(44),FCostObjectID varchar(44),FMaterialID varchar(44),FCostItemID varchar(44),FIsValid INT)";
        try {
            this._tempTblObjectRange = this.pool.createTempTable(createSqlTempTblObjectRange);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e);
        }
        return this._tempTblObjectRange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public String GetAllocDataTable(String factorFldCreateList) throws AllocateException {
        if (this.tblAllocDataCache == null) {
            Class<OtherAllocTable> clazz = OtherAllocTable.class;
            // MONITORENTER : com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Table.OtherAllocTable.class
            this.tblAllocDataCache = Collections.synchronizedMap(new HashMap());
            // MONITOREXIT : clazz
        }
        if (this.tblAllocDataCache.containsKey(factorFldCreateList)) {
            return (String)this.tblAllocDataCache.get(factorFldCreateList);
        }
        String createSqlTempTblAllocDataTable = "create table t_ncm_AllocData (FID varchar(44)," + factorFldCreateList + "FQty NUMERIC(24,12) Default(0), FRatio NUMERIC(24,12) Default(0),FRatioSum NUMERIC(24,12) Default(0))";
        String tblname = null;
        try {
            tblname = this.pool.createTempTable(createSqlTempTblAllocDataTable);
            this.pool.createIndex(tblname, "FID", false, false);
            this.tblAllocDataCache.put(factorFldCreateList, tblname);
            return tblname;
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        return tblname;
    }

    @Override
    public String GetCalPrdDetailResultTable() throws AllocateException {
        if (this._tblCostCalPrdDetailResult != null) {
            return this._tblCostCalPrdDetailResult;
        }
        Context ctx = (Context)this.param.get("ctx");
        String companyId = this.param.get("companyId").toString();
        try {
            this._tblCostCalPrdDetailResult = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_CostCalPrdDetailResult");
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e);
        }
        return this._tblCostCalPrdDetailResult;
    }

    @Override
    public void CreateTempTableIndexs() throws AllocateException {
        try {
            String tbl_range = this.GetObjectRangeTable();
            this.pool.createIndex(tbl_range, "FID", false, false);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    @Override
    public void releaseTempTable() {
        if (this._tempTblObjectRange != null) {
            this.pool.releaseTable(this._tempTblObjectRange);
        }
        if (this._tempTblBillEntryID != null) {
            this.pool.releaseTable(this._tempTblBillEntryID);
        }
        if (this.tblAllocDataCache != null) {
            for (Map.Entry entry : this.tblAllocDataCache.entrySet()) {
                String tblname = (String)entry.getValue();
                this.pool.releaseTable(tblname);
            }
        }
    }

    @Override
    public String GetToAllocBillEntryIDTable() throws AllocateException {
        if (this._tempTblBillEntryID != null) {
            return this._tempTblBillEntryID;
        }
        String createSqlTempBillEntryID = "create table t_ncm_BillEntryIDDataList ( \n    FSourceBillEntryID VARCHAR(44), \n    FIsDirect INT \n) \n";
        try {
            this._tempTblBillEntryID = this.pool.createTempTable(createSqlTempBillEntryID);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e);
        }
        return this._tempTblBillEntryID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public String getHourStrategyTbl() throws AllocateException {
        if (this.tblAllocDataCache == null) {
            Class<CCOAllocTable> clazz = CCOAllocTable.class;
            // MONITORENTER : com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Table.CCOAllocTable.class
            this.tblAllocDataCache = Collections.synchronizedMap(new HashMap());
            // MONITOREXIT : clazz
        }
        if (this.tblAllocDataCache.containsKey("hourStrategyTbl")) {
            return (String)this.tblAllocDataCache.get("hourStrategyTbl");
        }
        String createSqlTempTblAllocDataTable = "create table hourStrategyTbl (FID varchar(44),FQty NUMERIC(24,12) Default(0))";
        String tblname = null;
        try {
            tblname = this.pool.createTempTable(createSqlTempTblAllocDataTable);
            this.pool.createIndex(tblname, "FID", false, false);
            this.tblAllocDataCache.put("hourStrategyTbl", tblname);
            return tblname;
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        return tblname;
    }
}

