/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app.Alloc;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.basedata.ncm.AllocStdTypeEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.ncm.bill.AllocTypeEnum;
import com.kingdee.eas.ncm.bill.AllocateException;
import com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.AUSContext;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Allocator;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.AutoCCOAllocator;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.BaseAllocator;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.ManuCCOAllocator;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Table.AllocTable;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.WizOtherAllocator;
import com.kingdee.eas.ncm.bill.app.Alloc.BatchAllocIterator.AutoCCOBatchAllocIterator;
import com.kingdee.eas.ncm.bill.app.Alloc.BatchAllocIterator.IBatchAllocIterator;
import com.kingdee.eas.ncm.bill.app.Alloc.BatchAllocIterator.ManuCCOBatchAllocIterator;
import com.kingdee.eas.ncm.bill.app.Alloc.BatchAllocIterator.WizOtherBatchAllocIterator;
import com.kingdee.eas.ncm.bill.app.Alloc.helper.AllocateExceptionLog;
import com.kingdee.eas.ncm.bill.app.CostDataCache;
import com.kingdee.eas.ncm.common.AllocSourceBillEnum;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.Assert;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class CCOAllocDispatch {
    private Map _param;
    private Allocator allocator;
    private AllocateExceptionLog _logger;
    private String companyId;
    private String periodId;
    private String userId;
    private AllocTypeEnum allocType;
    private FilterInfo filterInfo;
    private AllocSourceBillEnum allocSourceBill;
    private static Logger log = Logger.getLogger((String)"com.kingdee.eas.ncm.bill.app.Alloc.AllocDispatchLog");
    private CostDataCache costDataCache = null;

    public CCOAllocDispatch(Map param) {
        Assert.that((boolean)param.containsKey("companyId"));
        Assert.that((boolean)param.containsKey("periodId"));
        Assert.that((boolean)param.containsKey("userId"));
        Assert.that((boolean)param.containsKey("allocType"));
        Assert.that((boolean)param.containsKey("filterInfo"));
        this._param = param;
        this.companyId = param.get("companyId").toString();
        this.periodId = param.get("periodId").toString();
        this.userId = param.get("userId").toString();
        this.allocType = (AllocTypeEnum)((Object)param.get("allocType"));
        this.filterInfo = (FilterInfo)param.get("filterInfo");
        this._param.put("allocStdType", AllocStdTypeEnum.INNERCC);
        this.allocSourceBill = (AllocSourceBillEnum)param.get("allocSourceBill");
        if (!this._param.containsKey("CostDataCache")) {
            this.costDataCache = new CostDataCache(this._param);
            this._param.put("CostDataCache", this.costDataCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map DoAllocate() throws Exception {
        Context ctx = (Context)this._param.get("ctx");
        log.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"27_AllocDispatch", (Locale)ctx.getLocale()));
        log.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"28_AllocDispatch", (Locale)ctx.getLocale()));
        AUSContext ausCtx = new AUSContext(this._param);
        this.allocator = this.CreateAllocator(ausCtx);
        AllocTable allocTable = this.allocator.getAllocTable();
        this._param.put("allocTable", allocTable);
        IBatchAllocIterator iterator = this.CreateBatchAllocIterator(this.allocator);
        Map ret = null;
        log.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"29_AllocDispatch", (Locale)ctx.getLocale()));
        try {
            try {
                this.allocator.preCheck();
            }
            catch (Exception e) {
                AllocateException ae = new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e);
                this._logger.AddLog(ae);
                log.error((Object)"", (Throwable)e);
                throw ae;
            }
            log.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"30_AllocDispatch", (Locale)ctx.getLocale()));
            try {
                this.allocator.preProcess();
            }
            catch (Exception e) {
                AllocateException ae = new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e);
                this._logger.AddLog(ae);
                log.error((Object)"", (Throwable)e);
                throw ae;
            }
            log.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"32_AllocDispatch", (Locale)ctx.getLocale()));
            iterator.FirstBatch();
            while (!iterator.IsDone()) {
                iterator.AllocateCurrBatch();
                iterator.NextBatch();
            }
            log.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"33_AllocDispatch", (Locale)ctx.getLocale()));
            ret = this.allocator.processResult();
        }
        finally {
            Exception ex;
            block20: {
                ex = null;
                try {
                    this.allocator.endProcess();
                }
                catch (Exception e) {
                    ex = e;
                }
                try {
                    if (this.costDataCache != null) {
                        this.costDataCache.release();
                    }
                }
                catch (Exception e) {
                    if (ex != null) break block20;
                    ex = e;
                }
            }
            if (ex != null) {
                throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, ex);
            }
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)ctx.get((Object)OrgType.Company);
            boolean isSuccessed = false;
            if (this._logger == null || this._logger.getLogCount() == 0) {
                isSuccessed = true;
            }
            NCMUtils.addEASLogForAlloc((Context)ctx, (String)"DoAllocate", (String)(company.getNumber() + ' ' + company.getName()), (AllocSourceBillEnum)this.allocSourceBill, (AllocTypeEnum)this.allocType, (String)this.companyId, (boolean)isSuccessed);
        }
        log.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"34_AllocDispatch", (Locale)ctx.getLocale()));
        return ret;
    }

    private Allocator CreateAllocator(AUSContext ausCtx) {
        BaseAllocator alloc = null;
        switch (this.allocType.getValue()) {
            case 2: {
                this._param.put("logTblName", "T_NCM_LOG_CCO");
                this._logger = new AllocateExceptionLog(this._param);
                this._param.put("logger", this._logger);
                alloc = new AutoCCOAllocator(this._param, ausCtx);
                break;
            }
            case 1: {
                alloc = new ManuCCOAllocator(this._param, ausCtx);
                break;
            }
            case 3: {
                this._param.put("logTblName", "T_NCM_LOG_CCO");
                this._logger = new AllocateExceptionLog(this._param);
                this._param.put("logger", this._logger);
                alloc = new WizOtherAllocator(this._param, ausCtx);
            }
        }
        return alloc;
    }

    private IBatchAllocIterator CreateBatchAllocIterator(Allocator allocatorAdapter) throws AllocateException {
        IBatchAllocIterator alloc = null;
        switch (this.allocType.getValue()) {
            case 2: {
                alloc = new AutoCCOBatchAllocIterator(this._param, allocatorAdapter);
                break;
            }
            case 1: {
                alloc = new ManuCCOBatchAllocIterator(this._param, allocatorAdapter);
                break;
            }
            case 3: {
                alloc = new WizOtherBatchAllocIterator(this._param, allocatorAdapter);
            }
        }
        return alloc;
    }

    public AllocTypeEnum getAllocType() {
        return this.allocType;
    }

    public String getCompanyId() {
        return this.companyId;
    }

    public FilterInfo getFilterInfo() {
        return this.filterInfo;
    }

    public String getPeriodId() {
        return this.periodId;
    }

    public String getUserId() {
        return this.userId;
    }

    public Allocator getAllocator() {
        return this.allocator;
    }

    public LinkedList buildCostTaskEntries() {
        LinkedList costTaskEntries = new LinkedList();
        return costTaskEntries;
    }
}

