/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app.Alloc.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.ncm.bill.AllocateException;
import com.kingdee.eas.ncm.bill.app.Alloc.helper.AllocUtils;
import com.kingdee.eas.ncm.common.utils.NCMCommonParams;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AllocateExceptionLog {
    private Context _ctx = null;
    private String _companyId = null;
    private String _periodId = null;
    private String _logTblName = null;
    private String _LogPhysicalTblName = null;
    private int _logCount = 0;
    private Set errors = new HashSet();
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ncm.bill.app.Alloc.helper.AllocateExceptionLog");

    public AllocateExceptionLog(Map param) {
        Assert.that((boolean)param.containsKey("companyId"));
        Assert.that((boolean)param.containsKey("periodId"));
        Assert.that((boolean)param.containsKey("logTblName"));
        Assert.that((boolean)param.containsKey("ctx"));
        this._companyId = (String)param.get("companyId");
        this._periodId = (String)param.get("periodId");
        this._logTblName = (String)param.get("logTblName");
        this._ctx = (Context)param.get("ctx");
        try {
            this._LogPhysicalTblName = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this._ctx, (String)this._companyId, (String)this._logTblName);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        if (this._LogPhysicalTblName != null) {
            try {
                NCMDynamicTableManager.DeleteTable((Context)this._ctx, (String)this._LogPhysicalTblName, null);
            }
            catch (SQLException e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
    }

    public AllocateExceptionLog(NCMCommonParams param) {
        Assert.that((boolean)param.containsKey("companyId"));
        Assert.that((boolean)param.containsKey("periodId"));
        Assert.that((boolean)param.containsKey("logTblName"));
        Assert.that((boolean)param.containsKey("ctx"));
        this._companyId = param.getCOMPANY_ID();
        this._periodId = param.getPERIOD_ID();
        this._logTblName = param.getString("logTblName");
        this._ctx = param.getCTX();
        try {
            this._LogPhysicalTblName = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this._ctx, (String)this._companyId, (String)this._logTblName);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        if (this._LogPhysicalTblName != null) {
            try {
                NCMDynamicTableManager.DeleteTable((Context)this._ctx, (String)this._LogPhysicalTblName, null);
            }
            catch (SQLException e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
    }

    public void AddLog(AllocateException e) {
        Assert.that((this._companyId != null ? 1 : 0) != 0);
        Assert.that((this._periodId != null ? 1 : 0) != 0);
        String possibleReason = null;
        String adviceHandle = null;
        if (e.getSubCode().equals(AllocateException.ITEM_ALLOC_SQLEXCEPTION.getCode())) {
            logger.error((Object)"", (Throwable)((Object)e));
            possibleReason = e.getCause().getMessage();
            adviceHandle = AllocUtils.getAllocResource(this._ctx, "advice_handle_checkWithTechnician");
        } else if (e.getSubCode().equals(AllocateException.ITEM_ALLOC_BOSEXCEPTION.getCode())) {
            logger.error((Object)"", (Throwable)((Object)e));
            possibleReason = e.getCause().getMessage();
            adviceHandle = AllocUtils.getAllocResource(this._ctx, "advice_handle_checkWithTechnician");
        } else if (e.getSubCode().equals(AllocateException.ITEM_ALLOC_NOTSET.getCode()) || e.getSubCode().equals(AllocateException.ITEM_AUXALLOC_NOTSET.getCode())) {
            possibleReason = AllocUtils.getAllocResource(this._ctx, "possible_reason_allocStd_notSet");
            adviceHandle = AllocUtils.getAllocResource(this._ctx, "advice_handle_allocStd_toSet");
        } else if (e.getSubCode().equals(AllocateException.ITEM_ALLOC_NODEFAULT_COSTITEM_MAT.getCode())) {
            possibleReason = AllocUtils.getAllocResource(this._ctx, "possible_reason_NoDefault_CostItem_Mat");
            adviceHandle = AllocUtils.getAllocResource(this._ctx, "advice_handle_NoDefault_CostItem_Mat");
        } else if (e.getSubCode().equals(AllocateException.ITEM_ALLOC_NODEFAULT_COSTITEM_OTHER.getCode())) {
            possibleReason = AllocUtils.getAllocResource(this._ctx, "possible_reason_NoDefault_CostItem_Other");
            adviceHandle = AllocUtils.getAllocResource(this._ctx, "advice_handle_NoDefault_CostItem_Other");
        } else if (e.getSubCode().equals(AllocateException.ITEM_ALLOC_NO_INPUT_WIP.getCode())) {
            possibleReason = AllocUtils.getAllocResource(this._ctx, "possible_reason_No_Input_WIP");
            adviceHandle = AllocUtils.getAllocResource(this._ctx, "advice_handle_No_Input_WIP");
        } else if (e.getSubCode().equals(AllocateException.ITEM_ALLOC_INVALID_COSTOBJ.getCode())) {
            possibleReason = AllocUtils.getAllocResource(this._ctx, "possible_reason_Invalid_CostObj");
            adviceHandle = AllocUtils.getAllocResource(this._ctx, "advice_handle_Invalid_CostObj");
        } else if (e.getSubCode().equals(AllocateException.ITEM_ALLOC_INVALID_DYNCOSTOBJ.getCode())) {
            possibleReason = AllocUtils.getAllocResource(this._ctx, "possible_reason_Invalid_DynCostObj");
            adviceHandle = AllocUtils.getAllocResource(this._ctx, "advice_handle_Invalid_DynCostObj");
        } else if (e.getSubCode().equals(AllocateException.ITEM_ALLOC_NO_INPUT_AUS.getCode())) {
            possibleReason = AllocUtils.getAllocResource(this._ctx, "possible_reason_No_Input_Aus");
            adviceHandle = AllocUtils.getAllocResource(this._ctx, "advice_handle_No_Input_Aus");
        } else if (e.getSubCode().equals(AllocateException.ITEM_ALLOC_NO_INPUT_AUSOBJ.getCode())) {
            possibleReason = AllocUtils.getAllocResource(this._ctx, "possible_reason_No_Input_AusObj");
            adviceHandle = AllocUtils.getAllocResource(this._ctx, "advice_handle_No_Input_AusObj");
        } else if (e.getSubCode().equals(AllocateException.ITEM_ALLOC_INVALID_AUSCOSTOBJ.getCode())) {
            possibleReason = AllocUtils.getAllocResource(this._ctx, "possible_reason_Invalid_AusCostObj");
            adviceHandle = AllocUtils.getAllocResource(this._ctx, "advice_handle_Invalid_AusCostObj");
        } else if (e.getSubCode().equals(AllocateException.ITEM_ALLOC_INVALID_COSTOBJSUITE_AUX.getCode())) {
            possibleReason = AllocUtils.getAllocResource(this._ctx, "possible_reason_Invalid_CostObjSuite_aux");
            adviceHandle = AllocUtils.getAllocResource(this._ctx, "advice_handle_Invalid_CostObjSuite_aux");
        } else if (e.getSubCode().equals(AllocateException.ITEM_ALLOC_NO_INPUT_AUS_CC.getCode())) {
            possibleReason = AllocUtils.getAllocResource(this._ctx, "possible_reason_No_Input_Aus_cc");
            adviceHandle = AllocUtils.getAllocResource(this._ctx, "advice_handle_No_Input_Aus_cc");
        } else if (e.getSubCode().equals(AllocateException.ITEM_ALLOC_NO_INPUT_AUSOBJ_CC.getCode())) {
            possibleReason = AllocUtils.getAllocResource(this._ctx, "possible_reason_No_Input_AusObj_cc");
            adviceHandle = AllocUtils.getAllocResource(this._ctx, "advice_handle_No_Input_AusObj_cc");
        } else if (e.getSubCode().equals(AllocateException.ITEM_ALLOC_INVALID_COSTOBJSUITE.getCode())) {
            possibleReason = AllocUtils.getAllocResource(this._ctx, "possible_reason_Invalid_CostObjSuite");
            adviceHandle = AllocUtils.getAllocResource(this._ctx, "advice_handle_Invalid_CostObjSuite");
        } else if (e.getSubCode().equals(AllocateException.ITEM_ALLOC_INVALID_DYNCOSTOBJSUITE.getCode())) {
            possibleReason = AllocUtils.getAllocResource(this._ctx, "possible_reason_Invalid_DynCostObjSuite");
            adviceHandle = AllocUtils.getAllocResource(this._ctx, "advice_handle_Invalid_DynCostObj");
        } else if (e.getSubCode().equals(AllocateException.ITEM_ALLOC_INVALID_COSTOBJ_CC.getCode())) {
            possibleReason = AllocUtils.getAllocResource(this._ctx, "possible_reason_Invalid_CostObj_CC");
            adviceHandle = AllocUtils.getAllocResource(this._ctx, "advice_handle_Invalid_CostObj_CC");
        } else if (e.getSubCode().equals(AllocateException.ITEM_ALLOC_INVALID_COSTOBJ_DYNCC.getCode())) {
            possibleReason = AllocUtils.getAllocResource(this._ctx, "possible_reason_Invalid_DynCostObj");
            adviceHandle = AllocUtils.getAllocResource(this._ctx, "advice_handle_Invalid_DynCostObj");
        } else if (e.getSubCode().equals(AllocateException.ITEM_ALLOC_NO_INPUT_DYNWIP.getCode())) {
            possibleReason = AllocUtils.getAllocResource(this._ctx, "possible_reason_Invalid_DynCostObj");
            adviceHandle = AllocUtils.getAllocResource(this._ctx, "advice_handle_Invalid_DynCostObj");
        } else if (e.getSubCode().equals(AllocateException.ITEM_ALLOC_INVALID_COSTCENTERGROUP.getCode())) {
            possibleReason = AllocUtils.getAllocResource(this._ctx, "possible_reason_Invalid_CostCenterGroup");
            adviceHandle = AllocUtils.getAllocResource(this._ctx, "advice_handle_Invalid_CostObj");
        }
        this.AddLog(e, possibleReason, adviceHandle);
    }

    public void AddLog(AllocateException e, String possibleReason, String adviceHandle) {
        this.AddLog(e.getMessage(this._ctx.getLocale()), possibleReason, adviceHandle);
    }

    public void AddLog(String allocErrorInfo, String possibleReason, String adviceHandle) {
        try {
            ++this._logCount;
            String key = allocErrorInfo + possibleReason + adviceHandle;
            if (this.errors.contains(key)) {
                return;
            }
            this.errors.add(key);
            this._writeLog(allocErrorInfo, possibleReason, adviceHandle);
        }
        catch (BOSException e1) {
            logger.error((Object)"", (Throwable)e1);
        }
    }

    public IRowSet GetLogData() {
        try {
            return AllocateExceptionLog.GetLogData(this._ctx, this._companyId, this._periodId, this._logTblName);
        }
        catch (BOSException e1) {
            logger.error((Object)"", (Throwable)e1);
            return null;
        }
    }

    public static IRowSet GetLogData(Context ctx, String companyId, String periodId, String logTblName) throws BOSException {
        Assert.that((logTblName != null ? 1 : 0) != 0);
        Assert.that((logTblName.equals("T_NCM_LOG_Mat") || logTblName.equals("T_NCM_LOG_DynMat") || logTblName.equals("T_NCM_LOG_Other") || logTblName.equals("T_NCM_LOG_DynOther") || logTblName.equals("T_NCM_LOG_CCO") || logTblName.equals("T_NCM_LOG_OtherInWH") || logTblName.equals("T_NCM_LOG_CostAdjust") ? 1 : 0) != 0);
        Assert.that((companyId != null ? 1 : 0) != 0);
        Assert.that((periodId != null ? 1 : 0) != 0);
        String logPhysicalTblName = null;
        try {
            logPhysicalTblName = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)logTblName);
        }
        catch (Exception e1) {
            logger.error((Object)"", (Throwable)e1);
        }
        if (logPhysicalTblName == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT D.FCompanyId, D.FCalculatePeriodID, D.FErrorInfo,D.FPossibleReason,D.FAdviceHandle,D.FLogTime,").append("  C.FNumber As FCompanyNumber, C.FName_L2 As FCompanyName,P.FNumber As FPeriodNumber ").append("FROM ").append(logPhysicalTblName).append(" D ").append("LEFT OUTER JOIN T_ORG_Company C ON D.FCompanyID = C.FID ").append("LEFT OUTER JOIN T_BD_Period P ON D.FCalculatePeriodID = P.FID ").append("WHERE D.FCompanyID ='").append(companyId).append("' AND D.FCalculatePeriodID='").append(periodId).append("'");
        try {
            return NCMDbUtil.executeQuery((Context)ctx, (String)sb.toString());
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            return null;
        }
    }

    private void _writeLog(String allocErrorInfo, String possibleReason, String adviceHandle) throws BOSException {
        if (possibleReason == null) {
            possibleReason = "";
        } else if (possibleReason.length() > 500) {
            possibleReason = possibleReason.substring(0, 499);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO ").append(this._LogPhysicalTblName).append(" (FID,FCompanyID,FCalculatePeriodID,FErrorInfo,FPossibleReason,FAdviceHandle,FLogTime)").append("VALUES(newbosid('08F65F4A'),'").append(this._companyId).append("','").append(this._periodId).append("','").append(allocErrorInfo).append("','").append(possibleReason.replaceAll("\\'", "\\`")).append("','").append(adviceHandle).append("',GetDate()").append(")");
        NCMDbUtil.execute((Context)this._ctx, (String)sb.toString());
    }

    public int getLogCount() {
        return this._logCount;
    }
}

