/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CostObjectCollection;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.bill.AdjustAllocDataInfo;
import com.kingdee.eas.ncm.bill.AllocTypeEnum;
import com.kingdee.eas.ncm.bill.AllocateException;
import com.kingdee.eas.ncm.bill.MatAllocWizardSchemeEntryCollection;
import com.kingdee.eas.ncm.bill.MatAllocWizardSchemeEntryInfo;
import com.kingdee.eas.ncm.bill.OtherFeeBillCollection;
import com.kingdee.eas.ncm.bill.OtherFeeBillFactory;
import com.kingdee.eas.ncm.bill.OtherFeeBillInfo;
import com.kingdee.eas.ncm.bill.app.AbstractAllocatorFacadeControllerBean;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocDispatch;
import com.kingdee.eas.ncm.bill.app.Alloc.CCOAllocDispatch;
import com.kingdee.eas.ncm.bill.app.Alloc.CostAdjustAllocDispatch;
import com.kingdee.eas.ncm.bill.app.Alloc.MatAllocDispatch;
import com.kingdee.eas.ncm.bill.app.Alloc.OtherAllocDispatch;
import com.kingdee.eas.ncm.bill.app.Alloc.helper.AllocateExceptionLog;
import com.kingdee.eas.ncm.common.AllocSourceBillEnum;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.ncm.common.utils.app.NCMServerUtils;
import com.kingdee.eas.ncm.dynamic.bill.app.Alloc.DynAllocDispatch;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class AllocatorFacadeControllerBean
extends AbstractAllocatorFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ncm.bill.app.AllocatorFacadeControllerBean");
    private static final char CLF = '\n';
    private String shareCostObjectID = null;

    @Override
    protected Map _materialAllocate(Context ctx, Map param) throws BOSException, AllocateException {
        param.put("isMat", String.valueOf(true));
        param.put("ctx", ctx);
        CtrlUnitInfo DefaultCU = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        param.put("CU_ID", DefaultCU.getId().toString());
        if (param.get("isNormal") != null) {
            DynAllocDispatch DynDisp = new DynAllocDispatch(param);
            return DynDisp.DoAllocate();
        }
        MatAllocDispatch disp = new MatAllocDispatch(param);
        try {
            return disp.DoAllocate();
        }
        catch (AllocateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
        }
    }

    @Override
    protected Map _otherInWHAllocate(Context ctx, Map param) throws BOSException, AllocateException {
        param.put("isMat", String.valueOf(true));
        param.put("matType", "OtherInWarehs");
        param.put("ctx", ctx);
        CtrlUnitInfo DefaultCU = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        param.put("CU_ID", DefaultCU.getId().toString());
        if (param.get("isNormal") != null) {
            DynAllocDispatch DynDisp = new DynAllocDispatch(param);
            return DynDisp.DoAllocate();
        }
        AllocDispatch disp = new AllocDispatch(param);
        try {
            return disp.DoAllocate();
        }
        catch (AllocateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
        }
    }

    @Override
    protected Map _costAdjustAllocate(Context ctx, Map param) throws BOSException, AllocateException {
        param.put("isMat", String.valueOf(true));
        param.put("matType", "CostAdjust");
        param.put("ctx", ctx);
        CtrlUnitInfo DefaultCU = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        param.put("CU_ID", DefaultCU.getId().toString());
        if (param.get("isNormal") != null) {
            DynAllocDispatch DynDisp = new DynAllocDispatch(param);
            return DynDisp.DoAllocate();
        }
        CostAdjustAllocDispatch disp = new CostAdjustAllocDispatch(param);
        try {
            return ((AllocDispatch)disp).DoAllocate();
        }
        catch (AllocateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
        }
    }

    @Override
    protected Map _otherAllocate(Context ctx, Map param) throws BOSException, AllocateException {
        param.put("isMat", String.valueOf(false));
        param.put("ctx", ctx);
        CtrlUnitInfo DefaultCU = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        param.put("CU_ID", DefaultCU.getId().toString());
        if (param.get("isNormal") != null) {
            DynAllocDispatch DynDisp = new DynAllocDispatch(param);
            return DynDisp.DoAllocate();
        }
        OtherAllocDispatch disp = new OtherAllocDispatch(param);
        try {
            return disp.DoAllocate();
        }
        catch (AllocateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
        }
    }

    @Override
    protected Map _ccoAllocate(Context ctx, Map param) throws BOSException, AllocateException {
        param.put("isMat", String.valueOf(false));
        param.put("ctx", ctx);
        CtrlUnitInfo DefaultCU = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        param.put("CU_ID", DefaultCU.getId().toString());
        CCOAllocDispatch disp = new CCOAllocDispatch(param);
        try {
            return disp.DoAllocate();
        }
        catch (AllocateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
        }
    }

    @Override
    protected Map _auxFeeAlloc(Context ctx, Map param) throws BOSException, AllocateException {
        param.put("isMat", String.valueOf(false));
        param.put("ctx", ctx);
        CtrlUnitInfo DefaultCU = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        param.put("CU_ID", DefaultCU.getId().toString());
        AllocDispatch disp = new AllocDispatch(param);
        try {
            return disp.DoAllocate();
        }
        catch (AllocateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
        }
    }

    @Override
    protected Map _wizardAllocate(Context ctx, Map param, MatAllocWizardSchemeEntryCollection solutions) throws BOSException, AllocateException {
        String companyId = (String)param.get("companyId");
        String periodId = (String)param.get("periodId");
        String userId = (String)param.get("userId");
        AllocTypeEnum allocType = (AllocTypeEnum)((Object)param.get("allocType"));
        FilterInfo commonfilter = (FilterInfo)param.get("filterInfo");
        String billType = (String)param.get("billType");
        AllocSourceBillEnum allocSourceBill = (AllocSourceBillEnum)param.get("allocSourceBill");
        try {
            PeriodInfo periodInfo = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(periodId));
            int size = solutions.size();
            for (int i = 0; i < size; ++i) {
                EntityViewInfo customerEntityView;
                MatAllocWizardSchemeEntryInfo entry = solutions.get(i);
                HashMap<String, Object> _param = new HashMap<String, Object>();
                _param.put("companyId", companyId);
                _param.put("periodId", periodId);
                _param.put("userId", userId);
                _param.put("allocType", (Object)allocType);
                _param.put("allocSourceBill", allocSourceBill);
                _param.put("allocStdID", entry.getAllocStd());
                _param.put("costItemID", entry.getCostItem());
                _param.put("isOnlyUnAlloced", String.valueOf(entry.isIsOnlyUnAlloc()));
                if (param.get("isNormal") != null) {
                    _param.put("isNormal", param.get("isNormal"));
                }
                FilterInfo customerFilterInfo = new FilterInfo();
                QuerySolutionInfo solution = (QuerySolutionInfo)entry.get("QuerySolutionInfo");
                if (solution != null && solution.getEntityViewInfo() != null && solution.getEntityViewInfo() != null && (customerEntityView = new EntityViewInfo(solution.getEntityViewInfo())).getFilter() != null) {
                    customerFilterInfo = customerEntityView.getFilter();
                }
                FilterInfo filter = (FilterInfo)commonfilter.clone();
                for (int j = 0; j < customerFilterInfo.getFilterItems().size(); ++j) {
                    String propertyName = customerFilterInfo.getFilterItems().get(j).get("propertyName").toString();
                    if (propertyName.equals("year")) {
                        customerFilterInfo.getFilterItems().get(j).setCompareValue((Object)periodInfo.getPeriodYear());
                    }
                    if (!propertyName.equals("period")) continue;
                    customerFilterInfo.getFilterItems().get(j).setCompareValue((Object)periodInfo.getPeriodNumber());
                }
                filter.mergeFilter(customerFilterInfo, "and");
                _param.put("filterInfo", filter);
                Map allocResult = this.allocateByBillType(ctx, billType, _param);
                if (allocResult == null || !allocResult.containsKey("HasError") || !String.valueOf(true).equals(allocResult.get("HasError"))) continue;
                return allocResult;
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return new HashMap();
    }

    private Map allocateByBillType(Context ctx, String billType, Map _param) throws AllocateException, BOSException {
        if ("MF".equals(billType)) {
            return this._materialAllocate(ctx, _param);
        }
        return null;
    }

    @Override
    protected IRowSet _getLogData(Context ctx, String companyId, String periodId, String logTblName) throws BOSException {
        return AllocateExceptionLog.GetLogData(ctx, companyId, periodId, logTblName);
    }

    @Override
    protected IRowSet _getMatAdjustData(Context ctx, String companyId, String periodId, String sourceBillId, String sourceBillEntryID, boolean forAdjust) throws BOSException {
        String physicalTbl = "T_IM_MaterialReqBill";
        String physicalEntryTbl = "T_IM_MaterialReqBillEntry";
        String resultTbl = "T_NCM_MatAllocResult";
        String adjustTbl = "T_NCM_MatAllocResult_Adjust";
        if ("41852138".equals(BOSUuid.read((String)periodId).getType().toString())) {
            resultTbl = "T_NCM_DynMatAllocResult";
            adjustTbl = "T_NCM_DynMatAllocResult_Adjust";
        }
        StringBuffer sb = this.makeCommonMatAdjustData(ctx, companyId, periodId, sourceBillId, sourceBillEntryID, forAdjust, resultTbl, adjustTbl, physicalTbl, physicalEntryTbl);
        return DbUtil.executeQuery((Context)ctx, (String)sb.toString());
    }

    @Override
    protected IRowSet _getOtherInWHAdjustData(Context ctx, String companyId, String periodId, String sourceBillId, String sourceBillEntryID, boolean forAdjust) throws BOSException {
        String physicalTbl = "T_IM_OtherInWarehsBill";
        String physicalEntryTbl = "T_IM_OtherInWarehsBillEntry";
        String resultTbl = "T_NCM_MatAllocResult";
        String adjustTbl = "T_NCM_MatAllocResult_Adjust";
        if ("41852138".equals(BOSUuid.read((String)periodId).getType().toString())) {
            resultTbl = "T_NCM_DynMatAllocResult";
            adjustTbl = "T_NCM_DynMatAllocResult_Adjust";
        }
        StringBuffer sb = this.makeCommonMatAdjustData(ctx, companyId, periodId, sourceBillId, sourceBillEntryID, forAdjust, resultTbl, adjustTbl, physicalTbl, physicalEntryTbl);
        return DbUtil.executeQuery((Context)ctx, (String)sb.toString());
    }

    @Override
    protected IRowSet _getCostAdjustAdjustData(Context ctx, String companyId, String periodId, String sourceBillId, String sourceBillEntryID, boolean forAdjust) throws BOSException {
        String physicalTbl = "T_CL_CostAdjustBill";
        String physicalEntryTbl = "T_CL_CostAdjustBillEntry";
        String resultTbl = "T_NCM_MatAllocResult";
        String adjustTbl = "T_NCM_MatAllocResult_Adjust";
        if ("41852138".equals(BOSUuid.read((String)periodId).getType().toString())) {
            resultTbl = "T_NCM_DynMatAllocResult";
            adjustTbl = "T_NCM_DynMatAllocResult_Adjust";
        }
        StringBuffer sb = this.makeCommonMatAdjustData(ctx, companyId, periodId, sourceBillId, sourceBillEntryID, forAdjust, resultTbl, adjustTbl, physicalTbl, physicalEntryTbl);
        return DbUtil.executeQuery((Context)ctx, (String)sb.toString());
    }

    private StringBuffer makeCommonMatAdjustData(Context ctx, String companyId, String periodId, String sourceBillId, String sourceBillEntryID, boolean forAdjust, String resultTbl, String adjustTbl, String physicalTbl, String physicalEntryTbl) throws BOSException {
        Assert.that((companyId != null ? 1 : 0) != 0);
        Assert.that((periodId != null ? 1 : 0) != 0);
        Assert.that((sourceBillId != null ? 1 : 0) != 0);
        Assert.that((sourceBillEntryID != null ? 1 : 0) != 0);
        String logPhysicalTblName = null;
        String logPhysicalTblName_Adjust = null;
        StringBuffer sb = new StringBuffer();
        String loc = ctx.getLocale().getLanguage();
        try {
            logPhysicalTblName = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)resultTbl);
            if (forAdjust) {
                logPhysicalTblName_Adjust = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)adjustTbl);
            }
        }
        catch (Exception e1) {
            logger.error((Object)"", (Throwable)e1);
            throw new BOSException((Throwable)e1);
        }
        if (forAdjust) {
            sb.append("Delete from ").append(logPhysicalTblName_Adjust).append('\n').append("WHERE FSourceBillID='").append(sourceBillId).append("' AND FSourceBillEntryID='").append(sourceBillEntryID).append("';").append(";").append("Insert Into ").append(logPhysicalTblName_Adjust).append(" (").append("FID ,FCompanyID ,FCalculatePeriodID ,FCostCenterID ,FSourceBillID ,FSourceBillEntryID ,FCostObjectID ,FCostItemID ,FAllocStdID ,FAllocStdData ,FQty ,FCommonQty ,FAssistQty ,FBaseUnitID ,FCommonUnitID ,FAssistUnitID ,FPrice ,FAmount ,FMaterialID ,FLot ,FBizDate ,FSeq ,FCreatorID ,FCreateTime ,FAdjustUserID ,FAdjustTime ,FIsDirect, AllocBillType , FIsRework, FAdminOrgUnitID , FWarehouseID").append(") ").append('\n').append("Select ").append("FID ,FCompanyID ,FCalculatePeriodID ,FCostCenterID ,FSourceBillID ,FSourceBillEntryID ,FCostObjectID ,FCostItemID ,FAllocStdID ,FAllocStdData ,FQty ,FCommonQty ,FAssistQty ,FBaseUnitID ,FCommonUnitID ,FAssistUnitID ,FPrice ,FAmount ,FMaterialID ,FLot ,FBizDate ,FSeq ,FCreatorID ,FCreateTime ,FAdjustUserID ,FAdjustTime ,FIsDirect, AllocBillType , FIsRework, FAdminOrgUnitID , FWarehouseID").append(" from ").append(logPhysicalTblName).append('\n').append("WHERE FCompanyID='").append(companyId).append("' AND FCalculatePeriodID='").append(periodId).append("' ").append('\n').append("  AND FSourceBillID='").append(sourceBillId).append("' AND FSourceBillEntryID='").append(sourceBillEntryID).append("'");
            NCMServerUtils.BatchSqlExecute((Context)ctx, (String)sb.toString(), (String)";");
            sb.delete(0, sb.length());
        }
        sb.append("SELECT D.FID,D.FCostObjectID,O.FNumber As FCostObjectNumber, O.FName_" + loc + " As FCostObjectName,P.FModel As FProdModel,").append('\n').append("  D.FAllocStdData,D.FCommonQty,D.FQty,D.FAssistQty,D.FPrice,D.FAmount,").append('\n').append("  D.FCostItemID, I.FNumber As FCostItemNumber, I.FName_" + loc + " As FCostItemName,").append('\n').append("  D.FAllocStdID, S.FNumber As FAllocStdNumber, S.FName_" + loc + " As FAllocStdName, ").append('\n').append("  D.FCreatorID, CR.FNumber As FCreatorNumber, CR.FName_" + loc + " As FCreatorName,D.FCreateTime,").append('\n').append("  D.FAdjustUserID, AD.FNumber As AdjustUserNumber, AD.FName_" + loc + " As FAdjustUserName,D.FAdjustTime, ").append('\n').append("  BU.FQtyPrecision,CY.FPrecision As FAmountPrecision,MT.FPricePrecision, ").append('\n').append("  admin.Fname_" + loc + " as FAdminOrgUnitName, warehouse.Fname_" + loc + " as FWareHouseName ").append('\n');
        if (forAdjust) {
            sb.append("FROM ").append(logPhysicalTblName_Adjust).append(" D ").append('\n');
        } else {
            sb.append("FROM ").append(logPhysicalTblName).append(" D ").append('\n');
        }
        sb.append("LEFT OUTER JOIN T_NCM_AllocStd S ON D.FAllocStdID = S.FID ").append('\n').append("LEFT OUTER JOIN T_BD_CostObject O ON D.FCostObjectID = O.FID ").append('\n').append("LEFT OUTER JOIN T_NCM_CostItem I ON D.FCostItemID = I.FID ").append('\n').append("LEFT JOIN T_BD_Material P ON O.FStdProductIDID = P.FID ").append('\n').append("LEFT OUTER JOIN T_PM_User CR ON D.FCreatorID = CR.FID ").append('\n').append("LEFT JOIN T_PM_User AD ON D.FAdjustUserID = AD.FID ").append('\n').append("LEFT OUTER JOIN ").append(physicalEntryTbl).append(" ME ON ME.FID=D.FSourceBillEntryID ").append('\n').append("LEFT OUTER JOIN ").append(physicalTbl).append(" M ON M.FID = ME.FParentID ").append('\n').append("LEFT OUTER JOIN T_BD_MeasureUnit BU ON ME.FUnitID = BU.FID ").append('\n').append("LEFT OUTER JOIN T_ORG_Company COM ON ME.FCompanyOrgUnitID = COM.FID ").append('\n').append("LEFT OUTER JOIN T_BD_Currency CY ON COM.FBaseCurrencyID = CY.FID ").append('\n').append("LEFT OUTER JOIN T_BD_Material MT ON ME.FMaterialID = MT.FID ").append('\n').append("LEFT OUTER JOIN T_ORG_Admin admin ON admin.FID = M.FAdminOrgUnitID ").append('\n').append("LEFT OUTER JOIN T_DB_WAREHOUSE warehouse ON warehouse.FID = ME.FWarehouseID ").append('\n').append("").append('\n').append("WHERE D.FCompanyID ='").append(companyId).append("' AND D.FCalculatePeriodID='").append(periodId).append("'").append('\n').append("  AND D.FSourceBillID='").append(sourceBillId).append("' AND D.FSourceBillEntryID='").append(sourceBillEntryID).append("'").append('\n').append("Order by O.FNumber ");
        return sb;
    }

    @Override
    protected IRowSet _getOtherAdjustData(Context ctx, String companyId, String periodId, String sourceBillId, String sourceBillEntryID, boolean forAdjust) throws BOSException {
        String logPhysicalTblName = null;
        String logPhysicalTblName_Adjust = null;
        try {
            logPhysicalTblName = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_OtherAllocResult");
            if (forAdjust) {
                logPhysicalTblName_Adjust = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_OtherAllocResult_Adjust");
            }
            if ("41852138".equals(BOSUuid.read((String)periodId).getType().toString())) {
                logPhysicalTblName = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_DynOtherAllocResult");
                if (forAdjust) {
                    logPhysicalTblName_Adjust = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_OtherAllocResult_Adjust");
                }
            }
        }
        catch (Exception e1) {
            logger.error((Object)"", (Throwable)e1);
            throw new BOSException((Throwable)e1);
        }
        this.prepareAdjustTable(ctx, companyId, periodId, sourceBillId, sourceBillEntryID, forAdjust, logPhysicalTblName, logPhysicalTblName_Adjust);
        return this._getAdjustDataForOther(ctx, companyId, periodId, sourceBillId, sourceBillEntryID, forAdjust, logPhysicalTblName, logPhysicalTblName_Adjust);
    }

    protected IRowSet _getAdjustDataForOther(Context ctx, String companyId, String periodId, String sourceBillId, String sourceBillEntryID, boolean forAdjust, String logPhysicalTblName, String logPhysicalTblName_Adjust) throws BOSException {
        String loc = ctx.getLocale().getLanguage();
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT D.FID,D.FCostObjectID,O.FNumber As FCostObjectNumber, O.FName_" + loc + " As FCostObjectName,P.FModel As FProdModel,").append('\n').append("  D.FdepartmentID,dp.Fnumber as Fdepartmentnumber,dp.Fname_" + loc + " as Fdepartmentname,").append('\n').append("  D.FSourceCostCenterID,CC.Fnumber as FSourceCostCenterNumber,CC.Fname_" + loc + " as FSourceCostCenterName,").append('\n').append("  D.FAllocStdData,D.FQty, D.FPrice, D.FAmount,").append('\n').append("  D.FCostItemID, I.FNumber As FCostItemNumber, I.FName_" + loc + " As FCostItemName,").append('\n').append("  D.FAllocStdID, S.FNumber As FAllocStdNumber, S.FName_" + loc + " As FAllocStdName, ").append('\n').append("  D.FCreatorID, CR.FNumber As FCreatorNumber, CR.FName_" + loc + " As FCreatorName,D.FCreateTime,").append('\n').append("  D.FAdjustUserID, AD.FNumber As AdjustUserNumber, AD.FName_" + loc + " As FAdjustUserName,D.FAdjustTime,CY.FPrecision As FAmountPrecision,Isnull(UNT.FQtyPrecision,8)As FQtyPrecision, Isnull(EXP.FPricePrecision,8)As FPricePrecision ").append('\n');
        if (forAdjust) {
            sb.append("FROM ").append(logPhysicalTblName_Adjust).append(" D ").append('\n');
        } else {
            sb.append("FROM ").append(logPhysicalTblName).append(" D ").append('\n');
        }
        sb.append("LEFT OUTER JOIN T_NCM_AllocStd S ON D.FAllocStdID = S.FID ").append('\n').append("LEFT OUTER JOIN T_BD_CostObject O ON D.FCostObjectID = O.FID ").append('\n').append("LEFT OUTER JOIN T_NCM_CostItem I ON D.FCostItemID = I.FID ").append('\n').append("LEFT JOIN T_BD_Material P ON O.FStdProductIDID = P.FID ").append('\n').append("LEFT OUTER JOIN T_PM_User CR ON D.FCreatorID = CR.FID ").append('\n').append("LEFT JOIN T_PM_User AD ON D.FAdjustUserID = AD.FID ").append('\n').append("LEFT OUTER JOIN T_ORG_Company COM ON D.FCompanyID = COM.FID ").append('\n').append("LEFT OUTER JOIN T_BD_Currency CY ON COM.FBaseCurrencyID = CY.FID ").append('\n').append("LEFT OUTER JOIN T_NCM_OtherFeeBillEntry BILLEntry ON BILLEntry.FID=D.FSourceBillEntryID ").append('\n').append("LEFT OUTER JOIN T_NCM_Expense EXP ON BILLEntry.FExpenseID = EXP.FID ").append('\n').append("LEFT OUTER JOIN T_BD_MeasureUnit UNT ON EXP.FUnitID = UNT.FID ").append('\n').append("LEFT OUTER JOIN T_ORG_BaseUnit dp ON D.FDepartmentID = dp.FID ").append('\n').append("LEFT OUTER JOIN T_ORG_COSTCENTER CC ON CC.FID = D.FSourceCostCenterID").append("").append('\n').append("WHERE D.FCompanyID ='").append(companyId).append("' AND D.FCalculatePeriodID='").append(periodId).append("'").append('\n').append("  AND D.FSourceBillID='").append(sourceBillId).append("' AND D.FSourceBillEntryID='").append(sourceBillEntryID).append("'").append('\n').append("Order by O.FNumber ");
        try {
            return DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private void prepareAdjustTable(Context ctx, String companyId, String periodId, String sourceBillId, String sourceBillEntryID, boolean forAdjust, String logPhysicalTblName, String logPhysicalTblName_Adjust) throws BOSException {
        Assert.that((companyId != null ? 1 : 0) != 0);
        Assert.that((periodId != null ? 1 : 0) != 0);
        Assert.that((sourceBillId != null ? 1 : 0) != 0);
        Assert.that((sourceBillEntryID != null ? 1 : 0) != 0);
        StringBuffer sb = new StringBuffer();
        if (forAdjust) {
            sb.append("Delete from ").append(logPhysicalTblName_Adjust).append('\n').append("WHERE FSourceBillID='").append(sourceBillId).append("' AND FSourceBillEntryID='").append(sourceBillEntryID).append("';").append(";").append("Insert Into ").append(logPhysicalTblName_Adjust).append(" (FID ,FCompanyID ,FCalculatePeriodID ,FCostCenterID ,FDepartmentID , FSourceCostCenterID,FSourceBillID ,FSourceBillEntryID ,FCostObjectID ,FCostItemID ,FAllocStdID ,FAllocStdData ,FQty ,FPrice ,FAmount ,FCreatorID ,FCreateTime ,FAdjustUserID ,FAdjustTime ,FIsDirect ) ").append('\n').append("Select FID ,FCompanyID ,FCalculatePeriodID ,FCostCenterID ,FDepartmentID , FSourceCostCenterID,FSourceBillID ,FSourceBillEntryID ,FCostObjectID ,FCostItemID ,FAllocStdID ,FAllocStdData ,FQty ,FPrice ,FAmount ,FCreatorID ,FCreateTime ,FAdjustUserID ,FAdjustTime ,FIsDirect  from ").append(logPhysicalTblName).append('\n').append("WHERE FCompanyID='").append(companyId).append("' AND FCalculatePeriodID='").append(periodId).append("' ").append('\n').append("  AND FSourceBillID='").append(sourceBillId).append("' AND FSourceBillEntryID='").append(sourceBillEntryID).append("'");
            NCMServerUtils.BatchSqlExecute((Context)ctx, (String)sb.toString(), (String)";");
            sb.delete(0, sb.length());
        }
    }

    @Override
    protected void _updateMatAdjustData(Context ctx, Map param) throws BOSException {
        String periodId = (String)param.get("periodID");
        String resultTbl = "T_NCM_MatAllocResult";
        String adjustTbl = "T_NCM_MatAllocResult_Adjust";
        if ("41852138".equals(BOSUuid.read((String)periodId).getType().toString())) {
            resultTbl = "T_NCM_DynMatAllocResult";
            adjustTbl = "T_NCM_DynMatAllocResult_Adjust";
        }
        this.updateCommonMatData(ctx, param, resultTbl, adjustTbl);
    }

    @Override
    protected void _updateOtherInWHAdjustData(Context ctx, Map param) throws BOSException {
        String periodId = (String)param.get("periodID");
        String resultTbl = "T_NCM_MatAllocResult";
        String adjustTbl = "T_NCM_MatAllocResult_Adjust";
        if ("41852138".equals(BOSUuid.read((String)periodId).getType().toString())) {
            resultTbl = "T_NCM_DynMatAllocResult";
            adjustTbl = "T_NCM_DynMatAllocResult_Adjust";
        }
        this.updateCommonMatData(ctx, param, resultTbl, adjustTbl);
    }

    private void updateCommonMatData(Context ctx, Map param, String resultTbl, String adjustTbl) throws BOSException {
        Assert.that((boolean)param.containsKey("Info"));
        Assert.that((boolean)param.containsKey("companyID"));
        Assert.that((boolean)param.containsKey("sourceBillId"));
        Assert.that((boolean)param.containsKey("sourceBillEntryId"));
        Assert.that((boolean)param.containsKey("userId"));
        Assert.that((boolean)param.containsKey("allocStdID"));
        String companyID = (String)param.get("companyID");
        String periodId = (String)param.get("periodID");
        String sourceBillID = (String)param.get("sourceBillId");
        String sourceBillEntryId = (String)param.get("sourceBillEntryId");
        String userId = (String)param.get("userId");
        String allocStdID = (String)param.get("allocStdID");
        AdjustAllocDataInfo[] info = (AdjustAllocDataInfo[])param.get("Info");
        String tblMatAllocResult = null;
        String tblMatAllocResult_Adjust = null;
        try {
            tblMatAllocResult = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyID, (String)resultTbl);
            tblMatAllocResult_Adjust = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyID, (String)adjustTbl);
        }
        catch (EASBizException e2) {
            logger.error((Object)"", (Throwable)e2);
            throw new BOSException((Throwable)e2);
        }
        catch (SQLException e2) {
            logger.error((Object)"", (Throwable)e2);
            throw new BOSException((Throwable)e2);
        }
        StringBuffer sb = new StringBuffer();
        if (info == null) {
            sb.append("Delete from ").append(tblMatAllocResult_Adjust).append('\n').append("WHERE FSourceBillID='").append(sourceBillID).append("' AND FSourceBillEntryID='").append(sourceBillEntryId).append("';");
            NCMServerUtils.BatchSqlExecute((Context)ctx, (String)sb.toString(), (String)";");
        } else {
            if (info.length <= 0) {
                return;
            }
            sb.append("UPDATE ").append(tblMatAllocResult_Adjust).append(" SET ").append(" FCostItemID =?, FAllocStdData = ?, FQty = ?, FCommonQty= ? , FAssistQty = ? , FPrice = ?, FAmount = ?, FAdjustUserID = ?, FAdjustTime = GetDate(),FAllocStdID=? WHERE FID = ? ");
            Connection conn = null;
            PreparedStatement pstmt = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                if (conn == null) {
                    return;
                }
                pstmt = conn.prepareStatement(sb.toString());
                AdjustAllocDataInfo item = null;
                for (int i = 0; i < info.length; ++i) {
                    item = info[i];
                    pstmt.setString(1, item.get_CostItem());
                    pstmt.setBigDecimal(2, item.get_AllocStdData());
                    pstmt.setBigDecimal(3, item.get_Qty());
                    pstmt.setBigDecimal(4, item.get_CommonQty());
                    pstmt.setBigDecimal(5, item.get_AssistQty());
                    pstmt.setBigDecimal(6, item.get_Price());
                    pstmt.setBigDecimal(7, item.get_Amount());
                    pstmt.setString(8, userId);
                    pstmt.setString(9, allocStdID);
                    pstmt.setString(10, item.get_ID());
                    pstmt.addBatch();
                }
                pstmt.executeBatch();
                pstmt.close();
                SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            finally {
                SQLUtils.cleanup(pstmt, (Connection)conn);
            }
        }
        sb.delete(0, sb.length());
        sb.append("Delete from ").append(tblMatAllocResult).append('\n').append("WHERE FSourceBillID='").append(sourceBillID).append("' AND FSourceBillEntryID='").append(sourceBillEntryId).append("';").append("Insert Into ").append(tblMatAllocResult).append('\n').append(" (").append("FID ,FCompanyID ,FCalculatePeriodID ,FCostCenterID ,FSourceBillID ,FSourceBillEntryID ,FCostObjectID ,FCostItemID ,FAllocStdID ,FAllocStdData ,FQty ,FCommonQty ,FAssistQty ,FBaseUnitID ,FCommonUnitID ,FAssistUnitID ,FPrice ,FAmount ,FMaterialID ,FLot ,FBizDate ,FSeq ,FCreatorID ,FCreateTime ,FAdjustUserID ,FAdjustTime ,FIsDirect, AllocBillType , FIsRework, FAdminOrgUnitID , FWarehouseID").append(") ").append('\n').append("Select ").append("FID ,FCompanyID ,FCalculatePeriodID ,FCostCenterID ,FSourceBillID ,FSourceBillEntryID ,FCostObjectID ,FCostItemID ,FAllocStdID ,FAllocStdData ,FQty ,FCommonQty ,FAssistQty ,FBaseUnitID ,FCommonUnitID ,FAssistUnitID ,FPrice ,FAmount ,FMaterialID ,FLot ,FBizDate ,FSeq ,FCreatorID ,FCreateTime ,FAdjustUserID ,FAdjustTime ,FIsDirect, AllocBillType , FIsRework, FAdminOrgUnitID , FWarehouseID").append(" from ").append(tblMatAllocResult_Adjust).append('\n').append("WHERE FCompanyID='").append(companyID).append("' AND FCalculatePeriodID='").append(periodId).append("' ").append('\n').append("\tAND FSourceBillID='").append(sourceBillID).append("' AND FSourceBillEntryID='").append(sourceBillEntryId).append("'");
        sb.append(";\n");
        sb.append("update T_IM_MaterialReqBillEntry set FIsAdmeasure = \n");
        sb.append("( \n");
        sb.append("\tselect case when count(*) > 0 then 1 else 0 end from " + tblMatAllocResult + " \n");
        sb.append("\twhere FSourceBillEntryID = '" + sourceBillEntryId + "'");
        sb.append(") \n");
        sb.append("where FID = '" + sourceBillEntryId + "' \n");
        NCMServerUtils.BatchSqlExecute((Context)ctx, (String)sb.toString(), (String)";");
    }

    @Override
    protected void _updateOtherAdjustData(Context ctx, Map param) throws BOSException {
        Assert.that((boolean)param.containsKey("Info"));
        Assert.that((boolean)param.containsKey("companyID"));
        Assert.that((boolean)param.containsKey("sourceBillId"));
        Assert.that((boolean)param.containsKey("sourceBillEntryId"));
        Assert.that((boolean)param.containsKey("userId"));
        Assert.that((boolean)param.containsKey("allocStdID"));
        String companyID = (String)param.get("companyID");
        String periodId = (String)param.get("periodID");
        String sourceBillID = (String)param.get("sourceBillId");
        String sourceBillEntryId = (String)param.get("sourceBillEntryId");
        String userId = (String)param.get("userId");
        String allocStdID = (String)param.get("allocStdID");
        AdjustAllocDataInfo[] info = (AdjustAllocDataInfo[])param.get("Info");
        String tblMatAllocResult = null;
        String tblMatAllocResult_Adjust = null;
        try {
            tblMatAllocResult = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyID, (String)"T_NCM_OtherAllocResult");
            tblMatAllocResult_Adjust = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyID, (String)"T_NCM_OtherAllocResult_Adjust");
            if ("41852138".equals(BOSUuid.read((String)periodId).getType().toString())) {
                tblMatAllocResult = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyID, (String)"T_NCM_DynOtherAllocResult");
                tblMatAllocResult_Adjust = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyID, (String)"T_NCM_OtherAllocResult_Adjust");
            }
        }
        catch (EASBizException e2) {
            logger.error((Object)"", (Throwable)e2);
            throw new BOSException((Throwable)e2);
        }
        catch (SQLException e2) {
            logger.error((Object)"", (Throwable)e2);
            throw new BOSException((Throwable)e2);
        }
        StringBuffer sb = new StringBuffer();
        if (info == null) {
            sb.append("Delete from ").append(tblMatAllocResult_Adjust).append('\n').append("WHERE FSourceBillID='").append(sourceBillID).append("' AND FSourceBillEntryID='").append(sourceBillEntryId).append("';");
            NCMServerUtils.BatchSqlExecute((Context)ctx, (String)sb.toString(), (String)";");
        } else {
            if (info.length <= 0) {
                return;
            }
            sb.append("UPDATE ").append(tblMatAllocResult_Adjust).append(" SET ").append(" FCostItemID =?, FAllocStdData = ?, FQty = ?, FPrice = ?, FAmount = ?, FAdjustUserID = ?, FAdjustTime = GetDate(),FAllocStdID=? WHERE FID = ? ");
            Connection conn = null;
            PreparedStatement pstmt = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                if (conn == null) {
                    return;
                }
                pstmt = conn.prepareStatement(sb.toString());
                AdjustAllocDataInfo item = null;
                for (int i = 0; i < info.length; ++i) {
                    item = info[i];
                    pstmt.setString(1, item.get_CostItem());
                    pstmt.setBigDecimal(2, item.get_AllocStdData());
                    pstmt.setBigDecimal(3, item.get_Qty());
                    pstmt.setBigDecimal(4, item.get_Price());
                    pstmt.setBigDecimal(5, item.get_Amount());
                    pstmt.setString(6, userId);
                    pstmt.setString(7, allocStdID);
                    pstmt.setString(8, item.get_ID());
                    pstmt.addBatch();
                }
                pstmt.executeBatch();
                pstmt.close();
                SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            finally {
                SQLUtils.cleanup(pstmt, (Connection)conn);
            }
        }
        sb.delete(0, sb.length());
        sb.append("Delete from ").append(tblMatAllocResult).append('\n').append("WHERE FSourceBillID='").append(sourceBillID).append("' AND FSourceBillEntryID='").append(sourceBillEntryId).append("';").append("Insert Into ").append(tblMatAllocResult).append('\n').append("Select * from ").append(tblMatAllocResult_Adjust).append('\n').append("WHERE FCompanyID='").append(companyID).append("' AND FCalculatePeriodID='").append(periodId).append("' ").append('\n').append("\tAND FSourceBillID='").append(sourceBillID).append("' AND FSourceBillEntryID='").append(sourceBillEntryId).append("'");
        NCMServerUtils.BatchSqlExecute((Context)ctx, (String)sb.toString(), (String)";");
    }

    @Override
    protected IRowSet _getCCOAdjustData(Context ctx, String companyId, String periodId, String sourceBillId, String sourceBillEntryID, boolean forAdjust) throws BOSException {
        Assert.that((companyId != null ? 1 : 0) != 0);
        Assert.that((periodId != null ? 1 : 0) != 0);
        Assert.that((sourceBillId != null ? 1 : 0) != 0);
        Assert.that((sourceBillEntryID != null ? 1 : 0) != 0);
        StringBuffer sb = new StringBuffer();
        String physicalTblData = null;
        try {
            sb.append("(select a.FID, a.FCompanyOrg as FCompanyID, a.FCalculatePeriod as FCalculatePeriodID,").append('\n').append("        b.FExpenseID as FExpenseID, a.FCostCenterID, a.FDepartmentID, a.FSourceCostCenterID, a.FSourceBillID as FSourceBillEntryID,").append('\n').append("        a.FCreatorID, a.FCreateTime, a.FLastUpdateUserID as FAdjustUserID, a.FLastUpdateTime as FAdjustTime,").append('\n').append("        b.FCostItemID, b.FAmount, b.FQty, b.FPrice, b.FAllocStdData,a.FAllocStdID,").append('\n').append("        c.FCostCenterGroupID, c.FID as FSourceBillID,a.FBizDate as FBizDate ").append('\n').append("   from T_NCM_OtherFeeBill a, T_NCM_OtherFeeBillEntry b, T_NCM_CCOFeeBill c, T_NCM_CCOFeeBillEntry d").append('\n').append("  where a.FID = b.FParentID and a.FSourceBillID = d.FID and d.FParentID = c.FID").append('\n').append("    and a.FSourceBillID = ''{0}'')");
            physicalTblData = MessageFormat.format(sb.toString(), sourceBillEntryID);
            sb.delete(0, sb.length());
            if (forAdjust) {
                String tblName_Adjust = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_CCOAllocResult_Adjust");
                sb.append("Delete from ").append(tblName_Adjust).append('\n').append("WHERE FSourceBillID='").append(sourceBillId).append("' AND FSourceBillEntryID='").append(sourceBillEntryID).append("';").append('\n').append("Insert Into ").append(tblName_Adjust).append("(FID, FCompanyID, FCalculatePeriodID, ").append("FExpenseID, FCostCenterID, FDepartmentID,FSourceCostCenterID, FSourceBillEntryID, ").append("FCreatorID, FCreateTime, FAdjustUserID, FAdjustTime, ").append("FCostItemID, FAmount, FQty, FPrice, FAllocStdData, FAllocStdID, ").append("FCostCenterGroupID, FSourceBillID, FBizDate )").append('\n').append("Select ").append("FID, FCompanyID, FCalculatePeriodID, ").append("FExpenseID, FCostCenterID, FDepartmentID,FSourceCostCenterID, FSourceBillEntryID, ").append("FCreatorID, FCreateTime, FAdjustUserID, FAdjustTime, ").append("FCostItemID, FAmount, FQty, FPrice, FAllocStdData, FAllocStdID, ").append("FCostCenterGroupID, FSourceBillID, FBizDate ").append("from ").append(physicalTblData).append(" tt ").append('\n').append("WHERE tt.FCompanyID='").append(companyId).append("' AND tt.FCalculatePeriodID='").append(periodId).append("' ").append('\n').append("  AND tt.FSourceBillID='").append(sourceBillId).append("' AND tt.FSourceBillEntryID='").append(sourceBillEntryID).append("'");
                NCMServerUtils.BatchSqlExecute((Context)ctx, (String)sb.toString(), (String)";");
                sb.delete(0, sb.length());
                physicalTblData = tblName_Adjust;
            }
        }
        catch (EASBizException e1) {
            logger.error((Object)"", (Throwable)e1);
            throw new BOSException((Throwable)e1);
        }
        catch (SQLException e2) {
            logger.error((Object)"", (Throwable)e2);
            throw new BOSException((Throwable)e2);
        }
        sb.append("SELECT D.FID,D.FCostCenterID,O.FNumber As FCostCenterNumber, O.FName_L2 As FCostCenterName,").append('\n').append("       D.FDepartmentID,dp.Fnumber as Fdepartmentnumber,dp.Fname_l2 as Fdepartmentname,").append('\n').append("       D.FSourceCostCenterID,sourCO.FNumber as FSourceCostCenterNumber,sourCO.FName_l2 as FSourceCostCenterName,").append("       D.FAllocStdData,D.FQty, D.FPrice, D.FAmount,").append('\n').append("       D.FCostItemID, I.FNumber As FCostItemNumber, I.FName_L2 As FCostItemName,").append('\n').append("       D.FAllocStdID, S.FNumber As FAllocStdNumber, S.FName_L2 As FAllocStdName, ").append('\n').append("       D.FCreatorID, CR.FNumber As FCreatorNumber, CR.FName_L2 As FCreatorName,D.FCreateTime,").append('\n').append("       D.FAdjustUserID, AD.FNumber As AdjustUserNumber, AD.FName_L2 As FAdjustUserName,D.FAdjustTime,CY.FPrecision As FAmountPrecision,Isnull(UNT.FQtyPrecision,8)As FQtyPrecision, Isnull(EXP.FPricePrecision,8)As FPricePrecision ").append('\n').append("FROM ").append(physicalTblData).append(" D ").append('\n').append("LEFT OUTER JOIN T_NCM_AllocStd S ON D.FAllocStdID = S.FID ").append('\n').append("LEFT OUTER JOIN T_ORG_CostCenter O ON D.FCostCenterID = O.FID ").append('\n').append("LEFT OUTER JOIN T_ORG_BaseUnit dp ON D.FDepartmentID = dp.FID ").append('\n').append("LEFT OUTER JOIN T_NCM_CostItem I ON D.FCostItemID = I.FID ").append('\n').append("LEFT OUTER JOIN T_PM_User CR ON D.FCreatorID = CR.FID ").append('\n').append("LEFT OUTER JOIN T_PM_User AD ON D.FAdjustUserID = AD.FID ").append('\n').append("LEFT OUTER JOIN T_ORG_Company COM ON D.FCompanyID = COM.FID ").append('\n').append("LEFT OUTER JOIN T_BD_Currency CY ON COM.FBaseCurrencyID = CY.FID ").append('\n').append("LEFT OUTER JOIN T_NCM_Expense EXP ON D.FExpenseID = EXP.FID ").append('\n').append("LEFT OUTER JOIN T_BD_MeasureUnit UNT ON EXP.FUnitID = UNT.FID ").append('\n').append("LEFT OUTER JOIN T_ORG_CostCenter sourCO ON D.FSourceCostCenterID = sourCO.FID ").append('\n').append("").append('\n').append("WHERE D.FCompanyID ='").append(companyId).append("' AND D.FCalculatePeriodID='").append(periodId).append("'").append('\n').append("  AND D.FSourceBillID='").append(sourceBillId).append("' AND D.FSourceBillEntryID='").append(sourceBillEntryID).append("'").append('\n').append("Order by O.FNumber ");
        try {
            return DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _updateCCOAdjustData(Context ctx, Map param) throws BOSException {
        String id;
        Assert.that((boolean)param.containsKey("Info"));
        Assert.that((boolean)param.containsKey("companyID"));
        Assert.that((boolean)param.containsKey("sourceBillId"));
        Assert.that((boolean)param.containsKey("sourceBillEntryId"));
        Assert.that((boolean)param.containsKey("userId"));
        Assert.that((boolean)param.containsKey("allocStdID"));
        String companyID = (String)param.get("companyID");
        String periodId = (String)param.get("periodID");
        String sourceBillID = (String)param.get("sourceBillId");
        String sourceBillEntryId = (String)param.get("sourceBillEntryId");
        String userId = (String)param.get("userId");
        String allocStdID = (String)param.get("allocStdID");
        AdjustAllocDataInfo[] info = (AdjustAllocDataInfo[])param.get("Info");
        String tblMatAllocResult_Adjust = null;
        try {
            tblMatAllocResult_Adjust = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyID, (String)"T_NCM_CCOAllocResult_Adjust");
        }
        catch (EASBizException e2) {
            logger.error((Object)"", (Throwable)e2);
            throw new BOSException((Throwable)e2);
        }
        catch (SQLException e2) {
            logger.error((Object)"", (Throwable)e2);
            throw new BOSException((Throwable)e2);
        }
        StringBuffer sb = new StringBuffer();
        if (info == null) {
            sb.append("Delete from ").append(tblMatAllocResult_Adjust).append('\n').append("WHERE FSourceBillID='").append(sourceBillID).append("' AND FSourceBillEntryID='").append(sourceBillEntryId).append("';");
            NCMServerUtils.BatchSqlExecute((Context)ctx, (String)sb.toString(), (String)";");
        } else {
            if (info.length <= 0) {
                return;
            }
            sb.append("UPDATE ").append(tblMatAllocResult_Adjust).append(" SET ").append(" FCostItemID =?, FAllocStdData = ?, FQty = ?, FPrice = ?, FAmount = ?, FAdjustUserID = ?, FAdjustTime = GetDate(),FAllocStdID=? WHERE FID = ? ");
            Connection conn = null;
            PreparedStatement pstmt = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                if (conn == null) {
                    return;
                }
                pstmt = conn.prepareStatement(sb.toString());
                AdjustAllocDataInfo item = null;
                for (int i = 0; i < info.length; ++i) {
                    item = info[i];
                    pstmt.setString(1, item.get_CostItem());
                    pstmt.setBigDecimal(2, item.get_AllocStdData());
                    pstmt.setBigDecimal(3, item.get_Qty());
                    pstmt.setBigDecimal(4, item.get_Price());
                    pstmt.setBigDecimal(5, item.get_Amount());
                    pstmt.setString(6, userId);
                    pstmt.setString(7, allocStdID);
                    pstmt.setString(8, item.get_ID());
                    pstmt.addBatch();
                }
                pstmt.executeBatch();
                pstmt.close();
                SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            finally {
                SQLUtils.cleanup(pstmt, (Connection)conn);
            }
        }
        String coField = "";
        String coFieldValue = "";
        if (this.isCostObjectOfBillRequired(ctx, companyID) && (id = this.getShareCostObjectID(ctx)) != null && id.length() > 0) {
            coField = ", FCostObjectID";
            coFieldValue = ", ''" + id + "''";
        }
        sb.delete(0, sb.length());
        sb.append("Delete from T_NCM_OtherFeeBillEntry").append('\n').append("WHERE exists(select 1 from T_NCM_OtherFeeBill a where a.FID = T_NCM_OtherFeeBillEntry.FParentID and a.FSourceBillID=''{0}'' and a.FFivouchered<>1 and a.FSourceBillID not in (select t.FID from T_NCM_OtherFeeBill j, T_NCM_CCOFeeBillEntry t where j.FSourceBillID=t.fid and j.FFivouchered=1));").append('\n').append("Delete from T_NCM_OtherFeeBill").append('\n').append("WHERE FSourceBillID=''{1}''  and FFivouchered<>1 and FSourceBillID not in (select t.FID from T_NCM_OtherFeeBill j, T_NCM_CCOFeeBillEntry t where j.FSourceBillID=t.fid and j.FFivouchered=1);").append('\n').append("Insert into T_NCM_OtherFeeBill(FID, FNumber, FCompanyOrg, FCalculatePeriod, ").append('\n').append(" FCostCenterID, FSourceBillID, FCreatorID, FCreateTime,").append('\n').append(" FDepartmentID,FSourceCostCenterID,").append('\n').append(" FLastUpdateUserID, FLastUpdateTime, FControlUnitID,").append('\n').append(" FBizDate,FHasEffected, FAuditorID,FAuditTime,FAllocStdID,").append('\n').append(" FBillStatus, FIsAuto, FFivouchered,FSourceFunction, FFetchSource)").append('\n').append(" select tt.FID, ''testAlloc'' as FNumber, tt.FCompanyID as FCompanyOrg, tt.FCalculatePeriodID as FCalculatePeriod, ").append('\n').append(" tt.FCostCenterID, tt.FSourceBillEntryID as FSourceBillID, tt.FCreatorID, tt.FCreateTime,").append('\n').append(" tt.FDepartmentID,tt.FSourceCostCenterID ,").append('\n').append(" tt.FAdjustUserID as FLastUpdateUserID, tt.FAdjustTime as FLastUpdateTime, FControlUnitID as FControlUnitID,").append('\n').append(" cc.FBizDate as FBizDate, 1 as FHasEffected, tt.FCreatorID as FAuditorID, tt.FCreateTime as FAuditTime,tt.FAllocStdID,").append('\n').append(" 4 as FBillStatus, 1 as FIsAuto, 0 as FFivouchered,''").append(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"238_CCOAllocator", (Locale)ctx.getLocale())).append("''''''||cc.FNumber||''''''").append(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"239_CCOAllocator", (Locale)ctx.getLocale())).append("''||TO_CHAR(ce.FSeq)||''").append(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"240_CCOAllocator", (Locale)ctx.getLocale())).append("'',3 as FFetchSource").append('\n').append(" from T_NCM_CCOFeeBill cc, T_NCM_CCOFeeBillEntry ce, {2} tt").append('\n').append(" where cc.FID = ce.FParentID and cc.FID = tt.FSourceBillID and ce.FID = tt.FSourceBillEntryID").append('\n').append("   and tt.FCompanyID=''{3}'' AND tt.FCalculatePeriodID=''{4}'' ").append('\n').append("   AND tt.FSourceBillID=''{5}'' AND tt.FSourceBillEntryID=''{6}'';").append('\n').append("Insert into T_NCM_OtherFeeBillEntry(FID, FSeq, FParentID, FCostItemID, FAmount, FQty, FPrice, FExpenseID, FAllocStdData" + coField + ")").append('\n').append("select newbosid(''2640287C'') as FID, 1 as FSeq, FID as FParentID, FCostItemID, FAmount, FQty, FPrice, FExpenseID, FAllocStdData" + coFieldValue).append('\n').append("  from {7} tt").append(" where tt.FCompanyID=''{8}'' AND tt.FCalculatePeriodID=''{9}'' ").append('\n').append("   AND tt.FSourceBillID=''{10}'' AND tt.FSourceBillEntryID=''{11}'';").append('\n').append("update T_NCM_CCOFeeBillEntry set FIsAlloced=1 ").append('\n').append("where exists(select 1 from T_NCM_CCOFeeBill cc, {12} tt").append('\n').append("              where cc.FID = T_NCM_CCOFeeBillEntry.FParentID and cc.FID = tt.FSourceBillID and T_NCM_CCOFeeBillEntry.FID = tt.FSourceBillEntryID ").append('\n').append("                and tt.FCompanyID=''{13}'' AND tt.FCalculatePeriodID=''{14}'' AND tt.FSourceBillID=''{15}'' ").append('\n').append("                AND tt.FSourceBillEntryID=''{16}'');");
        Object[] params = new Object[]{sourceBillEntryId, sourceBillEntryId, tblMatAllocResult_Adjust, companyID, periodId, sourceBillID, sourceBillEntryId, tblMatAllocResult_Adjust, companyID, periodId, sourceBillID, sourceBillEntryId, tblMatAllocResult_Adjust, companyID, periodId, sourceBillID, sourceBillEntryId};
        String sql = MessageFormat.format(sb.toString(), params);
        NCMServerUtils.BatchSqlExecute((Context)ctx, (String)sql, (String)";");
        StringBuffer sb2 = new StringBuffer();
        sb2.append("update t_ncm_otherfeebill set FDepartmentID = '' where FDepartmentID = 'null';");
        sb2.append("update t_ncm_otherfeebill set FSourceCostCenterID = '' where FSourceCostCenterID = 'null';");
        NCMServerUtils.BatchSqlExecute((Context)ctx, (String)sb2.toString());
        this.updateOtherFeeBillNumberAndSeq(ctx, (AdjustAllocDataInfo[])param.get("Info"), companyID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateOtherFeeBillNumberAndSeq(Context ctx, AdjustAllocDataInfo[] infos, String companyID) throws BOSException {
        if (infos == null) return;
        if (infos.length <= 0) {
            return;
        }
        Connection conn = null;
        StringBuffer sb = new StringBuffer();
        PreparedStatement pstmtUpdateBill = null;
        PreparedStatement pstmtUpdateEntry = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            Map codingRuleNumber = this.getDispNumber(ctx, companyID, infos);
            String ids = "";
            String id = null;
            sb.append("update T_NCM_OtherFeeBill set FNumber = ? where FID = ?");
            pstmtUpdateBill = conn.prepareStatement(sb.toString());
            sb.delete(0, sb.length());
            AdjustAllocDataInfo item = null;
            for (int i = 0; i < infos.length; ++i) {
                item = infos[i];
                id = item.get_ID();
                ids = ids + "'" + (i < infos.length - 1 ? id + "', " : id + "'");
                pstmtUpdateBill.setString(1, codingRuleNumber.get(id).toString());
                pstmtUpdateBill.setString(2, id);
                pstmtUpdateBill.addBatch();
            }
            pstmtUpdateBill.executeBatch();
            sb.append("select FParentID,FID from T_NCM_OtherFeeBillEntry where FParentID in (" + ids + ") order by FParentID,FID;");
            IRowSet _Data = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            sb.delete(0, sb.length());
            String sql = "update T_NCM_OtherFeeBillEntry set FSeq = ? where FID = ?";
            if (_Data != null && _Data.size() > 0) {
                String FParentID = null;
                String FID = null;
                HashMap billMap = new HashMap();
                _Data.first();
                while (_Data.getRow() > 0 && !_Data.isAfterLast()) {
                    FParentID = _Data.getString("FParentID");
                    FID = _Data.getString("FID");
                    if (billMap.containsKey(FParentID)) {
                        ((List)billMap.get(FParentID)).add(FID);
                    } else {
                        ArrayList<String> entryList = new ArrayList<String>();
                        entryList.add(FID);
                        billMap.put(FParentID, entryList);
                    }
                    _Data.next();
                }
                pstmtUpdateEntry = conn.prepareStatement("update T_NCM_OtherFeeBillEntry set FSeq = ? where FID = ?");
                sb.delete(0, sb.length());
                for (int i = 0; i < billMap.size(); ++i) {
                    List tempList = (List)billMap.get(FParentID);
                    for (int j = 0; j < tempList.size(); ++j) {
                        pstmtUpdateEntry.setBigDecimal(1, new BigDecimal(j + 1));
                        pstmtUpdateEntry.setString(2, (String)tempList.get(j));
                        pstmtUpdateEntry.addBatch();
                    }
                }
                pstmtUpdateEntry.executeBatch();
            }
            SQLUtils.cleanup((Statement)pstmtUpdateBill);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
            catch (AllocateException e2) {
                logger.error((Object)"", (Throwable)((Object)e2));
                return;
            }
        }
        SQLUtils.cleanup(pstmtUpdateEntry);
        SQLUtils.cleanup((Connection)conn);
        return;
        finally {
            SQLUtils.cleanup(pstmtUpdateBill);
            SQLUtils.cleanup(pstmtUpdateEntry);
            SQLUtils.cleanup((Connection)conn);
        }
    }

    private Map getDispNumber(Context ctx, String companyId, AdjustAllocDataInfo[] infos) throws AllocateException {
        block8: {
            if (infos != null && infos.length > 0) {
                try {
                    ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                    if (codingRuleManager.isExist((IObjectValue)new OtherFeeBillInfo(), companyId)) {
                        StringBuffer ids = new StringBuffer();
                        for (int i = 0; i < infos.length; ++i) {
                            ids.append("'");
                            ids.append(infos[i].get_ID());
                            ids.append("'");
                            if (i >= infos.length - 1) continue;
                            ids.append(",");
                        }
                        OtherFeeBillCollection coll = OtherFeeBillFactory.getLocalInstance(ctx).getOtherFeeBillCollection("select id,number,billStatus where id in(" + ids + ")");
                        if (coll != null && coll.size() > 0) {
                            HashMap<String, String> numbers = new HashMap<String, String>();
                            OtherFeeBillInfo info = null;
                            for (int i = 0; i < coll.size(); ++i) {
                                info = coll.get(i);
                                numbers.put(info.getId().toString(), codingRuleManager.getNumber((IObjectValue)info, companyId));
                            }
                            return numbers;
                        }
                        break block8;
                    }
                    throw new AllocateException(AllocateException.ITEM_ALLOC_NOCODINGRULE);
                }
                catch (BOSException e) {
                    logger.error((Object)"", (Throwable)e);
                    throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
                }
                catch (EASBizException e) {
                    logger.error((Object)"", (Throwable)e);
                    throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
                }
            }
        }
        return null;
    }

    @Override
    protected IRowSet _getAuxFeeAdjustData(Context ctx, String companyId, String periodId, String sourceBillId, String sourceBillEntryId, boolean isAdjust) throws BOSException {
        String logPhysicalTblName = null;
        String logPhysicalTblName_Adjust = null;
        try {
            logPhysicalTblName = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_AuxAllocResult");
            if (isAdjust) {
                logPhysicalTblName_Adjust = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_AuxAllocResult");
            }
        }
        catch (Exception e1) {
            logger.error((Object)"", (Throwable)e1);
            throw new BOSException((Throwable)e1);
        }
        this.prepareAdjustTable(ctx, companyId, periodId, sourceBillId, sourceBillEntryId, isAdjust, logPhysicalTblName, logPhysicalTblName_Adjust);
        return this._getAdjustDataForAux(ctx, companyId, periodId, sourceBillId, sourceBillEntryId, isAdjust, logPhysicalTblName, logPhysicalTblName_Adjust);
    }

    protected IRowSet _getAdjustDataForAux(Context ctx, String companyId, String periodId, String sourceBillId, String sourceBillEntryID, boolean forAdjust, String logPhysicalTblName, String logPhysicalTblName_Adjust) throws BOSException {
        String loc = ctx.getLocale().getLanguage();
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT D.FID,D.FCostObjectID,O.FNumber As FCostObjectNumber, O.FName_" + loc + " As FCostObjectName,P.FModel As FProdModel,").append('\n').append("  D.FAllocStdData,D.FTotalQty FQty,D.FPrice, D.FAmount ,").append('\n').append("  D.FCostItemID, I.FNumber As FCostItemNumber, I.FName_" + loc + " As FCostItemName,").append('\n').append("  D.FAllocStdID, S.FNumber As FAllocStdNumber, S.FName_" + loc + " As FAllocStdName, ").append('\n').append("  BILL.FCreatorID, CR.FNumber As FCreatorNumber, CR.FName_" + loc + " As FCreatorName,getDate() FCreateTime,").append('\n').append("  BILL.FLASTUPDATEUSERID, AD.FNumber As AdjustUserNumber, AD.FName_" + loc + " As FAdjustUserName,getDate() FAdjustTime,").append("  CY.FPrecision As FAmountPrecision,Isnull(Aux.FQtyPrecision,8)As FQtyPrecision, Isnull(Auxc.FPricePrecision,8)As FPricePrecision ").append('\n');
        if (forAdjust) {
            sb.append("FROM ").append(logPhysicalTblName_Adjust).append(" D ").append('\n');
        } else {
            sb.append("FROM ").append(logPhysicalTblName).append(" D ").append('\n');
        }
        sb.append("LEFT OUTER JOIN T_NCM_AllocStd S ON D.FAllocStdID = S.FID ").append('\n').append("LEFT OUTER JOIN T_BD_CostObject O ON D.FCostObjectID = O.FID ").append('\n').append("LEFT OUTER JOIN T_NCM_CostItem I ON D.FCostItemID = I.FID ").append('\n').append("LEFT JOIN T_BD_Material P ON O.FStdProductIDID = P.FID ").append('\n').append("LEFT OUTER JOIN T_NCM_InnerOverheadBill BILL ON BILL.FID=D.FSourceBillID ").append('\n').append("LEFT OUTER JOIN T_PM_User CR ON BILL.FCreatorID = CR.FID ").append('\n').append("LEFT JOIN T_PM_User AD ON BILL.FLASTUPDATEUSERID = AD.FID ").append('\n').append("LEFT OUTER JOIN T_ORG_Company COM ON D.FCompanyID = COM.FID ").append('\n').append("LEFT OUTER JOIN T_BD_Currency CY ON COM.FBaseCurrencyID = CY.FID ").append('\n').append(" INNER JOIN T_NCM_InnerOverheadBillEntry OBE ON OBE.FID = D.FSourceBillEntryID  ").append('\n').append(" INNER JOIN T_NCM_AUXOverhead Aux ON Aux.FID = OBE.FAuxOverheadID").append('\n').append(" INNER JOIN T_NCM_AUXOverheadCompanyInfo Auxc ON Auxc.FAUXOverheadID = OBE.FAuxOverheadID ").append('\n').append("\t\t  AND Auxc.FCompanyID = D.FCompanyID   ").append('\n').append(" INNER JOIN T_NCM_Expense EXP ON Auxc.FDefaultExpenseID = EXP.FID ").append('\n').append("LEFT OUTER JOIN T_BD_MeasureUnit UNT ON Aux.FUnitID = UNT.FID ").append('\n').append("").append('\n').append("WHERE D.FCompanyID ='").append(companyId).append("' AND D.FCalculatePeriodID='").append(periodId).append("'").append('\n').append("  AND D.FSourceBillID='").append(sourceBillId).append("' AND D.FSourceBillEntryID='").append(sourceBillEntryID).append("'").append('\n').append("Order by O.FNumber ");
        try {
            return DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        }
        catch (BOSException e) {
            logger.fatal((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected boolean _isIncludeCostAdjustData(Context ctx, String companyId) throws BOSException, AllocateException {
        boolean paramSignNotIncludeData = this.paramSignNotIncludeData(ctx, companyId);
        if (paramSignNotIncludeData) {
            this.deleteCostAdjustAllocResult(ctx, companyId);
        }
        return !paramSignNotIncludeData;
    }

    private boolean paramSignNotIncludeData(Context ctx, String companyId) throws BOSException {
        try {
            String value = ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)new ObjectUuidPK(companyId), "CM005");
            if (value != null && Boolean.valueOf(value).booleanValue()) {
                return false;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return true;
    }

    private void deleteCostAdjustAllocResult(Context ctx, String companyId) throws BOSException {
        try {
            String logPhysicalTblName = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_MatAllocResult");
            String whereClause = " where AllocBillType='CA'";
            NCMDynamicTableManager.DeleteTable((Context)ctx, (String)logPhysicalTblName, (String)whereClause);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    private boolean isCostObjectOfBillRequired(Context ctx, String companyID) throws BOSException {
        try {
            return NCMUtils.isCostObjectOfBillRequired((Context)ctx, (String)companyID);
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private String getShareCostObjectID(Context ctx) throws BOSException {
        if (this.shareCostObjectID == null) {
            this.shareCostObjectID = "";
            String companyID = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)"SCOID", CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyID, CompareType.EQUALS));
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(filter);
            CostObjectCollection coll = CostObjectFactory.getLocalInstance((Context)ctx).getCostObjectCollection(view);
            if (coll.size() > 0) {
                this.shareCostObjectID = coll.get(0).getId().toString();
            }
        }
        return this.shareCostObjectID;
    }

    @Override
    protected boolean _isCalculated(Context ctx, String companyId, String periodId) throws BOSException, EASBizException {
        try {
            String t_CostCalResult = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_CostCalResult");
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT 1 FROM ").append(t_CostCalResult).append(" WHERE FCompanyID ='").append(companyId).append("'").append(" AND FCalculatePeriodID='").append(periodId).append("'").append('\n');
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            return rs.next();
        }
        catch (SQLException ex) {
            throw new SQLDataException(ex);
        }
    }
}

