/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CostItemEnum;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.mm.basedata.BOMExtendFacadeFactory;
import com.kingdee.eas.ncm.bill.BoPInvSFPCostEntryInfo;
import com.kingdee.eas.ncm.bill.BoPInvSFPCostInfo;
import com.kingdee.eas.ncm.bill.NcmBillException;
import com.kingdee.eas.ncm.bill.app.AbstractBoPInvSFPCostControllerBean;
import com.kingdee.eas.ncm.bill.app.BoPInvSFPCostGenParam;
import com.kingdee.eas.ncm.common.BillBaseStatusEnum;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.common.RecoveryModelEnum;
import com.kingdee.eas.ncm.common.utils.NCMConst;
import com.kingdee.eas.ncm.common.utils.app.NCMDbBatchUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BoPInvSFPCostControllerBean
extends AbstractBoPInvSFPCostControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ncm.bill.app.BoPInvSFPCostControllerBean");
    protected String _ExtendResultTableName = null;

    public String getMainTableName(Context ctx, IObjectPK[] model) throws EASBizException, BOSException {
        return "T_NCM_BoPInvSFPCost";
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._checkIsDup(ctx, model);
        return super._submit(ctx, model);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        BoPInvSFPCostInfo info = (BoPInvSFPCostInfo)model;
        for (int i = 0; i < info.getEntrys().size(); ++i) {
            if (info.getEntrys().get(i).getCostItem() != null) {
                if (info.getEntrys().get(i).getCostItem().getItemType().equals((Object)CostItemEnum.STUFF) || info.getEntrys().get(i).getId() == null) continue;
                DbUtil.execute((Context)ctx, (String)"delete T_NCM_BoPInvSFPCostMatDetail  where FParentID=?", (Object[])new Object[]{info.getEntrys().get(i).getId().toString()});
                continue;
            }
            if (info.getEntrys().get(i).getId() == null) continue;
            DbUtil.execute((Context)ctx, (String)"delete T_NCM_BoPInvSFPCostMatDetail  where FParentID=?", (Object[])new Object[]{info.getEntrys().get(i).getId().toString()});
        }
        super._update(ctx, pk, model);
    }

    protected void _checkIsDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (this._checkDup(ctx, model)) {
            throw new NcmBillException(NcmBillException.INVSFPCOST_DUPLICATION);
        }
    }

    private boolean _checkDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BoPInvSFPCostInfo Info = (BoPInvSFPCostInfo)model;
        HashSet<Integer> billStatus = new HashSet<Integer>();
        billStatus.add(3);
        billStatus.add(4);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("companyOrg.id", (Object)Info.getCompanyOrg().getId().toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("product.id", (Object)Info.getProduct().getId().toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("lot", (Object)Info.getLot(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("billStatus", billStatus, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("calculatePeriod.id", (Object)Info.getCalculatePeriod().getId().toString(), CompareType.EQUALS));
        if (Info.getId() != null) {
            FilterItemInfo filterItem2 = new FilterItemInfo("id", (Object)Info.getId(), CompareType.NOTEQUALS);
            filterInfo.getFilterItems().add(filterItem2);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filterInfo);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        return this.exists(ctx, filterInfo);
    }

    protected Map bizCheckForSubmit(Context ctx, List ids, Map param) throws BOSException, EASBizException {
        final HashMap<String, List<String>> report = new HashMap<String, List<String>>();
        if (ids == null || ids.isEmpty()) {
            return report;
        }
        ArrayList<Object[]> idsParam = new ArrayList<Object[]>();
        int size = ids.size();
        for (int i = 0; i < size; ++i) {
            idsParam.add(new Object[]{ids.get(i)});
        }
        String productIsNull = "\u672a\u5f55\u5165\u4ea7\u54c1";
        String costObjectIsNull = "\u672a\u5f55\u5165\u6210\u672c\u5bf9\u8c61";
        String bizDateIsNull = "\u672a\u5f55\u5165\u4e1a\u52a1\u65e5\u671f";
        String qtyIsNull = "\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0";
        String amountIsNull = "\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0";
        StringBuffer kSql = new StringBuffer();
        kSql.append(" select FID,FProductID,FCostObjectID,FBizDate,FQty,FAmount \n").append(" from T_NCM_BoPInvSFPCost \n").append(" where FID in (");
        for (int i = 0; i < 200; ++i) {
            if (i == 199) {
                kSql.append(" ? ");
                continue;
            }
            kSql.append(" ?, ");
        }
        kSql.append("    )").append(" and (FProductID is null or FCostObjectID is null or FBizDate is null or FQty is null or FQty <= 0 or FAmount is null or FAmount <= 0)\n");
        NCMDbBatchUtil.batchExecuteQuery((Context)ctx, (String)kSql.toString(), idsParam, (NCMDbBatchUtil.QueryCallbackHandler)new NCMDbBatchUtil.QueryCallbackHandler(){

            public int beforeBatchBindParams(PreparedStatement ps) throws SQLException {
                return 0;
            }

            public void processRow(ResultSet rs) throws SQLException {
                String id = rs.getString("FID");
                String productID = rs.getString("FProductID");
                String costObjectID = rs.getString("FCostObjectID");
                Date date = rs.getDate("FBizDate");
                BigDecimal qty = rs.getBigDecimal("FQty");
                BigDecimal amount = rs.getBigDecimal("FAmount");
                List detail = null;
                detail = report.containsKey(id) ? (List)report.get(id) : new ArrayList();
                if (productID == null || productID.length() == 0) {
                    detail.add("\u672a\u5f55\u5165\u4ea7\u54c1");
                }
                if (costObjectID == null || costObjectID.length() == 0) {
                    detail.add("\u672a\u5f55\u5165\u6210\u672c\u5bf9\u8c61");
                }
                if (date == null) {
                    detail.add("\u672a\u5f55\u5165\u4e1a\u52a1\u65e5\u671f");
                }
                if (qty == null || qty.compareTo(SysConstant.BIGZERO) <= 0) {
                    detail.add("\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0");
                }
                if (amount == null || amount.compareTo(SysConstant.BIGZERO) <= 0) {
                    detail.add("\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
                }
                report.put(id, detail);
            }
        });
        String noEntry = "\u5355\u636e\u6ca1\u6709\u5206\u5f55";
        kSql.setLength(0);
        kSql.append(" select FID \n");
        kSql.append("  from T_NCM_BoPInvSFPCost \n");
        kSql.append("  where FID in (");
        for (int i = 0; i < 200; ++i) {
            if (i == 199) {
                kSql.append(" ? ");
                continue;
            }
            kSql.append(" ?, ");
        }
        kSql.append("    )");
        kSql.append("    and FNumber is not null \n");
        kSql.append("    and FID not in (select FParentID from T_NCM_BoPInvSFPCostEntry) \n");
        NCMDbBatchUtil.batchExecuteQuery((Context)ctx, (String)kSql.toString(), idsParam, (NCMDbBatchUtil.QueryCallbackHandler)new NCMDbBatchUtil.QueryCallbackHandler(){

            public int beforeBatchBindParams(PreparedStatement ps) throws SQLException {
                return 0;
            }

            public void processRow(ResultSet rs) throws SQLException {
                String id = rs.getString("FID");
                List<String> detail = null;
                detail = report.containsKey(id) ? (List)report.get(id) : new ArrayList<String>();
                detail.add("\u5355\u636e\u6ca1\u6709\u5206\u5f55");
                report.put(id, detail);
            }
        });
        String noCostItemInEntry = "\u5206\u5f55\u672a\u5f55\u5165\u6210\u672c\u9879\u76ee";
        String errorAmountInEntry = "\u5206\u5f55\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0";
        kSql.setLength(0);
        kSql.append(" select FParentID,FCostItemID,FAmount \n");
        kSql.append("  from T_NCM_BoPInvSFPCostEntry  \n");
        kSql.append("  where FParentID in (");
        for (int i = 0; i < 200; ++i) {
            if (i == 199) {
                kSql.append(" ? ");
                continue;
            }
            kSql.append(" ?, ");
        }
        kSql.append("    )");
        kSql.append("    and (FCostItemID is null or FAmount is null or FAmount <= 0) \n");
        NCMDbBatchUtil.batchExecuteQuery((Context)ctx, (String)kSql.toString(), idsParam, (NCMDbBatchUtil.QueryCallbackHandler)new NCMDbBatchUtil.QueryCallbackHandler(){

            public int beforeBatchBindParams(PreparedStatement ps) throws SQLException {
                return 0;
            }

            public void processRow(ResultSet rs) throws SQLException {
                String id = rs.getString("FParentID");
                String costItemID = rs.getString("FCostItemID");
                BigDecimal amount = rs.getBigDecimal("FAmount");
                List detail = null;
                detail = report.containsKey(id) ? (List)report.get(id) : new ArrayList();
                if (costItemID == null || costItemID.length() == 0) {
                    detail.add("\u5206\u5f55\u672a\u5f55\u5165\u6210\u672c\u9879\u76ee");
                }
                if (amount == null || amount.compareTo(SysConstant.BIGZERO) <= 0) {
                    detail.add("\u5206\u5f55\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
                }
                report.put(id, detail);
            }
        });
        String entryAmtNotEqualsProductAmt = "\u6210\u672c\u9879\u76ee\u91d1\u989d\u4e4b\u548c\u4e0d\u7b49\u4e8e\u4ea7\u54c1\u91d1\u989d";
        kSql.setLength(0);
        kSql.append(" select a.FID,a.FAmount as ptAmount,sum(b.FAmount) as ciAmount \n");
        kSql.append("  from T_NCM_BoPInvSFPCost a left join T_NCM_BoPInvSFPCostEntry b on a.FID=b.FParentID \n");
        kSql.append("  where a.FID in (");
        for (int i = 0; i < 200; ++i) {
            if (i == 199) {
                kSql.append(" ? ");
                continue;
            }
            kSql.append(" ?, ");
        }
        kSql.append("    ) group by a.FID,a.FAmount having sum(b.FAmount)<>a.FAmount ");
        NCMDbBatchUtil.batchExecuteQuery((Context)ctx, (String)kSql.toString(), idsParam, (NCMDbBatchUtil.QueryCallbackHandler)new NCMDbBatchUtil.QueryCallbackHandler(){

            public int beforeBatchBindParams(PreparedStatement ps) throws SQLException {
                return 0;
            }

            public void processRow(ResultSet rs) throws SQLException {
                String id = rs.getString("FID");
                BigDecimal ptAmount = rs.getBigDecimal("ptAmount");
                BigDecimal ciAmount = rs.getBigDecimal("ciAmount");
                List detail = null;
                detail = report.containsKey(id) ? (List)report.get(id) : new ArrayList();
                if (ptAmount.compareTo(ciAmount) != 0) {
                    detail.add("\u6210\u672c\u9879\u76ee\u91d1\u989d\u4e4b\u548c\u4e0d\u7b49\u4e8e\u4ea7\u54c1\u91d1\u989d");
                }
                report.put(id, detail);
            }
        });
        String checkCompanyAndProduct = "\u5e93\u5b58\u534a\u4ea7\u54c1\u6210\u672c\u7ed3\u6784\u8d22\u52a1\u7ec4\u7ec7\u548c\u4ea7\u54c1\u5fc5\u987b\u552f\u4e00";
        HashSet<String> submitedProductIDs = new HashSet<String>();
        List detail = null;
        int size2 = ids.size();
        for (int i = 0; i < size2; ++i) {
            String id = ids.get(i).toString();
            BoPInvSFPCostInfo info = this.getBoPInvSFPCostInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
            try {
                this._checkIsDup(ctx, (IObjectValue)info);
            }
            catch (NcmBillException e) {
                detail = report.containsKey(id) ? (List)report.get(id) : new ArrayList();
                if (e.getSubCode().equals(NcmBillException.INVSFPCOST_DUPLICATION.getCode())) {
                    detail.add("\u5e93\u5b58\u534a\u4ea7\u54c1\u6210\u672c\u7ed3\u6784\u8d22\u52a1\u7ec4\u7ec7\u548c\u4ea7\u54c1\u5fc5\u987b\u552f\u4e00");
                    report.put(id, detail);
                }
                throw e;
            }
            if (info.getProduct() != null && info.getProduct().getId() != null && submitedProductIDs.contains(info.getProduct().getId().toString() + info.getLot())) {
                if (report.containsKey(id)) continue;
                detail = report.containsKey(id) ? (List)report.get(id) : new ArrayList();
                detail.add("\u5e93\u5b58\u534a\u4ea7\u54c1\u6210\u672c\u7ed3\u6784\u8d22\u52a1\u7ec4\u7ec7\u548c\u4ea7\u54c1\u5fc5\u987b\u552f\u4e00");
                report.put(id, detail);
                continue;
            }
            if (info.getProduct() == null || info.getProduct().getId() == null) continue;
            submitedProductIDs.add(info.getProduct().getId().toString() + info.getLot());
        }
        return report;
    }

    @Override
    protected Map _generateData(Context ctx, Map param) throws BOSException, EASBizException {
        param.put("ctx", ctx);
        BoPInvSFPCostGenParam helper = new BoPInvSFPCostGenParam(param);
        try {
            Map map = this.doGenerateData(helper);
            return map;
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (BOSException e) {
            throw e;
        }
        finally {
            if (helper != null) {
                helper.ReleaseResource();
            }
        }
    }

    protected Map doGenerateData(BoPInvSFPCostGenParam paramHelper) throws BOSException, EASBizException {
        int totalRec = 0;
        boolean isNeedRefresh = false;
        String totalInfo = paramHelper.getLocaleStr("BoPInvSFPCost_Generate_RecordTotal");
        if (!paramHelper.isExistCodingRuleOfBoPInvSFPCost()) {
            throw new CMBillException(CMBillException.NOCORDRULE, new Object[]{paramHelper.getLocaleStr("BoPInvSFPCost_Generate_BillName")});
        }
        HashMap<String, String> genResultInfo = new HashMap<String, String>();
        genResultInfo.put("isNeedRefresh", String.valueOf(false));
        try {
            this.prepareData(paramHelper);
            if (paramHelper.canGenFromEstimateScheme) {
                this.prepareDataFromEstimateScheme(paramHelper);
            } else {
                this.prepareDataFromBom(paramHelper);
            }
            IRowSet headAndEntryData = this.getBillHeadAndEntryData(paramHelper);
            if (headAndEntryData == null || headAndEntryData.size() <= 0) {
                isNeedRefresh = false;
                genResultInfo.put("totalInfo", MessageFormat.format(totalInfo, String.valueOf(totalRec)));
                genResultInfo.put("isNeedRefresh", String.valueOf(isNeedRefresh));
                return genResultInfo;
            }
            BoPInvSFPCostInfo billInfo = new BoPInvSFPCostInfo();
            String lastCostObjectID = "";
            while (headAndEntryData.next()) {
                if (lastCostObjectID != null && !lastCostObjectID.equals(headAndEntryData.getString("FCostObjectID"))) {
                    if (lastCostObjectID.length() > 0) {
                        this._addnew(paramHelper.ctx, (IObjectValue)billInfo);
                    }
                    billInfo = new BoPInvSFPCostInfo();
                    lastCostObjectID = headAndEntryData.getString("FCostObjectID");
                }
                billInfo.setCalculatePeriod(paramHelper.periodInfo);
                billInfo.setBizDate(paramHelper.periodInfo.getEndDate());
                CompanyOrgUnitInfo companyInfo = new CompanyOrgUnitInfo();
                companyInfo.setId(BOSUuid.read((String)paramHelper.companyId));
                billInfo.setCompanyOrg(companyInfo);
                billInfo.setBillStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
                String sCostObjectID = headAndEntryData.getString("FCostObjectID");
                CostObjectInfo co = new CostObjectInfo();
                if (sCostObjectID != null && sCostObjectID.length() > 0) {
                    co.setId(BOSUuid.read((String)sCostObjectID));
                }
                billInfo.setCostObject(co);
                String sProductID = headAndEntryData.getString("FProductID");
                MaterialInfo mat = new MaterialInfo();
                if (sProductID != null && sProductID.length() > 0) {
                    mat.setId(BOSUuid.read((String)sProductID));
                }
                billInfo.setProduct(mat);
                if (" ".equals(headAndEntryData.getString("FProdBatchNo"))) {
                    billInfo.setLot(null);
                } else {
                    billInfo.setLot(headAndEntryData.getString("FProdBatchNo"));
                }
                billInfo.setIsAuto(true);
                billInfo.setAmount(headAndEntryData.getBigDecimal("FAmount"));
                billInfo.setQty(headAndEntryData.getBigDecimal("FQty"));
                BOSUuid id = BOSUuid.create((BOSObjectType)billInfo.getBOSType());
                billInfo.setId(id);
                BoPInvSFPCostEntryInfo billEntryInfo = new BoPInvSFPCostEntryInfo();
                String sCostItemID = headAndEntryData.getString("FCostItemID");
                CostItemInfo ci = new CostItemInfo();
                if (sCostItemID != null && sCostItemID.length() > 0) {
                    ci.setId(BOSUuid.read((String)sCostItemID));
                }
                billEntryInfo.setCostItem(ci);
                if (!"1".equals(headAndEntryData.getString("FItemType")) && "1".equals(headAndEntryData.getString("FIsAllocateQty"))) {
                    billEntryInfo.setQty(headAndEntryData.getBigDecimal("FCostItemQty"));
                    billEntryInfo.setPrice(headAndEntryData.getBigDecimal("FCostItemPrice"));
                }
                if (paramHelper.canGenFromEstimateScheme) {
                    billEntryInfo.setAmount(headAndEntryData.getBigDecimal("FCostItemAmount"));
                } else {
                    billEntryInfo.setAmount(NCMConst.ZERO);
                }
                billInfo.getEntrys().add(billEntryInfo);
            }
            if (billInfo != null) {
                this._addnew(paramHelper.ctx, (IObjectValue)billInfo);
            }
            this.FillBoPInvSFPCostMatDetail(paramHelper);
            if (paramHelper.canGenFromEstimateScheme) {
                this.adjustDiffCostItemAmount(paramHelper);
                this.adjustDiffMatDetail(paramHelper);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        isNeedRefresh = true;
        genResultInfo.put("isNeedRefresh", String.valueOf(isNeedRefresh));
        return genResultInfo;
    }

    protected void FillBoPInvSFPCostMatDetail(BoPInvSFPCostGenParam paramHelper) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        if (paramHelper.canGenFromEstimateScheme) {
            sb.append("INSERT INTO T_NCM_BoPInvSFPCostMatDetail (FID,FParentID,FMaterialID,FQty,FPrice,FAmount)").append('\n').append("select newbosID('1572714E'),data.FParentID,data.FMaterialID,sum(data.FQty),case when sum(data.FQty) <>0 then sum(data.Famount)/sum(data.FQty) else 0 end,sum(data.FAmount) from (").append('\n').append("select D.FParentID,D.FMaterialID,D.FQty*D.billFQty as FQty, ").append('\n').append("case when FQty*D.billFQty <> 0 then round(D.FAmount*D.FMaterialRadio,2)/(FQty*D.billFQty) else 0 end as FPrice,round(D.FAmount*D.FMaterialRadio,2) as FAmount ").append("From (").append('\n').append("  Select entry.fid as FParentID, data.FMaterialID,data.FQty,bill.FQty as billFQty,data.FPrice,entry.FAmount,data.FMaterialRadio ").append('\n').append("  From T_NCM_BoPInvSFPCost bill ").append('\n').append("  Inner join T_NCM_BoPInvSFPCostEntry entry on entry.FParentID = bill.FID ").append('\n').append("  inner join T_NCM_CostItem ci on ci.FID = entry.FCostItemID and ci.FItemType = 1").append('\n').append("  inner join T_BD_CostObject co on co.FID = bill.FCostObjectID ").append('\n').append("  Inner Join (").append('\n').append(" \t\tSelect FProductID,FCostItemID,FMaterialID,Sum(FQty)As FQty,Round(Sum(FAmount),2)As FAmount,Round(Round(Sum(FAmount),2)/Sum(FQty),Max(Mat.FPricePrecision))As FPrice,R.FMaterialRadio as FMaterialRadio").append('\n').append(" \t\tFrom ").append(this._ExtendResultTableName).append(" R ").append('\n').append("\t\tLEFT JOIN T_BD_Material Mat ON Mat.FID=R.FMaterialID ").append('\n').append("\t\tWhere FMaterialID is not null ").append('\n').append("\t\tGroup by FProductID,FCostItemID,FMaterialID,FMaterialRadio ").append('\n').append("\t\tHaving Sum(FQty) <> 0").append('\n').append("  )data ON data.FProductID=co.FStdProductIDID AND data.FCostItemID=entry.FCostItemID").append('\n').append(") D").append(" ) data ").append("group by data.FParentID,data.FMaterialID ;");
        } else {
            sb.append("INSERT INTO T_NCM_BoPInvSFPCostMatDetail (FID,FParentID,FMaterialID)").append('\n').append("select newbosID('1572714E'),D.FParentID,D.FMaterialID").append('\n').append("From (").append('\n').append("  Select distinct entry.fid as FParentID, data.FMaterialID as FMaterialID ").append('\n').append("  From T_NCM_BoPInvSFPCost bill ").append('\n').append("  Inner join T_NCM_BoPInvSFPCostEntry entry on entry.FParentID = bill.FID ").append('\n').append("  inner join T_BD_CostObject co on co.FID = bill.FCostObjectID ").append('\n').append("  inner join ").append(this._ExtendResultTableName).append(" data on co.FStdProductIDID = data.FTraceId ").append('\n').append("  Inner join ( ").append('\n').append("  \t\tSelect FMaterialID,IsNull(FDefaultCostItemID,(").append('\n').append("  \t\t\tSelect Top 1 FID ").append('\n').append("  \t\t\tFrom T_NCM_CostItem ").append('\n').append("  \t\t\tWhere FItemType=1 And (FControlUnitID = '" + paramHelper.CU + "' or fid in (select FDataBaseDID FROM T_BD_DataBaseDAssign where FBOSObjectType = '548C5A91' AND FAssignCUID = '" + paramHelper.CU + "')) ").append('\n').append("  \t\t\tOrder by FNumber ").append('\n').append(" \t\t))As FCostItemID ").append('\n').append("  \t\tFrom T_BD_MaterialCost").append('\n').append(" \t)mcst on mcst.FMaterialID = data.FMaterialID and mcst.FCostItemID=entry.FCostItemID ").append('\n');
            if (paramHelper.recoveryModel == RecoveryModelEnum.ByEnd) {
                sb.append(" Inner join T_BD_MaterialCompanyInfo matCom on data.FMaterialID = matCom.FMaterialID and matCom.FCompanyID = '" + paramHelper.companyId + "' and matCom.FCalculateType <> 2 ").append('\n');
            }
            sb.append(") D; ");
        }
        NCMDbUtil.BatchSqlExecute((Context)paramHelper.ctx, (String)sb.toString(), (String)";");
        sb.delete(0, sb.length());
    }

    private void prepareData(BoPInvSFPCostGenParam paramHelper) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO ").append(paramHelper.GetTBL_ValidSFPData()).append(" (FCostObjectID,FProductID,FProdBatchNo,FQty,FAmount) ").append('\n').append("SELECT M.FCostObjectID,M.FProductID,M.FProdBatchNo,SUM(M.FQty),SUM(M.FAmount) ").append('\n').append("FROM (").append('\n').append("\tSELECT O.FCostObjectID,bal.FMaterialID as FProductID, ISNULL(O.FProdBatchNo,N'')As FProdBatchNo,SUM(bal.FPeriodBeginQty)As FQty,SUM(bal.FPeriodBeginBalance) As FAmount ").append('\n').append("\tFROM T_IM_InventoryBalance bal ").append('\n').append("\tINNER JOIN T_BD_MaterialCompanyInfo mat ON mat.FCompanyID=bal.FCompanyOrgUnitID AND mat.FMaterialID = bal.FMaterialID AND mat.FStatus=1 AND mat.FCalculateType=2 ").append('\n');
        if (!paramHelper.isRevertAllProduct) {
            sb.append("\tINNER JOIN T_BD_MaterialCost mcst ON mcst.FMaterialID = bal.FMaterialID AND mcst.FStatus=1 AND mcst.FIsParticipateReduct=1 ").append('\n');
        }
        sb.append("\tINNER JOIN (").append('\n').append("\t\tSELECT distinct CO.FID As FCostObjectID,COE.FRelatedID As FProductId,Isnull(CO.FBatchNumber,N' ') As FProdBatchNo ").append('\n').append("\t\tFROM T_BD_CostObject CO ").append('\n').append("\t\tLEFT JOIN T_BD_COstObjectEntry COE on COE.FParentId = CO.Fid ").append('\n').append("\t\tWHERE CO.FCalculateMode<>7 AND CO.FIsForbiden = 0 AND CO.FCompanyID = '").append(paramHelper.companyId).append("' ").append('\n').append("\t)O ON O.FProductId=bal.FMaterialID and O.FProdBatchNo = isnull(bal.FLot,N' ')").append('\n').append("\tWHERE bal.FYear=").append(paramHelper.periodInfo.getPeriodYear()).append(" AND bal.FPeriod=").append(paramHelper.periodInfo.getPeriodNumber()).append('\n').append("\t\tAND bal.FCompanyOrgUnitID='").append(paramHelper.companyId).append("' ").append('\n').append("\tGROUP BY O.FCostObjectID, bal.FMaterialID, O.FProdBatchNo ").append('\n').append("\tHAVING SUM(bal.FPeriodBeginQty) <>0 ").append('\n').append("\tUNION ALL ").append('\n').append("\tSELECT O.FCostObjectID,balMatDetail.FMaterialID as FProductID, ISNULL(O.FProdBatchNo,N' ')As FProdBatchNo, SUM(balMatDetail.FQty) As FQty, SUM(balMatDetail.FAmount)As FAmount ").append('\n').append("\tFROM ").append(paramHelper.GetTBL_BalanceMatDetail()).append(" balMatDetail ").append('\n').append("\tINNER JOIN ").append(paramHelper.GetTBL_BalanceEntry()).append(" balMat ON balMat.FID=balMatDetail.FParentID ").append('\n').append("\tINNER JOIN ").append(paramHelper.GetTBL_Balance()).append(" bal ON bal.FID=balMat.FParentID ").append('\n').append("\tINNER JOIN T_BD_MaterialCompanyInfo mat ON mat.FCompanyID=bal.FCompanyOrg AND mat.FMaterialID = balMatDetail.FMaterialID AND mat.FStatus=1 AND mat.FCalculateType=2 ").append('\n').append("\tINNER JOIN (").append('\n').append("\t\tSELECT distinct CO.FID As FCostObjectID,COE.FRelatedID As FProductId,Isnull(CO.FBatchNumber,N' ') As FProdBatchNo ").append('\n').append("\t\tFROM T_BD_CostObject CO ").append('\n').append("\t\tLEFT JOIN T_BD_COstObjectEntry COE on COE.FParentId = CO.Fid ").append('\n').append("\t\tWHERE CO.FCalculateMode<>7 AND CO.FIsForbiden = 0 AND CO.FCompanyID = '").append(paramHelper.companyId).append("' ").append('\n').append("\t)O ON O.FProductId=balMatDetail.FMaterialID and O.FProdBatchNo = isnull(balMatDetail.FBatchNo,N' ')").append('\n');
        if (!paramHelper.isRevertAllProduct) {
            sb.append("\tINNER JOIN T_BD_MaterialCost mcst ON mcst.FMaterialID = balMatDetail.FMaterialID AND mcst.FStatus=1 AND mcst.FIsParticipateReduct=1 ").append('\n');
        }
        sb.append("\tWHERE bal.FCompanyOrg='").append(paramHelper.companyId).append("' AND bal.FCalculatePeriodID='").append(paramHelper.periodInfo.getId().toString()).append("'").append('\n').append("\tGROUP BY O.FCostObjectID,balMatDetail.FMaterialID, balMatDetail.FBatchNo,O.FProdBatchNo ").append('\n').append("\tHAVING SUM(balMatDetail.FQty) <>0 ").append('\n').append(")M ").append('\n').append("WHERE EXISTS( ");
        if (paramHelper.canGenFromEstimateScheme) {
            sb.append("\tSELECT 1 ").append('\n').append("\tFROM " + paramHelper.GetTBL_STDCostDataMatDetail() + " matDetail ").append('\n').append("\tWHERE matDetail.FEstimateSchemeID = '" + paramHelper.EstimateSchemeID + "' AND matDetail.FParentMaterialID=M.FProductID ");
        } else {
            sb.append("\tSELECT 1 ").append('\n').append("\tFROM T_MM_BOM bom ").append('\n').append("\tWHERE bom.FBaseStatus = 4 And bom.FBomType = 40 And bom.FMaterialID=M.FProductID AND FStorageOrgUnitID in (").append(paramHelper.getStorageOrgUnitIdsOfCompany()).append(") ");
        }
        sb.append(") ");
        sb.append("\tAND NOT EXISTS( ").append("\t\tSELECT 1 ").append('\n').append("\t\tFROM T_NCM_BoPInvSFPCost bill ").append('\n').append("\t\tWHERE bill.FCompanyOrg = '" + paramHelper.companyId + "' And bill.FCalculatePeriod = '" + paramHelper.periodInfo.getId().toString() + "' AND bill.FCostObjectID=M.FCostObjectID ").append('\n');
        if (paramHelper.isCoverExists) {
            sb.append("\t\tAND bill.FBillStatus = 4 ");
        }
        sb.append("\t) ").append("GROUP BY M.FCostObjectID,M.FProductID,M.FProdBatchNo ").append("HAVING SUM(M.FQty) <> 0 ").append('\n').append(";").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)paramHelper.ctx, (String)sb.toString(), (String)";");
        sb.delete(0, sb.length());
        if (paramHelper.isCoverExists) {
            sb.append("DELETE\tFROM T_NCM_BoPInvSFPCostEntry ").append('\n').append("WHERE EXISTS(  ").append('\n').append("\t\tSelect 1  ").append('\n').append("\t\tFrom ").append(paramHelper.GetTBL_ValidSFPData()).append(" S ").append('\n').append("\t\tInner join T_NCM_BoPInvSFPCost bill ON bill.FCostObjectID=S.FCostObjectID ").append('\n').append("\t\tWHERE T_NCM_BoPInvSFPCostEntry.FParentID=bill.FID AND bill.FBillStatus <> 4 AND bill.FCompanyOrg = '" + paramHelper.companyId + "' And bill.FCalculatePeriod = '" + paramHelper.periodInfo.getId().toString() + "' ").append('\n').append("\t); ").append('\n');
            sb.append("DELETE\tFROM T_NCM_BoPInvSFPCost ").append('\n').append("WHERE FBillStatus <> 4 AND FCompanyOrg = '" + paramHelper.companyId + "' And FCalculatePeriod = '" + paramHelper.periodInfo.getId().toString() + "' ").append('\n').append("\tAND EXISTS(  ").append('\n').append("\t\tSelect 1  ").append('\n').append("\t\tFrom ").append(paramHelper.GetTBL_ValidSFPData()).append(" S ").append('\n').append("\t\tWhere S.FCostObjectID=T_NCM_BoPInvSFPCost.FCostObjectID  ").append('\n').append("\t); ").append('\n');
            NCMDbUtil.BatchSqlExecute((Context)paramHelper.ctx, (String)sb.toString(), (String)";");
            sb.delete(0, sb.length());
        }
        sb.setLength(0);
        sb.append(" delete from ").append(paramHelper.GetTBL_ValidSFPData()).append('\n');
        sb.append(" where FCostObjectID in (select FCostObjectID from T_CAL_CostObjectRank bill \n");
        sb.append("                                              inner join T_CAL_CostObjectRankEntry entry on bill.FID = entry.FParentID \n");
        sb.append("                           where FCompanyOrg = '").append(paramHelper.companyId).append("' \n").append("                               and FCalculatePeriod = '").append(paramHelper.periodInfo.getId().toString()).append("' and bill.FLlcType=0 and FRank = 0); \n");
        NCMDbUtil.execute((Context)paramHelper.ctx, (String)sb.toString());
    }

    private void prepareDataFromEstimateScheme(BoPInvSFPCostGenParam paramHelper) throws BOSException, EASBizException {
        this._ExtendResultTableName = this.getExtendResultTableNameFromEstimateScheme(paramHelper);
        StringBuffer sb = new StringBuffer();
        sb.append(" update " + this._ExtendResultTableName + " as data1 set FCostItemRadio = ( \n");
        sb.append("    select sum(FAmount) from " + this._ExtendResultTableName + " data2 \n");
        sb.append("       where data1.FProductID = data2.FProductID and data2.FMaterialID is null \n");
        sb.append("      group by data2.FProductID ); \n");
        sb.append(" update " + this._ExtendResultTableName + " as data1 set FCostItemRadio = FAmount/FCostItemRadio; \n");
        NCMDbUtil.BatchSqlExecute((Context)paramHelper.ctx, (String)sb.toString(), (String)";");
        sb.setLength(0);
        sb.append(" update " + this._ExtendResultTableName + " as data1 set FMaterialRadio = ( \n");
        sb.append("    select sum(FAmount) from " + this._ExtendResultTableName + " data2 \n");
        sb.append("       inner join t_ncm_costItem ci on data2.FCostItemID = ci.fid and FItemType = 1 \n");
        sb.append("       where data1.FProductID = data2.FProductID and data1.FCostItemID = data2.FCostItemID and data2.FMaterialID is null \n");
        sb.append("      group by data2.FProductID,data2.FCostItemID ); \n");
        sb.append(" update " + this._ExtendResultTableName + " as data1 set FMaterialRadio = FAmount/FMaterialRadio; \n");
        NCMDbUtil.BatchSqlExecute((Context)paramHelper.ctx, (String)sb.toString(), (String)";");
    }

    private String getExtendResultTableNameFromEstimateScheme(BoPInvSFPCostGenParam paramHelper) throws EASBizException, BOSException {
        if (paramHelper.recoveryModel == RecoveryModelEnum.ByEnd) {
            this.Revert(paramHelper);
            return paramHelper.GetTBL_EstimateSchemeExtendResultData();
        }
        StringBuffer sb = new StringBuffer();
        sb.append(" INSERT INTO ").append(paramHelper.GetTBL_EstimateSchemeExtendResultData()).append('\n').append("\t(FProductID, FMaterialID,FCostItemID,FQty,FPrice,FAmount)").append('\n').append("\tSELECT distinct S.FParentMaterialID As FProductID,S.FMaterialID,S.FChildCostItemID As FCostItemID,S.FChildQty As FQty,S.FChildStdPrice As FPrice,S.FChildAmount As FAmount ").append('\n').append("\tFROM " + paramHelper.GetTBL_STDCostDataMatDetail() + " S ").append('\n').append("\tInner Join ").append(paramHelper.GetTBL_ValidSFPData()).append(" V ON V.FProductID= S.FParentMaterialID ").append('\n').append("\tWHERE S.FEstimateSchemeID = '" + paramHelper.EstimateSchemeID + "' ").append("\tUnion all ").append('\n').append(" \tSelect CI.FProductID,null As FMaterialID,CI.FCostItemID,Sum(FCostItemQty)As FQty,Round(Round(Sum(FCostItemAmount),2)/Sum(FCostItemQty),Max(Prd.FPricePrecision))As FPrice,Sum(FCostItemAmount)As FAmount").append('\n').append(" \tFrom (").append('\n').append(" \t\tSelect distinct FParentMaterialID As FProductID,FChildCostItemID As FCostItemID,FChildQty As FCostItemQty, FChildAmount As FCostItemAmount ").append('\n').append(" \t\tFrom ").append(paramHelper.GetTBL_STDCostDataMatDetail()).append(" M ").append('\n').append("\t\t\tWHERE M.FEstimateSchemeID = '" + paramHelper.EstimateSchemeID + "' ").append('\n').append(" \t\tUnion all").append('\n').append(" \t\tSelect FParentMaterialID As FProductID,FResCostItemID As FCostItemID,FResQty As FCostItemQty, FResAmount As FCostItemAmount ").append('\n').append(" \t\tFrom ").append(paramHelper.GetTBL_STDCostDataResDetail()).append(" R ").append('\n').append("\t\t\tWHERE R.FEstimateSchemeID = '" + paramHelper.EstimateSchemeID + "' ").append('\n').append(" \t) CI ").append('\n').append("\tInner Join (Select distinct FProductID from ").append(paramHelper.GetTBL_ValidSFPData()).append(") V ON V.FProductID= CI.FProductID ").append('\n').append("\tLEFT JOIN T_BD_Material Prd ON Prd.FID=CI.FProductID ").append('\n').append(" \tGROUP BY CI.FProductID,CI.FCostItemID ").append('\n').append(";").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)paramHelper.ctx, (String)sb.toString(), (String)";");
        sb.delete(0, sb.length());
        return paramHelper.GetTBL_EstimateSchemeExtendResultData();
    }

    private void prepareDataFromBom(BoPInvSFPCostGenParam paramHelper) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        sb.append(" INSERT INTO ").append(paramHelper.GetTBL_BOMExtendParam()).append('\n').append("\t(FStorageOrgUnitID,FBomID,FTraceID)").append('\n').append(" Select bom.FStorageOrgUnitID, bom.FID, bom.FMaterialID ").append('\n').append(" From T_MM_BOM bom ").append('\n').append(" Inner join ").append(paramHelper.GetTBL_ValidSFPData()).append(" S ON S.FProductID=bom.FMaterialID ").append('\n').append(" WHERE bom.FBaseStatus = 4 And bom.FBomType = 40 AND bom.FStorageOrgUnitID in (").append(paramHelper.getStorageOrgUnitIdsOfCompany()).append("); ");
        NCMDbUtil.BatchSqlExecute((Context)paramHelper.ctx, (String)sb.toString(), (String)";");
        sb.delete(0, sb.length());
        this._ExtendResultTableName = this.getExtendResultTableNameFromBom(paramHelper);
    }

    private String getExtendResultTableNameFromBom(BoPInvSFPCostGenParam paramHelper) throws EASBizException, BOSException {
        if (paramHelper.recoveryModel == RecoveryModelEnum.ByEnd) {
            return BOMExtendFacadeFactory.getLocalInstance((Context)paramHelper.ctx).getMfgBomExpandResult(paramHelper.GetTBL_BOMExtendParam());
        }
        StringBuffer sb = new StringBuffer();
        sb.append(" INSERT INTO ").append(paramHelper.GetTBL_BOMExtendResultData()).append('\n').append("\t(FMaterialID, FTraceId)").append('\n').append(" Select  entry.FMaterialID, P.FTraceID ").append('\n').append(" From T_MM_BOM bom ").append('\n').append(" Inner join T_MM_BOMEntry entry on bom.fid = entry.FParentID ").append('\n').append(" Inner join ").append(paramHelper.GetTBL_BOMExtendParam()).append(" p ON P.FTraceID = bom.FMaterialID and P.FStorageOrgUnitID = bom.FStorageOrgUnitID ").append('\n').append(" WHERE bom.FBaseStatus = 4 And bom.FBomType = 40; ");
        NCMDbUtil.BatchSqlExecute((Context)paramHelper.ctx, (String)sb.toString(), (String)";");
        sb.delete(0, sb.length());
        return paramHelper.GetTBL_BOMExtendResultData();
    }

    private IRowSet getBillHeadAndEntryData(BoPInvSFPCostGenParam paramHelper) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        if (paramHelper.canGenFromEstimateScheme) {
            sb.append(" select S.FCostObjectID,S.FProductID,S.FProdBatchNo,S.FQty,S.FAmount, ").append('\n').append(" \tci.FCostItemID,ci.FCostItemQty*S.FQty as FCostItemQty,round(ci.FCostItemRadio*S.FAmount,2) as FCostItemAmount,case when ci.FCostItemQty*S.FQty <> 0 then (ci.FCostItemRadio*S.FAmount)/(ci.FCostItemQty*S.FQty) else 0 end as FCostItemPrice,cii.FItemType,cii.FIsAllocateQty as FIsAllocateQty").append('\n').append(" From ").append(paramHelper.GetTBL_ValidSFPData()).append(" S ").append('\n').append(" Inner join (").append('\n').append("\t\tSelect FProductID,FCostItemID,Sum(FQty)As FCostItemQty,Round(Sum(FAmount),2)As FCostItemAmount,Round(Round(Sum(FAmount),2)/Sum(FQty),Max(Prd.FPricePrecision))As FCostItemPrice,Sum(data.FCostItemRadio) as FCostItemRadio").append('\n').append("\t\tFrom ").append(paramHelper.GetTBL_EstimateSchemeExtendResultData()).append(" data ").append('\n').append("\t\tLEFT JOIN T_BD_Material Prd ON Prd.FID=data.FProductID ").append('\n').append("\t\tWhere FMaterialID is null ").append('\n').append("\t\tGroup by FProductID,FCostItemID ").append('\n').append("\t\tHaving Sum(FQty) <> 0").append('\n').append(" ) ci on ci.FProductID = S.FProductID").append('\n').append(" Inner join T_NCM_CostItem cii on cii.FID  = ci.FCostItemID \n").append("Order by  S.FCostObjectID,S.FProductID,S.FProdBatchNo,ci.FCostItemID,cii.FItemType").append('\n').append(";").append('\n');
        } else {
            sb.append(" select S.FCostObjectID,S.FProductID,S.FProdBatchNo,ci.FID As FCostItemID,S.FQty,S.FAmount,0.00 As FCostItemQty, 0.00 As FCostItemAmount,0.00 As FCostItemPrice,ci.FItemType as FItemType, ci.FIsAllocateQty as FIsAllocateQty ").append('\n').append(" From ").append(paramHelper.GetTBL_ValidSFPData()).append(" S ").append('\n').append(" full join ( select cii.fid fid,cii.Fitemtype fitemtype,cii.FIsAllocateQty as FIsAllocateQty from  T_NCM_CostItem cii where  cii.FControlUnitID = '" + paramHelper.CU + "' or cii.fid in (select FDataBaseDID FROM T_BD_DataBaseDAssign where FBOSObjectType = '548C5A91' AND FAssignCUID = 'FH0AAAAJSK3M567U')) ci on 1=1 ").append('\n').append(" where S.FCostObjectID is not null ").append('\n').append(" Order by  S.FCostObjectID,S.FProductID,S.FProdBatchNo,ci.FID,ci.FItemType").append('\n').append(";").append('\n');
        }
        return NCMDbUtil.executeQuery((Context)paramHelper.ctx, (String)sb.toString());
    }

    public void Revert(BoPInvSFPCostGenParam paramHelper) throws EASBizException, BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT  DISTINCT FLowLevelCode ").append('\n').append(" FROM ").append(paramHelper.GetTBL_STDCostDataMatDetail()).append('\n').append(" WHERE FLowLevelCode <> 999 AND FLowLevelCode <> 0 AND FEstimateSchemeID = '" + paramHelper.EstimateSchemeID + "' ").append('\n').append(" ORDER BY FLowLevelCode DESC \n").append('\n');
        IRowSet rs = NCMDbUtil.executeQuery((Context)paramHelper.ctx, (String)sb.toString());
        sb.delete(0, sb.length());
        int rank = -1;
        try {
            while (rs.next()) {
                rank = rs.getInt("FLowLevelCode");
                this.RankRevert(paramHelper, rank);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void RankRevert(BoPInvSFPCostGenParam paramHelper, int rank) throws EASBizException, BOSException {
        StringBuffer sb = new StringBuffer();
        NumberFormat fm = NumberFormat.getInstance();
        fm.setGroupingUsed(false);
        sb.append(" Select S.FProductID,S.FProdAmount, ").append('\n').append(" \tS.FCostItemID,S.FCostItemQty,S.FCostItemAmount,D.FMaterialID,D.FMatQty,D.FMatAmount,Case When F.FProductID is null then 0 else 1 End As FHasCoef ").append('\n').append(" From (").append('\n').append(" \tSelect FProductID,FCostItemID,Max(FLowLevelCode)As FLowLevelCode,Sum(FProdAmount)as FProdAmount,Sum(FCostItemQty)As FCostItemQty,Sum(FCostItemAmount)As FCostItemAmount").append('\n').append(" \tFrom (").append('\n').append(" \t\tSelect distinct FParentMaterialID As FProductID,FStdPrice As FProdAmount,FChildCostItemID As FCostItemID,FChildQty As FCostItemQty, FChildAmount As FCostItemAmount, FLowLevelCode ").append('\n').append(" \t\tFrom ").append(paramHelper.GetTBL_STDCostDataMatDetail()).append(" M ").append('\n').append("\t\t\tWHERE M.FEstimateSchemeID = '" + paramHelper.EstimateSchemeID + "' AND FLowLevelCode = ").append(rank).append('\n').append(" \t\tUnion all ").append('\n').append(" \t\tSelect FParentMaterialID As FProductID,M.FProdAmount As FProdAmount,FResCostItemID As FCostItemID,FResQty As FCostItemQty, FResAmount As FCostItemAmount, IsNull(M.FLowLevelCode,-1) As FLowLevelCode ").append('\n').append(" \t\tFrom ").append(paramHelper.GetTBL_STDCostDataResDetail()).append(" R ").append('\n').append(" \t\tLeft Join ( ").append('\n').append(" \t\t\tSelect FParentMaterialID As FProductID, Max(FLowLevelCode)As FLowLevelCode,Max(FStdPrice) As FProdAmount ").append('\n').append(" \t\t\tFrom ").append(paramHelper.GetTBL_STDCostDataMatDetail()).append(" M ").append('\n').append("\t\t\t\tWHERE M.FEstimateSchemeID = '" + paramHelper.EstimateSchemeID + "' AND FLowLevelCode = ").append(rank).append('\n').append(" \t\t\tGROUP BY FParentMaterialID").append('\n').append(" \t\t) M On M.FProductID=R.FParentMaterialID").append('\n').append("\t\t\tWHERE R.FEstimateSchemeID = '" + paramHelper.EstimateSchemeID + "' ").append('\n').append(" \t) CI ").append('\n').append(" \tGROUP BY CI.FProductID,CI.FCostItemID ").append('\n').append(" ) S ").append('\n').append(" Left Join ( ").append('\n').append(" \tSelect distinct FParentMaterialID As FProductID,FStdPrice As FProdAmount,FChildCostItemID As FCostItemID,FMaterialID,FChildQty As FMatQty,FChildAmount As FMatAmount ").append('\n').append(" \tFrom ").append(paramHelper.GetTBL_STDCostDataMatDetail()).append(" M ").append('\n').append("\t\tWHERE M.FEstimateSchemeID = '" + paramHelper.EstimateSchemeID + "' ").append('\n').append(" ) D ON D.FProductID=S.FProductID AND D.FCostItemID=S.FCostItemID ").append('\n');
        if (!paramHelper.isRevertAllProduct) {
            sb.append("INNER JOIN T_BD_MaterialCost mcst ON mcst.FOrgUnit=B.FCompanyOrg AND mcst.FMaterialID = S.FProductID AND mcst.FStatus=1 AND mcst.FIsParticipateReduct=1 ").append('\n');
        }
        sb.append("LEFT JOIN ( ").append('\n').append("\t\tSelect distinct FProductID From ").append(paramHelper.GetTBL_EstimateSchemeExtendResultData()).append('\n').append(")F ON F.FProductID=D.FMaterialID ").append('\n').append("WHERE S.FLowLevelCode = ").append(rank).append('\n').append(";").append('\n');
        IRowSet rs = NCMDbUtil.executeQuery((Context)paramHelper.ctx, (String)sb.toString());
        sb.delete(0, sb.length());
        try {
            String lastProductId = "";
            String lastCostItemID = "";
            BigDecimal dMatAmount = BigDecimal.valueOf(0L);
            BigDecimal dMatQty = BigDecimal.valueOf(0L);
            BigDecimal dMatAmount_ToSubtract = BigDecimal.valueOf(0L);
            BigDecimal dMatQty_ToSubtract = BigDecimal.valueOf(0L);
            StringBuffer sbLastInsertSql_CostItem = new StringBuffer();
            while (rs.next()) {
                if (lastProductId.compareTo("") != 0 && (lastProductId.compareTo(rs.getString("FProductId")) != 0 || lastCostItemID.compareTo(rs.getString("FCostItemID")) != 0)) {
                    sb.append(sbLastInsertSql_CostItem.toString());
                    dMatAmount_ToSubtract = BigDecimal.valueOf(0L);
                    dMatQty_ToSubtract = BigDecimal.valueOf(0L);
                }
                lastProductId = rs.getString("FProductId");
                lastCostItemID = rs.getString("FCostItemID");
                if (rs.getString("FMaterialID") != null && rs.getString("FMaterialID").length() > 0) {
                    String matQty;
                    String matAmount;
                    dMatAmount = BigDecimal.valueOf(0L);
                    if (rs.getBigDecimal("FMatAmount") != null) {
                        dMatAmount = rs.getBigDecimal("FMatAmount");
                    }
                    dMatQty = BigDecimal.valueOf(0L);
                    if (rs.getBigDecimal("FMatQty") != null) {
                        dMatQty = rs.getBigDecimal("FMatQty");
                    }
                    if (rs.getInt("FHasCoef") == 1) {
                        matAmount = fm.format(dMatAmount);
                        matQty = fm.format(dMatQty);
                        sb.append("INSERT INTO ").append(paramHelper.GetTBL_EstimateSchemeExtendResultData()).append("(FProductID,FCostItemID,FMaterialID,FAmount,FQty,FType)").append('\n').append("Select '").append(rs.getString("FProductId")).append("' As FProductID,W.FCostItemID,W.FMaterialID, ").append('\n').append("    Round(W.FAmount * ").append(matAmount).append("/SM.FSumAmount,2) As FAmount, W.FQty * ").append(matQty).append(" As FQty, 1 ").append('\n').append("FROM ").append(paramHelper.GetTBL_EstimateSchemeExtendResultData()).append(" W ").append('\n').append("Inner Join ( ").append('\n').append(" \tSelect FProductID,Sum(FAmount)As FSumAmount").append('\n').append("\tFROM ").append(paramHelper.GetTBL_EstimateSchemeExtendResultData()).append(" ").append('\n').append("\tWhere FMaterialID is null ").append('\n').append("\tGroup by FProductID ").append('\n').append("\tHaving Sum(FAmount) <> 0 ").append('\n').append(")SM ON SM.FProductID=W.FProductID ").append('\n').append("WHERE W.FProductID = '").append(rs.getString("FMaterialID")).append("' ").append('\n').append("; ").append('\n');
                        dMatAmount_ToSubtract = dMatAmount_ToSubtract.add(dMatAmount);
                        dMatQty_ToSubtract = dMatQty_ToSubtract.add(dMatQty);
                        dMatAmount = BigDecimal.valueOf(0L);
                        dMatQty = BigDecimal.valueOf(0L);
                    }
                    if (dMatAmount.compareTo(BigDecimal.valueOf(0L)) != 0 || dMatQty.compareTo(BigDecimal.valueOf(0L)) != 0) {
                        matAmount = fm.format(dMatAmount);
                        matQty = fm.format(dMatQty);
                        sb.append("INSERT INTO ").append(paramHelper.GetTBL_EstimateSchemeExtendResultData()).append("(FProductID,FCostItemID,FMaterialID,FAmount,FQty,FType)").append('\n').append("Values('").append(rs.getString("FProductId")).append("','").append(rs.getString("FCostItemID")).append("','").append(rs.getString("FMaterialID")).append("',").append(matAmount).append(",").append(matQty).append(",1 ").append(");").append('\n');
                    }
                }
                fm.setMaximumFractionDigits(12);
                BigDecimal dCostItemAmount = BigDecimal.valueOf(0L);
                if (rs.getBigDecimal("FCostItemAmount") != null) {
                    dCostItemAmount = rs.getBigDecimal("FCostItemAmount");
                }
                dCostItemAmount = dCostItemAmount.subtract(dMatAmount_ToSubtract);
                BigDecimal dCostItemQty = BigDecimal.valueOf(0L);
                if (rs.getBigDecimal("FCostItemQty") != null) {
                    dCostItemQty = rs.getBigDecimal("FCostItemQty");
                }
                dCostItemQty = dCostItemQty.subtract(dMatQty_ToSubtract);
                String costItemAmount = fm.format(dCostItemAmount);
                String costItemQty = fm.format(dCostItemQty);
                sbLastInsertSql_CostItem.delete(0, sbLastInsertSql_CostItem.length());
                sbLastInsertSql_CostItem.append("INSERT INTO ").append(paramHelper.GetTBL_EstimateSchemeExtendResultData()).append("(FProductID,FCostItemID,FAmount,FQty,FType)").append('\n').append("Values('").append(rs.getString("FProductId")).append("','").append(rs.getString("FCostItemID")).append("',").append(costItemAmount).append(",").append(costItemQty).append(",1 ").append(");").append('\n');
            }
            if (sbLastInsertSql_CostItem.length() > 0) {
                sb.append(sbLastInsertSql_CostItem.toString());
            }
            if (sb.length() > 0) {
                NCMDbUtil.BatchSqlExecute((Context)paramHelper.ctx, (String)sb.toString(), (String)";");
                sb.delete(0, sb.length());
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    private void adjustDiffCostItemAmount(BoPInvSFPCostGenParam paramHelper) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append(" select fid,A.FDiffAmount as FDiffAmount from ( \n");
        sb.append("                   select bill.FID as FID , bill.FAmount - sum(entry.FAmount) AS FDiffAmount from T_NCM_BoPInvSFPCost bill \n");
        sb.append("                     inner join T_NCM_BoPInvSFPCostEntry entry on entry.FParentID = bill.FID \n");
        sb.append("                     where bill.FCompanyOrg = '" + paramHelper.companyId + "'and FCalculatePeriod = '" + paramHelper.periodInfo.getId().toString() + "'\n");
        sb.append("                     group by bill.Fid,bill.FAmount \n");
        sb.append("                  ) as A where A.FDiffAmount > 0 or A.FDiffAmount < 0 ");
        IRowSet rs = NCMDbUtil.executeQuery((Context)paramHelper.ctx, (String)sb.toString());
        sb.setLength(0);
        sb.append(" update T_NCM_BoPInvSFPCostEntry set FAmount = FAmount + (?) where FID in ( \n");
        sb.append("  select top 1 FID from T_NCM_BoPInvSFPCostEntry where FParentID = ? \n");
        sb.append("    order by FAmount DESC )\n");
        PreparedStatement pstmt = null;
        Object pstmtInsert = null;
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)paramHelper.ctx);
            pstmt = conn.prepareStatement(sb.toString());
            while (rs.next()) {
                pstmt.setBigDecimal(1, rs.getBigDecimal("FDiffAmount"));
                pstmt.setString(2, rs.getString("fid"));
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private void adjustDiffMatDetail(BoPInvSFPCostGenParam paramHelper) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append(" select fid,A.FDiffAmount as FDiffAmount from ( \n");
        sb.append("                   select entry.FID as FID , entry.FAmount - sum(detail.FAmount) AS FDiffAmount from T_NCM_BoPInvSFPCost bill \n");
        sb.append("                     inner join T_NCM_BoPInvSFPCostEntry entry on entry.FParentID = bill.FID \n");
        sb.append("                     inner join T_NCM_BoPInvSFPCostMatDetail detail on detail.FParentID = entry.FID \n");
        sb.append("                     where bill.FCompanyOrg = '" + paramHelper.companyId + "'and FCalculatePeriod = '" + paramHelper.periodInfo.getId().toString() + "'\n");
        sb.append("                     group by entry.FID,entry.FAmount \n");
        sb.append("                  ) as A where A.FDiffAmount > 0 or A.FDiffAmount < 0 ");
        IRowSet rs = NCMDbUtil.executeQuery((Context)paramHelper.ctx, (String)sb.toString());
        sb.setLength(0);
        sb.append(" update T_NCM_BoPInvSFPCostMatDetail set FAmount = FAmount + (?) where FID in ( \n");
        sb.append("  select top 1 FID from T_NCM_BoPInvSFPCostMatDetail where FParentID = ? \n");
        sb.append("    order by FAmount DESC )\n");
        PreparedStatement pstmt = null;
        Object pstmtInsert = null;
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)paramHelper.ctx);
            pstmt = conn.prepareStatement(sb.toString());
            while (rs.next()) {
                pstmt.setBigDecimal(1, rs.getBigDecimal("FDiffAmount"));
                pstmt.setString(2, rs.getString("fid"));
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }
}

