/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.bill.AllocateException;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Table.MatAllocTable;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.util.Assert;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class CostDataCache {
    private static Logger logger = Logger.getLogger((String)MatAllocTable.class.getName());
    protected static final char CLF = '\n';
    protected Map param = null;
    protected Context ctx = null;
    protected TempTablePool pool = null;
    protected String T_TMP_CostObject = null;
    protected String T_TMP_MatReqSum = null;
    protected String T_TMP_InputQty = null;
    protected String T_TMP_CurrInputQty = null;
    protected String T_TMP_FinishedQty = null;
    protected String T_TMP_RecMatToCO = null;
    protected String T_TMP_MatReq = null;
    protected String T_TMP_CostAdjust = null;
    protected String T_TMP_RecBill = null;
    protected String T_TMP_WIPCountMaterial = null;
    protected String T_TMP_SumHour = null;
    protected Map T_TMP_AllocStdSetByWIPs = new HashMap();
    protected Map T_TMP_UserDefinedDatas = new HashMap();

    public CostDataCache(Map param) {
        this.param = param;
        Assert.that((boolean)param.containsKey("companyId"));
        Assert.that((boolean)param.containsKey("periodId"));
    }

    public Context getContext() {
        if (this.ctx == null) {
            this.ctx = (Context)this.param.get("ctx");
        }
        return this.ctx;
    }

    public TempTablePool getTempTablePool() {
        if (this.pool == null) {
            this.pool = (TempTablePool)this.param.get("pool");
        }
        if (this.pool == null) {
            this.pool = TempTablePool.getInstance((Context)this.getContext());
        }
        return this.pool;
    }

    private PeriodInfo getPeriod() throws EASBizException, BOSException {
        if (this.param.containsKey("period") && this.param.get("period") instanceof PeriodInfo) {
            return (PeriodInfo)this.param.get("period");
        }
        String periodId = (String)this.param.get("periodId");
        PeriodInfo period = PeriodFactory.getLocalInstance((Context)this.getContext()).getPeriodInfo((IObjectPK)new ObjectUuidPK(periodId));
        return period;
    }

    public void release() {
        TempTablePool pool = this.getTempTablePool();
        if (this.T_TMP_CostObject != null) {
            NCMDbUtil.releaseTempTableByPool((TempTablePool)pool, (String)this.T_TMP_CostObject);
        }
        if (this.T_TMP_MatReqSum != null) {
            NCMDbUtil.releaseTempTableByPool((TempTablePool)pool, (String)this.T_TMP_MatReqSum);
        }
        if (this.T_TMP_InputQty != null) {
            NCMDbUtil.releaseTempTableByPool((TempTablePool)pool, (String)this.T_TMP_InputQty);
        }
        if (this.T_TMP_CurrInputQty != null) {
            NCMDbUtil.releaseTempTableByPool((TempTablePool)pool, (String)this.T_TMP_CurrInputQty);
        }
        if (this.T_TMP_FinishedQty != null) {
            NCMDbUtil.releaseTempTableByPool((TempTablePool)pool, (String)this.T_TMP_FinishedQty);
        }
        if (this.T_TMP_RecMatToCO != null) {
            NCMDbUtil.releaseTempTableByPool((TempTablePool)pool, (String)this.T_TMP_RecMatToCO);
        }
        if (this.T_TMP_MatReq != null) {
            NCMDbUtil.releaseTempTableByPool((TempTablePool)pool, (String)this.T_TMP_MatReq);
        }
        if (this.T_TMP_CostAdjust != null) {
            NCMDbUtil.releaseTempTableByPool((TempTablePool)pool, (String)this.T_TMP_CostAdjust);
        }
        if (this.T_TMP_RecBill != null) {
            NCMDbUtil.releaseTempTableByPool((TempTablePool)pool, (String)this.T_TMP_RecBill);
        }
        if (this.T_TMP_WIPCountMaterial != null) {
            NCMDbUtil.releaseTempTableByPool((TempTablePool)pool, (String)this.T_TMP_WIPCountMaterial);
        }
        if (this.T_TMP_SumHour != null) {
            NCMDbUtil.releaseTempTableByPool((TempTablePool)pool, (String)this.T_TMP_SumHour);
        }
        for (String T_TMP_AllocStdSetByWIP : this.T_TMP_AllocStdSetByWIPs.values()) {
            NCMDbUtil.releaseTempTableByPool((TempTablePool)pool, (String)T_TMP_AllocStdSetByWIP);
        }
        for (String T_TMP_UserDefinedData : this.T_TMP_UserDefinedDatas.values()) {
            NCMDbUtil.releaseTempTableByPool((TempTablePool)pool, (String)T_TMP_UserDefinedData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCostObjectTable() throws Exception {
        String string;
        if (this.T_TMP_CostObject != null) {
            return this.T_TMP_CostObject;
        }
        Context ctx = this.getContext();
        TempTablePool pool = this.getTempTablePool();
        String companyId = (String)this.param.get("companyId");
        String T_TMP_InputQty = this.getInputQtyTable();
        String T_TMP_RecBill = this.getRecBillTable();
        String T_TMP_MatReq = this.getMatReqTable();
        String T_TMP_CostAdjust = this.getCostAdjustTable();
        String tblBalanceDetail = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_BalanceMatDetail");
        StringBuffer ksql = new StringBuffer();
        String T_TMP_MatData = null;
        try {
            ksql.append("create table T ( \n");
            ksql.append("    FMaterialID VARCHAR(44), \n");
            ksql.append("    FLot NVARCHAR(80) \n");
            ksql.append(") \n");
            T_TMP_MatData = NCMDbUtil.createTempTableByPool((TempTablePool)pool, (String)ksql.toString());
            ksql.setLength(0);
            ksql.append("insert into " + T_TMP_MatData + " ( \n");
            ksql.append("    FMaterialID, \n");
            ksql.append("    FLot \n");
            ksql.append(") \n");
            ksql.append("SELECT \n");
            ksql.append("    FMaterialID, \n");
            ksql.append("    FLot \n");
            ksql.append("FROM " + T_TMP_MatReq + " \n");
            ksql.append("union \n");
            ksql.append("SELECT \n");
            ksql.append("    FMaterialID, \n");
            ksql.append("    FLot \n");
            ksql.append("FROM " + T_TMP_CostAdjust + " \n");
            ksql.append("union \n");
            ksql.append("SELECT \n");
            ksql.append("    FMaterialID, \n");
            ksql.append("    FBatchNo \n");
            ksql.append("FROM " + tblBalanceDetail + " \n");
            NCMDbUtil.execute((Context)ctx, (String)ksql.toString());
            NCMDbUtil.createTempTableIndexByPool((TempTablePool)pool, (String)T_TMP_MatData, (String)"FMaterialID, FLot", (boolean)true, (boolean)false);
            ksql.setLength(0);
            ksql.append("create table T ( \n");
            ksql.append("    FCostObjectID VARCHAR(44), \n");
            ksql.append("    FCalculateMode int, \n");
            ksql.append("    FBatchNumber NVARCHAR(255), \n");
            ksql.append("    FOrderID VARCHAR(44), \n");
            ksql.append("    FMaterialID VARCHAR(44), \n");
            ksql.append("    FIsMainProduct int, \n");
            ksql.append("    FIsByProduct int, \n");
            ksql.append("    FQuotiety NUMERIC(21,8) \n");
            ksql.append(") \n");
            this.T_TMP_CostObject = NCMDbUtil.createTempTableByPool((TempTablePool)pool, (String)ksql.toString());
            ksql.setLength(0);
            ksql.append("insert into " + this.T_TMP_CostObject + " ( \n");
            ksql.append("    FCostObjectID, \n");
            ksql.append("    FCalculateMode, \n");
            ksql.append("    FBatchNumber, \n");
            ksql.append("    FOrderID, \n");
            ksql.append("    FMaterialID, \n");
            ksql.append("    FIsMainProduct, \n");
            ksql.append("    FIsByProduct, \n");
            ksql.append("    FQuotiety \n");
            ksql.append(") \n");
            ksql.append("SELECT \n");
            ksql.append("    co.FID, \n");
            ksql.append("    co.FCalculateMode, \n");
            ksql.append("    co.FBatchNumber, \n");
            ksql.append("    co.FOrderID, \n");
            ksql.append("    co.FStdProductIDID, \n");
            ksql.append("    1 as FIsMainProduct, \n");
            ksql.append("    0 as FIsByProduct, \n");
            ksql.append("    1 as FQuotiety \n");
            ksql.append(" FROM " + T_TMP_InputQty + " r \n");
            ksql.append(" Inner join T_BD_CostObject co on r.FCostObjectID = co.FID  \n");
            ksql.append(" where co.FCompanyID = '" + companyId + "' \n");
            ksql.append("    and co.FRelatedType=0 and co.FIsForbiden = 0 \n");
            ksql.append("    and (co.FCalculateMode = 1 or co.FCalculateMode = 4 or co.FCalculateMode = 7) \n");
            ksql.append(" union \n");
            ksql.append("SELECT \n");
            ksql.append("    co.FID, \n");
            ksql.append("    co.FCalculateMode, \n");
            ksql.append("    co.FBatchNumber, \n");
            ksql.append("    co.FOrderID, \n");
            ksql.append("    co.FStdProductIDID, \n");
            ksql.append("    1 as FIsMainProduct, \n");
            ksql.append("    0 as FIsByProduct, \n");
            ksql.append("    1 as FQuotiety \n");
            ksql.append(" FROM " + T_TMP_RecBill + " r \n");
            ksql.append(" Inner join T_BD_CostObject co on r.FMaterialID = co.FStdProductIDID  \n");
            ksql.append(" where co.FCompanyID = '" + companyId + "' \n");
            ksql.append("    and co.FRelatedType=0 and co.FIsForbiden = 0 \n");
            ksql.append("            and ( \n");
            ksql.append("                co.FCalculateMode = 1 \n");
            ksql.append("                or co.FCalculateMode = 4 and isnull(co.FBatchNumber,' ') = isnull(r.FLot,' ') \n");
            ksql.append("                or co.FCalculateMode = 7 and co.FOrderID = r.FOrderID \n");
            ksql.append("            ) \n");
            ksql.append(" union \n");
            ksql.append("SELECT \n");
            ksql.append("    co.FID, \n");
            ksql.append("    co.FCalculateMode, \n");
            ksql.append("    co.FBatchNumber, \n");
            ksql.append("    co.FOrderID, \n");
            ksql.append("    co.FStdProductIDID, \n");
            ksql.append("    1 as FIsMainProduct, \n");
            ksql.append("    0 as FIsByProduct, \n");
            ksql.append("    1 as FQuotiety \n");
            ksql.append(" FROM " + T_TMP_MatData + " r \n");
            ksql.append(" Inner join T_BD_CostObject co on r.FMaterialID = co.FStdProductIDID  \n");
            ksql.append(" where co.FCompanyID = '" + companyId + "' \n");
            ksql.append("    and co.FRelatedType=0 and co.FIsForbiden = 0 \n");
            ksql.append("            and ( \n");
            ksql.append("                co.FCalculateMode = 1 \n");
            ksql.append("                or co.FCalculateMode = 4 and isnull(co.FBatchNumber,' ') = isnull(r.FLot,' ') \n");
            ksql.append("                or co.FCalculateMode = 7 \n");
            ksql.append("            ) \n");
            NCMDbUtil.execute((Context)ctx, (String)ksql.toString());
            ksql.setLength(0);
            ksql.append("insert into " + this.T_TMP_CostObject + " ( \n");
            ksql.append("    FCostObjectID, \n");
            ksql.append("    FCalculateMode, \n");
            ksql.append("    FBatchNumber, \n");
            ksql.append("    FOrderID, \n");
            ksql.append("    FMaterialID, \n");
            ksql.append("    FIsMainProduct, \n");
            ksql.append("    FIsByProduct, \n");
            ksql.append("    FQuotiety \n");
            ksql.append(") \n");
            ksql.append("SELECT \n");
            ksql.append("    co.FID, \n");
            ksql.append("    co.FCalculateMode, \n");
            ksql.append("    co.FBatchNumber, \n");
            ksql.append("    co.FOrderID, \n");
            ksql.append("    coe.FRelatedID, \n");
            ksql.append("    coe.FIsMainProduct, \n");
            ksql.append("    coe.FIsByProduct, \n");
            ksql.append("    coe.FQuotiety \n");
            ksql.append("FROM T_BD_CostObject co \n");
            ksql.append("JOIN T_BD_CostObjectEntry coe \n");
            ksql.append("    ON coe.FParentID = co.FID \n");
            ksql.append("where co.FCompanyID = '" + companyId + "' \n");
            ksql.append("    and co.FRelatedType=0 and co.FIsForbiden = 0 \n");
            ksql.append("    and co.FCalculateMode = 3 \n");
            ksql.append("    and ( \n");
            ksql.append("    exists ( \n");
            ksql.append("        select 1 from " + T_TMP_InputQty + " r \n");
            ksql.append("        where r.FCostObjectID = co.FID \n");
            ksql.append("    ) \n");
            ksql.append("    or exists ( \n");
            ksql.append("        select 1 from " + T_TMP_RecBill + " r \n");
            ksql.append("        where r.FMaterialID = coe.FRelatedID \n");
            ksql.append("    ) \n");
            ksql.append("    or exists ( \n");
            ksql.append("        select 1 from " + T_TMP_MatData + " r \n");
            ksql.append("        where r.FMaterialID = coe.FRelatedID \n");
            ksql.append("    ) \n");
            ksql.append("    ) \n");
            NCMDbUtil.execute((Context)ctx, (String)ksql.toString());
            NCMDbUtil.createTempTableIndexByPool((TempTablePool)pool, (String)this.T_TMP_CostObject, (String)"FCostObjectID", (boolean)false, (boolean)false);
            NCMDbUtil.createTempTableIndexByPool((TempTablePool)pool, (String)this.T_TMP_CostObject, (String)"FMaterialID, FCalculateMode, FBatchNumber", (boolean)false, (boolean)false);
            NCMDbUtil.createTempTableIndexByPool((TempTablePool)pool, (String)this.T_TMP_CostObject, (String)"FOrderID", (boolean)false, (boolean)false);
            string = this.T_TMP_CostObject;
        }
        catch (Throwable throwable) {
            NCMDbUtil.releaseTempTableByPool((TempTablePool)pool, T_TMP_MatData);
            throw throwable;
        }
        NCMDbUtil.releaseTempTableByPool((TempTablePool)pool, (String)T_TMP_MatData);
        return string;
    }

    public String getMatReqSumTable() throws BOSException, EASBizException {
        if (this.T_TMP_MatReqSum != null) {
            return this.T_TMP_MatReqSum;
        }
        Context ctx = this.getContext();
        TempTablePool pool = this.getTempTablePool();
        StringBuffer ksql = new StringBuffer();
        ksql.append("create table T ( \n");
        ksql.append("    FCostCenterID VARCHAR(44), \n");
        ksql.append("    FCostObjectID VARCHAR(44), \n");
        ksql.append("    FMaterialID VARCHAR(44), \n");
        ksql.append("    FBaseQty NUMERIC(21,8) \n");
        ksql.append(") \n");
        String T_TMP_MatReq = this.getMatReqTable();
        this.T_TMP_MatReqSum = NCMDbUtil.createTempTableByPool((TempTablePool)pool, (String)ksql.toString());
        ksql.setLength(0);
        ksql.append("insert into " + this.T_TMP_MatReqSum + " ( \n");
        ksql.append("    FCostCenterID, \n");
        ksql.append("    FCostObjectID, \n");
        ksql.append("    FMaterialID, \n");
        ksql.append("    FBaseQty \n");
        ksql.append(") \n");
        ksql.append("SELECT \n");
        ksql.append("    t.FcostCenterID, ").append('\n');
        ksql.append("    t.FcostObjectID, ").append('\n');
        ksql.append("    t.FMaterialID FMaterialID, ").append('\n');
        ksql.append("    ISNULL(SUM(t.FBaseQty),0) FBaseQty ").append('\n');
        ksql.append("FROM " + T_TMP_MatReq + " t ").append('\n');
        ksql.append("WHERE t.FCostCenterType = 0 and t.FRelatedType = 0 ").append('\n');
        ksql.append("GROUP BY t.FCostCenterID, ").append('\n');
        ksql.append("    t.FCostObjectID, ").append('\n');
        ksql.append("    t.FMaterialID ").append('\n');
        NCMDbUtil.execute((Context)ctx, (String)ksql.toString());
        NCMDbUtil.createTempTableIndexByPool((TempTablePool)pool, (String)this.T_TMP_MatReqSum, (String)"FCostCenterID, FCostObjectID, FMaterialID", (boolean)true, (boolean)false);
        return this.T_TMP_MatReqSum;
    }

    public String getMatReqTable() throws BOSException, EASBizException {
        if (this.T_TMP_MatReq != null) {
            return this.T_TMP_MatReq;
        }
        Context ctx = this.getContext();
        TempTablePool pool = this.getTempTablePool();
        String companyId = (String)this.param.get("companyId");
        PeriodInfo period = this.getPeriod();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String beginDate = format.format(period.getBeginDate());
        String endDate = format.format(period.getEndDate()).replaceAll("00:00:00", "23:59:59");
        StringBuffer ksql = new StringBuffer();
        ksql.append("create table T ( \n");
        ksql.append("    FSourceBillID VARCHAR(44), \n");
        ksql.append("    FNumber NVARCHAR(80), \n");
        ksql.append("    FSourceBillEntryID VARCHAR(44), \n");
        ksql.append("    FSeq INT, \n");
        ksql.append("    FCostCenterID VARCHAR(44), \n");
        ksql.append("    FCostObjectID VARCHAR(44), \n");
        ksql.append("    FMaterialID VARCHAR(44), \n");
        ksql.append("    FLot NVARCHAR(80), \n");
        ksql.append("    FBaseQty NUMERIC(21,8), \n");
        ksql.append("    FActualCost NUMERIC(19,4) DEFAULT 0, \n");
        ksql.append("    FIsReWork INT DEFAULT 0 NOT NULL, \n");
        ksql.append("    FISAdmeasure INT DEFAULT 0 NOT NULL, \n");
        ksql.append("    FCostCenterType INT DEFAULT 0 NOT NULL, \n");
        ksql.append("    FRelatedType INT DEFAULT 0 NOT NULL \n");
        ksql.append(") \n");
        this.T_TMP_MatReq = NCMDbUtil.createTempTableByPool((TempTablePool)pool, (String)ksql.toString());
        ksql.setLength(0);
        ksql.append("insert into " + this.T_TMP_MatReq + " ( \n");
        ksql.append("    FSourceBillID, \n");
        ksql.append("    FNumber, \n");
        ksql.append("    FSourceBillEntryID, \n");
        ksql.append("    FSeq, \n");
        ksql.append("    FCostCenterID, \n");
        ksql.append("    FCostObjectID, \n");
        ksql.append("    FMaterialID, \n");
        ksql.append("    FLot, \n");
        ksql.append("    FBaseQty, \n");
        ksql.append("    FActualCost, \n");
        ksql.append("    FIsReWork, \n");
        ksql.append("    FISAdmeasure, \n");
        ksql.append("    FCostCenterType, \n");
        ksql.append("    FRelatedType \n");
        ksql.append(") \n");
        ksql.append("SELECT \n");
        ksql.append("    b.FID FSourceBillID, \n");
        ksql.append("    b.FNumber FNumber, \n");
        ksql.append("    be.FID FSourceBillEntryID, \n");
        ksql.append("    be.FSeq FSeq, \n");
        ksql.append("    be.FCostCenterOrgUnitID FCostCenterID, ").append('\n');
        ksql.append("    be.FCostObjectID FCostObjectID, ").append('\n');
        ksql.append("    be.FMaterialID FMaterialID, ").append('\n');
        ksql.append("    be.FLot FLot, ").append('\n');
        ksql.append("    be.FBaseQty FBaseQty, ").append('\n');
        ksql.append("    be.FActualCost FActualCost, ").append('\n');
        ksql.append("    be.FIsReWork FIsReWork, ").append('\n');
        ksql.append("    be.FISAdmeasure FISAdmeasure, ").append('\n');
        ksql.append("    cc.FCostCenterType FCostCenterType, ").append('\n');
        ksql.append("    isnull(co.FRelatedType, 0) FRelatedType ").append('\n');
        ksql.append("FROM T_IM_MaterialReqBill b ").append('\n');
        ksql.append("JOIN T_IM_MaterialReqBillEntry be ").append('\n');
        ksql.append("    ON b.FID = be.FParentID ").append('\n');
        ksql.append("JOIN T_SCM_TransactionType tt ").append('\n');
        ksql.append("    ON b.FTransactionTypeID = tt.FID ").append('\n');
        ksql.append("inner join T_IM_InvUpdateType ut on be.FINVUPDATETYPEID = ut.fid ").append('\n');
        ksql.append("inner join T_IM_STORETYPE st on ut.FSTORETYPEPREID = st.fid ").append('\n');
        ksql.append("JOIN T_ORG_CostCenter cc ").append('\n');
        ksql.append("    ON be.FCostCenterOrgUnitID = cc.FID ").append('\n');
        ksql.append("LEFT JOIN T_BD_CostObject co ").append('\n');
        ksql.append("    ON co.FID = be.FCostObjectID ").append('\n');
        ksql.append("WHERE be.FCompanyOrgUnitID = '" + companyId + "' ").append('\n');
        ksql.append("    AND b.FYear = " + period.getPeriodYear() + " ").append('\n');
        ksql.append("    AND b.FPeriod = " + period.getPeriodNumber() + " ").append('\n');
        ksql.append("    AND b.FBaseStatus = 4 ").append('\n');
        ksql.append("    AND tt.FIsManuCostCalculate = 1 ").append('\n');
        ksql.append("    AND st.FISFORWARDAMT = 1  ").append('\n');
        ksql.append("    AND cc.FCostCenterType in (0, 1) ").append('\n');
        ksql.append("    AND be.FBizDate >= {TS '" + beginDate + "'} ").append('\n');
        ksql.append("    AND be.FBizDate <= {TS '" + endDate + "'} ").append('\n');
        NCMDbUtil.execute((Context)ctx, (String)ksql.toString());
        NCMDbUtil.createTempTableIndexByPool((TempTablePool)pool, (String)this.T_TMP_MatReq, (String)"FSourceBillID", (boolean)false, (boolean)false);
        NCMDbUtil.createTempTableIndexByPool((TempTablePool)pool, (String)this.T_TMP_MatReq, (String)"FSourceBillEntryID", (boolean)true, (boolean)false);
        NCMDbUtil.createTempTableIndexByPool((TempTablePool)pool, (String)this.T_TMP_MatReq, (String)"FCostCenterID", (boolean)false, (boolean)false);
        NCMDbUtil.createTempTableIndexByPool((TempTablePool)pool, (String)this.T_TMP_MatReq, (String)"FCostObjectID", (boolean)false, (boolean)false);
        NCMDbUtil.createTempTableIndexByPool((TempTablePool)pool, (String)this.T_TMP_MatReq, (String)"FMaterialID", (boolean)false, (boolean)false);
        return this.T_TMP_MatReq;
    }

    public String getCostAdjustTable() throws BOSException, EASBizException {
        if (this.T_TMP_CostAdjust != null) {
            return this.T_TMP_CostAdjust;
        }
        Context ctx = this.getContext();
        TempTablePool pool = this.getTempTablePool();
        String companyId = (String)this.param.get("companyId");
        PeriodInfo period = this.getPeriod();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String beginDate = format.format(period.getBeginDate());
        String endDate = format.format(period.getEndDate()).replaceAll("00:00:00", "23:59:59");
        StringBuffer ksql = new StringBuffer();
        ksql.append("create table T ( \n");
        ksql.append("    FSourceBillID VARCHAR(44), \n");
        ksql.append("    FNumber NVARCHAR(80), \n");
        ksql.append("    FSourceBillEntryID VARCHAR(44), \n");
        ksql.append("    FSeq INT, \n");
        ksql.append("    FCostCenterID VARCHAR(44), \n");
        ksql.append("    FCostObjectID VARCHAR(44), \n");
        ksql.append("    FMaterialID VARCHAR(44), \n");
        ksql.append("    FLot NVARCHAR(80), \n");
        ksql.append("    FBaseQty NUMERIC(21,8), \n");
        ksql.append("    FActualCost NUMERIC(19,4) DEFAULT 0, \n");
        ksql.append("    FCostCenterType INT DEFAULT 0 NOT NULL, \n");
        ksql.append("    FRelatedType INT DEFAULT 0 NOT NULL \n");
        ksql.append(") \n");
        this.T_TMP_CostAdjust = NCMDbUtil.createTempTableByPool((TempTablePool)pool, (String)ksql.toString());
        ksql.setLength(0);
        ksql.append("insert into " + this.T_TMP_CostAdjust + " ( \n");
        ksql.append("    FSourceBillID, \n");
        ksql.append("    FNumber, \n");
        ksql.append("    FSourceBillEntryID, \n");
        ksql.append("    FSeq, \n");
        ksql.append("    FCostCenterID, \n");
        ksql.append("    FCostObjectID, \n");
        ksql.append("    FMaterialID, \n");
        ksql.append("    FLot, \n");
        ksql.append("    FBaseQty, \n");
        ksql.append("    FActualCost, \n");
        ksql.append("    FCostCenterType, \n");
        ksql.append("    FRelatedType \n");
        ksql.append(") \n");
        ksql.append("SELECT \n");
        ksql.append("    b.FID FSourceBillID, \n");
        ksql.append("    b.FNumber FNumber, \n");
        ksql.append("    be.FID FSourceBillEntryID, \n");
        ksql.append("    be.FSeq FSeq, \n");
        ksql.append("    b.FCostCenterOrgUnitID FCostCenterID, ").append('\n');
        ksql.append("    be.FCostObjectID FCostObjectID, ").append('\n');
        ksql.append("    be.FMaterialID FMaterialID, ").append('\n');
        ksql.append("    be.FLot FLot, ").append('\n');
        ksql.append("    be.FBaseQty FBaseQty, ").append('\n');
        ksql.append("    be.FActualCost FActualCost, ").append('\n');
        ksql.append("    cc.FCostCenterType FCostCenterType, ").append('\n');
        ksql.append("    isnull(co.FRelatedType, 0) FRelatedType ").append('\n');
        ksql.append("FROM T_CL_CostAdjustBill b ").append('\n');
        ksql.append("JOIN T_CL_CostAdjustBillEntry be ").append('\n');
        ksql.append("    ON b.FID = be.FParentID ").append('\n');
        ksql.append("JOIN T_ORG_CostCenter cc ").append('\n');
        ksql.append("    ON b.FCostCenterOrgUnitID = cc.FID ").append('\n');
        ksql.append("LEFT JOIN T_BD_CostObject co ").append('\n');
        ksql.append("    ON co.FID = be.FCostObjectID ").append('\n');
        ksql.append("WHERE be.FCompanyOrgUnitID = '" + companyId + "' ").append('\n');
        ksql.append("    AND b.FYear = " + period.getPeriodYear() + " ").append('\n');
        ksql.append("    AND b.FPeriod = " + period.getPeriodNumber() + " ").append('\n');
        ksql.append("    AND b.FBaseStatus = 4 ").append('\n');
        ksql.append("    AND b.FIsReversed = 0 ").append('\n');
        ksql.append("    AND b.FCalculateKind = 1 ").append('\n');
        ksql.append("    AND b.FIssueType = 1 ").append('\n');
        ksql.append("    AND cc.FCostCenterType in (0) ").append('\n');
        ksql.append("    AND be.FBizDate >= {TS '" + beginDate + "'} ").append('\n');
        ksql.append("    AND be.FBizDate <= {TS '" + endDate + "'} ").append('\n');
        NCMDbUtil.execute((Context)ctx, (String)ksql.toString());
        NCMDbUtil.createTempTableIndexByPool((TempTablePool)pool, (String)this.T_TMP_CostAdjust, (String)"FSourceBillID", (boolean)false, (boolean)false);
        NCMDbUtil.createTempTableIndexByPool((TempTablePool)pool, (String)this.T_TMP_CostAdjust, (String)"FSourceBillEntryID", (boolean)true, (boolean)false);
        NCMDbUtil.createTempTableIndexByPool((TempTablePool)pool, (String)this.T_TMP_CostAdjust, (String)"FCostCenterID", (boolean)false, (boolean)false);
        NCMDbUtil.createTempTableIndexByPool((TempTablePool)pool, (String)this.T_TMP_CostAdjust, (String)"FCostObjectID", (boolean)false, (boolean)false);
        NCMDbUtil.createTempTableIndexByPool((TempTablePool)pool, (String)this.T_TMP_CostAdjust, (String)"FMaterialID", (boolean)false, (boolean)false);
        return this.T_TMP_CostAdjust;
    }

    public String getInputQtyTable() throws Exception {
        if (this.T_TMP_InputQty != null) {
            return this.T_TMP_InputQty;
        }
        Context ctx = this.getContext();
        TempTablePool pool = this.getTempTablePool();
        String companyId = (String)this.param.get("companyId");
        String periodId = (String)this.param.get("periodId");
        try {
            String tblBalance = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_Balance");
            StringBuffer ksql = new StringBuffer();
            ksql.append("create table T ( \n");
            ksql.append("    FCostCenterID varchar(44), \n");
            ksql.append("    FCostObjectID varchar(44), \n");
            ksql.append("    FQty NUMERIC(21,8) \n");
            ksql.append(") \n");
            this.T_TMP_InputQty = NCMDbUtil.createTempTableByPool((TempTablePool)pool, (String)ksql.toString());
            ksql.setLength(0);
            ksql.append("insert into " + this.T_TMP_InputQty + " ( \n");
            ksql.append("    FCostCenterID, \n");
            ksql.append("    FCostObjectID, \n");
            ksql.append("    FQty \n");
            ksql.append(") \n");
            ksql.append("select \n");
            ksql.append("    FCostCenterID, FCostObjectID, sum(FQty) FQty \n");
            ksql.append("from ( \n");
            ksql.append("    SELECT FCostCenterOrgUnitID FCostCenterID, inputbe.FCostObjectID, inputbe.FQty FQty \n");
            ksql.append("    from T_NCM_InputQtyBill inputb \n");
            ksql.append("    join T_NCM_InputQtyBillEntry inputbe ON inputbe.FParentID = inputb.FID  \n");
            ksql.append("    WHERE inputb.FCompanyOrg = '" + companyId + "' AND inputb.FCalculatePeriod = '" + periodId + "' \n");
            ksql.append("    and inputb.FBillStatus = 4 \n");
            ksql.append("    union all \n");
            ksql.append("    SELECT bal.FCostCenterID, bal.FCostObjectID, bal.FBopWIPQty FQty \n");
            ksql.append("    from " + tblBalance + " bal \n");
            ksql.append("    where bal.FCompanyOrg = '" + companyId + "' AND bal.FCalculatePeriodID = '" + periodId + "' \n");
            ksql.append(") a \n");
            ksql.append("group by FCostCenterID, FCostObjectID \n");
            ksql.append("; \n");
            NCMDbUtil.execute((Context)ctx, (String)ksql.toString());
            NCMDbUtil.createTempTableIndexByPool((TempTablePool)pool, (String)this.T_TMP_InputQty, (String)"FCostCenterID, FCostObjectID", (boolean)true, (boolean)false);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw e;
        }
        return this.T_TMP_InputQty;
    }

    public String getCurrInputQtyTable() throws AllocateException {
        if (this.T_TMP_CurrInputQty != null) {
            return this.T_TMP_CurrInputQty;
        }
        Context ctx = this.getContext();
        TempTablePool pool = this.getTempTablePool();
        String companyId = (String)this.param.get("companyId");
        String periodId = (String)this.param.get("periodId");
        try {
            StringBuffer ksql = new StringBuffer();
            ksql.append("create table T ( \n");
            ksql.append("    FCostCenterID varchar(44), \n");
            ksql.append("    FCostObjectID varchar(44), \n");
            ksql.append("    FQty NUMERIC(21,8) \n");
            ksql.append(") \n");
            this.T_TMP_CurrInputQty = NCMDbUtil.createTempTableByPool((TempTablePool)pool, (String)ksql.toString());
            ksql.setLength(0);
            ksql.append("insert into " + this.T_TMP_CurrInputQty + " ( \n");
            ksql.append("    FCostCenterID, \n");
            ksql.append("    FCostObjectID, \n");
            ksql.append("    FQty \n");
            ksql.append(") \n");
            ksql.append("select \n");
            ksql.append("    FCostCenterID, FCostObjectID, sum(FQty) FQty \n");
            ksql.append("from ( \n");
            ksql.append("    SELECT FCostCenterOrgUnitID FCostCenterID, inputbe.FCostObjectID, inputbe.FQty FQty \n");
            ksql.append("    from T_NCM_InputQtyBill inputb \n");
            ksql.append("    join T_NCM_InputQtyBillEntry inputbe ON inputbe.FParentID = inputb.FID  \n");
            ksql.append("    WHERE inputb.FCompanyOrg = '" + companyId + "' AND inputb.FCalculatePeriod = '" + periodId + "' \n");
            ksql.append("    and inputb.FBillStatus = 4 \n");
            ksql.append(") a \n");
            ksql.append("group by FCostCenterID, FCostObjectID \n");
            ksql.append("; \n");
            NCMDbUtil.execute((Context)ctx, (String)ksql.toString());
            NCMDbUtil.createTempTableIndexByPool((TempTablePool)pool, (String)this.T_TMP_CurrInputQty, (String)"FCostCenterID, FCostObjectID", (boolean)true, (boolean)false);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e);
        }
        return this.T_TMP_CurrInputQty;
    }

    public String getFinishedQtyTable() throws AllocateException {
        if (this.T_TMP_FinishedQty != null) {
            return this.T_TMP_FinishedQty;
        }
        Context ctx = this.getContext();
        TempTablePool pool = this.getTempTablePool();
        try {
            String T_TMP_RecBillCostObject = this.getRecBillCostObjectTable();
            StringBuffer ksql = new StringBuffer();
            ksql.append("create table T ( \n");
            ksql.append("    FCostCenterID VARCHAR(44), \n");
            ksql.append("    FCostObjectID VARCHAR(44), \n");
            ksql.append("    FQty NUMERIC(21,8) \n");
            ksql.append(") \n");
            this.T_TMP_FinishedQty = NCMDbUtil.createTempTableByPool((TempTablePool)pool, (String)ksql.toString());
            ksql.setLength(0);
            ksql.append("insert into " + this.T_TMP_FinishedQty + " ( \n");
            ksql.append("    FCostCenterID, \n");
            ksql.append("    FCostObjectID, \n");
            ksql.append("    FQty \n");
            ksql.append(") \n");
            ksql.append("select \n");
            ksql.append("    FCostCenterID, \n");
            ksql.append("    FCostObjectID, \n");
            ksql.append("    ISNULL(SUM(FBaseQty * ISNULL(FQuotiety,1)),0) FQty ").append('\n');
            ksql.append("from " + T_TMP_RecBillCostObject + " t ").append('\n');
            ksql.append("group by FCostCenterID, FCostObjectID ").append('\n');
            NCMDbUtil.execute((Context)ctx, (String)ksql.toString());
            NCMDbUtil.createTempTableIndexByPool((TempTablePool)pool, (String)this.T_TMP_FinishedQty, (String)"FCostCenterID, FCostObjectID", (boolean)true, (boolean)false);
            NCMDbUtil.createTempTableIndexByPool((TempTablePool)pool, (String)this.T_TMP_FinishedQty, (String)"FCostObjectID", (boolean)false, (boolean)false);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e);
        }
        return this.T_TMP_FinishedQty;
    }

    public String getRecBillCostObjectTable() throws BOSException {
        String T_TMP_CostObject;
        String T_TMP_RecBill;
        if (this.T_TMP_RecMatToCO != null) {
            return this.T_TMP_RecMatToCO;
        }
        TempTablePool pool = this.getTempTablePool();
        StringBuffer ksql = new StringBuffer();
        ksql.append("create table T ( \n");
        ksql.append("    FSourceBillID VARCHAR(44), \n");
        ksql.append("    FSourceBillEntryID VARCHAR(44), \n");
        ksql.append("    FCostCenterID VARCHAR(44), \n");
        ksql.append("    FCostObjectID VARCHAR(44), \n");
        ksql.append("    FMaterialID VARCHAR(44), \n");
        ksql.append("    FIsMainProduct INT, \n");
        ksql.append("    FIsByProduct INT, \n");
        ksql.append("    FQuotiety NUMERIC(21,8), \n");
        ksql.append("    FLot NVARCHAR(80), \n");
        ksql.append("    FOrderID VARCHAR(44), \n");
        ksql.append("    FBaseQty NUMERIC(21,8), \n");
        ksql.append("    FAssistQty NUMERIC(21,8), \n");
        ksql.append("    FQTY NUMERIC(21,8), \n");
        ksql.append("    FUnitActualCost NUMERIC(28,16) DEFAULT 0, \n");
        ksql.append("    FActualCost NUMERIC(19,4) DEFAULT 0 \n");
        ksql.append(") \n");
        this.T_TMP_RecMatToCO = NCMDbUtil.createTempTableByPool((TempTablePool)pool, (String)ksql.toString());
        try {
            T_TMP_RecBill = this.getRecBillTable();
            T_TMP_CostObject = this.getCostObjectTable();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        ksql.setLength(0);
        ksql.append("insert into " + this.T_TMP_RecMatToCO + " ( \n");
        ksql.append("    FSourceBillID, \n");
        ksql.append("    FSourceBillEntryID, \n");
        ksql.append("    FCostCenterID, \n");
        ksql.append("    FCostObjectID, \n");
        ksql.append("    FMaterialID, \n");
        ksql.append("    FIsMainProduct, \n");
        ksql.append("    FIsByProduct, \n");
        ksql.append("    FQuotiety, \n");
        ksql.append("    FLot, \n");
        ksql.append("    FOrderID, \n");
        ksql.append("    FBaseQty, \n");
        ksql.append("    FAssistQty, \n");
        ksql.append("    FQTY, \n");
        ksql.append("    FUnitActualCost, \n");
        ksql.append("    FActualCost \n");
        ksql.append(") \n");
        ksql.append("select \n");
        ksql.append("    t.FSourceBillID, \n");
        ksql.append("    t.FSourceBillEntryID, \n");
        ksql.append("    t.FCostCenterID, \n");
        ksql.append("    co.FCostObjectID, \n");
        ksql.append("    t.FMaterialID, \n");
        ksql.append("    co.FIsMainProduct, \n");
        ksql.append("    co.FIsByProduct, \n");
        ksql.append("    co.FQuotiety, \n");
        ksql.append("    t.FLot, \n");
        ksql.append("    t.FOrderID, \n");
        ksql.append("    t.FBaseQty, \n");
        ksql.append("    t.FAssistQty, \n");
        ksql.append("    t.FQTY, \n");
        ksql.append("    t.FUnitActualCost, \n");
        ksql.append("    t.FActualCost \n");
        ksql.append("from " + T_TMP_RecBill + " t \n");
        ksql.append("join " + T_TMP_CostObject + " co \n");
        ksql.append("\t on co.FMaterialID = t.FMaterialID \n");
        ksql.append("WHERE ( \n");
        ksql.append("    (co.FCalculateMode = 1) \n");
        ksql.append("    or \n");
        ksql.append("    co.FCalculateMode = 3 \n");
        ksql.append("    or \n");
        ksql.append("    (co.FCalculateMode = 4 and isnull(t.FLot,' ') = isnull(co.FBatchNumber,' ')) \n");
        ksql.append("    or \n");
        ksql.append("    (co.FCalculateMode = 7 and co.FOrderID = t.FOrderID) \n");
        ksql.append(") \n");
        NCMDbUtil.execute((Context)this.ctx, (String)ksql.toString());
        NCMDbUtil.createTempTableIndexByPool((TempTablePool)pool, (String)this.T_TMP_RecMatToCO, (String)"FSourceBillEntryID", (boolean)true, (boolean)false);
        ksql.setLength(0);
        ksql.append("insert into " + this.T_TMP_RecMatToCO + " ( \n");
        ksql.append("    FSourceBillID, \n");
        ksql.append("    FSourceBillEntryID, \n");
        ksql.append("    FCostCenterID, \n");
        ksql.append("    FCostObjectID, \n");
        ksql.append("    FMaterialID, \n");
        ksql.append("    FIsMainProduct, \n");
        ksql.append("    FIsByProduct, \n");
        ksql.append("    FQuotiety, \n");
        ksql.append("    FLot, \n");
        ksql.append("    FOrderID, \n");
        ksql.append("    FBaseQty, \n");
        ksql.append("    FAssistQty, \n");
        ksql.append("    FQTY, \n");
        ksql.append("    FUnitActualCost, \n");
        ksql.append("    FActualCost \n");
        ksql.append(") \n");
        ksql.append("select \n");
        ksql.append("    t.FSourceBillID, \n");
        ksql.append("    t.FSourceBillEntryID, \n");
        ksql.append("    t.FCostCenterID, \n");
        ksql.append("    null, \n");
        ksql.append("    t.FMaterialID, \n");
        ksql.append("    1, \n");
        ksql.append("    0, \n");
        ksql.append("    1, \n");
        ksql.append("    t.FLot, \n");
        ksql.append("    t.FOrderID, \n");
        ksql.append("    t.FBaseQty, \n");
        ksql.append("    t.FAssistQty, \n");
        ksql.append("    t.FQTY, \n");
        ksql.append("    t.FUnitActualCost, \n");
        ksql.append("    t.FActualCost \n");
        ksql.append("from " + T_TMP_RecBill + " t \n");
        ksql.append("WHERE not exists ( \n");
        ksql.append("    select 1 from " + this.T_TMP_RecMatToCO + " r \n");
        ksql.append("    where r.FSourceBillEntryID = t.FSourceBillEntryID \n");
        ksql.append(") \n");
        NCMDbUtil.execute((Context)this.ctx, (String)ksql.toString());
        NCMDbUtil.createTempTableIndexByPool((TempTablePool)pool, (String)this.T_TMP_RecMatToCO, (String)"FSourceBillID", (boolean)false, (boolean)false);
        NCMDbUtil.createTempTableIndexByPool((TempTablePool)pool, (String)this.T_TMP_RecMatToCO, (String)"FCostCenterID, FCostObjectID", (boolean)false, (boolean)false);
        NCMDbUtil.createTempTableIndexByPool((TempTablePool)pool, (String)this.T_TMP_RecMatToCO, (String)"FMaterialID", (boolean)false, (boolean)false);
        return this.T_TMP_RecMatToCO;
    }

    public String getRecBillTable() throws BOSException, EASBizException {
        if (this.T_TMP_RecBill != null) {
            return this.T_TMP_RecBill;
        }
        Context ctx = this.getContext();
        TempTablePool pool = this.getTempTablePool();
        String companyId = (String)this.param.get("companyId");
        PeriodInfo period = this.getPeriod();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String beginDate = format.format(period.getBeginDate());
        String endDate = format.format(period.getEndDate()).replaceAll("00:00:00", "23:59:59");
        StringBuffer ksql = new StringBuffer();
        ksql.append("create table T ( \n");
        ksql.append("    FSourceBillID VARCHAR(44), \n");
        ksql.append("    FNumber NVARCHAR(80), \n");
        ksql.append("    FFiVouchered INT, \n");
        ksql.append("    FSourceBillEntryID VARCHAR(44), \n");
        ksql.append("    FSeq INT, \n");
        ksql.append("    FCostCenterID VARCHAR(44), \n");
        ksql.append("    FMaterialID VARCHAR(44), \n");
        ksql.append("    FLot NVARCHAR(80), \n");
        ksql.append("    FOrderID VARCHAR(44), \n");
        ksql.append("    FBaseQty NUMERIC(21,8), \n");
        ksql.append("    FAssistQty NUMERIC(21,8), \n");
        ksql.append("    FQTY NUMERIC(21,8), \n");
        ksql.append("    FUnitActualCost NUMERIC(28,16) DEFAULT 0, \n");
        ksql.append("    FActualCost NUMERIC(19,4) DEFAULT 0 \n");
        ksql.append(") \n");
        this.T_TMP_RecBill = NCMDbUtil.createTempTableByPool((TempTablePool)pool, (String)ksql.toString());
        ksql.setLength(0);
        ksql.append("insert into " + this.T_TMP_RecBill + " ( \n");
        ksql.append("    FSourceBillID, \n");
        ksql.append("    FNumber, \n");
        ksql.append("    FFiVouchered, \n");
        ksql.append("    FSourceBillEntryID, \n");
        ksql.append("    FSeq, \n");
        ksql.append("    FCostCenterID, \n");
        ksql.append("    FMaterialID, \n");
        ksql.append("    FLot, \n");
        ksql.append("    FOrderID, \n");
        ksql.append("    FBaseQty, \n");
        ksql.append("    FAssistQty, \n");
        ksql.append("    FQTY, \n");
        ksql.append("    FUnitActualCost, \n");
        ksql.append("    FActualCost \n");
        ksql.append(") \n");
        ksql.append("select \n");
        ksql.append("    b.FID, \n");
        ksql.append("    b.FNumber, \n");
        ksql.append("    b.FFiVouchered, \n");
        ksql.append("    be.FID, \n");
        ksql.append("    be.FSeq, \n");
        ksql.append("    be.FCostCenterOrgUnitID, \n");
        ksql.append("    be.FMaterialID, \n");
        ksql.append("    be.FLot, \n");
        ksql.append("    be.FManuBillID, \n");
        ksql.append("    be.FBaseQty, \n");
        ksql.append("    be.FAssistQty, \n");
        ksql.append("    be.FQTY, \n");
        ksql.append("    be.FUnitActualCost, \n");
        ksql.append("    be.FActualCost \n");
        ksql.append("from T_IM_ManufactureRecBill b \n");
        ksql.append("join T_SCM_TransactionType tt \n");
        ksql.append("    on b.FTransactionTypeID = tt.FID \n");
        ksql.append("    and tt.FIsManuCostCalculate = 1 \n");
        ksql.append("join T_IM_ManufactureRecBillEntry be \n");
        ksql.append("    on be.FParentID = b.FID \n");
        ksql.append("inner join T_IM_InvUpdateType ut on be.FINVUPDATETYPEID = ut.fid ").append('\n');
        ksql.append("inner join T_IM_STORETYPE st on ut.FSTORETYPEID = st.fid and st.FISFORWARDAMT = 1 ").append('\n');
        ksql.append("join t_org_costcenter cc \n");
        ksql.append("    on cc.fid = be.FCostCenterOrgUnitID \n");
        ksql.append("    and cc.FCostCenterType = 0 \n");
        ksql.append("where \n");
        ksql.append("    b.FBASESTATUS = 4 \n");
        ksql.append("    and b.FYear = " + period.getPeriodYear() + " ").append('\n');
        ksql.append("    and b.FPeriod = " + period.getPeriodNumber() + " ").append('\n');
        ksql.append("    and be.FCompanyOrgUnitID = '" + companyId + "' \n");
        ksql.append("    and be.FBizDate >= {TS '" + beginDate + "'} ").append('\n');
        ksql.append("    and be.FBizDate <= {TS '" + endDate + "'} ").append('\n');
        NCMDbUtil.execute((Context)ctx, (String)ksql.toString());
        NCMDbUtil.createTempTableIndexByPool((TempTablePool)pool, (String)this.T_TMP_RecBill, (String)"FSourceBillID", (boolean)false, (boolean)false);
        NCMDbUtil.createTempTableIndexByPool((TempTablePool)pool, (String)this.T_TMP_RecBill, (String)"FSourceBillEntryID", (boolean)true, (boolean)false);
        NCMDbUtil.createTempTableIndexByPool((TempTablePool)pool, (String)this.T_TMP_RecBill, (String)"FMaterialID, FLot", (boolean)false, (boolean)false);
        NCMDbUtil.createTempTableIndexByPool((TempTablePool)pool, (String)this.T_TMP_RecBill, (String)"FMaterialID, FOrderID", (boolean)false, (boolean)false);
        return this.T_TMP_RecBill;
    }

    public String getAllocStdSetByWIPTable(boolean isCostCenter, boolean isCostObject, boolean isCostItem) throws BOSException {
        String key = isCostCenter + "_" + isCostObject + "_" + isCostItem;
        if (this.T_TMP_AllocStdSetByWIPs.containsKey(key)) {
            return (String)this.T_TMP_AllocStdSetByWIPs.get(key);
        }
        Context ctx = this.getContext();
        TempTablePool pool = this.getTempTablePool();
        String companyId = (String)this.param.get("companyId");
        String periodId = (String)this.param.get("periodId");
        String T_TMP_AllocStdSetByWIP = null;
        try {
            StringBuffer ksql = new StringBuffer();
            ksql.append("create table T ( \n");
            if (isCostCenter) {
                ksql.append("    FCostCenterID VARCHAR(44), \n");
            }
            if (isCostObject) {
                ksql.append("    FCostObjectID VARCHAR(44), \n");
            }
            if (isCostItem) {
                ksql.append("    FCostItemID VARCHAR(44), \n");
            }
            ksql.append("    FAllocStdID VARCHAR(44) \n");
            ksql.append(") \n");
            T_TMP_AllocStdSetByWIP = NCMDbUtil.createTempTableByPool((TempTablePool)pool, (String)ksql.toString());
            ksql.setLength(0);
            ksql.append("insert into " + T_TMP_AllocStdSetByWIP + " ( \n");
            if (isCostCenter) {
                ksql.append("    FCostCenterID, \n");
            }
            if (isCostObject) {
                ksql.append("    FCostObjectID, \n");
            }
            if (isCostItem) {
                ksql.append("    FCostItemID, \n");
            }
            ksql.append("    FAllocStdID \n");
            ksql.append(") \n");
            ksql.append("select distinct \n");
            if (isCostCenter) {
                ksql.append("    FCostCenterID, \n");
            }
            if (isCostObject) {
                ksql.append("    FCostObjectID, \n");
            }
            if (isCostItem) {
                ksql.append("    FCostItemID, \n");
            }
            ksql.append("    FAllocStdID \n");
            ksql.append("from T_NCM_AllocStdSetByWIP \n");
            ksql.append("where FCompanyID = '" + companyId + "' \n");
            ksql.append("    and FCalculatePeriodID = '" + periodId + "' \n");
            ksql.append("    and FAllocStdID is not null \n");
            if (isCostCenter) {
                ksql.append("    and FCostCenterID is not null \n");
            } else {
                ksql.append("    and FCostCenterID is null \n");
            }
            if (isCostObject) {
                ksql.append("    and FCostObjectID is not null \n");
            } else {
                ksql.append("    and FCostObjectID is null \n");
            }
            if (isCostItem) {
                ksql.append("    and FCostItemID is not null \n");
            } else {
                ksql.append("    and FCostItemID is null \n");
            }
            NCMDbUtil.execute((Context)ctx, (String)ksql.toString());
            this.T_TMP_AllocStdSetByWIPs.put(key, T_TMP_AllocStdSetByWIP);
            if (isCostCenter || isCostObject || isCostItem) {
                ksql.setLength(0);
                if (isCostCenter) {
                    ksql.append("FCostCenterID,");
                }
                if (isCostObject) {
                    ksql.append("FCostObjectID,");
                }
                if (isCostItem) {
                    ksql.append("FCostItemID,");
                }
                ksql.deleteCharAt(ksql.length() - 1);
                NCMDbUtil.createTempTableIndexByPool((TempTablePool)pool, (String)T_TMP_AllocStdSetByWIP, (String)ksql.toString(), (boolean)false, (boolean)false);
            }
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw e;
        }
        return T_TMP_AllocStdSetByWIP;
    }

    public String getUserDefinedDataTable(String allocStdUnitID, boolean isCostCenter, boolean isCostObject, boolean isCostItem, boolean isMaterial) throws AllocateException {
        String key = allocStdUnitID + "_" + isCostCenter + "_" + isCostObject + "_" + isCostItem + "_" + isMaterial;
        if (this.T_TMP_UserDefinedDatas.containsKey(key)) {
            return (String)this.T_TMP_UserDefinedDatas.get(key);
        }
        Context ctx = this.getContext();
        TempTablePool pool = this.getTempTablePool();
        String companyId = (String)this.param.get("companyId");
        String periodId = (String)this.param.get("periodId");
        String T_TMP_UserDefinedData = null;
        try {
            StringBuffer ksql = new StringBuffer();
            ksql.append("create table T ( \n");
            if (isCostCenter) {
                ksql.append("    FCostCenterID VARCHAR(44), \n");
            }
            if (isCostObject) {
                ksql.append("    FCostObjectID VARCHAR(44), \n");
            }
            if (isCostItem) {
                ksql.append("    FCostItemID VARCHAR(44), \n");
            }
            if (isMaterial) {
                ksql.append("    FMaterialID VARCHAR(44), \n");
            }
            ksql.append("    FQty NUMERIC(21,8) \n");
            ksql.append(") \n");
            T_TMP_UserDefinedData = NCMDbUtil.createTempTableByPool((TempTablePool)pool, (String)ksql.toString());
            ksql.setLength(0);
            ksql.append("insert into " + T_TMP_UserDefinedData + " ( \n");
            if (isCostCenter) {
                ksql.append("    FCostCenterID, \n");
            }
            if (isCostObject) {
                ksql.append("    FCostObjectID, \n");
            }
            if (isCostItem) {
                ksql.append("    FCostItemID, \n");
            }
            if (isMaterial) {
                ksql.append("    FMaterialID, \n");
            }
            ksql.append("    FQty \n");
            ksql.append(") \n");
            ksql.append("select \n");
            if (isCostCenter) {
                ksql.append("    FCostCenterID, \n");
            }
            if (isCostObject) {
                ksql.append("    FCostObjectID, \n");
            }
            if (isCostItem) {
                ksql.append("    FCostItemID, \n");
            }
            if (isMaterial) {
                ksql.append("    FMaterialID, \n");
            }
            ksql.append("    sum(FQty) FQty \n");
            ksql.append("from T_NCM_UserDefinedData \n");
            ksql.append("where FCompanyID = '" + companyId + "' \n");
            ksql.append("and FCalculatePeriodID = '" + periodId + "' \n");
            ksql.append("and FAllocStdUnitID = '" + allocStdUnitID + "' \n");
            if (!isCostObject) {
                ksql.append("and FCostObjectID is null \n");
            }
            if (isCostCenter || isCostObject || isCostItem || isMaterial) {
                ksql.append("group by ");
                if (isCostCenter) {
                    ksql.append("FCostCenterID,");
                }
                if (isCostObject) {
                    ksql.append("FCostObjectID,");
                }
                if (isCostItem) {
                    ksql.append("FCostItemID,");
                }
                if (isMaterial) {
                    ksql.append("FMaterialID,");
                }
                ksql.deleteCharAt(ksql.length() - 1);
                ksql.append(" \n");
            }
            NCMDbUtil.execute((Context)ctx, (String)ksql.toString());
            this.T_TMP_UserDefinedDatas.put(key, T_TMP_UserDefinedData);
            if (isCostCenter || isCostObject || isCostItem || isMaterial) {
                ksql.setLength(0);
                if (isCostCenter) {
                    ksql.append("FCostCenterID,");
                }
                if (isCostObject) {
                    ksql.append("FCostObjectID,");
                }
                if (isCostItem) {
                    ksql.append("FCostItemID,");
                }
                if (isMaterial) {
                    ksql.append("FMaterialID,");
                }
                ksql.deleteCharAt(ksql.length() - 1);
                NCMDbUtil.createTempTableIndexByPool((TempTablePool)pool, (String)T_TMP_UserDefinedData, (String)ksql.toString(), (boolean)false, (boolean)false);
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e);
        }
        return T_TMP_UserDefinedData;
    }

    public String getWIPCountMaterial() throws AllocateException {
        if (this.T_TMP_WIPCountMaterial != null) {
            return this.T_TMP_WIPCountMaterial;
        }
        String companyId = (String)this.param.get("companyId");
        String periodId = (String)this.param.get("periodId");
        Context ctx = this.getContext();
        TempTablePool pool = this.getTempTablePool();
        try {
            StringBuffer ksql = new StringBuffer();
            ksql.append("create table T ( \n");
            ksql.append("    FCostCenterID VARCHAR(44), \n");
            ksql.append("    FCostObjectID VARCHAR(44), \n");
            ksql.append("    FMaterialID VARCHAR(44), \n");
            ksql.append("    FQty NUMERIC(21,8) \n");
            ksql.append(") \n");
            this.T_TMP_WIPCountMaterial = NCMDbUtil.createTempTableByPool((TempTablePool)pool, (String)ksql.toString());
            ksql.setLength(0);
            ksql.append("insert into " + this.T_TMP_WIPCountMaterial + " ( \n");
            ksql.append("    FCostCenterID, \n");
            ksql.append("    FCostObjectID, \n");
            ksql.append("    FMaterialID, \n");
            ksql.append("    FQty \n");
            ksql.append(") \n");
            ksql.append("select \n");
            ksql.append("    FCostCenterID, \n");
            ksql.append("    FCostObjectID, \n");
            ksql.append("    FCostObjectID, \n");
            ksql.append("    sum(isnull(FBaseQty,0)) FQty ").append('\n');
            ksql.append("from T_NCM_WIPCountingMaterial t ").append('\n');
            ksql.append("where FCompanyOrg = '" + companyId + "' \n");
            ksql.append("and FCalculatePeriod = '" + periodId + "' \n");
            ksql.append("group by FCostCenterID, FCostObjectID,FMaterialID ").append('\n');
            NCMDbUtil.execute((Context)ctx, (String)ksql.toString());
            NCMDbUtil.createTempTableIndexByPool((TempTablePool)pool, (String)this.T_TMP_WIPCountMaterial, (String)"FCostCenterID, FCostObjectID", (boolean)false, (boolean)false);
            NCMDbUtil.createTempTableIndexByPool((TempTablePool)pool, (String)this.T_TMP_WIPCountMaterial, (String)"FMaterialID", (boolean)false, (boolean)false);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e);
        }
        return this.T_TMP_WIPCountMaterial;
    }

    public String getSumHourTable() throws AllocateException {
        if (this.T_TMP_SumHour != null) {
            return this.T_TMP_SumHour;
        }
        String companyId = (String)this.param.get("companyId");
        String periodId = (String)this.param.get("periodId");
        Context ctx = this.getContext();
        TempTablePool pool = this.getTempTablePool();
        try {
            StringBuffer ksql = new StringBuffer();
            ksql.append("create table T ( \n");
            ksql.append("    FCompanyOrg VARCHAR(44), \n");
            ksql.append("    FCalculatePeriod VARCHAR(44), \n");
            ksql.append("    FCostCenterID VARCHAR(44), \n");
            ksql.append("    FCostObjectID VARCHAR(44), \n");
            ksql.append("    FHour NUMERIC(28,10) \n");
            ksql.append(") \n");
            this.T_TMP_SumHour = NCMDbUtil.createTempTableByPool((TempTablePool)pool, (String)ksql.toString());
            ksql.setLength(0);
            ksql.append("insert into " + this.T_TMP_SumHour + " ( \n");
            ksql.append("    FCompanyOrg, \n");
            ksql.append("    FCalculatePeriod, \n");
            ksql.append("    FCostCenterID, \n");
            ksql.append("    FCostObjectID, \n");
            ksql.append("    FHour \n");
            ksql.append(") \n");
            ksql.append("  SELECT   h.FCompanyOrg, \n");
            ksql.append("                                  h.FCalculatePeriod, \n");
            ksql.append("                                  h.FCostCenterID, \n");
            ksql.append("                                  e.FCostObjectID, \n");
            ksql.append("                                  SUM(e.FhourSecond) AS sHOUR \n");
            ksql.append("                         FROM     T_NCM_Actualhour h \n");
            ksql.append("                                  INNER JOIN T_NCM_ActualhourEntry e \n");
            ksql.append("                                    ON h.FID = e.FParentID \n");
            ksql.append("                         WHERE    h.FCompanyOrg = '" + companyId + "' \n");
            ksql.append("                                  AND h.FCalculatePeriod = '" + periodId + "' \n");
            ksql.append("                                  AND h.FBillStatus = 4 \n");
            ksql.append("                         GROUP BY h.FCompanyOrg,h.FCalculatePeriod,h.Fcostcenterid,e.FCostObjectID ");
            NCMDbUtil.execute((Context)ctx, (String)ksql.toString());
            NCMDbUtil.createTempTableIndexByPool((TempTablePool)pool, (String)this.T_TMP_SumHour, (String)"FCompanyOrg, FCalculatePeriod, FCostCenterID, FCostObjectID", (boolean)false, (boolean)false);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e);
        }
        return this.T_TMP_SumHour;
    }
}

