/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.assistant.CostObjectCollection;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.ncm.ExpenseCollection;
import com.kingdee.eas.basedata.ncm.ExpenseCompanyInfoCollection;
import com.kingdee.eas.basedata.ncm.ExpenseCompanyInfoFactory;
import com.kingdee.eas.basedata.ncm.ExpenseFactory;
import com.kingdee.eas.basedata.ncm.IExpense;
import com.kingdee.eas.basedata.ncm.utils.BDCMUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.bill.NcmBillException;
import com.kingdee.eas.ncm.bill.app.AbstractWIPCountingMaterialControllerBean;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class WIPCountingMaterialControllerBean
extends AbstractWIPCountingMaterialControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ncm.bill.app.WIPCountingMaterialControllerBean");
    private static final String RESOURCE_URL = "com.kingdee.eas.ncm.bill.WIPCountingMaterialResource";
    private static final String KEY_METHODRESULT_OF_UPDATEDATA = WIPCountingMaterialControllerBean.class.getName() + "_updateData_result";
    public static final String SysExpense = "ml7t5QEaEADgAAwawKgRe0olWCc=";
    private static final DecimalFormat format = new DecimalFormat("###0.000000000000000000000");

    public String getMainTableName(Context ctx, IObjectPK[] model) throws EASBizException, BOSException {
        return "T_NCM_WIPCountingMaterial";
    }

    protected void checkNumber(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    protected boolean _checkNumberBlank(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        return true;
    }

    protected boolean _checkNumberDup(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        return true;
    }

    protected void _delete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        IObjectPK pk = LogUtil.beginLog((Context)ctx, (String)"delete", (BOSObjectType)this.getBOSType(), null, (String)ResourceBase.getString((String)RESOURCE_URL, (String)"LOG_DELETE", (Locale)ctx.getLocale()), (String)"ncm_WIPCountingMaterial_delete");
        this.innerDelete(ctx, arrayPK);
        LogUtil.afterLog((Context)ctx, (IObjectPK)pk);
    }

    @Override
    public Map updateData(Context ctx, List list) throws BOSException, EASBizException {
        try {
            super.updateData(ctx, list);
        }
        catch (NcmBillException e) {
            logger.error((Object)e.getMessage());
        }
        Map result = (Map)ctx.remove((Object)KEY_METHODRESULT_OF_UPDATEDATA);
        return result;
    }

    @Override
    protected Map _updateData(Context ctx, List list) throws BOSException, EASBizException {
        IObjectPK pk = LogUtil.beginLog((Context)ctx, (String)"updateData", (BOSObjectType)this.getBOSType(), null, (String)ResourceBase.getString((String)RESOURCE_URL, (String)"LOG_UPDATE", (Locale)ctx.getLocale()), (String)"ncm_WIPCountingMaterial_update");
        HashMap<String, Object> result = new HashMap<String, Object>();
        String FControlUnitID = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        String companyID = null;
        String periodID = null;
        String FUserID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            StringBuffer sql = new StringBuffer();
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.createStatement();
            for (int i = 0; i < list.size(); ++i) {
                Map info = (Map)list.get(i);
                String id = (String)info.get("id");
                if (companyID == null && info.get("companyOrg.id") != null) {
                    companyID = (String)info.get("companyOrg.id");
                }
                if (companyID == null) {
                    companyID = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
                }
                if (periodID == null && info.get("calculatePeriod.id") != null) {
                    periodID = (String)info.get("calculatePeriod.id");
                }
                if (periodID == null) {
                    periodID = NCMUtils.GetCurrentPeriod((Context)ctx, (String)companyID).getId().toString();
                }
                if (id == null) {
                    sql.append("insert into ").append(this.getMainTableName(ctx, null)).append(" ( \n");
                    sql.append("    FID,FCompanyOrg,FCalculatePeriod, \n");
                    sql.append("    FCostCenterID, \n");
                    sql.append("    FMaterialID,FBatch,FUnitID, \n");
                    sql.append("    FQty,FBaseQty,FAssistQty,FAmount, \n");
                    sql.append("    FCostObjectID,FCostObjectSuiteID,FCostItemID, \n");
                    sql.append("    FRemark_" + loc + ", \n");
                    sql.append("    FIsInWH, \n");
                    sql.append("    FSourceType, \n");
                    sql.append("    FFlag, \n");
                    sql.append("    FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime, \n");
                    sql.append("    FControlUnitID \n");
                    sql.append(") \n");
                    sql.append("values ( \n");
                    sql.append("'").append(BOSUuid.create((BOSObjectType)this.getBOSType())).append("', \n");
                    sql.append("'").append(companyID).append("', \n");
                    sql.append("'").append(periodID).append("', \n");
                    if (info.get("costCenter.id") != null) {
                        sql.append("'").append(info.get("costCenter.id")).append("', \n");
                    } else {
                        sql.append("null, \n");
                    }
                    if (info.get("material.id") != null) {
                        sql.append("'").append(info.get("material.id")).append("', \n");
                    } else {
                        sql.append("null, \n");
                    }
                    if (info.get("batch") != null) {
                        sql.append("'").append(info.get("batch")).append("', \n");
                    } else {
                        sql.append("null, \n");
                    }
                    if (info.get("unit.id") != null) {
                        sql.append("'").append(info.get("unit.id")).append("', \n");
                    } else {
                        sql.append("null, \n");
                    }
                    if (info.get("qty") != null && info.get("qty") instanceof BigDecimal) {
                        sql.append(format.format(((BigDecimal)info.get("qty")).doubleValue())).append(", \n");
                    } else {
                        sql.append("null, \n");
                    }
                    if (info.get("baseQty") != null && info.get("baseQty") instanceof BigDecimal) {
                        sql.append(format.format(((BigDecimal)info.get("baseQty")).doubleValue())).append(", \n");
                    } else {
                        sql.append("null, \n");
                    }
                    if (info.get("assistQty") != null && info.get("assistQty") instanceof BigDecimal) {
                        sql.append(format.format(((BigDecimal)info.get("assistQty")).doubleValue())).append(", \n");
                    } else {
                        sql.append("null, \n");
                    }
                    if (info.get("amount") != null && info.get("amount") instanceof BigDecimal) {
                        sql.append(format.format(((BigDecimal)info.get("amount")).doubleValue())).append(", \n");
                    } else {
                        sql.append("null, \n");
                    }
                    if (info.get("costObject.id") != null) {
                        sql.append("'").append(info.get("costObject.id")).append("', \n");
                    } else {
                        sql.append("null, \n");
                    }
                    if (info.get("costObjectSuite.id") != null) {
                        sql.append("'").append(info.get("costObjectSuite.id")).append("', \n");
                    } else {
                        sql.append("null, \n");
                    }
                    if (info.get("costItem.id") != null) {
                        sql.append("'").append(info.get("costItem.id")).append("', \n");
                    } else {
                        sql.append("null, \n");
                    }
                    if (info.get("remark") != null) {
                        sql.append("'").append(info.get("remark")).append("', \n");
                    } else {
                        sql.append("null, \n");
                    }
                    if (info.get("isInWH") != null && info.get("isInWH") instanceof Boolean) {
                        if (((Boolean)info.get("isInWH")).booleanValue()) {
                            sql.append("1, \n");
                        } else {
                            sql.append("0, \n");
                        }
                    } else {
                        sql.append("0, \n");
                    }
                    sql.append("10, \n");
                    sql.append("0, \n");
                    sql.append("'").append(FUserID).append("', \n");
                    sql.append("GetDate(), \n");
                    sql.append("'").append(FUserID).append("', \n");
                    sql.append("GetDate(), \n");
                    sql.append("'").append(FControlUnitID).append("' \n");
                    sql.append(") \n");
                } else {
                    sql.append("update ").append(this.getMainTableName(ctx, null)).append(" \n");
                    sql.append("set \n");
                    if (info.containsKey("costCenter.id")) {
                        if (info.get("costCenter.id") != null) {
                            sql.append("FCostCenterID = '").append(info.get("costCenter.id")).append("', \n");
                        } else {
                            sql.append("FCostCenterID = null, \n");
                        }
                    }
                    if (info.containsKey("material.id")) {
                        if (info.get("material.id") != null) {
                            sql.append("FMaterialID = '").append(info.get("material.id")).append("', \n");
                        } else {
                            sql.append("FMaterialID = null, \n");
                        }
                    }
                    if (info.containsKey("batch")) {
                        if (info.get("batch") != null) {
                            sql.append("FBatch = '").append(info.get("batch")).append("', \n");
                        } else {
                            sql.append("FBatch = null, \n");
                        }
                    }
                    if (info.containsKey("unit.id")) {
                        if (info.get("unit.id") != null) {
                            sql.append("FUnitID = '").append(info.get("unit.id")).append("', \n");
                        } else {
                            sql.append("FUnitID = null, \n");
                        }
                    }
                    if (info.containsKey("qty")) {
                        if (info.get("qty") != null && info.get("qty") instanceof BigDecimal) {
                            sql.append("FQty = ").append(format.format(((BigDecimal)info.get("qty")).doubleValue())).append(", \n");
                        } else {
                            sql.append("FQty = null, \n");
                        }
                    }
                    if (info.containsKey("baseQty")) {
                        if (info.get("baseQty") != null && info.get("baseQty") instanceof BigDecimal) {
                            sql.append("FBaseQty = ").append(format.format(((BigDecimal)info.get("baseQty")).doubleValue())).append(", \n");
                        } else {
                            sql.append("FBaseQty = null, \n");
                        }
                    }
                    if (info.containsKey("assistQty")) {
                        if (info.get("assistQty") != null && info.get("assistQty") instanceof BigDecimal) {
                            sql.append("FAssistQty = ").append(format.format(((BigDecimal)info.get("assistQty")).doubleValue())).append(", \n");
                        } else {
                            sql.append("FAssistQty = null, \n");
                        }
                    }
                    if (info.containsKey("amount")) {
                        if (info.get("amount") != null && info.get("amount") instanceof BigDecimal) {
                            sql.append("FAmount = ").append(format.format(((BigDecimal)info.get("amount")).doubleValue())).append(", \n");
                        } else {
                            sql.append("FAmount = null, \n");
                        }
                    }
                    if (info.containsKey("costObject.id")) {
                        if (info.get("costObject.id") != null) {
                            sql.append("FCostObjectID = '").append(info.get("costObject.id")).append("', \n");
                        } else {
                            sql.append("FCostObjectID = null, \n");
                        }
                    }
                    if (info.containsKey("costObjectSuite.id")) {
                        if (info.get("costObjectSuite.id") != null) {
                            sql.append("FCostObjectSuiteID = '").append(info.get("costObjectSuite.id")).append("', \n");
                        } else {
                            sql.append("FCostObjectSuiteID = null, \n");
                        }
                    }
                    if (info.containsKey("costItem.id")) {
                        if (info.get("costItem.id") != null) {
                            sql.append("FCostItemID = '").append(info.get("costItem.id")).append("', \n");
                        } else {
                            sql.append("FCostItemID = null, \n");
                        }
                    }
                    if (info.containsKey("remark")) {
                        if (info.get("remark") != null) {
                            sql.append("FRemark_" + loc + " = '").append(info.get("remark")).append("', \n");
                        } else {
                            sql.append("FRemark_" + loc + " = null, \n");
                        }
                    }
                    if (info.get("isInWH") != null) {
                        if (info.get("isInWH") instanceof Boolean) {
                            if (((Boolean)info.get("isInWH")).booleanValue()) {
                                sql.append("FIsInWH = 1, \n");
                            } else {
                                sql.append("FIsInWH = 0, \n");
                            }
                        } else {
                            sql.append("FIsInWH = 0, \n");
                        }
                    }
                    sql.append("FFlag = 1, \n");
                    sql.append("FLastUpdateTime = GetDate() \n");
                    sql.append("where FID = \n");
                    sql.append("'").append(id).append("'");
                }
                stmt.addBatch(sql.toString());
                sql.setLength(0);
            }
            stmt.executeBatch();
            sql.append("select \n");
            sql.append("top 1 \n");
            sql.append("cc.FNumber as FCostCenterNumber, \n");
            sql.append("mat.FNumber as FMaterialNumber, \n");
            sql.append("co.FNumber as FCostObjectNumber, \n");
            sql.append("cos.FNumber as FCostObjectSuiteNumber, \n");
            sql.append("ci.FNumber as FCostItemNumber, \n");
            sql.append("cc.FName_" + loc + " as FCostCenterName, \n");
            sql.append("mat.FName_" + loc + " as FMaterialName, \n");
            sql.append("co.FName_" + loc + " as FCostObjectName, \n");
            sql.append("cos.FName_" + loc + " as FCostObjectSuiteName, \n");
            sql.append("ci.FName_" + loc + " as FCostItemName, \n");
            sql.append("t.FBatch as FBatch \n");
            sql.append("from " + this.getMainTableName(ctx, null) + " as t \n");
            sql.append("left join T_ORG_CostCenter cc on cc.fid = t.FCostCenterID \n");
            sql.append("left join T_BD_Material mat on mat.fid = t.FMaterialID \n");
            sql.append("left join T_BD_CostObject co on co.fid = t.FCostObjectID \n");
            sql.append("left join T_NCM_CostObjectSuite cos on mat.fid = t.FCostObjectSuiteID \n");
            sql.append("left join T_NCM_CostItem ci on ci.fid = t.FCostItemID \n");
            sql.append("where t.FCompanyOrg = '" + companyID + "' and t.FCalculatePeriod = '" + periodID + "' \n");
            sql.append("and EXISTS ( \n");
            sql.append("select 1 from " + this.getMainTableName(ctx, null) + " as wip \n");
            sql.append("where \n");
            sql.append("t.FID != wip.FID \n");
            sql.append("and t.FCompanyOrg = wip.FCompanyOrg \n");
            sql.append("and t.FCalculatePeriod = wip.FCalculatePeriod \n");
            sql.append("and t.FCostCenterID = wip.FCostCenterID \n");
            sql.append("and t.FMaterialID = wip.FMaterialID \n");
            sql.append("and (t.FBatch = wip.FBatch or (t.FBatch is null and wip.FBatch is null)) \n");
            sql.append("and \n");
            sql.append("( \n");
            sql.append("\tt.FCostObjectID = wip.FCostObjectID \n");
            sql.append("\tor \n");
            sql.append("\t( \n");
            sql.append("\t\t(t.FCostObjectID is null and wip.FCostObjectID is null) \n");
            sql.append("\t\tand \n");
            sql.append("\t\t(t.FCostObjectSuiteID = wip.FCostObjectSuiteID or (t.FCostObjectSuiteID is null and wip.FCostObjectSuiteID is null)) \n");
            sql.append("\t) \n");
            sql.append(") \n");
            sql.append("and (t.FCostItemID = wip.FCostItemID or (t.FCostItemID is null and wip.FCostItemID is null)) \n");
            sql.append(") \n");
            rs = stmt.executeQuery(sql.toString());
            if (rs.next()) {
                result.put("error_type", 1);
                result.put("costCenter.number", rs.getString("FCostCenterNumber"));
                result.put("costCenter.name", rs.getString("FCostCenterName"));
                result.put("material.number", rs.getString("FMaterialNumber"));
                result.put("material.name", rs.getString("FMaterialName"));
                result.put("batch", rs.getString("FBatch"));
                result.put("costObject.number", rs.getString("FCostObjectNumber"));
                result.put("costObject.name", rs.getString("FCostObjectName"));
                result.put("costObjectSuite.number", rs.getString("FCostObjectSuiteNumber"));
                result.put("costObjectSuite.name", rs.getString("FCostObjectSuiteName"));
                result.put("costItem.number", rs.getString("FCostItemNumber"));
                result.put("costItem.name", rs.getString("FCostItemName"));
                ctx.put((Object)KEY_METHODRESULT_OF_UPDATEDATA, result);
                throw new NcmBillException(NcmBillException.OVER);
            }
            SQLUtils.cleanup((ResultSet)rs);
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        LogUtil.afterLog((Context)ctx, (IObjectPK)pk);
        return null;
    }

    public String buildSqlFromIds(Set ids, boolean appendQuote) {
        StringBuffer idsSql = new StringBuffer();
        if (ids != null && ids.size() > 0) {
            idsSql.append("(");
            Iterator it = ids.iterator();
            while (it.hasNext()) {
                if (appendQuote) {
                    idsSql.append("'");
                }
                idsSql.append(it.next());
                if (appendQuote) {
                    idsSql.append("'");
                }
                idsSql.append(",");
            }
            idsSql.deleteCharAt(idsSql.length() - 1);
            idsSql.append(")");
        }
        return idsSql.toString();
    }

    @Override
    protected boolean _isDataExists(Context ctx, Map param) throws BOSException, EASBizException {
        String companyId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        PeriodInfo period = NCMUtils.GetCurrentPeriod((Context)ctx, (String)companyId);
        String periodId = period.getId().toString();
        Set costCenterIds = null;
        if (param.get("costCenterIds") != null && param.get("costCenterIds") instanceof Set) {
            costCenterIds = (Set)param.get("costCenterIds");
        }
        HashSet<String> sourceTypes = new HashSet<String>();
        sourceTypes.add(String.valueOf(20));
        sourceTypes.add(String.valueOf(30));
        sourceTypes.add(String.valueOf(40));
        if (param.get("commonMatReq") != null) {
            sourceTypes.remove(String.valueOf(20));
        } else if (param.get("manuRec") != null) {
            sourceTypes.remove(String.valueOf(30));
        } else if (param.get("orderWIP") != null) {
            sourceTypes.remove(String.valueOf(40));
        }
        StringBuffer ksql = new StringBuffer();
        ksql.append("select top 1 1 from T_NCM_WIPCountingMaterial \n");
        ksql.append("where FCompanyOrg = '" + companyId + "' \n");
        ksql.append("and FCalculatePeriod = '" + periodId + "' \n");
        if (costCenterIds != null && costCenterIds.size() > 0) {
            ksql.append("and FCostCenterID in " + this.buildSqlFromIds(costCenterIds, true) + " \n");
        }
        ksql.append("and FSourceType in " + this.buildSqlFromIds(sourceTypes, false) + " \n");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)ksql.toString());
            return rs.next();
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new SQLDataException(e);
        }
    }

    @Override
    protected void _genData(Context ctx, Map param) throws BOSException, EASBizException {
        IObjectPK pk = LogUtil.beginLog((Context)ctx, (String)"genData", (BOSObjectType)this.getBOSType(), null, (String)ResourceBase.getString((String)RESOURCE_URL, (String)"LOG_GEN", (Locale)ctx.getLocale()), (String)"ncm_WIPCountingMaterial_gen");
        String companyId = null;
        if (param.containsKey("CompanyID")) {
            companyId = (String)param.get("CompanyID");
        }
        if (companyId == null) {
            companyId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        }
        PeriodInfo period = NCMUtils.GetCurrentPeriod((Context)ctx, (String)companyId);
        String periodId = period.getId().toString();
        Set costCenterIds = null;
        if (param.get("costCenterIds") != null && param.get("costCenterIds") instanceof Set) {
            costCenterIds = (Set)param.get("costCenterIds");
        }
        HashSet<String> sourceTypes = new HashSet<String>();
        sourceTypes.add(String.valueOf(20));
        sourceTypes.add(String.valueOf(30));
        sourceTypes.add(String.valueOf(40));
        if (param.get("commonMatReq") != null) {
            sourceTypes.remove(String.valueOf(20));
        } else if (param.get("manuRec") != null) {
            sourceTypes.remove(String.valueOf(30));
        } else if (param.get("orderWIP") != null) {
            sourceTypes.remove(String.valueOf(40));
        }
        StringBuffer ksql = new StringBuffer();
        ksql.append("delete from T_NCM_WIPCountingMaterial \n");
        ksql.append("where FCompanyOrg = '" + companyId + "' \n");
        ksql.append("and FCalculatePeriod = '" + periodId + "' \n");
        if (costCenterIds != null && costCenterIds.size() > 0) {
            ksql.append("and FCostCenterID in " + this.buildSqlFromIds(costCenterIds, true) + " \n");
        }
        ksql.append("and FSourceType in " + this.buildSqlFromIds(sourceTypes, false) + " \n");
        DbUtil.execute((Context)ctx, (String)ksql.toString());
        if (param.get("commonMatReq") != null) {
            this.genDataForCommonMatReq(ctx, param);
        } else if (param.get("manuRec") != null) {
            this.genDataForOrderMatReq(ctx, param);
        } else if (param.get("orderWIP") != null) {
            this.genDataForOrderWIP(ctx, param);
        }
        LogUtil.afterLog((Context)ctx, (IObjectPK)pk);
    }

    private String getDefaultCostItemID(Context ctx, String companyId) throws BOSException, EASBizException {
        String FCostItemID = "null";
        IExpense iExpense = ExpenseFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo dFilter = iExpense.getDatabaseDFilter((IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId()), "id", "CU.id");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)SysExpense));
        filter.mergeFilter(dFilter, "and");
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        view.setSelector(sic);
        ExpenseCollection eColl = iExpense.getExpenseCollection(view);
        if (eColl != null && eColl.size() > 0) {
            CostItemInfo costItem;
            view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("expense.id", (Object)SysExpense));
            filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)companyId));
            view.setFilter(filter);
            sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("costItem.id");
            sic.add("costItem.number");
            sic.add("costItem.name");
            view.setSelector(sic);
            ExpenseCompanyInfoCollection ecColl = ExpenseCompanyInfoFactory.getLocalInstance((Context)ctx).getExpenseCompanyInfoCollection(view);
            if (ecColl != null && ecColl.size() > 0 && (costItem = ecColl.get(0).getCostItem()) != null && costItem.getId() != null) {
                FCostItemID = "'" + costItem.getId().toString() + "'";
            }
        }
        return FCostItemID;
    }

    private String getShareCostObjectId(Context ctx, String companyId) throws BOSException {
        String shareCostObjectId = "SCOID";
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)"SCOID"));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        view.setSelector(selector);
        CostObjectCollection coll = CostObjectFactory.getLocalInstance((Context)ctx).getCostObjectCollection(view);
        if (coll.size() > 0) {
            shareCostObjectId = coll.get(0).getId().toString();
        }
        return shareCostObjectId;
    }

    protected void genDataForCommonMatReq(Context ctx, Map param) throws BOSException, EASBizException {
        String FControlUnitID = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        String companyId = null;
        if (param.containsKey("CompanyID")) {
            companyId = (String)param.get("CompanyID");
        }
        if (companyId == null) {
            companyId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        }
        PeriodInfo period = NCMUtils.GetCurrentPeriod((Context)ctx, (String)companyId);
        String FCalculatePeriod = period.getId().toString();
        String FUserID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String FCostItemID = "null";
        if (param.get("byCurrent") != null) {
            FCostItemID = this.getDefaultCostItemID(ctx, companyId);
        }
        String shareCostObjectId = this.getShareCostObjectId(ctx, companyId);
        Set costCenterIds = null;
        if (param.get("costCenterIds") != null && param.get("costCenterIds") instanceof Set) {
            costCenterIds = (Set)param.get("costCenterIds");
        }
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.createStatement();
            StringBuffer sql = new StringBuffer();
            if (param.get("byInit") != null) {
                String TBL_Balance = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_Balance");
                String TBL_BalanceEntry = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_BalanceEntry");
                String TBL_BalanceMatDetail = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_BalanceMatDetail");
                sql.append("insert into " + this.getMainTableName(ctx, null) + " ( \n");
                sql.append("    FID, FCompanyOrg, FCalculatePeriod, \n");
                sql.append("    FCostCenterID, \n");
                sql.append("    FMaterialID, FBatch, FUnitID, \n");
                sql.append("    FCostObjectID, FCostObjectSuiteID, FCostItemID, \n");
                sql.append("    FIsInWH, \n");
                sql.append("    FSourceType, \n");
                sql.append("    FFlag, \n");
                sql.append("    FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime, \n");
                sql.append("    FControlUnitID \n");
                sql.append(") \n");
                sql.append("select \n");
                sql.append("    newbosid('87CB4A7F') as FID, t.*, \n");
                sql.append("    (case when FCostObjectID is not null then 0 else 1 end) as FIsInWH, \n");
                sql.append("    20 as FSourceType, \n");
                sql.append("    0 as FFlag, \n");
                sql.append("    '").append(FUserID).append("' as FCreatorID, \n");
                sql.append("    GetDate() as FCreateTime, \n");
                sql.append("    '").append(FUserID).append("' as FLastUpdateUserID, \n");
                sql.append("    GetDate() as FLastUpdateTime, \n");
                sql.append("   '").append(FControlUnitID).append("' as FControlUnitID \n");
                sql.append("from ( \n");
                sql.append("\tselect distinct \n");
                sql.append("\ta.FCompanyOrg,  a.FCalculatePeriodID as FCalculatePeriod, a.FCostCenterID, c.FMaterialID, \n");
                sql.append("\tc.FBatchNo as FBatch, m.FBaseUnit, \n");
                sql.append("\ta.FCostObjectID, null as FCostObjectSuiteID, b.FCostItemID \n");
                sql.append("\tfrom " + TBL_Balance + " as a \n");
                sql.append("\tjoin " + TBL_BalanceEntry + " as b on b.FParentID = a.FID \n");
                sql.append("\tjoin " + TBL_BalanceMatDetail + " as c on c.FParentID = b.FID \n");
                sql.append("\tjoin t_org_costcenter as cc on cc.FID = a.FCostCenterID \n");
                sql.append("\tjoin t_bd_material as m on m.FID = c.FMaterialID \n");
                sql.append("\tjoin T_NCM_CostItem as ci on ci.FID = b.FCostItemID \n");
                sql.append("\twhere a.FCompanyOrg = '" + companyId + "' \n");
                sql.append("\tand a.FCalculatePeriodID = '" + FCalculatePeriod + "' \n");
                if (costCenterIds != null && costCenterIds.size() > 0) {
                    sql.append("and a.FCostCenterID in " + this.buildSqlFromIds(costCenterIds, true) + " \n");
                }
                sql.append("\tand cc.FCostCenterType = 0 \n");
                sql.append("\tand ci.FItemType = '1' \n");
                sql.append(") \n");
                sql.append("as t \n");
                sql.append("where NOT EXISTS ( \n");
                sql.append("select 1 from " + this.getMainTableName(ctx, null) + " as wip \n");
                sql.append("where \n");
                sql.append("t.FCompanyOrg = wip.FCompanyOrg \n");
                sql.append("and t.FCalculatePeriod = wip.FCalculatePeriod \n");
                sql.append("and t.FCostCenterID = wip.FCostCenterID \n");
                sql.append("and t.FMaterialID = wip.FMaterialID \n");
                sql.append("and (t.FBatch = wip.FBatch or (t.FBatch is null and wip.FBatch is null)) \n");
                sql.append("and \n");
                sql.append("( \n");
                sql.append("\tt.FCostObjectID = wip.FCostObjectID \n");
                sql.append("\tor \n");
                sql.append("\t( \n");
                sql.append("\t\t(t.FCostObjectID is null and wip.FCostObjectID is null) \n");
                sql.append("\t\tand \n");
                sql.append("\t\t(t.FCostObjectSuiteID = wip.FCostObjectSuiteID or (t.FCostObjectSuiteID is null and wip.FCostObjectSuiteID is null)) \n");
                sql.append("\t) \n");
                sql.append(") \n");
                sql.append("and (t.FCostItemID = wip.FCostItemID or (t.FCostItemID is null and wip.FCostItemID is null)) \n");
                sql.append(") \n");
                stmt.addBatch(sql.toString());
            }
            if (param.get("byCurrent") != null) {
                sql.setLength(0);
                sql.append("insert into " + this.getMainTableName(ctx, null) + " ( \n");
                sql.append("    FID, FCompanyOrg, FCalculatePeriod, \n");
                sql.append("    FCostCenterID, \n");
                sql.append("    FMaterialID, FBatch, FUnitID, \n");
                sql.append("    FCostObjectID, FCostObjectSuiteID, FCostItemID, \n");
                sql.append("    FIsInWH, \n");
                sql.append("    FSourceType, \n");
                sql.append("    FFlag, \n");
                sql.append("    FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime, \n");
                sql.append("    FControlUnitID \n");
                sql.append(") \n");
                sql.append("select \n");
                sql.append("    newbosid('87CB4A7F') as FID, t.*, \n");
                sql.append("    (case when FCostObjectID is not null then 0 else 1 end) as FIsInWH, \n");
                sql.append("    20 as FSourceType, \n");
                sql.append("    0 as FFlag, \n");
                sql.append("    '").append(FUserID).append("' as FCreatorID, \n");
                sql.append("    GetDate() as FCreateTime, \n");
                sql.append("    '").append(FUserID).append("' as FLastUpdateUserID, \n");
                sql.append("    GetDate() as FLastUpdateTime, \n");
                sql.append("    '").append(FControlUnitID).append("' as FControlUnitID \n");
                sql.append("from ( \n");
                sql.append("\tselect distinct \n");
                sql.append("\tb.FCompanyOrgUnitID as FCompanyOrg, '" + FCalculatePeriod + "' as FCalculatePeriod, b.FCostCenterOrgUnitID as FCostCenterID, b.FMaterialID, \n");
                sql.append("\tb.FLot as FBatch, m.FBaseUnit, \n");
                sql.append("\t(case when b.FCostObjectID = '" + shareCostObjectId + "' then null else b.FCostObjectID end) \n");
                sql.append("    as FCostObjectID, \n");
                sql.append("\t(case when (b.FCostObjectID is not null and b.FCostObjectID <> '" + shareCostObjectId + "') \n");
                sql.append("\tthen null else b.FCostObjectSuiteID end) ");
                sql.append("\tas FCostObjectSuiteID, ");
                sql.append("\t(case when b.FCostItemID is not null then b.FCostItemID when mc.FDefaultCostItemID is not null then mc.FDefaultCostItemID else " + FCostItemID + " end) as FCostItemID \n");
                sql.append("\tfrom T_IM_MaterialReqBill as a \n");
                sql.append("\tjoin T_IM_MaterialReqBillEntry as b on b.FParentID = a.FID \n");
                sql.append("\tjoin T_SCM_TransactionType tt on tt.FID = a.FTransactionTypeID \n");
                sql.append("\tinner join T_IM_InvUpdateType ut on b.FINVUPDATETYPEID = ut.fid \n");
                sql.append("\tinner join T_IM_STORETYPE st on ut.FSTORETYPEPREID = st.fid  \n");
                sql.append("\tjoin t_org_costcenter as cc on cc.FID = b.FCostCenterOrgUnitID \n");
                sql.append("\tjoin t_bd_material as m on m.FID = b.FMaterialID \n");
                sql.append("\tleft join T_BD_MaterialCost as mc on mc.FMaterialID = m.FID \n");
                sql.append("\tleft join T_NCM_CostItem as ci on ci.FID = b.FCostItemID \n");
                sql.append("\twhere b.FCompanyOrgUnitID = '" + companyId + "' \n");
                sql.append("\tand a.FYear = " + period.getPeriodYear() + " and a.FPeriod = " + period.getPeriodNumber() + " \n");
                sql.append("\tand a.FbaseStatus = 4 \n");
                sql.append("\tand a.FIsReversed = 0 \n");
                sql.append("\tand cc.FCostCenterType = 0 \n");
                if (costCenterIds != null && costCenterIds.size() > 0) {
                    sql.append("and b.FCostCenterOrgUnitID in " + this.buildSqlFromIds(costCenterIds, true) + " \n");
                }
                sql.append("\tand tt.FIsManuCostCalculate = 1 \n");
                sql.append("\tand st.FISFORWARDAMT = 1 \n");
                sql.append("\tand (ci.FID is null or ci.FID = '' or ci.FItemType = '1') \n");
                sql.append(") \n");
                sql.append("as t \n");
                sql.append("where NOT EXISTS ( \n");
                sql.append("select 1 from " + this.getMainTableName(ctx, null) + " as wip \n");
                sql.append("where \n");
                sql.append("t.FCompanyOrg = wip.FCompanyOrg \n");
                sql.append("and t.FCalculatePeriod = wip.FCalculatePeriod \n");
                sql.append("and t.FCostCenterID = wip.FCostCenterID \n");
                sql.append("and t.FMaterialID = wip.FMaterialID \n");
                sql.append("and (t.FBatch = wip.FBatch or (t.FBatch is null and wip.FBatch is null)) \n");
                sql.append("and \n");
                sql.append("( \n");
                sql.append("\tt.FCostObjectID = wip.FCostObjectID \n");
                sql.append("\tor \n");
                sql.append("\t( \n");
                sql.append("\t\t(t.FCostObjectID is null and wip.FCostObjectID is null) \n");
                sql.append("\t\tand \n");
                sql.append("\t\t(t.FCostObjectSuiteID = wip.FCostObjectSuiteID or (t.FCostObjectSuiteID is null and wip.FCostObjectSuiteID is null)) \n");
                sql.append("\t) \n");
                sql.append(") \n");
                sql.append("and (t.FCostItemID = wip.FCostItemID or (t.FCostItemID is null and wip.FCostItemID is null)) \n");
                sql.append(") \n");
                stmt.addBatch(sql.toString());
                sql.setLength(0);
                sql.append("insert into " + this.getMainTableName(ctx, null) + " ( \n");
                sql.append("    FID, FCompanyOrg, FCalculatePeriod, \n");
                sql.append("    FCostCenterID, \n");
                sql.append("    FMaterialID, FBatch, FUnitID, \n");
                sql.append("    FCostObjectID, FCostObjectSuiteID, FCostItemID, \n");
                sql.append("    FIsInWH, \n");
                sql.append("    FSourceType, \n");
                sql.append("    FFlag, \n");
                sql.append("    FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime, \n");
                sql.append("    FControlUnitID \n");
                sql.append(") \n");
                sql.append("select \n");
                sql.append("    newbosid('87CB4A7F') as FID, t.*, \n");
                sql.append("    (case when FCostObjectID is not null then 0 else 1 end) as FIsInWH, \n");
                sql.append("    20 as FSourceType, \n");
                sql.append("    0 as FFlag, \n");
                sql.append("    '").append(FUserID).append("' as FCreatorID, \n");
                sql.append("    GetDate() as FCreateTime, \n");
                sql.append("    '").append(FUserID).append("' as FLastUpdateUserID, \n");
                sql.append("    GetDate() as FLastUpdateTime, \n");
                sql.append("    '").append(FControlUnitID).append("' as FControlUnitID \n");
                sql.append("from ( \n");
                sql.append("\tselect distinct \n");
                sql.append("\tb.FCompanyOrgUnitID as FCompanyOrg, '" + FCalculatePeriod + "' as FCalculatePeriod, a.FCostCenterOrgUnitID as FCostCenterID, b.FMaterialID, \n");
                sql.append("\tb.FLot as FBatch, m.FBaseUnit, \n");
                sql.append("\t(case when b.FCostObjectID = '" + shareCostObjectId + "' then null else b.FCostObjectID end) \n");
                sql.append("    as FCostObjectID, \n");
                sql.append("\t(case when (b.FCostObjectID is not null and b.FCostObjectID <> '" + shareCostObjectId + "') \n");
                sql.append("\tthen null else b.FCostObjectSuiteID end) ");
                sql.append("\tas FCostObjectSuiteID, ");
                sql.append("\t(case when b.FCostItemID is not null then b.FCostItemID when mc.FDefaultCostItemID is not null then mc.FDefaultCostItemID else " + FCostItemID + " end) as FCostItemID \n");
                sql.append("\tfrom T_IM_OtherInWarehsBill as a \n");
                sql.append("\tjoin T_IM_OtherInWarehsBillEntry as b on b.FParentID = a.FID \n");
                sql.append("\tjoin T_SCM_TransactionType tt on tt.FID = a.FTransactionTypeID \n");
                sql.append("\tinner join T_IM_InvUpdateType ut on b.FINVUPDATETYPEID = ut.fid \n");
                sql.append("\tinner join T_IM_STORETYPE st on ut.FSTORETYPEID = st.fid  \n");
                sql.append("\tjoin t_org_costcenter as cc on cc.FID = a.FCostCenterOrgUnitID \n");
                sql.append("\tjoin t_bd_material as m on m.FID = b.FMaterialID \n");
                sql.append("\tleft join T_BD_MaterialCost as mc on mc.FMaterialID = m.FID \n");
                sql.append("\tleft join T_NCM_CostItem as ci on ci.FID = b.FCostItemID \n");
                sql.append("\twhere b.FCompanyOrgUnitID = '" + companyId + "' \n");
                sql.append("\tand a.FYear = " + period.getPeriodYear() + " and a.FPeriod = " + period.getPeriodNumber() + " \n");
                sql.append("\tand a.FbaseStatus = 4 \n");
                sql.append("\tand a.FIsReversed = 0 \n");
                if (costCenterIds != null && costCenterIds.size() > 0) {
                    sql.append("and a.FCostCenterOrgUnitID in " + this.buildSqlFromIds(costCenterIds, true) + " \n");
                }
                sql.append("\tand cc.FCostCenterType = 0 \n");
                sql.append("\tand tt.FIsManuCostCalculate = 1 \n");
                sql.append("\tand st.FISFORWARDAMT = 1 \n");
                sql.append("\tand (ci.FID is null or ci.FID = '' or ci.FItemType = '1') \n");
                sql.append(") \n");
                sql.append("as t \n");
                sql.append("where NOT EXISTS ( \n");
                sql.append("select 1 from " + this.getMainTableName(ctx, null) + " as wip \n");
                sql.append("where \n");
                sql.append("t.FCompanyOrg = wip.FCompanyOrg \n");
                sql.append("and t.FCalculatePeriod = wip.FCalculatePeriod \n");
                sql.append("and t.FCostCenterID = wip.FCostCenterID \n");
                sql.append("and t.FMaterialID = wip.FMaterialID \n");
                sql.append("and (t.FBatch = wip.FBatch or (t.FBatch is null and wip.FBatch is null)) \n");
                sql.append("and \n");
                sql.append("( \n");
                sql.append("\tt.FCostObjectID = wip.FCostObjectID \n");
                sql.append("\tor \n");
                sql.append("\t( \n");
                sql.append("\t\t(t.FCostObjectID is null and wip.FCostObjectID is null) \n");
                sql.append("\t\tand \n");
                sql.append("\t\t(t.FCostObjectSuiteID = wip.FCostObjectSuiteID or (t.FCostObjectSuiteID is null and wip.FCostObjectSuiteID is null)) \n");
                sql.append("\t) \n");
                sql.append(") \n");
                sql.append("and (t.FCostItemID = wip.FCostItemID or (t.FCostItemID is null and wip.FCostItemID is null)) \n");
                sql.append(") \n");
                stmt.addBatch(sql.toString());
                sql.setLength(0);
                sql.append("insert into " + this.getMainTableName(ctx, null) + " \n");
                sql.append("( \n");
                sql.append("    FID, FCompanyOrg, FCalculatePeriod, \n");
                sql.append("    FCostCenterID, \n");
                sql.append("    FMaterialID, FBatch, FUnitID, \n");
                sql.append("    FCostObjectID, FCostObjectSuiteID, FCostItemID, \n");
                sql.append("    FIsInWH, \n");
                sql.append("    FSourceType, \n");
                sql.append("    FFlag, \n");
                sql.append("    FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime, \n");
                sql.append("    FControlUnitID \n");
                sql.append(") \n");
                sql.append("select \n");
                sql.append("    newbosid('87CB4A7F') as FID, t.*, \n");
                sql.append("    (case when FCostObjectID is not null then 0 else 1 end) as FIsInWH, \n");
                sql.append("    20 as FSourceType, \n");
                sql.append("    0 as FFlag, \n");
                sql.append("    '").append(FUserID).append("' as FCreatorID, \n");
                sql.append("    GetDate() as FCreateTime, \n");
                sql.append("    '").append(FUserID).append("' as FLastUpdateUserID, \n");
                sql.append("    GetDate() as FLastUpdateTime, \n");
                sql.append("    '").append(FControlUnitID).append("' as FControlUnitID \n");
                sql.append("from ( \n");
                sql.append("\tselect distinct \n");
                sql.append("\tb.FCompanyOrgUnitID as FCompanyOrg, '" + FCalculatePeriod + "' as FCalculatePeriod, a.FCostCenterOrgUnit as FCostCenterID, b.FMaterialID, \n");
                sql.append("\tb.FLot as FBatch, m.FBaseUnit, \n");
                sql.append("\t(case when b.FCostObjectID = '" + shareCostObjectId + "' then null else b.FCostObjectID end) \n");
                sql.append("    as FCostObjectID, \n");
                sql.append("\tnull as FCostObjectSuiteID, \n");
                sql.append("\t(case when mc.FDefaultCostItemID is not null then mc.FDefaultCostItemID else " + FCostItemID + " end) as FCostItemID \n");
                sql.append("\tfrom t_cl_CostAdjustBill as a \n");
                sql.append("\tjoin t_cl_CostAdjustBillentry as b on b.FParentID = a.FID \n");
                sql.append("\tjoin t_org_costcenter as cc on cc.FID = a.FCostCenterOrgUnit \n");
                sql.append("\tjoin t_bd_material as m on m.FID = b.FMaterialID \n");
                sql.append("\tleft join T_BD_MaterialCost as mc on mc.FMaterialID = m.FID \n");
                sql.append("\twhere b.FCompanyOrgUnitID = '" + companyId + "' \n");
                sql.append("\tand a.FYear = " + period.getPeriodYear() + " and a.FPeriod = " + period.getPeriodNumber() + " \n");
                sql.append("\tand a.FbaseStatus = 4 \n");
                sql.append("\tand a.FIsReversed = 0 \n");
                sql.append("\tand a.FCalculateKind = 1 \n");
                sql.append("\tand a.FIssueType = 1 \n");
                if (costCenterIds != null && costCenterIds.size() > 0) {
                    sql.append("and a.FCostCenterOrgUnit in " + this.buildSqlFromIds(costCenterIds, true) + " \n");
                }
                sql.append("\tand cc.FCostCenterType = 0 \n");
                sql.append(") \n");
                sql.append("as t \n");
                sql.append("where NOT EXISTS ( \n");
                sql.append("select 1 from " + this.getMainTableName(ctx, null) + " as wip \n");
                sql.append("where \n");
                sql.append("t.FCompanyOrg = wip.FCompanyOrg \n");
                sql.append("and t.FCalculatePeriod = wip.FCalculatePeriod \n");
                sql.append("and t.FCostCenterID = wip.FCostCenterID \n");
                sql.append("and t.FMaterialID = wip.FMaterialID \n");
                sql.append("and (t.FBatch = wip.FBatch or (t.FBatch is null and wip.FBatch is null)) \n");
                sql.append("and \n");
                sql.append("( \n");
                sql.append("\tt.FCostObjectID = wip.FCostObjectID \n");
                sql.append("\tor \n");
                sql.append("\t( \n");
                sql.append("\t\t(t.FCostObjectID is null and wip.FCostObjectID is null) \n");
                sql.append("\t\tand \n");
                sql.append("\t\t(t.FCostObjectSuiteID = wip.FCostObjectSuiteID or (t.FCostObjectSuiteID is null and wip.FCostObjectSuiteID is null)) \n");
                sql.append("\t) \n");
                sql.append(") \n");
                sql.append("and (t.FCostItemID = wip.FCostItemID or (t.FCostItemID is null and wip.FCostItemID is null)) \n");
                sql.append(") \n");
                stmt.addBatch(sql.toString());
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    protected void genDataForOrderMatReq(Context ctx, Map param) throws BOSException, EASBizException {
        String FControlUnitID = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        String companyId = null;
        if (param.containsKey("CompanyID")) {
            companyId = (String)param.get("CompanyID");
        }
        if (companyId == null) {
            companyId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        }
        PeriodInfo period = NCMUtils.GetCurrentPeriod((Context)ctx, (String)companyId);
        String FCalculatePeriod = period.getId().toString();
        String FUserID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        Set costCenterIds = null;
        if (param.get("costCenterIds") != null && param.get("costCenterIds") instanceof Set) {
            costCenterIds = (Set)param.get("costCenterIds");
        }
        String FCostItemID = "null";
        if (param.get("orderMatReq") != null) {
            FCostItemID = this.getDefaultCostItemID(ctx, companyId);
        }
        String shareCostObjectId = this.getShareCostObjectId(ctx, companyId);
        boolean isQtyWipType = NCMUtils.isQtyWipType((Context)ctx, (String)companyId);
        String tempTable = null;
        Connection conn = null;
        Statement stmt = null;
        try {
            StringBuffer ksql = new StringBuffer();
            ksql.append("create table T ( \n");
            ksql.append("     FCostCenterID varchar(44), \n");
            ksql.append("     FMaterialID varchar(44), \n");
            ksql.append("     FBatch NVARCHAR(256), \n");
            ksql.append("     FCostObjectID varchar(44), \n");
            ksql.append("     FCostObjectSuiteID varchar(44), \n");
            ksql.append("     FCostItemID varchar(44), \n");
            ksql.append("     FBaseQty NUMERIC(28,10) DEFAULT 0, \n");
            ksql.append("     FAmount NUMERIC(28,10) DEFAULT 0, \n");
            ksql.append("     FFlag INT DEFAULT 0 \n");
            ksql.append(") \n");
            try {
                tempTable = TempTablePool.getInstance((Context)ctx).createTempTable(ksql.toString());
            }
            catch (Exception e) {
                logger.debug((Object)e);
                throw new BOSException((Throwable)e);
            }
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.createStatement();
            StringBuffer sql = new StringBuffer();
            sql.setLength(0);
            sql.append("insert into " + tempTable + " ( \n");
            sql.append("     FCostCenterID, \n");
            sql.append("     FMaterialID, \n");
            sql.append("     FBatch, \n");
            sql.append("     FCostObjectID, \n");
            sql.append("     FCostObjectSuiteID, \n");
            sql.append("     FCostItemID, \n");
            sql.append("     FBaseQty, \n");
            sql.append("     FAmount, \n");
            sql.append("     FFlag \n");
            sql.append(") \n");
            sql.append("select \n");
            sql.append("\tb.FCostCenterOrgUnitID FCostCenterID, \n");
            sql.append("\tb.FMaterialID FMaterialID, \n");
            sql.append("\tb.FLot FBatch, \n");
            sql.append("\t(\n");
            sql.append("\t    case when b.FCostObjectID = '" + shareCostObjectId + "' then null \n");
            sql.append("\t    else b.FCostObjectID end \n");
            sql.append("\t) as FCostObjectID, \n");
            sql.append("\t(\n");
            sql.append("\t    case when (b.FCostObjectID is not null and b.FCostObjectID <> '" + shareCostObjectId + "') \n");
            sql.append("\t    then null else b.FCostObjectSuiteID end ");
            sql.append("\t) as FCostObjectSuiteID, ");
            sql.append("\t(\n");
            sql.append("\t    case when b.FCostItemID is not null then b.FCostItemID \n");
            sql.append("\t    when mc.FDefaultCostItemID is not null then mc.FDefaultCostItemID \n");
            sql.append("\t    else " + FCostItemID + " end \n");
            sql.append("\t) as FCostItemID, \n");
            sql.append("\tb.FBaseQty as FBaseQty,  \n");
            sql.append("\tb.FActualCost as FAmount,  \n");
            sql.append("\t0 as FFlag  \n");
            sql.append("from T_IM_MaterialReqBill as a \n");
            sql.append("join T_IM_MaterialReqBillEntry as b on b.FParentID = a.FID \n");
            sql.append("join T_SCM_TransactionType tt on tt.FID = a.FTransactionTypeID \n");
            sql.append("inner join T_IM_InvUpdateType ut on b.FINVUPDATETYPEID = ut.fid \n");
            sql.append("inner join T_IM_STORETYPE st on ut.FSTORETYPEPREID = st.fid  \n");
            sql.append("join t_org_costcenter as cc on cc.FID = b.FCostCenterOrgUnitID \n");
            sql.append("join T_MM_ManufactureOrder as mo on mo.FID = b.FSourceBillID \n");
            sql.append("left join T_BD_MaterialCost as mc on mc.FMaterialID = b.FMaterialID \n");
            sql.append("    and mc.FOrgUnit = '" + companyId + "' \n");
            sql.append("left join T_NCM_CostItem as ci on ci.FID = b.FCostItemID \n");
            sql.append("where b.FCompanyOrgUnitID = '" + companyId + "' \n");
            sql.append("and a.FYear = " + period.getPeriodYear() + " \n");
            sql.append("and a.FPeriod = " + period.getPeriodNumber() + " \n");
            sql.append("and a.FbaseStatus = 4 \n");
            sql.append("and a.FIsReversed = 0 \n");
            if (costCenterIds != null && costCenterIds.size() > 0) {
                sql.append("and b.FCostCenterOrgUnitID in " + this.buildSqlFromIds(costCenterIds, true) + " \n");
            }
            sql.append("and cc.FCostCenterType = 0 \n");
            sql.append("and tt.FIsManuCostCalculate = 1 \n");
            sql.append("and st.FISFORWARDAMT = 1 \n");
            sql.append("and (ci.FID is null or ci.FID = '' or ci.FItemType = '1') \n");
            sql.append("and b.FSourceBillID is not null \n");
            sql.append("and not exists ( \n");
            sql.append("\tselect 1 from T_IM_ManufactureRecBill recBill \n");
            sql.append("\tjoin T_IM_ManufactureRecBillEntry recBillEntry \n");
            sql.append("\ton recBillEntry.FParentID = recBill.FID \n");
            sql.append("\tjoin T_SCM_TransactionType tt2 \n");
            sql.append("\ton tt2.FID = recBill.FTransactionTypeID \n");
            sql.append("\tand tt2.FIsManuCostCalculate = 1 \n");
            sql.append("\tinner join T_IM_InvUpdateType ut on recBillEntry.FINVUPDATETYPEID = ut.fid \n");
            sql.append("\tinner join T_IM_STORETYPE st on ut.FSTORETYPEID = st.fid and st.FISFORWARDAMT = 1 \n");
            sql.append("\twhere recBillEntry.FSourceBillID = mo.FID \n");
            sql.append("\tand recBillEntry.FCompanyOrgUnitID = '" + companyId + "' \n");
            sql.append("\tand recBill.FYear = " + period.getPeriodYear() + " \n");
            sql.append("\tand recBill.FPeriod = " + period.getPeriodNumber() + " \n");
            sql.append("\tand recBill.FbaseStatus = 4 \n");
            sql.append(") \n");
            stmt.executeUpdate(sql.toString());
            sql.setLength(0);
            sql.append("insert into " + tempTable + " ( \n");
            sql.append("     FCostCenterID, \n");
            sql.append("     FMaterialID, \n");
            sql.append("     FBatch, \n");
            sql.append("     FCostObjectID, \n");
            sql.append("     FCostObjectSuiteID, \n");
            sql.append("     FCostItemID, \n");
            sql.append("     FBaseQty, \n");
            sql.append("     FAmount, \n");
            sql.append("     FFlag \n");
            sql.append(") \n");
            sql.append("select \n");
            sql.append("\tb.FCostCenterOrgUnitID FCostCenterID, \n");
            sql.append("\tb.FMaterialID FMaterialID, \n");
            sql.append("\tb.FLot FBatch, \n");
            sql.append("\t(\n");
            sql.append("\t    case when b.FCostObjectID = '" + shareCostObjectId + "' then null \n");
            sql.append("\t    else b.FCostObjectID end \n");
            sql.append("\t) as FCostObjectID, \n");
            sql.append("\t(\n");
            sql.append("\t    case when (b.FCostObjectID is not null and b.FCostObjectID <> '" + shareCostObjectId + "') \n");
            sql.append("\t    then null else b.FCostObjectSuiteID end ");
            sql.append("\t) as FCostObjectSuiteID, ");
            sql.append("\t(\n");
            sql.append("\t    case when b.FCostItemID is not null then b.FCostItemID \n");
            sql.append("\t    when mc.FDefaultCostItemID is not null then mc.FDefaultCostItemID \n");
            sql.append("\t    else " + FCostItemID + " end \n");
            sql.append("\t) as FCostItemID, \n");
            sql.append("\tb.FBaseQty as FBaseQty,  \n");
            sql.append("\tb.FActualCost as FAmount,  \n");
            sql.append("\t0 as FFlag  \n");
            sql.append("from T_IM_MaterialReqBill as a \n");
            sql.append("join T_IM_MaterialReqBillEntry as b on b.FParentID = a.FID \n");
            sql.append("join T_SCM_TransactionType tt on tt.FID = a.FTransactionTypeID \n");
            sql.append("inner join T_IM_InvUpdateType ut on b.FINVUPDATETYPEID = ut.fid \n");
            sql.append("inner join T_IM_STORETYPE st on ut.FSTORETYPEPREID = st.fid and st.FISFORWARDAMT = 1 \n");
            sql.append("join t_org_costcenter as cc on cc.FID = b.FCostCenterOrgUnitID \n");
            sql.append("join T_MM_ProductionOrder as po on po.FID = b.FOrderBillID \n");
            sql.append("left join T_BD_MaterialCost as mc on mc.FMaterialID = b.FMaterialID \n");
            sql.append("    and mc.FOrgUnit = '" + companyId + "' \n");
            sql.append("left join T_NCM_CostItem as ci on ci.FID = b.FCostItemID \n");
            sql.append("where b.FCompanyOrgUnitID = '" + companyId + "' \n");
            sql.append("and a.FYear = " + period.getPeriodYear() + " \n");
            sql.append("and a.FPeriod = " + period.getPeriodNumber() + " \n");
            sql.append("and a.FbaseStatus = 4 \n");
            sql.append("and a.FIsReversed = 0 \n");
            if (costCenterIds != null && costCenterIds.size() > 0) {
                sql.append("and b.FCostCenterOrgUnitID in " + this.buildSqlFromIds(costCenterIds, true) + " \n");
            }
            sql.append("and cc.FCostCenterType = 0 \n");
            sql.append("and tt.FIsManuCostCalculate = 1 \n");
            sql.append("and (ci.FID is null or ci.FID = '' or ci.FItemType = '1') \n");
            sql.append("and b.FOrderBillID is not null \n");
            sql.append("and not exists ( \n");
            sql.append("\tselect 1 from T_IM_ManufactureRecBill recBill \n");
            sql.append("\tjoin T_IM_ManufactureRecBillEntry recBillEntry \n");
            sql.append("\ton recBillEntry.FParentID = recBill.FID \n");
            sql.append("\tjoin T_SCM_TransactionType tt2 \n");
            sql.append("\ton tt2.FID = recBill.FTransactionTypeID \n");
            sql.append("\tand tt2.FIsManuCostCalculate = 1 \n");
            sql.append("\tinner join T_IM_InvUpdateType ut on recBillEntry.FINVUPDATETYPEID = ut.fid \n");
            sql.append("\tinner join T_IM_STORETYPE st on ut.FSTORETYPEID = st.fid and st.FISFORWARDAMT = 1 \n");
            sql.append("\tjoin T_MM_FinishedRpt fr \n");
            sql.append("\ton fr.FID = recBillEntry.FSourceBillID \n");
            sql.append("\twhere fr.FProductionOrderID = po.FID \n");
            sql.append("\tand recBillEntry.FCompanyOrgUnitID = '" + companyId + "' \n");
            sql.append("\tand recBill.FYear = " + period.getPeriodYear() + " \n");
            sql.append("\tand recBill.FPeriod = " + period.getPeriodNumber() + " \n");
            sql.append("\tand recBill.FbaseStatus = 4 \n");
            sql.append(") \n");
            stmt.executeUpdate(sql.toString());
            sql.setLength(0);
            sql.append("insert into " + tempTable + " ( \n");
            sql.append("     FCostCenterID, \n");
            sql.append("     FMaterialID, \n");
            sql.append("     FBatch, \n");
            sql.append("     FCostObjectID, \n");
            sql.append("     FCostObjectSuiteID, \n");
            sql.append("     FCostItemID, \n");
            sql.append("     FBaseQty, \n");
            sql.append("     FAmount, \n");
            sql.append("     FFlag \n");
            sql.append(") \n");
            sql.append("select \n");
            sql.append("    FCostCenterID, \n");
            sql.append("    FMaterialID, \n");
            sql.append("    FBatch, \n");
            sql.append("    FCostObjectID, \n");
            sql.append("    FCostObjectSuiteID, \n");
            sql.append("    FCostItemID, \n");
            sql.append("    sum(FBaseQty) FBaseQty, \n");
            sql.append("    sum(FAmount) FAmount, \n");
            sql.append("    1 FFlag \n");
            sql.append("from " + tempTable + " \n");
            sql.append("group by FCostCenterID, FMaterialID, FBatch, \n");
            sql.append("FCostObjectID, FCostObjectSuiteID, FCostItemID \n");
            stmt.executeUpdate(sql.toString());
            sql.setLength(0);
            sql.append("delete from " + tempTable + " where FFlag <> 1 \n");
            stmt.executeUpdate(sql.toString());
            sql.setLength(0);
            sql.append("delete from " + this.getMainTableName(ctx, null) + " \n");
            sql.append("where FCompanyOrg = '" + companyId + "' \n");
            sql.append("and FCalculatePeriod = '" + FCalculatePeriod + "' \n");
            sql.append("and FSourceType = 30 \n");
            if (costCenterIds != null && costCenterIds.size() > 0) {
                sql.append("and FCostCenterID in " + this.buildSqlFromIds(costCenterIds, true) + " \n");
            }
            stmt.executeUpdate(sql.toString());
            sql.setLength(0);
            sql.append("insert into " + this.getMainTableName(ctx, null) + " ( \n");
            sql.append("    FID, FCompanyOrg, FCalculatePeriod, \n");
            sql.append("    FCostCenterID, \n");
            sql.append("    FMaterialID, FBatch, FUnitID, \n");
            sql.append("    FCostObjectID, FCostObjectSuiteID, FCostItemID, \n");
            if (isQtyWipType) {
                sql.append("    FQty, FBaseQty, \n");
            } else {
                sql.append("    FAmount, \n");
            }
            sql.append("    FIsInWH, \n");
            sql.append("    FSourceType, \n");
            sql.append("    FFlag, \n");
            sql.append("    FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, \n");
            sql.append("    FControlUnitID \n");
            sql.append(") \n");
            sql.append("select \n");
            sql.append("    newbosid('87CB4A7F') as FID, \n");
            sql.append("    '" + companyId + "' as FCompanyOrg, \n");
            sql.append("    '" + FCalculatePeriod + "' as FCalculatePeriod, \n");
            sql.append("    t.*, \n");
            sql.append("    (case when FCostObjectID is not null then 0 else 1 end) as FIsInWH, \n");
            sql.append("    30 as FSourceType, \n");
            sql.append("    0 as FFlag, \n");
            sql.append("    '").append(FUserID).append("' as FCreatorID, \n");
            sql.append("    GetDate() as FCreateTime, \n");
            sql.append("    '").append(FUserID).append("' as FLastUpdateUserID, \n");
            sql.append("    GetDate() as FLastUpdateTime, \n");
            sql.append("    '").append(FControlUnitID).append("' as FControlUnitID \n");
            sql.append("from (\n");
            sql.append("select \n");
            sql.append("    a.FCostCenterID FCostCenterID, \n");
            sql.append("    a.FMaterialID FMaterialID, \n");
            sql.append("    a.FBatch FBatch, \n");
            sql.append("    m.FBaseUnit FUnitID, \n");
            sql.append("    a.FCostObjectID FCostObjectID, \n");
            sql.append("    a.FCostObjectSuiteID FCostObjectSuiteID, \n");
            sql.append("    a.FCostItemID FCostItemID, \n");
            if (isQtyWipType) {
                sql.append("    a.FBaseQty FQty, \n");
                sql.append("    a.FBaseQty FBaseQty \n");
            } else {
                sql.append("    a.FAmount FAmount \n");
            }
            sql.append("    from " + tempTable + " a \n");
            sql.append("    join T_BD_Material m \n");
            sql.append("    on m.FID = a.FMaterialID \n");
            sql.append(") \n");
            sql.append("as t \n");
            sql.append("where NOT EXISTS ( \n");
            sql.append("select 1 from " + this.getMainTableName(ctx, null) + " as wip \n");
            sql.append("where \n");
            sql.append("wip.FCompanyOrg = '" + companyId + "' \n");
            sql.append("and wip.FCalculatePeriod = '" + FCalculatePeriod + "' \n");
            sql.append("and t.FCostCenterID = wip.FCostCenterID \n");
            sql.append("and t.FMaterialID = wip.FMaterialID \n");
            sql.append("and (t.FBatch = wip.FBatch or (t.FBatch is null and wip.FBatch is null)) \n");
            sql.append("and \n");
            sql.append("( \n");
            sql.append("\tt.FCostObjectID = wip.FCostObjectID \n");
            sql.append("\tor \n");
            sql.append("\t( \n");
            sql.append("\t\t(t.FCostObjectID is null and wip.FCostObjectID is null) \n");
            sql.append("\t\tand \n");
            sql.append("\t\t(t.FCostObjectSuiteID = wip.FCostObjectSuiteID or (t.FCostObjectSuiteID is null and wip.FCostObjectSuiteID is null)) \n");
            sql.append("\t) \n");
            sql.append(") \n");
            sql.append("and (t.FCostItemID = wip.FCostItemID or (t.FCostItemID is null and wip.FCostItemID is null)) \n");
            sql.append(") \n");
            stmt.executeUpdate(sql.toString());
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
                SQLUtils.cleanup(stmt, conn);
                throw throwable;
            }
        }
        TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    protected void genDataForOrderWIP(Context ctx, Map param) throws BOSException, EASBizException {
        String FControlUnitID = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        String companyId = null;
        if (param.containsKey("CompanyID")) {
            companyId = (String)param.get("CompanyID");
        }
        if (companyId == null) {
            companyId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        }
        PeriodInfo period = NCMUtils.GetCurrentPeriod((Context)ctx, (String)companyId);
        String FCalculatePeriod = period.getId().toString();
        String FUserID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        Set costCenterIds = null;
        if (param.get("costCenterIds") != null && param.get("costCenterIds") instanceof Set) {
            costCenterIds = (Set)param.get("costCenterIds");
        }
        String FCostItemID = "null";
        if (param.get("orderMatReq") != null) {
            FCostItemID = this.getDefaultCostItemID(ctx, companyId);
        }
        String shareCostObjectId = this.getShareCostObjectId(ctx, companyId);
        Set storageOrgUnitIds = BDCMUtils.getStorageOrgUnitIdsOfCompany((Context)ctx, (String)companyId);
        boolean isQtyWipType = NCMUtils.isQtyWipType((Context)ctx, (String)companyId);
        if (!isQtyWipType) {
            return;
        }
        String tempTable = null;
        Connection conn = null;
        Statement stmt = null;
        try {
            StringBuffer ksql = new StringBuffer();
            ksql.append("create table T ( \n");
            ksql.append("     FOrderID varchar(44), \n");
            ksql.append("     FCostCenterID varchar(44), \n");
            ksql.append("     FMaterialID varchar(44), \n");
            ksql.append("     FBatch NVARCHAR(256), \n");
            ksql.append("     FCostObjectID varchar(44), \n");
            ksql.append("     FCostObjectSuiteID varchar(44), \n");
            ksql.append("     FCostItemID varchar(44), \n");
            ksql.append("     FUnitID varchar(44), \n");
            ksql.append("     FBaseQty NUMERIC(28,10) DEFAULT 0, \n");
            ksql.append("     FAmount NUMERIC(28,10) DEFAULT 0, \n");
            ksql.append("     FFlag INT DEFAULT 0 \n");
            ksql.append(") \n");
            try {
                tempTable = TempTablePool.getInstance((Context)ctx).createTempTable(ksql.toString());
            }
            catch (Exception e) {
                logger.debug((Object)e);
                throw new BOSException((Throwable)e);
            }
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.createStatement();
            StringBuffer sql = new StringBuffer();
            sql.setLength(0);
            sql.append("insert into " + tempTable + " ( \n");
            sql.append("     FOrderID, \n");
            sql.append("     FCostCenterID, \n");
            sql.append("     FMaterialID, \n");
            sql.append("     FBatch, \n");
            sql.append("     FCostObjectID, \n");
            sql.append("     FCostObjectSuiteID, \n");
            sql.append("     FCostItemID, \n");
            sql.append("     FUnitID, \n");
            sql.append("     FBaseQty, \n");
            sql.append("     FAmount, \n");
            sql.append("     FFlag \n");
            sql.append(") \n");
            sql.append("select \n");
            sql.append("\ta.FID FOrderID, \n");
            sql.append("\tnull FCostCenterID, \n");
            sql.append("\tb.FMaterialID FMaterialID, \n");
            sql.append("\tnull FBatch, \n");
            sql.append("\t(\n");
            sql.append("\t    case when a.FCostObjectID = '" + shareCostObjectId + "' then null \n");
            sql.append("\t    else a.FCostObjectID end \n");
            sql.append("\t) as FCostObjectID, \n");
            sql.append("\tnull as FCostObjectSuiteID, \n");
            sql.append("\t(\n");
            sql.append("\t    case when mc.FDefaultCostItemID is not null then mc.FDefaultCostItemID \n");
            sql.append("\t    else " + FCostItemID + " end \n");
            sql.append("\t) as FCostItemID, \n");
            sql.append("\tb.FUnitID as FUnitID,  \n");
            sql.append("\tb.FWipQty as FBaseQty,  \n");
            sql.append("\t0 as FAmount,  \n");
            sql.append("\t0 as FFlag  \n");
            sql.append("from T_MM_ManufactureOrder as a \n");
            sql.append("join T_MM_MFTOrderStock as b on b.FParentID = a.FID \n");
            sql.append("left join T_BD_MaterialCost as mc on mc.FMaterialID = b.FMaterialID \n");
            sql.append("    and mc.FOrgUnit = '" + companyId + "' \n");
            sql.append("where b.FWipQty > 0 \n");
            sql.append("and a.FStorageOrgUnitID in " + this.buildSqlFromIds(storageOrgUnitIds, true) + " \n");
            HashSet<String> statuses = new HashSet<String>();
            statuses.add(String.valueOf(1));
            statuses.add(String.valueOf(2));
            statuses.add(String.valueOf(4));
            statuses.add(String.valueOf(5));
            statuses.add(String.valueOf(6));
            statuses.add(String.valueOf(7));
            statuses.add(String.valueOf(8));
            sql.append("and a.FBaseStatus in " + this.buildSqlFromIds(statuses, false) + " \n");
            stmt.executeUpdate(sql.toString());
            sql.setLength(0);
            sql.append("update " + tempTable + " set FCostCenterID = ( \n");
            sql.append("    select max(b.FCostCenterOrgUnitID) \n");
            sql.append("    from T_IM_MaterialReqBill as a \n");
            sql.append("    join T_IM_MaterialReqBillEntry as b on b.FParentID = a.FID \n");
            sql.append("    join T_SCM_TransactionType tt on tt.FID = a.FTransactionTypeID \n");
            sql.append("\tinner join T_IM_InvUpdateType ut on b.FINVUPDATETYPEID = ut.fid \n");
            sql.append("\tinner join T_IM_STORETYPE st on ut.FSTORETYPEPREID = st.fid  \n");
            sql.append("    join t_org_costcenter as cc on cc.FID = b.FCostCenterOrgUnitID \n");
            sql.append("    where b.FCompanyOrgUnitID = '" + companyId + "' \n");
            sql.append("    and a.FYear = " + period.getPeriodYear() + " \n");
            sql.append("    and a.FPeriod = " + period.getPeriodNumber() + " \n");
            sql.append("    and a.FbaseStatus = 4 \n");
            sql.append("    and a.FIsReversed = 0 \n");
            if (costCenterIds != null && costCenterIds.size() > 0) {
                sql.append("    and b.FCostCenterOrgUnitID in " + this.buildSqlFromIds(costCenterIds, true) + " \n");
            }
            sql.append("    and cc.FCostCenterType = 0 \n");
            sql.append("    and tt.FIsManuCostCalculate = 1 \n");
            sql.append("    and  st.FISFORWARDAMT = 1 \n");
            sql.append("    and b.FSourceBillID is not null \n");
            sql.append("    and b.FSourceBillID = " + tempTable + ".FOrderID \n");
            sql.append("    and a.FBizDate = ( \n");
            sql.append("        select max(a.FBizDate) \n");
            sql.append("        from T_IM_MaterialReqBill as a \n");
            sql.append("        join T_IM_MaterialReqBillEntry as b on b.FParentID = a.FID \n");
            sql.append("        join T_SCM_TransactionType tt on tt.FID = a.FTransactionTypeID \n");
            sql.append("\t \tinner join T_IM_InvUpdateType ut on b.FINVUPDATETYPEID = ut.fid \n");
            sql.append("\t \tinner join T_IM_STORETYPE st on ut.FSTORETYPEPREID = st.fid  \n");
            sql.append("        join t_org_costcenter as cc on cc.FID = b.FCostCenterOrgUnitID \n");
            sql.append("        where b.FCompanyOrgUnitID = '" + companyId + "' \n");
            sql.append("        and a.FYear = " + period.getPeriodYear() + " \n");
            sql.append("        and a.FPeriod = " + period.getPeriodNumber() + " \n");
            sql.append("        and a.FbaseStatus = 4 \n");
            sql.append("        and a.FIsReversed = 0 \n");
            if (costCenterIds != null && costCenterIds.size() > 0) {
                sql.append("    and b.FCostCenterOrgUnitID in " + this.buildSqlFromIds(costCenterIds, true) + " \n");
            }
            sql.append("        and cc.FCostCenterType = 0 \n");
            sql.append("        and tt.FIsManuCostCalculate = 1 \n");
            sql.append("        and st.FISFORWARDAMT = 1 \n");
            sql.append("        and b.FSourceBillID is not null \n");
            sql.append("        and b.FSourceBillID = " + tempTable + ".FOrderID \n");
            sql.append("    ) \n");
            sql.append(") \n");
            stmt.executeUpdate(sql.toString());
            sql.setLength(0);
            sql.append("delete from " + tempTable + " where FCostCenterID is null ");
            stmt.executeUpdate(sql.toString());
            sql.setLength(0);
            sql.append("update " + tempTable + " set FBaseQty = FBaseQty * isnull(( \n");
            sql.append("    select FBaseConvsRate \n");
            sql.append("    from T_BD_MultiMeasureUnit mu \n");
            sql.append("    where mu.FMaterialID = " + tempTable + ".FMaterialID \n");
            sql.append("    and mu.FMeasureUnitID = " + tempTable + ".FUnitID \n");
            sql.append("), 1) \n");
            stmt.executeUpdate(sql.toString());
            sql.setLength(0);
            sql.append("insert into " + tempTable + " ( \n");
            sql.append("     FCostCenterID, \n");
            sql.append("     FMaterialID, \n");
            sql.append("     FBatch, \n");
            sql.append("     FCostObjectID, \n");
            sql.append("     FCostObjectSuiteID, \n");
            sql.append("     FCostItemID, \n");
            sql.append("     FBaseQty, \n");
            sql.append("     FAmount, \n");
            sql.append("     FFlag \n");
            sql.append(") \n");
            sql.append("select \n");
            sql.append("    FCostCenterID, \n");
            sql.append("    FMaterialID, \n");
            sql.append("    FBatch, \n");
            sql.append("    FCostObjectID, \n");
            sql.append("    FCostObjectSuiteID, \n");
            sql.append("    FCostItemID, \n");
            sql.append("    sum(FBaseQty) FBaseQty, \n");
            sql.append("    sum(FAmount) FAmount, \n");
            sql.append("    1 FFlag \n");
            sql.append("from " + tempTable + " \n");
            sql.append("group by FCostCenterID, FMaterialID, FBatch, \n");
            sql.append("FCostObjectID, FCostObjectSuiteID, FCostItemID \n");
            stmt.executeUpdate(sql.toString());
            sql.setLength(0);
            sql.append("delete from " + tempTable + " where FFlag <> 1 \n");
            stmt.executeUpdate(sql.toString());
            sql.setLength(0);
            sql.append("delete from " + this.getMainTableName(ctx, null) + " \n");
            sql.append("where FCompanyOrg = '" + companyId + "' \n");
            sql.append("and FCalculatePeriod = '" + FCalculatePeriod + "' \n");
            sql.append("and FSourceType = 40 \n");
            if (costCenterIds != null && costCenterIds.size() > 0) {
                sql.append("and FCostCenterID in " + this.buildSqlFromIds(costCenterIds, true) + " \n");
            }
            stmt.executeUpdate(sql.toString());
            sql.setLength(0);
            sql.append("insert into " + this.getMainTableName(ctx, null) + " ( \n");
            sql.append("    FID, FCompanyOrg, FCalculatePeriod, \n");
            sql.append("    FCostCenterID, \n");
            sql.append("    FMaterialID, FBatch, FUnitID, \n");
            sql.append("    FCostObjectID, FCostObjectSuiteID, FCostItemID, \n");
            if (isQtyWipType) {
                sql.append("    FQty, FBaseQty, \n");
            } else {
                sql.append("    FAmount, \n");
            }
            sql.append("    FIsInWH, \n");
            sql.append("    FSourceType, \n");
            sql.append("    FFlag, \n");
            sql.append("    FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, \n");
            sql.append("    FControlUnitID \n");
            sql.append(") \n");
            sql.append("select \n");
            sql.append("    newbosid('87CB4A7F') as FID, \n");
            sql.append("    '" + companyId + "' as FCompanyOrg, \n");
            sql.append("    '" + FCalculatePeriod + "' as FCalculatePeriod, \n");
            sql.append("    t.*, \n");
            sql.append("    1 as FIsInWH, \n");
            sql.append("    40 as FSourceType, \n");
            sql.append("    0 as FFlag, \n");
            sql.append("    '").append(FUserID).append("' as FCreatorID, \n");
            sql.append("    GetDate() as FCreateTime, \n");
            sql.append("    '").append(FUserID).append("' as FLastUpdateUserID, \n");
            sql.append("    GetDate() as FLastUpdateTime, \n");
            sql.append("    '").append(FControlUnitID).append("' as FControlUnitID \n");
            sql.append("from (\n");
            sql.append("select \n");
            sql.append("    a.FCostCenterID FCostCenterID, \n");
            sql.append("    a.FMaterialID FMaterialID, \n");
            sql.append("    a.FBatch FBatch, \n");
            sql.append("    m.FBaseUnit FUnitID, \n");
            sql.append("    a.FCostObjectID FCostObjectID, \n");
            sql.append("    a.FCostObjectSuiteID FCostObjectSuiteID, \n");
            sql.append("    a.FCostItemID FCostItemID, \n");
            if (isQtyWipType) {
                sql.append("    a.FBaseQty FQty, \n");
                sql.append("    a.FBaseQty FBaseQty \n");
            } else {
                sql.append("    a.FAmount FAmount \n");
            }
            sql.append("    from " + tempTable + " a \n");
            sql.append("    join T_BD_Material m \n");
            sql.append("    on m.FID = a.FMaterialID \n");
            sql.append(") \n");
            sql.append("as t \n");
            sql.append("where NOT EXISTS ( \n");
            sql.append("select 1 from " + this.getMainTableName(ctx, null) + " as wip \n");
            sql.append("where \n");
            sql.append("wip.FCompanyOrg = '" + companyId + "' \n");
            sql.append("and wip.FCalculatePeriod = '" + FCalculatePeriod + "' \n");
            sql.append("and t.FCostCenterID = wip.FCostCenterID \n");
            sql.append("and t.FMaterialID = wip.FMaterialID \n");
            sql.append("and (t.FBatch = wip.FBatch or (t.FBatch is null and wip.FBatch is null)) \n");
            sql.append("and \n");
            sql.append("( \n");
            sql.append("\tt.FCostObjectID = wip.FCostObjectID \n");
            sql.append("\tor \n");
            sql.append("\t( \n");
            sql.append("\t\t(t.FCostObjectID is null and wip.FCostObjectID is null) \n");
            sql.append("\t\tand \n");
            sql.append("\t\t(t.FCostObjectSuiteID = wip.FCostObjectSuiteID or (t.FCostObjectSuiteID is null and wip.FCostObjectSuiteID is null)) \n");
            sql.append("\t) \n");
            sql.append(") \n");
            sql.append("and (t.FCostItemID = wip.FCostItemID or (t.FCostItemID is null and wip.FCostItemID is null)) \n");
            sql.append(") \n");
            stmt.executeUpdate(sql.toString());
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
                SQLUtils.cleanup(stmt, conn);
                throw throwable;
            }
        }
        TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }
}

