/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app.transmission;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ncm.bill.ActualHourCollection;
import com.kingdee.eas.ncm.bill.ActualHourEntryInfo;
import com.kingdee.eas.ncm.bill.ActualHourFactory;
import com.kingdee.eas.ncm.bill.ActualHourInfo;
import com.kingdee.eas.ncm.bill.DataInputModeEnum;
import com.kingdee.eas.ncm.bill.HourTypeEnum;
import com.kingdee.eas.ncm.bill.IActualHour;
import com.kingdee.eas.ncm.bill.TimeUnitEnum;
import com.kingdee.eas.ncm.common.BillBaseStatusEnum;
import com.kingdee.eas.ncm.common.NCMCostTypeEnum;
import com.kingdee.eas.ncm.common.transmission.app.AbstractNCMDataImport;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class ActualHourDataImport
extends AbstractNCMDataImport {
    private static final String RES_CLASSNAME = "com.kingdee.eas.ncm.bill.ActualHourResource";
    CompanyOrgUnitInfo company = null;
    PeriodInfo period = null;
    private static final DateFormat DF = new SimpleDateFormat("yyyy-MM-dd");

    public int getSubmitType() {
        return 1;
    }

    public String getMainField() {
        return "number";
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return ActualHourFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Map hsDataBlock, Context ctx) throws TaskExternalException {
        ActualHourInfo actualHour = null;
        try {
            this.initOrgUnit(ctx);
            for (int i = 0; i < hsDataBlock.size(); ++i) {
                Map hsData = (Map)hsDataBlock.get(i);
                if (i == 0) {
                    actualHour = this.parseHead(hsData, ctx);
                }
                ActualHourEntryInfo entry = this.parseEntry(hsData, ctx);
                actualHour.getEntries().add(entry);
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return actualHour;
    }

    public Map exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            result.put("number", this.getNotBlankString(rs.getString("number")));
            Date bizDate = rs.getDate("bizDate");
            String sBizDate = "";
            if (bizDate != null) {
                sBizDate = DF.format(bizDate);
            }
            result.put("bizDate", this.getNotBlankString(sBizDate));
            result.put("costCenter", this.getNotBlankString(rs.getString("costCenter.number")));
            result.put("costObject", this.getNotBlankString(rs.getString("costObject.number")));
            result.put("storageOrgUnit.number", this.getNotBlankString(rs.getString("storageOrgUnit.number")));
            result.put("order.number", this.getNotBlankString(rs.getString("morder.number")));
            result.put("project.number", this.getNotBlankString(rs.getString("project.number")));
            result.put("track.number", this.getNotBlankString(rs.getString("track.number")));
            result.put("material.number", this.getNotBlankString(rs.getString("product.number")));
            result.put("material.name", this.getNotBlankString(rs.getString("product.name")));
            result.put("batch", this.getNotBlankString(rs.getString("costObject.batchNumber")));
            result.put("hourType", this.getNotBlankString(rs.getString("entries.hourType")));
            String timeUnit = rs.getString("entries.timeUnit");
            result.put("timeUnit", this.getNotBlankString(timeUnit));
            BigDecimal hour = rs.getBigDecimal("entries.hourSecond");
            if (hour != null) {
                if ("1".equals(timeUnit)) {
                    hour = hour.divide(new BigDecimal(3600), 2, 1);
                }
                if ("2".equals(timeUnit)) {
                    hour = hour.divide(new BigDecimal(60), 2, 1);
                }
                if ("3".equals(timeUnit)) {
                    hour = hour.divide(new BigDecimal(1), 2, 1);
                }
            }
            if (hour == null) {
                hour = SysConstant.BIGZERO;
            }
            result.put("hour", hour);
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private void initOrgUnit(Context ctx) throws BOSException {
        if (this.company == null) {
            this.company = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        }
        if (this.period == null) {
            try {
                this.period = NCMUtils.GetCurrentPeriod((Context)ctx, (String)this.company.getId().toString());
            }
            catch (EASBizException e) {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private ActualHourInfo parseHead(Map<Object, Object> hsData, Context ctx) throws BOSException, TaskExternalException, EASBizException {
        ActualHourInfo actualHour = new ActualHourInfo();
        actualHour.setCompanyOrg(this.company);
        actualHour.setCalculatePeriod(this.period);
        actualHour.setCostType(NCMCostTypeEnum.NORMAL);
        this.dealWithTheNumberByImpMode(ctx, hsData, actualHour);
        this.dealWithTheBizData(ctx, hsData, actualHour);
        this.dealWithTheCostCenter(ctx, hsData, actualHour);
        return actualHour;
    }

    private void dealWithTheNumberByImpMode(Context ctx, Map<Object, Object> hsData, ActualHourInfo actualHour) throws BOSException, TaskExternalException, EASBizException {
        String number;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        RuleStatus ruleStatus = iCodingRuleManager.getRuleStatus((IObjectValue)actualHour, actualHour.getCompanyOrg().getId().toString());
        if (ruleStatus.isExist()) {
            actualHour.setBillStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
            if (!this.isSltImportUpdate()) {
                return;
            }
        }
        if ((number = hsData.get("number").toString()) == null || number.length() <= 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"57_ActualHourDataImport", (Locale)ctx.getLocale()));
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        filter.getFilterItems().add(new FilterItemInfo("companyOrg", (Object)actualHour.getCompanyOrg().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("calculatePeriod", (Object)actualHour.getCalculatePeriod().getId().toString()));
        view.setFilter(filter);
        ActualHourCollection coll = ((IActualHour)this.getController(ctx)).getActualHourCollection(view);
        if (coll != null && coll.size() >= 1) {
            if (this.isSltImportUpdate()) {
                this.checkCanEdit(ctx, actualHour, coll.get(0));
                actualHour.setId(coll.get(0).getId());
            } else {
                throw new BOSException(number + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"58_ActualHourDataImport", (Locale)ctx.getLocale()));
            }
        }
        actualHour.setNumber(number);
        actualHour.setBillStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
    }

    private void dealWithTheBizData(Context ctx, Map<Object, Object> hsData, ActualHourInfo actualHour) throws BOSException {
        PeriodInfo period;
        java.util.Date bizDate;
        Object data = this.getData(hsData, "bizDate");
        if (data != null && data.toString().trim().length() > 0) {
            bizDate = this.getDateByFeildData(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"59_ActualHourDataImport", (Locale)ctx.getLocale()), data);
            period = this.getPeriodByBizDate(ctx, bizDate, this.company);
            if (this.period.getEndDate().compareTo(bizDate) < 0) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"DoNotImportLatterData", (Locale)ctx.getLocale()));
            }
        } else {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"60_ActualHourDataImport", (Locale)ctx.getLocale()));
        }
        actualHour.setBizDate(bizDate);
        actualHour.setCalculatePeriod(period);
    }

    private void checkCanEdit(Context ctx, ActualHourInfo actualHour, ActualHourInfo actualHourInfo) throws BOSException {
        if (!BillBaseStatusEnum.TEMPORARILYSAVED.equals((Object)actualHourInfo.getBillStatus())) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"61_ActualHourDataImport", (Locale)ctx.getLocale()) + actualHourInfo.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"62_ActualHourDataImport", (Locale)ctx.getLocale()));
        }
    }

    private void dealWithTheCostCenter(Context ctx, Map<Object, Object> hsData, ActualHourInfo actualHour) throws TaskExternalException {
        Object data = this.getData(hsData, "costCenter");
        String propertyLocalName = ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"63_ActualHourDataImport", (Locale)ctx.getLocale());
        String msgOfNull = ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"64_ActualHourDataImport", (Locale)ctx.getLocale());
        actualHour.setCostCenter(this.importUtil.getCostCenterOrgUnitInfoByNumber(ctx, data, propertyLocalName, msgOfNull));
        this.importUtil.checkCostCenterByActualHourInfo(ctx, actualHour);
    }

    private ActualHourEntryInfo parseEntry(Map<Object, Object> hsData, Context ctx) throws BOSException, TaskExternalException {
        ActualHourEntryInfo entry = new ActualHourEntryInfo();
        CostObjectInfo costObject = this.parseCostObject(hsData, ctx);
        entry.setCostObject(costObject);
        if (costObject == null) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"65_ActualHourDataImport", (Locale)ctx.getLocale()));
        }
        if (costObject.isIsForbiden()) {
            throw new BOSException(this.getResource(ctx, "CostObjectHasForbidCanNotImport", new Object[]{costObject.getNumber()}));
        }
        Object data = this.getData(hsData, "hour");
        if (data != null && data.toString().trim().length() > 0) {
            String timeUnit = this.getData(hsData, "timeUnit").toString();
            BigDecimal hour = this.getBigDecimalValueByFeildData(ctx, ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"66_ActualHourDataImport", (Locale)ctx.getLocale()), data);
            if (hour.compareTo(BigDecimal.valueOf(0L)) <= 0) {
                throw new BOSException(this.getResource("Hour_MUST_MORETHAN_ZERO", ctx));
            }
            hour = hour.setScale(2, 4);
            entry.setHour(hour);
            if ("1".equals(timeUnit)) {
                entry.setHourSecond(hour.multiply(new BigDecimal(3600)));
            }
            if ("2".equals(timeUnit)) {
                entry.setHourSecond(hour.multiply(new BigDecimal(60)));
            }
            if ("3".equals(timeUnit)) {
                entry.setHourSecond(hour.multiply(BigDecimal.ONE));
            }
        } else {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"67_ActualHourDataImport", (Locale)ctx.getLocale()));
        }
        data = this.getData(hsData, "hourType");
        if (data == null || data.toString().trim().length() <= 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"249_actualHourImport_checkHourType", (Locale)ctx.getLocale()));
        }
        this.checkHourType(ctx, data.toString());
        entry.setHourType(HourTypeEnum.getEnum(data.toString()));
        data = this.getData(hsData, "timeUnit");
        if (data == null || data.toString().trim().length() <= 0 || !"1".equals(data.toString()) && !"2".equals(data.toString()) && !"3".equals(data.toString())) {
            if (!(data == null || data.toString().trim().length() <= 0 || "1".equals(data.toString()) && "2".equals(data.toString()) && "3".equals(data.toString()))) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"251_actualHourImport_checkTimeUnit", (Locale)ctx.getLocale()));
            }
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"250_actualHourImport_checkTimeUnit", (Locale)ctx.getLocale()));
        }
        entry.setTimeUnit(TimeUnitEnum.getEnum(data.toString()));
        entry.setInputMode(DataInputModeEnum.IMPORT);
        return entry;
    }

    private CostObjectInfo parseCostObject(Map<Object, Object> hsData, Context ctx) throws TaskExternalException {
        String companyId = this.company.getId().toString();
        Object storageData = this.getData(hsData, "storageOrgUnit.number");
        String storageOrgUnitNumber = null;
        if (storageData != null && storageData.toString().trim().length() > 0) {
            storageOrgUnitNumber = storageData.toString().trim();
        }
        Object costObjectData = this.getData(hsData, "costObject");
        String costObjectNumber = null;
        if (costObjectData != null && costObjectData.toString().trim().length() > 0) {
            costObjectNumber = costObjectData.toString().trim();
        }
        Object orderData = this.getData(hsData, "order.number");
        String orderNumber = null;
        if (orderData != null && orderData.toString().trim().length() > 0) {
            orderNumber = orderData.toString().trim();
        }
        Object productData = this.getData(hsData, "material.number");
        String productNumber = null;
        if (productData != null && productData.toString().trim().length() > 0) {
            productNumber = productData.toString().trim();
        }
        Object batchData = this.getData(hsData, "batch");
        String batch = null;
        if (batchData != null && batchData.toString().trim().length() > 0) {
            batch = batchData.toString().trim();
        }
        if (costObjectNumber != null) {
            String propertyLocalName = this.getResource(ctx, "CostObjectNumber");
            return this.importUtil.getCostObjectInfoByNumber(ctx, (Object)costObjectNumber, companyId, propertyLocalName, null);
        }
        if (orderNumber != null) {
            return this.importUtil.getCostObjectInfoByOrder(ctx, (Object)orderNumber, storageOrgUnitNumber, batch, companyId, null);
        }
        if (productNumber != null) {
            return this.importUtil.getCostObjectInfoByMaterialNumber(ctx, (Object)productNumber, batch, companyId, null);
        }
        throw new TaskExternalException(this.getResource(ctx, "CostObjectOrderMaterialCanNotAllEmpty"));
    }

    private void checkHourType(Context ctx, String hourtype) throws BOSException {
        if (!("1".equals(hourtype) || "2".equals(hourtype) || "3".equals(hourtype) || "4".equals(hourtype) || "5".equals(hourtype) || "6".equals(hourtype) || "7".equals(hourtype) || "8".equals(hourtype) || "9".equals(hourtype))) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"261_Actualhour_checkHourType", (Locale)ctx.getLocale()));
        }
    }

    protected String getResource(Context ctx, String resName) {
        return this.getResource(ctx, resName, null);
    }

    protected String getResource(Context ctx, String resName, Object[] params) {
        if (params != null) {
            return MessageFormat.format(ResourceBase.getString((String)RES_CLASSNAME, (String)resName, (Locale)ctx.getLocale()), params);
        }
        return ResourceBase.getString((String)RES_CLASSNAME, (String)resName, (Locale)ctx.getLocale());
    }
}

