/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app.transmission;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.ncm.AUXOverheadFactory;
import com.kingdee.eas.basedata.ncm.AUXOverheadInfo;
import com.kingdee.eas.basedata.ncm.AllocStdInfo;
import com.kingdee.eas.basedata.ncm.AllocStdTypeEnum;
import com.kingdee.eas.basedata.ncm.ExpenseInfo;
import com.kingdee.eas.basedata.ncm.IAUXOverhead;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ncm.bill.AllocStdSetByAUXOverheadCollection;
import com.kingdee.eas.ncm.bill.AllocStdSetByAUXOverheadFactory;
import com.kingdee.eas.ncm.bill.AllocStdSetByAUXOverheadInfo;
import com.kingdee.eas.ncm.bill.IAllocStdSetByAUXOverhead;
import com.kingdee.eas.ncm.common.transmission.app.AbstractNCMDataImport;
import com.kingdee.eas.ncm.common.transmission.app.NCMDataImportUtil;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;

public class AllocStdSetByAUXOverheadDataImport
extends AbstractNCMDataImport {
    private CompanyOrgUnitInfo company = null;
    private CtrlUnitInfo cu = null;
    private PeriodInfo period = null;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return AllocStdSetByAUXOverheadFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsDataBlock, Context ctx) throws TaskExternalException {
        AllocStdSetByAUXOverheadInfo allocStdSetByAUXOverheadInfo = null;
        try {
            this.initOrgUnit(ctx);
            allocStdSetByAUXOverheadInfo = this.parseData(hsDataBlock, ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return allocStdSetByAUXOverheadInfo;
    }

    private AllocStdSetByAUXOverheadInfo parseData(Hashtable hsData, Context ctx) throws BOSException {
        AllocStdSetByAUXOverheadInfo allocStdSetByAUXOverheadInfo = new AllocStdSetByAUXOverheadInfo();
        allocStdSetByAUXOverheadInfo.setId(BOSUuid.create((BOSObjectType)allocStdSetByAUXOverheadInfo.getBOSType()));
        allocStdSetByAUXOverheadInfo.setCompany(this.company);
        allocStdSetByAUXOverheadInfo.setCalculatePeriod(this.period);
        Object data = this.getData(hsData, "CostCenter");
        if (data != null && data.toString().trim().length() > 0) {
            allocStdSetByAUXOverheadInfo.setCostCenter(NCMDataImportUtil.getCostCenterbyNumber((Context)ctx, (String)this.getResource("COSTCENTER_NUMBER", ctx), (String)data.toString()));
        }
        if ((data = this.getData(hsData, "AUXOverhead")) != null && data.toString().trim().length() > 0) {
            allocStdSetByAUXOverheadInfo.setAuxOverHead(NCMDataImportUtil.getAUXOverheadByNumber((Context)ctx, (String)this.getResource("AUXOVERHEAD_NUMBER", ctx), (String)data.toString()));
        }
        if ((data = this.getData(hsData, "AllocStd")) != null && data.toString().trim().length() > 0) {
            allocStdSetByAUXOverheadInfo.setAllocStd(NCMDataImportUtil.getAllocStdByNumber((Context)ctx, (String)this.getResource("AllOCSTD_NUMBER", ctx), (String)data.toString()));
        }
        this.checkData(ctx, allocStdSetByAUXOverheadInfo);
        return allocStdSetByAUXOverheadInfo;
    }

    private void initOrgUnit(Context ctx) throws BOSException {
        if (this.cu == null || this.company == null) {
            IContextHelper context = ContextHelperFactory.getLocalInstance((Context)ctx);
            if (this.cu == null) {
                this.cu = context.getCurrentCtrlUnit();
            }
            if (this.company == null) {
                this.company = context.getCurrentCompany();
            }
            if (this.period == null) {
                try {
                    this.period = NCMUtils.GetCurrentPeriod((Context)ctx, (String)this.company.getId().toString());
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        AllocStdSetByAUXOverheadInfo allocStdSetByAUXOverheadInfo = null;
        if (coreBaseInfo instanceof AllocStdSetByAUXOverheadInfo) {
            allocStdSetByAUXOverheadInfo = (AllocStdSetByAUXOverheadInfo)coreBaseInfo;
        }
        if (allocStdSetByAUXOverheadInfo == null) {
            return;
        }
        ArrayList<CoreBaseInfo> addObjList = new ArrayList<CoreBaseInfo>();
        HashMap<String, String> updateObjects = new HashMap<String, String>();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.company.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("calculatePeriod.id", (Object)this.period.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("costCenter.id", (Object)allocStdSetByAUXOverheadInfo.getCostCenter().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("auxOverHead.id", (Object)allocStdSetByAUXOverheadInfo.getAuxOverHead().getId().toString()));
        EntityViewInfo eviData = new EntityViewInfo();
        eviData.setFilter(filter);
        try {
            IAllocStdSetByAUXOverhead coreBase = (IAllocStdSetByAUXOverhead)this.getController(ctx);
            AllocStdSetByAUXOverheadCollection collection = coreBase.getAllocStdSetByAUXOverheadCollection(eviData);
            String allocStdInfo = "";
            if (allocStdSetByAUXOverheadInfo.getAllocStd() != null) {
                allocStdInfo = allocStdSetByAUXOverheadInfo.getAllocStd().getId().toString();
            }
            if (collection.size() != 0 && this.isSltImportUpdate()) {
                AllocStdSetByAUXOverheadInfo Info = collection.get(0);
                updateObjects.put(Info.getId().toString(), allocStdInfo);
            } else if (!this.isSltImportUpdate()) {
                addObjList.add(coreBaseInfo);
            } else if (collection.size() == 0 && this.isSltImportUpdate()) {
                addObjList.add(coreBaseInfo);
            }
            coreBase.updateAllocStdSetting(updateObjects, new ArrayList(), addObjList);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            String allocStd = "";
            String allocStdName = "";
            if (rs.getString("AllocStd.number") != null) {
                allocStd = rs.getString("AllocStd.number");
            }
            if (rs.getString("AllocStd.name") != null) {
                allocStdName = rs.getString("AllocStd.name");
            }
            result.put("CostCenter", rs.getString("CostCenter.number"));
            result.put("CostCenterName", rs.getString("CostCenter.name"));
            result.put("AUXOverhead", rs.getString("AUXOverhead.number"));
            result.put("AUXOverheadName", rs.getString("AUXOverhead.name"));
            result.put("AllocStd", allocStd);
            result.put("AllocStdName", allocStdName);
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private void checkData(Context ctx, AllocStdSetByAUXOverheadInfo allocStdSetByAUXOverheadInfo) throws BOSException {
        this.checkCostCenter(ctx, allocStdSetByAUXOverheadInfo);
        this.checkAUXOverhead(ctx, allocStdSetByAUXOverheadInfo);
        this.checkAllocStd(ctx, allocStdSetByAUXOverheadInfo);
    }

    private void checkCostCenter(Context ctx, AllocStdSetByAUXOverheadInfo allocStdSetByAUXOverheadInfo) throws BOSException {
        CostCenterOrgUnitInfo costCenterInfo = allocStdSetByAUXOverheadInfo.getCostCenter();
        if (costCenterInfo == null) {
            throw new BOSException(this.getResource("COSTCENTER_NUMBER_CANNOT_EMPTY", ctx));
        }
        if (costCenterInfo.isIsSealUp()) {
            throw new BOSException(this.getResource("COSTCENTER_ISSEALUP_PART1", ctx) + costCenterInfo.getNumber() + this.getResource("COSTCENTER_ISSEALUP_PART2", ctx));
        }
        NCMDataImportUtil.isCostCenterDelegateCurCompany((Context)ctx, (String)costCenterInfo.getId().toString(), (String)costCenterInfo.getNumber(), (String)this.company.getId().toString());
    }

    private void checkAUXOverhead(Context ctx, AllocStdSetByAUXOverheadInfo allocStdSetByAUXOverheadInfo) throws BOSException {
        ExpenseInfo expenseInfo;
        AUXOverheadInfo auxOverheadInfo = allocStdSetByAUXOverheadInfo.getAuxOverHead();
        if (auxOverheadInfo == null) {
            throw new BOSException(this.getResource("AUXOVERHEAD_CANNOT_EMPTY", ctx));
        }
        IAUXOverhead biz = AUXOverheadFactory.getLocalInstance((Context)ctx);
        try {
            expenseInfo = (ExpenseInfo)biz.getDefualtExpense((Object)auxOverheadInfo);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        if (expenseInfo == null) {
            throw new BOSException(auxOverheadInfo.getNumber() + this.getResource("AUXOVERHEAD_ISHAVINGEXPENSE", ctx));
        }
        NCMDataImportUtil.checkDataBaseDPermission((Context)ctx, (String)this.cu.getId().toString(), (String)auxOverheadInfo.getCU().getId().toString(), (String)"8CB367E7", (String)auxOverheadInfo.getId().toString(), (String)auxOverheadInfo.getNumber(), (String)this.getResource("AUXOVERHEAD_NUMBER", ctx));
    }

    private void checkAllocStd(Context ctx, AllocStdSetByAUXOverheadInfo allocStdSetByAUXOverheadInfo) throws BOSException {
        AllocStdInfo allocStdInfo = allocStdSetByAUXOverheadInfo.getAllocStd();
        if (allocStdInfo == null) {
            return;
        }
        AllocStdTypeEnum allocStdType = allocStdInfo.getAllocStdType();
        if (!allocStdType.equals((Object)AllocStdTypeEnum.AUX) && !allocStdType.equals((Object)AllocStdTypeEnum.INNERPRD)) {
            throw new BOSException(allocStdInfo.getNumber() + this.getResource("ALLOCSTD_CHECK_BY_AUXOVERHEAD", ctx));
        }
    }
}

